export function useAddBankAccount() {
    const theme = useState('theme');
    const backAccountForm = useState('backAccountForm', () => 'hide');
    const createFormBox = ref<Component | any>(null);
    const cartNumber = ref<string | null>(null);
    const cartNumberInfo = ref<Record<string, string> | null>(null);
    const verifyForm = ref<Component | any>(null);
    const user = useState<Record<string, string>>('user');

    const checkLength = (value: string, label: string) => {
        if (value.toString().replaceAll('-', '').trim().length !== 16) {
            return `${label} باید شامل 16 رقم باشد`;
        }
        return true;
    };

    const checkResult = (response: { data: Record<string, any> }) => {
        if (response.data.status == 'ok') {
            cartNumberInfo.value = response.data;
        }
    };

    const verifyResult = (response: { data: Record<string, string> }) => {
        if (response.data.status == 'ok') {
            user.value['money-returning-methods'] = response.data.method;
            createFormBox.value!.hide();
        }
    };

    const afterClose = () => {
        backAccountForm.value = 'hide';
    };

    watch(
        () => backAccountForm.value,
        () => {
            if (backAccountForm.value == 'show') {
                cartNumberInfo.value = null;
                createFormBox.value!.show();
            }
        }
    );

    return {
        cartNumber,
        cartNumberInfo,
        checkLength,
        checkResult,
        verifyResult,
        afterClose,
        verifyForm,
        createFormBox,
        theme
    };
}
