export  function useCategoriesPage(){

    const categories=useState<Record<string, any>[]|null>('categories');
    const selectedMainCategoryId=ref<string|null>(null);
    const selectedChildCategoryId=ref<string|null>(null);
    const theme=useState<string>('theme');

    const getCategories=function (parentId:string){
        return categories.value!.filter((category)=>category.parent_id==parentId);
    }

    const getCategory=function (id:string){
        return categories.value!.find((category)=>category.id==id);
    }

    const showOrHideChildCategoriesBox=(id:string)=>{
        if(selectedChildCategoryId.value==id){
            selectedChildCategoryId.value=null;
        }
        else{
            selectedChildCategoryId.value=id;
        }
    }

    onMounted(()=>{
        if(theme.value=='desktop'){
            navigateTo('/');
        }
        if(categories.value!=null && categories.value.length>0){
            selectedMainCategoryId.value=categories.value[0].id;
            const childs=getCategories(selectedMainCategoryId.value!);
            if(childs.length>0){
                selectedChildCategoryId.value=childs[0].id;
            }
        }
    });

    watch(()=>categories.value,()=>{
        if(categories.value!=null && categories.value.length>0 &&
            selectedMainCategoryId.value==null){
            selectedMainCategoryId.value=categories.value[0].id;
        }
    })

    return {
        categories,
        selectedMainCategoryId,
        selectedChildCategoryId,
        theme,
        getCategory,
        getCategories,
        showOrHideChildCategoriesBox
    }
}