import  {searchStore} from "~/stores/search-products";

export function useFilterProduct(){

    const store=searchStore();

    const addOrRemoveFilter=(param:string,status:boolean)=>{
        const [filterId, itemId] = param.split('-');
        if (filterId && itemId) {
            const queries={...store.queries,...{}} as Record<string, any>;
            const key = `attributes_${filterId}`;
            queries[key] = store.queries[key] || {};
            if (status) {
                queries[key][itemId] = status;
            }
            else {
                delete queries[key][itemId];
                if (Object.keys(queries[key]).length === 0) {
                    delete queries[key];
                }
            }
            store.updateQueries(queries);
        }
    }

    return {
        addOrRemoveFilter,
        store
    };
}