import { ref } from 'vue'
import Modal from '@/components/Modal.vue'
import Offcanvas from '@/components/Offcanvas.vue'
import { productStore } from '@/stores/product'

const useReportWrongForm = () => {
    const successMessage = ref<string | null>(null)
    const description = ref<string | null>(null)
    const selectedItems = ref<Record<number, boolean>>({})
    const formBox = ref<InstanceType<typeof Modal> | InstanceType<typeof Offcanvas> | null>(null)

    const productState = productStore()
    const theme = useState('theme')
    const shopSetting = useState<Record<string, string>>('shopSetting')

    const items = {
        title: 'نام کالا نادرست است',
        image: 'تصویر کالا نادرست است',
        description: 'توضیحات کالا نادرست است',
        fake: 'کالای غیر اصل',
        specifications: 'مشخصات کالا نادرست است',
        repetitious: 'کالای تکراری',
    }

    const completionData=(data:Record<string, any>)=>{
        data['items']=Object.keys(selectedItems.value).toString();
        return  data;
    }

    const result = () => {
        description.value='';
        selectedItems.value={};
        successMessage.value='ثبت گزارش با موفقیت انجام شد';
        setTimeout(()=>{
            successMessage.value=null;
        },3000);
    }

    return {
        completionData,
        successMessage,
        description,
        selectedItems,
        formBox,
        productState,
        theme,
        shopSetting,
        items,
        result,
        Modal,
        Offcanvas,
    }
}

export default useReportWrongForm
