import { useValidate } from '~/composables/validate';

export function useTextInput(
    props: Record<string, any>, model: Ref<any>, realValue: Ref<any>
) {
    const passwordIcon = ref<'eye' | 'eye-slash'>('eye');
    const inputType = ref<string>(props.type || 'input');

    const { error,isValid, inputKeyUp, validateInput } = useValidate(props, model);
    const addRule = inject('addRule') as (fun:()=>string|boolean)=>void;
    const global = useNuxtApp().vueApp.config.globalProperties;

    const validate = () => {
        return validateInput();
    };

    const checkKeyDown = ($event: KeyboardEvent) => {
        if (props.type === 'number') {
            const n = $event.key;
            if (n !== 'Backspace' && isNaN(Number(n)) && n !== '.' && n !== '-') {
                $event.preventDefault();
            }
        }
    };

    const getFormatedValue = (value: any) => {
        if (props.separator) {
            return global.$replaceEnNumber(
                global.$numberFormat(
                    value.toString().replace(new RegExp(props.separator, 'g'), ''),
                    props.separator,
                    props.digit
                )
            );
        }
        return value;
    };

    const getRealValue = (value: any) => {
        if (value || value === 0) {
            return global.$replaceFaNumber(
                value.toString().replace(new RegExp(props.separator, 'g'), '')
            );
        }
        return 0;
    };

    const changePasswordInputType = () => {
        inputType.value = inputType.value === 'password' ? 'text' : 'password';
        passwordIcon.value = inputType.value === 'password' ? 'eye-slash' : 'eye';
    };

    onMounted(() => {
        if (addRule)
            addRule(validate);
        if (realValue.value) {
            model.value = getFormatedValue(realValue.value);
        }
        if(model.value){
            validateInput();
        }
    });

    watch(() => realValue.value, () => {
        model.value = getFormatedValue(parseInt(realValue.value));
    });

    watch(() => model.value, (newValue) => {
        if (
            props.type === 'number' &&
            newValue !== getFormatedValue(model.value)
        ) {
            realValue.value = getRealValue(model.value);
            model.value = getFormatedValue(model.value);
        }
    });

    return {
        error,
        inputKeyUp,
        validate,
        checkKeyDown,
        getFormatedValue,
        getRealValue,
        changePasswordInputType,
        isValid,
        passwordIcon,
        inputType
    };
}
