import AmountColumn from "~/components/wallet/table/AmountColumn.vue";

export function useWalletHistory(){
    const theme=useState('theme');
    const histories=ref({data:[]});
    const global=useNuxtApp().vueApp.config.globalProperties;
    onMounted(()=>{
        getWalletHistories();
    });
    const columns:Record<string, any>[]=[
        {
            title:'مبلغ',
            value:'amount',
            component:AmountColumn
        },
        {
            title: "توضیحات",
            value:'description',
        },
        {
            title: "زمان ثبت",
            type:'time',
            value:'created_at'
        },
        {
            title:'وضعیت',
            type:'status',
            value:(data:{status:number})=>{
                if(data.status==0){
                    return {title:'در انتظار پرداخت',className:'warning'}
                }
                else if(data.status==1){
                    return {title:'تایید شده',className:'green'}
                }
                else{
                    return {title:'لغو شده',className:'danger'}
                }
            }
        },
    ];

    const getWalletHistories=(page=1)=>{
        useNuxtApp().$axios.get(
            useRuntimeConfig().public.api+'/wallet/history?page='+page
        ).then((response)=>{
            histories.value=response.data;
        });
    }

    return {
        theme,
        histories,
        columns,
        getWalletHistories
    }
}