export  default function(store:{[p:string]:any}){

    const title=ref('فیلترها');
    const showAllFilters=ref(true);
    const filterBoxRef=shallowRef<any>(null);
    const optionRefBox=shallowRef<any>(null);
    const selectedFilter=ref<{[p:string]:any}|null>(null);
    const selectedFilters=ref<{[p:string]:boolean}>({});
    const selectedOption=ref<{[p:string]:any}>();

    const showOrHideChildBox=(filter:{[p:string]:any})=>{
        selectedFilter.value=filter;
        title.value=selectedFilter.value.name;
    }

    const addOrRemoveFilter=(param:string,status:boolean)=>{
        const [filterId, itemId] = param.split('-');
        if (filterId && itemId) {
            const key = `attributes_${filterId}`;
            store.queries[key] = store.queries[key] || {};
            if (status) {
                store.queries[key][itemId] = status;
            } else {
                delete store.queries[key][itemId];
                if (Object.keys(store.queries[key]).length === 0) {
                    delete store.queries[key];
                }
            }
        }
    }

    const showMainFiltersList=()=>{
        selectedFilter.value=null;
        title.value='فیلترها';
    }

    const showFilterBox=(filter:{[p:string]:any}|undefined)=>{
        selectedFilter.value=filter ?? null;
        filterBoxRef.value!.show();
        showAllFilters.value=filter==undefined;
        if(filter){
            title.value=filter.name;
        }
    }

    const showOption=(option:{[p:string]:any})=>{
        if(option.child==false){
            if(store.queries[option.param]){
                delete store.queries[option.param];
            }
            else{
                store.queries={...store.queries, ...{[option.param]:true}}
            }
        }
        else{
            title.value=option.title;
            selectedOption.value=option;
            optionRefBox.value.show();
        }
    }

    const removeFilterWithParam=(param:string)=>{
        delete store.queries[param];
        optionRefBox.value.hide();
    }

    const removeAllFilters=()=>{
        store.queries={};
        filterBoxRef.value.hide();
    }

    return {
        title,
        showAllFilters,
        filterBoxRef,
        selectedFilter,
        selectedFilters,
        optionRefBox,
        selectedOption,
        removeAllFilters,
        removeFilterWithParam,
        showOrHideChildBox,
        addOrRemoveFilter,
        showMainFiltersList,
        showFilterBox,
        showOption
    }
}