import {navigateTo, useState} from "nuxt/app";
export default defineNuxtRouteMiddleware(async (to,from)=>{
    if(process.client){
        const {$axios}=useNuxtApp();
        const user=useState('user');
        if(user.value==null || user.value==='loading'){
            try{
                const response=await $axios.get(useRuntimeConfig().public.api+'/user');
                user.value=response.data;
            }
            catch (e){
                return navigateTo('/login');
            }
        }
    }
});