/**
 * 主程序, 不包含手势,
 * 主要用来适配Mouse/Touch事件
 * ==================== 参考 ====================
 * https://segmentfault.com/a/1190000010511484#articleHeader0
 * https://segmentfault.com/a/1190000007448808#articleHeader1
 * hammer.js http://hammerjs.github.io/
 * ==================== 流程 ====================
 * Event(Mouse|Touch) => BaseInput => Input => Computed => AnyTouchEvent
 */
import AnyEvent from 'any-event';
import type { SupportElement } from 'any-touch';
import type { UnionToIntersection, Computed, NativeEvent, ComputeFunctionCreator, PluginContext, Plugin, Input } from '@any-touch/shared';
export { AnyTouchEvent } from '@any-touch/shared';
export interface Options {
    domEvents?: false | EventInit;
    preventDefault?: boolean | ((e: NativeEvent) => boolean);
}
declare type GetPluginContext<N> = N extends keyof PluginContextMap ? PluginContextMap[N] : (PluginContext | undefined);
/**
 * 默认的事件名和事件对象映射
 */
export interface EventMap {
    input: Input;
    computed: Record<string, any>;
    u: undefined;
    'at:after': Computed;
    'at:start': Input;
    'at:move': Input;
    'at:cancel': Input;
    'at:end': Input;
}
/**
 * 插件映射
 * {名称: 插件实例}
 * @example
 * {tap:TapContext}
 */
export interface PluginContextMap {
}
/**
 * 手势库的核心,
 * 本身不具备手势识别,
 * 需要加载识别器插件.
 * @example
 * import Core from '@any-touch/core';
 * import pan from '@any-touch/pan';
 * const at = new Core();
 * at.use(pan);
 */
export default class extends AnyEvent<EventMap> {
    /**
     * 版本
     */
    v: string;
    /**
     * 当前绑定元素
     */
    el?: SupportElement;
    /**
     * 当前插件(仅供插件开发者使用)
     */
    c?: PluginContext;
    private __options;
    private __inputCreatorMap;
    private __computeFunctionList;
    private __computeFunctionCreatorList;
    private __pluginContexts;
    private __isIgnoreMouse;
    /**
     * @param el 目标元素, 微信下没有el
     * @param options 选项
     */
    constructor(el?: SupportElement, options?: Options);
    /**
     * 加载并初始化插件
     * @param plugin 插件
     * @param pluginOptions 插件选项
     */
    use<P extends Plugin>(plugin: P, pluginOptions?: Parameters<P>[1]): void;
    /**
     * 监听input变化
     * @param event Touch / Mouse事件对象
     */
    catchEvent(event: NativeEvent): void;
    /**
     * 缓存计算函数生成器到队列
     * @param computeFunctionCreatorList 一组计算函数生成器
     */
    compute<CList extends ComputeFunctionCreator[] = ComputeFunctionCreator[]>(computeFunctionCreatorList: CList, callback: (computed: UnionToIntersection<ReturnType<ReturnType<CList[0]>>> & Input) => void): void;
    /**
     * 拦截器
     * 可以控制事件的触发
     * @param interceptor 拦截函数
     */
    beforeEach(interceptor: (type: string, next: () => void) => void): void;
    /**
     * 获取识别器通过名字
     * @param name 识别器的名字
     * @return 返回识别器
     */
    get<N extends keyof PluginContextMap>(name: N): GetPluginContext<N>;
    /**
     * 设置选项
     * @param newOptions 选项
     */
    set(newOptions: Partial<Options>): void;
    /**
     * 带DOM事件的emit(仅供插件开发者使用)
     * @param type 事件类型
     * @param payload 数据
     * @param pluginContext 插件实例
     */
    emit2(type: string, payload: Computed, pluginContext: PluginContext): void;
    /**
     * 销毁
     */
    destroy(): void;
}
