import type { PluginContext, AnyTouchEvent } from '@any-touch/shared';
import Core from '@any-touch/core';
declare const DEFAULT_OPTIONS: {
    name: string;
    threshold: number;
    pointLength: number;
};
/**
 * 实例
 */
export declare type PanContext = PluginContext & typeof DEFAULT_OPTIONS;
/**
 * 扩展插件映射
 */
declare module '@any-touch/core' {
    interface PluginContextMap {
        pan: PanContext;
    }
    interface EventMap {
        pan: AnyTouchEvent;
        panstart: AnyTouchEvent;
        panmove: AnyTouchEvent;
        panend: AnyTouchEvent;
        pancancel: AnyTouchEvent;
        panup: AnyTouchEvent;
        pandown: AnyTouchEvent;
        panright: AnyTouchEvent;
        panleft: AnyTouchEvent;
    }
}
/**
 * "拖拽"识别器
 * @param at AnyTouch实例
 * @param options 识别器选项
 * @returns  识别器实例
 */
export default function (at: Core, options?: Partial<typeof DEFAULT_OPTIONS>): PanContext;
export {};
