import { RECOGNIZER_STATE } from './index';
import { PluginContext } from './types';
/**
 * 获取状态字符串
 * @param code 状态代码
 * @returns
 */
export declare function getStatusName(code: RECOGNIZER_STATE): "end" | "start" | "cancel" | "move";
/**
 * 😊如果当前识别成功,
 * 那么计算当前识别器状态.
 * 逻辑: 是否test通过 + 上一轮识别器状态 + 输入阶段 => 当前识别器状态
 * @param isVaild 是否通过test
 * @param lastStatus 上一轮识别器状态
 * @param phase 输入阶段
 * @returns 识别器状态
 */
export declare function flow(isVaild: boolean, lastStatus: RECOGNIZER_STATE, phase: string): RECOGNIZER_STATE;
/**
 * 重置状态到possible
 * @param context 识别器实例
 */
export declare function resetState(context: PluginContext): void;
/**
 * 是否事件的结束
 * @param state
 * @returns 是否
 */
export declare function isMoveOrEndOrCancel(state: RECOGNIZER_STATE): boolean;
/**
 * 判断是否禁止识别
 * @param context 识别器实例
 * @returns 是否禁止识别
 */
export declare function isDisabled(context: PluginContext): boolean;
