import Core from '@any-touch/core';
import { STATE } from './const';
export declare type KV = Record<string, any>;
/**
 * 适配器支持的事件类型
 */
export declare type NativeEvent = MouseEvent | TouchEvent;
export interface PointClientXY {
    target: EventTarget | null;
    clientX: number;
    clientY: number;
}
/**
 * 输入阶段
 */
export declare type phase = 'start' | 'move' | 'end' | 'cancel';
/**
 * 原生事件上选取的共有字段
 */
export interface PubicEvent {
    readonly phase: phase;
    readonly changedPoints: PointClientXY[];
    readonly points: PointClientXY[];
    readonly target: EventTarget | null;
    readonly targets: (EventTarget | null)[];
    readonly nativeEvent: Event;
}
/**
 * 不包含prevInput/startInput/startMultiInput的Input
 */
export interface InputOnlyHasCurrent extends PubicEvent {
    readonly id: number;
    readonly isStart: boolean;
    readonly isEnd: boolean;
    readonly pointLength: number;
    readonly timestamp: number;
    readonly target: EventTarget | null;
    readonly currentTarget: EventTarget | null;
    readonly center?: Point;
    readonly x: number;
    readonly y: number;
    readonly getOffset: (el: HTMLElement) => {
        x: number;
        y: number;
    };
}
/**
 * 提供给插件(compute函数)之前的统一化数据
 */
export interface Input extends InputOnlyHasCurrent {
    readonly startInput: InputOnlyHasCurrent;
    readonly startMultiInput?: InputOnlyHasCurrent;
    readonly prevInput?: InputOnlyHasCurrent;
}
/**
 * 方向
 */
export declare type directionString = 'up' | 'right' | 'down' | 'left' | 'none';
/**
 * 点
 */
export interface Point {
    x: number;
    y: number;
}
export declare type Vector = Point;
/**
 * Input执行计算后的数据格式
 */
export interface Computed extends KV {
    readonly maxPointLength?: number;
    readonly velocityX?: number;
    readonly velocityY?: number;
    readonly speedX?: number;
    readonly speedY?: number;
    readonly scale?: number;
    readonly deltaScale?: number;
    readonly angle?: number;
    readonly deltaAngle?: number;
    readonly deltaX?: number;
    readonly deltaY?: number;
    readonly deltaXYAngle?: number;
    readonly displacementX?: number;
    readonly displacementY?: number;
    readonly distanceX?: number;
    readonly distanceY?: number;
    readonly distance?: number;
    readonly deltaTime?: number;
    readonly overallDirection?: directionString;
    readonly direction?: directionString;
    readonly startVecotr?: Vector;
    readonly prevVecotr?: Vector;
    readonly activeVecotr?: Vector;
}
export interface AnyTouchEvent extends Input, Required<Computed> {
    readonly type: string;
    readonly stopPropagation: () => void;
    readonly stopImmediatePropagation: () => void;
    readonly preventDefault: () => void;
}
/**
 * 识别器状态
 */
export declare type RECOGNIZER_STATE = STATE;
/**
 * Input转换器
 */
export interface InputCreatorFunction<T> {
    (event: T): void | Input;
}
/**
 * Input转换器外壳函数映射
 */
export interface InputCreatorFunctionMap {
    [k: string]: InputCreatorFunction<NativeEvent>;
}
export declare type PluginOptions = {
    name?: string;
} & KV;
/**
 * 插件上下文内容
 */
export declare type PluginContext<D extends Required<PluginOptions> = Required<PluginOptions>> = {
    state: RECOGNIZER_STATE;
    disabled: boolean;
} & D;
/**
 * 插件
 */
export declare type Plugin = (context: Core, pluginOptions?: PluginOptions) => PluginContext;
/**
 * 计算函数
 */
export declare type ComputeFunction = (input: Input, computed: Partial<Computed>) => Computed | void;
/**
 * 计算函数生成器
 */
export declare type ComputeFunctionCreator = () => ComputeFunction;
/**
 * 仅用来作为识别器和at通知的载体函数
 */
export interface EventTrigger {
    (type: string): void;
}
import tap from '@any-touch/tap';
import press from '@any-touch/press';
import swipe from '@any-touch/swipe';
import pan from '@any-touch/pan';
import pinch from '@any-touch/pinch';
import rotate from '@any-touch/rotate';
export declare type TapContext = ReturnType<typeof tap>;
export declare type PressContext = ReturnType<typeof press>;
export declare type SwipeContext = ReturnType<typeof swipe>;
export declare type PanContext = ReturnType<typeof pan>;
export declare type PinchContext = ReturnType<typeof pinch>;
export declare type RotateContext = ReturnType<typeof rotate>;
/**
 * 插件实例映射
 * {名称: 插件实例}
 */
export interface PluginContextMap {
    tap: TapContext;
    press: PressContext;
    swipe: SwipeContext;
    pan: PanContext;
    pinch: PinchContext;
    rotate: RotateContext;
}
export declare type UnionToIntersection<U> = (U extends any ? (k: U) => void : never) extends ((k: infer I) => void) ? I : never;
