import process from 'node:process';
import { fileURLToPath } from 'node:url';
import { defineCommand } from 'citty';
import { createJiti } from 'jiti';
import { resolve } from 'pathe';
import { isBun } from 'std-env';
import { x } from 'tinyexec';
import { l as loadKit } from '../shared/cli.DlcAx0De.mjs';
import { b as legacyRootDirArgs, d as dotEnvArgs, l as logLevelArgs, c as cwdArgs } from '../shared/cli.CyjRwZnH.mjs';
import 'node:path';
import 'consola';

const typecheck = defineCommand({
  meta: {
    name: "typecheck",
    description: "Runs `vue-tsc` to check types throughout your app."
  },
  args: {
    ...cwdArgs,
    ...logLevelArgs,
    ...dotEnvArgs,
    ...legacyRootDirArgs
  },
  async run(ctx) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir);
    const { loadNuxt, buildNuxt, writeTypes } = await loadKit(cwd);
    const nuxt = await loadNuxt({
      cwd,
      dotenv: { cwd, fileName: ctx.args.dotenv },
      overrides: {
        _prepare: true,
        logLevel: ctx.args.logLevel
      }
    });
    await writeTypes(nuxt);
    await buildNuxt(nuxt);
    await nuxt.close();
    const jiti = createJiti(cwd);
    const [resolvedTypeScript, resolvedVueTsc] = await Promise.all([
      jiti.esmResolve("typescript", { try: true }),
      jiti.esmResolve("vue-tsc/bin/vue-tsc.js", { try: true })
    ]);
    if (resolvedTypeScript && resolvedVueTsc) {
      await x(fileURLToPath(resolvedVueTsc), ["--noEmit"], {
        throwOnError: true,
        nodeOptions: {
          stdio: "inherit",
          cwd
        }
      });
    } else {
      if (isBun) {
        await x(
          "bun",
          "install typescript vue-tsc --global --silent".split(" "),
          {
            throwOnError: true,
            nodeOptions: { stdio: "inherit", cwd }
          }
        );
        await x("bunx", "vue-tsc --noEmit".split(" "), {
          throwOnError: true,
          nodeOptions: {
            stdio: "inherit",
            cwd
          }
        });
      } else {
        await x(
          "npx",
          "-p vue-tsc -p typescript vue-tsc --noEmit".split(" "),
          {
            throwOnError: true,
            nodeOptions: { stdio: "inherit", cwd }
          }
        );
      }
    }
  }
});

export { typecheck as default };
