'use strict';

const utils = require('consola/utils');
const consola = require('consola');
const stdEnv = require('std-env');
const isDocker = require('is-docker');
const rc = require('rc9');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e.default : e; }

const isDocker__default = /*#__PURE__*/_interopDefaultCompat(isDocker);

const version = "2.6.6";

const consentVersion = 1;

function updateUserNuxtRc(key, val) {
  rc.updateUser({ [key]: val }, ".nuxtrc");
}

async function ensureUserconsent(options) {
  if (options.consent && options.consent >= consentVersion) {
    return true;
  }
  if (stdEnv.isMinimal || process.env.CODESANDBOX_SSE || process.env.NEXT_TELEMETRY_DISABLED || isDocker__default()) {
    return false;
  }
  consola.consola.restoreAll();
  process.stdout.write("\n");
  consola.consola.info(`${utils.colors.green("Nuxt")} collects completely anonymous data about usage.
  This will help us improve Nuxt developer experience over time.
  Read more on ${utils.colors.underline(utils.colors.cyan("https://github.com/nuxt/telemetry"))}
`);
  const accepted = await consola.consola.prompt("Are you interested in participating?", {
    type: "confirm"
  });
  process.stdout.write("\n");
  consola.consola.wrapAll();
  if (accepted) {
    updateUserNuxtRc("telemetry.consent", consentVersion);
    updateUserNuxtRc("telemetry.enabled", true);
    return true;
  }
  updateUserNuxtRc("telemetry.enabled", false);
  return false;
}

exports.consentVersion = consentVersion;
exports.ensureUserconsent = ensureUserconsent;
exports.updateUserNuxtRc = updateUserNuxtRc;
exports.version = version;
