export const useLMarkerCluster = async (props) => {
  const L = window.L;
  const { MarkerClusterGroup } = await import("leaflet.markercluster");
  const markerCluster = new MarkerClusterGroup(props.options);
  const markers = [];
  props.markers.forEach((location) => {
    const marker = L.marker([location.lat, location.lng], {
      title: location.name,
      ...location.options
    });
    if (location.popup) {
      const popup = L.DomUtil.create("div", "popup");
      popup.innerHTML = location.popup;
      marker.bindPopup(popup);
    }
    markerCluster.addLayer(marker);
    markers.push(marker);
  });
  props.leafletObject.addLayer(markerCluster);
  return {
    markerCluster,
    markers
  };
};
