export interface DefaultTypeAndEventMap {
    [type: string]: any;
}
export interface AEventListener<Event, Key> {
    (event: Event, key: Key): void;
}
export interface Interceptor {
    (type: string | number | symbol, next: () => void): void;
}
export default class AnyEvent<TypeAndEventMap extends DefaultTypeAndEventMap = DefaultTypeAndEventMap> {
    private __map;
    private __interceptor?;
    /**
     * 当前事件对象
     */
    event: unknown;
    /**
     * 注册拦截器
     * @param interceptor 拦截器
     */
    beforeEach(interceptor: Interceptor): void;
    /**
     * 绑定事件
     * @param typeOrTypes 事件名
     * @param listener 回调函数
     */
    on<Key extends keyof TypeAndEventMap>(typeOrTypes: Key | Key[], listener: AEventListener<TypeAndEventMap[Key], Key>): this;
    /**
     * 按照监听器注册的顺序，同步地调用每个注册到名为 eventName 的事件的监听器，并传入提供的参数。
     * @param type 事件名
     * @param payload 数据
     * @param done 运行成功执行
     */
    emit<Key extends keyof TypeAndEventMap>(type: Key, payload?: TypeAndEventMap[Key], callback?: () => void): void;
    private __emit;
    /**
     * 解除绑定,
     * 如果不指定listener,
     * 那么解除所有eventName对应回调
     * @param type 事件名
     * @param listener 回调函数
     */
    off<Key extends keyof TypeAndEventMap>(type: Key, listener?: AEventListener<TypeAndEventMap[Key], Key>): void;
    /**
     * 销毁实例
     */
    destroy(): void;
}
