import { defineNuxtModule, createResolver, addPlugin, addImportsDir } from '@nuxt/kit';

const name = "nuxt-swiper";
const version = "2.0.1";

const module = defineNuxtModule({
  meta: {
    name,
    version,
    configKey: "swiper"
  },
  defaults: {
    enableComposables: true,
    bundled: true
  },
  setup(opts, nuxt) {
    const resolver = createResolver(import.meta.url);
    nuxt.options.appConfig = {
      ...nuxt.options.appConfig,
      __swiper: {
        bundled: opts?.bundled ?? true
      }
    };
    const isCustomElement = nuxt.options.vue.compilerOptions.isCustomElement;
    nuxt.options.vue.compilerOptions.isCustomElement = (tag) => tag.startsWith("swiper-") || isCustomElement?.(tag) || false;
    if (nuxt.options.vue.runtimeCompiler)
      addPlugin(resolver.resolve("./runtime/plugins/custom-elements"));
    if (opts.enableComposables)
      addImportsDir(resolver.resolve("./runtime/composables"));
    addPlugin(resolver.resolve("./runtime/plugins/components.client"));
    nuxt.hook("prepare:types", ({ references }) => {
      references.push({
        path: resolver.resolve("./runtime/components.d.ts")
      });
    });
  }
});

export { module as default };
