import type { SwiperContainer } from 'swiper/element';
import type { Swiper } from 'swiper/types';
import type { Ref } from 'vue';
/**
 * A Vue composable that provides a reactive interface to the Swiper slider instance.
 * This utility function allows you to directly access and control the Swiper instance
 * and provides reactive state properties for common Swiper values.
 *
 * @param swiperContainerRef - Ref to the `<swiper-container>` element that will be controlled.
 * @param options - Optional Swiper configuration parameters to merge with the default options.
 *                  These options will be applied if the Swiper instance is not yet created.
 *                  See Swiper documentation for all available options: https://swiperjs.com/swiper-api
 *
 * @returns An object containing:
 *  - `instance`: Ref to the Swiper instance
 *  - Reactive state properties: `isBeginning`, `isEnd`, `activeIndex`, `realIndex`, etc.
 *  - Navigation methods: `next()`, `prev()`, `to()`, `reset()`
 *
 * @example
 * ```vue
 * <script setup>
 * import { ref } from 'vue'
 *
 * const swiperRef = ref(null)
 * const { next, prev, isBeginning, isEnd } = useSwiper(swiperRef, {
 *   slidesPerView: 1,
 *   spaceBetween: 10,
 * })
 * </script>
 *
 * <template>
 *   <swiper-container ref="swiperRef">
 *     <swiper-slide>Slide 1</swiper-slide>
 *     <swiper-slide>Slide 2</swiper-slide>
 *   </swiper-container>
 *
 *   <button @click="next" :disabled="isEnd">Next</button>
 *   <button @click="prev" :disabled="isBeginning">Previous</button>
 * </template>
 * ```
 */
export declare function useSwiper(swiperContainerRef: Ref<SwiperContainer | null>, options?: SwiperContainer['swiper']['params']): {
    instance: Ref<Swiper | undefined, Swiper | undefined>;
    isBeginning: import("vue").ComputedRef<boolean>;
    isEnd: import("vue").ComputedRef<boolean>;
    activeIndex: import("vue").ComputedRef<number>;
    realIndex: import("vue").ComputedRef<number>;
    slides: import("vue").ComputedRef<HTMLElement[]>;
    slidesPerView: import("vue").ComputedRef<number>;
    progress: import("vue").ComputedRef<number>;
    getNumberOfSlides: import("vue").ComputedRef<number>;
    next: (speed?: number | undefined, runCallbacks?: boolean | undefined) => void;
    prev: (speed?: number | undefined, runCallbacks?: boolean | undefined) => void;
    to: (index: number, speed?: number | undefined, runCallbacks?: boolean | undefined) => void;
    reset: (speed?: number | undefined, runCallbacks?: boolean | undefined) => void;
};
