import { __export, getHot } from "./hot-C38Zn4iD.js";
import { Fragment, computed, createBaseVNode, createBlock, createCommentVNode, createElementBlock, createVNode, defineComponent, getCurrentInstance, h, inject, isRef, nextTick, normalizeStyle, onBeforeUnmount, onMounted, openBlock, ref, renderList, resolveComponent, shallowRef, toDisplayString, toRefs, unref, watch, watchEffect, withAsyncContext, withCtx } from "./runtime-core.esm-bundler-BYdEh_Lp.js";
import { isDark, isStaticMode, onModuleUpdated, rpc, usePayloadStore } from "./payload-BKj06nBe.js";
import "./_plugin-vue_export-helper-DfavQbjy.js";
import { Badge_default, Container_default, NavBar_default, PluginName_default, QuerySelector_default, SegmentControl_default } from "./QuerySelector-CM_pgBDK.js";
import { DurationDisplay_default, useOptionsStore } from "./options-C60pcttb.js";
import { useSearchResults } from "./search-Bta8DXiP.js";
/*! *****************************************************************************

Copyright (c) Microsoft Corporation.



Permission to use, copy, modify, and/or distribute this software for any

purpose with or without fee is hereby granted.



THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH

REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY

AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,

INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM

LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR

OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR

PERFORMANCE OF THIS SOFTWARE.

***************************************************************************** */
var extendStatics = function(d, b) {
	extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d$1, b$1) {
		d$1.__proto__ = b$1;
	} || function(d$1, b$1) {
		for (var p in b$1) if (Object.prototype.hasOwnProperty.call(b$1, p)) d$1[p] = b$1[p];
	};
	return extendStatics(d, b);
};
function __extends(d, b) {
	if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
	extendStatics(d, b);
	function __() {
		this.constructor = d;
	}
	d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
var DEFAULT_FONT_SIZE = 12;
var DEFAULT_FONT_FAMILY = "sans-serif";
var DEFAULT_FONT = DEFAULT_FONT_SIZE + "px " + DEFAULT_FONT_FAMILY;
var OFFSET = 20;
var SCALE = 100;
var defaultWidthMapStr = "007LLmW'55;N0500LLLLLLLLLL00NNNLzWW\\\\WQb\\0FWLg\\bWb\\WQ\\WrWWQ000CL5LLFLL0LL**F*gLLLL5F0LF\\FFF5.5N";
function getTextWidthMap(mapStr) {
	var map$2 = {};
	if (typeof JSON === "undefined") return map$2;
	for (var i = 0; i < mapStr.length; i++) {
		var char = String.fromCharCode(i + 32);
		var size = (mapStr.charCodeAt(i) - OFFSET) / SCALE;
		map$2[char] = size;
	}
	return map$2;
}
var DEFAULT_TEXT_WIDTH_MAP = getTextWidthMap(defaultWidthMapStr);
var platformApi = {
	createCanvas: function() {
		return typeof document !== "undefined" && document.createElement("canvas");
	},
	measureText: function() {
		var _ctx;
		var _cachedFont;
		return function(text, font) {
			if (!_ctx) {
				var canvas = platformApi.createCanvas();
				_ctx = canvas && canvas.getContext("2d");
			}
			if (_ctx) {
				if (_cachedFont !== font) _cachedFont = _ctx.font = font || DEFAULT_FONT;
				return _ctx.measureText(text);
			} else {
				text = text || "";
				font = font || DEFAULT_FONT;
				var res = /((?:\d+)?\.?\d*)px/.exec(font);
				var fontSize = res && +res[1] || DEFAULT_FONT_SIZE;
				var width = 0;
				if (font.indexOf("mono") >= 0) width = fontSize * text.length;
				else for (var i = 0; i < text.length; i++) {
					var preCalcWidth = DEFAULT_TEXT_WIDTH_MAP[text[i]];
					width += preCalcWidth == null ? fontSize : preCalcWidth * fontSize;
				}
				return { width };
			}
		};
	}(),
	loadImage: function(src, onload, onerror) {
		var image = new Image();
		image.onload = onload;
		image.onerror = onerror;
		image.src = src;
		return image;
	}
};
var BUILTIN_OBJECT = reduce([
	"Function",
	"RegExp",
	"Date",
	"Error",
	"CanvasGradient",
	"CanvasPattern",
	"Image",
	"Canvas"
], function(obj, val) {
	obj["[object " + val + "]"] = true;
	return obj;
}, {});
var TYPED_ARRAY = reduce([
	"Int8",
	"Uint8",
	"Uint8Clamped",
	"Int16",
	"Uint16",
	"Int32",
	"Uint32",
	"Float32",
	"Float64"
], function(obj, val) {
	obj["[object " + val + "Array]"] = true;
	return obj;
}, {});
var objToString = Object.prototype.toString;
var arrayProto = Array.prototype;
var nativeForEach = arrayProto.forEach;
var nativeFilter = arrayProto.filter;
var nativeSlice = arrayProto.slice;
var nativeMap = arrayProto.map;
var ctorFunction = function() {}.constructor;
var protoFunction = ctorFunction ? ctorFunction.prototype : null;
var protoKey = "__proto__";
var idStart = 2311;
function guid() {
	return idStart++;
}
function logError() {
	var args = [];
	for (var _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
	if (typeof console !== "undefined") console.error.apply(console, args);
}
function clone$2(source) {
	if (source == null || typeof source !== "object") return source;
	var result = source;
	var typeStr = objToString.call(source);
	if (typeStr === "[object Array]") {
		if (!isPrimitive(source)) {
			result = [];
			for (var i = 0, len$1 = source.length; i < len$1; i++) result[i] = clone$2(source[i]);
		}
	} else if (TYPED_ARRAY[typeStr]) {
		if (!isPrimitive(source)) {
			var Ctor = source.constructor;
			if (Ctor.from) result = Ctor.from(source);
			else {
				result = new Ctor(source.length);
				for (var i = 0, len$1 = source.length; i < len$1; i++) result[i] = source[i];
			}
		}
	} else if (!BUILTIN_OBJECT[typeStr] && !isPrimitive(source) && !isDom(source)) {
		result = {};
		for (var key in source) if (source.hasOwnProperty(key) && key !== protoKey) result[key] = clone$2(source[key]);
	}
	return result;
}
function merge(target, source, overwrite) {
	if (!isObject$2(source) || !isObject$2(target)) return overwrite ? clone$2(source) : target;
	for (var key in source) if (source.hasOwnProperty(key) && key !== protoKey) {
		var targetProp = target[key];
		var sourceProp = source[key];
		if (isObject$2(sourceProp) && isObject$2(targetProp) && !isArray(sourceProp) && !isArray(targetProp) && !isDom(sourceProp) && !isDom(targetProp) && !isBuiltInObject(sourceProp) && !isBuiltInObject(targetProp) && !isPrimitive(sourceProp) && !isPrimitive(targetProp)) merge(targetProp, sourceProp, overwrite);
		else if (overwrite || !(key in target)) target[key] = clone$2(source[key]);
	}
	return target;
}
function extend(target, source) {
	if (Object.assign) Object.assign(target, source);
	else for (var key in source) if (source.hasOwnProperty(key) && key !== protoKey) target[key] = source[key];
	return target;
}
function defaults(target, source, overlay) {
	var keysArr = keys(source);
	for (var i = 0, len$1 = keysArr.length; i < len$1; i++) {
		var key = keysArr[i];
		if (overlay ? source[key] != null : target[key] == null) target[key] = source[key];
	}
	return target;
}
var createCanvas = platformApi.createCanvas;
function indexOf(array, value) {
	if (array) {
		if (array.indexOf) return array.indexOf(value);
		for (var i = 0, len$1 = array.length; i < len$1; i++) if (array[i] === value) return i;
	}
	return -1;
}
function inherits(clazz, baseClazz) {
	var clazzPrototype = clazz.prototype;
	function F() {}
	F.prototype = baseClazz.prototype;
	clazz.prototype = new F();
	for (var prop in clazzPrototype) if (clazzPrototype.hasOwnProperty(prop)) clazz.prototype[prop] = clazzPrototype[prop];
	clazz.prototype.constructor = clazz;
	clazz.superClass = baseClazz;
}
function mixin(target, source, override) {
	target = "prototype" in target ? target.prototype : target;
	source = "prototype" in source ? source.prototype : source;
	if (Object.getOwnPropertyNames) {
		var keyList = Object.getOwnPropertyNames(source);
		for (var i = 0; i < keyList.length; i++) {
			var key = keyList[i];
			if (key !== "constructor") {
				if (override ? source[key] != null : target[key] == null) target[key] = source[key];
			}
		}
	} else defaults(target, source, override);
}
function isArrayLike(data) {
	if (!data) return false;
	if (typeof data === "string") return false;
	return typeof data.length === "number";
}
function each$4(arr, cb, context) {
	if (!(arr && cb)) return;
	if (arr.forEach && arr.forEach === nativeForEach) arr.forEach(cb, context);
	else if (arr.length === +arr.length) for (var i = 0, len$1 = arr.length; i < len$1; i++) cb.call(context, arr[i], i, arr);
	else for (var key in arr) if (arr.hasOwnProperty(key)) cb.call(context, arr[key], key, arr);
}
function map$1(arr, cb, context) {
	if (!arr) return [];
	if (!cb) return slice(arr);
	if (arr.map && arr.map === nativeMap) return arr.map(cb, context);
	else {
		var result = [];
		for (var i = 0, len$1 = arr.length; i < len$1; i++) result.push(cb.call(context, arr[i], i, arr));
		return result;
	}
}
function reduce(arr, cb, memo, context) {
	if (!(arr && cb)) return;
	for (var i = 0, len$1 = arr.length; i < len$1; i++) memo = cb.call(context, memo, arr[i], i, arr);
	return memo;
}
function filter(arr, cb, context) {
	if (!arr) return [];
	if (!cb) return slice(arr);
	if (arr.filter && arr.filter === nativeFilter) return arr.filter(cb, context);
	else {
		var result = [];
		for (var i = 0, len$1 = arr.length; i < len$1; i++) if (cb.call(context, arr[i], i, arr)) result.push(arr[i]);
		return result;
	}
}
function keys(obj) {
	if (!obj) return [];
	if (Object.keys) return Object.keys(obj);
	var keyList = [];
	for (var key in obj) if (obj.hasOwnProperty(key)) keyList.push(key);
	return keyList;
}
function bindPolyfill(func, context) {
	var args = [];
	for (var _i = 2; _i < arguments.length; _i++) args[_i - 2] = arguments[_i];
	return function() {
		return func.apply(context, args.concat(nativeSlice.call(arguments)));
	};
}
var bind$1 = protoFunction && isFunction(protoFunction.bind) ? protoFunction.call.bind(protoFunction.bind) : bindPolyfill;
function curry$1(func) {
	var args = [];
	for (var _i = 1; _i < arguments.length; _i++) args[_i - 1] = arguments[_i];
	return function() {
		return func.apply(this, args.concat(nativeSlice.call(arguments)));
	};
}
function isArray(value) {
	if (Array.isArray) return Array.isArray(value);
	return objToString.call(value) === "[object Array]";
}
function isFunction(value) {
	return typeof value === "function";
}
function isString(value) {
	return typeof value === "string";
}
function isStringSafe(value) {
	return objToString.call(value) === "[object String]";
}
function isNumber(value) {
	return typeof value === "number";
}
function isObject$2(value) {
	var type = typeof value;
	return type === "function" || !!value && type === "object";
}
function isBuiltInObject(value) {
	return !!BUILTIN_OBJECT[objToString.call(value)];
}
function isTypedArray(value) {
	return !!TYPED_ARRAY[objToString.call(value)];
}
function isDom(value) {
	return typeof value === "object" && typeof value.nodeType === "number" && typeof value.ownerDocument === "object";
}
function isGradientObject(value) {
	return value.colorStops != null;
}
function isImagePatternObject(value) {
	return value.image != null;
}
function eqNaN(value) {
	return value !== value;
}
function retrieve() {
	var args = [];
	for (var _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
	for (var i = 0, len$1 = args.length; i < len$1; i++) if (args[i] != null) return args[i];
}
function retrieve2(value0, value1) {
	return value0 != null ? value0 : value1;
}
function retrieve3(value0, value1, value2) {
	return value0 != null ? value0 : value1 != null ? value1 : value2;
}
function slice(arr) {
	var args = [];
	for (var _i = 1; _i < arguments.length; _i++) args[_i - 1] = arguments[_i];
	return nativeSlice.apply(arr, args);
}
function normalizeCssArray$1(val) {
	if (typeof val === "number") return [
		val,
		val,
		val,
		val
	];
	var len$1 = val.length;
	if (len$1 === 2) return [
		val[0],
		val[1],
		val[0],
		val[1]
	];
	else if (len$1 === 3) return [
		val[0],
		val[1],
		val[2],
		val[1]
	];
	return val;
}
function assert(condition, message) {
	if (!condition) throw new Error(message);
}
function trim(str) {
	if (str == null) return null;
	else if (typeof str.trim === "function") return str.trim();
	else return str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
}
var primitiveKey = "__ec_primitive__";
function setAsPrimitive(obj) {
	obj[primitiveKey] = true;
}
function isPrimitive(obj) {
	return obj[primitiveKey];
}
var MapPolyfill = function() {
	function MapPolyfill$1() {
		this.data = {};
	}
	MapPolyfill$1.prototype["delete"] = function(key) {
		var existed = this.has(key);
		if (existed) delete this.data[key];
		return existed;
	};
	MapPolyfill$1.prototype.has = function(key) {
		return this.data.hasOwnProperty(key);
	};
	MapPolyfill$1.prototype.get = function(key) {
		return this.data[key];
	};
	MapPolyfill$1.prototype.set = function(key, value) {
		this.data[key] = value;
		return this;
	};
	MapPolyfill$1.prototype.keys = function() {
		return keys(this.data);
	};
	MapPolyfill$1.prototype.forEach = function(callback) {
		var data = this.data;
		for (var key in data) if (data.hasOwnProperty(key)) callback(data[key], key);
	};
	return MapPolyfill$1;
}();
var isNativeMapSupported = typeof Map === "function";
function maybeNativeMap() {
	return isNativeMapSupported ? new Map() : new MapPolyfill();
}
var HashMap = function() {
	function HashMap$1(obj) {
		var isArr = isArray(obj);
		this.data = maybeNativeMap();
		var thisMap = this;
		obj instanceof HashMap$1 ? obj.each(visit) : obj && each$4(obj, visit);
		function visit(value, key) {
			isArr ? thisMap.set(value, key) : thisMap.set(key, value);
		}
	}
	HashMap$1.prototype.hasKey = function(key) {
		return this.data.has(key);
	};
	HashMap$1.prototype.get = function(key) {
		return this.data.get(key);
	};
	HashMap$1.prototype.set = function(key, value) {
		this.data.set(key, value);
		return value;
	};
	HashMap$1.prototype.each = function(cb, context) {
		this.data.forEach(function(value, key) {
			cb.call(context, value, key);
		});
	};
	HashMap$1.prototype.keys = function() {
		var keys$1 = this.data.keys();
		return isNativeMapSupported ? Array.from(keys$1) : keys$1;
	};
	HashMap$1.prototype.removeKey = function(key) {
		this.data["delete"](key);
	};
	return HashMap$1;
}();
function createHashMap(obj) {
	return new HashMap(obj);
}
function concatArray(a, b) {
	var newArray = new a.constructor(a.length + b.length);
	for (var i = 0; i < a.length; i++) newArray[i] = a[i];
	var offset = a.length;
	for (var i = 0; i < b.length; i++) newArray[i + offset] = b[i];
	return newArray;
}
function createObject(proto$1, properties) {
	var obj;
	if (Object.create) obj = Object.create(proto$1);
	else {
		var StyleCtor = function() {};
		StyleCtor.prototype = proto$1;
		obj = new StyleCtor();
	}
	if (properties) extend(obj, properties);
	return obj;
}
function disableUserSelect(dom) {
	var domStyle = dom.style;
	domStyle.webkitUserSelect = "none";
	domStyle.userSelect = "none";
	domStyle.webkitTapHighlightColor = "rgba(0,0,0,0)";
	domStyle["-webkit-touch-callout"] = "none";
}
function hasOwn(own, prop) {
	return own.hasOwnProperty(prop);
}
function noop() {}
var RADIAN_TO_DEGREE = 180 / Math.PI;
var Browser = function() {
	function Browser$1() {
		this.firefox = false;
		this.ie = false;
		this.edge = false;
		this.newEdge = false;
		this.weChat = false;
	}
	return Browser$1;
}();
var Env = function() {
	function Env$1() {
		this.browser = new Browser();
		this.node = false;
		this.wxa = false;
		this.worker = false;
		this.svgSupported = false;
		this.touchEventsSupported = false;
		this.pointerEventsSupported = false;
		this.domSupported = false;
		this.transformSupported = false;
		this.transform3dSupported = false;
		this.hasGlobalWindow = typeof window !== "undefined";
	}
	return Env$1;
}();
var env = new Env();
if (typeof wx === "object" && typeof wx.getSystemInfoSync === "function") {
	env.wxa = true;
	env.touchEventsSupported = true;
} else if (typeof document === "undefined" && typeof self !== "undefined") env.worker = true;
else if (!env.hasGlobalWindow || "Deno" in window) {
	env.node = true;
	env.svgSupported = true;
} else detect(navigator.userAgent, env);
function detect(ua, env$1) {
	var browser = env$1.browser;
	var firefox = ua.match(/Firefox\/([\d.]+)/);
	var ie = ua.match(/MSIE\s([\d.]+)/) || ua.match(/Trident\/.+?rv:(([\d.]+))/);
	var edge = ua.match(/Edge?\/([\d.]+)/);
	var weChat = /micromessenger/i.test(ua);
	if (firefox) {
		browser.firefox = true;
		browser.version = firefox[1];
	}
	if (ie) {
		browser.ie = true;
		browser.version = ie[1];
	}
	if (edge) {
		browser.edge = true;
		browser.version = edge[1];
		browser.newEdge = +edge[1].split(".")[0] > 18;
	}
	if (weChat) browser.weChat = true;
	env$1.svgSupported = typeof SVGRect !== "undefined";
	env$1.touchEventsSupported = "ontouchstart" in window && !browser.ie && !browser.edge;
	env$1.pointerEventsSupported = "onpointerdown" in window && (browser.edge || browser.ie && +browser.version >= 11);
	env$1.domSupported = typeof document !== "undefined";
	var style = document.documentElement.style;
	env$1.transform3dSupported = (browser.ie && "transition" in style || browser.edge || "WebKitCSSMatrix" in window && "m11" in new WebKitCSSMatrix() || "MozPerspective" in style) && !("OTransition" in style);
	env$1.transformSupported = env$1.transform3dSupported || browser.ie && +browser.version >= 9;
}
var env_default = env;
var TYPE_DELIMITER = ".";
var IS_CONTAINER = "___EC__COMPONENT__CONTAINER___";
var IS_EXTENDED_CLASS = "___EC__EXTENDED_CLASS___";
function parseClassType(componentType) {
	var ret = {
		main: "",
		sub: ""
	};
	if (componentType) {
		var typeArr = componentType.split(TYPE_DELIMITER);
		ret.main = typeArr[0] || "";
		ret.sub = typeArr[1] || "";
	}
	return ret;
}
/**

* @public

*/
function checkClassType(componentType) {
	assert(/^[a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)?$/.test(componentType), "componentType \"" + componentType + "\" illegal");
}
function isExtendedClass(clz) {
	return !!(clz && clz[IS_EXTENDED_CLASS]);
}
function enableClassExtend(rootClz, mandatoryMethods) {
	rootClz.$constructor = rootClz;
	rootClz.extend = function(proto$1) {
		var superClass = this;
		var ExtendedClass;
		if (isESClass(superClass)) ExtendedClass = function(_super) {
			__extends(class_1, _super);
			function class_1() {
				return _super.apply(this, arguments) || this;
			}
			return class_1;
		}(superClass);
		else {
			ExtendedClass = function() {
				(proto$1.$constructor || superClass).apply(this, arguments);
			};
			inherits(ExtendedClass, this);
		}
		extend(ExtendedClass.prototype, proto$1);
		ExtendedClass[IS_EXTENDED_CLASS] = true;
		ExtendedClass.extend = this.extend;
		ExtendedClass.superCall = superCall;
		ExtendedClass.superApply = superApply;
		ExtendedClass.superClass = superClass;
		return ExtendedClass;
	};
}
function isESClass(fn) {
	return isFunction(fn) && /^class\s/.test(Function.prototype.toString.call(fn));
}
function mountExtend(SubClz, SupperClz) {
	SubClz.extend = SupperClz.extend;
}
var classBase = Math.round(Math.random() * 10);
function enableClassCheck(target) {
	var classAttr = ["__\0is_clz", classBase++].join("_");
	target.prototype[classAttr] = true;
	target.isInstance = function(obj) {
		return !!(obj && obj[classAttr]);
	};
}
function superCall(context, methodName) {
	var args = [];
	for (var _i = 2; _i < arguments.length; _i++) args[_i - 2] = arguments[_i];
	return this.superClass.prototype[methodName].apply(context, args);
}
function superApply(context, methodName, args) {
	return this.superClass.prototype[methodName].apply(context, args);
}
function enableClassManagement(target) {
	/**
	
	* Component model classes
	
	* key: componentType,
	
	* value:
	
	*     componentClass, when componentType is 'a'
	
	*     or Object.<subKey, componentClass>, when componentType is 'a.b'
	
	*/
	var storage = {};
	target.registerClass = function(clz) {
		var componentFullType = clz.type || clz.prototype.type;
		if (componentFullType) {
			checkClassType(componentFullType);
			clz.prototype.type = componentFullType;
			var componentTypeInfo = parseClassType(componentFullType);
			if (!componentTypeInfo.sub) storage[componentTypeInfo.main] = clz;
			else if (componentTypeInfo.sub !== IS_CONTAINER) {
				var container = makeContainer(componentTypeInfo);
				container[componentTypeInfo.sub] = clz;
			}
		}
		return clz;
	};
	target.getClass = function(mainType, subType, throwWhenNotFound) {
		var clz = storage[mainType];
		if (clz && clz[IS_CONTAINER]) clz = subType ? clz[subType] : null;
		if (throwWhenNotFound && !clz) throw new Error(!subType ? mainType + ".type should be specified." : "Component " + mainType + "." + (subType || "") + " is used but not imported.");
		return clz;
	};
	target.getClassesByMainType = function(componentType) {
		var componentTypeInfo = parseClassType(componentType);
		var result = [];
		var obj = storage[componentTypeInfo.main];
		if (obj && obj[IS_CONTAINER]) each$4(obj, function(o, type) {
			type !== IS_CONTAINER && result.push(o);
		});
		else result.push(obj);
		return result;
	};
	target.hasClass = function(componentType) {
		var componentTypeInfo = parseClassType(componentType);
		return !!storage[componentTypeInfo.main];
	};
	/**
	
	* @return Like ['aa', 'bb'], but can not be ['aa.xx']
	
	*/
	target.getAllClassMainTypes = function() {
		var types = [];
		each$4(storage, function(obj, type) {
			types.push(type);
		});
		return types;
	};
	/**
	
	* If a main type is container and has sub types
	
	*/
	target.hasSubTypes = function(componentType) {
		var componentTypeInfo = parseClassType(componentType);
		var obj = storage[componentTypeInfo.main];
		return obj && obj[IS_CONTAINER];
	};
	function makeContainer(componentTypeInfo) {
		var container = storage[componentTypeInfo.main];
		if (!container || !container[IS_CONTAINER]) {
			container = storage[componentTypeInfo.main] = {};
			container[IS_CONTAINER] = true;
		}
		return container;
	}
}
function makeStyleMapper(properties, ignoreParent) {
	for (var i = 0; i < properties.length; i++) if (!properties[i][1]) properties[i][1] = properties[i][0];
	ignoreParent = ignoreParent || false;
	return function(model, excludes, includes) {
		var style = {};
		for (var i$1 = 0; i$1 < properties.length; i$1++) {
			var propName = properties[i$1][1];
			if (excludes && indexOf(excludes, propName) >= 0 || includes && indexOf(includes, propName) < 0) continue;
			var val = model.getShallow(propName, ignoreParent);
			if (val != null) style[properties[i$1][0]] = val;
		}
		return style;
	};
}
var AREA_STYLE_KEY_MAP = [
	["fill", "color"],
	["shadowBlur"],
	["shadowOffsetX"],
	["shadowOffsetY"],
	["opacity"],
	["shadowColor"]
];
var getAreaStyle = makeStyleMapper(AREA_STYLE_KEY_MAP);
var AreaStyleMixin = function() {
	function AreaStyleMixin$1() {}
	AreaStyleMixin$1.prototype.getAreaStyle = function(excludes, includes) {
		return getAreaStyle(this, excludes, includes);
	};
	return AreaStyleMixin$1;
}();
var Entry = function() {
	function Entry$1(val) {
		this.value = val;
	}
	return Entry$1;
}();
var LinkedList = function() {
	function LinkedList$1() {
		this._len = 0;
	}
	LinkedList$1.prototype.insert = function(val) {
		var entry = new Entry(val);
		this.insertEntry(entry);
		return entry;
	};
	LinkedList$1.prototype.insertEntry = function(entry) {
		if (!this.head) this.head = this.tail = entry;
		else {
			this.tail.next = entry;
			entry.prev = this.tail;
			entry.next = null;
			this.tail = entry;
		}
		this._len++;
	};
	LinkedList$1.prototype.remove = function(entry) {
		var prev = entry.prev;
		var next = entry.next;
		if (prev) prev.next = next;
		else this.head = next;
		if (next) next.prev = prev;
		else this.tail = prev;
		entry.next = entry.prev = null;
		this._len--;
	};
	LinkedList$1.prototype.len = function() {
		return this._len;
	};
	LinkedList$1.prototype.clear = function() {
		this.head = this.tail = null;
		this._len = 0;
	};
	return LinkedList$1;
}();
var LRU = function() {
	function LRU$1(maxSize) {
		this._list = new LinkedList();
		this._maxSize = 10;
		this._map = {};
		this._maxSize = maxSize;
	}
	LRU$1.prototype.put = function(key, value) {
		var list = this._list;
		var map$2 = this._map;
		var removed = null;
		if (map$2[key] == null) {
			var len$1 = list.len();
			var entry = this._lastRemovedEntry;
			if (len$1 >= this._maxSize && len$1 > 0) {
				var leastUsedEntry = list.head;
				list.remove(leastUsedEntry);
				delete map$2[leastUsedEntry.key];
				removed = leastUsedEntry.value;
				this._lastRemovedEntry = leastUsedEntry;
			}
			if (entry) entry.value = value;
			else entry = new Entry(value);
			entry.key = key;
			list.insertEntry(entry);
			map$2[key] = entry;
		}
		return removed;
	};
	LRU$1.prototype.get = function(key) {
		var entry = this._map[key];
		var list = this._list;
		if (entry != null) {
			if (entry !== list.tail) {
				list.remove(entry);
				list.insertEntry(entry);
			}
			return entry.value;
		}
	};
	LRU$1.prototype.clear = function() {
		this._list.clear();
		this._map = {};
	};
	LRU$1.prototype.len = function() {
		return this._list.len();
	};
	return LRU$1;
}();
var LRU_default = LRU;
var globalImageCache = new LRU_default(50);
function findExistImage(newImageOrSrc) {
	if (typeof newImageOrSrc === "string") {
		var cachedImgObj = globalImageCache.get(newImageOrSrc);
		return cachedImgObj && cachedImgObj.image;
	} else return newImageOrSrc;
}
function createOrUpdateImage(newImageOrSrc, image, hostEl, onload, cbPayload) {
	if (!newImageOrSrc) return image;
	else if (typeof newImageOrSrc === "string") {
		if (image && image.__zrImageSrc === newImageOrSrc || !hostEl) return image;
		var cachedImgObj = globalImageCache.get(newImageOrSrc);
		var pendingWrap = {
			hostEl,
			cb: onload,
			cbPayload
		};
		if (cachedImgObj) {
			image = cachedImgObj.image;
			!isImageReady(image) && cachedImgObj.pending.push(pendingWrap);
		} else {
			image = platformApi.loadImage(newImageOrSrc, imageOnLoad, imageOnLoad);
			image.__zrImageSrc = newImageOrSrc;
			globalImageCache.put(newImageOrSrc, image.__cachedImgObj = {
				image,
				pending: [pendingWrap]
			});
		}
		return image;
	} else return newImageOrSrc;
}
function imageOnLoad() {
	var cachedImgObj = this.__cachedImgObj;
	this.onload = this.onerror = this.__cachedImgObj = null;
	for (var i = 0; i < cachedImgObj.pending.length; i++) {
		var pendingWrap = cachedImgObj.pending[i];
		var cb = pendingWrap.cb;
		cb && cb(this, pendingWrap.cbPayload);
		pendingWrap.hostEl.dirty();
	}
	cachedImgObj.pending.length = 0;
}
function isImageReady(image) {
	return image && image.width && image.height;
}
function create$1() {
	return [
		1,
		0,
		0,
		1,
		0,
		0
	];
}
function identity(out$1) {
	out$1[0] = 1;
	out$1[1] = 0;
	out$1[2] = 0;
	out$1[3] = 1;
	out$1[4] = 0;
	out$1[5] = 0;
	return out$1;
}
function copy(out$1, m$1) {
	out$1[0] = m$1[0];
	out$1[1] = m$1[1];
	out$1[2] = m$1[2];
	out$1[3] = m$1[3];
	out$1[4] = m$1[4];
	out$1[5] = m$1[5];
	return out$1;
}
function mul(out$1, m1, m2) {
	var out0 = m1[0] * m2[0] + m1[2] * m2[1];
	var out1 = m1[1] * m2[0] + m1[3] * m2[1];
	var out2 = m1[0] * m2[2] + m1[2] * m2[3];
	var out3 = m1[1] * m2[2] + m1[3] * m2[3];
	var out4 = m1[0] * m2[4] + m1[2] * m2[5] + m1[4];
	var out5 = m1[1] * m2[4] + m1[3] * m2[5] + m1[5];
	out$1[0] = out0;
	out$1[1] = out1;
	out$1[2] = out2;
	out$1[3] = out3;
	out$1[4] = out4;
	out$1[5] = out5;
	return out$1;
}
function translate(out$1, a, v) {
	out$1[0] = a[0];
	out$1[1] = a[1];
	out$1[2] = a[2];
	out$1[3] = a[3];
	out$1[4] = a[4] + v[0];
	out$1[5] = a[5] + v[1];
	return out$1;
}
function rotate(out$1, a, rad, pivot) {
	if (pivot === void 0) pivot = [0, 0];
	var aa = a[0];
	var ac = a[2];
	var atx = a[4];
	var ab = a[1];
	var ad = a[3];
	var aty = a[5];
	var st = Math.sin(rad);
	var ct = Math.cos(rad);
	out$1[0] = aa * ct + ab * st;
	out$1[1] = -aa * st + ab * ct;
	out$1[2] = ac * ct + ad * st;
	out$1[3] = -ac * st + ct * ad;
	out$1[4] = ct * (atx - pivot[0]) + st * (aty - pivot[1]) + pivot[0];
	out$1[5] = ct * (aty - pivot[1]) - st * (atx - pivot[0]) + pivot[1];
	return out$1;
}
function scale$2(out$1, a, v) {
	var vx = v[0];
	var vy = v[1];
	out$1[0] = a[0] * vx;
	out$1[1] = a[1] * vy;
	out$1[2] = a[2] * vx;
	out$1[3] = a[3] * vy;
	out$1[4] = a[4] * vx;
	out$1[5] = a[5] * vy;
	return out$1;
}
function invert(out$1, a) {
	var aa = a[0];
	var ac = a[2];
	var atx = a[4];
	var ab = a[1];
	var ad = a[3];
	var aty = a[5];
	var det = aa * ad - ab * ac;
	if (!det) return null;
	det = 1 / det;
	out$1[0] = ad * det;
	out$1[1] = -ab * det;
	out$1[2] = -ac * det;
	out$1[3] = aa * det;
	out$1[4] = (ac * aty - ad * atx) * det;
	out$1[5] = (ab * atx - aa * aty) * det;
	return out$1;
}
var Point = function() {
	function Point$1(x, y) {
		this.x = x || 0;
		this.y = y || 0;
	}
	Point$1.prototype.copy = function(other) {
		this.x = other.x;
		this.y = other.y;
		return this;
	};
	Point$1.prototype.clone = function() {
		return new Point$1(this.x, this.y);
	};
	Point$1.prototype.set = function(x, y) {
		this.x = x;
		this.y = y;
		return this;
	};
	Point$1.prototype.equal = function(other) {
		return other.x === this.x && other.y === this.y;
	};
	Point$1.prototype.add = function(other) {
		this.x += other.x;
		this.y += other.y;
		return this;
	};
	Point$1.prototype.scale = function(scalar) {
		this.x *= scalar;
		this.y *= scalar;
	};
	Point$1.prototype.scaleAndAdd = function(other, scalar) {
		this.x += other.x * scalar;
		this.y += other.y * scalar;
	};
	Point$1.prototype.sub = function(other) {
		this.x -= other.x;
		this.y -= other.y;
		return this;
	};
	Point$1.prototype.dot = function(other) {
		return this.x * other.x + this.y * other.y;
	};
	Point$1.prototype.len = function() {
		return Math.sqrt(this.x * this.x + this.y * this.y);
	};
	Point$1.prototype.lenSquare = function() {
		return this.x * this.x + this.y * this.y;
	};
	Point$1.prototype.normalize = function() {
		var len$1 = this.len();
		this.x /= len$1;
		this.y /= len$1;
		return this;
	};
	Point$1.prototype.distance = function(other) {
		var dx = this.x - other.x;
		var dy = this.y - other.y;
		return Math.sqrt(dx * dx + dy * dy);
	};
	Point$1.prototype.distanceSquare = function(other) {
		var dx = this.x - other.x;
		var dy = this.y - other.y;
		return dx * dx + dy * dy;
	};
	Point$1.prototype.negate = function() {
		this.x = -this.x;
		this.y = -this.y;
		return this;
	};
	Point$1.prototype.transform = function(m$1) {
		if (!m$1) return;
		var x = this.x;
		var y = this.y;
		this.x = m$1[0] * x + m$1[2] * y + m$1[4];
		this.y = m$1[1] * x + m$1[3] * y + m$1[5];
		return this;
	};
	Point$1.prototype.toArray = function(out$1) {
		out$1[0] = this.x;
		out$1[1] = this.y;
		return out$1;
	};
	Point$1.prototype.fromArray = function(input) {
		this.x = input[0];
		this.y = input[1];
	};
	Point$1.set = function(p, x, y) {
		p.x = x;
		p.y = y;
	};
	Point$1.copy = function(p, p2) {
		p.x = p2.x;
		p.y = p2.y;
	};
	Point$1.len = function(p) {
		return Math.sqrt(p.x * p.x + p.y * p.y);
	};
	Point$1.lenSquare = function(p) {
		return p.x * p.x + p.y * p.y;
	};
	Point$1.dot = function(p0, p1) {
		return p0.x * p1.x + p0.y * p1.y;
	};
	Point$1.add = function(out$1, p0, p1) {
		out$1.x = p0.x + p1.x;
		out$1.y = p0.y + p1.y;
	};
	Point$1.sub = function(out$1, p0, p1) {
		out$1.x = p0.x - p1.x;
		out$1.y = p0.y - p1.y;
	};
	Point$1.scale = function(out$1, p0, scalar) {
		out$1.x = p0.x * scalar;
		out$1.y = p0.y * scalar;
	};
	Point$1.scaleAndAdd = function(out$1, p0, p1, scalar) {
		out$1.x = p0.x + p1.x * scalar;
		out$1.y = p0.y + p1.y * scalar;
	};
	Point$1.lerp = function(out$1, p0, p1, t) {
		var onet = 1 - t;
		out$1.x = onet * p0.x + t * p1.x;
		out$1.y = onet * p0.y + t * p1.y;
	};
	return Point$1;
}();
var Point_default = Point;
var mathMin$5 = Math.min;
var mathMax$5 = Math.max;
var lt = new Point_default();
var rb = new Point_default();
var lb = new Point_default();
var rt = new Point_default();
var minTv$1 = new Point_default();
var maxTv$1 = new Point_default();
var BoundingRect = function() {
	function BoundingRect$1(x, y, width, height) {
		if (width < 0) {
			x = x + width;
			width = -width;
		}
		if (height < 0) {
			y = y + height;
			height = -height;
		}
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}
	BoundingRect$1.prototype.union = function(other) {
		var x = mathMin$5(other.x, this.x);
		var y = mathMin$5(other.y, this.y);
		if (isFinite(this.x) && isFinite(this.width)) this.width = mathMax$5(other.x + other.width, this.x + this.width) - x;
		else this.width = other.width;
		if (isFinite(this.y) && isFinite(this.height)) this.height = mathMax$5(other.y + other.height, this.y + this.height) - y;
		else this.height = other.height;
		this.x = x;
		this.y = y;
	};
	BoundingRect$1.prototype.applyTransform = function(m$1) {
		BoundingRect$1.applyTransform(this, this, m$1);
	};
	BoundingRect$1.prototype.calculateTransform = function(b) {
		var a = this;
		var sx = b.width / a.width;
		var sy = b.height / a.height;
		var m$1 = create$1();
		translate(m$1, m$1, [-a.x, -a.y]);
		scale$2(m$1, m$1, [sx, sy]);
		translate(m$1, m$1, [b.x, b.y]);
		return m$1;
	};
	BoundingRect$1.prototype.intersect = function(b, mtv) {
		if (!b) return false;
		if (!(b instanceof BoundingRect$1)) b = BoundingRect$1.create(b);
		var a = this;
		var ax0 = a.x;
		var ax1 = a.x + a.width;
		var ay0 = a.y;
		var ay1 = a.y + a.height;
		var bx0 = b.x;
		var bx1 = b.x + b.width;
		var by0 = b.y;
		var by1 = b.y + b.height;
		var overlap = !(ax1 < bx0 || bx1 < ax0 || ay1 < by0 || by1 < ay0);
		if (mtv) {
			var dMin = Infinity;
			var dMax = 0;
			var d0 = Math.abs(ax1 - bx0);
			var d1 = Math.abs(bx1 - ax0);
			var d2 = Math.abs(ay1 - by0);
			var d3 = Math.abs(by1 - ay0);
			var dx = Math.min(d0, d1);
			var dy = Math.min(d2, d3);
			if (ax1 < bx0 || bx1 < ax0) {
				if (dx > dMax) {
					dMax = dx;
					if (d0 < d1) Point_default.set(maxTv$1, -d0, 0);
					else Point_default.set(maxTv$1, d1, 0);
				}
			} else if (dx < dMin) {
				dMin = dx;
				if (d0 < d1) Point_default.set(minTv$1, d0, 0);
				else Point_default.set(minTv$1, -d1, 0);
			}
			if (ay1 < by0 || by1 < ay0) {
				if (dy > dMax) {
					dMax = dy;
					if (d2 < d3) Point_default.set(maxTv$1, 0, -d2);
					else Point_default.set(maxTv$1, 0, d3);
				}
			} else if (dx < dMin) {
				dMin = dx;
				if (d2 < d3) Point_default.set(minTv$1, 0, d2);
				else Point_default.set(minTv$1, 0, -d3);
			}
		}
		if (mtv) Point_default.copy(mtv, overlap ? minTv$1 : maxTv$1);
		return overlap;
	};
	BoundingRect$1.prototype.contain = function(x, y) {
		var rect = this;
		return x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height;
	};
	BoundingRect$1.prototype.clone = function() {
		return new BoundingRect$1(this.x, this.y, this.width, this.height);
	};
	BoundingRect$1.prototype.copy = function(other) {
		BoundingRect$1.copy(this, other);
	};
	BoundingRect$1.prototype.plain = function() {
		return {
			x: this.x,
			y: this.y,
			width: this.width,
			height: this.height
		};
	};
	BoundingRect$1.prototype.isFinite = function() {
		return isFinite(this.x) && isFinite(this.y) && isFinite(this.width) && isFinite(this.height);
	};
	BoundingRect$1.prototype.isZero = function() {
		return this.width === 0 || this.height === 0;
	};
	BoundingRect$1.create = function(rect) {
		return new BoundingRect$1(rect.x, rect.y, rect.width, rect.height);
	};
	BoundingRect$1.copy = function(target, source) {
		target.x = source.x;
		target.y = source.y;
		target.width = source.width;
		target.height = source.height;
	};
	BoundingRect$1.applyTransform = function(target, source, m$1) {
		if (!m$1) {
			if (target !== source) BoundingRect$1.copy(target, source);
			return;
		}
		if (m$1[1] < 1e-5 && m$1[1] > -1e-5 && m$1[2] < 1e-5 && m$1[2] > -1e-5) {
			var sx = m$1[0];
			var sy = m$1[3];
			var tx = m$1[4];
			var ty = m$1[5];
			target.x = source.x * sx + tx;
			target.y = source.y * sy + ty;
			target.width = source.width * sx;
			target.height = source.height * sy;
			if (target.width < 0) {
				target.x += target.width;
				target.width = -target.width;
			}
			if (target.height < 0) {
				target.y += target.height;
				target.height = -target.height;
			}
			return;
		}
		lt.x = lb.x = source.x;
		lt.y = rt.y = source.y;
		rb.x = rt.x = source.x + source.width;
		rb.y = lb.y = source.y + source.height;
		lt.transform(m$1);
		rt.transform(m$1);
		rb.transform(m$1);
		lb.transform(m$1);
		target.x = mathMin$5(lt.x, rb.x, lb.x, rt.x);
		target.y = mathMin$5(lt.y, rb.y, lb.y, rt.y);
		var maxX = mathMax$5(lt.x, rb.x, lb.x, rt.x);
		var maxY = mathMax$5(lt.y, rb.y, lb.y, rt.y);
		target.width = maxX - target.x;
		target.height = maxY - target.y;
	};
	return BoundingRect$1;
}();
var BoundingRect_default = BoundingRect;
var textWidthCache = {};
function getWidth(text, font) {
	font = font || DEFAULT_FONT;
	var cacheOfFont = textWidthCache[font];
	if (!cacheOfFont) cacheOfFont = textWidthCache[font] = new LRU_default(500);
	var width = cacheOfFont.get(text);
	if (width == null) {
		width = platformApi.measureText(text, font).width;
		cacheOfFont.put(text, width);
	}
	return width;
}
function innerGetBoundingRect(text, font, textAlign, textBaseline) {
	var width = getWidth(text, font);
	var height = getLineHeight(font);
	var x = adjustTextX(0, width, textAlign);
	var y = adjustTextY(0, height, textBaseline);
	var rect = new BoundingRect_default(x, y, width, height);
	return rect;
}
function getBoundingRect(text, font, textAlign, textBaseline) {
	var textLines = ((text || "") + "").split("\n");
	var len$1 = textLines.length;
	if (len$1 === 1) return innerGetBoundingRect(textLines[0], font, textAlign, textBaseline);
	else {
		var uniondRect = new BoundingRect_default(0, 0, 0, 0);
		for (var i = 0; i < textLines.length; i++) {
			var rect = innerGetBoundingRect(textLines[i], font, textAlign, textBaseline);
			i === 0 ? uniondRect.copy(rect) : uniondRect.union(rect);
		}
		return uniondRect;
	}
}
function adjustTextX(x, width, textAlign) {
	if (textAlign === "right") x -= width;
	else if (textAlign === "center") x -= width / 2;
	return x;
}
function adjustTextY(y, height, verticalAlign) {
	if (verticalAlign === "middle") y -= height / 2;
	else if (verticalAlign === "bottom") y -= height;
	return y;
}
function getLineHeight(font) {
	return getWidth("国", font);
}
function parsePercent$1(value, maxValue) {
	if (typeof value === "string") {
		if (value.lastIndexOf("%") >= 0) return parseFloat(value) / 100 * maxValue;
		return parseFloat(value);
	}
	return value;
}
function calculateTextPosition(out$1, opts, rect) {
	var textPosition = opts.position || "inside";
	var distance$1 = opts.distance != null ? opts.distance : 5;
	var height = rect.height;
	var width = rect.width;
	var halfHeight = height / 2;
	var x = rect.x;
	var y = rect.y;
	var textAlign = "left";
	var textVerticalAlign = "top";
	if (textPosition instanceof Array) {
		x += parsePercent$1(textPosition[0], rect.width);
		y += parsePercent$1(textPosition[1], rect.height);
		textAlign = null;
		textVerticalAlign = null;
	} else switch (textPosition) {
		case "left":
			x -= distance$1;
			y += halfHeight;
			textAlign = "right";
			textVerticalAlign = "middle";
			break;
		case "right":
			x += distance$1 + width;
			y += halfHeight;
			textVerticalAlign = "middle";
			break;
		case "top":
			x += width / 2;
			y -= distance$1;
			textAlign = "center";
			textVerticalAlign = "bottom";
			break;
		case "bottom":
			x += width / 2;
			y += height + distance$1;
			textAlign = "center";
			break;
		case "inside":
			x += width / 2;
			y += halfHeight;
			textAlign = "center";
			textVerticalAlign = "middle";
			break;
		case "insideLeft":
			x += distance$1;
			y += halfHeight;
			textVerticalAlign = "middle";
			break;
		case "insideRight":
			x += width - distance$1;
			y += halfHeight;
			textAlign = "right";
			textVerticalAlign = "middle";
			break;
		case "insideTop":
			x += width / 2;
			y += distance$1;
			textAlign = "center";
			break;
		case "insideBottom":
			x += width / 2;
			y += height - distance$1;
			textAlign = "center";
			textVerticalAlign = "bottom";
			break;
		case "insideTopLeft":
			x += distance$1;
			y += distance$1;
			break;
		case "insideTopRight":
			x += width - distance$1;
			y += distance$1;
			textAlign = "right";
			break;
		case "insideBottomLeft":
			x += distance$1;
			y += height - distance$1;
			textVerticalAlign = "bottom";
			break;
		case "insideBottomRight":
			x += width - distance$1;
			y += height - distance$1;
			textAlign = "right";
			textVerticalAlign = "bottom";
			break;
	}
	out$1 = out$1 || {};
	out$1.x = x;
	out$1.y = y;
	out$1.align = textAlign;
	out$1.verticalAlign = textVerticalAlign;
	return out$1;
}
var STYLE_REG = /\{([a-zA-Z0-9_]+)\|([^}]*)\}/g;
function truncateText2(out$1, text, containerWidth, font, ellipsis, options) {
	if (!containerWidth) {
		out$1.text = "";
		out$1.isTruncated = false;
		return;
	}
	var textLines = (text + "").split("\n");
	options = prepareTruncateOptions(containerWidth, font, ellipsis, options);
	var isTruncated = false;
	var truncateOut = {};
	for (var i = 0, len$1 = textLines.length; i < len$1; i++) {
		truncateSingleLine(truncateOut, textLines[i], options);
		textLines[i] = truncateOut.textLine;
		isTruncated = isTruncated || truncateOut.isTruncated;
	}
	out$1.text = textLines.join("\n");
	out$1.isTruncated = isTruncated;
}
function prepareTruncateOptions(containerWidth, font, ellipsis, options) {
	options = options || {};
	var preparedOpts = extend({}, options);
	preparedOpts.font = font;
	ellipsis = retrieve2(ellipsis, "...");
	preparedOpts.maxIterations = retrieve2(options.maxIterations, 2);
	var minChar = preparedOpts.minChar = retrieve2(options.minChar, 0);
	preparedOpts.cnCharWidth = getWidth("国", font);
	var ascCharWidth = preparedOpts.ascCharWidth = getWidth("a", font);
	preparedOpts.placeholder = retrieve2(options.placeholder, "");
	var contentWidth = containerWidth = Math.max(0, containerWidth - 1);
	for (var i = 0; i < minChar && contentWidth >= ascCharWidth; i++) contentWidth -= ascCharWidth;
	var ellipsisWidth = getWidth(ellipsis, font);
	if (ellipsisWidth > contentWidth) {
		ellipsis = "";
		ellipsisWidth = 0;
	}
	contentWidth = containerWidth - ellipsisWidth;
	preparedOpts.ellipsis = ellipsis;
	preparedOpts.ellipsisWidth = ellipsisWidth;
	preparedOpts.contentWidth = contentWidth;
	preparedOpts.containerWidth = containerWidth;
	return preparedOpts;
}
function truncateSingleLine(out$1, textLine, options) {
	var containerWidth = options.containerWidth;
	var font = options.font;
	var contentWidth = options.contentWidth;
	if (!containerWidth) {
		out$1.textLine = "";
		out$1.isTruncated = false;
		return;
	}
	var lineWidth = getWidth(textLine, font);
	if (lineWidth <= containerWidth) {
		out$1.textLine = textLine;
		out$1.isTruncated = false;
		return;
	}
	for (var j = 0;; j++) {
		if (lineWidth <= contentWidth || j >= options.maxIterations) {
			textLine += options.ellipsis;
			break;
		}
		var subLength = j === 0 ? estimateLength(textLine, contentWidth, options.ascCharWidth, options.cnCharWidth) : lineWidth > 0 ? Math.floor(textLine.length * contentWidth / lineWidth) : 0;
		textLine = textLine.substr(0, subLength);
		lineWidth = getWidth(textLine, font);
	}
	if (textLine === "") textLine = options.placeholder;
	out$1.textLine = textLine;
	out$1.isTruncated = true;
}
function estimateLength(text, contentWidth, ascCharWidth, cnCharWidth) {
	var width = 0;
	var i = 0;
	for (var len$1 = text.length; i < len$1 && width < contentWidth; i++) {
		var charCode = text.charCodeAt(i);
		width += 0 <= charCode && charCode <= 127 ? ascCharWidth : cnCharWidth;
	}
	return i;
}
function parsePlainText(text, style) {
	text != null && (text += "");
	var overflow = style.overflow;
	var padding = style.padding;
	var font = style.font;
	var truncate = overflow === "truncate";
	var calculatedLineHeight = getLineHeight(font);
	var lineHeight = retrieve2(style.lineHeight, calculatedLineHeight);
	var bgColorDrawn = !!style.backgroundColor;
	var truncateLineOverflow = style.lineOverflow === "truncate";
	var isTruncated = false;
	var width = style.width;
	var lines;
	if (width != null && (overflow === "break" || overflow === "breakAll")) lines = text ? wrapText(text, style.font, width, overflow === "breakAll", 0).lines : [];
	else lines = text ? text.split("\n") : [];
	var contentHeight = lines.length * lineHeight;
	var height = retrieve2(style.height, contentHeight);
	if (contentHeight > height && truncateLineOverflow) {
		var lineCount = Math.floor(height / lineHeight);
		isTruncated = isTruncated || lines.length > lineCount;
		lines = lines.slice(0, lineCount);
	}
	if (text && truncate && width != null) {
		var options = prepareTruncateOptions(width, font, style.ellipsis, {
			minChar: style.truncateMinChar,
			placeholder: style.placeholder
		});
		var singleOut = {};
		for (var i = 0; i < lines.length; i++) {
			truncateSingleLine(singleOut, lines[i], options);
			lines[i] = singleOut.textLine;
			isTruncated = isTruncated || singleOut.isTruncated;
		}
	}
	var outerHeight = height;
	var contentWidth = 0;
	for (var i = 0; i < lines.length; i++) contentWidth = Math.max(getWidth(lines[i], font), contentWidth);
	if (width == null) width = contentWidth;
	var outerWidth = contentWidth;
	if (padding) {
		outerHeight += padding[0] + padding[2];
		outerWidth += padding[1] + padding[3];
		width += padding[1] + padding[3];
	}
	if (bgColorDrawn) outerWidth = width;
	return {
		lines,
		height,
		outerWidth,
		outerHeight,
		lineHeight,
		calculatedLineHeight,
		contentWidth,
		contentHeight,
		width,
		isTruncated
	};
}
var RichTextToken = function() {
	function RichTextToken$1() {}
	return RichTextToken$1;
}();
var RichTextLine = function() {
	function RichTextLine$1(tokens) {
		this.tokens = [];
		if (tokens) this.tokens = tokens;
	}
	return RichTextLine$1;
}();
var RichTextContentBlock = function() {
	function RichTextContentBlock$1() {
		this.width = 0;
		this.height = 0;
		this.contentWidth = 0;
		this.contentHeight = 0;
		this.outerWidth = 0;
		this.outerHeight = 0;
		this.lines = [];
		this.isTruncated = false;
	}
	return RichTextContentBlock$1;
}();
function parseRichText(text, style) {
	var contentBlock = new RichTextContentBlock();
	text != null && (text += "");
	if (!text) return contentBlock;
	var topWidth = style.width;
	var topHeight = style.height;
	var overflow = style.overflow;
	var wrapInfo = (overflow === "break" || overflow === "breakAll") && topWidth != null ? {
		width: topWidth,
		accumWidth: 0,
		breakAll: overflow === "breakAll"
	} : null;
	var lastIndex = STYLE_REG.lastIndex = 0;
	var result;
	while ((result = STYLE_REG.exec(text)) != null) {
		var matchedIndex = result.index;
		if (matchedIndex > lastIndex) pushTokens(contentBlock, text.substring(lastIndex, matchedIndex), style, wrapInfo);
		pushTokens(contentBlock, result[2], style, wrapInfo, result[1]);
		lastIndex = STYLE_REG.lastIndex;
	}
	if (lastIndex < text.length) pushTokens(contentBlock, text.substring(lastIndex, text.length), style, wrapInfo);
	var pendingList = [];
	var calculatedHeight = 0;
	var calculatedWidth = 0;
	var stlPadding = style.padding;
	var truncate = overflow === "truncate";
	var truncateLine = style.lineOverflow === "truncate";
	var tmpTruncateOut = {};
	function finishLine(line$1, lineWidth$1, lineHeight$1) {
		line$1.width = lineWidth$1;
		line$1.lineHeight = lineHeight$1;
		calculatedHeight += lineHeight$1;
		calculatedWidth = Math.max(calculatedWidth, lineWidth$1);
	}
	outer: for (var i = 0; i < contentBlock.lines.length; i++) {
		var line = contentBlock.lines[i];
		var lineHeight = 0;
		var lineWidth = 0;
		for (var j = 0; j < line.tokens.length; j++) {
			var token = line.tokens[j];
			var tokenStyle = token.styleName && style.rich[token.styleName] || {};
			var textPadding = token.textPadding = tokenStyle.padding;
			var paddingH = textPadding ? textPadding[1] + textPadding[3] : 0;
			var font = token.font = tokenStyle.font || style.font;
			token.contentHeight = getLineHeight(font);
			var tokenHeight = retrieve2(tokenStyle.height, token.contentHeight);
			token.innerHeight = tokenHeight;
			textPadding && (tokenHeight += textPadding[0] + textPadding[2]);
			token.height = tokenHeight;
			token.lineHeight = retrieve3(tokenStyle.lineHeight, style.lineHeight, tokenHeight);
			token.align = tokenStyle && tokenStyle.align || style.align;
			token.verticalAlign = tokenStyle && tokenStyle.verticalAlign || "middle";
			if (truncateLine && topHeight != null && calculatedHeight + token.lineHeight > topHeight) {
				var originalLength = contentBlock.lines.length;
				if (j > 0) {
					line.tokens = line.tokens.slice(0, j);
					finishLine(line, lineWidth, lineHeight);
					contentBlock.lines = contentBlock.lines.slice(0, i + 1);
				} else contentBlock.lines = contentBlock.lines.slice(0, i);
				contentBlock.isTruncated = contentBlock.isTruncated || contentBlock.lines.length < originalLength;
				break outer;
			}
			var styleTokenWidth = tokenStyle.width;
			var tokenWidthNotSpecified = styleTokenWidth == null || styleTokenWidth === "auto";
			if (typeof styleTokenWidth === "string" && styleTokenWidth.charAt(styleTokenWidth.length - 1) === "%") {
				token.percentWidth = styleTokenWidth;
				pendingList.push(token);
				token.contentWidth = getWidth(token.text, font);
			} else {
				if (tokenWidthNotSpecified) {
					var textBackgroundColor = tokenStyle.backgroundColor;
					var bgImg = textBackgroundColor && textBackgroundColor.image;
					if (bgImg) {
						bgImg = findExistImage(bgImg);
						if (isImageReady(bgImg)) token.width = Math.max(token.width, bgImg.width * tokenHeight / bgImg.height);
					}
				}
				var remainTruncWidth = truncate && topWidth != null ? topWidth - lineWidth : null;
				if (remainTruncWidth != null && remainTruncWidth < token.width) if (!tokenWidthNotSpecified || remainTruncWidth < paddingH) {
					token.text = "";
					token.width = token.contentWidth = 0;
				} else {
					truncateText2(tmpTruncateOut, token.text, remainTruncWidth - paddingH, font, style.ellipsis, { minChar: style.truncateMinChar });
					token.text = tmpTruncateOut.text;
					contentBlock.isTruncated = contentBlock.isTruncated || tmpTruncateOut.isTruncated;
					token.width = token.contentWidth = getWidth(token.text, font);
				}
				else token.contentWidth = getWidth(token.text, font);
			}
			token.width += paddingH;
			lineWidth += token.width;
			tokenStyle && (lineHeight = Math.max(lineHeight, token.lineHeight));
		}
		finishLine(line, lineWidth, lineHeight);
	}
	contentBlock.outerWidth = contentBlock.width = retrieve2(topWidth, calculatedWidth);
	contentBlock.outerHeight = contentBlock.height = retrieve2(topHeight, calculatedHeight);
	contentBlock.contentHeight = calculatedHeight;
	contentBlock.contentWidth = calculatedWidth;
	if (stlPadding) {
		contentBlock.outerWidth += stlPadding[1] + stlPadding[3];
		contentBlock.outerHeight += stlPadding[0] + stlPadding[2];
	}
	for (var i = 0; i < pendingList.length; i++) {
		var token = pendingList[i];
		var percentWidth = token.percentWidth;
		token.width = parseInt(percentWidth, 10) / 100 * contentBlock.width;
	}
	return contentBlock;
}
function pushTokens(block, str, style, wrapInfo, styleName) {
	var isEmptyStr = str === "";
	var tokenStyle = styleName && style.rich[styleName] || {};
	var lines = block.lines;
	var font = tokenStyle.font || style.font;
	var newLine = false;
	var strLines;
	var linesWidths;
	if (wrapInfo) {
		var tokenPadding = tokenStyle.padding;
		var tokenPaddingH = tokenPadding ? tokenPadding[1] + tokenPadding[3] : 0;
		if (tokenStyle.width != null && tokenStyle.width !== "auto") {
			var outerWidth_1 = parsePercent$1(tokenStyle.width, wrapInfo.width) + tokenPaddingH;
			if (lines.length > 0) {
				if (outerWidth_1 + wrapInfo.accumWidth > wrapInfo.width) {
					strLines = str.split("\n");
					newLine = true;
				}
			}
			wrapInfo.accumWidth = outerWidth_1;
		} else {
			var res = wrapText(str, font, wrapInfo.width, wrapInfo.breakAll, wrapInfo.accumWidth);
			wrapInfo.accumWidth = res.accumWidth + tokenPaddingH;
			linesWidths = res.linesWidths;
			strLines = res.lines;
		}
	} else strLines = str.split("\n");
	for (var i = 0; i < strLines.length; i++) {
		var text = strLines[i];
		var token = new RichTextToken();
		token.styleName = styleName;
		token.text = text;
		token.isLineHolder = !text && !isEmptyStr;
		if (typeof tokenStyle.width === "number") token.width = tokenStyle.width;
		else token.width = linesWidths ? linesWidths[i] : getWidth(text, font);
		if (!i && !newLine) {
			var tokens = (lines[lines.length - 1] || (lines[0] = new RichTextLine())).tokens;
			var tokensLen = tokens.length;
			tokensLen === 1 && tokens[0].isLineHolder ? tokens[0] = token : (text || !tokensLen || isEmptyStr) && tokens.push(token);
		} else lines.push(new RichTextLine([token]));
	}
}
function isAlphabeticLetter(ch) {
	var code = ch.charCodeAt(0);
	return code >= 32 && code <= 591 || code >= 880 && code <= 4351 || code >= 4608 && code <= 5119 || code >= 7680 && code <= 8303;
}
var breakCharMap = reduce(",&?/;] ".split(""), function(obj, ch) {
	obj[ch] = true;
	return obj;
}, {});
function isWordBreakChar(ch) {
	if (isAlphabeticLetter(ch)) {
		if (breakCharMap[ch]) return true;
		return false;
	}
	return true;
}
function wrapText(text, font, lineWidth, isBreakAll, lastAccumWidth) {
	var lines = [];
	var linesWidths = [];
	var line = "";
	var currentWord = "";
	var currentWordWidth = 0;
	var accumWidth = 0;
	for (var i = 0; i < text.length; i++) {
		var ch = text.charAt(i);
		if (ch === "\n") {
			if (currentWord) {
				line += currentWord;
				accumWidth += currentWordWidth;
			}
			lines.push(line);
			linesWidths.push(accumWidth);
			line = "";
			currentWord = "";
			currentWordWidth = 0;
			accumWidth = 0;
			continue;
		}
		var chWidth = getWidth(ch, font);
		var inWord = isBreakAll ? false : !isWordBreakChar(ch);
		if (!lines.length ? lastAccumWidth + accumWidth + chWidth > lineWidth : accumWidth + chWidth > lineWidth) {
			if (!accumWidth) if (inWord) {
				lines.push(currentWord);
				linesWidths.push(currentWordWidth);
				currentWord = ch;
				currentWordWidth = chWidth;
			} else {
				lines.push(ch);
				linesWidths.push(chWidth);
			}
			else if (line || currentWord) if (inWord) {
				if (!line) {
					line = currentWord;
					currentWord = "";
					currentWordWidth = 0;
					accumWidth = currentWordWidth;
				}
				lines.push(line);
				linesWidths.push(accumWidth - currentWordWidth);
				currentWord += ch;
				currentWordWidth += chWidth;
				line = "";
				accumWidth = currentWordWidth;
			} else {
				if (currentWord) {
					line += currentWord;
					currentWord = "";
					currentWordWidth = 0;
				}
				lines.push(line);
				linesWidths.push(accumWidth);
				line = ch;
				accumWidth = chWidth;
			}
			continue;
		}
		accumWidth += chWidth;
		if (inWord) {
			currentWord += ch;
			currentWordWidth += chWidth;
		} else {
			if (currentWord) {
				line += currentWord;
				currentWord = "";
				currentWordWidth = 0;
			}
			line += ch;
		}
	}
	if (!lines.length && !line) {
		line = text;
		currentWord = "";
		currentWordWidth = 0;
	}
	if (currentWord) line += currentWord;
	if (line) {
		lines.push(line);
		linesWidths.push(accumWidth);
	}
	if (lines.length === 1) accumWidth += lastAccumWidth;
	return {
		accumWidth,
		lines,
		linesWidths
	};
}
function create(x, y) {
	if (x == null) x = 0;
	if (y == null) y = 0;
	return [x, y];
}
function clone$1(v) {
	return [v[0], v[1]];
}
function add(out$1, v1, v2) {
	out$1[0] = v1[0] + v2[0];
	out$1[1] = v1[1] + v2[1];
	return out$1;
}
function sub(out$1, v1, v2) {
	out$1[0] = v1[0] - v2[0];
	out$1[1] = v1[1] - v2[1];
	return out$1;
}
function len(v) {
	return Math.sqrt(lenSquare(v));
}
function lenSquare(v) {
	return v[0] * v[0] + v[1] * v[1];
}
function scale$1(out$1, v, s) {
	out$1[0] = v[0] * s;
	out$1[1] = v[1] * s;
	return out$1;
}
function normalize$1(out$1, v) {
	var d = len(v);
	if (d === 0) {
		out$1[0] = 0;
		out$1[1] = 0;
	} else {
		out$1[0] = v[0] / d;
		out$1[1] = v[1] / d;
	}
	return out$1;
}
function distance(v1, v2) {
	return Math.sqrt((v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]));
}
var dist$1 = distance;
function distanceSquare(v1, v2) {
	return (v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]);
}
var distSquare = distanceSquare;
function applyTransform$1(out$1, v, m$1) {
	var x = v[0];
	var y = v[1];
	out$1[0] = m$1[0] * x + m$1[2] * y + m$1[4];
	out$1[1] = m$1[1] * x + m$1[3] * y + m$1[5];
	return out$1;
}
function min$1(out$1, v1, v2) {
	out$1[0] = Math.min(v1[0], v2[0]);
	out$1[1] = Math.min(v1[1], v2[1]);
	return out$1;
}
function max$1(out$1, v1, v2) {
	out$1[0] = Math.max(v1[0], v2[0]);
	out$1[1] = Math.max(v1[1], v2[1]);
	return out$1;
}
var mIdentity = identity;
var EPSILON$2 = 5e-5;
function isNotAroundZero$1(val) {
	return val > EPSILON$2 || val < -EPSILON$2;
}
var scaleTmp = [];
var tmpTransform = [];
var originTransform = create$1();
var abs = Math.abs;
var Transformable = function() {
	function Transformable$1() {}
	Transformable$1.prototype.getLocalTransform = function(m$1) {
		return Transformable$1.getLocalTransform(this, m$1);
	};
	Transformable$1.prototype.setPosition = function(arr) {
		this.x = arr[0];
		this.y = arr[1];
	};
	Transformable$1.prototype.setScale = function(arr) {
		this.scaleX = arr[0];
		this.scaleY = arr[1];
	};
	Transformable$1.prototype.setSkew = function(arr) {
		this.skewX = arr[0];
		this.skewY = arr[1];
	};
	Transformable$1.prototype.setOrigin = function(arr) {
		this.originX = arr[0];
		this.originY = arr[1];
	};
	Transformable$1.prototype.needLocalTransform = function() {
		return isNotAroundZero$1(this.rotation) || isNotAroundZero$1(this.x) || isNotAroundZero$1(this.y) || isNotAroundZero$1(this.scaleX - 1) || isNotAroundZero$1(this.scaleY - 1) || isNotAroundZero$1(this.skewX) || isNotAroundZero$1(this.skewY);
	};
	Transformable$1.prototype.updateTransform = function() {
		var parentTransform = this.parent && this.parent.transform;
		var needLocalTransform = this.needLocalTransform();
		var m$1 = this.transform;
		if (!(needLocalTransform || parentTransform)) {
			if (m$1) {
				mIdentity(m$1);
				this.invTransform = null;
			}
			return;
		}
		m$1 = m$1 || create$1();
		if (needLocalTransform) this.getLocalTransform(m$1);
		else mIdentity(m$1);
		if (parentTransform) if (needLocalTransform) mul(m$1, parentTransform, m$1);
		else copy(m$1, parentTransform);
		this.transform = m$1;
		this._resolveGlobalScaleRatio(m$1);
	};
	Transformable$1.prototype._resolveGlobalScaleRatio = function(m$1) {
		var globalScaleRatio = this.globalScaleRatio;
		if (globalScaleRatio != null && globalScaleRatio !== 1) {
			this.getGlobalScale(scaleTmp);
			var relX = scaleTmp[0] < 0 ? -1 : 1;
			var relY = scaleTmp[1] < 0 ? -1 : 1;
			var sx = ((scaleTmp[0] - relX) * globalScaleRatio + relX) / scaleTmp[0] || 0;
			var sy = ((scaleTmp[1] - relY) * globalScaleRatio + relY) / scaleTmp[1] || 0;
			m$1[0] *= sx;
			m$1[1] *= sx;
			m$1[2] *= sy;
			m$1[3] *= sy;
		}
		this.invTransform = this.invTransform || create$1();
		invert(this.invTransform, m$1);
	};
	Transformable$1.prototype.getComputedTransform = function() {
		var transformNode = this;
		var ancestors = [];
		while (transformNode) {
			ancestors.push(transformNode);
			transformNode = transformNode.parent;
		}
		while (transformNode = ancestors.pop()) transformNode.updateTransform();
		return this.transform;
	};
	Transformable$1.prototype.setLocalTransform = function(m$1) {
		if (!m$1) return;
		var sx = m$1[0] * m$1[0] + m$1[1] * m$1[1];
		var sy = m$1[2] * m$1[2] + m$1[3] * m$1[3];
		var rotation = Math.atan2(m$1[1], m$1[0]);
		var shearX = Math.PI / 2 + rotation - Math.atan2(m$1[3], m$1[2]);
		sy = Math.sqrt(sy) * Math.cos(shearX);
		sx = Math.sqrt(sx);
		this.skewX = shearX;
		this.skewY = 0;
		this.rotation = -rotation;
		this.x = +m$1[4];
		this.y = +m$1[5];
		this.scaleX = sx;
		this.scaleY = sy;
		this.originX = 0;
		this.originY = 0;
	};
	Transformable$1.prototype.decomposeTransform = function() {
		if (!this.transform) return;
		var parent = this.parent;
		var m$1 = this.transform;
		if (parent && parent.transform) {
			parent.invTransform = parent.invTransform || create$1();
			mul(tmpTransform, parent.invTransform, m$1);
			m$1 = tmpTransform;
		}
		var ox = this.originX;
		var oy = this.originY;
		if (ox || oy) {
			originTransform[4] = ox;
			originTransform[5] = oy;
			mul(tmpTransform, m$1, originTransform);
			tmpTransform[4] -= ox;
			tmpTransform[5] -= oy;
			m$1 = tmpTransform;
		}
		this.setLocalTransform(m$1);
	};
	Transformable$1.prototype.getGlobalScale = function(out$1) {
		var m$1 = this.transform;
		out$1 = out$1 || [];
		if (!m$1) {
			out$1[0] = 1;
			out$1[1] = 1;
			return out$1;
		}
		out$1[0] = Math.sqrt(m$1[0] * m$1[0] + m$1[1] * m$1[1]);
		out$1[1] = Math.sqrt(m$1[2] * m$1[2] + m$1[3] * m$1[3]);
		if (m$1[0] < 0) out$1[0] = -out$1[0];
		if (m$1[3] < 0) out$1[1] = -out$1[1];
		return out$1;
	};
	Transformable$1.prototype.transformCoordToLocal = function(x, y) {
		var v2 = [x, y];
		var invTransform = this.invTransform;
		if (invTransform) applyTransform$1(v2, v2, invTransform);
		return v2;
	};
	Transformable$1.prototype.transformCoordToGlobal = function(x, y) {
		var v2 = [x, y];
		var transform = this.transform;
		if (transform) applyTransform$1(v2, v2, transform);
		return v2;
	};
	Transformable$1.prototype.getLineScale = function() {
		var m$1 = this.transform;
		return m$1 && abs(m$1[0] - 1) > 1e-10 && abs(m$1[3] - 1) > 1e-10 ? Math.sqrt(abs(m$1[0] * m$1[3] - m$1[2] * m$1[1])) : 1;
	};
	Transformable$1.prototype.copyTransform = function(source) {
		copyTransform(this, source);
	};
	Transformable$1.getLocalTransform = function(target, m$1) {
		m$1 = m$1 || [];
		var ox = target.originX || 0;
		var oy = target.originY || 0;
		var sx = target.scaleX;
		var sy = target.scaleY;
		var ax = target.anchorX;
		var ay = target.anchorY;
		var rotation = target.rotation || 0;
		var x = target.x;
		var y = target.y;
		var skewX = target.skewX ? Math.tan(target.skewX) : 0;
		var skewY = target.skewY ? Math.tan(-target.skewY) : 0;
		if (ox || oy || ax || ay) {
			var dx = ox + ax;
			var dy = oy + ay;
			m$1[4] = -dx * sx - skewX * dy * sy;
			m$1[5] = -dy * sy - skewY * dx * sx;
		} else m$1[4] = m$1[5] = 0;
		m$1[0] = sx;
		m$1[3] = sy;
		m$1[1] = skewY * sx;
		m$1[2] = skewX * sy;
		rotation && rotate(m$1, m$1, rotation);
		m$1[4] += ox + x;
		m$1[5] += oy + y;
		return m$1;
	};
	Transformable$1.initDefaultProps = function() {
		var proto$1 = Transformable$1.prototype;
		proto$1.scaleX = proto$1.scaleY = proto$1.globalScaleRatio = 1;
		proto$1.x = proto$1.y = proto$1.originX = proto$1.originY = proto$1.skewX = proto$1.skewY = proto$1.rotation = proto$1.anchorX = proto$1.anchorY = 0;
	}();
	return Transformable$1;
}();
var TRANSFORMABLE_PROPS = [
	"x",
	"y",
	"originX",
	"originY",
	"anchorX",
	"anchorY",
	"rotation",
	"scaleX",
	"scaleY",
	"skewX",
	"skewY"
];
function copyTransform(target, source) {
	for (var i = 0; i < TRANSFORMABLE_PROPS.length; i++) {
		var propName = TRANSFORMABLE_PROPS[i];
		target[propName] = source[propName];
	}
}
var Transformable_default = Transformable;
var easingFuncs = {
	linear: function(k) {
		return k;
	},
	quadraticIn: function(k) {
		return k * k;
	},
	quadraticOut: function(k) {
		return k * (2 - k);
	},
	quadraticInOut: function(k) {
		if ((k *= 2) < 1) return .5 * k * k;
		return -.5 * (--k * (k - 2) - 1);
	},
	cubicIn: function(k) {
		return k * k * k;
	},
	cubicOut: function(k) {
		return --k * k * k + 1;
	},
	cubicInOut: function(k) {
		if ((k *= 2) < 1) return .5 * k * k * k;
		return .5 * ((k -= 2) * k * k + 2);
	},
	quarticIn: function(k) {
		return k * k * k * k;
	},
	quarticOut: function(k) {
		return 1 - --k * k * k * k;
	},
	quarticInOut: function(k) {
		if ((k *= 2) < 1) return .5 * k * k * k * k;
		return -.5 * ((k -= 2) * k * k * k - 2);
	},
	quinticIn: function(k) {
		return k * k * k * k * k;
	},
	quinticOut: function(k) {
		return --k * k * k * k * k + 1;
	},
	quinticInOut: function(k) {
		if ((k *= 2) < 1) return .5 * k * k * k * k * k;
		return .5 * ((k -= 2) * k * k * k * k + 2);
	},
	sinusoidalIn: function(k) {
		return 1 - Math.cos(k * Math.PI / 2);
	},
	sinusoidalOut: function(k) {
		return Math.sin(k * Math.PI / 2);
	},
	sinusoidalInOut: function(k) {
		return .5 * (1 - Math.cos(Math.PI * k));
	},
	exponentialIn: function(k) {
		return k === 0 ? 0 : Math.pow(1024, k - 1);
	},
	exponentialOut: function(k) {
		return k === 1 ? 1 : 1 - Math.pow(2, -10 * k);
	},
	exponentialInOut: function(k) {
		if (k === 0) return 0;
		if (k === 1) return 1;
		if ((k *= 2) < 1) return .5 * Math.pow(1024, k - 1);
		return .5 * (-Math.pow(2, -10 * (k - 1)) + 2);
	},
	circularIn: function(k) {
		return 1 - Math.sqrt(1 - k * k);
	},
	circularOut: function(k) {
		return Math.sqrt(1 - --k * k);
	},
	circularInOut: function(k) {
		if ((k *= 2) < 1) return -.5 * (Math.sqrt(1 - k * k) - 1);
		return .5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
	},
	elasticIn: function(k) {
		var s;
		var a = .1;
		var p = .4;
		if (k === 0) return 0;
		if (k === 1) return 1;
		if (!a || a < 1) {
			a = 1;
			s = p / 4;
		} else s = p * Math.asin(1 / a) / (2 * Math.PI);
		return -(a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
	},
	elasticOut: function(k) {
		var s;
		var a = .1;
		var p = .4;
		if (k === 0) return 0;
		if (k === 1) return 1;
		if (!a || a < 1) {
			a = 1;
			s = p / 4;
		} else s = p * Math.asin(1 / a) / (2 * Math.PI);
		return a * Math.pow(2, -10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1;
	},
	elasticInOut: function(k) {
		var s;
		var a = .1;
		var p = .4;
		if (k === 0) return 0;
		if (k === 1) return 1;
		if (!a || a < 1) {
			a = 1;
			s = p / 4;
		} else s = p * Math.asin(1 / a) / (2 * Math.PI);
		if ((k *= 2) < 1) return -.5 * (a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
		return a * Math.pow(2, -10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * .5 + 1;
	},
	backIn: function(k) {
		var s = 1.70158;
		return k * k * ((s + 1) * k - s);
	},
	backOut: function(k) {
		var s = 1.70158;
		return --k * k * ((s + 1) * k + s) + 1;
	},
	backInOut: function(k) {
		var s = 1.70158 * 1.525;
		if ((k *= 2) < 1) return .5 * (k * k * ((s + 1) * k - s));
		return .5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
	},
	bounceIn: function(k) {
		return 1 - easingFuncs.bounceOut(1 - k);
	},
	bounceOut: function(k) {
		if (k < 1 / 2.75) return 7.5625 * k * k;
		else if (k < 2 / 2.75) return 7.5625 * (k -= 1.5 / 2.75) * k + .75;
		else if (k < 2.5 / 2.75) return 7.5625 * (k -= 2.25 / 2.75) * k + .9375;
		else return 7.5625 * (k -= 2.625 / 2.75) * k + .984375;
	},
	bounceInOut: function(k) {
		if (k < .5) return easingFuncs.bounceIn(k * 2) * .5;
		return easingFuncs.bounceOut(k * 2 - 1) * .5 + .5;
	}
};
var easing_default = easingFuncs;
var mathPow$1 = Math.pow;
var mathSqrt$3 = Math.sqrt;
var EPSILON$1 = 1e-8;
var EPSILON_NUMERIC = 1e-4;
var THREE_SQRT = mathSqrt$3(3);
var ONE_THIRD = 1 / 3;
var _v0 = create();
var _v1 = create();
var _v2 = create();
function isAroundZero(val) {
	return val > -EPSILON$1 && val < EPSILON$1;
}
function isNotAroundZero(val) {
	return val > EPSILON$1 || val < -EPSILON$1;
}
function cubicAt(p0, p1, p2, p3, t) {
	var onet = 1 - t;
	return onet * onet * (onet * p0 + 3 * t * p1) + t * t * (t * p3 + 3 * onet * p2);
}
function cubicDerivativeAt(p0, p1, p2, p3, t) {
	var onet = 1 - t;
	return 3 * (((p1 - p0) * onet + 2 * (p2 - p1) * t) * onet + (p3 - p2) * t * t);
}
function cubicRootAt(p0, p1, p2, p3, val, roots$1) {
	var a = p3 + 3 * (p1 - p2) - p0;
	var b = 3 * (p2 - p1 * 2 + p0);
	var c = 3 * (p1 - p0);
	var d = p0 - val;
	var A = b * b - 3 * a * c;
	var B = b * c - 9 * a * d;
	var C = c * c - 3 * b * d;
	var n = 0;
	if (isAroundZero(A) && isAroundZero(B)) if (isAroundZero(b)) roots$1[0] = 0;
	else {
		var t1 = -c / b;
		if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
	}
	else {
		var disc = B * B - 4 * A * C;
		if (isAroundZero(disc)) {
			var K = B / A;
			var t1 = -b / a + K;
			var t2 = -K / 2;
			if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
			if (t2 >= 0 && t2 <= 1) roots$1[n++] = t2;
		} else if (disc > 0) {
			var discSqrt = mathSqrt$3(disc);
			var Y1 = A * b + 1.5 * a * (-B + discSqrt);
			var Y2 = A * b + 1.5 * a * (-B - discSqrt);
			if (Y1 < 0) Y1 = -mathPow$1(-Y1, ONE_THIRD);
			else Y1 = mathPow$1(Y1, ONE_THIRD);
			if (Y2 < 0) Y2 = -mathPow$1(-Y2, ONE_THIRD);
			else Y2 = mathPow$1(Y2, ONE_THIRD);
			var t1 = (-b - (Y1 + Y2)) / (3 * a);
			if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
		} else {
			var T = (2 * A * b - 3 * a * B) / (2 * mathSqrt$3(A * A * A));
			var theta = Math.acos(T) / 3;
			var ASqrt = mathSqrt$3(A);
			var tmp = Math.cos(theta);
			var t1 = (-b - 2 * ASqrt * tmp) / (3 * a);
			var t2 = (-b + ASqrt * (tmp + THREE_SQRT * Math.sin(theta))) / (3 * a);
			var t3 = (-b + ASqrt * (tmp - THREE_SQRT * Math.sin(theta))) / (3 * a);
			if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
			if (t2 >= 0 && t2 <= 1) roots$1[n++] = t2;
			if (t3 >= 0 && t3 <= 1) roots$1[n++] = t3;
		}
	}
	return n;
}
function cubicExtrema(p0, p1, p2, p3, extrema$1) {
	var b = 6 * p2 - 12 * p1 + 6 * p0;
	var a = 9 * p1 + 3 * p3 - 3 * p0 - 9 * p2;
	var c = 3 * p1 - 3 * p0;
	var n = 0;
	if (isAroundZero(a)) {
		if (isNotAroundZero(b)) {
			var t1 = -c / b;
			if (t1 >= 0 && t1 <= 1) extrema$1[n++] = t1;
		}
	} else {
		var disc = b * b - 4 * a * c;
		if (isAroundZero(disc)) extrema$1[0] = -b / (2 * a);
		else if (disc > 0) {
			var discSqrt = mathSqrt$3(disc);
			var t1 = (-b + discSqrt) / (2 * a);
			var t2 = (-b - discSqrt) / (2 * a);
			if (t1 >= 0 && t1 <= 1) extrema$1[n++] = t1;
			if (t2 >= 0 && t2 <= 1) extrema$1[n++] = t2;
		}
	}
	return n;
}
function cubicSubdivide(p0, p1, p2, p3, t, out$1) {
	var p01 = (p1 - p0) * t + p0;
	var p12 = (p2 - p1) * t + p1;
	var p23 = (p3 - p2) * t + p2;
	var p012 = (p12 - p01) * t + p01;
	var p123 = (p23 - p12) * t + p12;
	var p0123 = (p123 - p012) * t + p012;
	out$1[0] = p0;
	out$1[1] = p01;
	out$1[2] = p012;
	out$1[3] = p0123;
	out$1[4] = p0123;
	out$1[5] = p123;
	out$1[6] = p23;
	out$1[7] = p3;
}
function cubicProjectPoint(x0, y0, x1, y1, x2, y2, x3, y3, x, y, out$1) {
	var t;
	var interval = .005;
	var d = Infinity;
	var prev;
	var next;
	var d1;
	var d2;
	_v0[0] = x;
	_v0[1] = y;
	for (var _t = 0; _t < 1; _t += .05) {
		_v1[0] = cubicAt(x0, x1, x2, x3, _t);
		_v1[1] = cubicAt(y0, y1, y2, y3, _t);
		d1 = distSquare(_v0, _v1);
		if (d1 < d) {
			t = _t;
			d = d1;
		}
	}
	d = Infinity;
	for (var i = 0; i < 32; i++) {
		if (interval < EPSILON_NUMERIC) break;
		prev = t - interval;
		next = t + interval;
		_v1[0] = cubicAt(x0, x1, x2, x3, prev);
		_v1[1] = cubicAt(y0, y1, y2, y3, prev);
		d1 = distSquare(_v1, _v0);
		if (prev >= 0 && d1 < d) {
			t = prev;
			d = d1;
		} else {
			_v2[0] = cubicAt(x0, x1, x2, x3, next);
			_v2[1] = cubicAt(y0, y1, y2, y3, next);
			d2 = distSquare(_v2, _v0);
			if (next <= 1 && d2 < d) {
				t = next;
				d = d2;
			} else interval *= .5;
		}
	}
	if (out$1) {
		out$1[0] = cubicAt(x0, x1, x2, x3, t);
		out$1[1] = cubicAt(y0, y1, y2, y3, t);
	}
	return mathSqrt$3(d);
}
function cubicLength(x0, y0, x1, y1, x2, y2, x3, y3, iteration) {
	var px = x0;
	var py = y0;
	var d = 0;
	var step = 1 / iteration;
	for (var i = 1; i <= iteration; i++) {
		var t = i * step;
		var x = cubicAt(x0, x1, x2, x3, t);
		var y = cubicAt(y0, y1, y2, y3, t);
		var dx = x - px;
		var dy = y - py;
		d += Math.sqrt(dx * dx + dy * dy);
		px = x;
		py = y;
	}
	return d;
}
function quadraticAt(p0, p1, p2, t) {
	var onet = 1 - t;
	return onet * (onet * p0 + 2 * t * p1) + t * t * p2;
}
function quadraticDerivativeAt(p0, p1, p2, t) {
	return 2 * ((1 - t) * (p1 - p0) + t * (p2 - p1));
}
function quadraticRootAt(p0, p1, p2, val, roots$1) {
	var a = p0 - 2 * p1 + p2;
	var b = 2 * (p1 - p0);
	var c = p0 - val;
	var n = 0;
	if (isAroundZero(a)) {
		if (isNotAroundZero(b)) {
			var t1 = -c / b;
			if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
		}
	} else {
		var disc = b * b - 4 * a * c;
		if (isAroundZero(disc)) {
			var t1 = -b / (2 * a);
			if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
		} else if (disc > 0) {
			var discSqrt = mathSqrt$3(disc);
			var t1 = (-b + discSqrt) / (2 * a);
			var t2 = (-b - discSqrt) / (2 * a);
			if (t1 >= 0 && t1 <= 1) roots$1[n++] = t1;
			if (t2 >= 0 && t2 <= 1) roots$1[n++] = t2;
		}
	}
	return n;
}
function quadraticExtremum(p0, p1, p2) {
	var divider = p0 + p2 - 2 * p1;
	if (divider === 0) return .5;
	else return (p0 - p1) / divider;
}
function quadraticSubdivide(p0, p1, p2, t, out$1) {
	var p01 = (p1 - p0) * t + p0;
	var p12 = (p2 - p1) * t + p1;
	var p012 = (p12 - p01) * t + p01;
	out$1[0] = p0;
	out$1[1] = p01;
	out$1[2] = p012;
	out$1[3] = p012;
	out$1[4] = p12;
	out$1[5] = p2;
}
function quadraticProjectPoint(x0, y0, x1, y1, x2, y2, x, y, out$1) {
	var t;
	var interval = .005;
	var d = Infinity;
	_v0[0] = x;
	_v0[1] = y;
	for (var _t = 0; _t < 1; _t += .05) {
		_v1[0] = quadraticAt(x0, x1, x2, _t);
		_v1[1] = quadraticAt(y0, y1, y2, _t);
		var d1 = distSquare(_v0, _v1);
		if (d1 < d) {
			t = _t;
			d = d1;
		}
	}
	d = Infinity;
	for (var i = 0; i < 32; i++) {
		if (interval < EPSILON_NUMERIC) break;
		var prev = t - interval;
		var next = t + interval;
		_v1[0] = quadraticAt(x0, x1, x2, prev);
		_v1[1] = quadraticAt(y0, y1, y2, prev);
		var d1 = distSquare(_v1, _v0);
		if (prev >= 0 && d1 < d) {
			t = prev;
			d = d1;
		} else {
			_v2[0] = quadraticAt(x0, x1, x2, next);
			_v2[1] = quadraticAt(y0, y1, y2, next);
			var d2 = distSquare(_v2, _v0);
			if (next <= 1 && d2 < d) {
				t = next;
				d = d2;
			} else interval *= .5;
		}
	}
	if (out$1) {
		out$1[0] = quadraticAt(x0, x1, x2, t);
		out$1[1] = quadraticAt(y0, y1, y2, t);
	}
	return mathSqrt$3(d);
}
function quadraticLength(x0, y0, x1, y1, x2, y2, iteration) {
	var px = x0;
	var py = y0;
	var d = 0;
	var step = 1 / iteration;
	for (var i = 1; i <= iteration; i++) {
		var t = i * step;
		var x = quadraticAt(x0, x1, x2, t);
		var y = quadraticAt(y0, y1, y2, t);
		var dx = x - px;
		var dy = y - py;
		d += Math.sqrt(dx * dx + dy * dy);
		px = x;
		py = y;
	}
	return d;
}
var regexp = /cubic-bezier\(([0-9,\.e ]+)\)/;
function createCubicEasingFunc(cubicEasingStr) {
	var cubic = cubicEasingStr && regexp.exec(cubicEasingStr);
	if (cubic) {
		var points$1 = cubic[1].split(",");
		var a_1 = +trim(points$1[0]);
		var b_1 = +trim(points$1[1]);
		var c_1 = +trim(points$1[2]);
		var d_1 = +trim(points$1[3]);
		if (isNaN(a_1 + b_1 + c_1 + d_1)) return;
		var roots_1 = [];
		return function(p) {
			return p <= 0 ? 0 : p >= 1 ? 1 : cubicRootAt(0, a_1, c_1, 1, p, roots_1) && cubicAt(0, b_1, d_1, 1, roots_1[0]);
		};
	}
}
var Clip = function() {
	function Clip$1(opts) {
		this._inited = false;
		this._startTime = 0;
		this._pausedTime = 0;
		this._paused = false;
		this._life = opts.life || 1e3;
		this._delay = opts.delay || 0;
		this.loop = opts.loop || false;
		this.onframe = opts.onframe || noop;
		this.ondestroy = opts.ondestroy || noop;
		this.onrestart = opts.onrestart || noop;
		opts.easing && this.setEasing(opts.easing);
	}
	Clip$1.prototype.step = function(globalTime, deltaTime) {
		if (!this._inited) {
			this._startTime = globalTime + this._delay;
			this._inited = true;
		}
		if (this._paused) {
			this._pausedTime += deltaTime;
			return;
		}
		var life = this._life;
		var elapsedTime = globalTime - this._startTime - this._pausedTime;
		var percent = elapsedTime / life;
		if (percent < 0) percent = 0;
		percent = Math.min(percent, 1);
		var easingFunc = this.easingFunc;
		var schedule = easingFunc ? easingFunc(percent) : percent;
		this.onframe(schedule);
		if (percent === 1) if (this.loop) {
			var remainder = elapsedTime % life;
			this._startTime = globalTime - remainder;
			this._pausedTime = 0;
			this.onrestart();
		} else return true;
		return false;
	};
	Clip$1.prototype.pause = function() {
		this._paused = true;
	};
	Clip$1.prototype.resume = function() {
		this._paused = false;
	};
	Clip$1.prototype.setEasing = function(easing) {
		this.easing = easing;
		this.easingFunc = isFunction(easing) ? easing : easing_default[easing] || createCubicEasingFunc(easing);
	};
	return Clip$1;
}();
var Clip_default = Clip;
var kCSSColorTable = {
	"transparent": [
		0,
		0,
		0,
		0
	],
	"aliceblue": [
		240,
		248,
		255,
		1
	],
	"antiquewhite": [
		250,
		235,
		215,
		1
	],
	"aqua": [
		0,
		255,
		255,
		1
	],
	"aquamarine": [
		127,
		255,
		212,
		1
	],
	"azure": [
		240,
		255,
		255,
		1
	],
	"beige": [
		245,
		245,
		220,
		1
	],
	"bisque": [
		255,
		228,
		196,
		1
	],
	"black": [
		0,
		0,
		0,
		1
	],
	"blanchedalmond": [
		255,
		235,
		205,
		1
	],
	"blue": [
		0,
		0,
		255,
		1
	],
	"blueviolet": [
		138,
		43,
		226,
		1
	],
	"brown": [
		165,
		42,
		42,
		1
	],
	"burlywood": [
		222,
		184,
		135,
		1
	],
	"cadetblue": [
		95,
		158,
		160,
		1
	],
	"chartreuse": [
		127,
		255,
		0,
		1
	],
	"chocolate": [
		210,
		105,
		30,
		1
	],
	"coral": [
		255,
		127,
		80,
		1
	],
	"cornflowerblue": [
		100,
		149,
		237,
		1
	],
	"cornsilk": [
		255,
		248,
		220,
		1
	],
	"crimson": [
		220,
		20,
		60,
		1
	],
	"cyan": [
		0,
		255,
		255,
		1
	],
	"darkblue": [
		0,
		0,
		139,
		1
	],
	"darkcyan": [
		0,
		139,
		139,
		1
	],
	"darkgoldenrod": [
		184,
		134,
		11,
		1
	],
	"darkgray": [
		169,
		169,
		169,
		1
	],
	"darkgreen": [
		0,
		100,
		0,
		1
	],
	"darkgrey": [
		169,
		169,
		169,
		1
	],
	"darkkhaki": [
		189,
		183,
		107,
		1
	],
	"darkmagenta": [
		139,
		0,
		139,
		1
	],
	"darkolivegreen": [
		85,
		107,
		47,
		1
	],
	"darkorange": [
		255,
		140,
		0,
		1
	],
	"darkorchid": [
		153,
		50,
		204,
		1
	],
	"darkred": [
		139,
		0,
		0,
		1
	],
	"darksalmon": [
		233,
		150,
		122,
		1
	],
	"darkseagreen": [
		143,
		188,
		143,
		1
	],
	"darkslateblue": [
		72,
		61,
		139,
		1
	],
	"darkslategray": [
		47,
		79,
		79,
		1
	],
	"darkslategrey": [
		47,
		79,
		79,
		1
	],
	"darkturquoise": [
		0,
		206,
		209,
		1
	],
	"darkviolet": [
		148,
		0,
		211,
		1
	],
	"deeppink": [
		255,
		20,
		147,
		1
	],
	"deepskyblue": [
		0,
		191,
		255,
		1
	],
	"dimgray": [
		105,
		105,
		105,
		1
	],
	"dimgrey": [
		105,
		105,
		105,
		1
	],
	"dodgerblue": [
		30,
		144,
		255,
		1
	],
	"firebrick": [
		178,
		34,
		34,
		1
	],
	"floralwhite": [
		255,
		250,
		240,
		1
	],
	"forestgreen": [
		34,
		139,
		34,
		1
	],
	"fuchsia": [
		255,
		0,
		255,
		1
	],
	"gainsboro": [
		220,
		220,
		220,
		1
	],
	"ghostwhite": [
		248,
		248,
		255,
		1
	],
	"gold": [
		255,
		215,
		0,
		1
	],
	"goldenrod": [
		218,
		165,
		32,
		1
	],
	"gray": [
		128,
		128,
		128,
		1
	],
	"green": [
		0,
		128,
		0,
		1
	],
	"greenyellow": [
		173,
		255,
		47,
		1
	],
	"grey": [
		128,
		128,
		128,
		1
	],
	"honeydew": [
		240,
		255,
		240,
		1
	],
	"hotpink": [
		255,
		105,
		180,
		1
	],
	"indianred": [
		205,
		92,
		92,
		1
	],
	"indigo": [
		75,
		0,
		130,
		1
	],
	"ivory": [
		255,
		255,
		240,
		1
	],
	"khaki": [
		240,
		230,
		140,
		1
	],
	"lavender": [
		230,
		230,
		250,
		1
	],
	"lavenderblush": [
		255,
		240,
		245,
		1
	],
	"lawngreen": [
		124,
		252,
		0,
		1
	],
	"lemonchiffon": [
		255,
		250,
		205,
		1
	],
	"lightblue": [
		173,
		216,
		230,
		1
	],
	"lightcoral": [
		240,
		128,
		128,
		1
	],
	"lightcyan": [
		224,
		255,
		255,
		1
	],
	"lightgoldenrodyellow": [
		250,
		250,
		210,
		1
	],
	"lightgray": [
		211,
		211,
		211,
		1
	],
	"lightgreen": [
		144,
		238,
		144,
		1
	],
	"lightgrey": [
		211,
		211,
		211,
		1
	],
	"lightpink": [
		255,
		182,
		193,
		1
	],
	"lightsalmon": [
		255,
		160,
		122,
		1
	],
	"lightseagreen": [
		32,
		178,
		170,
		1
	],
	"lightskyblue": [
		135,
		206,
		250,
		1
	],
	"lightslategray": [
		119,
		136,
		153,
		1
	],
	"lightslategrey": [
		119,
		136,
		153,
		1
	],
	"lightsteelblue": [
		176,
		196,
		222,
		1
	],
	"lightyellow": [
		255,
		255,
		224,
		1
	],
	"lime": [
		0,
		255,
		0,
		1
	],
	"limegreen": [
		50,
		205,
		50,
		1
	],
	"linen": [
		250,
		240,
		230,
		1
	],
	"magenta": [
		255,
		0,
		255,
		1
	],
	"maroon": [
		128,
		0,
		0,
		1
	],
	"mediumaquamarine": [
		102,
		205,
		170,
		1
	],
	"mediumblue": [
		0,
		0,
		205,
		1
	],
	"mediumorchid": [
		186,
		85,
		211,
		1
	],
	"mediumpurple": [
		147,
		112,
		219,
		1
	],
	"mediumseagreen": [
		60,
		179,
		113,
		1
	],
	"mediumslateblue": [
		123,
		104,
		238,
		1
	],
	"mediumspringgreen": [
		0,
		250,
		154,
		1
	],
	"mediumturquoise": [
		72,
		209,
		204,
		1
	],
	"mediumvioletred": [
		199,
		21,
		133,
		1
	],
	"midnightblue": [
		25,
		25,
		112,
		1
	],
	"mintcream": [
		245,
		255,
		250,
		1
	],
	"mistyrose": [
		255,
		228,
		225,
		1
	],
	"moccasin": [
		255,
		228,
		181,
		1
	],
	"navajowhite": [
		255,
		222,
		173,
		1
	],
	"navy": [
		0,
		0,
		128,
		1
	],
	"oldlace": [
		253,
		245,
		230,
		1
	],
	"olive": [
		128,
		128,
		0,
		1
	],
	"olivedrab": [
		107,
		142,
		35,
		1
	],
	"orange": [
		255,
		165,
		0,
		1
	],
	"orangered": [
		255,
		69,
		0,
		1
	],
	"orchid": [
		218,
		112,
		214,
		1
	],
	"palegoldenrod": [
		238,
		232,
		170,
		1
	],
	"palegreen": [
		152,
		251,
		152,
		1
	],
	"paleturquoise": [
		175,
		238,
		238,
		1
	],
	"palevioletred": [
		219,
		112,
		147,
		1
	],
	"papayawhip": [
		255,
		239,
		213,
		1
	],
	"peachpuff": [
		255,
		218,
		185,
		1
	],
	"peru": [
		205,
		133,
		63,
		1
	],
	"pink": [
		255,
		192,
		203,
		1
	],
	"plum": [
		221,
		160,
		221,
		1
	],
	"powderblue": [
		176,
		224,
		230,
		1
	],
	"purple": [
		128,
		0,
		128,
		1
	],
	"red": [
		255,
		0,
		0,
		1
	],
	"rosybrown": [
		188,
		143,
		143,
		1
	],
	"royalblue": [
		65,
		105,
		225,
		1
	],
	"saddlebrown": [
		139,
		69,
		19,
		1
	],
	"salmon": [
		250,
		128,
		114,
		1
	],
	"sandybrown": [
		244,
		164,
		96,
		1
	],
	"seagreen": [
		46,
		139,
		87,
		1
	],
	"seashell": [
		255,
		245,
		238,
		1
	],
	"sienna": [
		160,
		82,
		45,
		1
	],
	"silver": [
		192,
		192,
		192,
		1
	],
	"skyblue": [
		135,
		206,
		235,
		1
	],
	"slateblue": [
		106,
		90,
		205,
		1
	],
	"slategray": [
		112,
		128,
		144,
		1
	],
	"slategrey": [
		112,
		128,
		144,
		1
	],
	"snow": [
		255,
		250,
		250,
		1
	],
	"springgreen": [
		0,
		255,
		127,
		1
	],
	"steelblue": [
		70,
		130,
		180,
		1
	],
	"tan": [
		210,
		180,
		140,
		1
	],
	"teal": [
		0,
		128,
		128,
		1
	],
	"thistle": [
		216,
		191,
		216,
		1
	],
	"tomato": [
		255,
		99,
		71,
		1
	],
	"turquoise": [
		64,
		224,
		208,
		1
	],
	"violet": [
		238,
		130,
		238,
		1
	],
	"wheat": [
		245,
		222,
		179,
		1
	],
	"white": [
		255,
		255,
		255,
		1
	],
	"whitesmoke": [
		245,
		245,
		245,
		1
	],
	"yellow": [
		255,
		255,
		0,
		1
	],
	"yellowgreen": [
		154,
		205,
		50,
		1
	]
};
function clampCssByte(i) {
	i = Math.round(i);
	return i < 0 ? 0 : i > 255 ? 255 : i;
}
function clampCssFloat(f) {
	return f < 0 ? 0 : f > 1 ? 1 : f;
}
function parseCssInt(val) {
	var str = val;
	if (str.length && str.charAt(str.length - 1) === "%") return clampCssByte(parseFloat(str) / 100 * 255);
	return clampCssByte(parseInt(str, 10));
}
function parseCssFloat(val) {
	var str = val;
	if (str.length && str.charAt(str.length - 1) === "%") return clampCssFloat(parseFloat(str) / 100);
	return clampCssFloat(parseFloat(str));
}
function cssHueToRgb(m1, m2, h$1) {
	if (h$1 < 0) h$1 += 1;
	else if (h$1 > 1) h$1 -= 1;
	if (h$1 * 6 < 1) return m1 + (m2 - m1) * h$1 * 6;
	if (h$1 * 2 < 1) return m2;
	if (h$1 * 3 < 2) return m1 + (m2 - m1) * (2 / 3 - h$1) * 6;
	return m1;
}
function setRgba(out$1, r, g, b, a) {
	out$1[0] = r;
	out$1[1] = g;
	out$1[2] = b;
	out$1[3] = a;
	return out$1;
}
function copyRgba(out$1, a) {
	out$1[0] = a[0];
	out$1[1] = a[1];
	out$1[2] = a[2];
	out$1[3] = a[3];
	return out$1;
}
var colorCache = new LRU_default(20);
var lastRemovedArr = null;
function putToCache(colorStr, rgbaArr) {
	if (lastRemovedArr) copyRgba(lastRemovedArr, rgbaArr);
	lastRemovedArr = colorCache.put(colorStr, lastRemovedArr || rgbaArr.slice());
}
function parse(colorStr, rgbaArr) {
	if (!colorStr) return;
	rgbaArr = rgbaArr || [];
	var cached = colorCache.get(colorStr);
	if (cached) return copyRgba(rgbaArr, cached);
	colorStr = colorStr + "";
	var str = colorStr.replace(/ /g, "").toLowerCase();
	if (str in kCSSColorTable) {
		copyRgba(rgbaArr, kCSSColorTable[str]);
		putToCache(colorStr, rgbaArr);
		return rgbaArr;
	}
	var strLen = str.length;
	if (str.charAt(0) === "#") {
		if (strLen === 4 || strLen === 5) {
			var iv = parseInt(str.slice(1, 4), 16);
			if (!(iv >= 0 && iv <= 4095)) {
				setRgba(rgbaArr, 0, 0, 0, 1);
				return;
			}
			setRgba(rgbaArr, (iv & 3840) >> 4 | (iv & 3840) >> 8, iv & 240 | (iv & 240) >> 4, iv & 15 | (iv & 15) << 4, strLen === 5 ? parseInt(str.slice(4), 16) / 15 : 1);
			putToCache(colorStr, rgbaArr);
			return rgbaArr;
		} else if (strLen === 7 || strLen === 9) {
			var iv = parseInt(str.slice(1, 7), 16);
			if (!(iv >= 0 && iv <= 16777215)) {
				setRgba(rgbaArr, 0, 0, 0, 1);
				return;
			}
			setRgba(rgbaArr, (iv & 16711680) >> 16, (iv & 65280) >> 8, iv & 255, strLen === 9 ? parseInt(str.slice(7), 16) / 255 : 1);
			putToCache(colorStr, rgbaArr);
			return rgbaArr;
		}
		return;
	}
	var op = str.indexOf("(");
	var ep = str.indexOf(")");
	if (op !== -1 && ep + 1 === strLen) {
		var fname = str.substr(0, op);
		var params = str.substr(op + 1, ep - (op + 1)).split(",");
		var alpha = 1;
		switch (fname) {
			case "rgba":
				if (params.length !== 4) return params.length === 3 ? setRgba(rgbaArr, +params[0], +params[1], +params[2], 1) : setRgba(rgbaArr, 0, 0, 0, 1);
				alpha = parseCssFloat(params.pop());
			case "rgb": if (params.length >= 3) {
				setRgba(rgbaArr, parseCssInt(params[0]), parseCssInt(params[1]), parseCssInt(params[2]), params.length === 3 ? alpha : parseCssFloat(params[3]));
				putToCache(colorStr, rgbaArr);
				return rgbaArr;
			} else {
				setRgba(rgbaArr, 0, 0, 0, 1);
				return;
			}
			case "hsla":
				if (params.length !== 4) {
					setRgba(rgbaArr, 0, 0, 0, 1);
					return;
				}
				params[3] = parseCssFloat(params[3]);
				hsla2rgba(params, rgbaArr);
				putToCache(colorStr, rgbaArr);
				return rgbaArr;
			case "hsl":
				if (params.length !== 3) {
					setRgba(rgbaArr, 0, 0, 0, 1);
					return;
				}
				hsla2rgba(params, rgbaArr);
				putToCache(colorStr, rgbaArr);
				return rgbaArr;
			default: return;
		}
	}
	setRgba(rgbaArr, 0, 0, 0, 1);
	return;
}
function hsla2rgba(hsla, rgba) {
	var h$1 = (parseFloat(hsla[0]) % 360 + 360) % 360 / 360;
	var s = parseCssFloat(hsla[1]);
	var l = parseCssFloat(hsla[2]);
	var m2 = l <= .5 ? l * (s + 1) : l + s - l * s;
	var m1 = l * 2 - m2;
	rgba = rgba || [];
	setRgba(rgba, clampCssByte(cssHueToRgb(m1, m2, h$1 + 1 / 3) * 255), clampCssByte(cssHueToRgb(m1, m2, h$1) * 255), clampCssByte(cssHueToRgb(m1, m2, h$1 - 1 / 3) * 255), 1);
	if (hsla.length === 4) rgba[3] = hsla[3];
	return rgba;
}
function lift(color, level) {
	var colorArr = parse(color);
	if (colorArr) {
		for (var i = 0; i < 3; i++) {
			if (level < 0) colorArr[i] = colorArr[i] * (1 - level) | 0;
			else colorArr[i] = (255 - colorArr[i]) * level + colorArr[i] | 0;
			if (colorArr[i] > 255) colorArr[i] = 255;
			else if (colorArr[i] < 0) colorArr[i] = 0;
		}
		return stringify(colorArr, colorArr.length === 4 ? "rgba" : "rgb");
	}
}
function stringify(arrColor, type) {
	if (!arrColor || !arrColor.length) return;
	var colorStr = arrColor[0] + "," + arrColor[1] + "," + arrColor[2];
	if (type === "rgba" || type === "hsva" || type === "hsla") colorStr += "," + arrColor[3];
	return type + "(" + colorStr + ")";
}
function lum(color, backgroundLum) {
	var arr = parse(color);
	return arr ? (.299 * arr[0] + .587 * arr[1] + .114 * arr[2]) * arr[3] / 255 + (1 - arr[3]) * backgroundLum : 0;
}
var liftedColorCache = new LRU_default(100);
function liftColor(color) {
	if (isString(color)) {
		var liftedColor = liftedColorCache.get(color);
		if (!liftedColor) {
			liftedColor = lift(color, -.1);
			liftedColorCache.put(color, liftedColor);
		}
		return liftedColor;
	} else if (isGradientObject(color)) {
		var ret = extend({}, color);
		ret.colorStops = map$1(color.colorStops, function(stop$1) {
			return {
				offset: stop$1.offset,
				color: lift(stop$1.color, -.1)
			};
		});
		return ret;
	}
	return color;
}
function isLinearGradient(val) {
	return val.type === "linear";
}
function isRadialGradient(val) {
	return val.type === "radial";
}
var encodeBase64 = function() {
	if (env_default.hasGlobalWindow && isFunction(window.btoa)) return function(str) {
		return window.btoa(unescape(encodeURIComponent(str)));
	};
	if (typeof Buffer !== "undefined") return function(str) {
		return Buffer.from(str).toString("base64");
	};
	return function(str) {
		return null;
	};
}();
var arraySlice = Array.prototype.slice;
function interpolateNumber(p0, p1, percent) {
	return (p1 - p0) * percent + p0;
}
function interpolate1DArray(out$1, p0, p1, percent) {
	var len$1 = p0.length;
	for (var i = 0; i < len$1; i++) out$1[i] = interpolateNumber(p0[i], p1[i], percent);
	return out$1;
}
function interpolate2DArray(out$1, p0, p1, percent) {
	var len$1 = p0.length;
	var len2 = len$1 && p0[0].length;
	for (var i = 0; i < len$1; i++) {
		if (!out$1[i]) out$1[i] = [];
		for (var j = 0; j < len2; j++) out$1[i][j] = interpolateNumber(p0[i][j], p1[i][j], percent);
	}
	return out$1;
}
function add1DArray(out$1, p0, p1, sign) {
	var len$1 = p0.length;
	for (var i = 0; i < len$1; i++) out$1[i] = p0[i] + p1[i] * sign;
	return out$1;
}
function add2DArray(out$1, p0, p1, sign) {
	var len$1 = p0.length;
	var len2 = len$1 && p0[0].length;
	for (var i = 0; i < len$1; i++) {
		if (!out$1[i]) out$1[i] = [];
		for (var j = 0; j < len2; j++) out$1[i][j] = p0[i][j] + p1[i][j] * sign;
	}
	return out$1;
}
function fillColorStops(val0, val1) {
	var len0 = val0.length;
	var len1 = val1.length;
	var shorterArr = len0 > len1 ? val1 : val0;
	var shorterLen = Math.min(len0, len1);
	var last = shorterArr[shorterLen - 1] || {
		color: [
			0,
			0,
			0,
			0
		],
		offset: 0
	};
	for (var i = shorterLen; i < Math.max(len0, len1); i++) shorterArr.push({
		offset: last.offset,
		color: last.color.slice()
	});
}
function fillArray(val0, val1, arrDim) {
	var arr0 = val0;
	var arr1 = val1;
	if (!arr0.push || !arr1.push) return;
	var arr0Len = arr0.length;
	var arr1Len = arr1.length;
	if (arr0Len !== arr1Len) {
		var isPreviousLarger = arr0Len > arr1Len;
		if (isPreviousLarger) arr0.length = arr1Len;
		else for (var i = arr0Len; i < arr1Len; i++) arr0.push(arrDim === 1 ? arr1[i] : arraySlice.call(arr1[i]));
	}
	var len2 = arr0[0] && arr0[0].length;
	for (var i = 0; i < arr0.length; i++) if (arrDim === 1) {
		if (isNaN(arr0[i])) arr0[i] = arr1[i];
	} else for (var j = 0; j < len2; j++) if (isNaN(arr0[i][j])) arr0[i][j] = arr1[i][j];
}
function cloneValue(value) {
	if (isArrayLike(value)) {
		var len$1 = value.length;
		if (isArrayLike(value[0])) {
			var ret = [];
			for (var i = 0; i < len$1; i++) ret.push(arraySlice.call(value[i]));
			return ret;
		}
		return arraySlice.call(value);
	}
	return value;
}
function rgba2String(rgba) {
	rgba[0] = Math.floor(rgba[0]) || 0;
	rgba[1] = Math.floor(rgba[1]) || 0;
	rgba[2] = Math.floor(rgba[2]) || 0;
	rgba[3] = rgba[3] == null ? 1 : rgba[3];
	return "rgba(" + rgba.join(",") + ")";
}
function guessArrayDim(value) {
	return isArrayLike(value && value[0]) ? 2 : 1;
}
var VALUE_TYPE_NUMBER = 0;
var VALUE_TYPE_1D_ARRAY = 1;
var VALUE_TYPE_2D_ARRAY = 2;
var VALUE_TYPE_COLOR = 3;
var VALUE_TYPE_LINEAR_GRADIENT = 4;
var VALUE_TYPE_RADIAL_GRADIENT = 5;
var VALUE_TYPE_UNKOWN = 6;
function isGradientValueType(valType) {
	return valType === VALUE_TYPE_LINEAR_GRADIENT || valType === VALUE_TYPE_RADIAL_GRADIENT;
}
function isArrayValueType(valType) {
	return valType === VALUE_TYPE_1D_ARRAY || valType === VALUE_TYPE_2D_ARRAY;
}
var tmpRgba = [
	0,
	0,
	0,
	0
];
var Track = function() {
	function Track$1(propName) {
		this.keyframes = [];
		this.discrete = false;
		this._invalid = false;
		this._needsSort = false;
		this._lastFr = 0;
		this._lastFrP = 0;
		this.propName = propName;
	}
	Track$1.prototype.isFinished = function() {
		return this._finished;
	};
	Track$1.prototype.setFinished = function() {
		this._finished = true;
		if (this._additiveTrack) this._additiveTrack.setFinished();
	};
	Track$1.prototype.needsAnimate = function() {
		return this.keyframes.length >= 1;
	};
	Track$1.prototype.getAdditiveTrack = function() {
		return this._additiveTrack;
	};
	Track$1.prototype.addKeyframe = function(time, rawValue, easing) {
		this._needsSort = true;
		var keyframes = this.keyframes;
		var len$1 = keyframes.length;
		var discrete = false;
		var valType = VALUE_TYPE_UNKOWN;
		var value = rawValue;
		if (isArrayLike(rawValue)) {
			var arrayDim = guessArrayDim(rawValue);
			valType = arrayDim;
			if (arrayDim === 1 && !isNumber(rawValue[0]) || arrayDim === 2 && !isNumber(rawValue[0][0])) discrete = true;
		} else if (isNumber(rawValue) && !eqNaN(rawValue)) valType = VALUE_TYPE_NUMBER;
		else if (isString(rawValue)) if (!isNaN(+rawValue)) valType = VALUE_TYPE_NUMBER;
		else {
			var colorArray = parse(rawValue);
			if (colorArray) {
				value = colorArray;
				valType = VALUE_TYPE_COLOR;
			}
		}
		else if (isGradientObject(rawValue)) {
			var parsedGradient = extend({}, value);
			parsedGradient.colorStops = map$1(rawValue.colorStops, function(colorStop) {
				return {
					offset: colorStop.offset,
					color: parse(colorStop.color)
				};
			});
			if (isLinearGradient(rawValue)) valType = VALUE_TYPE_LINEAR_GRADIENT;
			else if (isRadialGradient(rawValue)) valType = VALUE_TYPE_RADIAL_GRADIENT;
			value = parsedGradient;
		}
		if (len$1 === 0) this.valType = valType;
		else if (valType !== this.valType || valType === VALUE_TYPE_UNKOWN) discrete = true;
		this.discrete = this.discrete || discrete;
		var kf = {
			time,
			value,
			rawValue,
			percent: 0
		};
		if (easing) {
			kf.easing = easing;
			kf.easingFunc = isFunction(easing) ? easing : easing_default[easing] || createCubicEasingFunc(easing);
		}
		keyframes.push(kf);
		return kf;
	};
	Track$1.prototype.prepare = function(maxTime, additiveTrack) {
		var kfs = this.keyframes;
		if (this._needsSort) kfs.sort(function(a, b) {
			return a.time - b.time;
		});
		var valType = this.valType;
		var kfsLen = kfs.length;
		var lastKf = kfs[kfsLen - 1];
		var isDiscrete = this.discrete;
		var isArr = isArrayValueType(valType);
		var isGradient = isGradientValueType(valType);
		for (var i = 0; i < kfsLen; i++) {
			var kf = kfs[i];
			var value = kf.value;
			var lastValue = lastKf.value;
			kf.percent = kf.time / maxTime;
			if (!isDiscrete) {
				if (isArr && i !== kfsLen - 1) fillArray(value, lastValue, valType);
				else if (isGradient) fillColorStops(value.colorStops, lastValue.colorStops);
			}
		}
		if (!isDiscrete && valType !== VALUE_TYPE_RADIAL_GRADIENT && additiveTrack && this.needsAnimate() && additiveTrack.needsAnimate() && valType === additiveTrack.valType && !additiveTrack._finished) {
			this._additiveTrack = additiveTrack;
			var startValue = kfs[0].value;
			for (var i = 0; i < kfsLen; i++) if (valType === VALUE_TYPE_NUMBER) kfs[i].additiveValue = kfs[i].value - startValue;
			else if (valType === VALUE_TYPE_COLOR) kfs[i].additiveValue = add1DArray([], kfs[i].value, startValue, -1);
			else if (isArrayValueType(valType)) kfs[i].additiveValue = valType === VALUE_TYPE_1D_ARRAY ? add1DArray([], kfs[i].value, startValue, -1) : add2DArray([], kfs[i].value, startValue, -1);
		}
	};
	Track$1.prototype.step = function(target, percent) {
		if (this._finished) return;
		if (this._additiveTrack && this._additiveTrack._finished) this._additiveTrack = null;
		var isAdditive = this._additiveTrack != null;
		var valueKey = isAdditive ? "additiveValue" : "value";
		var valType = this.valType;
		var keyframes = this.keyframes;
		var kfsNum = keyframes.length;
		var propName = this.propName;
		var isValueColor = valType === VALUE_TYPE_COLOR;
		var frameIdx;
		var lastFrame = this._lastFr;
		var mathMin$6 = Math.min;
		var frame;
		var nextFrame;
		if (kfsNum === 1) frame = nextFrame = keyframes[0];
		else {
			if (percent < 0) frameIdx = 0;
			else if (percent < this._lastFrP) {
				var start$1 = mathMin$6(lastFrame + 1, kfsNum - 1);
				for (frameIdx = start$1; frameIdx >= 0; frameIdx--) if (keyframes[frameIdx].percent <= percent) break;
				frameIdx = mathMin$6(frameIdx, kfsNum - 2);
			} else {
				for (frameIdx = lastFrame; frameIdx < kfsNum; frameIdx++) if (keyframes[frameIdx].percent > percent) break;
				frameIdx = mathMin$6(frameIdx - 1, kfsNum - 2);
			}
			nextFrame = keyframes[frameIdx + 1];
			frame = keyframes[frameIdx];
		}
		if (!(frame && nextFrame)) return;
		this._lastFr = frameIdx;
		this._lastFrP = percent;
		var interval = nextFrame.percent - frame.percent;
		var w = interval === 0 ? 1 : mathMin$6((percent - frame.percent) / interval, 1);
		if (nextFrame.easingFunc) w = nextFrame.easingFunc(w);
		var targetArr = isAdditive ? this._additiveValue : isValueColor ? tmpRgba : target[propName];
		if ((isArrayValueType(valType) || isValueColor) && !targetArr) targetArr = this._additiveValue = [];
		if (this.discrete) target[propName] = w < 1 ? frame.rawValue : nextFrame.rawValue;
		else if (isArrayValueType(valType)) valType === VALUE_TYPE_1D_ARRAY ? interpolate1DArray(targetArr, frame[valueKey], nextFrame[valueKey], w) : interpolate2DArray(targetArr, frame[valueKey], nextFrame[valueKey], w);
		else if (isGradientValueType(valType)) {
			var val = frame[valueKey];
			var nextVal_1 = nextFrame[valueKey];
			var isLinearGradient_1 = valType === VALUE_TYPE_LINEAR_GRADIENT;
			target[propName] = {
				type: isLinearGradient_1 ? "linear" : "radial",
				x: interpolateNumber(val.x, nextVal_1.x, w),
				y: interpolateNumber(val.y, nextVal_1.y, w),
				colorStops: map$1(val.colorStops, function(colorStop, idx) {
					var nextColorStop = nextVal_1.colorStops[idx];
					return {
						offset: interpolateNumber(colorStop.offset, nextColorStop.offset, w),
						color: rgba2String(interpolate1DArray([], colorStop.color, nextColorStop.color, w))
					};
				}),
				global: nextVal_1.global
			};
			if (isLinearGradient_1) {
				target[propName].x2 = interpolateNumber(val.x2, nextVal_1.x2, w);
				target[propName].y2 = interpolateNumber(val.y2, nextVal_1.y2, w);
			} else target[propName].r = interpolateNumber(val.r, nextVal_1.r, w);
		} else if (isValueColor) {
			interpolate1DArray(targetArr, frame[valueKey], nextFrame[valueKey], w);
			if (!isAdditive) target[propName] = rgba2String(targetArr);
		} else {
			var value = interpolateNumber(frame[valueKey], nextFrame[valueKey], w);
			if (isAdditive) this._additiveValue = value;
			else target[propName] = value;
		}
		if (isAdditive) this._addToTarget(target);
	};
	Track$1.prototype._addToTarget = function(target) {
		var valType = this.valType;
		var propName = this.propName;
		var additiveValue = this._additiveValue;
		if (valType === VALUE_TYPE_NUMBER) target[propName] = target[propName] + additiveValue;
		else if (valType === VALUE_TYPE_COLOR) {
			parse(target[propName], tmpRgba);
			add1DArray(tmpRgba, tmpRgba, additiveValue, 1);
			target[propName] = rgba2String(tmpRgba);
		} else if (valType === VALUE_TYPE_1D_ARRAY) add1DArray(target[propName], target[propName], additiveValue, 1);
		else if (valType === VALUE_TYPE_2D_ARRAY) add2DArray(target[propName], target[propName], additiveValue, 1);
	};
	return Track$1;
}();
var Animator = function() {
	function Animator$1(target, loop, allowDiscreteAnimation, additiveTo) {
		this._tracks = {};
		this._trackKeys = [];
		this._maxTime = 0;
		this._started = 0;
		this._clip = null;
		this._target = target;
		this._loop = loop;
		if (loop && additiveTo) {
			logError("Can' use additive animation on looped animation.");
			return;
		}
		this._additiveAnimators = additiveTo;
		this._allowDiscrete = allowDiscreteAnimation;
	}
	Animator$1.prototype.getMaxTime = function() {
		return this._maxTime;
	};
	Animator$1.prototype.getDelay = function() {
		return this._delay;
	};
	Animator$1.prototype.getLoop = function() {
		return this._loop;
	};
	Animator$1.prototype.getTarget = function() {
		return this._target;
	};
	Animator$1.prototype.changeTarget = function(target) {
		this._target = target;
	};
	Animator$1.prototype.when = function(time, props, easing) {
		return this.whenWithKeys(time, props, keys(props), easing);
	};
	Animator$1.prototype.whenWithKeys = function(time, props, propNames, easing) {
		var tracks = this._tracks;
		for (var i = 0; i < propNames.length; i++) {
			var propName = propNames[i];
			var track = tracks[propName];
			if (!track) {
				track = tracks[propName] = new Track(propName);
				var initialValue = void 0;
				var additiveTrack = this._getAdditiveTrack(propName);
				if (additiveTrack) {
					var addtiveTrackKfs = additiveTrack.keyframes;
					var lastFinalKf = addtiveTrackKfs[addtiveTrackKfs.length - 1];
					initialValue = lastFinalKf && lastFinalKf.value;
					if (additiveTrack.valType === VALUE_TYPE_COLOR && initialValue) initialValue = rgba2String(initialValue);
				} else initialValue = this._target[propName];
				if (initialValue == null) continue;
				if (time > 0) track.addKeyframe(0, cloneValue(initialValue), easing);
				this._trackKeys.push(propName);
			}
			track.addKeyframe(time, cloneValue(props[propName]), easing);
		}
		this._maxTime = Math.max(this._maxTime, time);
		return this;
	};
	Animator$1.prototype.pause = function() {
		this._clip.pause();
		this._paused = true;
	};
	Animator$1.prototype.resume = function() {
		this._clip.resume();
		this._paused = false;
	};
	Animator$1.prototype.isPaused = function() {
		return !!this._paused;
	};
	Animator$1.prototype.duration = function(duration) {
		this._maxTime = duration;
		this._force = true;
		return this;
	};
	Animator$1.prototype._doneCallback = function() {
		this._setTracksFinished();
		this._clip = null;
		var doneList = this._doneCbs;
		if (doneList) {
			var len$1 = doneList.length;
			for (var i = 0; i < len$1; i++) doneList[i].call(this);
		}
	};
	Animator$1.prototype._abortedCallback = function() {
		this._setTracksFinished();
		var animation = this.animation;
		var abortedList = this._abortedCbs;
		if (animation) animation.removeClip(this._clip);
		this._clip = null;
		if (abortedList) for (var i = 0; i < abortedList.length; i++) abortedList[i].call(this);
	};
	Animator$1.prototype._setTracksFinished = function() {
		var tracks = this._tracks;
		var tracksKeys = this._trackKeys;
		for (var i = 0; i < tracksKeys.length; i++) tracks[tracksKeys[i]].setFinished();
	};
	Animator$1.prototype._getAdditiveTrack = function(trackName) {
		var additiveTrack;
		var additiveAnimators = this._additiveAnimators;
		if (additiveAnimators) for (var i = 0; i < additiveAnimators.length; i++) {
			var track = additiveAnimators[i].getTrack(trackName);
			if (track) additiveTrack = track;
		}
		return additiveTrack;
	};
	Animator$1.prototype.start = function(easing) {
		if (this._started > 0) return;
		this._started = 1;
		var self$1 = this;
		var tracks = [];
		var maxTime = this._maxTime || 0;
		for (var i = 0; i < this._trackKeys.length; i++) {
			var propName = this._trackKeys[i];
			var track = this._tracks[propName];
			var additiveTrack = this._getAdditiveTrack(propName);
			var kfs = track.keyframes;
			var kfsNum = kfs.length;
			track.prepare(maxTime, additiveTrack);
			if (track.needsAnimate()) if (!this._allowDiscrete && track.discrete) {
				var lastKf = kfs[kfsNum - 1];
				if (lastKf) self$1._target[track.propName] = lastKf.rawValue;
				track.setFinished();
			} else tracks.push(track);
		}
		if (tracks.length || this._force) {
			var clip$1 = new Clip_default({
				life: maxTime,
				loop: this._loop,
				delay: this._delay || 0,
				onframe: function(percent) {
					self$1._started = 2;
					var additiveAnimators = self$1._additiveAnimators;
					if (additiveAnimators) {
						var stillHasAdditiveAnimator = false;
						for (var i$1 = 0; i$1 < additiveAnimators.length; i$1++) if (additiveAnimators[i$1]._clip) {
							stillHasAdditiveAnimator = true;
							break;
						}
						if (!stillHasAdditiveAnimator) self$1._additiveAnimators = null;
					}
					for (var i$1 = 0; i$1 < tracks.length; i$1++) tracks[i$1].step(self$1._target, percent);
					var onframeList = self$1._onframeCbs;
					if (onframeList) for (var i$1 = 0; i$1 < onframeList.length; i$1++) onframeList[i$1](self$1._target, percent);
				},
				ondestroy: function() {
					self$1._doneCallback();
				}
			});
			this._clip = clip$1;
			if (this.animation) this.animation.addClip(clip$1);
			if (easing) clip$1.setEasing(easing);
		} else this._doneCallback();
		return this;
	};
	Animator$1.prototype.stop = function(forwardToLast) {
		if (!this._clip) return;
		var clip$1 = this._clip;
		if (forwardToLast) clip$1.onframe(1);
		this._abortedCallback();
	};
	Animator$1.prototype.delay = function(time) {
		this._delay = time;
		return this;
	};
	Animator$1.prototype.during = function(cb) {
		if (cb) {
			if (!this._onframeCbs) this._onframeCbs = [];
			this._onframeCbs.push(cb);
		}
		return this;
	};
	Animator$1.prototype.done = function(cb) {
		if (cb) {
			if (!this._doneCbs) this._doneCbs = [];
			this._doneCbs.push(cb);
		}
		return this;
	};
	Animator$1.prototype.aborted = function(cb) {
		if (cb) {
			if (!this._abortedCbs) this._abortedCbs = [];
			this._abortedCbs.push(cb);
		}
		return this;
	};
	Animator$1.prototype.getClip = function() {
		return this._clip;
	};
	Animator$1.prototype.getTrack = function(propName) {
		return this._tracks[propName];
	};
	Animator$1.prototype.getTracks = function() {
		var _this = this;
		return map$1(this._trackKeys, function(key) {
			return _this._tracks[key];
		});
	};
	Animator$1.prototype.stopTracks = function(propNames, forwardToLast) {
		if (!propNames.length || !this._clip) return true;
		var tracks = this._tracks;
		var tracksKeys = this._trackKeys;
		for (var i = 0; i < propNames.length; i++) {
			var track = tracks[propNames[i]];
			if (track && !track.isFinished()) {
				if (forwardToLast) track.step(this._target, 1);
				else if (this._started === 1) track.step(this._target, 0);
				track.setFinished();
			}
		}
		var allAborted = true;
		for (var i = 0; i < tracksKeys.length; i++) if (!tracks[tracksKeys[i]].isFinished()) {
			allAborted = false;
			break;
		}
		if (allAborted) this._abortedCallback();
		return allAborted;
	};
	Animator$1.prototype.saveTo = function(target, trackKeys, firstOrLast) {
		if (!target) return;
		trackKeys = trackKeys || this._trackKeys;
		for (var i = 0; i < trackKeys.length; i++) {
			var propName = trackKeys[i];
			var track = this._tracks[propName];
			if (!track || track.isFinished()) continue;
			var kfs = track.keyframes;
			var kf = kfs[firstOrLast ? 0 : kfs.length - 1];
			if (kf) target[propName] = cloneValue(kf.rawValue);
		}
	};
	Animator$1.prototype.__changeFinalValue = function(finalProps, trackKeys) {
		trackKeys = trackKeys || keys(finalProps);
		for (var i = 0; i < trackKeys.length; i++) {
			var propName = trackKeys[i];
			var track = this._tracks[propName];
			if (!track) continue;
			var kfs = track.keyframes;
			if (kfs.length > 1) {
				var lastKf = kfs.pop();
				track.addKeyframe(lastKf.time, finalProps[propName]);
				track.prepare(this._maxTime, track.getAdditiveTrack());
			}
		}
	};
	return Animator$1;
}();
var Animator_default = Animator;
var Eventful = function() {
	function Eventful$1(eventProcessors) {
		if (eventProcessors) this._$eventProcessor = eventProcessors;
	}
	Eventful$1.prototype.on = function(event, query, handler, context) {
		if (!this._$handlers) this._$handlers = {};
		var _h = this._$handlers;
		if (typeof query === "function") {
			context = handler;
			handler = query;
			query = null;
		}
		if (!handler || !event) return this;
		var eventProcessor = this._$eventProcessor;
		if (query != null && eventProcessor && eventProcessor.normalizeQuery) query = eventProcessor.normalizeQuery(query);
		if (!_h[event]) _h[event] = [];
		for (var i = 0; i < _h[event].length; i++) if (_h[event][i].h === handler) return this;
		var wrap = {
			h: handler,
			query,
			ctx: context || this,
			callAtLast: handler.zrEventfulCallAtLast
		};
		var lastIndex = _h[event].length - 1;
		var lastWrap = _h[event][lastIndex];
		lastWrap && lastWrap.callAtLast ? _h[event].splice(lastIndex, 0, wrap) : _h[event].push(wrap);
		return this;
	};
	Eventful$1.prototype.isSilent = function(eventName) {
		var _h = this._$handlers;
		return !_h || !_h[eventName] || !_h[eventName].length;
	};
	Eventful$1.prototype.off = function(eventType, handler) {
		var _h = this._$handlers;
		if (!_h) return this;
		if (!eventType) {
			this._$handlers = {};
			return this;
		}
		if (handler) {
			if (_h[eventType]) {
				var newList = [];
				for (var i = 0, l = _h[eventType].length; i < l; i++) if (_h[eventType][i].h !== handler) newList.push(_h[eventType][i]);
				_h[eventType] = newList;
			}
			if (_h[eventType] && _h[eventType].length === 0) delete _h[eventType];
		} else delete _h[eventType];
		return this;
	};
	Eventful$1.prototype.trigger = function(eventType) {
		var args = [];
		for (var _i = 1; _i < arguments.length; _i++) args[_i - 1] = arguments[_i];
		if (!this._$handlers) return this;
		var _h = this._$handlers[eventType];
		var eventProcessor = this._$eventProcessor;
		if (_h) {
			var argLen = args.length;
			var len$1 = _h.length;
			for (var i = 0; i < len$1; i++) {
				var hItem = _h[i];
				if (eventProcessor && eventProcessor.filter && hItem.query != null && !eventProcessor.filter(eventType, hItem.query)) continue;
				switch (argLen) {
					case 0:
						hItem.h.call(hItem.ctx);
						break;
					case 1:
						hItem.h.call(hItem.ctx, args[0]);
						break;
					case 2:
						hItem.h.call(hItem.ctx, args[0], args[1]);
						break;
					default:
						hItem.h.apply(hItem.ctx, args);
						break;
				}
			}
		}
		eventProcessor && eventProcessor.afterTrigger && eventProcessor.afterTrigger(eventType);
		return this;
	};
	Eventful$1.prototype.triggerWithContext = function(type) {
		var args = [];
		for (var _i = 1; _i < arguments.length; _i++) args[_i - 1] = arguments[_i];
		if (!this._$handlers) return this;
		var _h = this._$handlers[type];
		var eventProcessor = this._$eventProcessor;
		if (_h) {
			var argLen = args.length;
			var ctx = args[argLen - 1];
			var len$1 = _h.length;
			for (var i = 0; i < len$1; i++) {
				var hItem = _h[i];
				if (eventProcessor && eventProcessor.filter && hItem.query != null && !eventProcessor.filter(type, hItem.query)) continue;
				switch (argLen) {
					case 0:
						hItem.h.call(ctx);
						break;
					case 1:
						hItem.h.call(ctx, args[0]);
						break;
					case 2:
						hItem.h.call(ctx, args[0], args[1]);
						break;
					default:
						hItem.h.apply(ctx, args.slice(1, argLen - 1));
						break;
				}
			}
		}
		eventProcessor && eventProcessor.afterTrigger && eventProcessor.afterTrigger(type);
		return this;
	};
	return Eventful$1;
}();
var Eventful_default = Eventful;
var dpr = 1;
if (env_default.hasGlobalWindow) dpr = Math.max(window.devicePixelRatio || window.screen && window.screen.deviceXDPI / window.screen.logicalXDPI || 1, 1);
var devicePixelRatio = dpr;
var DARK_MODE_THRESHOLD = .4;
var DARK_LABEL_COLOR = "#333";
var LIGHT_LABEL_COLOR = "#ccc";
var LIGHTER_LABEL_COLOR = "#eee";
var REDRAW_BIT = 1;
var STYLE_CHANGED_BIT = 2;
var SHAPE_CHANGED_BIT = 4;
var PRESERVED_NORMAL_STATE = "__zr_normal__";
var PRIMARY_STATES_KEYS$1 = TRANSFORMABLE_PROPS.concat(["ignore"]);
var DEFAULT_ANIMATABLE_MAP = reduce(TRANSFORMABLE_PROPS, function(obj, key) {
	obj[key] = true;
	return obj;
}, { ignore: false });
var tmpTextPosCalcRes = {};
var tmpBoundingRect = new BoundingRect_default(0, 0, 0, 0);
var Element = function() {
	function Element$1(props) {
		this.id = guid();
		this.animators = [];
		this.currentStates = [];
		this.states = {};
		this._init(props);
	}
	Element$1.prototype._init = function(props) {
		this.attr(props);
	};
	Element$1.prototype.drift = function(dx, dy, e$1) {
		switch (this.draggable) {
			case "horizontal":
				dy = 0;
				break;
			case "vertical":
				dx = 0;
				break;
		}
		var m$1 = this.transform;
		if (!m$1) m$1 = this.transform = [
			1,
			0,
			0,
			1,
			0,
			0
		];
		m$1[4] += dx;
		m$1[5] += dy;
		this.decomposeTransform();
		this.markRedraw();
	};
	Element$1.prototype.beforeUpdate = function() {};
	Element$1.prototype.afterUpdate = function() {};
	Element$1.prototype.update = function() {
		this.updateTransform();
		if (this.__dirty) this.updateInnerText();
	};
	Element$1.prototype.updateInnerText = function(forceUpdate) {
		var textEl = this._textContent;
		if (textEl && (!textEl.ignore || forceUpdate)) {
			if (!this.textConfig) this.textConfig = {};
			var textConfig = this.textConfig;
			var isLocal = textConfig.local;
			var innerTransformable = textEl.innerTransformable;
			var textAlign = void 0;
			var textVerticalAlign = void 0;
			var textStyleChanged = false;
			innerTransformable.parent = isLocal ? this : null;
			var innerOrigin = false;
			innerTransformable.copyTransform(textEl);
			if (textConfig.position != null) {
				var layoutRect = tmpBoundingRect;
				if (textConfig.layoutRect) layoutRect.copy(textConfig.layoutRect);
				else layoutRect.copy(this.getBoundingRect());
				if (!isLocal) layoutRect.applyTransform(this.transform);
				if (this.calculateTextPosition) this.calculateTextPosition(tmpTextPosCalcRes, textConfig, layoutRect);
				else calculateTextPosition(tmpTextPosCalcRes, textConfig, layoutRect);
				innerTransformable.x = tmpTextPosCalcRes.x;
				innerTransformable.y = tmpTextPosCalcRes.y;
				textAlign = tmpTextPosCalcRes.align;
				textVerticalAlign = tmpTextPosCalcRes.verticalAlign;
				var textOrigin = textConfig.origin;
				if (textOrigin && textConfig.rotation != null) {
					var relOriginX = void 0;
					var relOriginY = void 0;
					if (textOrigin === "center") {
						relOriginX = layoutRect.width * .5;
						relOriginY = layoutRect.height * .5;
					} else {
						relOriginX = parsePercent$1(textOrigin[0], layoutRect.width);
						relOriginY = parsePercent$1(textOrigin[1], layoutRect.height);
					}
					innerOrigin = true;
					innerTransformable.originX = -innerTransformable.x + relOriginX + (isLocal ? 0 : layoutRect.x);
					innerTransformable.originY = -innerTransformable.y + relOriginY + (isLocal ? 0 : layoutRect.y);
				}
			}
			if (textConfig.rotation != null) innerTransformable.rotation = textConfig.rotation;
			var textOffset = textConfig.offset;
			if (textOffset) {
				innerTransformable.x += textOffset[0];
				innerTransformable.y += textOffset[1];
				if (!innerOrigin) {
					innerTransformable.originX = -textOffset[0];
					innerTransformable.originY = -textOffset[1];
				}
			}
			var isInside = textConfig.inside == null ? typeof textConfig.position === "string" && textConfig.position.indexOf("inside") >= 0 : textConfig.inside;
			var innerTextDefaultStyle = this._innerTextDefaultStyle || (this._innerTextDefaultStyle = {});
			var textFill = void 0;
			var textStroke = void 0;
			var autoStroke = void 0;
			if (isInside && this.canBeInsideText()) {
				textFill = textConfig.insideFill;
				textStroke = textConfig.insideStroke;
				if (textFill == null || textFill === "auto") textFill = this.getInsideTextFill();
				if (textStroke == null || textStroke === "auto") {
					textStroke = this.getInsideTextStroke(textFill);
					autoStroke = true;
				}
			} else {
				textFill = textConfig.outsideFill;
				textStroke = textConfig.outsideStroke;
				if (textFill == null || textFill === "auto") textFill = this.getOutsideFill();
				if (textStroke == null || textStroke === "auto") {
					textStroke = this.getOutsideStroke(textFill);
					autoStroke = true;
				}
			}
			textFill = textFill || "#000";
			if (textFill !== innerTextDefaultStyle.fill || textStroke !== innerTextDefaultStyle.stroke || autoStroke !== innerTextDefaultStyle.autoStroke || textAlign !== innerTextDefaultStyle.align || textVerticalAlign !== innerTextDefaultStyle.verticalAlign) {
				textStyleChanged = true;
				innerTextDefaultStyle.fill = textFill;
				innerTextDefaultStyle.stroke = textStroke;
				innerTextDefaultStyle.autoStroke = autoStroke;
				innerTextDefaultStyle.align = textAlign;
				innerTextDefaultStyle.verticalAlign = textVerticalAlign;
				textEl.setDefaultTextStyle(innerTextDefaultStyle);
			}
			textEl.__dirty |= REDRAW_BIT;
			if (textStyleChanged) textEl.dirtyStyle(true);
		}
	};
	Element$1.prototype.canBeInsideText = function() {
		return true;
	};
	Element$1.prototype.getInsideTextFill = function() {
		return "#fff";
	};
	Element$1.prototype.getInsideTextStroke = function(textFill) {
		return "#000";
	};
	Element$1.prototype.getOutsideFill = function() {
		return this.__zr && this.__zr.isDarkMode() ? LIGHT_LABEL_COLOR : DARK_LABEL_COLOR;
	};
	Element$1.prototype.getOutsideStroke = function(textFill) {
		var backgroundColor$1 = this.__zr && this.__zr.getBackgroundColor();
		var colorArr = typeof backgroundColor$1 === "string" && parse(backgroundColor$1);
		if (!colorArr) colorArr = [
			255,
			255,
			255,
			1
		];
		var alpha = colorArr[3];
		var isDark$1 = this.__zr.isDarkMode();
		for (var i = 0; i < 3; i++) colorArr[i] = colorArr[i] * alpha + (isDark$1 ? 0 : 255) * (1 - alpha);
		colorArr[3] = 1;
		return stringify(colorArr, "rgba");
	};
	Element$1.prototype.traverse = function(cb, context) {};
	Element$1.prototype.attrKV = function(key, value) {
		if (key === "textConfig") this.setTextConfig(value);
		else if (key === "textContent") this.setTextContent(value);
		else if (key === "clipPath") this.setClipPath(value);
		else if (key === "extra") {
			this.extra = this.extra || {};
			extend(this.extra, value);
		} else this[key] = value;
	};
	Element$1.prototype.hide = function() {
		this.ignore = true;
		this.markRedraw();
	};
	Element$1.prototype.show = function() {
		this.ignore = false;
		this.markRedraw();
	};
	Element$1.prototype.attr = function(keyOrObj, value) {
		if (typeof keyOrObj === "string") this.attrKV(keyOrObj, value);
		else if (isObject$2(keyOrObj)) {
			var obj = keyOrObj;
			var keysArr = keys(obj);
			for (var i = 0; i < keysArr.length; i++) {
				var key = keysArr[i];
				this.attrKV(key, keyOrObj[key]);
			}
		}
		this.markRedraw();
		return this;
	};
	Element$1.prototype.saveCurrentToNormalState = function(toState) {
		this._innerSaveToNormal(toState);
		var normalState = this._normalState;
		for (var i = 0; i < this.animators.length; i++) {
			var animator = this.animators[i];
			var fromStateTransition = animator.__fromStateTransition;
			if (animator.getLoop() || fromStateTransition && fromStateTransition !== PRESERVED_NORMAL_STATE) continue;
			var targetName = animator.targetName;
			var target = targetName ? normalState[targetName] : normalState;
			animator.saveTo(target);
		}
	};
	Element$1.prototype._innerSaveToNormal = function(toState) {
		var normalState = this._normalState;
		if (!normalState) normalState = this._normalState = {};
		if (toState.textConfig && !normalState.textConfig) normalState.textConfig = this.textConfig;
		this._savePrimaryToNormal(toState, normalState, PRIMARY_STATES_KEYS$1);
	};
	Element$1.prototype._savePrimaryToNormal = function(toState, normalState, primaryKeys) {
		for (var i = 0; i < primaryKeys.length; i++) {
			var key = primaryKeys[i];
			if (toState[key] != null && !(key in normalState)) normalState[key] = this[key];
		}
	};
	Element$1.prototype.hasState = function() {
		return this.currentStates.length > 0;
	};
	Element$1.prototype.getState = function(name) {
		return this.states[name];
	};
	Element$1.prototype.ensureState = function(name) {
		var states = this.states;
		if (!states[name]) states[name] = {};
		return states[name];
	};
	Element$1.prototype.clearStates = function(noAnimation) {
		this.useState(PRESERVED_NORMAL_STATE, false, noAnimation);
	};
	Element$1.prototype.useState = function(stateName, keepCurrentStates, noAnimation, forceUseHoverLayer) {
		var toNormalState = stateName === PRESERVED_NORMAL_STATE;
		var hasStates = this.hasState();
		if (!hasStates && toNormalState) return;
		var currentStates = this.currentStates;
		var animationCfg = this.stateTransition;
		if (indexOf(currentStates, stateName) >= 0 && (keepCurrentStates || currentStates.length === 1)) return;
		var state;
		if (this.stateProxy && !toNormalState) state = this.stateProxy(stateName);
		if (!state) state = this.states && this.states[stateName];
		if (!state && !toNormalState) {
			logError("State " + stateName + " not exists.");
			return;
		}
		if (!toNormalState) this.saveCurrentToNormalState(state);
		var useHoverLayer = !!(state && state.hoverLayer || forceUseHoverLayer);
		if (useHoverLayer) this._toggleHoverLayerFlag(true);
		this._applyStateObj(stateName, state, this._normalState, keepCurrentStates, !noAnimation && !this.__inHover && animationCfg && animationCfg.duration > 0, animationCfg);
		var textContent = this._textContent;
		var textGuide = this._textGuide;
		if (textContent) textContent.useState(stateName, keepCurrentStates, noAnimation, useHoverLayer);
		if (textGuide) textGuide.useState(stateName, keepCurrentStates, noAnimation, useHoverLayer);
		if (toNormalState) {
			this.currentStates = [];
			this._normalState = {};
		} else if (!keepCurrentStates) this.currentStates = [stateName];
		else this.currentStates.push(stateName);
		this._updateAnimationTargets();
		this.markRedraw();
		if (!useHoverLayer && this.__inHover) {
			this._toggleHoverLayerFlag(false);
			this.__dirty &= ~REDRAW_BIT;
		}
		return state;
	};
	Element$1.prototype.useStates = function(states, noAnimation, forceUseHoverLayer) {
		if (!states.length) this.clearStates();
		else {
			var stateObjects = [];
			var currentStates = this.currentStates;
			var len$1 = states.length;
			var notChange = len$1 === currentStates.length;
			if (notChange) {
				for (var i = 0; i < len$1; i++) if (states[i] !== currentStates[i]) {
					notChange = false;
					break;
				}
			}
			if (notChange) return;
			for (var i = 0; i < len$1; i++) {
				var stateName = states[i];
				var stateObj = void 0;
				if (this.stateProxy) stateObj = this.stateProxy(stateName, states);
				if (!stateObj) stateObj = this.states[stateName];
				if (stateObj) stateObjects.push(stateObj);
			}
			var lastStateObj = stateObjects[len$1 - 1];
			var useHoverLayer = !!(lastStateObj && lastStateObj.hoverLayer || forceUseHoverLayer);
			if (useHoverLayer) this._toggleHoverLayerFlag(true);
			var mergedState = this._mergeStates(stateObjects);
			var animationCfg = this.stateTransition;
			this.saveCurrentToNormalState(mergedState);
			this._applyStateObj(states.join(","), mergedState, this._normalState, false, !noAnimation && !this.__inHover && animationCfg && animationCfg.duration > 0, animationCfg);
			var textContent = this._textContent;
			var textGuide = this._textGuide;
			if (textContent) textContent.useStates(states, noAnimation, useHoverLayer);
			if (textGuide) textGuide.useStates(states, noAnimation, useHoverLayer);
			this._updateAnimationTargets();
			this.currentStates = states.slice();
			this.markRedraw();
			if (!useHoverLayer && this.__inHover) {
				this._toggleHoverLayerFlag(false);
				this.__dirty &= ~REDRAW_BIT;
			}
		}
	};
	Element$1.prototype.isSilent = function() {
		var isSilent = this.silent;
		var ancestor = this.parent;
		while (!isSilent && ancestor) {
			if (ancestor.silent) {
				isSilent = true;
				break;
			}
			ancestor = ancestor.parent;
		}
		return isSilent;
	};
	Element$1.prototype._updateAnimationTargets = function() {
		for (var i = 0; i < this.animators.length; i++) {
			var animator = this.animators[i];
			if (animator.targetName) animator.changeTarget(this[animator.targetName]);
		}
	};
	Element$1.prototype.removeState = function(state) {
		var idx = indexOf(this.currentStates, state);
		if (idx >= 0) {
			var currentStates = this.currentStates.slice();
			currentStates.splice(idx, 1);
			this.useStates(currentStates);
		}
	};
	Element$1.prototype.replaceState = function(oldState, newState, forceAdd) {
		var currentStates = this.currentStates.slice();
		var idx = indexOf(currentStates, oldState);
		var newStateExists = indexOf(currentStates, newState) >= 0;
		if (idx >= 0) if (!newStateExists) currentStates[idx] = newState;
		else currentStates.splice(idx, 1);
		else if (forceAdd && !newStateExists) currentStates.push(newState);
		this.useStates(currentStates);
	};
	Element$1.prototype.toggleState = function(state, enable) {
		if (enable) this.useState(state, true);
		else this.removeState(state);
	};
	Element$1.prototype._mergeStates = function(states) {
		var mergedState = {};
		var mergedTextConfig;
		for (var i = 0; i < states.length; i++) {
			var state = states[i];
			extend(mergedState, state);
			if (state.textConfig) {
				mergedTextConfig = mergedTextConfig || {};
				extend(mergedTextConfig, state.textConfig);
			}
		}
		if (mergedTextConfig) mergedState.textConfig = mergedTextConfig;
		return mergedState;
	};
	Element$1.prototype._applyStateObj = function(stateName, state, normalState, keepCurrentStates, transition, animationCfg) {
		var needsRestoreToNormal = !(state && keepCurrentStates);
		if (state && state.textConfig) {
			this.textConfig = extend({}, keepCurrentStates ? this.textConfig : normalState.textConfig);
			extend(this.textConfig, state.textConfig);
		} else if (needsRestoreToNormal) {
			if (normalState.textConfig) this.textConfig = normalState.textConfig;
		}
		var transitionTarget = {};
		var hasTransition = false;
		for (var i = 0; i < PRIMARY_STATES_KEYS$1.length; i++) {
			var key = PRIMARY_STATES_KEYS$1[i];
			var propNeedsTransition = transition && DEFAULT_ANIMATABLE_MAP[key];
			if (state && state[key] != null) if (propNeedsTransition) {
				hasTransition = true;
				transitionTarget[key] = state[key];
			} else this[key] = state[key];
			else if (needsRestoreToNormal) {
				if (normalState[key] != null) if (propNeedsTransition) {
					hasTransition = true;
					transitionTarget[key] = normalState[key];
				} else this[key] = normalState[key];
			}
		}
		if (!transition) for (var i = 0; i < this.animators.length; i++) {
			var animator = this.animators[i];
			var targetName = animator.targetName;
			if (!animator.getLoop()) animator.__changeFinalValue(targetName ? (state || normalState)[targetName] : state || normalState);
		}
		if (hasTransition) this._transitionState(stateName, transitionTarget, animationCfg);
	};
	Element$1.prototype._attachComponent = function(componentEl) {
		if (componentEl.__zr && !componentEl.__hostTarget) return;
		if (componentEl === this) return;
		var zr = this.__zr;
		if (zr) componentEl.addSelfToZr(zr);
		componentEl.__zr = zr;
		componentEl.__hostTarget = this;
	};
	Element$1.prototype._detachComponent = function(componentEl) {
		if (componentEl.__zr) componentEl.removeSelfFromZr(componentEl.__zr);
		componentEl.__zr = null;
		componentEl.__hostTarget = null;
	};
	Element$1.prototype.getClipPath = function() {
		return this._clipPath;
	};
	Element$1.prototype.setClipPath = function(clipPath) {
		if (this._clipPath && this._clipPath !== clipPath) this.removeClipPath();
		this._attachComponent(clipPath);
		this._clipPath = clipPath;
		this.markRedraw();
	};
	Element$1.prototype.removeClipPath = function() {
		var clipPath = this._clipPath;
		if (clipPath) {
			this._detachComponent(clipPath);
			this._clipPath = null;
			this.markRedraw();
		}
	};
	Element$1.prototype.getTextContent = function() {
		return this._textContent;
	};
	Element$1.prototype.setTextContent = function(textEl) {
		var previousTextContent = this._textContent;
		if (previousTextContent === textEl) return;
		if (previousTextContent && previousTextContent !== textEl) this.removeTextContent();
		textEl.innerTransformable = new Transformable_default();
		this._attachComponent(textEl);
		this._textContent = textEl;
		this.markRedraw();
	};
	Element$1.prototype.setTextConfig = function(cfg) {
		if (!this.textConfig) this.textConfig = {};
		extend(this.textConfig, cfg);
		this.markRedraw();
	};
	Element$1.prototype.removeTextConfig = function() {
		this.textConfig = null;
		this.markRedraw();
	};
	Element$1.prototype.removeTextContent = function() {
		var textEl = this._textContent;
		if (textEl) {
			textEl.innerTransformable = null;
			this._detachComponent(textEl);
			this._textContent = null;
			this._innerTextDefaultStyle = null;
			this.markRedraw();
		}
	};
	Element$1.prototype.getTextGuideLine = function() {
		return this._textGuide;
	};
	Element$1.prototype.setTextGuideLine = function(guideLine) {
		if (this._textGuide && this._textGuide !== guideLine) this.removeTextGuideLine();
		this._attachComponent(guideLine);
		this._textGuide = guideLine;
		this.markRedraw();
	};
	Element$1.prototype.removeTextGuideLine = function() {
		var textGuide = this._textGuide;
		if (textGuide) {
			this._detachComponent(textGuide);
			this._textGuide = null;
			this.markRedraw();
		}
	};
	Element$1.prototype.markRedraw = function() {
		this.__dirty |= REDRAW_BIT;
		var zr = this.__zr;
		if (zr) if (this.__inHover) zr.refreshHover();
		else zr.refresh();
		if (this.__hostTarget) this.__hostTarget.markRedraw();
	};
	Element$1.prototype.dirty = function() {
		this.markRedraw();
	};
	Element$1.prototype._toggleHoverLayerFlag = function(inHover) {
		this.__inHover = inHover;
		var textContent = this._textContent;
		var textGuide = this._textGuide;
		if (textContent) textContent.__inHover = inHover;
		if (textGuide) textGuide.__inHover = inHover;
	};
	Element$1.prototype.addSelfToZr = function(zr) {
		if (this.__zr === zr) return;
		this.__zr = zr;
		var animators = this.animators;
		if (animators) for (var i = 0; i < animators.length; i++) zr.animation.addAnimator(animators[i]);
		if (this._clipPath) this._clipPath.addSelfToZr(zr);
		if (this._textContent) this._textContent.addSelfToZr(zr);
		if (this._textGuide) this._textGuide.addSelfToZr(zr);
	};
	Element$1.prototype.removeSelfFromZr = function(zr) {
		if (!this.__zr) return;
		this.__zr = null;
		var animators = this.animators;
		if (animators) for (var i = 0; i < animators.length; i++) zr.animation.removeAnimator(animators[i]);
		if (this._clipPath) this._clipPath.removeSelfFromZr(zr);
		if (this._textContent) this._textContent.removeSelfFromZr(zr);
		if (this._textGuide) this._textGuide.removeSelfFromZr(zr);
	};
	Element$1.prototype.animate = function(key, loop, allowDiscreteAnimation) {
		var target = key ? this[key] : this;
		var animator = new Animator_default(target, loop, allowDiscreteAnimation);
		key && (animator.targetName = key);
		this.addAnimator(animator, key);
		return animator;
	};
	Element$1.prototype.addAnimator = function(animator, key) {
		var zr = this.__zr;
		var el = this;
		animator.during(function() {
			el.updateDuringAnimation(key);
		}).done(function() {
			var animators = el.animators;
			var idx = indexOf(animators, animator);
			if (idx >= 0) animators.splice(idx, 1);
		});
		this.animators.push(animator);
		if (zr) zr.animation.addAnimator(animator);
		zr && zr.wakeUp();
	};
	Element$1.prototype.updateDuringAnimation = function(key) {
		this.markRedraw();
	};
	Element$1.prototype.stopAnimation = function(scope, forwardToLast) {
		var animators = this.animators;
		var len$1 = animators.length;
		var leftAnimators = [];
		for (var i = 0; i < len$1; i++) {
			var animator = animators[i];
			if (!scope || scope === animator.scope) animator.stop(forwardToLast);
			else leftAnimators.push(animator);
		}
		this.animators = leftAnimators;
		return this;
	};
	Element$1.prototype.animateTo = function(target, cfg, animationProps) {
		animateTo(this, target, cfg, animationProps);
	};
	Element$1.prototype.animateFrom = function(target, cfg, animationProps) {
		animateTo(this, target, cfg, animationProps, true);
	};
	Element$1.prototype._transitionState = function(stateName, target, cfg, animationProps) {
		var animators = animateTo(this, target, cfg, animationProps);
		for (var i = 0; i < animators.length; i++) animators[i].__fromStateTransition = stateName;
	};
	Element$1.prototype.getBoundingRect = function() {
		return null;
	};
	Element$1.prototype.getPaintRect = function() {
		return null;
	};
	Element$1.initDefaultProps = function() {
		var elProto = Element$1.prototype;
		elProto.type = "element";
		elProto.name = "";
		elProto.ignore = elProto.silent = elProto.isGroup = elProto.draggable = elProto.dragging = elProto.ignoreClip = elProto.__inHover = false;
		elProto.__dirty = REDRAW_BIT;
		var logs = {};
		function logDeprecatedError(key, xKey, yKey) {
			if (!logs[key + xKey + yKey]) {
				console.warn("DEPRECATED: '" + key + "' has been deprecated. use '" + xKey + "', '" + yKey + "' instead");
				logs[key + xKey + yKey] = true;
			}
		}
		function createLegacyProperty(key, privateKey, xKey, yKey) {
			Object.defineProperty(elProto, key, {
				get: function() {
					if (!this[privateKey]) {
						var pos = this[privateKey] = [];
						enhanceArray(this, pos);
					}
					return this[privateKey];
				},
				set: function(pos) {
					this[xKey] = pos[0];
					this[yKey] = pos[1];
					this[privateKey] = pos;
					enhanceArray(this, pos);
				}
			});
			function enhanceArray(self$1, pos) {
				Object.defineProperty(pos, 0, {
					get: function() {
						return self$1[xKey];
					},
					set: function(val) {
						self$1[xKey] = val;
					}
				});
				Object.defineProperty(pos, 1, {
					get: function() {
						return self$1[yKey];
					},
					set: function(val) {
						self$1[yKey] = val;
					}
				});
			}
		}
		if (Object.defineProperty) {
			createLegacyProperty("position", "_legacyPos", "x", "y");
			createLegacyProperty("scale", "_legacyScale", "scaleX", "scaleY");
			createLegacyProperty("origin", "_legacyOrigin", "originX", "originY");
		}
	}();
	return Element$1;
}();
mixin(Element, Eventful_default);
mixin(Element, Transformable_default);
function animateTo(animatable, target, cfg, animationProps, reverse) {
	cfg = cfg || {};
	var animators = [];
	animateToShallow(animatable, "", animatable, target, cfg, animationProps, animators, reverse);
	var finishCount = animators.length;
	var doneHappened = false;
	var cfgDone = cfg.done;
	var cfgAborted = cfg.aborted;
	var doneCb = function() {
		doneHappened = true;
		finishCount--;
		if (finishCount <= 0) doneHappened ? cfgDone && cfgDone() : cfgAborted && cfgAborted();
	};
	var abortedCb = function() {
		finishCount--;
		if (finishCount <= 0) doneHappened ? cfgDone && cfgDone() : cfgAborted && cfgAborted();
	};
	if (!finishCount) cfgDone && cfgDone();
	if (animators.length > 0 && cfg.during) animators[0].during(function(target$1, percent) {
		cfg.during(percent);
	});
	for (var i = 0; i < animators.length; i++) {
		var animator = animators[i];
		if (doneCb) animator.done(doneCb);
		if (abortedCb) animator.aborted(abortedCb);
		if (cfg.force) animator.duration(cfg.duration);
		animator.start(cfg.easing);
	}
	return animators;
}
function copyArrShallow(source, target, len$1) {
	for (var i = 0; i < len$1; i++) source[i] = target[i];
}
function is2DArray(value) {
	return isArrayLike(value[0]);
}
function copyValue(target, source, key) {
	if (isArrayLike(source[key])) {
		if (!isArrayLike(target[key])) target[key] = [];
		if (isTypedArray(source[key])) {
			var len$1 = source[key].length;
			if (target[key].length !== len$1) {
				target[key] = new source[key].constructor(len$1);
				copyArrShallow(target[key], source[key], len$1);
			}
		} else {
			var sourceArr = source[key];
			var targetArr = target[key];
			var len0 = sourceArr.length;
			if (is2DArray(sourceArr)) {
				var len1 = sourceArr[0].length;
				for (var i = 0; i < len0; i++) if (!targetArr[i]) targetArr[i] = Array.prototype.slice.call(sourceArr[i]);
				else copyArrShallow(targetArr[i], sourceArr[i], len1);
			} else copyArrShallow(targetArr, sourceArr, len0);
			targetArr.length = sourceArr.length;
		}
	} else target[key] = source[key];
}
function isValueSame(val1, val2) {
	return val1 === val2 || isArrayLike(val1) && isArrayLike(val2) && is1DArraySame(val1, val2);
}
function is1DArraySame(arr0, arr1) {
	var len$1 = arr0.length;
	if (len$1 !== arr1.length) return false;
	for (var i = 0; i < len$1; i++) if (arr0[i] !== arr1[i]) return false;
	return true;
}
function animateToShallow(animatable, topKey, animateObj, target, cfg, animationProps, animators, reverse) {
	var targetKeys = keys(target);
	var duration = cfg.duration;
	var delay = cfg.delay;
	var additive = cfg.additive;
	var setToFinal = cfg.setToFinal;
	var animateAll = !isObject$2(animationProps);
	var existsAnimators = animatable.animators;
	var animationKeys = [];
	for (var k = 0; k < targetKeys.length; k++) {
		var innerKey = targetKeys[k];
		var targetVal = target[innerKey];
		if (targetVal != null && animateObj[innerKey] != null && (animateAll || animationProps[innerKey])) if (isObject$2(targetVal) && !isArrayLike(targetVal) && !isGradientObject(targetVal)) {
			if (topKey) {
				if (!reverse) {
					animateObj[innerKey] = targetVal;
					animatable.updateDuringAnimation(topKey);
				}
				continue;
			}
			animateToShallow(animatable, innerKey, animateObj[innerKey], targetVal, cfg, animationProps && animationProps[innerKey], animators, reverse);
		} else animationKeys.push(innerKey);
		else if (!reverse) {
			animateObj[innerKey] = targetVal;
			animatable.updateDuringAnimation(topKey);
			animationKeys.push(innerKey);
		}
	}
	var keyLen = animationKeys.length;
	if (!additive && keyLen) for (var i = 0; i < existsAnimators.length; i++) {
		var animator = existsAnimators[i];
		if (animator.targetName === topKey) {
			var allAborted = animator.stopTracks(animationKeys);
			if (allAborted) {
				var idx = indexOf(existsAnimators, animator);
				existsAnimators.splice(idx, 1);
			}
		}
	}
	if (!cfg.force) {
		animationKeys = filter(animationKeys, function(key) {
			return !isValueSame(target[key], animateObj[key]);
		});
		keyLen = animationKeys.length;
	}
	if (keyLen > 0 || cfg.force && !animators.length) {
		var revertedSource = void 0;
		var reversedTarget = void 0;
		var sourceClone = void 0;
		if (reverse) {
			reversedTarget = {};
			if (setToFinal) revertedSource = {};
			for (var i = 0; i < keyLen; i++) {
				var innerKey = animationKeys[i];
				reversedTarget[innerKey] = animateObj[innerKey];
				if (setToFinal) revertedSource[innerKey] = target[innerKey];
				else animateObj[innerKey] = target[innerKey];
			}
		} else if (setToFinal) {
			sourceClone = {};
			for (var i = 0; i < keyLen; i++) {
				var innerKey = animationKeys[i];
				sourceClone[innerKey] = cloneValue(animateObj[innerKey]);
				copyValue(animateObj, target, innerKey);
			}
		}
		var animator = new Animator_default(animateObj, false, false, additive ? filter(existsAnimators, function(animator$1) {
			return animator$1.targetName === topKey;
		}) : null);
		animator.targetName = topKey;
		if (cfg.scope) animator.scope = cfg.scope;
		if (setToFinal && revertedSource) animator.whenWithKeys(0, revertedSource, animationKeys);
		if (sourceClone) animator.whenWithKeys(0, sourceClone, animationKeys);
		animator.whenWithKeys(duration == null ? 500 : duration, reverse ? reversedTarget : target, animationKeys).delay(delay || 0);
		animatable.addAnimator(animator, topKey);
		animators.push(animator);
	}
}
var Element_default = Element;
var STYLE_MAGIC_KEY = "__zr_style_" + Math.round(Math.random() * 10);
var DEFAULT_COMMON_STYLE = {
	shadowBlur: 0,
	shadowOffsetX: 0,
	shadowOffsetY: 0,
	shadowColor: "#000",
	opacity: 1,
	blend: "source-over"
};
var DEFAULT_COMMON_ANIMATION_PROPS = { style: {
	shadowBlur: true,
	shadowOffsetX: true,
	shadowOffsetY: true,
	shadowColor: true,
	opacity: true
} };
DEFAULT_COMMON_STYLE[STYLE_MAGIC_KEY] = true;
var PRIMARY_STATES_KEYS = [
	"z",
	"z2",
	"invisible"
];
var PRIMARY_STATES_KEYS_IN_HOVER_LAYER = ["invisible"];
var Displayable = function(_super) {
	__extends(Displayable$1, _super);
	function Displayable$1(props) {
		return _super.call(this, props) || this;
	}
	Displayable$1.prototype._init = function(props) {
		var keysArr = keys(props);
		for (var i = 0; i < keysArr.length; i++) {
			var key = keysArr[i];
			if (key === "style") this.useStyle(props[key]);
			else _super.prototype.attrKV.call(this, key, props[key]);
		}
		if (!this.style) this.useStyle({});
	};
	Displayable$1.prototype.beforeBrush = function() {};
	Displayable$1.prototype.afterBrush = function() {};
	Displayable$1.prototype.innerBeforeBrush = function() {};
	Displayable$1.prototype.innerAfterBrush = function() {};
	Displayable$1.prototype.shouldBePainted = function(viewWidth, viewHeight, considerClipPath, considerAncestors) {
		var m$1 = this.transform;
		if (this.ignore || this.invisible || this.style.opacity === 0 || this.culling && isDisplayableCulled(this, viewWidth, viewHeight) || m$1 && !m$1[0] && !m$1[3]) return false;
		if (considerClipPath && this.__clipPaths) {
			for (var i = 0; i < this.__clipPaths.length; ++i) if (this.__clipPaths[i].isZeroArea()) return false;
		}
		if (considerAncestors && this.parent) {
			var parent_1 = this.parent;
			while (parent_1) {
				if (parent_1.ignore) return false;
				parent_1 = parent_1.parent;
			}
		}
		return true;
	};
	Displayable$1.prototype.contain = function(x, y) {
		return this.rectContain(x, y);
	};
	Displayable$1.prototype.traverse = function(cb, context) {
		cb.call(context, this);
	};
	Displayable$1.prototype.rectContain = function(x, y) {
		var coord = this.transformCoordToLocal(x, y);
		var rect = this.getBoundingRect();
		return rect.contain(coord[0], coord[1]);
	};
	Displayable$1.prototype.getPaintRect = function() {
		var rect = this._paintRect;
		if (!this._paintRect || this.__dirty) {
			var transform = this.transform;
			var elRect = this.getBoundingRect();
			var style = this.style;
			var shadowSize = style.shadowBlur || 0;
			var shadowOffsetX = style.shadowOffsetX || 0;
			var shadowOffsetY = style.shadowOffsetY || 0;
			rect = this._paintRect || (this._paintRect = new BoundingRect_default(0, 0, 0, 0));
			if (transform) BoundingRect_default.applyTransform(rect, elRect, transform);
			else rect.copy(elRect);
			if (shadowSize || shadowOffsetX || shadowOffsetY) {
				rect.width += shadowSize * 2 + Math.abs(shadowOffsetX);
				rect.height += shadowSize * 2 + Math.abs(shadowOffsetY);
				rect.x = Math.min(rect.x, rect.x + shadowOffsetX - shadowSize);
				rect.y = Math.min(rect.y, rect.y + shadowOffsetY - shadowSize);
			}
			var tolerance = this.dirtyRectTolerance;
			if (!rect.isZero()) {
				rect.x = Math.floor(rect.x - tolerance);
				rect.y = Math.floor(rect.y - tolerance);
				rect.width = Math.ceil(rect.width + 1 + tolerance * 2);
				rect.height = Math.ceil(rect.height + 1 + tolerance * 2);
			}
		}
		return rect;
	};
	Displayable$1.prototype.setPrevPaintRect = function(paintRect) {
		if (paintRect) {
			this._prevPaintRect = this._prevPaintRect || new BoundingRect_default(0, 0, 0, 0);
			this._prevPaintRect.copy(paintRect);
		} else this._prevPaintRect = null;
	};
	Displayable$1.prototype.getPrevPaintRect = function() {
		return this._prevPaintRect;
	};
	Displayable$1.prototype.animateStyle = function(loop) {
		return this.animate("style", loop);
	};
	Displayable$1.prototype.updateDuringAnimation = function(targetKey) {
		if (targetKey === "style") this.dirtyStyle();
		else this.markRedraw();
	};
	Displayable$1.prototype.attrKV = function(key, value) {
		if (key !== "style") _super.prototype.attrKV.call(this, key, value);
		else if (!this.style) this.useStyle(value);
		else this.setStyle(value);
	};
	Displayable$1.prototype.setStyle = function(keyOrObj, value) {
		if (typeof keyOrObj === "string") this.style[keyOrObj] = value;
		else extend(this.style, keyOrObj);
		this.dirtyStyle();
		return this;
	};
	Displayable$1.prototype.dirtyStyle = function(notRedraw) {
		if (!notRedraw) this.markRedraw();
		this.__dirty |= STYLE_CHANGED_BIT;
		if (this._rect) this._rect = null;
	};
	Displayable$1.prototype.dirty = function() {
		this.dirtyStyle();
	};
	Displayable$1.prototype.styleChanged = function() {
		return !!(this.__dirty & STYLE_CHANGED_BIT);
	};
	Displayable$1.prototype.styleUpdated = function() {
		this.__dirty &= ~STYLE_CHANGED_BIT;
	};
	Displayable$1.prototype.createStyle = function(obj) {
		return createObject(DEFAULT_COMMON_STYLE, obj);
	};
	Displayable$1.prototype.useStyle = function(obj) {
		if (!obj[STYLE_MAGIC_KEY]) obj = this.createStyle(obj);
		if (this.__inHover) this.__hoverStyle = obj;
		else this.style = obj;
		this.dirtyStyle();
	};
	Displayable$1.prototype.isStyleObject = function(obj) {
		return obj[STYLE_MAGIC_KEY];
	};
	Displayable$1.prototype._innerSaveToNormal = function(toState) {
		_super.prototype._innerSaveToNormal.call(this, toState);
		var normalState = this._normalState;
		if (toState.style && !normalState.style) normalState.style = this._mergeStyle(this.createStyle(), this.style);
		this._savePrimaryToNormal(toState, normalState, PRIMARY_STATES_KEYS);
	};
	Displayable$1.prototype._applyStateObj = function(stateName, state, normalState, keepCurrentStates, transition, animationCfg) {
		_super.prototype._applyStateObj.call(this, stateName, state, normalState, keepCurrentStates, transition, animationCfg);
		var needsRestoreToNormal = !(state && keepCurrentStates);
		var targetStyle;
		if (state && state.style) if (transition) if (keepCurrentStates) targetStyle = state.style;
		else {
			targetStyle = this._mergeStyle(this.createStyle(), normalState.style);
			this._mergeStyle(targetStyle, state.style);
		}
		else {
			targetStyle = this._mergeStyle(this.createStyle(), keepCurrentStates ? this.style : normalState.style);
			this._mergeStyle(targetStyle, state.style);
		}
		else if (needsRestoreToNormal) targetStyle = normalState.style;
		if (targetStyle) if (transition) {
			var sourceStyle = this.style;
			this.style = this.createStyle(needsRestoreToNormal ? {} : sourceStyle);
			if (needsRestoreToNormal) {
				var changedKeys = keys(sourceStyle);
				for (var i = 0; i < changedKeys.length; i++) {
					var key = changedKeys[i];
					if (key in targetStyle) {
						targetStyle[key] = targetStyle[key];
						this.style[key] = sourceStyle[key];
					}
				}
			}
			var targetKeys = keys(targetStyle);
			for (var i = 0; i < targetKeys.length; i++) {
				var key = targetKeys[i];
				this.style[key] = this.style[key];
			}
			this._transitionState(stateName, { style: targetStyle }, animationCfg, this.getAnimationStyleProps());
		} else this.useStyle(targetStyle);
		var statesKeys = this.__inHover ? PRIMARY_STATES_KEYS_IN_HOVER_LAYER : PRIMARY_STATES_KEYS;
		for (var i = 0; i < statesKeys.length; i++) {
			var key = statesKeys[i];
			if (state && state[key] != null) this[key] = state[key];
			else if (needsRestoreToNormal) {
				if (normalState[key] != null) this[key] = normalState[key];
			}
		}
	};
	Displayable$1.prototype._mergeStates = function(states) {
		var mergedState = _super.prototype._mergeStates.call(this, states);
		var mergedStyle;
		for (var i = 0; i < states.length; i++) {
			var state = states[i];
			if (state.style) {
				mergedStyle = mergedStyle || {};
				this._mergeStyle(mergedStyle, state.style);
			}
		}
		if (mergedStyle) mergedState.style = mergedStyle;
		return mergedState;
	};
	Displayable$1.prototype._mergeStyle = function(targetStyle, sourceStyle) {
		extend(targetStyle, sourceStyle);
		return targetStyle;
	};
	Displayable$1.prototype.getAnimationStyleProps = function() {
		return DEFAULT_COMMON_ANIMATION_PROPS;
	};
	Displayable$1.initDefaultProps = function() {
		var dispProto = Displayable$1.prototype;
		dispProto.type = "displayable";
		dispProto.invisible = false;
		dispProto.z = 0;
		dispProto.z2 = 0;
		dispProto.zlevel = 0;
		dispProto.culling = false;
		dispProto.cursor = "pointer";
		dispProto.rectHover = false;
		dispProto.incremental = false;
		dispProto._rect = null;
		dispProto.dirtyRectTolerance = 0;
		dispProto.__dirty = REDRAW_BIT | STYLE_CHANGED_BIT;
	}();
	return Displayable$1;
}(Element_default);
var tmpRect$1 = new BoundingRect_default(0, 0, 0, 0);
var viewRect = new BoundingRect_default(0, 0, 0, 0);
function isDisplayableCulled(el, width, height) {
	tmpRect$1.copy(el.getBoundingRect());
	if (el.transform) tmpRect$1.applyTransform(el.transform);
	viewRect.width = width;
	viewRect.height = height;
	return !tmpRect$1.intersect(viewRect);
}
var Displayable_default = Displayable;
var mathMin$4 = Math.min;
var mathMax$4 = Math.max;
var mathSin$3 = Math.sin;
var mathCos$3 = Math.cos;
var PI2$5 = Math.PI * 2;
var start = create();
var end = create();
var extremity = create();
function fromLine(x0, y0, x1, y1, min$2, max$2) {
	min$2[0] = mathMin$4(x0, x1);
	min$2[1] = mathMin$4(y0, y1);
	max$2[0] = mathMax$4(x0, x1);
	max$2[1] = mathMax$4(y0, y1);
}
var xDim = [];
var yDim = [];
function fromCubic(x0, y0, x1, y1, x2, y2, x3, y3, min$2, max$2) {
	var cubicExtrema$1 = cubicExtrema;
	var cubicAt$1 = cubicAt;
	var n = cubicExtrema$1(x0, x1, x2, x3, xDim);
	min$2[0] = Infinity;
	min$2[1] = Infinity;
	max$2[0] = -Infinity;
	max$2[1] = -Infinity;
	for (var i = 0; i < n; i++) {
		var x = cubicAt$1(x0, x1, x2, x3, xDim[i]);
		min$2[0] = mathMin$4(x, min$2[0]);
		max$2[0] = mathMax$4(x, max$2[0]);
	}
	n = cubicExtrema$1(y0, y1, y2, y3, yDim);
	for (var i = 0; i < n; i++) {
		var y = cubicAt$1(y0, y1, y2, y3, yDim[i]);
		min$2[1] = mathMin$4(y, min$2[1]);
		max$2[1] = mathMax$4(y, max$2[1]);
	}
	min$2[0] = mathMin$4(x0, min$2[0]);
	max$2[0] = mathMax$4(x0, max$2[0]);
	min$2[0] = mathMin$4(x3, min$2[0]);
	max$2[0] = mathMax$4(x3, max$2[0]);
	min$2[1] = mathMin$4(y0, min$2[1]);
	max$2[1] = mathMax$4(y0, max$2[1]);
	min$2[1] = mathMin$4(y3, min$2[1]);
	max$2[1] = mathMax$4(y3, max$2[1]);
}
function fromQuadratic(x0, y0, x1, y1, x2, y2, min$2, max$2) {
	var quadraticExtremum$1 = quadraticExtremum;
	var quadraticAt$1 = quadraticAt;
	var tx = mathMax$4(mathMin$4(quadraticExtremum$1(x0, x1, x2), 1), 0);
	var ty = mathMax$4(mathMin$4(quadraticExtremum$1(y0, y1, y2), 1), 0);
	var x = quadraticAt$1(x0, x1, x2, tx);
	var y = quadraticAt$1(y0, y1, y2, ty);
	min$2[0] = mathMin$4(x0, x2, x);
	min$2[1] = mathMin$4(y0, y2, y);
	max$2[0] = mathMax$4(x0, x2, x);
	max$2[1] = mathMax$4(y0, y2, y);
}
function fromArc(x, y, rx, ry, startAngle, endAngle, anticlockwise, min$2, max$2) {
	var vec2Min = min$1;
	var vec2Max = max$1;
	var diff = Math.abs(startAngle - endAngle);
	if (diff % PI2$5 < 1e-4 && diff > 1e-4) {
		min$2[0] = x - rx;
		min$2[1] = y - ry;
		max$2[0] = x + rx;
		max$2[1] = y + ry;
		return;
	}
	start[0] = mathCos$3(startAngle) * rx + x;
	start[1] = mathSin$3(startAngle) * ry + y;
	end[0] = mathCos$3(endAngle) * rx + x;
	end[1] = mathSin$3(endAngle) * ry + y;
	vec2Min(min$2, start, end);
	vec2Max(max$2, start, end);
	startAngle = startAngle % PI2$5;
	if (startAngle < 0) startAngle = startAngle + PI2$5;
	endAngle = endAngle % PI2$5;
	if (endAngle < 0) endAngle = endAngle + PI2$5;
	if (startAngle > endAngle && !anticlockwise) endAngle += PI2$5;
	else if (startAngle < endAngle && anticlockwise) startAngle += PI2$5;
	if (anticlockwise) {
		var tmp = endAngle;
		endAngle = startAngle;
		startAngle = tmp;
	}
	for (var angle = 0; angle < endAngle; angle += Math.PI / 2) if (angle > startAngle) {
		extremity[0] = mathCos$3(angle) * rx + x;
		extremity[1] = mathSin$3(angle) * ry + y;
		vec2Min(min$2, extremity, min$2);
		vec2Max(max$2, extremity, max$2);
	}
}
var CMD$2 = {
	M: 1,
	L: 2,
	C: 3,
	Q: 4,
	A: 5,
	Z: 6,
	R: 7
};
var tmpOutX = [];
var tmpOutY = [];
var min = [];
var max = [];
var min2 = [];
var max2 = [];
var mathMin$3 = Math.min;
var mathMax$3 = Math.max;
var mathCos$2 = Math.cos;
var mathSin$2 = Math.sin;
var mathAbs$1 = Math.abs;
var PI$4 = Math.PI;
var PI2$4 = PI$4 * 2;
var hasTypedArray = typeof Float32Array !== "undefined";
var tmpAngles = [];
function modPI2(radian) {
	var n = Math.round(radian / PI$4 * 1e8) / 1e8;
	return n % 2 * PI$4;
}
function normalizeArcAngles(angles, anticlockwise) {
	var newStartAngle = modPI2(angles[0]);
	if (newStartAngle < 0) newStartAngle += PI2$4;
	var delta = newStartAngle - angles[0];
	var newEndAngle = angles[1];
	newEndAngle += delta;
	if (!anticlockwise && newEndAngle - newStartAngle >= PI2$4) newEndAngle = newStartAngle + PI2$4;
	else if (anticlockwise && newStartAngle - newEndAngle >= PI2$4) newEndAngle = newStartAngle - PI2$4;
	else if (!anticlockwise && newStartAngle > newEndAngle) newEndAngle = newStartAngle + (PI2$4 - modPI2(newStartAngle - newEndAngle));
	else if (anticlockwise && newStartAngle < newEndAngle) newEndAngle = newStartAngle - (PI2$4 - modPI2(newEndAngle - newStartAngle));
	angles[0] = newStartAngle;
	angles[1] = newEndAngle;
}
var PathProxy = function() {
	function PathProxy$1(notSaveData) {
		this.dpr = 1;
		this._xi = 0;
		this._yi = 0;
		this._x0 = 0;
		this._y0 = 0;
		this._len = 0;
		if (notSaveData) this._saveData = false;
		if (this._saveData) this.data = [];
	}
	PathProxy$1.prototype.increaseVersion = function() {
		this._version++;
	};
	PathProxy$1.prototype.getVersion = function() {
		return this._version;
	};
	PathProxy$1.prototype.setScale = function(sx, sy, segmentIgnoreThreshold) {
		segmentIgnoreThreshold = segmentIgnoreThreshold || 0;
		if (segmentIgnoreThreshold > 0) {
			this._ux = mathAbs$1(segmentIgnoreThreshold / devicePixelRatio / sx) || 0;
			this._uy = mathAbs$1(segmentIgnoreThreshold / devicePixelRatio / sy) || 0;
		}
	};
	PathProxy$1.prototype.setDPR = function(dpr$1) {
		this.dpr = dpr$1;
	};
	PathProxy$1.prototype.setContext = function(ctx) {
		this._ctx = ctx;
	};
	PathProxy$1.prototype.getContext = function() {
		return this._ctx;
	};
	PathProxy$1.prototype.beginPath = function() {
		this._ctx && this._ctx.beginPath();
		this.reset();
		return this;
	};
	PathProxy$1.prototype.reset = function() {
		if (this._saveData) this._len = 0;
		if (this._pathSegLen) {
			this._pathSegLen = null;
			this._pathLen = 0;
		}
		this._version++;
	};
	PathProxy$1.prototype.moveTo = function(x, y) {
		this._drawPendingPt();
		this.addData(CMD$2.M, x, y);
		this._ctx && this._ctx.moveTo(x, y);
		this._x0 = x;
		this._y0 = y;
		this._xi = x;
		this._yi = y;
		return this;
	};
	PathProxy$1.prototype.lineTo = function(x, y) {
		var dx = mathAbs$1(x - this._xi);
		var dy = mathAbs$1(y - this._yi);
		var exceedUnit = dx > this._ux || dy > this._uy;
		this.addData(CMD$2.L, x, y);
		if (this._ctx && exceedUnit) this._ctx.lineTo(x, y);
		if (exceedUnit) {
			this._xi = x;
			this._yi = y;
			this._pendingPtDist = 0;
		} else {
			var d2 = dx * dx + dy * dy;
			if (d2 > this._pendingPtDist) {
				this._pendingPtX = x;
				this._pendingPtY = y;
				this._pendingPtDist = d2;
			}
		}
		return this;
	};
	PathProxy$1.prototype.bezierCurveTo = function(x1, y1, x2, y2, x3, y3) {
		this._drawPendingPt();
		this.addData(CMD$2.C, x1, y1, x2, y2, x3, y3);
		if (this._ctx) this._ctx.bezierCurveTo(x1, y1, x2, y2, x3, y3);
		this._xi = x3;
		this._yi = y3;
		return this;
	};
	PathProxy$1.prototype.quadraticCurveTo = function(x1, y1, x2, y2) {
		this._drawPendingPt();
		this.addData(CMD$2.Q, x1, y1, x2, y2);
		if (this._ctx) this._ctx.quadraticCurveTo(x1, y1, x2, y2);
		this._xi = x2;
		this._yi = y2;
		return this;
	};
	PathProxy$1.prototype.arc = function(cx, cy, r, startAngle, endAngle, anticlockwise) {
		this._drawPendingPt();
		tmpAngles[0] = startAngle;
		tmpAngles[1] = endAngle;
		normalizeArcAngles(tmpAngles, anticlockwise);
		startAngle = tmpAngles[0];
		endAngle = tmpAngles[1];
		var delta = endAngle - startAngle;
		this.addData(CMD$2.A, cx, cy, r, r, startAngle, delta, 0, anticlockwise ? 0 : 1);
		this._ctx && this._ctx.arc(cx, cy, r, startAngle, endAngle, anticlockwise);
		this._xi = mathCos$2(endAngle) * r + cx;
		this._yi = mathSin$2(endAngle) * r + cy;
		return this;
	};
	PathProxy$1.prototype.arcTo = function(x1, y1, x2, y2, radius) {
		this._drawPendingPt();
		if (this._ctx) this._ctx.arcTo(x1, y1, x2, y2, radius);
		return this;
	};
	PathProxy$1.prototype.rect = function(x, y, w, h$1) {
		this._drawPendingPt();
		this._ctx && this._ctx.rect(x, y, w, h$1);
		this.addData(CMD$2.R, x, y, w, h$1);
		return this;
	};
	PathProxy$1.prototype.closePath = function() {
		this._drawPendingPt();
		this.addData(CMD$2.Z);
		var ctx = this._ctx;
		var x0 = this._x0;
		var y0 = this._y0;
		if (ctx) ctx.closePath();
		this._xi = x0;
		this._yi = y0;
		return this;
	};
	PathProxy$1.prototype.fill = function(ctx) {
		ctx && ctx.fill();
		this.toStatic();
	};
	PathProxy$1.prototype.stroke = function(ctx) {
		ctx && ctx.stroke();
		this.toStatic();
	};
	PathProxy$1.prototype.len = function() {
		return this._len;
	};
	PathProxy$1.prototype.setData = function(data) {
		var len$1 = data.length;
		if (!(this.data && this.data.length === len$1) && hasTypedArray) this.data = new Float32Array(len$1);
		for (var i = 0; i < len$1; i++) this.data[i] = data[i];
		this._len = len$1;
	};
	PathProxy$1.prototype.appendPath = function(path) {
		if (!(path instanceof Array)) path = [path];
		var len$1 = path.length;
		var appendSize = 0;
		var offset = this._len;
		for (var i = 0; i < len$1; i++) appendSize += path[i].len();
		if (hasTypedArray && this.data instanceof Float32Array) this.data = new Float32Array(offset + appendSize);
		for (var i = 0; i < len$1; i++) {
			var appendPathData = path[i].data;
			for (var k = 0; k < appendPathData.length; k++) this.data[offset++] = appendPathData[k];
		}
		this._len = offset;
	};
	PathProxy$1.prototype.addData = function(cmd, a, b, c, d, e$1, f, g, h$1) {
		if (!this._saveData) return;
		var data = this.data;
		if (this._len + arguments.length > data.length) {
			this._expandData();
			data = this.data;
		}
		for (var i = 0; i < arguments.length; i++) data[this._len++] = arguments[i];
	};
	PathProxy$1.prototype._drawPendingPt = function() {
		if (this._pendingPtDist > 0) {
			this._ctx && this._ctx.lineTo(this._pendingPtX, this._pendingPtY);
			this._pendingPtDist = 0;
		}
	};
	PathProxy$1.prototype._expandData = function() {
		if (!(this.data instanceof Array)) {
			var newData = [];
			for (var i = 0; i < this._len; i++) newData[i] = this.data[i];
			this.data = newData;
		}
	};
	PathProxy$1.prototype.toStatic = function() {
		if (!this._saveData) return;
		this._drawPendingPt();
		var data = this.data;
		if (data instanceof Array) {
			data.length = this._len;
			if (hasTypedArray && this._len > 11) this.data = new Float32Array(data);
		}
	};
	PathProxy$1.prototype.getBoundingRect = function() {
		min[0] = min[1] = min2[0] = min2[1] = Number.MAX_VALUE;
		max[0] = max[1] = max2[0] = max2[1] = -Number.MAX_VALUE;
		var data = this.data;
		var xi = 0;
		var yi = 0;
		var x0 = 0;
		var y0 = 0;
		var i;
		for (i = 0; i < this._len;) {
			var cmd = data[i++];
			var isFirst = i === 1;
			if (isFirst) {
				xi = data[i];
				yi = data[i + 1];
				x0 = xi;
				y0 = yi;
			}
			switch (cmd) {
				case CMD$2.M:
					xi = x0 = data[i++];
					yi = y0 = data[i++];
					min2[0] = x0;
					min2[1] = y0;
					max2[0] = x0;
					max2[1] = y0;
					break;
				case CMD$2.L:
					fromLine(xi, yi, data[i], data[i + 1], min2, max2);
					xi = data[i++];
					yi = data[i++];
					break;
				case CMD$2.C:
					fromCubic(xi, yi, data[i++], data[i++], data[i++], data[i++], data[i], data[i + 1], min2, max2);
					xi = data[i++];
					yi = data[i++];
					break;
				case CMD$2.Q:
					fromQuadratic(xi, yi, data[i++], data[i++], data[i], data[i + 1], min2, max2);
					xi = data[i++];
					yi = data[i++];
					break;
				case CMD$2.A:
					var cx = data[i++];
					var cy = data[i++];
					var rx = data[i++];
					var ry = data[i++];
					var startAngle = data[i++];
					var endAngle = data[i++] + startAngle;
					i += 1;
					var anticlockwise = !data[i++];
					if (isFirst) {
						x0 = mathCos$2(startAngle) * rx + cx;
						y0 = mathSin$2(startAngle) * ry + cy;
					}
					fromArc(cx, cy, rx, ry, startAngle, endAngle, anticlockwise, min2, max2);
					xi = mathCos$2(endAngle) * rx + cx;
					yi = mathSin$2(endAngle) * ry + cy;
					break;
				case CMD$2.R:
					x0 = xi = data[i++];
					y0 = yi = data[i++];
					var width = data[i++];
					var height = data[i++];
					fromLine(x0, y0, x0 + width, y0 + height, min2, max2);
					break;
				case CMD$2.Z:
					xi = x0;
					yi = y0;
					break;
			}
			min$1(min, min, min2);
			max$1(max, max, max2);
		}
		if (i === 0) min[0] = min[1] = max[0] = max[1] = 0;
		return new BoundingRect_default(min[0], min[1], max[0] - min[0], max[1] - min[1]);
	};
	PathProxy$1.prototype._calculateLength = function() {
		var data = this.data;
		var len$1 = this._len;
		var ux = this._ux;
		var uy = this._uy;
		var xi = 0;
		var yi = 0;
		var x0 = 0;
		var y0 = 0;
		if (!this._pathSegLen) this._pathSegLen = [];
		var pathSegLen = this._pathSegLen;
		var pathTotalLen = 0;
		var segCount = 0;
		for (var i = 0; i < len$1;) {
			var cmd = data[i++];
			var isFirst = i === 1;
			if (isFirst) {
				xi = data[i];
				yi = data[i + 1];
				x0 = xi;
				y0 = yi;
			}
			var l = -1;
			switch (cmd) {
				case CMD$2.M:
					xi = x0 = data[i++];
					yi = y0 = data[i++];
					break;
				case CMD$2.L: {
					var x2 = data[i++];
					var y2 = data[i++];
					var dx = x2 - xi;
					var dy = y2 - yi;
					if (mathAbs$1(dx) > ux || mathAbs$1(dy) > uy || i === len$1 - 1) {
						l = Math.sqrt(dx * dx + dy * dy);
						xi = x2;
						yi = y2;
					}
					break;
				}
				case CMD$2.C: {
					var x1 = data[i++];
					var y1 = data[i++];
					var x2 = data[i++];
					var y2 = data[i++];
					var x3 = data[i++];
					var y3 = data[i++];
					l = cubicLength(xi, yi, x1, y1, x2, y2, x3, y3, 10);
					xi = x3;
					yi = y3;
					break;
				}
				case CMD$2.Q: {
					var x1 = data[i++];
					var y1 = data[i++];
					var x2 = data[i++];
					var y2 = data[i++];
					l = quadraticLength(xi, yi, x1, y1, x2, y2, 10);
					xi = x2;
					yi = y2;
					break;
				}
				case CMD$2.A:
					var cx = data[i++];
					var cy = data[i++];
					var rx = data[i++];
					var ry = data[i++];
					var startAngle = data[i++];
					var delta = data[i++];
					var endAngle = delta + startAngle;
					i += 1;
					if (isFirst) {
						x0 = mathCos$2(startAngle) * rx + cx;
						y0 = mathSin$2(startAngle) * ry + cy;
					}
					l = mathMax$3(rx, ry) * mathMin$3(PI2$4, Math.abs(delta));
					xi = mathCos$2(endAngle) * rx + cx;
					yi = mathSin$2(endAngle) * ry + cy;
					break;
				case CMD$2.R: {
					x0 = xi = data[i++];
					y0 = yi = data[i++];
					var width = data[i++];
					var height = data[i++];
					l = width * 2 + height * 2;
					break;
				}
				case CMD$2.Z: {
					var dx = x0 - xi;
					var dy = y0 - yi;
					l = Math.sqrt(dx * dx + dy * dy);
					xi = x0;
					yi = y0;
					break;
				}
			}
			if (l >= 0) {
				pathSegLen[segCount++] = l;
				pathTotalLen += l;
			}
		}
		this._pathLen = pathTotalLen;
		return pathTotalLen;
	};
	PathProxy$1.prototype.rebuildPath = function(ctx, percent) {
		var d = this.data;
		var ux = this._ux;
		var uy = this._uy;
		var len$1 = this._len;
		var x0;
		var y0;
		var xi;
		var yi;
		var x;
		var y;
		var drawPart = percent < 1;
		var pathSegLen;
		var pathTotalLen;
		var accumLength = 0;
		var segCount = 0;
		var displayedLength;
		var pendingPtDist = 0;
		var pendingPtX;
		var pendingPtY;
		if (drawPart) {
			if (!this._pathSegLen) this._calculateLength();
			pathSegLen = this._pathSegLen;
			pathTotalLen = this._pathLen;
			displayedLength = percent * pathTotalLen;
			if (!displayedLength) return;
		}
		lo: for (var i = 0; i < len$1;) {
			var cmd = d[i++];
			var isFirst = i === 1;
			if (isFirst) {
				xi = d[i];
				yi = d[i + 1];
				x0 = xi;
				y0 = yi;
			}
			if (cmd !== CMD$2.L && pendingPtDist > 0) {
				ctx.lineTo(pendingPtX, pendingPtY);
				pendingPtDist = 0;
			}
			switch (cmd) {
				case CMD$2.M:
					x0 = xi = d[i++];
					y0 = yi = d[i++];
					ctx.moveTo(xi, yi);
					break;
				case CMD$2.L: {
					x = d[i++];
					y = d[i++];
					var dx = mathAbs$1(x - xi);
					var dy = mathAbs$1(y - yi);
					if (dx > ux || dy > uy) {
						if (drawPart) {
							var l = pathSegLen[segCount++];
							if (accumLength + l > displayedLength) {
								var t = (displayedLength - accumLength) / l;
								ctx.lineTo(xi * (1 - t) + x * t, yi * (1 - t) + y * t);
								break lo;
							}
							accumLength += l;
						}
						ctx.lineTo(x, y);
						xi = x;
						yi = y;
						pendingPtDist = 0;
					} else {
						var d2 = dx * dx + dy * dy;
						if (d2 > pendingPtDist) {
							pendingPtX = x;
							pendingPtY = y;
							pendingPtDist = d2;
						}
					}
					break;
				}
				case CMD$2.C: {
					var x1 = d[i++];
					var y1 = d[i++];
					var x2 = d[i++];
					var y2 = d[i++];
					var x3 = d[i++];
					var y3 = d[i++];
					if (drawPart) {
						var l = pathSegLen[segCount++];
						if (accumLength + l > displayedLength) {
							var t = (displayedLength - accumLength) / l;
							cubicSubdivide(xi, x1, x2, x3, t, tmpOutX);
							cubicSubdivide(yi, y1, y2, y3, t, tmpOutY);
							ctx.bezierCurveTo(tmpOutX[1], tmpOutY[1], tmpOutX[2], tmpOutY[2], tmpOutX[3], tmpOutY[3]);
							break lo;
						}
						accumLength += l;
					}
					ctx.bezierCurveTo(x1, y1, x2, y2, x3, y3);
					xi = x3;
					yi = y3;
					break;
				}
				case CMD$2.Q: {
					var x1 = d[i++];
					var y1 = d[i++];
					var x2 = d[i++];
					var y2 = d[i++];
					if (drawPart) {
						var l = pathSegLen[segCount++];
						if (accumLength + l > displayedLength) {
							var t = (displayedLength - accumLength) / l;
							quadraticSubdivide(xi, x1, x2, t, tmpOutX);
							quadraticSubdivide(yi, y1, y2, t, tmpOutY);
							ctx.quadraticCurveTo(tmpOutX[1], tmpOutY[1], tmpOutX[2], tmpOutY[2]);
							break lo;
						}
						accumLength += l;
					}
					ctx.quadraticCurveTo(x1, y1, x2, y2);
					xi = x2;
					yi = y2;
					break;
				}
				case CMD$2.A:
					var cx = d[i++];
					var cy = d[i++];
					var rx = d[i++];
					var ry = d[i++];
					var startAngle = d[i++];
					var delta = d[i++];
					var psi = d[i++];
					var anticlockwise = !d[i++];
					var r = rx > ry ? rx : ry;
					var isEllipse = mathAbs$1(rx - ry) > .001;
					var endAngle = startAngle + delta;
					var breakBuild = false;
					if (drawPart) {
						var l = pathSegLen[segCount++];
						if (accumLength + l > displayedLength) {
							endAngle = startAngle + delta * (displayedLength - accumLength) / l;
							breakBuild = true;
						}
						accumLength += l;
					}
					if (isEllipse && ctx.ellipse) ctx.ellipse(cx, cy, rx, ry, psi, startAngle, endAngle, anticlockwise);
					else ctx.arc(cx, cy, r, startAngle, endAngle, anticlockwise);
					if (breakBuild) break lo;
					if (isFirst) {
						x0 = mathCos$2(startAngle) * rx + cx;
						y0 = mathSin$2(startAngle) * ry + cy;
					}
					xi = mathCos$2(endAngle) * rx + cx;
					yi = mathSin$2(endAngle) * ry + cy;
					break;
				case CMD$2.R:
					x0 = xi = d[i];
					y0 = yi = d[i + 1];
					x = d[i++];
					y = d[i++];
					var width = d[i++];
					var height = d[i++];
					if (drawPart) {
						var l = pathSegLen[segCount++];
						if (accumLength + l > displayedLength) {
							var d_1 = displayedLength - accumLength;
							ctx.moveTo(x, y);
							ctx.lineTo(x + mathMin$3(d_1, width), y);
							d_1 -= width;
							if (d_1 > 0) ctx.lineTo(x + width, y + mathMin$3(d_1, height));
							d_1 -= height;
							if (d_1 > 0) ctx.lineTo(x + mathMax$3(width - d_1, 0), y + height);
							d_1 -= width;
							if (d_1 > 0) ctx.lineTo(x, y + mathMax$3(height - d_1, 0));
							break lo;
						}
						accumLength += l;
					}
					ctx.rect(x, y, width, height);
					break;
				case CMD$2.Z:
					if (drawPart) {
						var l = pathSegLen[segCount++];
						if (accumLength + l > displayedLength) {
							var t = (displayedLength - accumLength) / l;
							ctx.lineTo(xi * (1 - t) + x0 * t, yi * (1 - t) + y0 * t);
							break lo;
						}
						accumLength += l;
					}
					ctx.closePath();
					xi = x0;
					yi = y0;
			}
		}
	};
	PathProxy$1.prototype.clone = function() {
		var newProxy = new PathProxy$1();
		var data = this.data;
		newProxy.data = data.slice ? data.slice() : Array.prototype.slice.call(data);
		newProxy._len = this._len;
		return newProxy;
	};
	PathProxy$1.CMD = CMD$2;
	PathProxy$1.initDefaultProps = function() {
		var proto$1 = PathProxy$1.prototype;
		proto$1._saveData = true;
		proto$1._ux = 0;
		proto$1._uy = 0;
		proto$1._pendingPtDist = 0;
		proto$1._version = 0;
	}();
	return PathProxy$1;
}();
var PathProxy_default = PathProxy;
function containStroke$4(x0, y0, x1, y1, lineWidth, x, y) {
	if (lineWidth === 0) return false;
	var _l = lineWidth;
	var _a$1 = 0;
	var _b$1 = x0;
	if (y > y0 + _l && y > y1 + _l || y < y0 - _l && y < y1 - _l || x > x0 + _l && x > x1 + _l || x < x0 - _l && x < x1 - _l) return false;
	if (x0 !== x1) {
		_a$1 = (y0 - y1) / (x0 - x1);
		_b$1 = (x0 * y1 - x1 * y0) / (x0 - x1);
	} else return Math.abs(x - x0) <= _l / 2;
	var tmp = _a$1 * x - y + _b$1;
	var _s = tmp * tmp / (_a$1 * _a$1 + 1);
	return _s <= _l / 2 * _l / 2;
}
function containStroke$3(x0, y0, x1, y1, x2, y2, x3, y3, lineWidth, x, y) {
	if (lineWidth === 0) return false;
	var _l = lineWidth;
	if (y > y0 + _l && y > y1 + _l && y > y2 + _l && y > y3 + _l || y < y0 - _l && y < y1 - _l && y < y2 - _l && y < y3 - _l || x > x0 + _l && x > x1 + _l && x > x2 + _l && x > x3 + _l || x < x0 - _l && x < x1 - _l && x < x2 - _l && x < x3 - _l) return false;
	var d = cubicProjectPoint(x0, y0, x1, y1, x2, y2, x3, y3, x, y, null);
	return d <= _l / 2;
}
function containStroke$2(x0, y0, x1, y1, x2, y2, lineWidth, x, y) {
	if (lineWidth === 0) return false;
	var _l = lineWidth;
	if (y > y0 + _l && y > y1 + _l && y > y2 + _l || y < y0 - _l && y < y1 - _l && y < y2 - _l || x > x0 + _l && x > x1 + _l && x > x2 + _l || x < x0 - _l && x < x1 - _l && x < x2 - _l) return false;
	var d = quadraticProjectPoint(x0, y0, x1, y1, x2, y2, x, y, null);
	return d <= _l / 2;
}
var PI2$3 = Math.PI * 2;
function normalizeRadian(angle) {
	angle %= PI2$3;
	if (angle < 0) angle += PI2$3;
	return angle;
}
var PI2$2 = Math.PI * 2;
function containStroke$1(cx, cy, r, startAngle, endAngle, anticlockwise, lineWidth, x, y) {
	if (lineWidth === 0) return false;
	var _l = lineWidth;
	x -= cx;
	y -= cy;
	var d = Math.sqrt(x * x + y * y);
	if (d - _l > r || d + _l < r) return false;
	if (Math.abs(startAngle - endAngle) % PI2$2 < 1e-4) return true;
	if (anticlockwise) {
		var tmp = startAngle;
		startAngle = normalizeRadian(endAngle);
		endAngle = normalizeRadian(tmp);
	} else {
		startAngle = normalizeRadian(startAngle);
		endAngle = normalizeRadian(endAngle);
	}
	if (startAngle > endAngle) endAngle += PI2$2;
	var angle = Math.atan2(y, x);
	if (angle < 0) angle += PI2$2;
	return angle >= startAngle && angle <= endAngle || angle + PI2$2 >= startAngle && angle + PI2$2 <= endAngle;
}
function windingLine(x0, y0, x1, y1, x, y) {
	if (y > y0 && y > y1 || y < y0 && y < y1) return 0;
	if (y1 === y0) return 0;
	var t = (y - y0) / (y1 - y0);
	var dir = y1 < y0 ? 1 : -1;
	if (t === 1 || t === 0) dir = y1 < y0 ? .5 : -.5;
	var x_ = t * (x1 - x0) + x0;
	return x_ === x ? Infinity : x_ > x ? dir : 0;
}
var CMD$1 = PathProxy_default.CMD;
var PI2$1 = Math.PI * 2;
var EPSILON = 1e-4;
function isAroundEqual(a, b) {
	return Math.abs(a - b) < EPSILON;
}
var roots = [
	-1,
	-1,
	-1
];
var extrema = [-1, -1];
function swapExtrema() {
	var tmp = extrema[0];
	extrema[0] = extrema[1];
	extrema[1] = tmp;
}
function windingCubic(x0, y0, x1, y1, x2, y2, x3, y3, x, y) {
	if (y > y0 && y > y1 && y > y2 && y > y3 || y < y0 && y < y1 && y < y2 && y < y3) return 0;
	var nRoots = cubicRootAt(y0, y1, y2, y3, y, roots);
	if (nRoots === 0) return 0;
	else {
		var w = 0;
		var nExtrema = -1;
		var y0_ = void 0;
		var y1_ = void 0;
		for (var i = 0; i < nRoots; i++) {
			var t = roots[i];
			var unit = t === 0 || t === 1 ? .5 : 1;
			var x_ = cubicAt(x0, x1, x2, x3, t);
			if (x_ < x) continue;
			if (nExtrema < 0) {
				nExtrema = cubicExtrema(y0, y1, y2, y3, extrema);
				if (extrema[1] < extrema[0] && nExtrema > 1) swapExtrema();
				y0_ = cubicAt(y0, y1, y2, y3, extrema[0]);
				if (nExtrema > 1) y1_ = cubicAt(y0, y1, y2, y3, extrema[1]);
			}
			if (nExtrema === 2) if (t < extrema[0]) w += y0_ < y0 ? unit : -unit;
			else if (t < extrema[1]) w += y1_ < y0_ ? unit : -unit;
			else w += y3 < y1_ ? unit : -unit;
			else if (t < extrema[0]) w += y0_ < y0 ? unit : -unit;
			else w += y3 < y0_ ? unit : -unit;
		}
		return w;
	}
}
function windingQuadratic(x0, y0, x1, y1, x2, y2, x, y) {
	if (y > y0 && y > y1 && y > y2 || y < y0 && y < y1 && y < y2) return 0;
	var nRoots = quadraticRootAt(y0, y1, y2, y, roots);
	if (nRoots === 0) return 0;
	else {
		var t = quadraticExtremum(y0, y1, y2);
		if (t >= 0 && t <= 1) {
			var w = 0;
			var y_ = quadraticAt(y0, y1, y2, t);
			for (var i = 0; i < nRoots; i++) {
				var unit = roots[i] === 0 || roots[i] === 1 ? .5 : 1;
				var x_ = quadraticAt(x0, x1, x2, roots[i]);
				if (x_ < x) continue;
				if (roots[i] < t) w += y_ < y0 ? unit : -unit;
				else w += y2 < y_ ? unit : -unit;
			}
			return w;
		} else {
			var unit = roots[0] === 0 || roots[0] === 1 ? .5 : 1;
			var x_ = quadraticAt(x0, x1, x2, roots[0]);
			if (x_ < x) return 0;
			return y2 < y0 ? unit : -unit;
		}
	}
}
function windingArc(cx, cy, r, startAngle, endAngle, anticlockwise, x, y) {
	y -= cy;
	if (y > r || y < -r) return 0;
	var tmp = Math.sqrt(r * r - y * y);
	roots[0] = -tmp;
	roots[1] = tmp;
	var dTheta = Math.abs(startAngle - endAngle);
	if (dTheta < 1e-4) return 0;
	if (dTheta >= PI2$1 - 1e-4) {
		startAngle = 0;
		endAngle = PI2$1;
		var dir = anticlockwise ? 1 : -1;
		if (x >= roots[0] + cx && x <= roots[1] + cx) return dir;
		else return 0;
	}
	if (startAngle > endAngle) {
		var tmp_1 = startAngle;
		startAngle = endAngle;
		endAngle = tmp_1;
	}
	if (startAngle < 0) {
		startAngle += PI2$1;
		endAngle += PI2$1;
	}
	var w = 0;
	for (var i = 0; i < 2; i++) {
		var x_ = roots[i];
		if (x_ + cx > x) {
			var angle = Math.atan2(y, x_);
			var dir = anticlockwise ? 1 : -1;
			if (angle < 0) angle = PI2$1 + angle;
			if (angle >= startAngle && angle <= endAngle || angle + PI2$1 >= startAngle && angle + PI2$1 <= endAngle) {
				if (angle > Math.PI / 2 && angle < Math.PI * 1.5) dir = -dir;
				w += dir;
			}
		}
	}
	return w;
}
function containPath(path, lineWidth, isStroke, x, y) {
	var data = path.data;
	var len$1 = path.len();
	var w = 0;
	var xi = 0;
	var yi = 0;
	var x0 = 0;
	var y0 = 0;
	var x1;
	var y1;
	for (var i = 0; i < len$1;) {
		var cmd = data[i++];
		var isFirst = i === 1;
		if (cmd === CMD$1.M && i > 1) {
			if (!isStroke) w += windingLine(xi, yi, x0, y0, x, y);
		}
		if (isFirst) {
			xi = data[i];
			yi = data[i + 1];
			x0 = xi;
			y0 = yi;
		}
		switch (cmd) {
			case CMD$1.M:
				x0 = data[i++];
				y0 = data[i++];
				xi = x0;
				yi = y0;
				break;
			case CMD$1.L:
				if (isStroke) {
					if (containStroke$4(xi, yi, data[i], data[i + 1], lineWidth, x, y)) return true;
				} else w += windingLine(xi, yi, data[i], data[i + 1], x, y) || 0;
				xi = data[i++];
				yi = data[i++];
				break;
			case CMD$1.C:
				if (isStroke) {
					if (containStroke$3(xi, yi, data[i++], data[i++], data[i++], data[i++], data[i], data[i + 1], lineWidth, x, y)) return true;
				} else w += windingCubic(xi, yi, data[i++], data[i++], data[i++], data[i++], data[i], data[i + 1], x, y) || 0;
				xi = data[i++];
				yi = data[i++];
				break;
			case CMD$1.Q:
				if (isStroke) {
					if (containStroke$2(xi, yi, data[i++], data[i++], data[i], data[i + 1], lineWidth, x, y)) return true;
				} else w += windingQuadratic(xi, yi, data[i++], data[i++], data[i], data[i + 1], x, y) || 0;
				xi = data[i++];
				yi = data[i++];
				break;
			case CMD$1.A:
				var cx = data[i++];
				var cy = data[i++];
				var rx = data[i++];
				var ry = data[i++];
				var theta = data[i++];
				var dTheta = data[i++];
				i += 1;
				var anticlockwise = !!(1 - data[i++]);
				x1 = Math.cos(theta) * rx + cx;
				y1 = Math.sin(theta) * ry + cy;
				if (!isFirst) w += windingLine(xi, yi, x1, y1, x, y);
				else {
					x0 = x1;
					y0 = y1;
				}
				var _x = (x - cx) * ry / rx + cx;
				if (isStroke) {
					if (containStroke$1(cx, cy, ry, theta, theta + dTheta, anticlockwise, lineWidth, _x, y)) return true;
				} else w += windingArc(cx, cy, ry, theta, theta + dTheta, anticlockwise, _x, y);
				xi = Math.cos(theta + dTheta) * rx + cx;
				yi = Math.sin(theta + dTheta) * ry + cy;
				break;
			case CMD$1.R:
				x0 = xi = data[i++];
				y0 = yi = data[i++];
				var width = data[i++];
				var height = data[i++];
				x1 = x0 + width;
				y1 = y0 + height;
				if (isStroke) {
					if (containStroke$4(x0, y0, x1, y0, lineWidth, x, y) || containStroke$4(x1, y0, x1, y1, lineWidth, x, y) || containStroke$4(x1, y1, x0, y1, lineWidth, x, y) || containStroke$4(x0, y1, x0, y0, lineWidth, x, y)) return true;
				} else {
					w += windingLine(x1, y0, x1, y1, x, y);
					w += windingLine(x0, y1, x0, y0, x, y);
				}
				break;
			case CMD$1.Z:
				if (isStroke) {
					if (containStroke$4(xi, yi, x0, y0, lineWidth, x, y)) return true;
				} else w += windingLine(xi, yi, x0, y0, x, y);
				xi = x0;
				yi = y0;
				break;
		}
	}
	if (!isStroke && !isAroundEqual(yi, y0)) w += windingLine(xi, yi, x0, y0, x, y) || 0;
	return w !== 0;
}
function contain$1(pathProxy, x, y) {
	return containPath(pathProxy, 0, false, x, y);
}
function containStroke(pathProxy, lineWidth, x, y) {
	return containPath(pathProxy, lineWidth, true, x, y);
}
var DEFAULT_PATH_STYLE = defaults({
	fill: "#000",
	stroke: null,
	strokePercent: 1,
	fillOpacity: 1,
	strokeOpacity: 1,
	lineDashOffset: 0,
	lineWidth: 1,
	lineCap: "butt",
	miterLimit: 10,
	strokeNoScale: false,
	strokeFirst: false
}, DEFAULT_COMMON_STYLE);
var DEFAULT_PATH_ANIMATION_PROPS = { style: defaults({
	fill: true,
	stroke: true,
	strokePercent: true,
	fillOpacity: true,
	strokeOpacity: true,
	lineDashOffset: true,
	lineWidth: true,
	miterLimit: true
}, DEFAULT_COMMON_ANIMATION_PROPS.style) };
var pathCopyParams = TRANSFORMABLE_PROPS.concat([
	"invisible",
	"culling",
	"z",
	"z2",
	"zlevel",
	"parent"
]);
var Path = function(_super) {
	__extends(Path$1, _super);
	function Path$1(opts) {
		return _super.call(this, opts) || this;
	}
	Path$1.prototype.update = function() {
		var _this = this;
		_super.prototype.update.call(this);
		var style = this.style;
		if (style.decal) {
			var decalEl = this._decalEl = this._decalEl || new Path$1();
			if (decalEl.buildPath === Path$1.prototype.buildPath) decalEl.buildPath = function(ctx) {
				_this.buildPath(ctx, _this.shape);
			};
			decalEl.silent = true;
			var decalElStyle = decalEl.style;
			for (var key in style) if (decalElStyle[key] !== style[key]) decalElStyle[key] = style[key];
			decalElStyle.fill = style.fill ? style.decal : null;
			decalElStyle.decal = null;
			decalElStyle.shadowColor = null;
			style.strokeFirst && (decalElStyle.stroke = null);
			for (var i = 0; i < pathCopyParams.length; ++i) decalEl[pathCopyParams[i]] = this[pathCopyParams[i]];
			decalEl.__dirty |= REDRAW_BIT;
		} else if (this._decalEl) this._decalEl = null;
	};
	Path$1.prototype.getDecalElement = function() {
		return this._decalEl;
	};
	Path$1.prototype._init = function(props) {
		var keysArr = keys(props);
		this.shape = this.getDefaultShape();
		var defaultStyle = this.getDefaultStyle();
		if (defaultStyle) this.useStyle(defaultStyle);
		for (var i = 0; i < keysArr.length; i++) {
			var key = keysArr[i];
			var value = props[key];
			if (key === "style") if (!this.style) this.useStyle(value);
			else extend(this.style, value);
			else if (key === "shape") extend(this.shape, value);
			else _super.prototype.attrKV.call(this, key, value);
		}
		if (!this.style) this.useStyle({});
	};
	Path$1.prototype.getDefaultStyle = function() {
		return null;
	};
	Path$1.prototype.getDefaultShape = function() {
		return {};
	};
	Path$1.prototype.canBeInsideText = function() {
		return this.hasFill();
	};
	Path$1.prototype.getInsideTextFill = function() {
		var pathFill = this.style.fill;
		if (pathFill !== "none") {
			if (isString(pathFill)) {
				var fillLum = lum(pathFill, 0);
				if (fillLum > .5) return DARK_LABEL_COLOR;
				else if (fillLum > .2) return LIGHTER_LABEL_COLOR;
				return LIGHT_LABEL_COLOR;
			} else if (pathFill) return LIGHT_LABEL_COLOR;
		}
		return DARK_LABEL_COLOR;
	};
	Path$1.prototype.getInsideTextStroke = function(textFill) {
		var pathFill = this.style.fill;
		if (isString(pathFill)) {
			var zr = this.__zr;
			var isDarkMode$1 = !!(zr && zr.isDarkMode());
			var isDarkLabel = lum(textFill, 0) < DARK_MODE_THRESHOLD;
			if (isDarkMode$1 === isDarkLabel) return pathFill;
		}
	};
	Path$1.prototype.buildPath = function(ctx, shapeCfg, inBatch) {};
	Path$1.prototype.pathUpdated = function() {
		this.__dirty &= ~SHAPE_CHANGED_BIT;
	};
	Path$1.prototype.getUpdatedPathProxy = function(inBatch) {
		!this.path && this.createPathProxy();
		this.path.beginPath();
		this.buildPath(this.path, this.shape, inBatch);
		return this.path;
	};
	Path$1.prototype.createPathProxy = function() {
		this.path = new PathProxy_default(false);
	};
	Path$1.prototype.hasStroke = function() {
		var style = this.style;
		var stroke = style.stroke;
		return !(stroke == null || stroke === "none" || !(style.lineWidth > 0));
	};
	Path$1.prototype.hasFill = function() {
		var style = this.style;
		var fill = style.fill;
		return fill != null && fill !== "none";
	};
	Path$1.prototype.getBoundingRect = function() {
		var rect = this._rect;
		var style = this.style;
		var needsUpdateRect = !rect;
		if (needsUpdateRect) {
			var firstInvoke = false;
			if (!this.path) {
				firstInvoke = true;
				this.createPathProxy();
			}
			var path = this.path;
			if (firstInvoke || this.__dirty & SHAPE_CHANGED_BIT) {
				path.beginPath();
				this.buildPath(path, this.shape, false);
				this.pathUpdated();
			}
			rect = path.getBoundingRect();
		}
		this._rect = rect;
		if (this.hasStroke() && this.path && this.path.len() > 0) {
			var rectStroke = this._rectStroke || (this._rectStroke = rect.clone());
			if (this.__dirty || needsUpdateRect) {
				rectStroke.copy(rect);
				var lineScale = style.strokeNoScale ? this.getLineScale() : 1;
				var w = style.lineWidth;
				if (!this.hasFill()) {
					var strokeContainThreshold = this.strokeContainThreshold;
					w = Math.max(w, strokeContainThreshold == null ? 4 : strokeContainThreshold);
				}
				if (lineScale > 1e-10) {
					rectStroke.width += w / lineScale;
					rectStroke.height += w / lineScale;
					rectStroke.x -= w / lineScale / 2;
					rectStroke.y -= w / lineScale / 2;
				}
			}
			return rectStroke;
		}
		return rect;
	};
	Path$1.prototype.contain = function(x, y) {
		var localPos = this.transformCoordToLocal(x, y);
		var rect = this.getBoundingRect();
		var style = this.style;
		x = localPos[0];
		y = localPos[1];
		if (rect.contain(x, y)) {
			var pathProxy = this.path;
			if (this.hasStroke()) {
				var lineWidth = style.lineWidth;
				var lineScale = style.strokeNoScale ? this.getLineScale() : 1;
				if (lineScale > 1e-10) {
					if (!this.hasFill()) lineWidth = Math.max(lineWidth, this.strokeContainThreshold);
					if (containStroke(pathProxy, lineWidth / lineScale, x, y)) return true;
				}
			}
			if (this.hasFill()) return contain$1(pathProxy, x, y);
		}
		return false;
	};
	Path$1.prototype.dirtyShape = function() {
		this.__dirty |= SHAPE_CHANGED_BIT;
		if (this._rect) this._rect = null;
		if (this._decalEl) this._decalEl.dirtyShape();
		this.markRedraw();
	};
	Path$1.prototype.dirty = function() {
		this.dirtyStyle();
		this.dirtyShape();
	};
	Path$1.prototype.animateShape = function(loop) {
		return this.animate("shape", loop);
	};
	Path$1.prototype.updateDuringAnimation = function(targetKey) {
		if (targetKey === "style") this.dirtyStyle();
		else if (targetKey === "shape") this.dirtyShape();
		else this.markRedraw();
	};
	Path$1.prototype.attrKV = function(key, value) {
		if (key === "shape") this.setShape(value);
		else _super.prototype.attrKV.call(this, key, value);
	};
	Path$1.prototype.setShape = function(keyOrObj, value) {
		var shape = this.shape;
		if (!shape) shape = this.shape = {};
		if (typeof keyOrObj === "string") shape[keyOrObj] = value;
		else extend(shape, keyOrObj);
		this.dirtyShape();
		return this;
	};
	Path$1.prototype.shapeChanged = function() {
		return !!(this.__dirty & SHAPE_CHANGED_BIT);
	};
	Path$1.prototype.createStyle = function(obj) {
		return createObject(DEFAULT_PATH_STYLE, obj);
	};
	Path$1.prototype._innerSaveToNormal = function(toState) {
		_super.prototype._innerSaveToNormal.call(this, toState);
		var normalState = this._normalState;
		if (toState.shape && !normalState.shape) normalState.shape = extend({}, this.shape);
	};
	Path$1.prototype._applyStateObj = function(stateName, state, normalState, keepCurrentStates, transition, animationCfg) {
		_super.prototype._applyStateObj.call(this, stateName, state, normalState, keepCurrentStates, transition, animationCfg);
		var needsRestoreToNormal = !(state && keepCurrentStates);
		var targetShape;
		if (state && state.shape) if (transition) if (keepCurrentStates) targetShape = state.shape;
		else {
			targetShape = extend({}, normalState.shape);
			extend(targetShape, state.shape);
		}
		else {
			targetShape = extend({}, keepCurrentStates ? this.shape : normalState.shape);
			extend(targetShape, state.shape);
		}
		else if (needsRestoreToNormal) targetShape = normalState.shape;
		if (targetShape) if (transition) {
			this.shape = extend({}, this.shape);
			var targetShapePrimaryProps = {};
			var shapeKeys = keys(targetShape);
			for (var i = 0; i < shapeKeys.length; i++) {
				var key = shapeKeys[i];
				if (typeof targetShape[key] === "object") this.shape[key] = targetShape[key];
				else targetShapePrimaryProps[key] = targetShape[key];
			}
			this._transitionState(stateName, { shape: targetShapePrimaryProps }, animationCfg);
		} else {
			this.shape = targetShape;
			this.dirtyShape();
		}
	};
	Path$1.prototype._mergeStates = function(states) {
		var mergedState = _super.prototype._mergeStates.call(this, states);
		var mergedShape;
		for (var i = 0; i < states.length; i++) {
			var state = states[i];
			if (state.shape) {
				mergedShape = mergedShape || {};
				this._mergeStyle(mergedShape, state.shape);
			}
		}
		if (mergedShape) mergedState.shape = mergedShape;
		return mergedState;
	};
	Path$1.prototype.getAnimationStyleProps = function() {
		return DEFAULT_PATH_ANIMATION_PROPS;
	};
	Path$1.prototype.isZeroArea = function() {
		return false;
	};
	Path$1.extend = function(defaultProps) {
		var Sub = function(_super$1) {
			__extends(Sub$1, _super$1);
			function Sub$1(opts) {
				var _this = _super$1.call(this, opts) || this;
				defaultProps.init && defaultProps.init.call(_this, opts);
				return _this;
			}
			Sub$1.prototype.getDefaultStyle = function() {
				return clone$2(defaultProps.style);
			};
			Sub$1.prototype.getDefaultShape = function() {
				return clone$2(defaultProps.shape);
			};
			return Sub$1;
		}(Path$1);
		for (var key in defaultProps) if (typeof defaultProps[key] === "function") Sub.prototype[key] = defaultProps[key];
		return Sub;
	};
	Path$1.initDefaultProps = function() {
		var pathProto = Path$1.prototype;
		pathProto.type = "path";
		pathProto.strokeContainThreshold = 5;
		pathProto.segmentIgnoreThreshold = 0;
		pathProto.subPixelOptimize = false;
		pathProto.autoBatch = false;
		pathProto.__dirty = REDRAW_BIT | STYLE_CHANGED_BIT | SHAPE_CHANGED_BIT;
	}();
	return Path$1;
}(Displayable_default);
var Path_default = Path;
var DEFAULT_TSPAN_STYLE = defaults({
	strokeFirst: true,
	font: DEFAULT_FONT,
	x: 0,
	y: 0,
	textAlign: "left",
	textBaseline: "top",
	miterLimit: 2
}, DEFAULT_PATH_STYLE);
var TSpan = function(_super) {
	__extends(TSpan$1, _super);
	function TSpan$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	TSpan$1.prototype.hasStroke = function() {
		var style = this.style;
		var stroke = style.stroke;
		return stroke != null && stroke !== "none" && style.lineWidth > 0;
	};
	TSpan$1.prototype.hasFill = function() {
		var style = this.style;
		var fill = style.fill;
		return fill != null && fill !== "none";
	};
	TSpan$1.prototype.createStyle = function(obj) {
		return createObject(DEFAULT_TSPAN_STYLE, obj);
	};
	TSpan$1.prototype.setBoundingRect = function(rect) {
		this._rect = rect;
	};
	TSpan$1.prototype.getBoundingRect = function() {
		var style = this.style;
		if (!this._rect) {
			var text = style.text;
			text != null ? text += "" : text = "";
			var rect = getBoundingRect(text, style.font, style.textAlign, style.textBaseline);
			rect.x += style.x || 0;
			rect.y += style.y || 0;
			if (this.hasStroke()) {
				var w = style.lineWidth;
				rect.x -= w / 2;
				rect.y -= w / 2;
				rect.width += w;
				rect.height += w;
			}
			this._rect = rect;
		}
		return this._rect;
	};
	TSpan$1.initDefaultProps = function() {
		var tspanProto = TSpan$1.prototype;
		tspanProto.dirtyRectTolerance = 10;
	}();
	return TSpan$1;
}(Displayable_default);
TSpan.prototype.type = "tspan";
var TSpan_default = TSpan;
var DEFAULT_IMAGE_STYLE = defaults({
	x: 0,
	y: 0
}, DEFAULT_COMMON_STYLE);
var DEFAULT_IMAGE_ANIMATION_PROPS = { style: defaults({
	x: true,
	y: true,
	width: true,
	height: true,
	sx: true,
	sy: true,
	sWidth: true,
	sHeight: true
}, DEFAULT_COMMON_ANIMATION_PROPS.style) };
function isImageLike(source) {
	return !!(source && typeof source !== "string" && source.width && source.height);
}
var ZRImage = function(_super) {
	__extends(ZRImage$1, _super);
	function ZRImage$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	ZRImage$1.prototype.createStyle = function(obj) {
		return createObject(DEFAULT_IMAGE_STYLE, obj);
	};
	ZRImage$1.prototype._getSize = function(dim) {
		var style = this.style;
		var size = style[dim];
		if (size != null) return size;
		var imageSource = isImageLike(style.image) ? style.image : this.__image;
		if (!imageSource) return 0;
		var otherDim = dim === "width" ? "height" : "width";
		var otherDimSize = style[otherDim];
		if (otherDimSize == null) return imageSource[dim];
		else return imageSource[dim] / imageSource[otherDim] * otherDimSize;
	};
	ZRImage$1.prototype.getWidth = function() {
		return this._getSize("width");
	};
	ZRImage$1.prototype.getHeight = function() {
		return this._getSize("height");
	};
	ZRImage$1.prototype.getAnimationStyleProps = function() {
		return DEFAULT_IMAGE_ANIMATION_PROPS;
	};
	ZRImage$1.prototype.getBoundingRect = function() {
		var style = this.style;
		if (!this._rect) this._rect = new BoundingRect_default(style.x || 0, style.y || 0, this.getWidth(), this.getHeight());
		return this._rect;
	};
	return ZRImage$1;
}(Displayable_default);
ZRImage.prototype.type = "image";
var Image_default = ZRImage;
function buildPath$2(ctx, shape) {
	var x = shape.x;
	var y = shape.y;
	var width = shape.width;
	var height = shape.height;
	var r = shape.r;
	var r1;
	var r2;
	var r3;
	var r4;
	if (width < 0) {
		x = x + width;
		width = -width;
	}
	if (height < 0) {
		y = y + height;
		height = -height;
	}
	if (typeof r === "number") r1 = r2 = r3 = r4 = r;
	else if (r instanceof Array) if (r.length === 1) r1 = r2 = r3 = r4 = r[0];
	else if (r.length === 2) {
		r1 = r3 = r[0];
		r2 = r4 = r[1];
	} else if (r.length === 3) {
		r1 = r[0];
		r2 = r4 = r[1];
		r3 = r[2];
	} else {
		r1 = r[0];
		r2 = r[1];
		r3 = r[2];
		r4 = r[3];
	}
	else r1 = r2 = r3 = r4 = 0;
	var total;
	if (r1 + r2 > width) {
		total = r1 + r2;
		r1 *= width / total;
		r2 *= width / total;
	}
	if (r3 + r4 > width) {
		total = r3 + r4;
		r3 *= width / total;
		r4 *= width / total;
	}
	if (r2 + r3 > height) {
		total = r2 + r3;
		r2 *= height / total;
		r3 *= height / total;
	}
	if (r1 + r4 > height) {
		total = r1 + r4;
		r1 *= height / total;
		r4 *= height / total;
	}
	ctx.moveTo(x + r1, y);
	ctx.lineTo(x + width - r2, y);
	r2 !== 0 && ctx.arc(x + width - r2, y + r2, r2, -Math.PI / 2, 0);
	ctx.lineTo(x + width, y + height - r3);
	r3 !== 0 && ctx.arc(x + width - r3, y + height - r3, r3, 0, Math.PI / 2);
	ctx.lineTo(x + r4, y + height);
	r4 !== 0 && ctx.arc(x + r4, y + height - r4, r4, Math.PI / 2, Math.PI);
	ctx.lineTo(x, y + r1);
	r1 !== 0 && ctx.arc(x + r1, y + r1, r1, Math.PI, Math.PI * 1.5);
}
var round$1 = Math.round;
function subPixelOptimizeLine$1(outputShape, inputShape, style) {
	if (!inputShape) return;
	var x1 = inputShape.x1;
	var x2 = inputShape.x2;
	var y1 = inputShape.y1;
	var y2 = inputShape.y2;
	outputShape.x1 = x1;
	outputShape.x2 = x2;
	outputShape.y1 = y1;
	outputShape.y2 = y2;
	var lineWidth = style && style.lineWidth;
	if (!lineWidth) return outputShape;
	if (round$1(x1 * 2) === round$1(x2 * 2)) outputShape.x1 = outputShape.x2 = subPixelOptimize$1(x1, lineWidth, true);
	if (round$1(y1 * 2) === round$1(y2 * 2)) outputShape.y1 = outputShape.y2 = subPixelOptimize$1(y1, lineWidth, true);
	return outputShape;
}
function subPixelOptimizeRect$1(outputShape, inputShape, style) {
	if (!inputShape) return;
	var originX = inputShape.x;
	var originY = inputShape.y;
	var originWidth = inputShape.width;
	var originHeight = inputShape.height;
	outputShape.x = originX;
	outputShape.y = originY;
	outputShape.width = originWidth;
	outputShape.height = originHeight;
	var lineWidth = style && style.lineWidth;
	if (!lineWidth) return outputShape;
	outputShape.x = subPixelOptimize$1(originX, lineWidth, true);
	outputShape.y = subPixelOptimize$1(originY, lineWidth, true);
	outputShape.width = Math.max(subPixelOptimize$1(originX + originWidth, lineWidth, false) - outputShape.x, originWidth === 0 ? 0 : 1);
	outputShape.height = Math.max(subPixelOptimize$1(originY + originHeight, lineWidth, false) - outputShape.y, originHeight === 0 ? 0 : 1);
	return outputShape;
}
function subPixelOptimize$1(position, lineWidth, positiveOrNegative) {
	if (!lineWidth) return position;
	var doubledPosition = round$1(position * 2);
	return (doubledPosition + round$1(lineWidth)) % 2 === 0 ? doubledPosition / 2 : (doubledPosition + (positiveOrNegative ? 1 : -1)) / 2;
}
var RectShape = function() {
	function RectShape$1() {
		this.x = 0;
		this.y = 0;
		this.width = 0;
		this.height = 0;
	}
	return RectShape$1;
}();
var subPixelOptimizeOutputShape$1 = {};
var Rect = function(_super) {
	__extends(Rect$1, _super);
	function Rect$1(opts) {
		return _super.call(this, opts) || this;
	}
	Rect$1.prototype.getDefaultShape = function() {
		return new RectShape();
	};
	Rect$1.prototype.buildPath = function(ctx, shape) {
		var x;
		var y;
		var width;
		var height;
		if (this.subPixelOptimize) {
			var optimizedShape = subPixelOptimizeRect$1(subPixelOptimizeOutputShape$1, shape, this.style);
			x = optimizedShape.x;
			y = optimizedShape.y;
			width = optimizedShape.width;
			height = optimizedShape.height;
			optimizedShape.r = shape.r;
			shape = optimizedShape;
		} else {
			x = shape.x;
			y = shape.y;
			width = shape.width;
			height = shape.height;
		}
		if (!shape.r) ctx.rect(x, y, width, height);
		else buildPath$2(ctx, shape);
	};
	Rect$1.prototype.isZeroArea = function() {
		return !this.shape.width || !this.shape.height;
	};
	return Rect$1;
}(Path_default);
Rect.prototype.type = "rect";
var Rect_default = Rect;
var DEFAULT_RICH_TEXT_COLOR = { fill: "#000" };
var DEFAULT_STROKE_LINE_WIDTH = 2;
var DEFAULT_TEXT_ANIMATION_PROPS = { style: defaults({
	fill: true,
	stroke: true,
	fillOpacity: true,
	strokeOpacity: true,
	lineWidth: true,
	fontSize: true,
	lineHeight: true,
	width: true,
	height: true,
	textShadowColor: true,
	textShadowBlur: true,
	textShadowOffsetX: true,
	textShadowOffsetY: true,
	backgroundColor: true,
	padding: true,
	borderColor: true,
	borderWidth: true,
	borderRadius: true
}, DEFAULT_COMMON_ANIMATION_PROPS.style) };
var ZRText = function(_super) {
	__extends(ZRText$1, _super);
	function ZRText$1(opts) {
		var _this = _super.call(this) || this;
		_this.type = "text";
		_this._children = [];
		_this._defaultStyle = DEFAULT_RICH_TEXT_COLOR;
		_this.attr(opts);
		return _this;
	}
	ZRText$1.prototype.childrenRef = function() {
		return this._children;
	};
	ZRText$1.prototype.update = function() {
		_super.prototype.update.call(this);
		if (this.styleChanged()) this._updateSubTexts();
		for (var i = 0; i < this._children.length; i++) {
			var child = this._children[i];
			child.zlevel = this.zlevel;
			child.z = this.z;
			child.z2 = this.z2;
			child.culling = this.culling;
			child.cursor = this.cursor;
			child.invisible = this.invisible;
		}
	};
	ZRText$1.prototype.updateTransform = function() {
		var innerTransformable = this.innerTransformable;
		if (innerTransformable) {
			innerTransformable.updateTransform();
			if (innerTransformable.transform) this.transform = innerTransformable.transform;
		} else _super.prototype.updateTransform.call(this);
	};
	ZRText$1.prototype.getLocalTransform = function(m$1) {
		var innerTransformable = this.innerTransformable;
		return innerTransformable ? innerTransformable.getLocalTransform(m$1) : _super.prototype.getLocalTransform.call(this, m$1);
	};
	ZRText$1.prototype.getComputedTransform = function() {
		if (this.__hostTarget) {
			this.__hostTarget.getComputedTransform();
			this.__hostTarget.updateInnerText(true);
		}
		return _super.prototype.getComputedTransform.call(this);
	};
	ZRText$1.prototype._updateSubTexts = function() {
		this._childCursor = 0;
		normalizeTextStyle(this.style);
		this.style.rich ? this._updateRichTexts() : this._updatePlainTexts();
		this._children.length = this._childCursor;
		this.styleUpdated();
	};
	ZRText$1.prototype.addSelfToZr = function(zr) {
		_super.prototype.addSelfToZr.call(this, zr);
		for (var i = 0; i < this._children.length; i++) this._children[i].__zr = zr;
	};
	ZRText$1.prototype.removeSelfFromZr = function(zr) {
		_super.prototype.removeSelfFromZr.call(this, zr);
		for (var i = 0; i < this._children.length; i++) this._children[i].__zr = null;
	};
	ZRText$1.prototype.getBoundingRect = function() {
		if (this.styleChanged()) this._updateSubTexts();
		if (!this._rect) {
			var tmpRect$2 = new BoundingRect_default(0, 0, 0, 0);
			var children = this._children;
			var tmpMat = [];
			var rect = null;
			for (var i = 0; i < children.length; i++) {
				var child = children[i];
				var childRect = child.getBoundingRect();
				var transform = child.getLocalTransform(tmpMat);
				if (transform) {
					tmpRect$2.copy(childRect);
					tmpRect$2.applyTransform(transform);
					rect = rect || tmpRect$2.clone();
					rect.union(tmpRect$2);
				} else {
					rect = rect || childRect.clone();
					rect.union(childRect);
				}
			}
			this._rect = rect || tmpRect$2;
		}
		return this._rect;
	};
	ZRText$1.prototype.setDefaultTextStyle = function(defaultTextStyle) {
		this._defaultStyle = defaultTextStyle || DEFAULT_RICH_TEXT_COLOR;
	};
	ZRText$1.prototype.setTextContent = function(textContent) {};
	ZRText$1.prototype._mergeStyle = function(targetStyle, sourceStyle) {
		if (!sourceStyle) return targetStyle;
		var sourceRich = sourceStyle.rich;
		var targetRich = targetStyle.rich || sourceRich && {};
		extend(targetStyle, sourceStyle);
		if (sourceRich && targetRich) {
			this._mergeRich(targetRich, sourceRich);
			targetStyle.rich = targetRich;
		} else if (targetRich) targetStyle.rich = targetRich;
		return targetStyle;
	};
	ZRText$1.prototype._mergeRich = function(targetRich, sourceRich) {
		var richNames = keys(sourceRich);
		for (var i = 0; i < richNames.length; i++) {
			var richName = richNames[i];
			targetRich[richName] = targetRich[richName] || {};
			extend(targetRich[richName], sourceRich[richName]);
		}
	};
	ZRText$1.prototype.getAnimationStyleProps = function() {
		return DEFAULT_TEXT_ANIMATION_PROPS;
	};
	ZRText$1.prototype._getOrCreateChild = function(Ctor) {
		var child = this._children[this._childCursor];
		if (!child || !(child instanceof Ctor)) child = new Ctor();
		this._children[this._childCursor++] = child;
		child.__zr = this.__zr;
		child.parent = this;
		return child;
	};
	ZRText$1.prototype._updatePlainTexts = function() {
		var style = this.style;
		var textFont = style.font || DEFAULT_FONT;
		var textPadding = style.padding;
		var text = getStyleText(style);
		var contentBlock = parsePlainText(text, style);
		var needDrawBg = needDrawBackground(style);
		var bgColorDrawn = !!style.backgroundColor;
		var outerHeight = contentBlock.outerHeight;
		var outerWidth = contentBlock.outerWidth;
		var contentWidth = contentBlock.contentWidth;
		var textLines = contentBlock.lines;
		var lineHeight = contentBlock.lineHeight;
		var defaultStyle = this._defaultStyle;
		this.isTruncated = !!contentBlock.isTruncated;
		var baseX = style.x || 0;
		var baseY = style.y || 0;
		var textAlign = style.align || defaultStyle.align || "left";
		var verticalAlign = style.verticalAlign || defaultStyle.verticalAlign || "top";
		var textX = baseX;
		var textY = adjustTextY(baseY, contentBlock.contentHeight, verticalAlign);
		if (needDrawBg || textPadding) {
			var boxX = adjustTextX(baseX, outerWidth, textAlign);
			var boxY = adjustTextY(baseY, outerHeight, verticalAlign);
			needDrawBg && this._renderBackground(style, style, boxX, boxY, outerWidth, outerHeight);
		}
		textY += lineHeight / 2;
		if (textPadding) {
			textX = getTextXForPadding(baseX, textAlign, textPadding);
			if (verticalAlign === "top") textY += textPadding[0];
			else if (verticalAlign === "bottom") textY -= textPadding[2];
		}
		var defaultLineWidth = 0;
		var useDefaultFill = false;
		var textFill = getFill("fill" in style ? style.fill : (useDefaultFill = true, defaultStyle.fill));
		var textStroke = getStroke("stroke" in style ? style.stroke : !bgColorDrawn && (!defaultStyle.autoStroke || useDefaultFill) ? (defaultLineWidth = DEFAULT_STROKE_LINE_WIDTH, defaultStyle.stroke) : null);
		var hasShadow = style.textShadowBlur > 0;
		var fixedBoundingRect = style.width != null && (style.overflow === "truncate" || style.overflow === "break" || style.overflow === "breakAll");
		var calculatedLineHeight = contentBlock.calculatedLineHeight;
		for (var i = 0; i < textLines.length; i++) {
			var el = this._getOrCreateChild(TSpan_default);
			var subElStyle = el.createStyle();
			el.useStyle(subElStyle);
			subElStyle.text = textLines[i];
			subElStyle.x = textX;
			subElStyle.y = textY;
			if (textAlign) subElStyle.textAlign = textAlign;
			subElStyle.textBaseline = "middle";
			subElStyle.opacity = style.opacity;
			subElStyle.strokeFirst = true;
			if (hasShadow) {
				subElStyle.shadowBlur = style.textShadowBlur || 0;
				subElStyle.shadowColor = style.textShadowColor || "transparent";
				subElStyle.shadowOffsetX = style.textShadowOffsetX || 0;
				subElStyle.shadowOffsetY = style.textShadowOffsetY || 0;
			}
			subElStyle.stroke = textStroke;
			subElStyle.fill = textFill;
			if (textStroke) {
				subElStyle.lineWidth = style.lineWidth || defaultLineWidth;
				subElStyle.lineDash = style.lineDash;
				subElStyle.lineDashOffset = style.lineDashOffset || 0;
			}
			subElStyle.font = textFont;
			setSeparateFont(subElStyle, style);
			textY += lineHeight;
			if (fixedBoundingRect) el.setBoundingRect(new BoundingRect_default(adjustTextX(subElStyle.x, contentWidth, subElStyle.textAlign), adjustTextY(subElStyle.y, calculatedLineHeight, subElStyle.textBaseline), contentWidth, calculatedLineHeight));
		}
	};
	ZRText$1.prototype._updateRichTexts = function() {
		var style = this.style;
		var text = getStyleText(style);
		var contentBlock = parseRichText(text, style);
		var contentWidth = contentBlock.width;
		var outerWidth = contentBlock.outerWidth;
		var outerHeight = contentBlock.outerHeight;
		var textPadding = style.padding;
		var baseX = style.x || 0;
		var baseY = style.y || 0;
		var defaultStyle = this._defaultStyle;
		var textAlign = style.align || defaultStyle.align;
		var verticalAlign = style.verticalAlign || defaultStyle.verticalAlign;
		this.isTruncated = !!contentBlock.isTruncated;
		var boxX = adjustTextX(baseX, outerWidth, textAlign);
		var boxY = adjustTextY(baseY, outerHeight, verticalAlign);
		var xLeft = boxX;
		var lineTop = boxY;
		if (textPadding) {
			xLeft += textPadding[3];
			lineTop += textPadding[0];
		}
		var xRight = xLeft + contentWidth;
		if (needDrawBackground(style)) this._renderBackground(style, style, boxX, boxY, outerWidth, outerHeight);
		var bgColorDrawn = !!style.backgroundColor;
		for (var i = 0; i < contentBlock.lines.length; i++) {
			var line = contentBlock.lines[i];
			var tokens = line.tokens;
			var tokenCount = tokens.length;
			var lineHeight = line.lineHeight;
			var remainedWidth = line.width;
			var leftIndex = 0;
			var lineXLeft = xLeft;
			var lineXRight = xRight;
			var rightIndex = tokenCount - 1;
			var token = void 0;
			while (leftIndex < tokenCount && (token = tokens[leftIndex], !token.align || token.align === "left")) {
				this._placeToken(token, style, lineHeight, lineTop, lineXLeft, "left", bgColorDrawn);
				remainedWidth -= token.width;
				lineXLeft += token.width;
				leftIndex++;
			}
			while (rightIndex >= 0 && (token = tokens[rightIndex], token.align === "right")) {
				this._placeToken(token, style, lineHeight, lineTop, lineXRight, "right", bgColorDrawn);
				remainedWidth -= token.width;
				lineXRight -= token.width;
				rightIndex--;
			}
			lineXLeft += (contentWidth - (lineXLeft - xLeft) - (xRight - lineXRight) - remainedWidth) / 2;
			while (leftIndex <= rightIndex) {
				token = tokens[leftIndex];
				this._placeToken(token, style, lineHeight, lineTop, lineXLeft + token.width / 2, "center", bgColorDrawn);
				lineXLeft += token.width;
				leftIndex++;
			}
			lineTop += lineHeight;
		}
	};
	ZRText$1.prototype._placeToken = function(token, style, lineHeight, lineTop, x, textAlign, parentBgColorDrawn) {
		var tokenStyle = style.rich[token.styleName] || {};
		tokenStyle.text = token.text;
		var verticalAlign = token.verticalAlign;
		var y = lineTop + lineHeight / 2;
		if (verticalAlign === "top") y = lineTop + token.height / 2;
		else if (verticalAlign === "bottom") y = lineTop + lineHeight - token.height / 2;
		var needDrawBg = !token.isLineHolder && needDrawBackground(tokenStyle);
		needDrawBg && this._renderBackground(tokenStyle, style, textAlign === "right" ? x - token.width : textAlign === "center" ? x - token.width / 2 : x, y - token.height / 2, token.width, token.height);
		var bgColorDrawn = !!tokenStyle.backgroundColor;
		var textPadding = token.textPadding;
		if (textPadding) {
			x = getTextXForPadding(x, textAlign, textPadding);
			y -= token.height / 2 - textPadding[0] - token.innerHeight / 2;
		}
		var el = this._getOrCreateChild(TSpan_default);
		var subElStyle = el.createStyle();
		el.useStyle(subElStyle);
		var defaultStyle = this._defaultStyle;
		var useDefaultFill = false;
		var defaultLineWidth = 0;
		var textFill = getFill("fill" in tokenStyle ? tokenStyle.fill : "fill" in style ? style.fill : (useDefaultFill = true, defaultStyle.fill));
		var textStroke = getStroke("stroke" in tokenStyle ? tokenStyle.stroke : "stroke" in style ? style.stroke : !bgColorDrawn && !parentBgColorDrawn && (!defaultStyle.autoStroke || useDefaultFill) ? (defaultLineWidth = DEFAULT_STROKE_LINE_WIDTH, defaultStyle.stroke) : null);
		var hasShadow = tokenStyle.textShadowBlur > 0 || style.textShadowBlur > 0;
		subElStyle.text = token.text;
		subElStyle.x = x;
		subElStyle.y = y;
		if (hasShadow) {
			subElStyle.shadowBlur = tokenStyle.textShadowBlur || style.textShadowBlur || 0;
			subElStyle.shadowColor = tokenStyle.textShadowColor || style.textShadowColor || "transparent";
			subElStyle.shadowOffsetX = tokenStyle.textShadowOffsetX || style.textShadowOffsetX || 0;
			subElStyle.shadowOffsetY = tokenStyle.textShadowOffsetY || style.textShadowOffsetY || 0;
		}
		subElStyle.textAlign = textAlign;
		subElStyle.textBaseline = "middle";
		subElStyle.font = token.font || DEFAULT_FONT;
		subElStyle.opacity = retrieve3(tokenStyle.opacity, style.opacity, 1);
		setSeparateFont(subElStyle, tokenStyle);
		if (textStroke) {
			subElStyle.lineWidth = retrieve3(tokenStyle.lineWidth, style.lineWidth, defaultLineWidth);
			subElStyle.lineDash = retrieve2(tokenStyle.lineDash, style.lineDash);
			subElStyle.lineDashOffset = style.lineDashOffset || 0;
			subElStyle.stroke = textStroke;
		}
		if (textFill) subElStyle.fill = textFill;
		var textWidth = token.contentWidth;
		var textHeight = token.contentHeight;
		el.setBoundingRect(new BoundingRect_default(adjustTextX(subElStyle.x, textWidth, subElStyle.textAlign), adjustTextY(subElStyle.y, textHeight, subElStyle.textBaseline), textWidth, textHeight));
	};
	ZRText$1.prototype._renderBackground = function(style, topStyle, x, y, width, height) {
		var textBackgroundColor = style.backgroundColor;
		var textBorderWidth = style.borderWidth;
		var textBorderColor = style.borderColor;
		var isImageBg = textBackgroundColor && textBackgroundColor.image;
		var isPlainOrGradientBg = textBackgroundColor && !isImageBg;
		var textBorderRadius = style.borderRadius;
		var self$1 = this;
		var rectEl;
		var imgEl;
		if (isPlainOrGradientBg || style.lineHeight || textBorderWidth && textBorderColor) {
			rectEl = this._getOrCreateChild(Rect_default);
			rectEl.useStyle(rectEl.createStyle());
			rectEl.style.fill = null;
			var rectShape = rectEl.shape;
			rectShape.x = x;
			rectShape.y = y;
			rectShape.width = width;
			rectShape.height = height;
			rectShape.r = textBorderRadius;
			rectEl.dirtyShape();
		}
		if (isPlainOrGradientBg) {
			var rectStyle = rectEl.style;
			rectStyle.fill = textBackgroundColor || null;
			rectStyle.fillOpacity = retrieve2(style.fillOpacity, 1);
		} else if (isImageBg) {
			imgEl = this._getOrCreateChild(Image_default);
			imgEl.onload = function() {
				self$1.dirtyStyle();
			};
			var imgStyle = imgEl.style;
			imgStyle.image = textBackgroundColor.image;
			imgStyle.x = x;
			imgStyle.y = y;
			imgStyle.width = width;
			imgStyle.height = height;
		}
		if (textBorderWidth && textBorderColor) {
			var rectStyle = rectEl.style;
			rectStyle.lineWidth = textBorderWidth;
			rectStyle.stroke = textBorderColor;
			rectStyle.strokeOpacity = retrieve2(style.strokeOpacity, 1);
			rectStyle.lineDash = style.borderDash;
			rectStyle.lineDashOffset = style.borderDashOffset || 0;
			rectEl.strokeContainThreshold = 0;
			if (rectEl.hasFill() && rectEl.hasStroke()) {
				rectStyle.strokeFirst = true;
				rectStyle.lineWidth *= 2;
			}
		}
		var commonStyle = (rectEl || imgEl).style;
		commonStyle.shadowBlur = style.shadowBlur || 0;
		commonStyle.shadowColor = style.shadowColor || "transparent";
		commonStyle.shadowOffsetX = style.shadowOffsetX || 0;
		commonStyle.shadowOffsetY = style.shadowOffsetY || 0;
		commonStyle.opacity = retrieve3(style.opacity, topStyle.opacity, 1);
	};
	ZRText$1.makeFont = function(style) {
		var font = "";
		if (hasSeparateFont(style)) font = [
			style.fontStyle,
			style.fontWeight,
			parseFontSize(style.fontSize),
			style.fontFamily || "sans-serif"
		].join(" ");
		return font && trim(font) || style.textFont || style.font;
	};
	return ZRText$1;
}(Displayable_default);
var VALID_TEXT_ALIGN = {
	left: true,
	right: 1,
	center: 1
};
var VALID_TEXT_VERTICAL_ALIGN = {
	top: 1,
	bottom: 1,
	middle: 1
};
var FONT_PARTS = [
	"fontStyle",
	"fontWeight",
	"fontSize",
	"fontFamily"
];
function parseFontSize(fontSize) {
	if (typeof fontSize === "string" && (fontSize.indexOf("px") !== -1 || fontSize.indexOf("rem") !== -1 || fontSize.indexOf("em") !== -1)) return fontSize;
	else if (!isNaN(+fontSize)) return fontSize + "px";
	else return DEFAULT_FONT_SIZE + "px";
}
function setSeparateFont(targetStyle, sourceStyle) {
	for (var i = 0; i < FONT_PARTS.length; i++) {
		var fontProp = FONT_PARTS[i];
		var val = sourceStyle[fontProp];
		if (val != null) targetStyle[fontProp] = val;
	}
}
function hasSeparateFont(style) {
	return style.fontSize != null || style.fontFamily || style.fontWeight;
}
function normalizeTextStyle(style) {
	normalizeStyle$1(style);
	each$4(style.rich, normalizeStyle$1);
	return style;
}
function normalizeStyle$1(style) {
	if (style) {
		style.font = ZRText.makeFont(style);
		var textAlign = style.align;
		textAlign === "middle" && (textAlign = "center");
		style.align = textAlign == null || VALID_TEXT_ALIGN[textAlign] ? textAlign : "left";
		var verticalAlign = style.verticalAlign;
		verticalAlign === "center" && (verticalAlign = "middle");
		style.verticalAlign = verticalAlign == null || VALID_TEXT_VERTICAL_ALIGN[verticalAlign] ? verticalAlign : "top";
		var textPadding = style.padding;
		if (textPadding) style.padding = normalizeCssArray$1(style.padding);
	}
}
function getStroke(stroke, lineWidth) {
	return stroke == null || lineWidth <= 0 || stroke === "transparent" || stroke === "none" ? null : stroke.image || stroke.colorStops ? "#000" : stroke;
}
function getFill(fill) {
	return fill == null || fill === "none" ? null : fill.image || fill.colorStops ? "#000" : fill;
}
function getTextXForPadding(x, textAlign, textPadding) {
	return textAlign === "right" ? x - textPadding[1] : textAlign === "center" ? x + textPadding[3] / 2 - textPadding[1] / 2 : x + textPadding[3];
}
function getStyleText(style) {
	var text = style.text;
	text != null && (text += "");
	return text;
}
function needDrawBackground(style) {
	return !!(style.backgroundColor || style.lineHeight || style.borderWidth && style.borderColor);
}
var Text_default = ZRText;
var RADIAN_EPSILON = 1e-4;
var ROUND_SUPPORTED_PRECISION_MAX = 20;
function _trim(str) {
	return str.replace(/^\s+|\s+$/g, "");
}
function linearMap(val, domain, range, clamp$1) {
	var d0 = domain[0];
	var d1 = domain[1];
	var r0 = range[0];
	var r1 = range[1];
	var subDomain = d1 - d0;
	var subRange = r1 - r0;
	if (subDomain === 0) return subRange === 0 ? r0 : (r0 + r1) / 2;
	if (clamp$1) {
		if (subDomain > 0) {
			if (val <= d0) return r0;
			else if (val >= d1) return r1;
		} else if (val >= d0) return r0;
		else if (val <= d1) return r1;
	} else {
		if (val === d0) return r0;
		if (val === d1) return r1;
	}
	return (val - d0) / subDomain * subRange + r0;
}
function parsePercent(percent, all) {
	switch (percent) {
		case "center":
		case "middle":
			percent = "50%";
			break;
		case "left":
		case "top":
			percent = "0%";
			break;
		case "right":
		case "bottom":
			percent = "100%";
			break;
	}
	if (isString(percent)) {
		if (_trim(percent).match(/%$/)) return parseFloat(percent) / 100 * all;
		return parseFloat(percent);
	}
	return percent == null ? NaN : +percent;
}
function round(x, precision, returnStr) {
	if (precision == null) precision = 10;
	precision = Math.min(Math.max(0, precision), ROUND_SUPPORTED_PRECISION_MAX);
	x = (+x).toFixed(precision);
	return returnStr ? x : +x;
}
function getPrecision(val) {
	val = +val;
	if (isNaN(val)) return 0;
	if (val > 1e-14) {
		var e$1 = 1;
		for (var i = 0; i < 15; i++, e$1 *= 10) if (Math.round(val * e$1) / e$1 === val) return i;
	}
	return getPrecisionSafe(val);
}
function getPrecisionSafe(val) {
	var str = val.toString().toLowerCase();
	var eIndex = str.indexOf("e");
	var exp = eIndex > 0 ? +str.slice(eIndex + 1) : 0;
	var significandPartLen = eIndex > 0 ? eIndex : str.length;
	var dotIndex = str.indexOf(".");
	var decimalPartLen = dotIndex < 0 ? 0 : significandPartLen - 1 - dotIndex;
	return Math.max(0, decimalPartLen - exp);
}
function getPixelPrecision(dataExtent, pixelExtent) {
	var log = Math.log;
	var LN10 = Math.LN10;
	var dataQuantity = Math.floor(log(dataExtent[1] - dataExtent[0]) / LN10);
	var sizeQuantity = Math.round(log(Math.abs(pixelExtent[1] - pixelExtent[0])) / LN10);
	var precision = Math.min(Math.max(-dataQuantity + sizeQuantity, 0), 20);
	return !isFinite(precision) ? 20 : precision;
}
function addSafe(val0, val1) {
	var maxPrecision = Math.max(getPrecision(val0), getPrecision(val1));
	var sum = val0 + val1;
	return maxPrecision > ROUND_SUPPORTED_PRECISION_MAX ? sum : round(sum, maxPrecision);
}
function remRadian(radian) {
	var pi2 = Math.PI * 2;
	return (radian % pi2 + pi2) % pi2;
}
function isRadianAroundZero(val) {
	return val > -RADIAN_EPSILON && val < RADIAN_EPSILON;
}
var TIME_REG = /^(?:(\d{4})(?:[-\/](\d{1,2})(?:[-\/](\d{1,2})(?:[T ](\d{1,2})(?::(\d{1,2})(?::(\d{1,2})(?:[.,](\d+))?)?)?(Z|[\+\-]\d\d:?\d\d)?)?)?)?)?$/;
function parseDate(value) {
	if (value instanceof Date) return value;
	else if (isString(value)) {
		var match = TIME_REG.exec(value);
		if (!match) return new Date(NaN);
		if (!match[8]) return new Date(+match[1], +(match[2] || 1) - 1, +match[3] || 1, +match[4] || 0, +(match[5] || 0), +match[6] || 0, match[7] ? +match[7].substring(0, 3) : 0);
		else {
			var hour = +match[4] || 0;
			if (match[8].toUpperCase() !== "Z") hour -= +match[8].slice(0, 3);
			return new Date(Date.UTC(+match[1], +(match[2] || 1) - 1, +match[3] || 1, hour, +(match[5] || 0), +match[6] || 0, match[7] ? +match[7].substring(0, 3) : 0));
		}
	} else if (value == null) return new Date(NaN);
	return new Date(Math.round(value));
}
function quantity(val) {
	return Math.pow(10, quantityExponent(val));
}
function quantityExponent(val) {
	if (val === 0) return 0;
	var exp = Math.floor(Math.log(val) / Math.LN10);
	/**
	
	* exp is expected to be the rounded-down result of the base-10 log of val.
	
	* But due to the precision loss with Math.log(val), we need to restore it
	
	* using 10^exp to make sure we can get val back from exp. #11249
	
	*/
	if (val / Math.pow(10, exp) >= 10) exp++;
	return exp;
}
function nice(val, round$2) {
	var exponent = quantityExponent(val);
	var exp10 = Math.pow(10, exponent);
	var f = val / exp10;
	var nf;
	if (round$2) if (f < 1.5) nf = 1;
	else if (f < 2.5) nf = 2;
	else if (f < 4) nf = 3;
	else if (f < 7) nf = 5;
	else nf = 10;
	else if (f < 1) nf = 1;
	else if (f < 2) nf = 2;
	else if (f < 3) nf = 3;
	else if (f < 5) nf = 5;
	else nf = 10;
	val = nf * exp10;
	return exponent >= -20 ? +val.toFixed(exponent < 0 ? -exponent : 0) : val;
}
function numericToNumber(val) {
	var valFloat = parseFloat(val);
	return valFloat == val && (valFloat !== 0 || !isString(val) || val.indexOf("x") <= 0) ? valFloat : NaN;
}
function isNumeric(val) {
	return !isNaN(numericToNumber(val));
}
function getRandomIdBase() {
	return Math.round(Math.random() * 9);
}
function getGreatestCommonDividor(a, b) {
	if (b === 0) return a;
	return getGreatestCommonDividor(b, a % b);
}
function getLeastCommonMultiple(a, b) {
	if (a == null) return b;
	if (b == null) return a;
	return a * b / getGreatestCommonDividor(a, b);
}
function deprecateLog(str) {}
function throwError(msg) {
	throw new Error(msg);
}
/**

* Make the name displayable. But we should

* make sure it is not duplicated with user

* specified name, so use '\0';

*/
var DUMMY_COMPONENT_NAME_PREFIX = "series\0";
var INTERNAL_COMPONENT_ID_PREFIX = "\0_ec_\0";
function normalizeToArray(value) {
	return value instanceof Array ? value : value == null ? [] : [value];
}
function defaultEmphasis(opt, key, subOpts) {
	if (opt) {
		opt[key] = opt[key] || {};
		opt.emphasis = opt.emphasis || {};
		opt.emphasis[key] = opt.emphasis[key] || {};
		for (var i = 0, len$1 = subOpts.length; i < len$1; i++) {
			var subOptName = subOpts[i];
			if (!opt.emphasis[key].hasOwnProperty(subOptName) && opt[key].hasOwnProperty(subOptName)) opt.emphasis[key][subOptName] = opt[key][subOptName];
		}
	}
}
var TEXT_STYLE_OPTIONS = [
	"fontStyle",
	"fontWeight",
	"fontSize",
	"fontFamily",
	"rich",
	"tag",
	"color",
	"textBorderColor",
	"textBorderWidth",
	"width",
	"height",
	"lineHeight",
	"align",
	"verticalAlign",
	"baseline",
	"shadowColor",
	"shadowBlur",
	"shadowOffsetX",
	"shadowOffsetY",
	"textShadowColor",
	"textShadowBlur",
	"textShadowOffsetX",
	"textShadowOffsetY",
	"backgroundColor",
	"borderColor",
	"borderWidth",
	"borderRadius",
	"padding"
];
function getDataItemValue(dataItem) {
	return isObject$2(dataItem) && !isArray(dataItem) && !(dataItem instanceof Date) ? dataItem.value : dataItem;
}
function isDataItemOption(dataItem) {
	return isObject$2(dataItem) && !(dataItem instanceof Array);
}
function mappingToExists(existings, newCmptOptions, mode) {
	var isNormalMergeMode = mode === "normalMerge";
	var isReplaceMergeMode = mode === "replaceMerge";
	var isReplaceAllMode = mode === "replaceAll";
	existings = existings || [];
	newCmptOptions = (newCmptOptions || []).slice();
	var existingIdIdxMap = createHashMap();
	each$4(newCmptOptions, function(cmptOption, index) {
		if (!isObject$2(cmptOption)) {
			newCmptOptions[index] = null;
			return;
		}
	});
	var result = prepareResult(existings, existingIdIdxMap, mode);
	if (isNormalMergeMode || isReplaceMergeMode) mappingById(result, existings, existingIdIdxMap, newCmptOptions);
	if (isNormalMergeMode) mappingByName(result, newCmptOptions);
	if (isNormalMergeMode || isReplaceMergeMode) mappingByIndex(result, newCmptOptions, isReplaceMergeMode);
	else if (isReplaceAllMode) mappingInReplaceAllMode(result, newCmptOptions);
	makeIdAndName(result);
	return result;
}
function prepareResult(existings, existingIdIdxMap, mode) {
	var result = [];
	if (mode === "replaceAll") return result;
	for (var index = 0; index < existings.length; index++) {
		var existing = existings[index];
		if (existing && existing.id != null) existingIdIdxMap.set(existing.id, index);
		result.push({
			existing: mode === "replaceMerge" || isComponentIdInternal(existing) ? null : existing,
			newOption: null,
			keyInfo: null,
			brandNew: null
		});
	}
	return result;
}
function mappingById(result, existings, existingIdIdxMap, newCmptOptions) {
	each$4(newCmptOptions, function(cmptOption, index) {
		if (!cmptOption || cmptOption.id == null) return;
		var optionId = makeComparableKey(cmptOption.id);
		var existingIdx = existingIdIdxMap.get(optionId);
		if (existingIdx != null) {
			var resultItem = result[existingIdx];
			assert(!resultItem.newOption, "Duplicated option on id \"" + optionId + "\".");
			resultItem.newOption = cmptOption;
			resultItem.existing = existings[existingIdx];
			newCmptOptions[index] = null;
		}
	});
}
function mappingByName(result, newCmptOptions) {
	each$4(newCmptOptions, function(cmptOption, index) {
		if (!cmptOption || cmptOption.name == null) return;
		for (var i = 0; i < result.length; i++) {
			var existing = result[i].existing;
			if (!result[i].newOption && existing && (existing.id == null || cmptOption.id == null) && !isComponentIdInternal(cmptOption) && !isComponentIdInternal(existing) && keyExistAndEqual("name", existing, cmptOption)) {
				result[i].newOption = cmptOption;
				newCmptOptions[index] = null;
				return;
			}
		}
	});
}
function mappingByIndex(result, newCmptOptions, brandNew) {
	each$4(newCmptOptions, function(cmptOption) {
		if (!cmptOption) return;
		var resultItem;
		var nextIdx = 0;
		while ((resultItem = result[nextIdx]) && (resultItem.newOption || isComponentIdInternal(resultItem.existing) || resultItem.existing && cmptOption.id != null && !keyExistAndEqual("id", cmptOption, resultItem.existing))) nextIdx++;
		if (resultItem) {
			resultItem.newOption = cmptOption;
			resultItem.brandNew = brandNew;
		} else result.push({
			newOption: cmptOption,
			brandNew,
			existing: null,
			keyInfo: null
		});
		nextIdx++;
	});
}
function mappingInReplaceAllMode(result, newCmptOptions) {
	each$4(newCmptOptions, function(cmptOption) {
		result.push({
			newOption: cmptOption,
			brandNew: true,
			existing: null,
			keyInfo: null
		});
	});
}
/**

* Make id and name for mapping result (result of mappingToExists)

* into `keyInfo` field.

*/
function makeIdAndName(mapResult) {
	var idMap = createHashMap();
	each$4(mapResult, function(item) {
		var existing = item.existing;
		existing && idMap.set(existing.id, item);
	});
	each$4(mapResult, function(item) {
		var opt = item.newOption;
		assert(!opt || opt.id == null || !idMap.get(opt.id) || idMap.get(opt.id) === item, "id duplicates: " + (opt && opt.id));
		opt && opt.id != null && idMap.set(opt.id, item);
		!item.keyInfo && (item.keyInfo = {});
	});
	each$4(mapResult, function(item, index) {
		var existing = item.existing;
		var opt = item.newOption;
		var keyInfo = item.keyInfo;
		if (!isObject$2(opt)) return;
		keyInfo.name = opt.name != null ? makeComparableKey(opt.name) : existing ? existing.name : DUMMY_COMPONENT_NAME_PREFIX + index;
		if (existing) keyInfo.id = makeComparableKey(existing.id);
		else if (opt.id != null) keyInfo.id = makeComparableKey(opt.id);
		else {
			var idNum = 0;
			do
				keyInfo.id = "\0" + keyInfo.name + "\0" + idNum++;
			while (idMap.get(keyInfo.id));
		}
		idMap.set(keyInfo.id, item);
	});
}
function keyExistAndEqual(attr, obj1, obj2) {
	var key1 = convertOptionIdName(obj1[attr], null);
	var key2 = convertOptionIdName(obj2[attr], null);
	return key1 != null && key2 != null && key1 === key2;
}
/**

* @return return null if not exist.

*/
function makeComparableKey(val) {
	return convertOptionIdName(val, "");
}
function convertOptionIdName(idOrName, defaultValue) {
	if (idOrName == null) return defaultValue;
	return isString(idOrName) ? idOrName : isNumber(idOrName) || isStringSafe(idOrName) ? idOrName + "" : defaultValue;
}
function isNameSpecified(componentModel) {
	var name = componentModel.name;
	return !!(name && name.indexOf(DUMMY_COMPONENT_NAME_PREFIX));
}
function isComponentIdInternal(cmptOption) {
	return cmptOption && cmptOption.id != null && makeComparableKey(cmptOption.id).indexOf(INTERNAL_COMPONENT_ID_PREFIX) === 0;
}
function setComponentTypeToKeyInfo(mappingResult, mainType, componentModelCtor) {
	each$4(mappingResult, function(item) {
		var newOption = item.newOption;
		if (isObject$2(newOption)) {
			item.keyInfo.mainType = mainType;
			item.keyInfo.subType = determineSubType(mainType, newOption, item.existing, componentModelCtor);
		}
	});
}
function determineSubType(mainType, newCmptOption, existComponent, componentModelCtor) {
	var subType = newCmptOption.type ? newCmptOption.type : existComponent ? existComponent.subType : componentModelCtor.determineSubType(mainType, newCmptOption);
	return subType;
}
function queryDataIndex(data, payload) {
	if (payload.dataIndexInside != null) return payload.dataIndexInside;
	else if (payload.dataIndex != null) return isArray(payload.dataIndex) ? map$1(payload.dataIndex, function(value) {
		return data.indexOfRawIndex(value);
	}) : data.indexOfRawIndex(payload.dataIndex);
	else if (payload.name != null) return isArray(payload.name) ? map$1(payload.name, function(value) {
		return data.indexOfName(value);
	}) : data.indexOfName(payload.name);
}
function makeInner() {
	var key = "__ec_inner_" + innerUniqueIndex++;
	return function(hostObj) {
		return hostObj[key] || (hostObj[key] = {});
	};
}
var innerUniqueIndex = getRandomIdBase();
function parseFinder(ecModel, finderInput, opt) {
	var _a$1 = preParseFinder(finderInput, opt), mainTypeSpecified = _a$1.mainTypeSpecified, queryOptionMap = _a$1.queryOptionMap, others = _a$1.others;
	var result = others;
	var defaultMainType = opt ? opt.defaultMainType : null;
	if (!mainTypeSpecified && defaultMainType) queryOptionMap.set(defaultMainType, {});
	queryOptionMap.each(function(queryOption, mainType) {
		var queryResult = queryReferringComponents(ecModel, mainType, queryOption, {
			useDefault: defaultMainType === mainType,
			enableAll: opt && opt.enableAll != null ? opt.enableAll : true,
			enableNone: opt && opt.enableNone != null ? opt.enableNone : true
		});
		result[mainType + "Models"] = queryResult.models;
		result[mainType + "Model"] = queryResult.models[0];
	});
	return result;
}
function preParseFinder(finderInput, opt) {
	var finder;
	if (isString(finderInput)) {
		var obj = {};
		obj[finderInput + "Index"] = 0;
		finder = obj;
	} else finder = finderInput;
	var queryOptionMap = createHashMap();
	var others = {};
	var mainTypeSpecified = false;
	each$4(finder, function(value, key) {
		if (key === "dataIndex" || key === "dataIndexInside") {
			others[key] = value;
			return;
		}
		var parsedKey = key.match(/^(\w+)(Index|Id|Name)$/) || [];
		var mainType = parsedKey[1];
		var queryType = (parsedKey[2] || "").toLowerCase();
		if (!mainType || !queryType || opt && opt.includeMainTypes && indexOf(opt.includeMainTypes, mainType) < 0) return;
		mainTypeSpecified = mainTypeSpecified || !!mainType;
		var queryOption = queryOptionMap.get(mainType) || queryOptionMap.set(mainType, {});
		queryOption[queryType] = value;
	});
	return {
		mainTypeSpecified,
		queryOptionMap,
		others
	};
}
var SINGLE_REFERRING = {
	useDefault: true,
	enableAll: false,
	enableNone: false
};
function queryReferringComponents(ecModel, mainType, userOption, opt) {
	opt = opt || SINGLE_REFERRING;
	var indexOption = userOption.index;
	var idOption = userOption.id;
	var nameOption = userOption.name;
	var result = {
		models: null,
		specified: indexOption != null || idOption != null || nameOption != null
	};
	if (!result.specified) {
		var firstCmpt = void 0;
		result.models = opt.useDefault && (firstCmpt = ecModel.getComponent(mainType)) ? [firstCmpt] : [];
		return result;
	}
	if (indexOption === "none" || indexOption === false) {
		assert(opt.enableNone, "`\"none\"` or `false` is not a valid value on index option.");
		result.models = [];
		return result;
	}
	if (indexOption === "all") {
		assert(opt.enableAll, "`\"all\"` is not a valid value on index option.");
		indexOption = idOption = nameOption = null;
	}
	result.models = ecModel.queryComponents({
		mainType,
		index: indexOption,
		id: idOption,
		name: nameOption
	});
	return result;
}
function setAttribute(dom, key, value) {
	dom.setAttribute ? dom.setAttribute(key, value) : dom[key] = value;
}
function getAttribute(dom, key) {
	return dom.getAttribute ? dom.getAttribute(key) : dom[key];
}
function getTooltipRenderMode(renderModeOption) {
	if (renderModeOption === "auto") return env_default.domSupported ? "html" : "richText";
	else return renderModeOption || "html";
}
var getECData = makeInner();
var setCommonECData = function(seriesIndex, dataType, dataIdx, el) {
	if (el) {
		var ecData = getECData(el);
		ecData.dataIndex = dataIdx;
		ecData.dataType = dataType;
		ecData.seriesIndex = seriesIndex;
		ecData.ssrType = "chart";
		if (el.type === "group") el.traverse(function(child) {
			var childECData = getECData(child);
			childECData.seriesIndex = seriesIndex;
			childECData.dataIndex = dataIdx;
			childECData.dataType = dataType;
			childECData.ssrType = "chart";
		});
	}
};
var _highlightNextDigit = 1;
var _highlightKeyMap = {};
var getSavedStates = makeInner();
var getComponentStates = makeInner();
var HOVER_STATE_NORMAL = 0;
var HOVER_STATE_BLUR = 1;
var HOVER_STATE_EMPHASIS = 2;
var SPECIAL_STATES = [
	"emphasis",
	"blur",
	"select"
];
var DISPLAY_STATES = [
	"normal",
	"emphasis",
	"blur",
	"select"
];
var Z2_EMPHASIS_LIFT = 10;
var Z2_SELECT_LIFT = 9;
var HIGHLIGHT_ACTION_TYPE = "highlight";
var DOWNPLAY_ACTION_TYPE = "downplay";
var SELECT_ACTION_TYPE = "select";
var UNSELECT_ACTION_TYPE = "unselect";
var TOGGLE_SELECT_ACTION_TYPE = "toggleSelect";
function hasFillOrStroke(fillOrStroke) {
	return fillOrStroke != null && fillOrStroke !== "none";
}
function doChangeHoverState(el, stateName, hoverStateEnum) {
	if (el.onHoverStateChange && (el.hoverState || 0) !== hoverStateEnum) el.onHoverStateChange(stateName);
	el.hoverState = hoverStateEnum;
}
function singleEnterEmphasis(el) {
	doChangeHoverState(el, "emphasis", HOVER_STATE_EMPHASIS);
}
function singleLeaveEmphasis(el) {
	if (el.hoverState === HOVER_STATE_EMPHASIS) doChangeHoverState(el, "normal", HOVER_STATE_NORMAL);
}
function singleEnterBlur(el) {
	doChangeHoverState(el, "blur", HOVER_STATE_BLUR);
}
function singleLeaveBlur(el) {
	if (el.hoverState === HOVER_STATE_BLUR) doChangeHoverState(el, "normal", HOVER_STATE_NORMAL);
}
function singleEnterSelect(el) {
	el.selected = true;
}
function singleLeaveSelect(el) {
	el.selected = false;
}
function updateElementState(el, updater, commonParam) {
	updater(el, commonParam);
}
function traverseUpdateState(el, updater, commonParam) {
	updateElementState(el, updater, commonParam);
	el.isGroup && el.traverse(function(child) {
		updateElementState(child, updater, commonParam);
	});
}
function getFromStateStyle(el, props, toStateName, defaultValue) {
	var style = el.style;
	var fromState = {};
	for (var i = 0; i < props.length; i++) {
		var propName = props[i];
		var val = style[propName];
		fromState[propName] = val == null ? defaultValue && defaultValue[propName] : val;
	}
	for (var i = 0; i < el.animators.length; i++) {
		var animator = el.animators[i];
		if (animator.__fromStateTransition && animator.__fromStateTransition.indexOf(toStateName) < 0 && animator.targetName === "style") animator.saveTo(fromState, props);
	}
	return fromState;
}
function createEmphasisDefaultState(el, stateName, targetStates, state) {
	var hasSelect = targetStates && indexOf(targetStates, "select") >= 0;
	var cloned = false;
	if (el instanceof Path_default) {
		var store = getSavedStates(el);
		var fromFill = hasSelect ? store.selectFill || store.normalFill : store.normalFill;
		var fromStroke = hasSelect ? store.selectStroke || store.normalStroke : store.normalStroke;
		if (hasFillOrStroke(fromFill) || hasFillOrStroke(fromStroke)) {
			state = state || {};
			var emphasisStyle = state.style || {};
			if (emphasisStyle.fill === "inherit") {
				cloned = true;
				state = extend({}, state);
				emphasisStyle = extend({}, emphasisStyle);
				emphasisStyle.fill = fromFill;
			} else if (!hasFillOrStroke(emphasisStyle.fill) && hasFillOrStroke(fromFill)) {
				cloned = true;
				state = extend({}, state);
				emphasisStyle = extend({}, emphasisStyle);
				emphasisStyle.fill = liftColor(fromFill);
			} else if (!hasFillOrStroke(emphasisStyle.stroke) && hasFillOrStroke(fromStroke)) {
				if (!cloned) {
					state = extend({}, state);
					emphasisStyle = extend({}, emphasisStyle);
				}
				emphasisStyle.stroke = liftColor(fromStroke);
			}
			state.style = emphasisStyle;
		}
	}
	if (state) {
		if (state.z2 == null) {
			if (!cloned) state = extend({}, state);
			var z2EmphasisLift = el.z2EmphasisLift;
			state.z2 = el.z2 + (z2EmphasisLift != null ? z2EmphasisLift : Z2_EMPHASIS_LIFT);
		}
	}
	return state;
}
function createSelectDefaultState(el, stateName, state) {
	if (state) {
		if (state.z2 == null) {
			state = extend({}, state);
			var z2SelectLift = el.z2SelectLift;
			state.z2 = el.z2 + (z2SelectLift != null ? z2SelectLift : Z2_SELECT_LIFT);
		}
	}
	return state;
}
function createBlurDefaultState(el, stateName, state) {
	var hasBlur = indexOf(el.currentStates, stateName) >= 0;
	var currentOpacity = el.style.opacity;
	var fromState = !hasBlur ? getFromStateStyle(el, ["opacity"], stateName, { opacity: 1 }) : null;
	state = state || {};
	var blurStyle = state.style || {};
	if (blurStyle.opacity == null) {
		state = extend({}, state);
		blurStyle = extend({ opacity: hasBlur ? currentOpacity : fromState.opacity * .1 }, blurStyle);
		state.style = blurStyle;
	}
	return state;
}
function elementStateProxy(stateName, targetStates) {
	var state = this.states[stateName];
	if (this.style) {
		if (stateName === "emphasis") return createEmphasisDefaultState(this, stateName, targetStates, state);
		else if (stateName === "blur") return createBlurDefaultState(this, stateName, state);
		else if (stateName === "select") return createSelectDefaultState(this, stateName, state);
	}
	return state;
}
function setDefaultStateProxy(el) {
	el.stateProxy = elementStateProxy;
	var textContent = el.getTextContent();
	var textGuide = el.getTextGuideLine();
	if (textContent) textContent.stateProxy = elementStateProxy;
	if (textGuide) textGuide.stateProxy = elementStateProxy;
}
function enterEmphasisWhenMouseOver(el, e$1) {
	!shouldSilent(el, e$1) && !el.__highByOuter && traverseUpdateState(el, singleEnterEmphasis);
}
function leaveEmphasisWhenMouseOut(el, e$1) {
	!shouldSilent(el, e$1) && !el.__highByOuter && traverseUpdateState(el, singleLeaveEmphasis);
}
function enterEmphasis(el, highlightDigit) {
	el.__highByOuter |= 1 << (highlightDigit || 0);
	traverseUpdateState(el, singleEnterEmphasis);
}
function leaveEmphasis(el, highlightDigit) {
	!(el.__highByOuter &= ~(1 << (highlightDigit || 0))) && traverseUpdateState(el, singleLeaveEmphasis);
}
function enterBlur(el) {
	traverseUpdateState(el, singleEnterBlur);
}
function leaveBlur(el) {
	traverseUpdateState(el, singleLeaveBlur);
}
function enterSelect(el) {
	traverseUpdateState(el, singleEnterSelect);
}
function leaveSelect(el) {
	traverseUpdateState(el, singleLeaveSelect);
}
function shouldSilent(el, e$1) {
	return el.__highDownSilentOnTouch && e$1.zrByTouch;
}
function allLeaveBlur(api) {
	var model = api.getModel();
	var leaveBlurredSeries = [];
	var allComponentViews = [];
	model.eachComponent(function(componentType, componentModel) {
		var componentStates = getComponentStates(componentModel);
		var isSeries$1 = componentType === "series";
		var view = isSeries$1 ? api.getViewOfSeriesModel(componentModel) : api.getViewOfComponentModel(componentModel);
		!isSeries$1 && allComponentViews.push(view);
		if (componentStates.isBlured) {
			view.group.traverse(function(child) {
				singleLeaveBlur(child);
			});
			isSeries$1 && leaveBlurredSeries.push(componentModel);
		}
		componentStates.isBlured = false;
	});
	each$4(allComponentViews, function(view) {
		if (view && view.toggleBlurSeries) view.toggleBlurSeries(leaveBlurredSeries, false, model);
	});
}
function blurSeries(targetSeriesIndex, focus, blurScope, api) {
	var ecModel = api.getModel();
	blurScope = blurScope || "coordinateSystem";
	function leaveBlurOfIndices(data, dataIndices) {
		for (var i = 0; i < dataIndices.length; i++) {
			var itemEl = data.getItemGraphicEl(dataIndices[i]);
			itemEl && leaveBlur(itemEl);
		}
	}
	if (targetSeriesIndex == null) return;
	if (!focus || focus === "none") return;
	var targetSeriesModel = ecModel.getSeriesByIndex(targetSeriesIndex);
	var targetCoordSys = targetSeriesModel.coordinateSystem;
	if (targetCoordSys && targetCoordSys.master) targetCoordSys = targetCoordSys.master;
	var blurredSeries = [];
	ecModel.eachSeries(function(seriesModel) {
		var sameSeries = targetSeriesModel === seriesModel;
		var coordSys = seriesModel.coordinateSystem;
		if (coordSys && coordSys.master) coordSys = coordSys.master;
		var sameCoordSys = coordSys && targetCoordSys ? coordSys === targetCoordSys : sameSeries;
		if (!(blurScope === "series" && !sameSeries || blurScope === "coordinateSystem" && !sameCoordSys || focus === "series" && sameSeries)) {
			var view = api.getViewOfSeriesModel(seriesModel);
			view.group.traverse(function(child) {
				if (child.__highByOuter && sameSeries && focus === "self") return;
				singleEnterBlur(child);
			});
			if (isArrayLike(focus)) leaveBlurOfIndices(seriesModel.getData(), focus);
			else if (isObject$2(focus)) {
				var dataTypes = keys(focus);
				for (var d = 0; d < dataTypes.length; d++) leaveBlurOfIndices(seriesModel.getData(dataTypes[d]), focus[dataTypes[d]]);
			}
			blurredSeries.push(seriesModel);
			getComponentStates(seriesModel).isBlured = true;
		}
	});
	ecModel.eachComponent(function(componentType, componentModel) {
		if (componentType === "series") return;
		var view = api.getViewOfComponentModel(componentModel);
		if (view && view.toggleBlurSeries) view.toggleBlurSeries(blurredSeries, true, ecModel);
	});
}
function blurComponent(componentMainType, componentIndex, api) {
	if (componentMainType == null || componentIndex == null) return;
	var componentModel = api.getModel().getComponent(componentMainType, componentIndex);
	if (!componentModel) return;
	getComponentStates(componentModel).isBlured = true;
	var view = api.getViewOfComponentModel(componentModel);
	if (!view || !view.focusBlurEnabled) return;
	view.group.traverse(function(child) {
		singleEnterBlur(child);
	});
}
function blurSeriesFromHighlightPayload(seriesModel, payload, api) {
	var seriesIndex = seriesModel.seriesIndex;
	var data = seriesModel.getData(payload.dataType);
	if (!data) return;
	var dataIndex = queryDataIndex(data, payload);
	dataIndex = (isArray(dataIndex) ? dataIndex[0] : dataIndex) || 0;
	var el = data.getItemGraphicEl(dataIndex);
	if (!el) {
		var count = data.count();
		var current = 0;
		while (!el && current < count) el = data.getItemGraphicEl(current++);
	}
	if (el) {
		var ecData = getECData(el);
		blurSeries(seriesIndex, ecData.focus, ecData.blurScope, api);
	} else {
		var focus_1 = seriesModel.get(["emphasis", "focus"]);
		var blurScope = seriesModel.get(["emphasis", "blurScope"]);
		if (focus_1 != null) blurSeries(seriesIndex, focus_1, blurScope, api);
	}
}
function findComponentHighDownDispatchers(componentMainType, componentIndex, name, api) {
	var ret = {
		focusSelf: false,
		dispatchers: null
	};
	if (componentMainType == null || componentMainType === "series" || componentIndex == null || name == null) return ret;
	var componentModel = api.getModel().getComponent(componentMainType, componentIndex);
	if (!componentModel) return ret;
	var view = api.getViewOfComponentModel(componentModel);
	if (!view || !view.findHighDownDispatchers) return ret;
	var dispatchers = view.findHighDownDispatchers(name);
	var focusSelf;
	for (var i = 0; i < dispatchers.length; i++) if (getECData(dispatchers[i]).focus === "self") {
		focusSelf = true;
		break;
	}
	return {
		focusSelf,
		dispatchers
	};
}
function handleGlobalMouseOverForHighDown(dispatcher, e$1, api) {
	var ecData = getECData(dispatcher);
	var _a$1 = findComponentHighDownDispatchers(ecData.componentMainType, ecData.componentIndex, ecData.componentHighDownName, api), dispatchers = _a$1.dispatchers, focusSelf = _a$1.focusSelf;
	if (dispatchers) {
		if (focusSelf) blurComponent(ecData.componentMainType, ecData.componentIndex, api);
		each$4(dispatchers, function(dispatcher$1) {
			return enterEmphasisWhenMouseOver(dispatcher$1, e$1);
		});
	} else {
		blurSeries(ecData.seriesIndex, ecData.focus, ecData.blurScope, api);
		if (ecData.focus === "self") blurComponent(ecData.componentMainType, ecData.componentIndex, api);
		enterEmphasisWhenMouseOver(dispatcher, e$1);
	}
}
function handleGlobalMouseOutForHighDown(dispatcher, e$1, api) {
	allLeaveBlur(api);
	var ecData = getECData(dispatcher);
	var dispatchers = findComponentHighDownDispatchers(ecData.componentMainType, ecData.componentIndex, ecData.componentHighDownName, api).dispatchers;
	if (dispatchers) each$4(dispatchers, function(dispatcher$1) {
		return leaveEmphasisWhenMouseOut(dispatcher$1, e$1);
	});
	else leaveEmphasisWhenMouseOut(dispatcher, e$1);
}
function toggleSelectionFromPayload(seriesModel, payload, api) {
	if (!isSelectChangePayload(payload)) return;
	var dataType = payload.dataType;
	var data = seriesModel.getData(dataType);
	var dataIndex = queryDataIndex(data, payload);
	if (!isArray(dataIndex)) dataIndex = [dataIndex];
	seriesModel[payload.type === TOGGLE_SELECT_ACTION_TYPE ? "toggleSelect" : payload.type === SELECT_ACTION_TYPE ? "select" : "unselect"](dataIndex, dataType);
}
function updateSeriesElementSelection(seriesModel) {
	var allData = seriesModel.getAllData();
	each$4(allData, function(_a$1) {
		var data = _a$1.data, type = _a$1.type;
		data.eachItemGraphicEl(function(el, idx) {
			seriesModel.isSelected(idx, type) ? enterSelect(el) : leaveSelect(el);
		});
	});
}
function getAllSelectedIndices(ecModel) {
	var ret = [];
	ecModel.eachSeries(function(seriesModel) {
		var allData = seriesModel.getAllData();
		each$4(allData, function(_a$1) {
			var data = _a$1.data, type = _a$1.type;
			var dataIndices = seriesModel.getSelectedDataIndices();
			if (dataIndices.length > 0) {
				var item = {
					dataIndex: dataIndices,
					seriesIndex: seriesModel.seriesIndex
				};
				if (type != null) item.dataType = type;
				ret.push(item);
			}
		});
	});
	return ret;
}
function enableHoverEmphasis(el, focus, blurScope) {
	setAsHighDownDispatcher(el, true);
	traverseUpdateState(el, setDefaultStateProxy);
	enableHoverFocus(el, focus, blurScope);
}
function disableHoverEmphasis(el) {
	setAsHighDownDispatcher(el, false);
}
function toggleHoverEmphasis(el, focus, blurScope, isDisabled) {
	isDisabled ? disableHoverEmphasis(el) : enableHoverEmphasis(el, focus, blurScope);
}
function enableHoverFocus(el, focus, blurScope) {
	var ecData = getECData(el);
	if (focus != null) {
		ecData.focus = focus;
		ecData.blurScope = blurScope;
	} else if (ecData.focus) ecData.focus = null;
}
var OTHER_STATES = [
	"emphasis",
	"blur",
	"select"
];
var defaultStyleGetterMap = {
	itemStyle: "getItemStyle",
	lineStyle: "getLineStyle",
	areaStyle: "getAreaStyle"
};
function setStatesStylesFromModel(el, itemModel, styleType, getter) {
	styleType = styleType || "itemStyle";
	for (var i = 0; i < OTHER_STATES.length; i++) {
		var stateName = OTHER_STATES[i];
		var model = itemModel.getModel([stateName, styleType]);
		var state = el.ensureState(stateName);
		state.style = getter ? getter(model) : model[defaultStyleGetterMap[styleType]]();
	}
}
function setAsHighDownDispatcher(el, asDispatcher) {
	var disable = asDispatcher === false;
	var extendedEl = el;
	if (el.highDownSilentOnTouch) extendedEl.__highDownSilentOnTouch = el.highDownSilentOnTouch;
	if (!disable || extendedEl.__highDownDispatcher) {
		extendedEl.__highByOuter = extendedEl.__highByOuter || 0;
		extendedEl.__highDownDispatcher = !disable;
	}
}
function isHighDownDispatcher(el) {
	return !!(el && el.__highDownDispatcher);
}
function getHighlightDigit(highlightKey) {
	var highlightDigit = _highlightKeyMap[highlightKey];
	if (highlightDigit == null && _highlightNextDigit <= 32) highlightDigit = _highlightKeyMap[highlightKey] = _highlightNextDigit++;
	return highlightDigit;
}
function isSelectChangePayload(payload) {
	var payloadType = payload.type;
	return payloadType === SELECT_ACTION_TYPE || payloadType === UNSELECT_ACTION_TYPE || payloadType === TOGGLE_SELECT_ACTION_TYPE;
}
function isHighDownPayload(payload) {
	var payloadType = payload.type;
	return payloadType === HIGHLIGHT_ACTION_TYPE || payloadType === DOWNPLAY_ACTION_TYPE;
}
function savePathStates(el) {
	var store = getSavedStates(el);
	store.normalFill = el.style.fill;
	store.normalStroke = el.style.stroke;
	var selectState = el.states.select || {};
	store.selectFill = selectState.style && selectState.style.fill || null;
	store.selectStroke = selectState.style && selectState.style.stroke || null;
}
var CMD = PathProxy_default.CMD;
var points = [
	[],
	[],
	[]
];
var mathSqrt$2 = Math.sqrt;
var mathAtan2 = Math.atan2;
function transformPath(path, m$1) {
	if (!m$1) return;
	var data = path.data;
	var len$1 = path.len();
	var cmd;
	var nPoint;
	var i;
	var j;
	var k;
	var p;
	var M = CMD.M;
	var C = CMD.C;
	var L = CMD.L;
	var R = CMD.R;
	var A = CMD.A;
	var Q = CMD.Q;
	for (i = 0, j = 0; i < len$1;) {
		cmd = data[i++];
		j = i;
		nPoint = 0;
		switch (cmd) {
			case M:
				nPoint = 1;
				break;
			case L:
				nPoint = 1;
				break;
			case C:
				nPoint = 3;
				break;
			case Q:
				nPoint = 2;
				break;
			case A:
				var x = m$1[4];
				var y = m$1[5];
				var sx = mathSqrt$2(m$1[0] * m$1[0] + m$1[1] * m$1[1]);
				var sy = mathSqrt$2(m$1[2] * m$1[2] + m$1[3] * m$1[3]);
				var angle = mathAtan2(-m$1[1] / sy, m$1[0] / sx);
				data[i] *= sx;
				data[i++] += x;
				data[i] *= sy;
				data[i++] += y;
				data[i++] *= sx;
				data[i++] *= sy;
				data[i++] += angle;
				data[i++] += angle;
				i += 2;
				j = i;
				break;
			case R:
				p[0] = data[i++];
				p[1] = data[i++];
				applyTransform$1(p, p, m$1);
				data[j++] = p[0];
				data[j++] = p[1];
				p[0] += data[i++];
				p[1] += data[i++];
				applyTransform$1(p, p, m$1);
				data[j++] = p[0];
				data[j++] = p[1];
		}
		for (k = 0; k < nPoint; k++) {
			var p_1 = points[k];
			p_1[0] = data[i++];
			p_1[1] = data[i++];
			applyTransform$1(p_1, p_1, m$1);
			data[j++] = p_1[0];
			data[j++] = p_1[1];
		}
	}
	path.increaseVersion();
}
var mathSqrt$1 = Math.sqrt;
var mathSin$1 = Math.sin;
var mathCos$1 = Math.cos;
var PI$3 = Math.PI;
function vMag(v) {
	return Math.sqrt(v[0] * v[0] + v[1] * v[1]);
}
function vRatio(u, v) {
	return (u[0] * v[0] + u[1] * v[1]) / (vMag(u) * vMag(v));
}
function vAngle(u, v) {
	return (u[0] * v[1] < u[1] * v[0] ? -1 : 1) * Math.acos(vRatio(u, v));
}
function processArc(x1, y1, x2, y2, fa, fs, rx, ry, psiDeg, cmd, path) {
	var psi = psiDeg * (PI$3 / 180);
	var xp = mathCos$1(psi) * (x1 - x2) / 2 + mathSin$1(psi) * (y1 - y2) / 2;
	var yp = -1 * mathSin$1(psi) * (x1 - x2) / 2 + mathCos$1(psi) * (y1 - y2) / 2;
	var lambda = xp * xp / (rx * rx) + yp * yp / (ry * ry);
	if (lambda > 1) {
		rx *= mathSqrt$1(lambda);
		ry *= mathSqrt$1(lambda);
	}
	var f = (fa === fs ? -1 : 1) * mathSqrt$1((rx * rx * (ry * ry) - rx * rx * (yp * yp) - ry * ry * (xp * xp)) / (rx * rx * (yp * yp) + ry * ry * (xp * xp))) || 0;
	var cxp = f * rx * yp / ry;
	var cyp = f * -ry * xp / rx;
	var cx = (x1 + x2) / 2 + mathCos$1(psi) * cxp - mathSin$1(psi) * cyp;
	var cy = (y1 + y2) / 2 + mathSin$1(psi) * cxp + mathCos$1(psi) * cyp;
	var theta = vAngle([1, 0], [(xp - cxp) / rx, (yp - cyp) / ry]);
	var u = [(xp - cxp) / rx, (yp - cyp) / ry];
	var v = [(-1 * xp - cxp) / rx, (-1 * yp - cyp) / ry];
	var dTheta = vAngle(u, v);
	if (vRatio(u, v) <= -1) dTheta = PI$3;
	if (vRatio(u, v) >= 1) dTheta = 0;
	if (dTheta < 0) {
		var n = Math.round(dTheta / PI$3 * 1e6) / 1e6;
		dTheta = PI$3 * 2 + n % 2 * PI$3;
	}
	path.addData(cmd, cx, cy, rx, ry, theta, dTheta, psi, fs);
}
var commandReg = /([mlvhzcqtsa])([^mlvhzcqtsa]*)/gi;
var numberReg = /-?([0-9]*\.)?[0-9]+([eE]-?[0-9]+)?/g;
function createPathProxyFromString(data) {
	var path = new PathProxy_default();
	if (!data) return path;
	var cpx = 0;
	var cpy = 0;
	var subpathX = cpx;
	var subpathY = cpy;
	var prevCmd;
	var CMD$3 = PathProxy_default.CMD;
	var cmdList = data.match(commandReg);
	if (!cmdList) return path;
	for (var l = 0; l < cmdList.length; l++) {
		var cmdText = cmdList[l];
		var cmdStr = cmdText.charAt(0);
		var cmd = void 0;
		var p = cmdText.match(numberReg) || [];
		var pLen = p.length;
		for (var i = 0; i < pLen; i++) p[i] = parseFloat(p[i]);
		var off = 0;
		while (off < pLen) {
			var ctlPtx = void 0;
			var ctlPty = void 0;
			var rx = void 0;
			var ry = void 0;
			var psi = void 0;
			var fa = void 0;
			var fs = void 0;
			var x1 = cpx;
			var y1 = cpy;
			var len$1 = void 0;
			var pathData = void 0;
			switch (cmdStr) {
				case "l":
					cpx += p[off++];
					cpy += p[off++];
					cmd = CMD$3.L;
					path.addData(cmd, cpx, cpy);
					break;
				case "L":
					cpx = p[off++];
					cpy = p[off++];
					cmd = CMD$3.L;
					path.addData(cmd, cpx, cpy);
					break;
				case "m":
					cpx += p[off++];
					cpy += p[off++];
					cmd = CMD$3.M;
					path.addData(cmd, cpx, cpy);
					subpathX = cpx;
					subpathY = cpy;
					cmdStr = "l";
					break;
				case "M":
					cpx = p[off++];
					cpy = p[off++];
					cmd = CMD$3.M;
					path.addData(cmd, cpx, cpy);
					subpathX = cpx;
					subpathY = cpy;
					cmdStr = "L";
					break;
				case "h":
					cpx += p[off++];
					cmd = CMD$3.L;
					path.addData(cmd, cpx, cpy);
					break;
				case "H":
					cpx = p[off++];
					cmd = CMD$3.L;
					path.addData(cmd, cpx, cpy);
					break;
				case "v":
					cpy += p[off++];
					cmd = CMD$3.L;
					path.addData(cmd, cpx, cpy);
					break;
				case "V":
					cpy = p[off++];
					cmd = CMD$3.L;
					path.addData(cmd, cpx, cpy);
					break;
				case "C":
					cmd = CMD$3.C;
					path.addData(cmd, p[off++], p[off++], p[off++], p[off++], p[off++], p[off++]);
					cpx = p[off - 2];
					cpy = p[off - 1];
					break;
				case "c":
					cmd = CMD$3.C;
					path.addData(cmd, p[off++] + cpx, p[off++] + cpy, p[off++] + cpx, p[off++] + cpy, p[off++] + cpx, p[off++] + cpy);
					cpx += p[off - 2];
					cpy += p[off - 1];
					break;
				case "S":
					ctlPtx = cpx;
					ctlPty = cpy;
					len$1 = path.len();
					pathData = path.data;
					if (prevCmd === CMD$3.C) {
						ctlPtx += cpx - pathData[len$1 - 4];
						ctlPty += cpy - pathData[len$1 - 3];
					}
					cmd = CMD$3.C;
					x1 = p[off++];
					y1 = p[off++];
					cpx = p[off++];
					cpy = p[off++];
					path.addData(cmd, ctlPtx, ctlPty, x1, y1, cpx, cpy);
					break;
				case "s":
					ctlPtx = cpx;
					ctlPty = cpy;
					len$1 = path.len();
					pathData = path.data;
					if (prevCmd === CMD$3.C) {
						ctlPtx += cpx - pathData[len$1 - 4];
						ctlPty += cpy - pathData[len$1 - 3];
					}
					cmd = CMD$3.C;
					x1 = cpx + p[off++];
					y1 = cpy + p[off++];
					cpx += p[off++];
					cpy += p[off++];
					path.addData(cmd, ctlPtx, ctlPty, x1, y1, cpx, cpy);
					break;
				case "Q":
					x1 = p[off++];
					y1 = p[off++];
					cpx = p[off++];
					cpy = p[off++];
					cmd = CMD$3.Q;
					path.addData(cmd, x1, y1, cpx, cpy);
					break;
				case "q":
					x1 = p[off++] + cpx;
					y1 = p[off++] + cpy;
					cpx += p[off++];
					cpy += p[off++];
					cmd = CMD$3.Q;
					path.addData(cmd, x1, y1, cpx, cpy);
					break;
				case "T":
					ctlPtx = cpx;
					ctlPty = cpy;
					len$1 = path.len();
					pathData = path.data;
					if (prevCmd === CMD$3.Q) {
						ctlPtx += cpx - pathData[len$1 - 4];
						ctlPty += cpy - pathData[len$1 - 3];
					}
					cpx = p[off++];
					cpy = p[off++];
					cmd = CMD$3.Q;
					path.addData(cmd, ctlPtx, ctlPty, cpx, cpy);
					break;
				case "t":
					ctlPtx = cpx;
					ctlPty = cpy;
					len$1 = path.len();
					pathData = path.data;
					if (prevCmd === CMD$3.Q) {
						ctlPtx += cpx - pathData[len$1 - 4];
						ctlPty += cpy - pathData[len$1 - 3];
					}
					cpx += p[off++];
					cpy += p[off++];
					cmd = CMD$3.Q;
					path.addData(cmd, ctlPtx, ctlPty, cpx, cpy);
					break;
				case "A":
					rx = p[off++];
					ry = p[off++];
					psi = p[off++];
					fa = p[off++];
					fs = p[off++];
					x1 = cpx, y1 = cpy;
					cpx = p[off++];
					cpy = p[off++];
					cmd = CMD$3.A;
					processArc(x1, y1, cpx, cpy, fa, fs, rx, ry, psi, cmd, path);
					break;
				case "a":
					rx = p[off++];
					ry = p[off++];
					psi = p[off++];
					fa = p[off++];
					fs = p[off++];
					x1 = cpx, y1 = cpy;
					cpx += p[off++];
					cpy += p[off++];
					cmd = CMD$3.A;
					processArc(x1, y1, cpx, cpy, fa, fs, rx, ry, psi, cmd, path);
					break;
			}
		}
		if (cmdStr === "z" || cmdStr === "Z") {
			cmd = CMD$3.Z;
			path.addData(cmd);
			cpx = subpathX;
			cpy = subpathY;
		}
		prevCmd = cmd;
	}
	path.toStatic();
	return path;
}
var SVGPath = function(_super) {
	__extends(SVGPath$1, _super);
	function SVGPath$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	SVGPath$1.prototype.applyTransform = function(m$1) {};
	return SVGPath$1;
}(Path_default);
function isPathProxy(path) {
	return path.setData != null;
}
function createPathOptions(str, opts) {
	var pathProxy = createPathProxyFromString(str);
	var innerOpts = extend({}, opts);
	innerOpts.buildPath = function(path) {
		if (isPathProxy(path)) {
			path.setData(pathProxy.data);
			var ctx = path.getContext();
			if (ctx) path.rebuildPath(ctx, 1);
		} else {
			var ctx = path;
			pathProxy.rebuildPath(ctx, 1);
		}
	};
	innerOpts.applyTransform = function(m$1) {
		transformPath(pathProxy, m$1);
		this.dirtyShape();
	};
	return innerOpts;
}
function createFromString(str, opts) {
	return new SVGPath(createPathOptions(str, opts));
}
function extendFromString(str, defaultOpts) {
	var innerOpts = createPathOptions(str, defaultOpts);
	var Sub = function(_super) {
		__extends(Sub$1, _super);
		function Sub$1(opts) {
			var _this = _super.call(this, opts) || this;
			_this.applyTransform = innerOpts.applyTransform;
			_this.buildPath = innerOpts.buildPath;
			return _this;
		}
		return Sub$1;
	}(SVGPath);
	return Sub;
}
function mergePath$1(pathEls, opts) {
	var pathList = [];
	var len$1 = pathEls.length;
	for (var i = 0; i < len$1; i++) {
		var pathEl = pathEls[i];
		pathList.push(pathEl.getUpdatedPathProxy(true));
	}
	var pathBundle = new Path_default(opts);
	pathBundle.createPathProxy();
	pathBundle.buildPath = function(path) {
		if (isPathProxy(path)) {
			path.appendPath(pathList);
			var ctx = path.getContext();
			if (ctx) path.rebuildPath(ctx, 1);
		}
	};
	return pathBundle;
}
var Group$2 = function(_super) {
	__extends(Group$3, _super);
	function Group$3(opts) {
		var _this = _super.call(this) || this;
		_this.isGroup = true;
		_this._children = [];
		_this.attr(opts);
		return _this;
	}
	Group$3.prototype.childrenRef = function() {
		return this._children;
	};
	Group$3.prototype.children = function() {
		return this._children.slice();
	};
	Group$3.prototype.childAt = function(idx) {
		return this._children[idx];
	};
	Group$3.prototype.childOfName = function(name) {
		var children = this._children;
		for (var i = 0; i < children.length; i++) if (children[i].name === name) return children[i];
	};
	Group$3.prototype.childCount = function() {
		return this._children.length;
	};
	Group$3.prototype.add = function(child) {
		if (child) {
			if (child !== this && child.parent !== this) {
				this._children.push(child);
				this._doAdd(child);
			}
		}
		return this;
	};
	Group$3.prototype.addBefore = function(child, nextSibling) {
		if (child && child !== this && child.parent !== this && nextSibling && nextSibling.parent === this) {
			var children = this._children;
			var idx = children.indexOf(nextSibling);
			if (idx >= 0) {
				children.splice(idx, 0, child);
				this._doAdd(child);
			}
		}
		return this;
	};
	Group$3.prototype.replace = function(oldChild, newChild) {
		var idx = indexOf(this._children, oldChild);
		if (idx >= 0) this.replaceAt(newChild, idx);
		return this;
	};
	Group$3.prototype.replaceAt = function(child, index) {
		var children = this._children;
		var old = children[index];
		if (child && child !== this && child.parent !== this && child !== old) {
			children[index] = child;
			old.parent = null;
			var zr = this.__zr;
			if (zr) old.removeSelfFromZr(zr);
			this._doAdd(child);
		}
		return this;
	};
	Group$3.prototype._doAdd = function(child) {
		if (child.parent) child.parent.remove(child);
		child.parent = this;
		var zr = this.__zr;
		if (zr && zr !== child.__zr) child.addSelfToZr(zr);
		zr && zr.refresh();
	};
	Group$3.prototype.remove = function(child) {
		var zr = this.__zr;
		var children = this._children;
		var idx = indexOf(children, child);
		if (idx < 0) return this;
		children.splice(idx, 1);
		child.parent = null;
		if (zr) child.removeSelfFromZr(zr);
		zr && zr.refresh();
		return this;
	};
	Group$3.prototype.removeAll = function() {
		var children = this._children;
		var zr = this.__zr;
		for (var i = 0; i < children.length; i++) {
			var child = children[i];
			if (zr) child.removeSelfFromZr(zr);
			child.parent = null;
		}
		children.length = 0;
		return this;
	};
	Group$3.prototype.eachChild = function(cb, context) {
		var children = this._children;
		for (var i = 0; i < children.length; i++) {
			var child = children[i];
			cb.call(context, child, i);
		}
		return this;
	};
	Group$3.prototype.traverse = function(cb, context) {
		for (var i = 0; i < this._children.length; i++) {
			var child = this._children[i];
			var stopped = cb.call(context, child);
			if (child.isGroup && !stopped) child.traverse(cb, context);
		}
		return this;
	};
	Group$3.prototype.addSelfToZr = function(zr) {
		_super.prototype.addSelfToZr.call(this, zr);
		for (var i = 0; i < this._children.length; i++) {
			var child = this._children[i];
			child.addSelfToZr(zr);
		}
	};
	Group$3.prototype.removeSelfFromZr = function(zr) {
		_super.prototype.removeSelfFromZr.call(this, zr);
		for (var i = 0; i < this._children.length; i++) {
			var child = this._children[i];
			child.removeSelfFromZr(zr);
		}
	};
	Group$3.prototype.getBoundingRect = function(includeChildren) {
		var tmpRect$2 = new BoundingRect_default(0, 0, 0, 0);
		var children = includeChildren || this._children;
		var tmpMat = [];
		var rect = null;
		for (var i = 0; i < children.length; i++) {
			var child = children[i];
			if (child.ignore || child.invisible) continue;
			var childRect = child.getBoundingRect();
			var transform = child.getLocalTransform(tmpMat);
			if (transform) {
				BoundingRect_default.applyTransform(tmpRect$2, childRect, transform);
				rect = rect || tmpRect$2.clone();
				rect.union(tmpRect$2);
			} else {
				rect = rect || childRect.clone();
				rect.union(childRect);
			}
		}
		return rect || tmpRect$2;
	};
	return Group$3;
}(Element_default);
Group$2.prototype.type = "group";
var Group_default = Group$2;
var CircleShape = function() {
	function CircleShape$1() {
		this.cx = 0;
		this.cy = 0;
		this.r = 0;
	}
	return CircleShape$1;
}();
var Circle = function(_super) {
	__extends(Circle$1, _super);
	function Circle$1(opts) {
		return _super.call(this, opts) || this;
	}
	Circle$1.prototype.getDefaultShape = function() {
		return new CircleShape();
	};
	Circle$1.prototype.buildPath = function(ctx, shape) {
		ctx.moveTo(shape.cx + shape.r, shape.cy);
		ctx.arc(shape.cx, shape.cy, shape.r, 0, Math.PI * 2);
	};
	return Circle$1;
}(Path_default);
Circle.prototype.type = "circle";
var Circle_default = Circle;
var EllipseShape = function() {
	function EllipseShape$1() {
		this.cx = 0;
		this.cy = 0;
		this.rx = 0;
		this.ry = 0;
	}
	return EllipseShape$1;
}();
var Ellipse = function(_super) {
	__extends(Ellipse$1, _super);
	function Ellipse$1(opts) {
		return _super.call(this, opts) || this;
	}
	Ellipse$1.prototype.getDefaultShape = function() {
		return new EllipseShape();
	};
	Ellipse$1.prototype.buildPath = function(ctx, shape) {
		var k = .5522848;
		var x = shape.cx;
		var y = shape.cy;
		var a = shape.rx;
		var b = shape.ry;
		var ox = a * k;
		var oy = b * k;
		ctx.moveTo(x - a, y);
		ctx.bezierCurveTo(x - a, y - oy, x - ox, y - b, x, y - b);
		ctx.bezierCurveTo(x + ox, y - b, x + a, y - oy, x + a, y);
		ctx.bezierCurveTo(x + a, y + oy, x + ox, y + b, x, y + b);
		ctx.bezierCurveTo(x - ox, y + b, x - a, y + oy, x - a, y);
		ctx.closePath();
	};
	return Ellipse$1;
}(Path_default);
Ellipse.prototype.type = "ellipse";
var Ellipse_default = Ellipse;
var PI$2 = Math.PI;
var PI2 = PI$2 * 2;
var mathSin = Math.sin;
var mathCos = Math.cos;
var mathACos = Math.acos;
var mathATan2 = Math.atan2;
var mathAbs = Math.abs;
var mathSqrt = Math.sqrt;
var mathMax$2 = Math.max;
var mathMin$2 = Math.min;
var e = 1e-4;
function intersect(x0, y0, x1, y1, x2, y2, x3, y3) {
	var dx10 = x1 - x0;
	var dy10 = y1 - y0;
	var dx32 = x3 - x2;
	var dy32 = y3 - y2;
	var t = dy32 * dx10 - dx32 * dy10;
	if (t * t < e) return;
	t = (dx32 * (y0 - y2) - dy32 * (x0 - x2)) / t;
	return [x0 + t * dx10, y0 + t * dy10];
}
function computeCornerTangents(x0, y0, x1, y1, radius, cr, clockwise) {
	var x01 = x0 - x1;
	var y01 = y0 - y1;
	var lo = (clockwise ? cr : -cr) / mathSqrt(x01 * x01 + y01 * y01);
	var ox = lo * y01;
	var oy = -lo * x01;
	var x11 = x0 + ox;
	var y11 = y0 + oy;
	var x10 = x1 + ox;
	var y10 = y1 + oy;
	var x00 = (x11 + x10) / 2;
	var y00 = (y11 + y10) / 2;
	var dx = x10 - x11;
	var dy = y10 - y11;
	var d2 = dx * dx + dy * dy;
	var r = radius - cr;
	var s = x11 * y10 - x10 * y11;
	var d = (dy < 0 ? -1 : 1) * mathSqrt(mathMax$2(0, r * r * d2 - s * s));
	var cx0 = (s * dy - dx * d) / d2;
	var cy0 = (-s * dx - dy * d) / d2;
	var cx1 = (s * dy + dx * d) / d2;
	var cy1 = (-s * dx + dy * d) / d2;
	var dx0 = cx0 - x00;
	var dy0 = cy0 - y00;
	var dx1 = cx1 - x00;
	var dy1 = cy1 - y00;
	if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) {
		cx0 = cx1;
		cy0 = cy1;
	}
	return {
		cx: cx0,
		cy: cy0,
		x0: -ox,
		y0: -oy,
		x1: cx0 * (radius / r - 1),
		y1: cy0 * (radius / r - 1)
	};
}
function normalizeCornerRadius(cr) {
	var arr;
	if (isArray(cr)) {
		var len$1 = cr.length;
		if (!len$1) return cr;
		if (len$1 === 1) arr = [
			cr[0],
			cr[0],
			0,
			0
		];
		else if (len$1 === 2) arr = [
			cr[0],
			cr[0],
			cr[1],
			cr[1]
		];
		else if (len$1 === 3) arr = cr.concat(cr[2]);
		else arr = cr;
	} else arr = [
		cr,
		cr,
		cr,
		cr
	];
	return arr;
}
function buildPath$1(ctx, shape) {
	var _a$1;
	var radius = mathMax$2(shape.r, 0);
	var innerRadius = mathMax$2(shape.r0 || 0, 0);
	var hasRadius = radius > 0;
	var hasInnerRadius = innerRadius > 0;
	if (!hasRadius && !hasInnerRadius) return;
	if (!hasRadius) {
		radius = innerRadius;
		innerRadius = 0;
	}
	if (innerRadius > radius) {
		var tmp = radius;
		radius = innerRadius;
		innerRadius = tmp;
	}
	var startAngle = shape.startAngle, endAngle = shape.endAngle;
	if (isNaN(startAngle) || isNaN(endAngle)) return;
	var cx = shape.cx, cy = shape.cy;
	var clockwise = !!shape.clockwise;
	var arc = mathAbs(endAngle - startAngle);
	var mod = arc > PI2 && arc % PI2;
	mod > e && (arc = mod);
	if (!(radius > e)) ctx.moveTo(cx, cy);
	else if (arc > PI2 - e) {
		ctx.moveTo(cx + radius * mathCos(startAngle), cy + radius * mathSin(startAngle));
		ctx.arc(cx, cy, radius, startAngle, endAngle, !clockwise);
		if (innerRadius > e) {
			ctx.moveTo(cx + innerRadius * mathCos(endAngle), cy + innerRadius * mathSin(endAngle));
			ctx.arc(cx, cy, innerRadius, endAngle, startAngle, clockwise);
		}
	} else {
		var icrStart = void 0;
		var icrEnd = void 0;
		var ocrStart = void 0;
		var ocrEnd = void 0;
		var ocrs = void 0;
		var ocre = void 0;
		var icrs = void 0;
		var icre = void 0;
		var ocrMax = void 0;
		var icrMax = void 0;
		var limitedOcrMax = void 0;
		var limitedIcrMax = void 0;
		var xre = void 0;
		var yre = void 0;
		var xirs = void 0;
		var yirs = void 0;
		var xrs = radius * mathCos(startAngle);
		var yrs = radius * mathSin(startAngle);
		var xire = innerRadius * mathCos(endAngle);
		var yire = innerRadius * mathSin(endAngle);
		var hasArc = arc > e;
		if (hasArc) {
			var cornerRadius = shape.cornerRadius;
			if (cornerRadius) _a$1 = normalizeCornerRadius(cornerRadius), icrStart = _a$1[0], icrEnd = _a$1[1], ocrStart = _a$1[2], ocrEnd = _a$1[3];
			var halfRd = mathAbs(radius - innerRadius) / 2;
			ocrs = mathMin$2(halfRd, ocrStart);
			ocre = mathMin$2(halfRd, ocrEnd);
			icrs = mathMin$2(halfRd, icrStart);
			icre = mathMin$2(halfRd, icrEnd);
			limitedOcrMax = ocrMax = mathMax$2(ocrs, ocre);
			limitedIcrMax = icrMax = mathMax$2(icrs, icre);
			if (ocrMax > e || icrMax > e) {
				xre = radius * mathCos(endAngle);
				yre = radius * mathSin(endAngle);
				xirs = innerRadius * mathCos(startAngle);
				yirs = innerRadius * mathSin(startAngle);
				if (arc < PI$2) {
					var it_1 = intersect(xrs, yrs, xirs, yirs, xre, yre, xire, yire);
					if (it_1) {
						var x0 = xrs - it_1[0];
						var y0 = yrs - it_1[1];
						var x1 = xre - it_1[0];
						var y1 = yre - it_1[1];
						var a = 1 / mathSin(mathACos((x0 * x1 + y0 * y1) / (mathSqrt(x0 * x0 + y0 * y0) * mathSqrt(x1 * x1 + y1 * y1))) / 2);
						var b = mathSqrt(it_1[0] * it_1[0] + it_1[1] * it_1[1]);
						limitedOcrMax = mathMin$2(ocrMax, (radius - b) / (a + 1));
						limitedIcrMax = mathMin$2(icrMax, (innerRadius - b) / (a - 1));
					}
				}
			}
		}
		if (!hasArc) ctx.moveTo(cx + xrs, cy + yrs);
		else if (limitedOcrMax > e) {
			var crStart = mathMin$2(ocrStart, limitedOcrMax);
			var crEnd = mathMin$2(ocrEnd, limitedOcrMax);
			var ct0 = computeCornerTangents(xirs, yirs, xrs, yrs, radius, crStart, clockwise);
			var ct1 = computeCornerTangents(xre, yre, xire, yire, radius, crEnd, clockwise);
			ctx.moveTo(cx + ct0.cx + ct0.x0, cy + ct0.cy + ct0.y0);
			if (limitedOcrMax < ocrMax && crStart === crEnd) ctx.arc(cx + ct0.cx, cy + ct0.cy, limitedOcrMax, mathATan2(ct0.y0, ct0.x0), mathATan2(ct1.y0, ct1.x0), !clockwise);
			else {
				crStart > 0 && ctx.arc(cx + ct0.cx, cy + ct0.cy, crStart, mathATan2(ct0.y0, ct0.x0), mathATan2(ct0.y1, ct0.x1), !clockwise);
				ctx.arc(cx, cy, radius, mathATan2(ct0.cy + ct0.y1, ct0.cx + ct0.x1), mathATan2(ct1.cy + ct1.y1, ct1.cx + ct1.x1), !clockwise);
				crEnd > 0 && ctx.arc(cx + ct1.cx, cy + ct1.cy, crEnd, mathATan2(ct1.y1, ct1.x1), mathATan2(ct1.y0, ct1.x0), !clockwise);
			}
		} else {
			ctx.moveTo(cx + xrs, cy + yrs);
			ctx.arc(cx, cy, radius, startAngle, endAngle, !clockwise);
		}
		if (!(innerRadius > e) || !hasArc) ctx.lineTo(cx + xire, cy + yire);
		else if (limitedIcrMax > e) {
			var crStart = mathMin$2(icrStart, limitedIcrMax);
			var crEnd = mathMin$2(icrEnd, limitedIcrMax);
			var ct0 = computeCornerTangents(xire, yire, xre, yre, innerRadius, -crEnd, clockwise);
			var ct1 = computeCornerTangents(xrs, yrs, xirs, yirs, innerRadius, -crStart, clockwise);
			ctx.lineTo(cx + ct0.cx + ct0.x0, cy + ct0.cy + ct0.y0);
			if (limitedIcrMax < icrMax && crStart === crEnd) ctx.arc(cx + ct0.cx, cy + ct0.cy, limitedIcrMax, mathATan2(ct0.y0, ct0.x0), mathATan2(ct1.y0, ct1.x0), !clockwise);
			else {
				crEnd > 0 && ctx.arc(cx + ct0.cx, cy + ct0.cy, crEnd, mathATan2(ct0.y0, ct0.x0), mathATan2(ct0.y1, ct0.x1), !clockwise);
				ctx.arc(cx, cy, innerRadius, mathATan2(ct0.cy + ct0.y1, ct0.cx + ct0.x1), mathATan2(ct1.cy + ct1.y1, ct1.cx + ct1.x1), clockwise);
				crStart > 0 && ctx.arc(cx + ct1.cx, cy + ct1.cy, crStart, mathATan2(ct1.y1, ct1.x1), mathATan2(ct1.y0, ct1.x0), !clockwise);
			}
		} else {
			ctx.lineTo(cx + xire, cy + yire);
			ctx.arc(cx, cy, innerRadius, endAngle, startAngle, clockwise);
		}
	}
	ctx.closePath();
}
var SectorShape = function() {
	function SectorShape$1() {
		this.cx = 0;
		this.cy = 0;
		this.r0 = 0;
		this.r = 0;
		this.startAngle = 0;
		this.endAngle = Math.PI * 2;
		this.clockwise = true;
		this.cornerRadius = 0;
	}
	return SectorShape$1;
}();
var Sector = function(_super) {
	__extends(Sector$1, _super);
	function Sector$1(opts) {
		return _super.call(this, opts) || this;
	}
	Sector$1.prototype.getDefaultShape = function() {
		return new SectorShape();
	};
	Sector$1.prototype.buildPath = function(ctx, shape) {
		buildPath$1(ctx, shape);
	};
	Sector$1.prototype.isZeroArea = function() {
		return this.shape.startAngle === this.shape.endAngle || this.shape.r === this.shape.r0;
	};
	return Sector$1;
}(Path_default);
Sector.prototype.type = "sector";
var Sector_default = Sector;
var RingShape = function() {
	function RingShape$1() {
		this.cx = 0;
		this.cy = 0;
		this.r = 0;
		this.r0 = 0;
	}
	return RingShape$1;
}();
var Ring = function(_super) {
	__extends(Ring$1, _super);
	function Ring$1(opts) {
		return _super.call(this, opts) || this;
	}
	Ring$1.prototype.getDefaultShape = function() {
		return new RingShape();
	};
	Ring$1.prototype.buildPath = function(ctx, shape) {
		var x = shape.cx;
		var y = shape.cy;
		var PI2$6 = Math.PI * 2;
		ctx.moveTo(x + shape.r, y);
		ctx.arc(x, y, shape.r, 0, PI2$6, false);
		ctx.moveTo(x + shape.r0, y);
		ctx.arc(x, y, shape.r0, 0, PI2$6, true);
	};
	return Ring$1;
}(Path_default);
Ring.prototype.type = "ring";
var Ring_default = Ring;
function smoothBezier(points$1, smooth, isLoop, constraint) {
	var cps = [];
	var v = [];
	var v1 = [];
	var v2 = [];
	var prevPoint;
	var nextPoint;
	var min$2;
	var max$2;
	if (constraint) {
		min$2 = [Infinity, Infinity];
		max$2 = [-Infinity, -Infinity];
		for (var i = 0, len$1 = points$1.length; i < len$1; i++) {
			min$1(min$2, min$2, points$1[i]);
			max$1(max$2, max$2, points$1[i]);
		}
		min$1(min$2, min$2, constraint[0]);
		max$1(max$2, max$2, constraint[1]);
	}
	for (var i = 0, len$1 = points$1.length; i < len$1; i++) {
		var point = points$1[i];
		if (isLoop) {
			prevPoint = points$1[i ? i - 1 : len$1 - 1];
			nextPoint = points$1[(i + 1) % len$1];
		} else if (i === 0 || i === len$1 - 1) {
			cps.push(clone$1(points$1[i]));
			continue;
		} else {
			prevPoint = points$1[i - 1];
			nextPoint = points$1[i + 1];
		}
		sub(v, nextPoint, prevPoint);
		scale$1(v, v, smooth);
		var d0 = distance(point, prevPoint);
		var d1 = distance(point, nextPoint);
		var sum = d0 + d1;
		if (sum !== 0) {
			d0 /= sum;
			d1 /= sum;
		}
		scale$1(v1, v, -d0);
		scale$1(v2, v, d1);
		var cp0 = add([], point, v1);
		var cp1 = add([], point, v2);
		if (constraint) {
			max$1(cp0, cp0, min$2);
			min$1(cp0, cp0, max$2);
			max$1(cp1, cp1, min$2);
			min$1(cp1, cp1, max$2);
		}
		cps.push(cp0);
		cps.push(cp1);
	}
	if (isLoop) cps.push(cps.shift());
	return cps;
}
function buildPath(ctx, shape, closePath) {
	var smooth = shape.smooth;
	var points$1 = shape.points;
	if (points$1 && points$1.length >= 2) {
		if (smooth) {
			var controlPoints = smoothBezier(points$1, smooth, closePath, shape.smoothConstraint);
			ctx.moveTo(points$1[0][0], points$1[0][1]);
			var len$1 = points$1.length;
			for (var i = 0; i < (closePath ? len$1 : len$1 - 1); i++) {
				var cp1 = controlPoints[i * 2];
				var cp2 = controlPoints[i * 2 + 1];
				var p = points$1[(i + 1) % len$1];
				ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], p[0], p[1]);
			}
		} else {
			ctx.moveTo(points$1[0][0], points$1[0][1]);
			for (var i = 1, l = points$1.length; i < l; i++) ctx.lineTo(points$1[i][0], points$1[i][1]);
		}
		closePath && ctx.closePath();
	}
}
var PolygonShape = function() {
	function PolygonShape$1() {
		this.points = null;
		this.smooth = 0;
		this.smoothConstraint = null;
	}
	return PolygonShape$1;
}();
var Polygon = function(_super) {
	__extends(Polygon$1, _super);
	function Polygon$1(opts) {
		return _super.call(this, opts) || this;
	}
	Polygon$1.prototype.getDefaultShape = function() {
		return new PolygonShape();
	};
	Polygon$1.prototype.buildPath = function(ctx, shape) {
		buildPath(ctx, shape, true);
	};
	return Polygon$1;
}(Path_default);
Polygon.prototype.type = "polygon";
var Polygon_default = Polygon;
var PolylineShape = function() {
	function PolylineShape$1() {
		this.points = null;
		this.percent = 1;
		this.smooth = 0;
		this.smoothConstraint = null;
	}
	return PolylineShape$1;
}();
var Polyline = function(_super) {
	__extends(Polyline$1, _super);
	function Polyline$1(opts) {
		return _super.call(this, opts) || this;
	}
	Polyline$1.prototype.getDefaultStyle = function() {
		return {
			stroke: "#000",
			fill: null
		};
	};
	Polyline$1.prototype.getDefaultShape = function() {
		return new PolylineShape();
	};
	Polyline$1.prototype.buildPath = function(ctx, shape) {
		buildPath(ctx, shape, false);
	};
	return Polyline$1;
}(Path_default);
Polyline.prototype.type = "polyline";
var Polyline_default = Polyline;
var subPixelOptimizeOutputShape = {};
var LineShape = function() {
	function LineShape$1() {
		this.x1 = 0;
		this.y1 = 0;
		this.x2 = 0;
		this.y2 = 0;
		this.percent = 1;
	}
	return LineShape$1;
}();
var Line = function(_super) {
	__extends(Line$1, _super);
	function Line$1(opts) {
		return _super.call(this, opts) || this;
	}
	Line$1.prototype.getDefaultStyle = function() {
		return {
			stroke: "#000",
			fill: null
		};
	};
	Line$1.prototype.getDefaultShape = function() {
		return new LineShape();
	};
	Line$1.prototype.buildPath = function(ctx, shape) {
		var x1;
		var y1;
		var x2;
		var y2;
		if (this.subPixelOptimize) {
			var optimizedShape = subPixelOptimizeLine$1(subPixelOptimizeOutputShape, shape, this.style);
			x1 = optimizedShape.x1;
			y1 = optimizedShape.y1;
			x2 = optimizedShape.x2;
			y2 = optimizedShape.y2;
		} else {
			x1 = shape.x1;
			y1 = shape.y1;
			x2 = shape.x2;
			y2 = shape.y2;
		}
		var percent = shape.percent;
		if (percent === 0) return;
		ctx.moveTo(x1, y1);
		if (percent < 1) {
			x2 = x1 * (1 - percent) + x2 * percent;
			y2 = y1 * (1 - percent) + y2 * percent;
		}
		ctx.lineTo(x2, y2);
	};
	Line$1.prototype.pointAt = function(p) {
		var shape = this.shape;
		return [shape.x1 * (1 - p) + shape.x2 * p, shape.y1 * (1 - p) + shape.y2 * p];
	};
	return Line$1;
}(Path_default);
Line.prototype.type = "line";
var Line_default = Line;
var out = [];
var BezierCurveShape = function() {
	function BezierCurveShape$1() {
		this.x1 = 0;
		this.y1 = 0;
		this.x2 = 0;
		this.y2 = 0;
		this.cpx1 = 0;
		this.cpy1 = 0;
		this.percent = 1;
	}
	return BezierCurveShape$1;
}();
function someVectorAt(shape, t, isTangent) {
	var cpx2 = shape.cpx2;
	var cpy2 = shape.cpy2;
	if (cpx2 != null || cpy2 != null) return [(isTangent ? cubicDerivativeAt : cubicAt)(shape.x1, shape.cpx1, shape.cpx2, shape.x2, t), (isTangent ? cubicDerivativeAt : cubicAt)(shape.y1, shape.cpy1, shape.cpy2, shape.y2, t)];
	else return [(isTangent ? quadraticDerivativeAt : quadraticAt)(shape.x1, shape.cpx1, shape.x2, t), (isTangent ? quadraticDerivativeAt : quadraticAt)(shape.y1, shape.cpy1, shape.y2, t)];
}
var BezierCurve = function(_super) {
	__extends(BezierCurve$1, _super);
	function BezierCurve$1(opts) {
		return _super.call(this, opts) || this;
	}
	BezierCurve$1.prototype.getDefaultStyle = function() {
		return {
			stroke: "#000",
			fill: null
		};
	};
	BezierCurve$1.prototype.getDefaultShape = function() {
		return new BezierCurveShape();
	};
	BezierCurve$1.prototype.buildPath = function(ctx, shape) {
		var x1 = shape.x1;
		var y1 = shape.y1;
		var x2 = shape.x2;
		var y2 = shape.y2;
		var cpx1 = shape.cpx1;
		var cpy1 = shape.cpy1;
		var cpx2 = shape.cpx2;
		var cpy2 = shape.cpy2;
		var percent = shape.percent;
		if (percent === 0) return;
		ctx.moveTo(x1, y1);
		if (cpx2 == null || cpy2 == null) {
			if (percent < 1) {
				quadraticSubdivide(x1, cpx1, x2, percent, out);
				cpx1 = out[1];
				x2 = out[2];
				quadraticSubdivide(y1, cpy1, y2, percent, out);
				cpy1 = out[1];
				y2 = out[2];
			}
			ctx.quadraticCurveTo(cpx1, cpy1, x2, y2);
		} else {
			if (percent < 1) {
				cubicSubdivide(x1, cpx1, cpx2, x2, percent, out);
				cpx1 = out[1];
				cpx2 = out[2];
				x2 = out[3];
				cubicSubdivide(y1, cpy1, cpy2, y2, percent, out);
				cpy1 = out[1];
				cpy2 = out[2];
				y2 = out[3];
			}
			ctx.bezierCurveTo(cpx1, cpy1, cpx2, cpy2, x2, y2);
		}
	};
	BezierCurve$1.prototype.pointAt = function(t) {
		return someVectorAt(this.shape, t, false);
	};
	BezierCurve$1.prototype.tangentAt = function(t) {
		var p = someVectorAt(this.shape, t, true);
		return normalize$1(p, p);
	};
	return BezierCurve$1;
}(Path_default);
BezierCurve.prototype.type = "bezier-curve";
var BezierCurve_default = BezierCurve;
var ArcShape = function() {
	function ArcShape$1() {
		this.cx = 0;
		this.cy = 0;
		this.r = 0;
		this.startAngle = 0;
		this.endAngle = Math.PI * 2;
		this.clockwise = true;
	}
	return ArcShape$1;
}();
var Arc = function(_super) {
	__extends(Arc$1, _super);
	function Arc$1(opts) {
		return _super.call(this, opts) || this;
	}
	Arc$1.prototype.getDefaultStyle = function() {
		return {
			stroke: "#000",
			fill: null
		};
	};
	Arc$1.prototype.getDefaultShape = function() {
		return new ArcShape();
	};
	Arc$1.prototype.buildPath = function(ctx, shape) {
		var x = shape.cx;
		var y = shape.cy;
		var r = Math.max(shape.r, 0);
		var startAngle = shape.startAngle;
		var endAngle = shape.endAngle;
		var clockwise = shape.clockwise;
		var unitX = Math.cos(startAngle);
		var unitY = Math.sin(startAngle);
		ctx.moveTo(unitX * r + x, unitY * r + y);
		ctx.arc(x, y, r, startAngle, endAngle, !clockwise);
	};
	return Arc$1;
}(Path_default);
Arc.prototype.type = "arc";
var Arc_default = Arc;
var CompoundPath = function(_super) {
	__extends(CompoundPath$1, _super);
	function CompoundPath$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = "compound";
		return _this;
	}
	CompoundPath$1.prototype._updatePathDirty = function() {
		var paths = this.shape.paths;
		var dirtyPath = this.shapeChanged();
		for (var i = 0; i < paths.length; i++) dirtyPath = dirtyPath || paths[i].shapeChanged();
		if (dirtyPath) this.dirtyShape();
	};
	CompoundPath$1.prototype.beforeBrush = function() {
		this._updatePathDirty();
		var paths = this.shape.paths || [];
		var scale$3 = this.getGlobalScale();
		for (var i = 0; i < paths.length; i++) {
			if (!paths[i].path) paths[i].createPathProxy();
			paths[i].path.setScale(scale$3[0], scale$3[1], paths[i].segmentIgnoreThreshold);
		}
	};
	CompoundPath$1.prototype.buildPath = function(ctx, shape) {
		var paths = shape.paths || [];
		for (var i = 0; i < paths.length; i++) paths[i].buildPath(ctx, paths[i].shape, true);
	};
	CompoundPath$1.prototype.afterBrush = function() {
		var paths = this.shape.paths || [];
		for (var i = 0; i < paths.length; i++) paths[i].pathUpdated();
	};
	CompoundPath$1.prototype.getBoundingRect = function() {
		this._updatePathDirty.call(this);
		return Path_default.prototype.getBoundingRect.call(this);
	};
	return CompoundPath$1;
}(Path_default);
var CompoundPath_default = CompoundPath;
var Gradient = function() {
	function Gradient$1(colorStops) {
		this.colorStops = colorStops || [];
	}
	Gradient$1.prototype.addColorStop = function(offset, color) {
		this.colorStops.push({
			offset,
			color
		});
	};
	return Gradient$1;
}();
var Gradient_default = Gradient;
var LinearGradient = function(_super) {
	__extends(LinearGradient$1, _super);
	function LinearGradient$1(x, y, x2, y2, colorStops, globalCoord) {
		var _this = _super.call(this, colorStops) || this;
		_this.x = x == null ? 0 : x;
		_this.y = y == null ? 0 : y;
		_this.x2 = x2 == null ? 1 : x2;
		_this.y2 = y2 == null ? 0 : y2;
		_this.type = "linear";
		_this.global = globalCoord || false;
		return _this;
	}
	return LinearGradient$1;
}(Gradient_default);
var LinearGradient_default = LinearGradient;
var RadialGradient = function(_super) {
	__extends(RadialGradient$1, _super);
	function RadialGradient$1(x, y, r, colorStops, globalCoord) {
		var _this = _super.call(this, colorStops) || this;
		_this.x = x == null ? .5 : x;
		_this.y = y == null ? .5 : y;
		_this.r = r == null ? .5 : r;
		_this.type = "radial";
		_this.global = globalCoord || false;
		return _this;
	}
	return RadialGradient$1;
}(Gradient_default);
var RadialGradient_default = RadialGradient;
var extent = [0, 0];
var extent2 = [0, 0];
var minTv = new Point_default();
var maxTv = new Point_default();
var OrientedBoundingRect = function() {
	function OrientedBoundingRect$1(rect, transform) {
		this._corners = [];
		this._axes = [];
		this._origin = [0, 0];
		for (var i = 0; i < 4; i++) this._corners[i] = new Point_default();
		for (var i = 0; i < 2; i++) this._axes[i] = new Point_default();
		if (rect) this.fromBoundingRect(rect, transform);
	}
	OrientedBoundingRect$1.prototype.fromBoundingRect = function(rect, transform) {
		var corners = this._corners;
		var axes = this._axes;
		var x = rect.x;
		var y = rect.y;
		var x2 = x + rect.width;
		var y2 = y + rect.height;
		corners[0].set(x, y);
		corners[1].set(x2, y);
		corners[2].set(x2, y2);
		corners[3].set(x, y2);
		if (transform) for (var i = 0; i < 4; i++) corners[i].transform(transform);
		Point_default.sub(axes[0], corners[1], corners[0]);
		Point_default.sub(axes[1], corners[3], corners[0]);
		axes[0].normalize();
		axes[1].normalize();
		for (var i = 0; i < 2; i++) this._origin[i] = axes[i].dot(corners[0]);
	};
	OrientedBoundingRect$1.prototype.intersect = function(other, mtv) {
		var overlapped = true;
		var noMtv = !mtv;
		minTv.set(Infinity, Infinity);
		maxTv.set(0, 0);
		if (!this._intersectCheckOneSide(this, other, minTv, maxTv, noMtv, 1)) {
			overlapped = false;
			if (noMtv) return overlapped;
		}
		if (!this._intersectCheckOneSide(other, this, minTv, maxTv, noMtv, -1)) {
			overlapped = false;
			if (noMtv) return overlapped;
		}
		if (!noMtv) Point_default.copy(mtv, overlapped ? minTv : maxTv);
		return overlapped;
	};
	OrientedBoundingRect$1.prototype._intersectCheckOneSide = function(self$1, other, minTv$2, maxTv$2, noMtv, inverse) {
		var overlapped = true;
		for (var i = 0; i < 2; i++) {
			var axis = this._axes[i];
			this._getProjMinMaxOnAxis(i, self$1._corners, extent);
			this._getProjMinMaxOnAxis(i, other._corners, extent2);
			if (extent[1] < extent2[0] || extent[0] > extent2[1]) {
				overlapped = false;
				if (noMtv) return overlapped;
				var dist0 = Math.abs(extent2[0] - extent[1]);
				var dist1 = Math.abs(extent[0] - extent2[1]);
				if (Math.min(dist0, dist1) > maxTv$2.len()) if (dist0 < dist1) Point_default.scale(maxTv$2, axis, -dist0 * inverse);
				else Point_default.scale(maxTv$2, axis, dist1 * inverse);
			} else if (minTv$2) {
				var dist0 = Math.abs(extent2[0] - extent[1]);
				var dist1 = Math.abs(extent[0] - extent2[1]);
				if (Math.min(dist0, dist1) < minTv$2.len()) if (dist0 < dist1) Point_default.scale(minTv$2, axis, dist0 * inverse);
				else Point_default.scale(minTv$2, axis, -dist1 * inverse);
			}
		}
		return overlapped;
	};
	OrientedBoundingRect$1.prototype._getProjMinMaxOnAxis = function(dim, corners, out$1) {
		var axis = this._axes[dim];
		var origin = this._origin;
		var proj = corners[0].dot(axis) + origin[dim];
		var min$2 = proj;
		var max$2 = proj;
		for (var i = 1; i < corners.length; i++) {
			var proj_1 = corners[i].dot(axis) + origin[dim];
			min$2 = Math.min(proj_1, min$2);
			max$2 = Math.max(proj_1, max$2);
		}
		out$1[0] = min$2;
		out$1[1] = max$2;
	};
	return OrientedBoundingRect$1;
}();
var OrientedBoundingRect_default = OrientedBoundingRect;
var m = [];
var IncrementalDisplayable = function(_super) {
	__extends(IncrementalDisplayable$1, _super);
	function IncrementalDisplayable$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.notClear = true;
		_this.incremental = true;
		_this._displayables = [];
		_this._temporaryDisplayables = [];
		_this._cursor = 0;
		return _this;
	}
	IncrementalDisplayable$1.prototype.traverse = function(cb, context) {
		cb.call(context, this);
	};
	IncrementalDisplayable$1.prototype.useStyle = function() {
		this.style = {};
	};
	IncrementalDisplayable$1.prototype.getCursor = function() {
		return this._cursor;
	};
	IncrementalDisplayable$1.prototype.innerAfterBrush = function() {
		this._cursor = this._displayables.length;
	};
	IncrementalDisplayable$1.prototype.clearDisplaybles = function() {
		this._displayables = [];
		this._temporaryDisplayables = [];
		this._cursor = 0;
		this.markRedraw();
		this.notClear = false;
	};
	IncrementalDisplayable$1.prototype.clearTemporalDisplayables = function() {
		this._temporaryDisplayables = [];
	};
	IncrementalDisplayable$1.prototype.addDisplayable = function(displayable, notPersistent) {
		if (notPersistent) this._temporaryDisplayables.push(displayable);
		else this._displayables.push(displayable);
		this.markRedraw();
	};
	IncrementalDisplayable$1.prototype.addDisplayables = function(displayables, notPersistent) {
		notPersistent = notPersistent || false;
		for (var i = 0; i < displayables.length; i++) this.addDisplayable(displayables[i], notPersistent);
	};
	IncrementalDisplayable$1.prototype.getDisplayables = function() {
		return this._displayables;
	};
	IncrementalDisplayable$1.prototype.getTemporalDisplayables = function() {
		return this._temporaryDisplayables;
	};
	IncrementalDisplayable$1.prototype.eachPendingDisplayable = function(cb) {
		for (var i = this._cursor; i < this._displayables.length; i++) cb && cb(this._displayables[i]);
		for (var i = 0; i < this._temporaryDisplayables.length; i++) cb && cb(this._temporaryDisplayables[i]);
	};
	IncrementalDisplayable$1.prototype.update = function() {
		this.updateTransform();
		for (var i = this._cursor; i < this._displayables.length; i++) {
			var displayable = this._displayables[i];
			displayable.parent = this;
			displayable.update();
			displayable.parent = null;
		}
		for (var i = 0; i < this._temporaryDisplayables.length; i++) {
			var displayable = this._temporaryDisplayables[i];
			displayable.parent = this;
			displayable.update();
			displayable.parent = null;
		}
	};
	IncrementalDisplayable$1.prototype.getBoundingRect = function() {
		if (!this._rect) {
			var rect = new BoundingRect_default(Infinity, Infinity, -Infinity, -Infinity);
			for (var i = 0; i < this._displayables.length; i++) {
				var displayable = this._displayables[i];
				var childRect = displayable.getBoundingRect().clone();
				if (displayable.needLocalTransform()) childRect.applyTransform(displayable.getLocalTransform(m));
				rect.union(childRect);
			}
			this._rect = rect;
		}
		return this._rect;
	};
	IncrementalDisplayable$1.prototype.contain = function(x, y) {
		var localPos = this.transformCoordToLocal(x, y);
		var rect = this.getBoundingRect();
		if (rect.contain(localPos[0], localPos[1])) for (var i = 0; i < this._displayables.length; i++) {
			var displayable = this._displayables[i];
			if (displayable.contain(x, y)) return true;
		}
		return false;
	};
	return IncrementalDisplayable$1;
}(Displayable_default);
var IncrementalDisplayable_default = IncrementalDisplayable;
var transitionStore = makeInner();
function getAnimationConfig(animationType, animatableModel, dataIndex, extraOpts, extraDelayParams) {
	var animationPayload;
	if (animatableModel && animatableModel.ecModel) {
		var updatePayload = animatableModel.ecModel.getUpdatePayload();
		animationPayload = updatePayload && updatePayload.animation;
	}
	var animationEnabled = animatableModel && animatableModel.isAnimationEnabled();
	var isUpdate = animationType === "update";
	if (animationEnabled) {
		var duration = void 0;
		var easing = void 0;
		var delay = void 0;
		if (extraOpts) {
			duration = retrieve2(extraOpts.duration, 200);
			easing = retrieve2(extraOpts.easing, "cubicOut");
			delay = 0;
		} else {
			duration = animatableModel.getShallow(isUpdate ? "animationDurationUpdate" : "animationDuration");
			easing = animatableModel.getShallow(isUpdate ? "animationEasingUpdate" : "animationEasing");
			delay = animatableModel.getShallow(isUpdate ? "animationDelayUpdate" : "animationDelay");
		}
		if (animationPayload) {
			animationPayload.duration != null && (duration = animationPayload.duration);
			animationPayload.easing != null && (easing = animationPayload.easing);
			animationPayload.delay != null && (delay = animationPayload.delay);
		}
		if (isFunction(delay)) delay = delay(dataIndex, extraDelayParams);
		if (isFunction(duration)) duration = duration(dataIndex);
		var config = {
			duration: duration || 0,
			delay,
			easing
		};
		return config;
	} else return null;
}
function animateOrSetProps(animationType, el, props, animatableModel, dataIndex, cb, during) {
	var isFrom = false;
	var removeOpt;
	if (isFunction(dataIndex)) {
		during = cb;
		cb = dataIndex;
		dataIndex = null;
	} else if (isObject$2(dataIndex)) {
		cb = dataIndex.cb;
		during = dataIndex.during;
		isFrom = dataIndex.isFrom;
		removeOpt = dataIndex.removeOpt;
		dataIndex = dataIndex.dataIndex;
	}
	var isRemove = animationType === "leave";
	if (!isRemove) el.stopAnimation("leave");
	var animationConfig = getAnimationConfig(animationType, animatableModel, dataIndex, isRemove ? removeOpt || {} : null, animatableModel && animatableModel.getAnimationDelayParams ? animatableModel.getAnimationDelayParams(el, dataIndex) : null);
	if (animationConfig && animationConfig.duration > 0) {
		var duration = animationConfig.duration;
		var animationDelay = animationConfig.delay;
		var animationEasing = animationConfig.easing;
		var animateConfig = {
			duration,
			delay: animationDelay || 0,
			easing: animationEasing,
			done: cb,
			force: !!cb || !!during,
			setToFinal: !isRemove,
			scope: animationType,
			during
		};
		isFrom ? el.animateFrom(props, animateConfig) : el.animateTo(props, animateConfig);
	} else {
		el.stopAnimation();
		!isFrom && el.attr(props);
		during && during(1);
		cb && cb();
	}
}
/**

* Update graphic element properties with or without animation according to the

* configuration in series.

*

* Caution: this method will stop previous animation.

* So do not use this method to one element twice before

* animation starts, unless you know what you are doing.

* @example

*     graphic.updateProps(el, {

*         position: [100, 100]

*     }, seriesModel, dataIndex, function () { console.log('Animation done!'); });

*     // Or

*     graphic.updateProps(el, {

*         position: [100, 100]

*     }, seriesModel, function () { console.log('Animation done!'); });

*/
function updateProps$1(el, props, animatableModel, dataIndex, cb, during) {
	animateOrSetProps("update", el, props, animatableModel, dataIndex, cb, during);
}
function initProps(el, props, animatableModel, dataIndex, cb, during) {
	animateOrSetProps("enter", el, props, animatableModel, dataIndex, cb, during);
}
function isElementRemoved(el) {
	if (!el.__zr) return true;
	for (var i = 0; i < el.animators.length; i++) {
		var animator = el.animators[i];
		if (animator.scope === "leave") return true;
	}
	return false;
}
function removeElement(el, props, animatableModel, dataIndex, cb, during) {
	if (isElementRemoved(el)) return;
	animateOrSetProps("leave", el, props, animatableModel, dataIndex, cb, during);
}
function fadeOutDisplayable(el, animatableModel, dataIndex, done) {
	el.removeTextContent();
	el.removeTextGuideLine();
	removeElement(el, { style: { opacity: 0 } }, animatableModel, dataIndex, done);
}
function removeElementWithFadeOut(el, animatableModel, dataIndex) {
	function doRemove() {
		el.parent && el.parent.remove(el);
	}
	if (!el.isGroup) fadeOutDisplayable(el, animatableModel, dataIndex, doRemove);
	else el.traverse(function(disp) {
		if (!disp.isGroup) fadeOutDisplayable(disp, animatableModel, dataIndex, doRemove);
	});
}
function saveOldStyle(el) {
	transitionStore(el).oldStyle = el.style;
}
var graphic_exports = {};
__export(graphic_exports, {
	Arc: () => Arc_default,
	BezierCurve: () => BezierCurve_default,
	BoundingRect: () => BoundingRect_default,
	Circle: () => Circle_default,
	CompoundPath: () => CompoundPath_default,
	Ellipse: () => Ellipse_default,
	Group: () => Group_default,
	Image: () => Image_default,
	IncrementalDisplayable: () => IncrementalDisplayable_default,
	Line: () => Line_default,
	LinearGradient: () => LinearGradient_default,
	OrientedBoundingRect: () => OrientedBoundingRect_default,
	Path: () => Path_default,
	Point: () => Point_default,
	Polygon: () => Polygon_default,
	Polyline: () => Polyline_default,
	RadialGradient: () => RadialGradient_default,
	Rect: () => Rect_default,
	Ring: () => Ring_default,
	Sector: () => Sector_default,
	Text: () => Text_default,
	applyTransform: () => applyTransform,
	clipPointsByRect: () => clipPointsByRect,
	clipRectByRect: () => clipRectByRect,
	createIcon: () => createIcon,
	extendPath: () => extendPath,
	extendShape: () => extendShape,
	getShapeClass: () => getShapeClass,
	getTransform: () => getTransform,
	groupTransition: () => groupTransition,
	initProps: () => initProps,
	isElementRemoved: () => isElementRemoved,
	lineLineIntersect: () => lineLineIntersect,
	linePolygonIntersect: () => linePolygonIntersect,
	makeImage: () => makeImage,
	makePath: () => makePath,
	mergePath: () => mergePath,
	registerShape: () => registerShape,
	removeElement: () => removeElement,
	removeElementWithFadeOut: () => removeElementWithFadeOut,
	resizePath: () => resizePath,
	setTooltipConfig: () => setTooltipConfig,
	subPixelOptimize: () => subPixelOptimize,
	subPixelOptimizeLine: () => subPixelOptimizeLine,
	subPixelOptimizeRect: () => subPixelOptimizeRect,
	transformDirection: () => transformDirection,
	traverseElements: () => traverseElements,
	updateProps: () => updateProps$1
});
var mathMax$1 = Math.max;
var mathMin$1 = Math.min;
var _customShapeMap = {};
function extendShape(opts) {
	return Path_default.extend(opts);
}
var extendPathFromString = extendFromString;
function extendPath(pathData, opts) {
	return extendPathFromString(pathData, opts);
}
function registerShape(name, ShapeClass) {
	_customShapeMap[name] = ShapeClass;
}
function getShapeClass(name) {
	if (_customShapeMap.hasOwnProperty(name)) return _customShapeMap[name];
}
function makePath(pathData, opts, rect, layout$2) {
	var path = createFromString(pathData, opts);
	if (rect) {
		if (layout$2 === "center") rect = centerGraphic(rect, path.getBoundingRect());
		resizePath(path, rect);
	}
	return path;
}
function makeImage(imageUrl, rect, layout$2) {
	var zrImg = new Image_default({
		style: {
			image: imageUrl,
			x: rect.x,
			y: rect.y,
			width: rect.width,
			height: rect.height
		},
		onload: function(img) {
			if (layout$2 === "center") {
				var boundingRect = {
					width: img.width,
					height: img.height
				};
				zrImg.setStyle(centerGraphic(rect, boundingRect));
			}
		}
	});
	return zrImg;
}
/**

* Get position of centered element in bounding box.

*

* @param  rect         element local bounding box

* @param  boundingRect constraint bounding box

* @return element position containing x, y, width, and height

*/
function centerGraphic(rect, boundingRect) {
	var aspect = boundingRect.width / boundingRect.height;
	var width = rect.height * aspect;
	var height;
	if (width <= rect.width) height = rect.height;
	else {
		width = rect.width;
		height = width / aspect;
	}
	var cx = rect.x + rect.width / 2;
	var cy = rect.y + rect.height / 2;
	return {
		x: cx - width / 2,
		y: cy - height / 2,
		width,
		height
	};
}
var mergePath = mergePath$1;
function resizePath(path, rect) {
	if (!path.applyTransform) return;
	var pathRect = path.getBoundingRect();
	var m$1 = pathRect.calculateTransform(rect);
	path.applyTransform(m$1);
}
function subPixelOptimizeLine(shape, lineWidth) {
	subPixelOptimizeLine$1(shape, shape, { lineWidth });
	return shape;
}
function subPixelOptimizeRect(param) {
	subPixelOptimizeRect$1(param.shape, param.shape, param.style);
	return param;
}
var subPixelOptimize = subPixelOptimize$1;
function getTransform(target, ancestor) {
	var mat = identity([]);
	while (target && target !== ancestor) {
		mul(mat, target.getLocalTransform(), mat);
		target = target.parent;
	}
	return mat;
}
function applyTransform(target, transform, invert$1) {
	if (transform && !isArrayLike(transform)) transform = Transformable_default.getLocalTransform(transform);
	if (invert$1) transform = invert([], transform);
	return applyTransform$1([], target, transform);
}
function transformDirection(direction, transform, invert$1) {
	var hBase = transform[4] === 0 || transform[5] === 0 || transform[0] === 0 ? 1 : Math.abs(2 * transform[4] / transform[0]);
	var vBase = transform[4] === 0 || transform[5] === 0 || transform[2] === 0 ? 1 : Math.abs(2 * transform[4] / transform[2]);
	var vertex = [direction === "left" ? -hBase : direction === "right" ? hBase : 0, direction === "top" ? -vBase : direction === "bottom" ? vBase : 0];
	vertex = applyTransform(vertex, transform, invert$1);
	return Math.abs(vertex[0]) > Math.abs(vertex[1]) ? vertex[0] > 0 ? "right" : "left" : vertex[1] > 0 ? "bottom" : "top";
}
function isNotGroup(el) {
	return !el.isGroup;
}
function isPath(el) {
	return el.shape != null;
}
function groupTransition(g1, g2, animatableModel) {
	if (!g1 || !g2) return;
	function getElMap(g) {
		var elMap = {};
		g.traverse(function(el) {
			if (isNotGroup(el) && el.anid) elMap[el.anid] = el;
		});
		return elMap;
	}
	function getAnimatableProps(el) {
		var obj = {
			x: el.x,
			y: el.y,
			rotation: el.rotation
		};
		if (isPath(el)) obj.shape = extend({}, el.shape);
		return obj;
	}
	var elMap1 = getElMap(g1);
	g2.traverse(function(el) {
		if (isNotGroup(el) && el.anid) {
			var oldEl = elMap1[el.anid];
			if (oldEl) {
				var newProp = getAnimatableProps(el);
				el.attr(getAnimatableProps(oldEl));
				updateProps$1(el, newProp, animatableModel, getECData(el).dataIndex);
			}
		}
	});
}
function clipPointsByRect(points$1, rect) {
	return map$1(points$1, function(point) {
		var x = point[0];
		x = mathMax$1(x, rect.x);
		x = mathMin$1(x, rect.x + rect.width);
		var y = point[1];
		y = mathMax$1(y, rect.y);
		y = mathMin$1(y, rect.y + rect.height);
		return [x, y];
	});
}
function clipRectByRect(targetRect, rect) {
	var x = mathMax$1(targetRect.x, rect.x);
	var x2 = mathMin$1(targetRect.x + targetRect.width, rect.x + rect.width);
	var y = mathMax$1(targetRect.y, rect.y);
	var y2 = mathMin$1(targetRect.y + targetRect.height, rect.y + rect.height);
	if (x2 >= x && y2 >= y) return {
		x,
		y,
		width: x2 - x,
		height: y2 - y
	};
}
function createIcon(iconStr, opt, rect) {
	var innerOpts = extend({ rectHover: true }, opt);
	var style = innerOpts.style = { strokeNoScale: true };
	rect = rect || {
		x: -1,
		y: -1,
		width: 2,
		height: 2
	};
	if (iconStr) return iconStr.indexOf("image://") === 0 ? (style.image = iconStr.slice(8), defaults(style, rect), new Image_default(innerOpts)) : makePath(iconStr.replace("path://", ""), innerOpts, rect, "center");
}
function linePolygonIntersect(a1x, a1y, a2x, a2y, points$1) {
	for (var i = 0, p2 = points$1[points$1.length - 1]; i < points$1.length; i++) {
		var p = points$1[i];
		if (lineLineIntersect(a1x, a1y, a2x, a2y, p[0], p[1], p2[0], p2[1])) return true;
		p2 = p;
	}
}
function lineLineIntersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y) {
	var mx = a2x - a1x;
	var my = a2y - a1y;
	var nx = b2x - b1x;
	var ny = b2y - b1y;
	var nmCrossProduct = crossProduct2d(nx, ny, mx, my);
	if (nearZero(nmCrossProduct)) return false;
	var b1a1x = a1x - b1x;
	var b1a1y = a1y - b1y;
	var q = crossProduct2d(b1a1x, b1a1y, mx, my) / nmCrossProduct;
	if (q < 0 || q > 1) return false;
	var p = crossProduct2d(b1a1x, b1a1y, nx, ny) / nmCrossProduct;
	if (p < 0 || p > 1) return false;
	return true;
}
/**

* Cross product of 2-dimension vector.

*/
function crossProduct2d(x1, y1, x2, y2) {
	return x1 * y2 - x2 * y1;
}
function nearZero(val) {
	return val <= 1e-6 && val >= -1e-6;
}
function setTooltipConfig(opt) {
	var itemTooltipOption = opt.itemTooltipOption;
	var componentModel = opt.componentModel;
	var itemName = opt.itemName;
	var itemTooltipOptionObj = isString(itemTooltipOption) ? { formatter: itemTooltipOption } : itemTooltipOption;
	var mainType = componentModel.mainType;
	var componentIndex = componentModel.componentIndex;
	var formatterParams = {
		componentType: mainType,
		name: itemName,
		$vars: ["name"]
	};
	formatterParams[mainType + "Index"] = componentIndex;
	var formatterParamsExtra = opt.formatterParamsExtra;
	if (formatterParamsExtra) each$4(keys(formatterParamsExtra), function(key) {
		if (!hasOwn(formatterParams, key)) {
			formatterParams[key] = formatterParamsExtra[key];
			formatterParams.$vars.push(key);
		}
	});
	var ecData = getECData(opt.el);
	ecData.componentMainType = mainType;
	ecData.componentIndex = componentIndex;
	ecData.tooltipConfig = {
		name: itemName,
		option: defaults({
			content: itemName,
			encodeHTMLContent: true,
			formatterParams
		}, itemTooltipOptionObj)
	};
}
function traverseElement(el, cb) {
	var stopped;
	if (el.isGroup) stopped = cb(el);
	if (!stopped) el.traverse(cb);
}
function traverseElements(els, cb) {
	if (els) if (isArray(els)) for (var i = 0; i < els.length; i++) traverseElement(els[i], cb);
	else traverseElement(els, cb);
}
registerShape("circle", Circle_default);
registerShape("ellipse", Ellipse_default);
registerShape("sector", Sector_default);
registerShape("ring", Ring_default);
registerShape("polygon", Polygon_default);
registerShape("polyline", Polyline_default);
registerShape("rect", Rect_default);
registerShape("line", Line_default);
registerShape("bezierCurve", BezierCurve_default);
registerShape("arc", Arc_default);
var EMPTY_OBJ = {};
function setLabelText(label, labelTexts) {
	for (var i = 0; i < SPECIAL_STATES.length; i++) {
		var stateName = SPECIAL_STATES[i];
		var text = labelTexts[stateName];
		var state = label.ensureState(stateName);
		state.style = state.style || {};
		state.style.text = text;
	}
	var oldStates = label.currentStates.slice();
	label.clearStates(true);
	label.setStyle({ text: labelTexts.normal });
	label.useStates(oldStates, true);
}
function getLabelText(opt, stateModels, interpolatedValue) {
	var labelFetcher = opt.labelFetcher;
	var labelDataIndex = opt.labelDataIndex;
	var labelDimIndex = opt.labelDimIndex;
	var normalModel = stateModels.normal;
	var baseText;
	if (labelFetcher) baseText = labelFetcher.getFormattedLabel(labelDataIndex, "normal", null, labelDimIndex, normalModel && normalModel.get("formatter"), interpolatedValue != null ? { interpolatedValue } : null);
	if (baseText == null) baseText = isFunction(opt.defaultText) ? opt.defaultText(labelDataIndex, opt, interpolatedValue) : opt.defaultText;
	var statesText = { normal: baseText };
	for (var i = 0; i < SPECIAL_STATES.length; i++) {
		var stateName = SPECIAL_STATES[i];
		var stateModel = stateModels[stateName];
		statesText[stateName] = retrieve2(labelFetcher ? labelFetcher.getFormattedLabel(labelDataIndex, stateName, null, labelDimIndex, stateModel && stateModel.get("formatter")) : null, baseText);
	}
	return statesText;
}
function setLabelStyle(targetEl, labelStatesModels, opt, stateSpecified) {
	opt = opt || EMPTY_OBJ;
	var isSetOnText = targetEl instanceof Text_default;
	var needsCreateText = false;
	for (var i = 0; i < DISPLAY_STATES.length; i++) {
		var stateModel = labelStatesModels[DISPLAY_STATES[i]];
		if (stateModel && stateModel.getShallow("show")) {
			needsCreateText = true;
			break;
		}
	}
	var textContent = isSetOnText ? targetEl : targetEl.getTextContent();
	if (needsCreateText) {
		if (!isSetOnText) {
			if (!textContent) {
				textContent = new Text_default();
				targetEl.setTextContent(textContent);
			}
			if (targetEl.stateProxy) textContent.stateProxy = targetEl.stateProxy;
		}
		var labelStatesTexts = getLabelText(opt, labelStatesModels);
		var normalModel = labelStatesModels.normal;
		var showNormal = !!normalModel.getShallow("show");
		var normalStyle = createTextStyle(normalModel, stateSpecified && stateSpecified.normal, opt, false, !isSetOnText);
		normalStyle.text = labelStatesTexts.normal;
		if (!isSetOnText) targetEl.setTextConfig(createTextConfig(normalModel, opt, false));
		for (var i = 0; i < SPECIAL_STATES.length; i++) {
			var stateName = SPECIAL_STATES[i];
			var stateModel = labelStatesModels[stateName];
			if (stateModel) {
				var stateObj = textContent.ensureState(stateName);
				var stateShow = !!retrieve2(stateModel.getShallow("show"), showNormal);
				if (stateShow !== showNormal) stateObj.ignore = !stateShow;
				stateObj.style = createTextStyle(stateModel, stateSpecified && stateSpecified[stateName], opt, true, !isSetOnText);
				stateObj.style.text = labelStatesTexts[stateName];
				if (!isSetOnText) {
					var targetElEmphasisState = targetEl.ensureState(stateName);
					targetElEmphasisState.textConfig = createTextConfig(stateModel, opt, true);
				}
			}
		}
		textContent.silent = !!normalModel.getShallow("silent");
		if (textContent.style.x != null) normalStyle.x = textContent.style.x;
		if (textContent.style.y != null) normalStyle.y = textContent.style.y;
		textContent.ignore = !showNormal;
		textContent.useStyle(normalStyle);
		textContent.dirty();
		if (opt.enableTextSetter) labelInner(textContent).setLabelText = function(interpolatedValue) {
			var labelStatesTexts$1 = getLabelText(opt, labelStatesModels, interpolatedValue);
			setLabelText(textContent, labelStatesTexts$1);
		};
	} else if (textContent) textContent.ignore = true;
	targetEl.dirty();
}
function getLabelStatesModels(itemModel, labelName) {
	labelName = labelName || "label";
	var statesModels = { normal: itemModel.getModel(labelName) };
	for (var i = 0; i < SPECIAL_STATES.length; i++) {
		var stateName = SPECIAL_STATES[i];
		statesModels[stateName] = itemModel.getModel([stateName, labelName]);
	}
	return statesModels;
}
function createTextStyle(textStyleModel, specifiedTextStyle, opt, isNotNormal, isAttached) {
	var textStyle = {};
	setTextStyleCommon(textStyle, textStyleModel, opt, isNotNormal, isAttached);
	specifiedTextStyle && extend(textStyle, specifiedTextStyle);
	return textStyle;
}
function createTextConfig(textStyleModel, opt, isNotNormal) {
	opt = opt || {};
	var textConfig = {};
	var labelPosition;
	var labelRotate = textStyleModel.getShallow("rotate");
	var labelDistance = retrieve2(textStyleModel.getShallow("distance"), isNotNormal ? null : 5);
	var labelOffset = textStyleModel.getShallow("offset");
	labelPosition = textStyleModel.getShallow("position") || (isNotNormal ? null : "inside");
	labelPosition === "outside" && (labelPosition = opt.defaultOutsidePosition || "top");
	if (labelPosition != null) textConfig.position = labelPosition;
	if (labelOffset != null) textConfig.offset = labelOffset;
	if (labelRotate != null) {
		labelRotate *= Math.PI / 180;
		textConfig.rotation = labelRotate;
	}
	if (labelDistance != null) textConfig.distance = labelDistance;
	textConfig.outsideFill = textStyleModel.get("color") === "inherit" ? opt.inheritColor || null : "auto";
	return textConfig;
}
/**

* The uniform entry of set text style, that is, retrieve style definitions

* from `model` and set to `textStyle` object.

*

* Never in merge mode, but in overwrite mode, that is, all of the text style

* properties will be set. (Consider the states of normal and emphasis and

* default value can be adopted, merge would make the logic too complicated

* to manage.)

*/
function setTextStyleCommon(textStyle, textStyleModel, opt, isNotNormal, isAttached) {
	opt = opt || EMPTY_OBJ;
	var ecModel = textStyleModel.ecModel;
	var globalTextStyle = ecModel && ecModel.option.textStyle;
	var richItemNames = getRichItemNames(textStyleModel);
	var richResult;
	if (richItemNames) {
		richResult = {};
		for (var name_1 in richItemNames) if (richItemNames.hasOwnProperty(name_1)) {
			var richTextStyle = textStyleModel.getModel(["rich", name_1]);
			setTokenTextStyle(richResult[name_1] = {}, richTextStyle, globalTextStyle, opt, isNotNormal, isAttached, false, true);
		}
	}
	if (richResult) textStyle.rich = richResult;
	var overflow = textStyleModel.get("overflow");
	if (overflow) textStyle.overflow = overflow;
	var margin = textStyleModel.get("minMargin");
	if (margin != null) textStyle.margin = margin;
	setTokenTextStyle(textStyle, textStyleModel, globalTextStyle, opt, isNotNormal, isAttached, true, false);
}
function getRichItemNames(textStyleModel) {
	var richItemNameMap;
	while (textStyleModel && textStyleModel !== textStyleModel.ecModel) {
		var rich = (textStyleModel.option || EMPTY_OBJ).rich;
		if (rich) {
			richItemNameMap = richItemNameMap || {};
			var richKeys = keys(rich);
			for (var i = 0; i < richKeys.length; i++) {
				var richKey = richKeys[i];
				richItemNameMap[richKey] = 1;
			}
		}
		textStyleModel = textStyleModel.parentModel;
	}
	return richItemNameMap;
}
var TEXT_PROPS_WITH_GLOBAL = [
	"fontStyle",
	"fontWeight",
	"fontSize",
	"fontFamily",
	"textShadowColor",
	"textShadowBlur",
	"textShadowOffsetX",
	"textShadowOffsetY"
];
var TEXT_PROPS_SELF = [
	"align",
	"lineHeight",
	"width",
	"height",
	"tag",
	"verticalAlign",
	"ellipsis"
];
var TEXT_PROPS_BOX = [
	"padding",
	"borderWidth",
	"borderRadius",
	"borderDashOffset",
	"backgroundColor",
	"borderColor",
	"shadowColor",
	"shadowBlur",
	"shadowOffsetX",
	"shadowOffsetY"
];
function setTokenTextStyle(textStyle, textStyleModel, globalTextStyle, opt, isNotNormal, isAttached, isBlock, inRich) {
	globalTextStyle = !isNotNormal && globalTextStyle || EMPTY_OBJ;
	var inheritColor = opt && opt.inheritColor;
	var fillColor = textStyleModel.getShallow("color");
	var strokeColor = textStyleModel.getShallow("textBorderColor");
	var opacity = retrieve2(textStyleModel.getShallow("opacity"), globalTextStyle.opacity);
	if (fillColor === "inherit" || fillColor === "auto") if (inheritColor) fillColor = inheritColor;
	else fillColor = null;
	if (strokeColor === "inherit" || strokeColor === "auto") if (inheritColor) strokeColor = inheritColor;
	else strokeColor = null;
	if (!isAttached) {
		fillColor = fillColor || globalTextStyle.color;
		strokeColor = strokeColor || globalTextStyle.textBorderColor;
	}
	if (fillColor != null) textStyle.fill = fillColor;
	if (strokeColor != null) textStyle.stroke = strokeColor;
	var textBorderWidth = retrieve2(textStyleModel.getShallow("textBorderWidth"), globalTextStyle.textBorderWidth);
	if (textBorderWidth != null) textStyle.lineWidth = textBorderWidth;
	var textBorderType = retrieve2(textStyleModel.getShallow("textBorderType"), globalTextStyle.textBorderType);
	if (textBorderType != null) textStyle.lineDash = textBorderType;
	var textBorderDashOffset = retrieve2(textStyleModel.getShallow("textBorderDashOffset"), globalTextStyle.textBorderDashOffset);
	if (textBorderDashOffset != null) textStyle.lineDashOffset = textBorderDashOffset;
	if (!isNotNormal && opacity == null && !inRich) opacity = opt && opt.defaultOpacity;
	if (opacity != null) textStyle.opacity = opacity;
	if (!isNotNormal && !isAttached) {
		if (textStyle.fill == null && opt.inheritColor) textStyle.fill = opt.inheritColor;
	}
	for (var i = 0; i < TEXT_PROPS_WITH_GLOBAL.length; i++) {
		var key = TEXT_PROPS_WITH_GLOBAL[i];
		var val = retrieve2(textStyleModel.getShallow(key), globalTextStyle[key]);
		if (val != null) textStyle[key] = val;
	}
	for (var i = 0; i < TEXT_PROPS_SELF.length; i++) {
		var key = TEXT_PROPS_SELF[i];
		var val = textStyleModel.getShallow(key);
		if (val != null) textStyle[key] = val;
	}
	if (textStyle.verticalAlign == null) {
		var baseline = textStyleModel.getShallow("baseline");
		if (baseline != null) textStyle.verticalAlign = baseline;
	}
	if (!isBlock || !opt.disableBox) {
		for (var i = 0; i < TEXT_PROPS_BOX.length; i++) {
			var key = TEXT_PROPS_BOX[i];
			var val = textStyleModel.getShallow(key);
			if (val != null) textStyle[key] = val;
		}
		var borderType = textStyleModel.getShallow("borderType");
		if (borderType != null) textStyle.borderDash = borderType;
		if ((textStyle.backgroundColor === "auto" || textStyle.backgroundColor === "inherit") && inheritColor) textStyle.backgroundColor = inheritColor;
		if ((textStyle.borderColor === "auto" || textStyle.borderColor === "inherit") && inheritColor) textStyle.borderColor = inheritColor;
	}
}
function getFont(opt, ecModel) {
	var gTextStyleModel = ecModel && ecModel.getModel("textStyle");
	return trim([
		opt.fontStyle || gTextStyleModel && gTextStyleModel.getShallow("fontStyle") || "",
		opt.fontWeight || gTextStyleModel && gTextStyleModel.getShallow("fontWeight") || "",
		(opt.fontSize || gTextStyleModel && gTextStyleModel.getShallow("fontSize") || 12) + "px",
		opt.fontFamily || gTextStyleModel && gTextStyleModel.getShallow("fontFamily") || "sans-serif"
	].join(" "));
}
var labelInner = makeInner();
function setLabelValueAnimation(label, labelStatesModels, value, getDefaultText) {
	if (!label) return;
	var obj = labelInner(label);
	obj.prevValue = obj.value;
	obj.value = value;
	var normalLabelModel = labelStatesModels.normal;
	obj.valueAnimation = normalLabelModel.get("valueAnimation");
	if (obj.valueAnimation) {
		obj.precision = normalLabelModel.get("precision");
		obj.defaultInterpolatedText = getDefaultText;
		obj.statesModels = labelStatesModels;
	}
}
var PATH_COLOR = ["textStyle", "color"];
var textStyleParams = [
	"fontStyle",
	"fontWeight",
	"fontSize",
	"fontFamily",
	"padding",
	"lineHeight",
	"rich",
	"width",
	"height",
	"overflow"
];
var tmpText = new Text_default();
var TextStyleMixin = function() {
	function TextStyleMixin$1() {}
	/**
	
	* Get color property or get color from option.textStyle.color
	
	*/
	TextStyleMixin$1.prototype.getTextColor = function(isEmphasis) {
		var ecModel = this.ecModel;
		return this.getShallow("color") || (!isEmphasis && ecModel ? ecModel.get(PATH_COLOR) : null);
	};
	/**
	
	* Create font string from fontStyle, fontWeight, fontSize, fontFamily
	
	* @return {string}
	
	*/
	TextStyleMixin$1.prototype.getFont = function() {
		return getFont({
			fontStyle: this.getShallow("fontStyle"),
			fontWeight: this.getShallow("fontWeight"),
			fontSize: this.getShallow("fontSize"),
			fontFamily: this.getShallow("fontFamily")
		}, this.ecModel);
	};
	TextStyleMixin$1.prototype.getTextRect = function(text) {
		var style = {
			text,
			verticalAlign: this.getShallow("verticalAlign") || this.getShallow("baseline")
		};
		for (var i = 0; i < textStyleParams.length; i++) style[textStyleParams[i]] = this.getShallow(textStyleParams[i]);
		tmpText.useStyle(style);
		tmpText.update();
		return tmpText.getBoundingRect();
	};
	return TextStyleMixin$1;
}();
var textStyle_default = TextStyleMixin;
var LINE_STYLE_KEY_MAP = [
	["lineWidth", "width"],
	["stroke", "color"],
	["opacity"],
	["shadowBlur"],
	["shadowOffsetX"],
	["shadowOffsetY"],
	["shadowColor"],
	["lineDash", "type"],
	["lineDashOffset", "dashOffset"],
	["lineCap", "cap"],
	["lineJoin", "join"],
	["miterLimit"]
];
var getLineStyle = makeStyleMapper(LINE_STYLE_KEY_MAP);
var LineStyleMixin = function() {
	function LineStyleMixin$1() {}
	LineStyleMixin$1.prototype.getLineStyle = function(excludes) {
		return getLineStyle(this, excludes);
	};
	return LineStyleMixin$1;
}();
var ITEM_STYLE_KEY_MAP = [
	["fill", "color"],
	["stroke", "borderColor"],
	["lineWidth", "borderWidth"],
	["opacity"],
	["shadowBlur"],
	["shadowOffsetX"],
	["shadowOffsetY"],
	["shadowColor"],
	["lineDash", "borderType"],
	["lineDashOffset", "borderDashOffset"],
	["lineCap", "borderCap"],
	["lineJoin", "borderJoin"],
	["miterLimit", "borderMiterLimit"]
];
var getItemStyle = makeStyleMapper(ITEM_STYLE_KEY_MAP);
var ItemStyleMixin = function() {
	function ItemStyleMixin$1() {}
	ItemStyleMixin$1.prototype.getItemStyle = function(excludes, includes) {
		return getItemStyle(this, excludes, includes);
	};
	return ItemStyleMixin$1;
}();
var Model = function() {
	function Model$1(option, parentModel, ecModel) {
		this.parentModel = parentModel;
		this.ecModel = ecModel;
		this.option = option;
	}
	Model$1.prototype.init = function(option, parentModel, ecModel) {
		var rest = [];
		for (var _i = 3; _i < arguments.length; _i++) rest[_i - 3] = arguments[_i];
	};
	/**
	
	* Merge the input option to me.
	
	*/
	Model$1.prototype.mergeOption = function(option, ecModel) {
		merge(this.option, option, true);
	};
	Model$1.prototype.get = function(path, ignoreParent) {
		if (path == null) return this.option;
		return this._doGet(this.parsePath(path), !ignoreParent && this.parentModel);
	};
	Model$1.prototype.getShallow = function(key, ignoreParent) {
		var option = this.option;
		var val = option == null ? option : option[key];
		if (val == null && !ignoreParent) {
			var parentModel = this.parentModel;
			if (parentModel) val = parentModel.getShallow(key);
		}
		return val;
	};
	Model$1.prototype.getModel = function(path, parentModel) {
		var hasPath = path != null;
		var pathFinal = hasPath ? this.parsePath(path) : null;
		var obj = hasPath ? this._doGet(pathFinal) : this.option;
		parentModel = parentModel || this.parentModel && this.parentModel.getModel(this.resolveParentPath(pathFinal));
		return new Model$1(obj, parentModel, this.ecModel);
	};
	/**
	
	* If model has option
	
	*/
	Model$1.prototype.isEmpty = function() {
		return this.option == null;
	};
	Model$1.prototype.restoreData = function() {};
	Model$1.prototype.clone = function() {
		var Ctor = this.constructor;
		return new Ctor(clone$2(this.option));
	};
	Model$1.prototype.parsePath = function(path) {
		if (typeof path === "string") return path.split(".");
		return path;
	};
	Model$1.prototype.resolveParentPath = function(path) {
		return path;
	};
	Model$1.prototype.isAnimationEnabled = function() {
		if (!env_default.node && this.option) {
			if (this.option.animation != null) return !!this.option.animation;
			else if (this.parentModel) return this.parentModel.isAnimationEnabled();
		}
	};
	Model$1.prototype._doGet = function(pathArr, parentModel) {
		var obj = this.option;
		if (!pathArr) return obj;
		for (var i = 0; i < pathArr.length; i++) {
			if (!pathArr[i]) continue;
			obj = obj && typeof obj === "object" ? obj[pathArr[i]] : null;
			if (obj == null) break;
		}
		if (obj == null && parentModel) obj = parentModel._doGet(this.resolveParentPath(pathArr), parentModel.parentModel);
		return obj;
	};
	return Model$1;
}();
enableClassExtend(Model);
enableClassCheck(Model);
mixin(Model, LineStyleMixin);
mixin(Model, ItemStyleMixin);
mixin(Model, AreaStyleMixin);
mixin(Model, textStyle_default);
var Model_default = Model;
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
function dataIndexMapValueLength(valNumOrArrLengthMoreThan2) {
	return valNumOrArrLengthMoreThan2 == null ? 0 : valNumOrArrLengthMoreThan2.length || 1;
}
function defaultKeyGetter(item) {
	return item;
}
var DataDiffer = function() {
	/**
	
	* @param context Can be visited by this.context in callback.
	
	*/
	function DataDiffer$1(oldArr, newArr, oldKeyGetter, newKeyGetter, context, diffMode) {
		this._old = oldArr;
		this._new = newArr;
		this._oldKeyGetter = oldKeyGetter || defaultKeyGetter;
		this._newKeyGetter = newKeyGetter || defaultKeyGetter;
		this.context = context;
		this._diffModeMultiple = diffMode === "multiple";
	}
	/**
	
	* Callback function when add a data
	
	*/
	DataDiffer$1.prototype.add = function(func) {
		this._add = func;
		return this;
	};
	/**
	
	* Callback function when update a data
	
	*/
	DataDiffer$1.prototype.update = function(func) {
		this._update = func;
		return this;
	};
	/**
	
	* Callback function when update a data and only work in `cbMode: 'byKey'`.
	
	*/
	DataDiffer$1.prototype.updateManyToOne = function(func) {
		this._updateManyToOne = func;
		return this;
	};
	/**
	
	* Callback function when update a data and only work in `cbMode: 'byKey'`.
	
	*/
	DataDiffer$1.prototype.updateOneToMany = function(func) {
		this._updateOneToMany = func;
		return this;
	};
	/**
	
	* Callback function when update a data and only work in `cbMode: 'byKey'`.
	
	*/
	DataDiffer$1.prototype.updateManyToMany = function(func) {
		this._updateManyToMany = func;
		return this;
	};
	/**
	
	* Callback function when remove a data
	
	*/
	DataDiffer$1.prototype.remove = function(func) {
		this._remove = func;
		return this;
	};
	DataDiffer$1.prototype.execute = function() {
		this[this._diffModeMultiple ? "_executeMultiple" : "_executeOneToOne"]();
	};
	DataDiffer$1.prototype._executeOneToOne = function() {
		var oldArr = this._old;
		var newArr = this._new;
		var newDataIndexMap = {};
		var oldDataKeyArr = new Array(oldArr.length);
		var newDataKeyArr = new Array(newArr.length);
		this._initIndexMap(oldArr, null, oldDataKeyArr, "_oldKeyGetter");
		this._initIndexMap(newArr, newDataIndexMap, newDataKeyArr, "_newKeyGetter");
		for (var i = 0; i < oldArr.length; i++) {
			var oldKey = oldDataKeyArr[i];
			var newIdxMapVal = newDataIndexMap[oldKey];
			var newIdxMapValLen = dataIndexMapValueLength(newIdxMapVal);
			if (newIdxMapValLen > 1) {
				var newIdx = newIdxMapVal.shift();
				if (newIdxMapVal.length === 1) newDataIndexMap[oldKey] = newIdxMapVal[0];
				this._update && this._update(newIdx, i);
			} else if (newIdxMapValLen === 1) {
				newDataIndexMap[oldKey] = null;
				this._update && this._update(newIdxMapVal, i);
			} else this._remove && this._remove(i);
		}
		this._performRestAdd(newDataKeyArr, newDataIndexMap);
	};
	/**
	
	* For example, consider the case:
	
	* oldData: [o0, o1, o2, o3, o4, o5, o6, o7],
	
	* newData: [n0, n1, n2, n3, n4, n5, n6, n7, n8],
	
	* Where:
	
	*     o0, o1, n0 has key 'a' (many to one)
	
	*     o5, n4, n5, n6 has key 'b' (one to many)
	
	*     o2, n1 has key 'c' (one to one)
	
	*     n2, n3 has key 'd' (add)
	
	*     o3, o4 has key 'e' (remove)
	
	*     o6, o7, n7, n8 has key 'f' (many to many, treated as add and remove)
	
	* Then:
	
	*     (The order of the following directives are not ensured.)
	
	*     this._updateManyToOne(n0, [o0, o1]);
	
	*     this._updateOneToMany([n4, n5, n6], o5);
	
	*     this._update(n1, o2);
	
	*     this._remove(o3);
	
	*     this._remove(o4);
	
	*     this._remove(o6);
	
	*     this._remove(o7);
	
	*     this._add(n2);
	
	*     this._add(n3);
	
	*     this._add(n7);
	
	*     this._add(n8);
	
	*/
	DataDiffer$1.prototype._executeMultiple = function() {
		var oldArr = this._old;
		var newArr = this._new;
		var oldDataIndexMap = {};
		var newDataIndexMap = {};
		var oldDataKeyArr = [];
		var newDataKeyArr = [];
		this._initIndexMap(oldArr, oldDataIndexMap, oldDataKeyArr, "_oldKeyGetter");
		this._initIndexMap(newArr, newDataIndexMap, newDataKeyArr, "_newKeyGetter");
		for (var i = 0; i < oldDataKeyArr.length; i++) {
			var oldKey = oldDataKeyArr[i];
			var oldIdxMapVal = oldDataIndexMap[oldKey];
			var newIdxMapVal = newDataIndexMap[oldKey];
			var oldIdxMapValLen = dataIndexMapValueLength(oldIdxMapVal);
			var newIdxMapValLen = dataIndexMapValueLength(newIdxMapVal);
			if (oldIdxMapValLen > 1 && newIdxMapValLen === 1) {
				this._updateManyToOne && this._updateManyToOne(newIdxMapVal, oldIdxMapVal);
				newDataIndexMap[oldKey] = null;
			} else if (oldIdxMapValLen === 1 && newIdxMapValLen > 1) {
				this._updateOneToMany && this._updateOneToMany(newIdxMapVal, oldIdxMapVal);
				newDataIndexMap[oldKey] = null;
			} else if (oldIdxMapValLen === 1 && newIdxMapValLen === 1) {
				this._update && this._update(newIdxMapVal, oldIdxMapVal);
				newDataIndexMap[oldKey] = null;
			} else if (oldIdxMapValLen > 1 && newIdxMapValLen > 1) {
				this._updateManyToMany && this._updateManyToMany(newIdxMapVal, oldIdxMapVal);
				newDataIndexMap[oldKey] = null;
			} else if (oldIdxMapValLen > 1) for (var i_1 = 0; i_1 < oldIdxMapValLen; i_1++) this._remove && this._remove(oldIdxMapVal[i_1]);
			else this._remove && this._remove(oldIdxMapVal);
		}
		this._performRestAdd(newDataKeyArr, newDataIndexMap);
	};
	DataDiffer$1.prototype._performRestAdd = function(newDataKeyArr, newDataIndexMap) {
		for (var i = 0; i < newDataKeyArr.length; i++) {
			var newKey = newDataKeyArr[i];
			var newIdxMapVal = newDataIndexMap[newKey];
			var idxMapValLen = dataIndexMapValueLength(newIdxMapVal);
			if (idxMapValLen > 1) for (var j = 0; j < idxMapValLen; j++) this._add && this._add(newIdxMapVal[j]);
			else if (idxMapValLen === 1) this._add && this._add(newIdxMapVal);
			newDataIndexMap[newKey] = null;
		}
	};
	DataDiffer$1.prototype._initIndexMap = function(arr, map$2, keyArr, keyGetterName) {
		var cbModeMultiple = this._diffModeMultiple;
		for (var i = 0; i < arr.length; i++) {
			var key = "_ec_" + this[keyGetterName](arr[i], i);
			if (!cbModeMultiple) keyArr[i] = key;
			if (!map$2) continue;
			var idxMapVal = map$2[key];
			var idxMapValLen = dataIndexMapValueLength(idxMapVal);
			if (idxMapValLen === 0) {
				map$2[key] = i;
				if (cbModeMultiple) keyArr.push(key);
			} else if (idxMapValLen === 1) map$2[key] = [idxMapVal, i];
			else idxMapVal.push(i);
		}
	};
	return DataDiffer$1;
}();
var DataDiffer_default = DataDiffer;
var VISUAL_DIMENSIONS = createHashMap([
	"tooltip",
	"label",
	"itemName",
	"itemId",
	"itemGroupId",
	"itemChildGroupId",
	"seriesName"
]);
var SOURCE_FORMAT_ORIGINAL = "original";
var SOURCE_FORMAT_ARRAY_ROWS = "arrayRows";
var SOURCE_FORMAT_OBJECT_ROWS = "objectRows";
var SOURCE_FORMAT_KEYED_COLUMNS = "keyedColumns";
var SOURCE_FORMAT_TYPED_ARRAY = "typedArray";
var SOURCE_FORMAT_UNKNOWN = "unknown";
var SERIES_LAYOUT_BY_COLUMN = "column";
var SERIES_LAYOUT_BY_ROW = "row";
var BE_ORDINAL = {
	Must: 1,
	Might: 2,
	Not: 3
};
var innerGlobalModel = makeInner();
function resetSourceDefaulter(ecModel) {
	innerGlobalModel(ecModel).datasetMap = createHashMap();
}
function makeSeriesEncodeForAxisCoordSys(coordDimensions, seriesModel, source) {
	var encode = {};
	var datasetModel = querySeriesUpstreamDatasetModel(seriesModel);
	if (!datasetModel || !coordDimensions) return encode;
	var encodeItemName = [];
	var encodeSeriesName = [];
	var ecModel = seriesModel.ecModel;
	var datasetMap = innerGlobalModel(ecModel).datasetMap;
	var key = datasetModel.uid + "_" + source.seriesLayoutBy;
	var baseCategoryDimIndex;
	var categoryWayValueDimStart;
	coordDimensions = coordDimensions.slice();
	each$4(coordDimensions, function(coordDimInfoLoose, coordDimIdx) {
		var coordDimInfo = isObject$2(coordDimInfoLoose) ? coordDimInfoLoose : coordDimensions[coordDimIdx] = { name: coordDimInfoLoose };
		if (coordDimInfo.type === "ordinal" && baseCategoryDimIndex == null) {
			baseCategoryDimIndex = coordDimIdx;
			categoryWayValueDimStart = getDataDimCountOnCoordDim(coordDimInfo);
		}
		encode[coordDimInfo.name] = [];
	});
	var datasetRecord = datasetMap.get(key) || datasetMap.set(key, {
		categoryWayDim: categoryWayValueDimStart,
		valueWayDim: 0
	});
	each$4(coordDimensions, function(coordDimInfo, coordDimIdx) {
		var coordDimName = coordDimInfo.name;
		var count = getDataDimCountOnCoordDim(coordDimInfo);
		if (baseCategoryDimIndex == null) {
			var start$1 = datasetRecord.valueWayDim;
			pushDim(encode[coordDimName], start$1, count);
			pushDim(encodeSeriesName, start$1, count);
			datasetRecord.valueWayDim += count;
		} else if (baseCategoryDimIndex === coordDimIdx) {
			pushDim(encode[coordDimName], 0, count);
			pushDim(encodeItemName, 0, count);
		} else {
			var start$1 = datasetRecord.categoryWayDim;
			pushDim(encode[coordDimName], start$1, count);
			pushDim(encodeSeriesName, start$1, count);
			datasetRecord.categoryWayDim += count;
		}
	});
	function pushDim(dimIdxArr, idxFrom, idxCount) {
		for (var i = 0; i < idxCount; i++) dimIdxArr.push(idxFrom + i);
	}
	function getDataDimCountOnCoordDim(coordDimInfo) {
		var dimsDef = coordDimInfo.dimsDef;
		return dimsDef ? dimsDef.length : 1;
	}
	encodeItemName.length && (encode.itemName = encodeItemName);
	encodeSeriesName.length && (encode.seriesName = encodeSeriesName);
	return encode;
}
function querySeriesUpstreamDatasetModel(seriesModel) {
	var thisData = seriesModel.get("data", true);
	if (!thisData) return queryReferringComponents(seriesModel.ecModel, "dataset", {
		index: seriesModel.get("datasetIndex", true),
		id: seriesModel.get("datasetId", true)
	}, SINGLE_REFERRING).models[0];
}
function queryDatasetUpstreamDatasetModels(datasetModel) {
	if (!datasetModel.get("transform", true) && !datasetModel.get("fromTransformResult", true)) return [];
	return queryReferringComponents(datasetModel.ecModel, "dataset", {
		index: datasetModel.get("fromDatasetIndex", true),
		id: datasetModel.get("fromDatasetId", true)
	}, SINGLE_REFERRING).models;
}
function guessOrdinal(source, dimIndex) {
	return doGuessOrdinal(source.data, source.sourceFormat, source.seriesLayoutBy, source.dimensionsDefine, source.startIndex, dimIndex);
}
function doGuessOrdinal(data, sourceFormat, seriesLayoutBy, dimensionsDefine, startIndex, dimIndex) {
	var result;
	var maxLoop = 5;
	if (isTypedArray(data)) return BE_ORDINAL.Not;
	var dimName;
	var dimType;
	if (dimensionsDefine) {
		var dimDefItem = dimensionsDefine[dimIndex];
		if (isObject$2(dimDefItem)) {
			dimName = dimDefItem.name;
			dimType = dimDefItem.type;
		} else if (isString(dimDefItem)) dimName = dimDefItem;
	}
	if (dimType != null) return dimType === "ordinal" ? BE_ORDINAL.Must : BE_ORDINAL.Not;
	if (sourceFormat === SOURCE_FORMAT_ARRAY_ROWS) {
		var dataArrayRows = data;
		if (seriesLayoutBy === SERIES_LAYOUT_BY_ROW) {
			var sample = dataArrayRows[dimIndex];
			for (var i = 0; i < (sample || []).length && i < maxLoop; i++) if ((result = detectValue(sample[startIndex + i])) != null) return result;
		} else for (var i = 0; i < dataArrayRows.length && i < maxLoop; i++) {
			var row = dataArrayRows[startIndex + i];
			if (row && (result = detectValue(row[dimIndex])) != null) return result;
		}
	} else if (sourceFormat === SOURCE_FORMAT_OBJECT_ROWS) {
		var dataObjectRows = data;
		if (!dimName) return BE_ORDINAL.Not;
		for (var i = 0; i < dataObjectRows.length && i < maxLoop; i++) {
			var item = dataObjectRows[i];
			if (item && (result = detectValue(item[dimName])) != null) return result;
		}
	} else if (sourceFormat === SOURCE_FORMAT_KEYED_COLUMNS) {
		var dataKeyedColumns = data;
		if (!dimName) return BE_ORDINAL.Not;
		var sample = dataKeyedColumns[dimName];
		if (!sample || isTypedArray(sample)) return BE_ORDINAL.Not;
		for (var i = 0; i < sample.length && i < maxLoop; i++) if ((result = detectValue(sample[i])) != null) return result;
	} else if (sourceFormat === SOURCE_FORMAT_ORIGINAL) {
		var dataOriginal = data;
		for (var i = 0; i < dataOriginal.length && i < maxLoop; i++) {
			var item = dataOriginal[i];
			var val = getDataItemValue(item);
			if (!isArray(val)) return BE_ORDINAL.Not;
			if ((result = detectValue(val[dimIndex])) != null) return result;
		}
	}
	function detectValue(val$1) {
		var beStr = isString(val$1);
		if (val$1 != null && Number.isFinite(Number(val$1)) && val$1 !== "") return beStr ? BE_ORDINAL.Might : BE_ORDINAL.Not;
		else if (beStr && val$1 !== "-") return BE_ORDINAL.Must;
	}
	return BE_ORDINAL.Not;
}
var SourceImpl = function() {
	function SourceImpl$1(fields) {
		this.data = fields.data || (fields.sourceFormat === SOURCE_FORMAT_KEYED_COLUMNS ? {} : []);
		this.sourceFormat = fields.sourceFormat || SOURCE_FORMAT_UNKNOWN;
		this.seriesLayoutBy = fields.seriesLayoutBy || SERIES_LAYOUT_BY_COLUMN;
		this.startIndex = fields.startIndex || 0;
		this.dimensionsDetectedCount = fields.dimensionsDetectedCount;
		this.metaRawOption = fields.metaRawOption;
		var dimensionsDefine = this.dimensionsDefine = fields.dimensionsDefine;
		if (dimensionsDefine) for (var i = 0; i < dimensionsDefine.length; i++) {
			var dim = dimensionsDefine[i];
			if (dim.type == null) {
				if (guessOrdinal(this, i) === BE_ORDINAL.Must) dim.type = "ordinal";
			}
		}
	}
	return SourceImpl$1;
}();
function isSourceInstance(val) {
	return val instanceof SourceImpl;
}
function createSource(sourceData, thisMetaRawOption, sourceFormat) {
	sourceFormat = sourceFormat || detectSourceFormat(sourceData);
	var seriesLayoutBy = thisMetaRawOption.seriesLayoutBy;
	var determined = determineSourceDimensions(sourceData, sourceFormat, seriesLayoutBy, thisMetaRawOption.sourceHeader, thisMetaRawOption.dimensions);
	var source = new SourceImpl({
		data: sourceData,
		sourceFormat,
		seriesLayoutBy,
		dimensionsDefine: determined.dimensionsDefine,
		startIndex: determined.startIndex,
		dimensionsDetectedCount: determined.dimensionsDetectedCount,
		metaRawOption: clone$2(thisMetaRawOption)
	});
	return source;
}
function createSourceFromSeriesDataOption(data) {
	return new SourceImpl({
		data,
		sourceFormat: isTypedArray(data) ? SOURCE_FORMAT_TYPED_ARRAY : SOURCE_FORMAT_ORIGINAL
	});
}
function cloneSourceShallow(source) {
	return new SourceImpl({
		data: source.data,
		sourceFormat: source.sourceFormat,
		seriesLayoutBy: source.seriesLayoutBy,
		dimensionsDefine: clone$2(source.dimensionsDefine),
		startIndex: source.startIndex,
		dimensionsDetectedCount: source.dimensionsDetectedCount
	});
}
function detectSourceFormat(data) {
	var sourceFormat = SOURCE_FORMAT_UNKNOWN;
	if (isTypedArray(data)) sourceFormat = SOURCE_FORMAT_TYPED_ARRAY;
	else if (isArray(data)) {
		if (data.length === 0) sourceFormat = SOURCE_FORMAT_ARRAY_ROWS;
		for (var i = 0, len$1 = data.length; i < len$1; i++) {
			var item = data[i];
			if (item == null) continue;
			else if (isArray(item) || isTypedArray(item)) {
				sourceFormat = SOURCE_FORMAT_ARRAY_ROWS;
				break;
			} else if (isObject$2(item)) {
				sourceFormat = SOURCE_FORMAT_OBJECT_ROWS;
				break;
			}
		}
	} else if (isObject$2(data)) {
		for (var key in data) if (hasOwn(data, key) && isArrayLike(data[key])) {
			sourceFormat = SOURCE_FORMAT_KEYED_COLUMNS;
			break;
		}
	}
	return sourceFormat;
}
/**

* Determine the source definitions from data standalone dimensions definitions

* are not specified.

*/
function determineSourceDimensions(data, sourceFormat, seriesLayoutBy, sourceHeader, dimensionsDefine) {
	var dimensionsDetectedCount;
	var startIndex;
	if (!data) return {
		dimensionsDefine: normalizeDimensionsOption(dimensionsDefine),
		startIndex,
		dimensionsDetectedCount
	};
	if (sourceFormat === SOURCE_FORMAT_ARRAY_ROWS) {
		var dataArrayRows = data;
		if (sourceHeader === "auto" || sourceHeader == null) arrayRowsTravelFirst(function(val) {
			if (val != null && val !== "-") if (isString(val)) startIndex ??= 1;
			else startIndex = 0;
		}, seriesLayoutBy, dataArrayRows, 10);
		else startIndex = isNumber(sourceHeader) ? sourceHeader : sourceHeader ? 1 : 0;
		if (!dimensionsDefine && startIndex === 1) {
			dimensionsDefine = [];
			arrayRowsTravelFirst(function(val, index) {
				dimensionsDefine[index] = val != null ? val + "" : "";
			}, seriesLayoutBy, dataArrayRows, Infinity);
		}
		dimensionsDetectedCount = dimensionsDefine ? dimensionsDefine.length : seriesLayoutBy === SERIES_LAYOUT_BY_ROW ? dataArrayRows.length : dataArrayRows[0] ? dataArrayRows[0].length : null;
	} else if (sourceFormat === SOURCE_FORMAT_OBJECT_ROWS) {
		if (!dimensionsDefine) dimensionsDefine = objectRowsCollectDimensions(data);
	} else if (sourceFormat === SOURCE_FORMAT_KEYED_COLUMNS) {
		if (!dimensionsDefine) {
			dimensionsDefine = [];
			each$4(data, function(colArr, key) {
				dimensionsDefine.push(key);
			});
		}
	} else if (sourceFormat === SOURCE_FORMAT_ORIGINAL) {
		var value0 = getDataItemValue(data[0]);
		dimensionsDetectedCount = isArray(value0) && value0.length || 1;
	} else if (sourceFormat === SOURCE_FORMAT_TYPED_ARRAY) {}
	return {
		startIndex,
		dimensionsDefine: normalizeDimensionsOption(dimensionsDefine),
		dimensionsDetectedCount
	};
}
function objectRowsCollectDimensions(data) {
	var firstIndex = 0;
	var obj;
	while (firstIndex < data.length && !(obj = data[firstIndex++]));
	if (obj) return keys(obj);
}
function normalizeDimensionsOption(dimensionsDefine) {
	if (!dimensionsDefine) return;
	var nameMap = createHashMap();
	return map$1(dimensionsDefine, function(rawItem, index) {
		rawItem = isObject$2(rawItem) ? rawItem : { name: rawItem };
		var item = {
			name: rawItem.name,
			displayName: rawItem.displayName,
			type: rawItem.type
		};
		if (item.name == null) return item;
		item.name += "";
		if (item.displayName == null) item.displayName = item.name;
		var exist = nameMap.get(item.name);
		if (!exist) nameMap.set(item.name, { count: 1 });
		else item.name += "-" + exist.count++;
		return item;
	});
}
function arrayRowsTravelFirst(cb, seriesLayoutBy, data, maxLoop) {
	if (seriesLayoutBy === SERIES_LAYOUT_BY_ROW) for (var i = 0; i < data.length && i < maxLoop; i++) cb(data[i] ? data[i][0] : null, i);
	else {
		var value0 = data[0] || [];
		for (var i = 0; i < value0.length && i < maxLoop; i++) cb(value0[i], i);
	}
}
function shouldRetrieveDataByName(source) {
	var sourceFormat = source.sourceFormat;
	return sourceFormat === SOURCE_FORMAT_OBJECT_ROWS || sourceFormat === SOURCE_FORMAT_KEYED_COLUMNS;
}
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
var _a, _b, _c;
var providerMethods;
var mountMethods;
/**

* If normal array used, mutable chunk size is supported.

* If typed array used, chunk size must be fixed.

*/
var DefaultDataProvider = function() {
	function DefaultDataProvider$1(sourceParam, dimSize) {
		var source = !isSourceInstance(sourceParam) ? createSourceFromSeriesDataOption(sourceParam) : sourceParam;
		this._source = source;
		var data = this._data = source.data;
		if (source.sourceFormat === SOURCE_FORMAT_TYPED_ARRAY) {
			this._offset = 0;
			this._dimSize = dimSize;
			this._data = data;
		}
		mountMethods(this, data, source);
	}
	DefaultDataProvider$1.prototype.getSource = function() {
		return this._source;
	};
	DefaultDataProvider$1.prototype.count = function() {
		return 0;
	};
	DefaultDataProvider$1.prototype.getItem = function(idx, out$1) {
		return;
	};
	DefaultDataProvider$1.prototype.appendData = function(newData) {};
	DefaultDataProvider$1.prototype.clean = function() {};
	DefaultDataProvider$1.protoInitialize = function() {
		var proto$1 = DefaultDataProvider$1.prototype;
		proto$1.pure = false;
		proto$1.persistent = true;
	}();
	DefaultDataProvider$1.internalField = function() {
		var _a$1;
		mountMethods = function(provider, data, source) {
			var sourceFormat = source.sourceFormat;
			var seriesLayoutBy = source.seriesLayoutBy;
			var startIndex = source.startIndex;
			var dimsDef = source.dimensionsDefine;
			var methods = providerMethods[getMethodMapKey(sourceFormat, seriesLayoutBy)];
			extend(provider, methods);
			if (sourceFormat === SOURCE_FORMAT_TYPED_ARRAY) {
				provider.getItem = getItemForTypedArray;
				provider.count = countForTypedArray;
				provider.fillStorage = fillStorageForTypedArray;
			} else {
				var rawItemGetter = getRawSourceItemGetter(sourceFormat, seriesLayoutBy);
				provider.getItem = bind$1(rawItemGetter, null, data, startIndex, dimsDef);
				var rawCounter = getRawSourceDataCounter(sourceFormat, seriesLayoutBy);
				provider.count = bind$1(rawCounter, null, data, startIndex, dimsDef);
			}
		};
		var getItemForTypedArray = function(idx, out$1) {
			idx = idx - this._offset;
			out$1 = out$1 || [];
			var data = this._data;
			var dimSize = this._dimSize;
			var offset = dimSize * idx;
			for (var i = 0; i < dimSize; i++) out$1[i] = data[offset + i];
			return out$1;
		};
		var fillStorageForTypedArray = function(start$1, end$1, storage, extent$1) {
			var data = this._data;
			var dimSize = this._dimSize;
			for (var dim = 0; dim < dimSize; dim++) {
				var dimExtent = extent$1[dim];
				var min$2 = dimExtent[0] == null ? Infinity : dimExtent[0];
				var max$2 = dimExtent[1] == null ? -Infinity : dimExtent[1];
				var count = end$1 - start$1;
				var arr = storage[dim];
				for (var i = 0; i < count; i++) {
					var val = data[i * dimSize + dim];
					arr[start$1 + i] = val;
					val < min$2 && (min$2 = val);
					val > max$2 && (max$2 = val);
				}
				dimExtent[0] = min$2;
				dimExtent[1] = max$2;
			}
		};
		var countForTypedArray = function() {
			return this._data ? this._data.length / this._dimSize : 0;
		};
		providerMethods = (_a$1 = {}, _a$1[SOURCE_FORMAT_ARRAY_ROWS + "_" + SERIES_LAYOUT_BY_COLUMN] = {
			pure: true,
			appendData: appendDataSimply
		}, _a$1[SOURCE_FORMAT_ARRAY_ROWS + "_" + SERIES_LAYOUT_BY_ROW] = {
			pure: true,
			appendData: function() {
				throw new Error("Do not support appendData when set seriesLayoutBy: \"row\".");
			}
		}, _a$1[SOURCE_FORMAT_OBJECT_ROWS] = {
			pure: true,
			appendData: appendDataSimply
		}, _a$1[SOURCE_FORMAT_KEYED_COLUMNS] = {
			pure: true,
			appendData: function(newData) {
				var data = this._data;
				each$4(newData, function(newCol, key) {
					var oldCol = data[key] || (data[key] = []);
					for (var i = 0; i < (newCol || []).length; i++) oldCol.push(newCol[i]);
				});
			}
		}, _a$1[SOURCE_FORMAT_ORIGINAL] = { appendData: appendDataSimply }, _a$1[SOURCE_FORMAT_TYPED_ARRAY] = {
			persistent: false,
			pure: true,
			appendData: function(newData) {
				this._data = newData;
			},
			clean: function() {
				this._offset += this.count();
				this._data = null;
			}
		}, _a$1);
		function appendDataSimply(newData) {
			for (var i = 0; i < newData.length; i++) this._data.push(newData[i]);
		}
	}();
	return DefaultDataProvider$1;
}();
var getItemSimply = function(rawData, startIndex, dimsDef, idx) {
	return rawData[idx];
};
var rawSourceItemGetterMap = (_a = {}, _a[SOURCE_FORMAT_ARRAY_ROWS + "_" + SERIES_LAYOUT_BY_COLUMN] = function(rawData, startIndex, dimsDef, idx) {
	return rawData[idx + startIndex];
}, _a[SOURCE_FORMAT_ARRAY_ROWS + "_" + SERIES_LAYOUT_BY_ROW] = function(rawData, startIndex, dimsDef, idx, out$1) {
	idx += startIndex;
	var item = out$1 || [];
	var data = rawData;
	for (var i = 0; i < data.length; i++) {
		var row = data[i];
		item[i] = row ? row[idx] : null;
	}
	return item;
}, _a[SOURCE_FORMAT_OBJECT_ROWS] = getItemSimply, _a[SOURCE_FORMAT_KEYED_COLUMNS] = function(rawData, startIndex, dimsDef, idx, out$1) {
	var item = out$1 || [];
	for (var i = 0; i < dimsDef.length; i++) {
		var dimName = dimsDef[i].name;
		var col = rawData[dimName];
		item[i] = col ? col[idx] : null;
	}
	return item;
}, _a[SOURCE_FORMAT_ORIGINAL] = getItemSimply, _a);
function getRawSourceItemGetter(sourceFormat, seriesLayoutBy) {
	var method = rawSourceItemGetterMap[getMethodMapKey(sourceFormat, seriesLayoutBy)];
	return method;
}
var countSimply = function(rawData, startIndex, dimsDef) {
	return rawData.length;
};
var rawSourceDataCounterMap = (_b = {}, _b[SOURCE_FORMAT_ARRAY_ROWS + "_" + SERIES_LAYOUT_BY_COLUMN] = function(rawData, startIndex, dimsDef) {
	return Math.max(0, rawData.length - startIndex);
}, _b[SOURCE_FORMAT_ARRAY_ROWS + "_" + SERIES_LAYOUT_BY_ROW] = function(rawData, startIndex, dimsDef) {
	var row = rawData[0];
	return row ? Math.max(0, row.length - startIndex) : 0;
}, _b[SOURCE_FORMAT_OBJECT_ROWS] = countSimply, _b[SOURCE_FORMAT_KEYED_COLUMNS] = function(rawData, startIndex, dimsDef) {
	var dimName = dimsDef[0].name;
	var col = rawData[dimName];
	return col ? col.length : 0;
}, _b[SOURCE_FORMAT_ORIGINAL] = countSimply, _b);
function getRawSourceDataCounter(sourceFormat, seriesLayoutBy) {
	var method = rawSourceDataCounterMap[getMethodMapKey(sourceFormat, seriesLayoutBy)];
	return method;
}
var getRawValueSimply = function(dataItem, dimIndex, property) {
	return dataItem[dimIndex];
};
var rawSourceValueGetterMap = (_c = {}, _c[SOURCE_FORMAT_ARRAY_ROWS] = getRawValueSimply, _c[SOURCE_FORMAT_OBJECT_ROWS] = function(dataItem, dimIndex, property) {
	return dataItem[property];
}, _c[SOURCE_FORMAT_KEYED_COLUMNS] = getRawValueSimply, _c[SOURCE_FORMAT_ORIGINAL] = function(dataItem, dimIndex, property) {
	var value = getDataItemValue(dataItem);
	return !(value instanceof Array) ? value : value[dimIndex];
}, _c[SOURCE_FORMAT_TYPED_ARRAY] = getRawValueSimply, _c);
function getRawSourceValueGetter(sourceFormat) {
	var method = rawSourceValueGetterMap[sourceFormat];
	return method;
}
function getMethodMapKey(sourceFormat, seriesLayoutBy) {
	return sourceFormat === SOURCE_FORMAT_ARRAY_ROWS ? sourceFormat + "_" + seriesLayoutBy : sourceFormat;
}
function retrieveRawValue(data, dataIndex, dim) {
	if (!data) return;
	var dataItem = data.getRawDataItem(dataIndex);
	if (dataItem == null) return;
	var store = data.getStore();
	var sourceFormat = store.getSource().sourceFormat;
	if (dim != null) {
		var dimIndex = data.getDimensionIndex(dim);
		var property = store.getDimensionProperty(dimIndex);
		return getRawSourceValueGetter(sourceFormat)(dataItem, dimIndex, property);
	} else {
		var result = dataItem;
		if (sourceFormat === SOURCE_FORMAT_ORIGINAL) result = getDataItemValue(dataItem);
		return result;
	}
}
var DimensionUserOuput = function() {
	function DimensionUserOuput$1(encode, dimRequest) {
		this._encode = encode;
		this._schema = dimRequest;
	}
	DimensionUserOuput$1.prototype.get = function() {
		return {
			fullDimensions: this._getFullDimensionNames(),
			encode: this._encode
		};
	};
	/**
	
	* Get all data store dimension names.
	
	* Theoretically a series data store is defined both by series and used dataset (if any).
	
	* If some dimensions are omitted for performance reason in `this.dimensions`,
	
	* the dimension name may not be auto-generated if user does not specify a dimension name.
	
	* In this case, the dimension name is `null`/`undefined`.
	
	*/
	DimensionUserOuput$1.prototype._getFullDimensionNames = function() {
		if (!this._cachedDimNames) this._cachedDimNames = this._schema ? this._schema.makeOutputDimensionNames() : [];
		return this._cachedDimNames;
	};
	return DimensionUserOuput$1;
}();
function summarizeDimensions(data, schema) {
	var summary = {};
	var encode = summary.encode = {};
	var notExtraCoordDimMap = createHashMap();
	var defaultedLabel = [];
	var defaultedTooltip = [];
	var userOutputEncode = {};
	each$4(data.dimensions, function(dimName) {
		var dimItem = data.getDimensionInfo(dimName);
		var coordDim = dimItem.coordDim;
		if (coordDim) {
			var coordDimIndex = dimItem.coordDimIndex;
			getOrCreateEncodeArr(encode, coordDim)[coordDimIndex] = dimName;
			if (!dimItem.isExtraCoord) {
				notExtraCoordDimMap.set(coordDim, 1);
				if (mayLabelDimType(dimItem.type)) defaultedLabel[0] = dimName;
				getOrCreateEncodeArr(userOutputEncode, coordDim)[coordDimIndex] = data.getDimensionIndex(dimItem.name);
			}
			if (dimItem.defaultTooltip) defaultedTooltip.push(dimName);
		}
		VISUAL_DIMENSIONS.each(function(v, otherDim) {
			var encodeArr = getOrCreateEncodeArr(encode, otherDim);
			var dimIndex = dimItem.otherDims[otherDim];
			if (dimIndex != null && dimIndex !== false) encodeArr[dimIndex] = dimItem.name;
		});
	});
	var dataDimsOnCoord = [];
	var encodeFirstDimNotExtra = {};
	notExtraCoordDimMap.each(function(v, coordDim) {
		var dimArr = encode[coordDim];
		encodeFirstDimNotExtra[coordDim] = dimArr[0];
		dataDimsOnCoord = dataDimsOnCoord.concat(dimArr);
	});
	summary.dataDimsOnCoord = dataDimsOnCoord;
	summary.dataDimIndicesOnCoord = map$1(dataDimsOnCoord, function(dimName) {
		return data.getDimensionInfo(dimName).storeDimIndex;
	});
	summary.encodeFirstDimNotExtra = encodeFirstDimNotExtra;
	var encodeLabel = encode.label;
	if (encodeLabel && encodeLabel.length) defaultedLabel = encodeLabel.slice();
	var encodeTooltip = encode.tooltip;
	if (encodeTooltip && encodeTooltip.length) defaultedTooltip = encodeTooltip.slice();
	else if (!defaultedTooltip.length) defaultedTooltip = defaultedLabel.slice();
	encode.defaultedLabel = defaultedLabel;
	encode.defaultedTooltip = defaultedTooltip;
	summary.userOutput = new DimensionUserOuput(userOutputEncode, schema);
	return summary;
}
function getOrCreateEncodeArr(encode, dim) {
	if (!encode.hasOwnProperty(dim)) encode[dim] = [];
	return encode[dim];
}
function getDimensionTypeByAxis(axisType) {
	return axisType === "category" ? "ordinal" : axisType === "time" ? "time" : "float";
}
function mayLabelDimType(dimType) {
	return !(dimType === "ordinal" || dimType === "time");
}
var SeriesDimensionDefine = function() {
	/**
	
	* @param opt All of the fields will be shallow copied.
	
	*/
	function SeriesDimensionDefine$1(opt) {
		/**
		
		* The format of `otherDims` is:
		
		* ```js
		
		* {
		
		*     tooltip?: number
		
		*     label?: number
		
		*     itemName?: number
		
		*     seriesName?: number
		
		* }
		
		* ```
		
		*
		
		* A `series.encode` can specified these fields:
		
		* ```js
		
		* encode: {
		
		*     // "3, 1, 5" is the index of data dimension.
		
		*     tooltip: [3, 1, 5],
		
		*     label: [0, 3],
		
		*     ...
		
		* }
		
		* ```
		
		* `otherDims` is the parse result of the `series.encode` above, like:
		
		* ```js
		
		* // Suppose the index of this data dimension is `3`.
		
		* this.otherDims = {
		
		*     // `3` is at the index `0` of the `encode.tooltip`
		
		*     tooltip: 0,
		
		*     // `3` is at the index `1` of the `encode.label`
		
		*     label: 1
		
		* };
		
		* ```
		
		*
		
		* This prop should never be `null`/`undefined` after initialized.
		
		*/
		this.otherDims = {};
		if (opt != null) extend(this, opt);
	}
	return SeriesDimensionDefine$1;
}();
var SeriesDimensionDefine_default = SeriesDimensionDefine;
function parseDataValue(value, opt) {
	var dimType = opt && opt.type;
	if (dimType === "ordinal") return value;
	if (dimType === "time" && !isNumber(value) && value != null && value !== "-") value = +parseDate(value);
	return value == null || value === "" ? NaN : Number(value);
}
var valueParserMap = createHashMap({
	"number": function(val) {
		return parseFloat(val);
	},
	"time": function(val) {
		return +parseDate(val);
	},
	"trim": function(val) {
		return isString(val) ? trim(val) : val;
	}
});
var ORDER_COMPARISON_OP_MAP = {
	lt: function(lval, rval) {
		return lval < rval;
	},
	lte: function(lval, rval) {
		return lval <= rval;
	},
	gt: function(lval, rval) {
		return lval > rval;
	},
	gte: function(lval, rval) {
		return lval >= rval;
	}
};
var FilterOrderComparator = function() {
	function FilterOrderComparator$1(op, rval) {
		if (!isNumber(rval)) {
			var errMsg = "";
			throwError(errMsg);
		}
		this._opFn = ORDER_COMPARISON_OP_MAP[op];
		this._rvalFloat = numericToNumber(rval);
	}
	FilterOrderComparator$1.prototype.evaluate = function(lval) {
		return isNumber(lval) ? this._opFn(lval, this._rvalFloat) : this._opFn(numericToNumber(lval), this._rvalFloat);
	};
	return FilterOrderComparator$1;
}();
var SortOrderComparator = function() {
	/**
	
	* @param order by default: 'asc'
	
	* @param incomparable by default: Always on the tail.
	
	*        That is, if 'asc' => 'max', if 'desc' => 'min'
	
	*        See the definition of "incomparable" in [SORT_COMPARISON_RULE].
	
	*/
	function SortOrderComparator$1(order, incomparable) {
		var isDesc = order === "desc";
		this._resultLT = isDesc ? 1 : -1;
		if (incomparable == null) incomparable = isDesc ? "min" : "max";
		this._incomparable = incomparable === "min" ? -Infinity : Infinity;
	}
	SortOrderComparator$1.prototype.evaluate = function(lval, rval) {
		var lvalFloat = isNumber(lval) ? lval : numericToNumber(lval);
		var rvalFloat = isNumber(rval) ? rval : numericToNumber(rval);
		var lvalNotNumeric = isNaN(lvalFloat);
		var rvalNotNumeric = isNaN(rvalFloat);
		if (lvalNotNumeric) lvalFloat = this._incomparable;
		if (rvalNotNumeric) rvalFloat = this._incomparable;
		if (lvalNotNumeric && rvalNotNumeric) {
			var lvalIsStr = isString(lval);
			var rvalIsStr = isString(rval);
			if (lvalIsStr) lvalFloat = rvalIsStr ? lval : 0;
			if (rvalIsStr) rvalFloat = lvalIsStr ? rval : 0;
		}
		return lvalFloat < rvalFloat ? this._resultLT : lvalFloat > rvalFloat ? -this._resultLT : 0;
	};
	return SortOrderComparator$1;
}();
var FilterEqualityComparator = function() {
	function FilterEqualityComparator$1(isEq, rval) {
		this._rval = rval;
		this._isEQ = isEq;
		this._rvalTypeof = typeof rval;
		this._rvalFloat = numericToNumber(rval);
	}
	FilterEqualityComparator$1.prototype.evaluate = function(lval) {
		var eqResult = lval === this._rval;
		if (!eqResult) {
			var lvalTypeof = typeof lval;
			if (lvalTypeof !== this._rvalTypeof && (lvalTypeof === "number" || this._rvalTypeof === "number")) eqResult = numericToNumber(lval) === this._rvalFloat;
		}
		return this._isEQ ? eqResult : !eqResult;
	};
	return FilterEqualityComparator$1;
}();
var UNDEFINED = "undefined";
var CtorUint32Array = typeof Uint32Array === UNDEFINED ? Array : Uint32Array;
var CtorUint16Array = typeof Uint16Array === UNDEFINED ? Array : Uint16Array;
var CtorInt32Array$1 = typeof Int32Array === UNDEFINED ? Array : Int32Array;
var CtorFloat64Array = typeof Float64Array === UNDEFINED ? Array : Float64Array;
/**

* Multi dimensional data store

*/
var dataCtors = {
	"float": CtorFloat64Array,
	"int": CtorInt32Array$1,
	"ordinal": Array,
	"number": Array,
	"time": CtorFloat64Array
};
var defaultDimValueGetters;
function getIndicesCtor(rawCount) {
	return rawCount > 65535 ? CtorUint32Array : CtorUint16Array;
}
function getInitialExtent() {
	return [Infinity, -Infinity];
}
function cloneChunk(originalChunk) {
	var Ctor = originalChunk.constructor;
	return Ctor === Array ? originalChunk.slice() : new Ctor(originalChunk);
}
function prepareStore(store, dimIdx, dimType, end$1, append) {
	var DataCtor = dataCtors[dimType || "float"];
	if (append) {
		var oldStore = store[dimIdx];
		var oldLen = oldStore && oldStore.length;
		if (!(oldLen === end$1)) {
			var newStore = new DataCtor(end$1);
			for (var j = 0; j < oldLen; j++) newStore[j] = oldStore[j];
			store[dimIdx] = newStore;
		}
	} else store[dimIdx] = new DataCtor(end$1);
}
/**

* Basically, DataStore API keep immutable.

*/
var DataStore = function() {
	function DataStore$1() {
		this._chunks = [];
		this._rawExtent = [];
		this._extent = [];
		this._count = 0;
		this._rawCount = 0;
		this._calcDimNameToIdx = createHashMap();
	}
	/**
	
	* Initialize from data
	
	*/
	DataStore$1.prototype.initData = function(provider, inputDimensions, dimValueGetter) {
		this._provider = provider;
		this._chunks = [];
		this._indices = null;
		this.getRawIndex = this._getRawIdxIdentity;
		var source = provider.getSource();
		var defaultGetter = this.defaultDimValueGetter = defaultDimValueGetters[source.sourceFormat];
		this._dimValueGetter = dimValueGetter || defaultGetter;
		this._rawExtent = [];
		var willRetrieveDataByName = shouldRetrieveDataByName(source);
		this._dimensions = map$1(inputDimensions, function(dim) {
			return {
				type: dim.type,
				property: dim.property
			};
		});
		this._initDataFromProvider(0, provider.count());
	};
	DataStore$1.prototype.getProvider = function() {
		return this._provider;
	};
	/**
	
	* Caution: even when a `source` instance owned by a series, the created data store
	
	* may still be shared by different sereis (the source hash does not use all `source`
	
	* props, see `sourceManager`). In this case, the `source` props that are not used in
	
	* hash (like `source.dimensionDefine`) probably only belongs to a certain series and
	
	* thus should not be fetch here.
	
	*/
	DataStore$1.prototype.getSource = function() {
		return this._provider.getSource();
	};
	/**
	
	* @caution Only used in dataStack.
	
	*/
	DataStore$1.prototype.ensureCalculationDimension = function(dimName, type) {
		var calcDimNameToIdx = this._calcDimNameToIdx;
		var dimensions = this._dimensions;
		var calcDimIdx = calcDimNameToIdx.get(dimName);
		if (calcDimIdx != null) {
			if (dimensions[calcDimIdx].type === type) return calcDimIdx;
		} else calcDimIdx = dimensions.length;
		dimensions[calcDimIdx] = { type };
		calcDimNameToIdx.set(dimName, calcDimIdx);
		this._chunks[calcDimIdx] = new dataCtors[type || "float"](this._rawCount);
		this._rawExtent[calcDimIdx] = getInitialExtent();
		return calcDimIdx;
	};
	DataStore$1.prototype.collectOrdinalMeta = function(dimIdx, ordinalMeta) {
		var chunk = this._chunks[dimIdx];
		var dim = this._dimensions[dimIdx];
		var rawExtents = this._rawExtent;
		var offset = dim.ordinalOffset || 0;
		var len$1 = chunk.length;
		if (offset === 0) rawExtents[dimIdx] = getInitialExtent();
		var dimRawExtent = rawExtents[dimIdx];
		for (var i = offset; i < len$1; i++) {
			var val = chunk[i] = ordinalMeta.parseAndCollect(chunk[i]);
			if (!isNaN(val)) {
				dimRawExtent[0] = Math.min(val, dimRawExtent[0]);
				dimRawExtent[1] = Math.max(val, dimRawExtent[1]);
			}
		}
		dim.ordinalMeta = ordinalMeta;
		dim.ordinalOffset = len$1;
		dim.type = "ordinal";
	};
	DataStore$1.prototype.getOrdinalMeta = function(dimIdx) {
		var dimInfo = this._dimensions[dimIdx];
		var ordinalMeta = dimInfo.ordinalMeta;
		return ordinalMeta;
	};
	DataStore$1.prototype.getDimensionProperty = function(dimIndex) {
		var item = this._dimensions[dimIndex];
		return item && item.property;
	};
	/**
	
	* Caution: Can be only called on raw data (before `this._indices` created).
	
	*/
	DataStore$1.prototype.appendData = function(data) {
		var provider = this._provider;
		var start$1 = this.count();
		provider.appendData(data);
		var end$1 = provider.count();
		if (!provider.persistent) end$1 += start$1;
		if (start$1 < end$1) this._initDataFromProvider(start$1, end$1, true);
		return [start$1, end$1];
	};
	DataStore$1.prototype.appendValues = function(values, minFillLen) {
		var chunks = this._chunks;
		var dimensions = this._dimensions;
		var dimLen = dimensions.length;
		var rawExtent = this._rawExtent;
		var start$1 = this.count();
		var end$1 = start$1 + Math.max(values.length, minFillLen || 0);
		for (var i = 0; i < dimLen; i++) {
			var dim = dimensions[i];
			prepareStore(chunks, i, dim.type, end$1, true);
		}
		var emptyDataItem = [];
		for (var idx = start$1; idx < end$1; idx++) {
			var sourceIdx = idx - start$1;
			for (var dimIdx = 0; dimIdx < dimLen; dimIdx++) {
				var dim = dimensions[dimIdx];
				var val = defaultDimValueGetters.arrayRows.call(this, values[sourceIdx] || emptyDataItem, dim.property, sourceIdx, dimIdx);
				chunks[dimIdx][idx] = val;
				var dimRawExtent = rawExtent[dimIdx];
				val < dimRawExtent[0] && (dimRawExtent[0] = val);
				val > dimRawExtent[1] && (dimRawExtent[1] = val);
			}
		}
		this._rawCount = this._count = end$1;
		return {
			start: start$1,
			end: end$1
		};
	};
	DataStore$1.prototype._initDataFromProvider = function(start$1, end$1, append) {
		var provider = this._provider;
		var chunks = this._chunks;
		var dimensions = this._dimensions;
		var dimLen = dimensions.length;
		var rawExtent = this._rawExtent;
		var dimNames = map$1(dimensions, function(dim$1) {
			return dim$1.property;
		});
		for (var i = 0; i < dimLen; i++) {
			var dim = dimensions[i];
			if (!rawExtent[i]) rawExtent[i] = getInitialExtent();
			prepareStore(chunks, i, dim.type, end$1, append);
		}
		if (provider.fillStorage) provider.fillStorage(start$1, end$1, chunks, rawExtent);
		else {
			var dataItem = [];
			for (var idx = start$1; idx < end$1; idx++) {
				dataItem = provider.getItem(idx, dataItem);
				for (var dimIdx = 0; dimIdx < dimLen; dimIdx++) {
					var dimStorage = chunks[dimIdx];
					var val = this._dimValueGetter(dataItem, dimNames[dimIdx], idx, dimIdx);
					dimStorage[idx] = val;
					var dimRawExtent = rawExtent[dimIdx];
					val < dimRawExtent[0] && (dimRawExtent[0] = val);
					val > dimRawExtent[1] && (dimRawExtent[1] = val);
				}
			}
		}
		if (!provider.persistent && provider.clean) provider.clean();
		this._rawCount = this._count = end$1;
		this._extent = [];
	};
	DataStore$1.prototype.count = function() {
		return this._count;
	};
	/**
	
	* Get value. Return NaN if idx is out of range.
	
	*/
	DataStore$1.prototype.get = function(dim, idx) {
		if (!(idx >= 0 && idx < this._count)) return NaN;
		var dimStore = this._chunks[dim];
		return dimStore ? dimStore[this.getRawIndex(idx)] : NaN;
	};
	DataStore$1.prototype.getValues = function(dimensions, idx) {
		var values = [];
		var dimArr = [];
		if (idx == null) {
			idx = dimensions;
			dimensions = [];
			for (var i = 0; i < this._dimensions.length; i++) dimArr.push(i);
		} else dimArr = dimensions;
		for (var i = 0, len$1 = dimArr.length; i < len$1; i++) values.push(this.get(dimArr[i], idx));
		return values;
	};
	/**
	
	* @param dim concrete dim
	
	*/
	DataStore$1.prototype.getByRawIndex = function(dim, rawIdx) {
		if (!(rawIdx >= 0 && rawIdx < this._rawCount)) return NaN;
		var dimStore = this._chunks[dim];
		return dimStore ? dimStore[rawIdx] : NaN;
	};
	/**
	
	* Get sum of data in one dimension
	
	*/
	DataStore$1.prototype.getSum = function(dim) {
		var dimData = this._chunks[dim];
		var sum = 0;
		if (dimData) for (var i = 0, len$1 = this.count(); i < len$1; i++) {
			var value = this.get(dim, i);
			if (!isNaN(value)) sum += value;
		}
		return sum;
	};
	/**
	
	* Get median of data in one dimension
	
	*/
	DataStore$1.prototype.getMedian = function(dim) {
		var dimDataArray = [];
		this.each([dim], function(val) {
			if (!isNaN(val)) dimDataArray.push(val);
		});
		var sortedDimDataArray = dimDataArray.sort(function(a, b) {
			return a - b;
		});
		var len$1 = this.count();
		return len$1 === 0 ? 0 : len$1 % 2 === 1 ? sortedDimDataArray[(len$1 - 1) / 2] : (sortedDimDataArray[len$1 / 2] + sortedDimDataArray[len$1 / 2 - 1]) / 2;
	};
	/**
	
	* Retrieve the index with given raw data index.
	
	*/
	DataStore$1.prototype.indexOfRawIndex = function(rawIndex) {
		if (rawIndex >= this._rawCount || rawIndex < 0) return -1;
		if (!this._indices) return rawIndex;
		var indices = this._indices;
		var rawDataIndex = indices[rawIndex];
		if (rawDataIndex != null && rawDataIndex < this._count && rawDataIndex === rawIndex) return rawIndex;
		var left = 0;
		var right = this._count - 1;
		while (left <= right) {
			var mid = (left + right) / 2 | 0;
			if (indices[mid] < rawIndex) left = mid + 1;
			else if (indices[mid] > rawIndex) right = mid - 1;
			else return mid;
		}
		return -1;
	};
	/**
	
	* Retrieve the index of nearest value.
	
	* @param dim
	
	* @param value
	
	* @param [maxDistance=Infinity]
	
	* @return If and only if multiple indices have
	
	*         the same value, they are put to the result.
	
	*/
	DataStore$1.prototype.indicesOfNearest = function(dim, value, maxDistance) {
		var chunks = this._chunks;
		var dimData = chunks[dim];
		var nearestIndices = [];
		if (!dimData) return nearestIndices;
		if (maxDistance == null) maxDistance = Infinity;
		var minDist = Infinity;
		var minDiff = -1;
		var nearestIndicesLen = 0;
		for (var i = 0, len$1 = this.count(); i < len$1; i++) {
			var dataIndex = this.getRawIndex(i);
			var diff = value - dimData[dataIndex];
			var dist$2 = Math.abs(diff);
			if (dist$2 <= maxDistance) {
				if (dist$2 < minDist || dist$2 === minDist && diff >= 0 && minDiff < 0) {
					minDist = dist$2;
					minDiff = diff;
					nearestIndicesLen = 0;
				}
				if (diff === minDiff) nearestIndices[nearestIndicesLen++] = i;
			}
		}
		nearestIndices.length = nearestIndicesLen;
		return nearestIndices;
	};
	DataStore$1.prototype.getIndices = function() {
		var newIndices;
		var indices = this._indices;
		if (indices) {
			var Ctor = indices.constructor;
			var thisCount = this._count;
			if (Ctor === Array) {
				newIndices = new Ctor(thisCount);
				for (var i = 0; i < thisCount; i++) newIndices[i] = indices[i];
			} else newIndices = new Ctor(indices.buffer, 0, thisCount);
		} else {
			var Ctor = getIndicesCtor(this._rawCount);
			newIndices = new Ctor(this.count());
			for (var i = 0; i < newIndices.length; i++) newIndices[i] = i;
		}
		return newIndices;
	};
	/**
	
	* Data filter.
	
	*/
	DataStore$1.prototype.filter = function(dims, cb) {
		if (!this._count) return this;
		var newStore = this.clone();
		var count = newStore.count();
		var Ctor = getIndicesCtor(newStore._rawCount);
		var newIndices = new Ctor(count);
		var value = [];
		var dimSize = dims.length;
		var offset = 0;
		var dim0 = dims[0];
		var chunks = newStore._chunks;
		for (var i = 0; i < count; i++) {
			var keep = void 0;
			var rawIdx = newStore.getRawIndex(i);
			if (dimSize === 0) keep = cb(i);
			else if (dimSize === 1) {
				var val = chunks[dim0][rawIdx];
				keep = cb(val, i);
			} else {
				var k = 0;
				for (; k < dimSize; k++) value[k] = chunks[dims[k]][rawIdx];
				value[k] = i;
				keep = cb.apply(null, value);
			}
			if (keep) newIndices[offset++] = rawIdx;
		}
		if (offset < count) newStore._indices = newIndices;
		newStore._count = offset;
		newStore._extent = [];
		newStore._updateGetRawIdx();
		return newStore;
	};
	/**
	
	* Select data in range. (For optimization of filter)
	
	* (Manually inline code, support 5 million data filtering in data zoom.)
	
	*/
	DataStore$1.prototype.selectRange = function(range) {
		var newStore = this.clone();
		var len$1 = newStore._count;
		if (!len$1) return this;
		var dims = keys(range);
		var dimSize = dims.length;
		if (!dimSize) return this;
		var originalCount = newStore.count();
		var Ctor = getIndicesCtor(newStore._rawCount);
		var newIndices = new Ctor(originalCount);
		var offset = 0;
		var dim0 = dims[0];
		var min$2 = range[dim0][0];
		var max$2 = range[dim0][1];
		var storeArr = newStore._chunks;
		var quickFinished = false;
		if (!newStore._indices) {
			var idx = 0;
			if (dimSize === 1) {
				var dimStorage = storeArr[dims[0]];
				for (var i = 0; i < len$1; i++) {
					var val = dimStorage[i];
					if (val >= min$2 && val <= max$2 || isNaN(val)) newIndices[offset++] = idx;
					idx++;
				}
				quickFinished = true;
			} else if (dimSize === 2) {
				var dimStorage = storeArr[dims[0]];
				var dimStorage2 = storeArr[dims[1]];
				var min2$1 = range[dims[1]][0];
				var max2$1 = range[dims[1]][1];
				for (var i = 0; i < len$1; i++) {
					var val = dimStorage[i];
					var val2 = dimStorage2[i];
					if ((val >= min$2 && val <= max$2 || isNaN(val)) && (val2 >= min2$1 && val2 <= max2$1 || isNaN(val2))) newIndices[offset++] = idx;
					idx++;
				}
				quickFinished = true;
			}
		}
		if (!quickFinished) if (dimSize === 1) for (var i = 0; i < originalCount; i++) {
			var rawIndex = newStore.getRawIndex(i);
			var val = storeArr[dims[0]][rawIndex];
			if (val >= min$2 && val <= max$2 || isNaN(val)) newIndices[offset++] = rawIndex;
		}
		else for (var i = 0; i < originalCount; i++) {
			var keep = true;
			var rawIndex = newStore.getRawIndex(i);
			for (var k = 0; k < dimSize; k++) {
				var dimk = dims[k];
				var val = storeArr[dimk][rawIndex];
				if (val < range[dimk][0] || val > range[dimk][1]) keep = false;
			}
			if (keep) newIndices[offset++] = newStore.getRawIndex(i);
		}
		if (offset < originalCount) newStore._indices = newIndices;
		newStore._count = offset;
		newStore._extent = [];
		newStore._updateGetRawIdx();
		return newStore;
	};
	/**
	
	* Data mapping to a new List with given dimensions
	
	*/
	DataStore$1.prototype.map = function(dims, cb) {
		var target = this.clone(dims);
		this._updateDims(target, dims, cb);
		return target;
	};
	/**
	
	* @caution Danger!! Only used in dataStack.
	
	*/
	DataStore$1.prototype.modify = function(dims, cb) {
		this._updateDims(this, dims, cb);
	};
	DataStore$1.prototype._updateDims = function(target, dims, cb) {
		var targetChunks = target._chunks;
		var tmpRetValue = [];
		var dimSize = dims.length;
		var dataCount = target.count();
		var values = [];
		var rawExtent = target._rawExtent;
		for (var i = 0; i < dims.length; i++) rawExtent[dims[i]] = getInitialExtent();
		for (var dataIndex = 0; dataIndex < dataCount; dataIndex++) {
			var rawIndex = target.getRawIndex(dataIndex);
			for (var k = 0; k < dimSize; k++) values[k] = targetChunks[dims[k]][rawIndex];
			values[dimSize] = dataIndex;
			var retValue = cb && cb.apply(null, values);
			if (retValue != null) {
				if (typeof retValue !== "object") {
					tmpRetValue[0] = retValue;
					retValue = tmpRetValue;
				}
				for (var i = 0; i < retValue.length; i++) {
					var dim = dims[i];
					var val = retValue[i];
					var rawExtentOnDim = rawExtent[dim];
					var dimStore = targetChunks[dim];
					if (dimStore) dimStore[rawIndex] = val;
					if (val < rawExtentOnDim[0]) rawExtentOnDim[0] = val;
					if (val > rawExtentOnDim[1]) rawExtentOnDim[1] = val;
				}
			}
		}
	};
	/**
	
	* Large data down sampling using largest-triangle-three-buckets
	
	* @param {string} valueDimension
	
	* @param {number} targetCount
	
	*/
	DataStore$1.prototype.lttbDownSample = function(valueDimension, rate) {
		var target = this.clone([valueDimension], true);
		var targetStorage = target._chunks;
		var dimStore = targetStorage[valueDimension];
		var len$1 = this.count();
		var sampledIndex = 0;
		var frameSize = Math.floor(1 / rate);
		var currentRawIndex = this.getRawIndex(0);
		var maxArea;
		var area;
		var nextRawIndex;
		var newIndices = new (getIndicesCtor(this._rawCount))(Math.min((Math.ceil(len$1 / frameSize) + 2) * 2, len$1));
		newIndices[sampledIndex++] = currentRawIndex;
		for (var i = 1; i < len$1 - 1; i += frameSize) {
			var nextFrameStart = Math.min(i + frameSize, len$1 - 1);
			var nextFrameEnd = Math.min(i + frameSize * 2, len$1);
			var avgX = (nextFrameEnd + nextFrameStart) / 2;
			var avgY = 0;
			for (var idx = nextFrameStart; idx < nextFrameEnd; idx++) {
				var rawIndex = this.getRawIndex(idx);
				var y = dimStore[rawIndex];
				if (isNaN(y)) continue;
				avgY += y;
			}
			avgY /= nextFrameEnd - nextFrameStart;
			var frameStart = i;
			var frameEnd = Math.min(i + frameSize, len$1);
			var pointAX = i - 1;
			var pointAY = dimStore[currentRawIndex];
			maxArea = -1;
			nextRawIndex = frameStart;
			var firstNaNIndex = -1;
			var countNaN = 0;
			for (var idx = frameStart; idx < frameEnd; idx++) {
				var rawIndex = this.getRawIndex(idx);
				var y = dimStore[rawIndex];
				if (isNaN(y)) {
					countNaN++;
					if (firstNaNIndex < 0) firstNaNIndex = rawIndex;
					continue;
				}
				area = Math.abs((pointAX - avgX) * (y - pointAY) - (pointAX - idx) * (avgY - pointAY));
				if (area > maxArea) {
					maxArea = area;
					nextRawIndex = rawIndex;
				}
			}
			if (countNaN > 0 && countNaN < frameEnd - frameStart) {
				newIndices[sampledIndex++] = Math.min(firstNaNIndex, nextRawIndex);
				nextRawIndex = Math.max(firstNaNIndex, nextRawIndex);
			}
			newIndices[sampledIndex++] = nextRawIndex;
			currentRawIndex = nextRawIndex;
		}
		newIndices[sampledIndex++] = this.getRawIndex(len$1 - 1);
		target._count = sampledIndex;
		target._indices = newIndices;
		target.getRawIndex = this._getRawIdx;
		return target;
	};
	/**
	
	* Large data down sampling using min-max
	
	* @param {string} valueDimension
	
	* @param {number} rate
	
	*/
	DataStore$1.prototype.minmaxDownSample = function(valueDimension, rate) {
		var target = this.clone([valueDimension], true);
		var targetStorage = target._chunks;
		var frameSize = Math.floor(1 / rate);
		var dimStore = targetStorage[valueDimension];
		var len$1 = this.count();
		var newIndices = new (getIndicesCtor(this._rawCount))(Math.ceil(len$1 / frameSize) * 2);
		var offset = 0;
		for (var i = 0; i < len$1; i += frameSize) {
			var minIndex = i;
			var minValue = dimStore[this.getRawIndex(minIndex)];
			var maxIndex = i;
			var maxValue = dimStore[this.getRawIndex(maxIndex)];
			var thisFrameSize = frameSize;
			if (i + frameSize > len$1) thisFrameSize = len$1 - i;
			for (var k = 0; k < thisFrameSize; k++) {
				var rawIndex = this.getRawIndex(i + k);
				var value = dimStore[rawIndex];
				if (value < minValue) {
					minValue = value;
					minIndex = i + k;
				}
				if (value > maxValue) {
					maxValue = value;
					maxIndex = i + k;
				}
			}
			var rawMinIndex = this.getRawIndex(minIndex);
			var rawMaxIndex = this.getRawIndex(maxIndex);
			if (minIndex < maxIndex) {
				newIndices[offset++] = rawMinIndex;
				newIndices[offset++] = rawMaxIndex;
			} else {
				newIndices[offset++] = rawMaxIndex;
				newIndices[offset++] = rawMinIndex;
			}
		}
		target._count = offset;
		target._indices = newIndices;
		target._updateGetRawIdx();
		return target;
	};
	/**
	
	* Large data down sampling on given dimension
	
	* @param sampleIndex Sample index for name and id
	
	*/
	DataStore$1.prototype.downSample = function(dimension, rate, sampleValue, sampleIndex) {
		var target = this.clone([dimension], true);
		var targetStorage = target._chunks;
		var frameValues = [];
		var frameSize = Math.floor(1 / rate);
		var dimStore = targetStorage[dimension];
		var len$1 = this.count();
		var rawExtentOnDim = target._rawExtent[dimension] = getInitialExtent();
		var newIndices = new (getIndicesCtor(this._rawCount))(Math.ceil(len$1 / frameSize));
		var offset = 0;
		for (var i = 0; i < len$1; i += frameSize) {
			if (frameSize > len$1 - i) {
				frameSize = len$1 - i;
				frameValues.length = frameSize;
			}
			for (var k = 0; k < frameSize; k++) {
				var dataIdx = this.getRawIndex(i + k);
				frameValues[k] = dimStore[dataIdx];
			}
			var value = sampleValue(frameValues);
			var sampleFrameIdx = this.getRawIndex(Math.min(i + sampleIndex(frameValues, value) || 0, len$1 - 1));
			dimStore[sampleFrameIdx] = value;
			if (value < rawExtentOnDim[0]) rawExtentOnDim[0] = value;
			if (value > rawExtentOnDim[1]) rawExtentOnDim[1] = value;
			newIndices[offset++] = sampleFrameIdx;
		}
		target._count = offset;
		target._indices = newIndices;
		target._updateGetRawIdx();
		return target;
	};
	/**
	
	* Data iteration
	
	* @param ctx default this
	
	* @example
	
	*  list.each('x', function (x, idx) {});
	
	*  list.each(['x', 'y'], function (x, y, idx) {});
	
	*  list.each(function (idx) {})
	
	*/
	DataStore$1.prototype.each = function(dims, cb) {
		if (!this._count) return;
		var dimSize = dims.length;
		var chunks = this._chunks;
		for (var i = 0, len$1 = this.count(); i < len$1; i++) {
			var rawIdx = this.getRawIndex(i);
			switch (dimSize) {
				case 0:
					cb(i);
					break;
				case 1:
					cb(chunks[dims[0]][rawIdx], i);
					break;
				case 2:
					cb(chunks[dims[0]][rawIdx], chunks[dims[1]][rawIdx], i);
					break;
				default:
					var k = 0;
					var value = [];
					for (; k < dimSize; k++) value[k] = chunks[dims[k]][rawIdx];
					value[k] = i;
					cb.apply(null, value);
			}
		}
	};
	/**
	
	* Get extent of data in one dimension
	
	*/
	DataStore$1.prototype.getDataExtent = function(dim) {
		var dimData = this._chunks[dim];
		var initialExtent = getInitialExtent();
		if (!dimData) return initialExtent;
		var currEnd = this.count();
		var useRaw = !this._indices;
		var dimExtent;
		if (useRaw) return this._rawExtent[dim].slice();
		dimExtent = this._extent[dim];
		if (dimExtent) return dimExtent.slice();
		dimExtent = initialExtent;
		var min$2 = dimExtent[0];
		var max$2 = dimExtent[1];
		for (var i = 0; i < currEnd; i++) {
			var rawIdx = this.getRawIndex(i);
			var value = dimData[rawIdx];
			value < min$2 && (min$2 = value);
			value > max$2 && (max$2 = value);
		}
		dimExtent = [min$2, max$2];
		this._extent[dim] = dimExtent;
		return dimExtent;
	};
	/**
	
	* Get raw data item
	
	*/
	DataStore$1.prototype.getRawDataItem = function(idx) {
		var rawIdx = this.getRawIndex(idx);
		if (!this._provider.persistent) {
			var val = [];
			var chunks = this._chunks;
			for (var i = 0; i < chunks.length; i++) val.push(chunks[i][rawIdx]);
			return val;
		} else return this._provider.getItem(rawIdx);
	};
	/**
	
	* Clone shallow.
	
	*
	
	* @param clonedDims Determine which dims to clone. Will share the data if not specified.
	
	*/
	DataStore$1.prototype.clone = function(clonedDims, ignoreIndices) {
		var target = new DataStore$1();
		var chunks = this._chunks;
		var clonedDimsMap = clonedDims && reduce(clonedDims, function(obj, dimIdx) {
			obj[dimIdx] = true;
			return obj;
		}, {});
		if (clonedDimsMap) for (var i = 0; i < chunks.length; i++) target._chunks[i] = !clonedDimsMap[i] ? chunks[i] : cloneChunk(chunks[i]);
		else target._chunks = chunks;
		this._copyCommonProps(target);
		if (!ignoreIndices) target._indices = this._cloneIndices();
		target._updateGetRawIdx();
		return target;
	};
	DataStore$1.prototype._copyCommonProps = function(target) {
		target._count = this._count;
		target._rawCount = this._rawCount;
		target._provider = this._provider;
		target._dimensions = this._dimensions;
		target._extent = clone$2(this._extent);
		target._rawExtent = clone$2(this._rawExtent);
	};
	DataStore$1.prototype._cloneIndices = function() {
		if (this._indices) {
			var Ctor = this._indices.constructor;
			var indices = void 0;
			if (Ctor === Array) {
				var thisCount = this._indices.length;
				indices = new Ctor(thisCount);
				for (var i = 0; i < thisCount; i++) indices[i] = this._indices[i];
			} else indices = new Ctor(this._indices);
			return indices;
		}
		return null;
	};
	DataStore$1.prototype._getRawIdxIdentity = function(idx) {
		return idx;
	};
	DataStore$1.prototype._getRawIdx = function(idx) {
		if (idx < this._count && idx >= 0) return this._indices[idx];
		return -1;
	};
	DataStore$1.prototype._updateGetRawIdx = function() {
		this.getRawIndex = this._indices ? this._getRawIdx : this._getRawIdxIdentity;
	};
	DataStore$1.internalField = function() {
		function getDimValueSimply(dataItem, property, dataIndex, dimIndex) {
			return parseDataValue(dataItem[dimIndex], this._dimensions[dimIndex]);
		}
		defaultDimValueGetters = {
			arrayRows: getDimValueSimply,
			objectRows: function(dataItem, property, dataIndex, dimIndex) {
				return parseDataValue(dataItem[property], this._dimensions[dimIndex]);
			},
			keyedColumns: getDimValueSimply,
			original: function(dataItem, property, dataIndex, dimIndex) {
				var value = dataItem && (dataItem.value == null ? dataItem : dataItem.value);
				return parseDataValue(value instanceof Array ? value[dimIndex] : value, this._dimensions[dimIndex]);
			},
			typedArray: function(dataItem, property, dataIndex, dimIndex) {
				return dataItem[dimIndex];
			}
		};
	}();
	return DataStore$1;
}();
var DataStore_default = DataStore;
var inner$9 = makeInner();
var dimTypeShort = {
	float: "f",
	int: "i",
	ordinal: "o",
	number: "n",
	time: "t"
};
/**

* Represents the dimension requirement of a series.

*

* NOTICE:

* When there are too many dimensions in dataset and many series, only the used dimensions

* (i.e., used by coord sys and declared in `series.encode`) are add to `dimensionDefineList`.

* But users may query data by other unused dimension names.

* In this case, users can only query data if and only if they have defined dimension names

* via ec option, so we provide `getDimensionIndexFromSource`, which only query them from

* `source` dimensions.

*/
var SeriesDataSchema = function() {
	function SeriesDataSchema$1(opt) {
		this.dimensions = opt.dimensions;
		this._dimOmitted = opt.dimensionOmitted;
		this.source = opt.source;
		this._fullDimCount = opt.fullDimensionCount;
		this._updateDimOmitted(opt.dimensionOmitted);
	}
	SeriesDataSchema$1.prototype.isDimensionOmitted = function() {
		return this._dimOmitted;
	};
	SeriesDataSchema$1.prototype._updateDimOmitted = function(dimensionOmitted) {
		this._dimOmitted = dimensionOmitted;
		if (!dimensionOmitted) return;
		if (!this._dimNameMap) this._dimNameMap = ensureSourceDimNameMap(this.source);
	};
	/**
	
	* @caution Can only be used when `dimensionOmitted: true`.
	
	*
	
	* Get index by user defined dimension name (i.e., not internal generate name).
	
	* That is, get index from `dimensionsDefine`.
	
	* If no `dimensionsDefine`, or no name get, return -1.
	
	*/
	SeriesDataSchema$1.prototype.getSourceDimensionIndex = function(dimName) {
		return retrieve2(this._dimNameMap.get(dimName), -1);
	};
	/**
	
	* @caution Can only be used when `dimensionOmitted: true`.
	
	*
	
	* Notice: may return `null`/`undefined` if user not specify dimension names.
	
	*/
	SeriesDataSchema$1.prototype.getSourceDimension = function(dimIndex) {
		var dimensionsDefine = this.source.dimensionsDefine;
		if (dimensionsDefine) return dimensionsDefine[dimIndex];
	};
	SeriesDataSchema$1.prototype.makeStoreSchema = function() {
		var dimCount = this._fullDimCount;
		var willRetrieveDataByName = shouldRetrieveDataByName(this.source);
		var makeHashStrict = !shouldOmitUnusedDimensions(dimCount);
		var dimHash = "";
		var dims = [];
		for (var fullDimIdx = 0, seriesDimIdx = 0; fullDimIdx < dimCount; fullDimIdx++) {
			var property = void 0;
			var type = void 0;
			var ordinalMeta = void 0;
			var seriesDimDef = this.dimensions[seriesDimIdx];
			if (seriesDimDef && seriesDimDef.storeDimIndex === fullDimIdx) {
				property = willRetrieveDataByName ? seriesDimDef.name : null;
				type = seriesDimDef.type;
				ordinalMeta = seriesDimDef.ordinalMeta;
				seriesDimIdx++;
			} else {
				var sourceDimDef = this.getSourceDimension(fullDimIdx);
				if (sourceDimDef) {
					property = willRetrieveDataByName ? sourceDimDef.name : null;
					type = sourceDimDef.type;
				}
			}
			dims.push({
				property,
				type,
				ordinalMeta
			});
			if (willRetrieveDataByName && property != null && (!seriesDimDef || !seriesDimDef.isCalculationCoord)) dimHash += makeHashStrict ? property.replace(/\`/g, "`1").replace(/\$/g, "`2") : property;
			dimHash += "$";
			dimHash += dimTypeShort[type] || "f";
			if (ordinalMeta) dimHash += ordinalMeta.uid;
			dimHash += "$";
		}
		var source = this.source;
		var hash = [
			source.seriesLayoutBy,
			source.startIndex,
			dimHash
		].join("$$");
		return {
			dimensions: dims,
			hash
		};
	};
	SeriesDataSchema$1.prototype.makeOutputDimensionNames = function() {
		var result = [];
		for (var fullDimIdx = 0, seriesDimIdx = 0; fullDimIdx < this._fullDimCount; fullDimIdx++) {
			var name_1 = void 0;
			var seriesDimDef = this.dimensions[seriesDimIdx];
			if (seriesDimDef && seriesDimDef.storeDimIndex === fullDimIdx) {
				if (!seriesDimDef.isCalculationCoord) name_1 = seriesDimDef.name;
				seriesDimIdx++;
			} else {
				var sourceDimDef = this.getSourceDimension(fullDimIdx);
				if (sourceDimDef) name_1 = sourceDimDef.name;
			}
			result.push(name_1);
		}
		return result;
	};
	SeriesDataSchema$1.prototype.appendCalculationDimension = function(dimDef) {
		this.dimensions.push(dimDef);
		dimDef.isCalculationCoord = true;
		this._fullDimCount++;
		this._updateDimOmitted(true);
	};
	return SeriesDataSchema$1;
}();
function isSeriesDataSchema(schema) {
	return schema instanceof SeriesDataSchema;
}
function createDimNameMap(dimsDef) {
	var dataDimNameMap = createHashMap();
	for (var i = 0; i < (dimsDef || []).length; i++) {
		var dimDefItemRaw = dimsDef[i];
		var userDimName = isObject$2(dimDefItemRaw) ? dimDefItemRaw.name : dimDefItemRaw;
		if (userDimName != null && dataDimNameMap.get(userDimName) == null) dataDimNameMap.set(userDimName, i);
	}
	return dataDimNameMap;
}
function ensureSourceDimNameMap(source) {
	var innerSource = inner$9(source);
	return innerSource.dimNameMap || (innerSource.dimNameMap = createDimNameMap(source.dimensionsDefine));
}
function shouldOmitUnusedDimensions(dimCount) {
	return dimCount > 30;
}
var isObject$1 = isObject$2;
var map = map$1;
var CtorInt32Array = typeof Int32Array === "undefined" ? Array : Int32Array;
var ID_PREFIX = "e\0\0";
var INDEX_NOT_FOUND = -1;
var TRANSFERABLE_PROPERTIES = [
	"hasItemOption",
	"_nameList",
	"_idList",
	"_invertedIndicesMap",
	"_dimSummary",
	"userOutput",
	"_rawData",
	"_dimValueGetter",
	"_nameDimIdx",
	"_idDimIdx",
	"_nameRepeatCount"
];
var CLONE_PROPERTIES = ["_approximateExtent"];
var prepareInvertedIndex;
var getId;
var getIdNameFromStore;
var normalizeDimensions;
var transferProperties;
var cloneListForMapAndSample;
var makeIdFromName;
var SeriesData = function() {
	/**
	
	* @param dimensionsInput.dimensions
	
	*        For example, ['someDimName', {name: 'someDimName', type: 'someDimType'}, ...].
	
	*        Dimensions should be concrete names like x, y, z, lng, lat, angle, radius
	
	*/
	function SeriesData$1(dimensionsInput, hostModel) {
		this.type = "list";
		this._dimOmitted = false;
		this._nameList = [];
		this._idList = [];
		this._visual = {};
		this._layout = {};
		this._itemVisuals = [];
		this._itemLayouts = [];
		this._graphicEls = [];
		this._approximateExtent = {};
		this._calculationInfo = {};
		this.hasItemOption = false;
		this.TRANSFERABLE_METHODS = [
			"cloneShallow",
			"downSample",
			"minmaxDownSample",
			"lttbDownSample",
			"map"
		];
		this.CHANGABLE_METHODS = ["filterSelf", "selectRange"];
		this.DOWNSAMPLE_METHODS = [
			"downSample",
			"minmaxDownSample",
			"lttbDownSample"
		];
		var dimensions;
		var assignStoreDimIdx = false;
		if (isSeriesDataSchema(dimensionsInput)) {
			dimensions = dimensionsInput.dimensions;
			this._dimOmitted = dimensionsInput.isDimensionOmitted();
			this._schema = dimensionsInput;
		} else {
			assignStoreDimIdx = true;
			dimensions = dimensionsInput;
		}
		dimensions = dimensions || ["x", "y"];
		var dimensionInfos = {};
		var dimensionNames = [];
		var invertedIndicesMap = {};
		var needsHasOwn = false;
		var emptyObj = {};
		for (var i = 0; i < dimensions.length; i++) {
			var dimInfoInput = dimensions[i];
			var dimensionInfo = isString(dimInfoInput) ? new SeriesDimensionDefine_default({ name: dimInfoInput }) : !(dimInfoInput instanceof SeriesDimensionDefine_default) ? new SeriesDimensionDefine_default(dimInfoInput) : dimInfoInput;
			var dimensionName = dimensionInfo.name;
			dimensionInfo.type = dimensionInfo.type || "float";
			if (!dimensionInfo.coordDim) {
				dimensionInfo.coordDim = dimensionName;
				dimensionInfo.coordDimIndex = 0;
			}
			var otherDims = dimensionInfo.otherDims = dimensionInfo.otherDims || {};
			dimensionNames.push(dimensionName);
			dimensionInfos[dimensionName] = dimensionInfo;
			if (emptyObj[dimensionName] != null) needsHasOwn = true;
			if (dimensionInfo.createInvertedIndices) invertedIndicesMap[dimensionName] = [];
			if (otherDims.itemName === 0) this._nameDimIdx = i;
			if (otherDims.itemId === 0) this._idDimIdx = i;
			if (assignStoreDimIdx) dimensionInfo.storeDimIndex = i;
		}
		this.dimensions = dimensionNames;
		this._dimInfos = dimensionInfos;
		this._initGetDimensionInfo(needsHasOwn);
		this.hostModel = hostModel;
		this._invertedIndicesMap = invertedIndicesMap;
		if (this._dimOmitted) {
			var dimIdxToName_1 = this._dimIdxToName = createHashMap();
			each$4(dimensionNames, function(dimName) {
				dimIdxToName_1.set(dimensionInfos[dimName].storeDimIndex, dimName);
			});
		}
	}
	/**
	
	*
	
	* Get concrete dimension name by dimension name or dimension index.
	
	* If input a dimension name, do not validate whether the dimension name exits.
	
	*
	
	* @caution
	
	* @param dim Must make sure the dimension is `SeriesDimensionLoose`.
	
	* Because only those dimensions will have auto-generated dimension names if not
	
	* have a user-specified name, and other dimensions will get a return of null/undefined.
	
	*
	
	* @notice Because of this reason, should better use `getDimensionIndex` instead, for examples:
	
	* ```js
	
	* const val = data.getStore().get(data.getDimensionIndex(dim), dataIdx);
	
	* ```
	
	*
	
	* @return Concrete dim name.
	
	*/
	SeriesData$1.prototype.getDimension = function(dim) {
		var dimIdx = this._recognizeDimIndex(dim);
		if (dimIdx == null) return dim;
		dimIdx = dim;
		if (!this._dimOmitted) return this.dimensions[dimIdx];
		var dimName = this._dimIdxToName.get(dimIdx);
		if (dimName != null) return dimName;
		var sourceDimDef = this._schema.getSourceDimension(dimIdx);
		if (sourceDimDef) return sourceDimDef.name;
	};
	/**
	
	* Get dimension index in data store. Return -1 if not found.
	
	* Can be used to index value from getRawValue.
	
	*/
	SeriesData$1.prototype.getDimensionIndex = function(dim) {
		var dimIdx = this._recognizeDimIndex(dim);
		if (dimIdx != null) return dimIdx;
		if (dim == null) return -1;
		var dimInfo = this._getDimInfo(dim);
		return dimInfo ? dimInfo.storeDimIndex : this._dimOmitted ? this._schema.getSourceDimensionIndex(dim) : -1;
	};
	/**
	
	* The meanings of the input parameter `dim`:
	
	*
	
	* + If dim is a number (e.g., `1`), it means the index of the dimension.
	
	*   For example, `getDimension(0)` will return 'x' or 'lng' or 'radius'.
	
	* + If dim is a number-like string (e.g., `"1"`):
	
	*     + If there is the same concrete dim name defined in `series.dimensions` or `dataset.dimensions`,
	
	*        it means that concrete name.
	
	*     + If not, it will be converted to a number, which means the index of the dimension.
	
	*        (why? because of the backward compatibility. We have been tolerating number-like string in
	
	*        dimension setting, although now it seems that it is not a good idea.)
	
	*     For example, `visualMap[i].dimension: "1"` is the same meaning as `visualMap[i].dimension: 1`,
	
	*     if no dimension name is defined as `"1"`.
	
	* + If dim is a not-number-like string, it means the concrete dim name.
	
	*   For example, it can be be default name `"x"`, `"y"`, `"z"`, `"lng"`, `"lat"`, `"angle"`, `"radius"`,
	
	*   or customized in `dimensions` property of option like `"age"`.
	
	*
	
	* @return recognized `DimensionIndex`. Otherwise return null/undefined (means that dim is `DimensionName`).
	
	*/
	SeriesData$1.prototype._recognizeDimIndex = function(dim) {
		if (isNumber(dim) || dim != null && !isNaN(dim) && !this._getDimInfo(dim) && (!this._dimOmitted || this._schema.getSourceDimensionIndex(dim) < 0)) return +dim;
	};
	SeriesData$1.prototype._getStoreDimIndex = function(dim) {
		var dimIdx = this.getDimensionIndex(dim);
		return dimIdx;
	};
	/**
	
	* Get type and calculation info of particular dimension
	
	* @param dim
	
	*        Dimension can be concrete names like x, y, z, lng, lat, angle, radius
	
	*        Or a ordinal number. For example getDimensionInfo(0) will return 'x' or 'lng' or 'radius'
	
	*/
	SeriesData$1.prototype.getDimensionInfo = function(dim) {
		return this._getDimInfo(this.getDimension(dim));
	};
	SeriesData$1.prototype._initGetDimensionInfo = function(needsHasOwn) {
		var dimensionInfos = this._dimInfos;
		this._getDimInfo = needsHasOwn ? function(dimName) {
			return dimensionInfos.hasOwnProperty(dimName) ? dimensionInfos[dimName] : void 0;
		} : function(dimName) {
			return dimensionInfos[dimName];
		};
	};
	/**
	
	* concrete dimension name list on coord.
	
	*/
	SeriesData$1.prototype.getDimensionsOnCoord = function() {
		return this._dimSummary.dataDimsOnCoord.slice();
	};
	SeriesData$1.prototype.mapDimension = function(coordDim, idx) {
		var dimensionsSummary = this._dimSummary;
		if (idx == null) return dimensionsSummary.encodeFirstDimNotExtra[coordDim];
		var dims = dimensionsSummary.encode[coordDim];
		return dims ? dims[idx] : null;
	};
	SeriesData$1.prototype.mapDimensionsAll = function(coordDim) {
		var dimensionsSummary = this._dimSummary;
		var dims = dimensionsSummary.encode[coordDim];
		return (dims || []).slice();
	};
	SeriesData$1.prototype.getStore = function() {
		return this._store;
	};
	/**
	
	* Initialize from data
	
	* @param data source or data or data store.
	
	* @param nameList The name of a datum is used on data diff and
	
	*        default label/tooltip.
	
	*        A name can be specified in encode.itemName,
	
	*        or dataItem.name (only for series option data),
	
	*        or provided in nameList from outside.
	
	*/
	SeriesData$1.prototype.initData = function(data, nameList, dimValueGetter) {
		var _this = this;
		var store;
		if (data instanceof DataStore_default) store = data;
		if (!store) {
			var dimensions = this.dimensions;
			var provider = isSourceInstance(data) || isArrayLike(data) ? new DefaultDataProvider(data, dimensions.length) : data;
			store = new DataStore_default();
			var dimensionInfos = map(dimensions, function(dimName) {
				return {
					type: _this._dimInfos[dimName].type,
					property: dimName
				};
			});
			store.initData(provider, dimensionInfos, dimValueGetter);
		}
		this._store = store;
		this._nameList = (nameList || []).slice();
		this._idList = [];
		this._nameRepeatCount = {};
		this._doInit(0, store.count());
		this._dimSummary = summarizeDimensions(this, this._schema);
		this.userOutput = this._dimSummary.userOutput;
	};
	/**
	
	* Caution: Can be only called on raw data (before `this._indices` created).
	
	*/
	SeriesData$1.prototype.appendData = function(data) {
		var range = this._store.appendData(data);
		this._doInit(range[0], range[1]);
	};
	/**
	
	* Caution: Can be only called on raw data (before `this._indices` created).
	
	* This method does not modify `rawData` (`dataProvider`), but only
	
	* add values to store.
	
	*
	
	* The final count will be increased by `Math.max(values.length, names.length)`.
	
	*
	
	* @param values That is the SourceType: 'arrayRows', like
	
	*        [
	
	*            [12, 33, 44],
	
	*            [NaN, 43, 1],
	
	*            ['-', 'asdf', 0]
	
	*        ]
	
	*        Each item is exactly corresponding to a dimension.
	
	*/
	SeriesData$1.prototype.appendValues = function(values, names) {
		var _a$1 = this._store.appendValues(values, names && names.length), start$1 = _a$1.start, end$1 = _a$1.end;
		var shouldMakeIdFromName = this._shouldMakeIdFromName();
		this._updateOrdinalMeta();
		if (names) for (var idx = start$1; idx < end$1; idx++) {
			var sourceIdx = idx - start$1;
			this._nameList[idx] = names[sourceIdx];
			if (shouldMakeIdFromName) makeIdFromName(this, idx);
		}
	};
	SeriesData$1.prototype._updateOrdinalMeta = function() {
		var store = this._store;
		var dimensions = this.dimensions;
		for (var i = 0; i < dimensions.length; i++) {
			var dimInfo = this._dimInfos[dimensions[i]];
			if (dimInfo.ordinalMeta) store.collectOrdinalMeta(dimInfo.storeDimIndex, dimInfo.ordinalMeta);
		}
	};
	SeriesData$1.prototype._shouldMakeIdFromName = function() {
		var provider = this._store.getProvider();
		return this._idDimIdx == null && provider.getSource().sourceFormat !== SOURCE_FORMAT_TYPED_ARRAY && !provider.fillStorage;
	};
	SeriesData$1.prototype._doInit = function(start$1, end$1) {
		if (start$1 >= end$1) return;
		var store = this._store;
		var provider = store.getProvider();
		this._updateOrdinalMeta();
		var nameList = this._nameList;
		var idList = this._idList;
		var sourceFormat = provider.getSource().sourceFormat;
		var isFormatOriginal = sourceFormat === SOURCE_FORMAT_ORIGINAL;
		if (isFormatOriginal && !provider.pure) {
			var sharedDataItem = [];
			for (var idx = start$1; idx < end$1; idx++) {
				var dataItem = provider.getItem(idx, sharedDataItem);
				if (!this.hasItemOption && isDataItemOption(dataItem)) this.hasItemOption = true;
				if (dataItem) {
					var itemName = dataItem.name;
					if (nameList[idx] == null && itemName != null) nameList[idx] = convertOptionIdName(itemName, null);
					var itemId = dataItem.id;
					if (idList[idx] == null && itemId != null) idList[idx] = convertOptionIdName(itemId, null);
				}
			}
		}
		if (this._shouldMakeIdFromName()) for (var idx = start$1; idx < end$1; idx++) makeIdFromName(this, idx);
		prepareInvertedIndex(this);
	};
	/**
	
	* PENDING: In fact currently this function is only used to short-circuit
	
	* the calling of `scale.unionExtentFromData` when data have been filtered by modules
	
	* like "dataZoom". `scale.unionExtentFromData` is used to calculate data extent for series on
	
	* an axis, but if a "axis related data filter module" is used, the extent of the axis have
	
	* been fixed and no need to calling `scale.unionExtentFromData` actually.
	
	* But if we add "custom data filter" in future, which is not "axis related", this method may
	
	* be still needed.
	
	*
	
	* Optimize for the scenario that data is filtered by a given extent.
	
	* Consider that if data amount is more than hundreds of thousand,
	
	* extent calculation will cost more than 10ms and the cache will
	
	* be erased because of the filtering.
	
	*/
	SeriesData$1.prototype.getApproximateExtent = function(dim) {
		return this._approximateExtent[dim] || this._store.getDataExtent(this._getStoreDimIndex(dim));
	};
	/**
	
	* Calculate extent on a filtered data might be time consuming.
	
	* Approximate extent is only used for: calculate extent of filtered data outside.
	
	*/
	SeriesData$1.prototype.setApproximateExtent = function(extent$1, dim) {
		dim = this.getDimension(dim);
		this._approximateExtent[dim] = extent$1.slice();
	};
	SeriesData$1.prototype.getCalculationInfo = function(key) {
		return this._calculationInfo[key];
	};
	SeriesData$1.prototype.setCalculationInfo = function(key, value) {
		isObject$1(key) ? extend(this._calculationInfo, key) : this._calculationInfo[key] = value;
	};
	/**
	
	* @return Never be null/undefined. `number` will be converted to string. Because:
	
	* In most cases, name is used in display, where returning a string is more convenient.
	
	* In other cases, name is used in query (see `indexOfName`), where we can keep the
	
	* rule that name `2` equals to name `'2'`.
	
	*/
	SeriesData$1.prototype.getName = function(idx) {
		var rawIndex = this.getRawIndex(idx);
		var name = this._nameList[rawIndex];
		if (name == null && this._nameDimIdx != null) name = getIdNameFromStore(this, this._nameDimIdx, rawIndex);
		if (name == null) name = "";
		return name;
	};
	SeriesData$1.prototype._getCategory = function(dimIdx, idx) {
		var ordinal = this._store.get(dimIdx, idx);
		var ordinalMeta = this._store.getOrdinalMeta(dimIdx);
		if (ordinalMeta) return ordinalMeta.categories[ordinal];
		return ordinal;
	};
	/**
	
	* @return Never null/undefined. `number` will be converted to string. Because:
	
	* In all cases having encountered at present, id is used in making diff comparison, which
	
	* are usually based on hash map. We can keep the rule that the internal id are always string
	
	* (treat `2` is the same as `'2'`) to make the related logic simple.
	
	*/
	SeriesData$1.prototype.getId = function(idx) {
		return getId(this, this.getRawIndex(idx));
	};
	SeriesData$1.prototype.count = function() {
		return this._store.count();
	};
	/**
	
	* Get value. Return NaN if idx is out of range.
	
	*
	
	* @notice Should better to use `data.getStore().get(dimIndex, dataIdx)` instead.
	
	*/
	SeriesData$1.prototype.get = function(dim, idx) {
		var store = this._store;
		var dimInfo = this._dimInfos[dim];
		if (dimInfo) return store.get(dimInfo.storeDimIndex, idx);
	};
	/**
	
	* @notice Should better to use `data.getStore().getByRawIndex(dimIndex, dataIdx)` instead.
	
	*/
	SeriesData$1.prototype.getByRawIndex = function(dim, rawIdx) {
		var store = this._store;
		var dimInfo = this._dimInfos[dim];
		if (dimInfo) return store.getByRawIndex(dimInfo.storeDimIndex, rawIdx);
	};
	SeriesData$1.prototype.getIndices = function() {
		return this._store.getIndices();
	};
	SeriesData$1.prototype.getDataExtent = function(dim) {
		return this._store.getDataExtent(this._getStoreDimIndex(dim));
	};
	SeriesData$1.prototype.getSum = function(dim) {
		return this._store.getSum(this._getStoreDimIndex(dim));
	};
	SeriesData$1.prototype.getMedian = function(dim) {
		return this._store.getMedian(this._getStoreDimIndex(dim));
	};
	SeriesData$1.prototype.getValues = function(dimensions, idx) {
		var _this = this;
		var store = this._store;
		return isArray(dimensions) ? store.getValues(map(dimensions, function(dim) {
			return _this._getStoreDimIndex(dim);
		}), idx) : store.getValues(dimensions);
	};
	/**
	
	* If value is NaN. Including '-'
	
	* Only check the coord dimensions.
	
	*/
	SeriesData$1.prototype.hasValue = function(idx) {
		var dataDimIndicesOnCoord = this._dimSummary.dataDimIndicesOnCoord;
		for (var i = 0, len$1 = dataDimIndicesOnCoord.length; i < len$1; i++) if (isNaN(this._store.get(dataDimIndicesOnCoord[i], idx))) return false;
		return true;
	};
	/**
	
	* Retrieve the index with given name
	
	*/
	SeriesData$1.prototype.indexOfName = function(name) {
		for (var i = 0, len$1 = this._store.count(); i < len$1; i++) if (this.getName(i) === name) return i;
		return -1;
	};
	SeriesData$1.prototype.getRawIndex = function(idx) {
		return this._store.getRawIndex(idx);
	};
	SeriesData$1.prototype.indexOfRawIndex = function(rawIndex) {
		return this._store.indexOfRawIndex(rawIndex);
	};
	/**
	
	* Only support the dimension which inverted index created.
	
	* Do not support other cases until required.
	
	* @param dim concrete dim
	
	* @param value ordinal index
	
	* @return rawIndex
	
	*/
	SeriesData$1.prototype.rawIndexOf = function(dim, value) {
		var invertedIndices = dim && this._invertedIndicesMap[dim];
		var rawIndex = invertedIndices && invertedIndices[value];
		if (rawIndex == null || isNaN(rawIndex)) return INDEX_NOT_FOUND;
		return rawIndex;
	};
	/**
	
	* Retrieve the index of nearest value
	
	* @param dim
	
	* @param value
	
	* @param [maxDistance=Infinity]
	
	* @return If and only if multiple indices has
	
	*         the same value, they are put to the result.
	
	*/
	SeriesData$1.prototype.indicesOfNearest = function(dim, value, maxDistance) {
		return this._store.indicesOfNearest(this._getStoreDimIndex(dim), value, maxDistance);
	};
	SeriesData$1.prototype.each = function(dims, cb, ctx) {
		"use strict";
		if (isFunction(dims)) {
			ctx = cb;
			cb = dims;
			dims = [];
		}
		var fCtx = ctx || this;
		var dimIndices = map(normalizeDimensions(dims), this._getStoreDimIndex, this);
		this._store.each(dimIndices, fCtx ? bind$1(cb, fCtx) : cb);
	};
	SeriesData$1.prototype.filterSelf = function(dims, cb, ctx) {
		"use strict";
		if (isFunction(dims)) {
			ctx = cb;
			cb = dims;
			dims = [];
		}
		var fCtx = ctx || this;
		var dimIndices = map(normalizeDimensions(dims), this._getStoreDimIndex, this);
		this._store = this._store.filter(dimIndices, fCtx ? bind$1(cb, fCtx) : cb);
		return this;
	};
	/**
	
	* Select data in range. (For optimization of filter)
	
	* (Manually inline code, support 5 million data filtering in data zoom.)
	
	*/
	SeriesData$1.prototype.selectRange = function(range) {
		"use strict";
		var _this = this;
		var innerRange = {};
		var dims = keys(range);
		var dimIndices = [];
		each$4(dims, function(dim) {
			var dimIdx = _this._getStoreDimIndex(dim);
			innerRange[dimIdx] = range[dim];
			dimIndices.push(dimIdx);
		});
		this._store = this._store.selectRange(innerRange);
		return this;
	};
	SeriesData$1.prototype.mapArray = function(dims, cb, ctx) {
		"use strict";
		if (isFunction(dims)) {
			ctx = cb;
			cb = dims;
			dims = [];
		}
		ctx = ctx || this;
		var result = [];
		this.each(dims, function() {
			result.push(cb && cb.apply(this, arguments));
		}, ctx);
		return result;
	};
	SeriesData$1.prototype.map = function(dims, cb, ctx, ctxCompat) {
		"use strict";
		var fCtx = ctx || ctxCompat || this;
		var dimIndices = map(normalizeDimensions(dims), this._getStoreDimIndex, this);
		var list = cloneListForMapAndSample(this);
		list._store = this._store.map(dimIndices, fCtx ? bind$1(cb, fCtx) : cb);
		return list;
	};
	SeriesData$1.prototype.modify = function(dims, cb, ctx, ctxCompat) {
		var _this = this;
		var fCtx = ctx || ctxCompat || this;
		var dimIndices = map(normalizeDimensions(dims), this._getStoreDimIndex, this);
		this._store.modify(dimIndices, fCtx ? bind$1(cb, fCtx) : cb);
	};
	/**
	
	* Large data down sampling on given dimension
	
	* @param sampleIndex Sample index for name and id
	
	*/
	SeriesData$1.prototype.downSample = function(dimension, rate, sampleValue, sampleIndex) {
		var list = cloneListForMapAndSample(this);
		list._store = this._store.downSample(this._getStoreDimIndex(dimension), rate, sampleValue, sampleIndex);
		return list;
	};
	/**
	
	* Large data down sampling using min-max
	
	* @param {string} valueDimension
	
	* @param {number} rate
	
	*/
	SeriesData$1.prototype.minmaxDownSample = function(valueDimension, rate) {
		var list = cloneListForMapAndSample(this);
		list._store = this._store.minmaxDownSample(this._getStoreDimIndex(valueDimension), rate);
		return list;
	};
	/**
	
	* Large data down sampling using largest-triangle-three-buckets
	
	* @param {string} valueDimension
	
	* @param {number} targetCount
	
	*/
	SeriesData$1.prototype.lttbDownSample = function(valueDimension, rate) {
		var list = cloneListForMapAndSample(this);
		list._store = this._store.lttbDownSample(this._getStoreDimIndex(valueDimension), rate);
		return list;
	};
	SeriesData$1.prototype.getRawDataItem = function(idx) {
		return this._store.getRawDataItem(idx);
	};
	/**
	
	* Get model of one data item.
	
	*/
	SeriesData$1.prototype.getItemModel = function(idx) {
		var hostModel = this.hostModel;
		var dataItem = this.getRawDataItem(idx);
		return new Model_default(dataItem, hostModel, hostModel && hostModel.ecModel);
	};
	/**
	
	* Create a data differ
	
	*/
	SeriesData$1.prototype.diff = function(otherList) {
		var thisList = this;
		return new DataDiffer_default(otherList ? otherList.getStore().getIndices() : [], this.getStore().getIndices(), function(idx) {
			return getId(otherList, idx);
		}, function(idx) {
			return getId(thisList, idx);
		});
	};
	/**
	
	* Get visual property.
	
	*/
	SeriesData$1.prototype.getVisual = function(key) {
		var visual = this._visual;
		return visual && visual[key];
	};
	SeriesData$1.prototype.setVisual = function(kvObj, val) {
		this._visual = this._visual || {};
		if (isObject$1(kvObj)) extend(this._visual, kvObj);
		else this._visual[kvObj] = val;
	};
	/**
	
	* Get visual property of single data item
	
	*/
	SeriesData$1.prototype.getItemVisual = function(idx, key) {
		var itemVisual = this._itemVisuals[idx];
		var val = itemVisual && itemVisual[key];
		if (val == null) return this.getVisual(key);
		return val;
	};
	/**
	
	* If exists visual property of single data item
	
	*/
	SeriesData$1.prototype.hasItemVisual = function() {
		return this._itemVisuals.length > 0;
	};
	/**
	
	* Make sure itemVisual property is unique
	
	*/
	SeriesData$1.prototype.ensureUniqueItemVisual = function(idx, key) {
		var itemVisuals = this._itemVisuals;
		var itemVisual = itemVisuals[idx];
		if (!itemVisual) itemVisual = itemVisuals[idx] = {};
		var val = itemVisual[key];
		if (val == null) {
			val = this.getVisual(key);
			if (isArray(val)) val = val.slice();
			else if (isObject$1(val)) val = extend({}, val);
			itemVisual[key] = val;
		}
		return val;
	};
	SeriesData$1.prototype.setItemVisual = function(idx, key, value) {
		var itemVisual = this._itemVisuals[idx] || {};
		this._itemVisuals[idx] = itemVisual;
		if (isObject$1(key)) extend(itemVisual, key);
		else itemVisual[key] = value;
	};
	/**
	
	* Clear itemVisuals and list visual.
	
	*/
	SeriesData$1.prototype.clearAllVisual = function() {
		this._visual = {};
		this._itemVisuals = [];
	};
	SeriesData$1.prototype.setLayout = function(key, val) {
		isObject$1(key) ? extend(this._layout, key) : this._layout[key] = val;
	};
	/**
	
	* Get layout property.
	
	*/
	SeriesData$1.prototype.getLayout = function(key) {
		return this._layout[key];
	};
	/**
	
	* Get layout of single data item
	
	*/
	SeriesData$1.prototype.getItemLayout = function(idx) {
		return this._itemLayouts[idx];
	};
	/**
	
	* Set layout of single data item
	
	*/
	SeriesData$1.prototype.setItemLayout = function(idx, layout$2, merge$1) {
		this._itemLayouts[idx] = merge$1 ? extend(this._itemLayouts[idx] || {}, layout$2) : layout$2;
	};
	/**
	
	* Clear all layout of single data item
	
	*/
	SeriesData$1.prototype.clearItemLayouts = function() {
		this._itemLayouts.length = 0;
	};
	/**
	
	* Set graphic element relative to data. It can be set as null
	
	*/
	SeriesData$1.prototype.setItemGraphicEl = function(idx, el) {
		var seriesIndex = this.hostModel && this.hostModel.seriesIndex;
		setCommonECData(seriesIndex, this.dataType, idx, el);
		this._graphicEls[idx] = el;
	};
	SeriesData$1.prototype.getItemGraphicEl = function(idx) {
		return this._graphicEls[idx];
	};
	SeriesData$1.prototype.eachItemGraphicEl = function(cb, context) {
		each$4(this._graphicEls, function(el, idx) {
			if (el) cb && cb.call(context, el, idx);
		});
	};
	/**
	
	* Shallow clone a new list except visual and layout properties, and graph elements.
	
	* New list only change the indices.
	
	*/
	SeriesData$1.prototype.cloneShallow = function(list) {
		if (!list) list = new SeriesData$1(this._schema ? this._schema : map(this.dimensions, this._getDimInfo, this), this.hostModel);
		transferProperties(list, this);
		list._store = this._store;
		return list;
	};
	/**
	
	* Wrap some method to add more feature
	
	*/
	SeriesData$1.prototype.wrapMethod = function(methodName, injectFunction) {
		var originalMethod = this[methodName];
		if (!isFunction(originalMethod)) return;
		this.__wrappedMethods = this.__wrappedMethods || [];
		this.__wrappedMethods.push(methodName);
		this[methodName] = function() {
			var res = originalMethod.apply(this, arguments);
			return injectFunction.apply(this, [res].concat(slice(arguments)));
		};
	};
	SeriesData$1.internalField = function() {
		prepareInvertedIndex = function(data) {
			var invertedIndicesMap = data._invertedIndicesMap;
			each$4(invertedIndicesMap, function(invertedIndices, dim) {
				var dimInfo = data._dimInfos[dim];
				var ordinalMeta = dimInfo.ordinalMeta;
				var store = data._store;
				if (ordinalMeta) {
					invertedIndices = invertedIndicesMap[dim] = new CtorInt32Array(ordinalMeta.categories.length);
					for (var i = 0; i < invertedIndices.length; i++) invertedIndices[i] = INDEX_NOT_FOUND;
					for (var i = 0; i < store.count(); i++) invertedIndices[store.get(dimInfo.storeDimIndex, i)] = i;
				}
			});
		};
		getIdNameFromStore = function(data, dimIdx, idx) {
			return convertOptionIdName(data._getCategory(dimIdx, idx), null);
		};
		/**
		
		* @see the comment of `List['getId']`.
		
		*/
		getId = function(data, rawIndex) {
			var id = data._idList[rawIndex];
			if (id == null && data._idDimIdx != null) id = getIdNameFromStore(data, data._idDimIdx, rawIndex);
			if (id == null) id = ID_PREFIX + rawIndex;
			return id;
		};
		normalizeDimensions = function(dimensions) {
			if (!isArray(dimensions)) dimensions = dimensions != null ? [dimensions] : [];
			return dimensions;
		};
		/**
		
		* Data in excludeDimensions is copied, otherwise transferred.
		
		*/
		cloneListForMapAndSample = function(original) {
			var list = new SeriesData$1(original._schema ? original._schema : map(original.dimensions, original._getDimInfo, original), original.hostModel);
			transferProperties(list, original);
			return list;
		};
		transferProperties = function(target, source) {
			each$4(TRANSFERABLE_PROPERTIES.concat(source.__wrappedMethods || []), function(propName) {
				if (source.hasOwnProperty(propName)) target[propName] = source[propName];
			});
			target.__wrappedMethods = source.__wrappedMethods;
			each$4(CLONE_PROPERTIES, function(propName) {
				target[propName] = clone$2(source[propName]);
			});
			target._calculationInfo = extend({}, source._calculationInfo);
		};
		makeIdFromName = function(data, idx) {
			var nameList = data._nameList;
			var idList = data._idList;
			var nameDimIdx = data._nameDimIdx;
			var idDimIdx = data._idDimIdx;
			var name = nameList[idx];
			var id = idList[idx];
			if (name == null && nameDimIdx != null) nameList[idx] = name = getIdNameFromStore(data, nameDimIdx, idx);
			if (id == null && idDimIdx != null) idList[idx] = id = getIdNameFromStore(data, idDimIdx, idx);
			if (id == null && name != null) {
				var nameRepeatCount = data._nameRepeatCount;
				var nmCnt = nameRepeatCount[name] = (nameRepeatCount[name] || 0) + 1;
				id = name;
				if (nmCnt > 1) id += "__ec__" + nmCnt;
				idList[idx] = id;
			}
		};
	}();
	return SeriesData$1;
}();
var SeriesData_default = SeriesData;
function prepareSeriesDataSchema(source, opt) {
	if (!isSourceInstance(source)) source = createSourceFromSeriesDataOption(source);
	opt = opt || {};
	var sysDims = opt.coordDimensions || [];
	var dimsDef = opt.dimensionsDefine || source.dimensionsDefine || [];
	var coordDimNameMap = createHashMap();
	var resultList = [];
	var dimCount = getDimCount(source, sysDims, dimsDef, opt.dimensionsCount);
	var omitUnusedDimensions = opt.canOmitUnusedDimensions && shouldOmitUnusedDimensions(dimCount);
	var isUsingSourceDimensionsDef = dimsDef === source.dimensionsDefine;
	var dataDimNameMap = isUsingSourceDimensionsDef ? ensureSourceDimNameMap(source) : createDimNameMap(dimsDef);
	var encodeDef = opt.encodeDefine;
	if (!encodeDef && opt.encodeDefaulter) encodeDef = opt.encodeDefaulter(source, dimCount);
	var encodeDefMap = createHashMap(encodeDef);
	var indicesMap = new CtorInt32Array$1(dimCount);
	for (var i = 0; i < indicesMap.length; i++) indicesMap[i] = -1;
	function getResultItem(dimIdx) {
		var idx = indicesMap[dimIdx];
		if (idx < 0) {
			var dimDefItemRaw = dimsDef[dimIdx];
			var dimDefItem = isObject$2(dimDefItemRaw) ? dimDefItemRaw : { name: dimDefItemRaw };
			var resultItem$1 = new SeriesDimensionDefine_default();
			var userDimName = dimDefItem.name;
			if (userDimName != null && dataDimNameMap.get(userDimName) != null) resultItem$1.name = resultItem$1.displayName = userDimName;
			dimDefItem.type != null && (resultItem$1.type = dimDefItem.type);
			dimDefItem.displayName != null && (resultItem$1.displayName = dimDefItem.displayName);
			var newIdx = resultList.length;
			indicesMap[dimIdx] = newIdx;
			resultItem$1.storeDimIndex = dimIdx;
			resultList.push(resultItem$1);
			return resultItem$1;
		}
		return resultList[idx];
	}
	if (!omitUnusedDimensions) for (var i = 0; i < dimCount; i++) getResultItem(i);
	encodeDefMap.each(function(dataDimsRaw, coordDim$1) {
		var dataDims = normalizeToArray(dataDimsRaw).slice();
		if (dataDims.length === 1 && !isString(dataDims[0]) && dataDims[0] < 0) {
			encodeDefMap.set(coordDim$1, false);
			return;
		}
		var validDataDims = encodeDefMap.set(coordDim$1, []);
		each$4(dataDims, function(resultDimIdxOrName, idx) {
			var resultDimIdx$1 = isString(resultDimIdxOrName) ? dataDimNameMap.get(resultDimIdxOrName) : resultDimIdxOrName;
			if (resultDimIdx$1 != null && resultDimIdx$1 < dimCount) {
				validDataDims[idx] = resultDimIdx$1;
				applyDim(getResultItem(resultDimIdx$1), coordDim$1, idx);
			}
		});
	});
	var availDimIdx = 0;
	each$4(sysDims, function(sysDimItemRaw) {
		var coordDim$1;
		var sysDimItemDimsDef;
		var sysDimItemOtherDims;
		var sysDimItem;
		if (isString(sysDimItemRaw)) {
			coordDim$1 = sysDimItemRaw;
			sysDimItem = {};
		} else {
			sysDimItem = sysDimItemRaw;
			coordDim$1 = sysDimItem.name;
			var ordinalMeta = sysDimItem.ordinalMeta;
			sysDimItem.ordinalMeta = null;
			sysDimItem = extend({}, sysDimItem);
			sysDimItem.ordinalMeta = ordinalMeta;
			sysDimItemDimsDef = sysDimItem.dimsDef;
			sysDimItemOtherDims = sysDimItem.otherDims;
			sysDimItem.name = sysDimItem.coordDim = sysDimItem.coordDimIndex = sysDimItem.dimsDef = sysDimItem.otherDims = null;
		}
		var dataDims = encodeDefMap.get(coordDim$1);
		if (dataDims === false) return;
		dataDims = normalizeToArray(dataDims);
		if (!dataDims.length) for (var i$1 = 0; i$1 < (sysDimItemDimsDef && sysDimItemDimsDef.length || 1); i$1++) {
			while (availDimIdx < dimCount && getResultItem(availDimIdx).coordDim != null) availDimIdx++;
			availDimIdx < dimCount && dataDims.push(availDimIdx++);
		}
		each$4(dataDims, function(resultDimIdx$1, coordDimIndex) {
			var resultItem$1 = getResultItem(resultDimIdx$1);
			if (isUsingSourceDimensionsDef && sysDimItem.type != null) resultItem$1.type = sysDimItem.type;
			applyDim(defaults(resultItem$1, sysDimItem), coordDim$1, coordDimIndex);
			if (resultItem$1.name == null && sysDimItemDimsDef) {
				var sysDimItemDimsDefItem = sysDimItemDimsDef[coordDimIndex];
				!isObject$2(sysDimItemDimsDefItem) && (sysDimItemDimsDefItem = { name: sysDimItemDimsDefItem });
				resultItem$1.name = resultItem$1.displayName = sysDimItemDimsDefItem.name;
				resultItem$1.defaultTooltip = sysDimItemDimsDefItem.defaultTooltip;
			}
			sysDimItemOtherDims && defaults(resultItem$1.otherDims, sysDimItemOtherDims);
		});
	});
	function applyDim(resultItem$1, coordDim$1, coordDimIndex) {
		if (VISUAL_DIMENSIONS.get(coordDim$1) != null) resultItem$1.otherDims[coordDim$1] = coordDimIndex;
		else {
			resultItem$1.coordDim = coordDim$1;
			resultItem$1.coordDimIndex = coordDimIndex;
			coordDimNameMap.set(coordDim$1, true);
		}
	}
	var generateCoord = opt.generateCoord;
	var generateCoordCount = opt.generateCoordCount;
	var fromZero = generateCoordCount != null;
	generateCoordCount = generateCoord ? generateCoordCount || 1 : 0;
	var extra = generateCoord || "value";
	function ifNoNameFillWithCoordName(resultItem$1) {
		if (resultItem$1.name == null) resultItem$1.name = resultItem$1.coordDim;
	}
	if (!omitUnusedDimensions) for (var resultDimIdx = 0; resultDimIdx < dimCount; resultDimIdx++) {
		var resultItem = getResultItem(resultDimIdx);
		var coordDim = resultItem.coordDim;
		if (coordDim == null) {
			resultItem.coordDim = genCoordDimName(extra, coordDimNameMap, fromZero);
			resultItem.coordDimIndex = 0;
			if (!generateCoord || generateCoordCount <= 0) resultItem.isExtraCoord = true;
			generateCoordCount--;
		}
		ifNoNameFillWithCoordName(resultItem);
		if (resultItem.type == null && (guessOrdinal(source, resultDimIdx) === BE_ORDINAL.Must || resultItem.isExtraCoord && (resultItem.otherDims.itemName != null || resultItem.otherDims.seriesName != null))) resultItem.type = "ordinal";
	}
	else {
		each$4(resultList, function(resultItem$1) {
			ifNoNameFillWithCoordName(resultItem$1);
		});
		resultList.sort(function(item0, item1) {
			return item0.storeDimIndex - item1.storeDimIndex;
		});
	}
	removeDuplication(resultList);
	return new SeriesDataSchema({
		source,
		dimensions: resultList,
		fullDimensionCount: dimCount,
		dimensionOmitted: omitUnusedDimensions
	});
}
function removeDuplication(result) {
	var duplicationMap = createHashMap();
	for (var i = 0; i < result.length; i++) {
		var dim = result[i];
		var dimOriginalName = dim.name;
		var count = duplicationMap.get(dimOriginalName) || 0;
		if (count > 0) dim.name = dimOriginalName + (count - 1);
		count++;
		duplicationMap.set(dimOriginalName, count);
	}
}
function getDimCount(source, sysDims, dimsDef, optDimCount) {
	var dimCount = Math.max(source.dimensionsDetectedCount || 1, sysDims.length, dimsDef.length, optDimCount || 0);
	each$4(sysDims, function(sysDimItem) {
		var sysDimItemDimsDef;
		if (isObject$2(sysDimItem) && (sysDimItemDimsDef = sysDimItem.dimsDef)) dimCount = Math.max(dimCount, sysDimItemDimsDef.length);
	});
	return dimCount;
}
function genCoordDimName(name, map$2, fromZero) {
	if (fromZero || map$2.hasKey(name)) {
		var i = 0;
		while (map$2.hasKey(name + i)) i++;
		name += i;
	}
	map$2.set(name, true);
	return name;
}
var coordinateSystemCreators = {};
var CoordinateSystemManager = function() {
	function CoordinateSystemManager$1() {
		this._coordinateSystems = [];
	}
	CoordinateSystemManager$1.prototype.create = function(ecModel, api) {
		var coordinateSystems = [];
		each$4(coordinateSystemCreators, function(creator, type) {
			var list = creator.create(ecModel, api);
			coordinateSystems = coordinateSystems.concat(list || []);
		});
		this._coordinateSystems = coordinateSystems;
	};
	CoordinateSystemManager$1.prototype.update = function(ecModel, api) {
		each$4(this._coordinateSystems, function(coordSys) {
			coordSys.update && coordSys.update(ecModel, api);
		});
	};
	CoordinateSystemManager$1.prototype.getCoordinateSystems = function() {
		return this._coordinateSystems.slice();
	};
	CoordinateSystemManager$1.register = function(type, creator) {
		coordinateSystemCreators[type] = creator;
	};
	CoordinateSystemManager$1.get = function(type) {
		return coordinateSystemCreators[type];
	};
	return CoordinateSystemManager$1;
}();
var CoordinateSystem_default = CoordinateSystemManager;
/**

* @class

* For example:

* {

*     coordSysName: 'cartesian2d',

*     coordSysDims: ['x', 'y', ...],

*     axisMap: HashMap({

*         x: xAxisModel,

*         y: yAxisModel

*     }),

*     categoryAxisMap: HashMap({

*         x: xAxisModel,

*         y: undefined

*     }),

*     // The index of the first category axis in `coordSysDims`.

*     // `null/undefined` means no category axis exists.

*     firstCategoryDimIndex: 1,

*     // To replace user specified encode.

* }

*/
var CoordSysInfo = function() {
	function CoordSysInfo$1(coordSysName) {
		this.coordSysDims = [];
		this.axisMap = createHashMap();
		this.categoryAxisMap = createHashMap();
		this.coordSysName = coordSysName;
	}
	return CoordSysInfo$1;
}();
function getCoordSysInfoBySeries(seriesModel) {
	var coordSysName = seriesModel.get("coordinateSystem");
	var result = new CoordSysInfo(coordSysName);
	var fetch = fetchers[coordSysName];
	if (fetch) {
		fetch(seriesModel, result, result.axisMap, result.categoryAxisMap);
		return result;
	}
}
var fetchers = {
	cartesian2d: function(seriesModel, result, axisMap, categoryAxisMap) {
		var xAxisModel = seriesModel.getReferringComponents("xAxis", SINGLE_REFERRING).models[0];
		var yAxisModel = seriesModel.getReferringComponents("yAxis", SINGLE_REFERRING).models[0];
		result.coordSysDims = ["x", "y"];
		axisMap.set("x", xAxisModel);
		axisMap.set("y", yAxisModel);
		if (isCategory(xAxisModel)) {
			categoryAxisMap.set("x", xAxisModel);
			result.firstCategoryDimIndex = 0;
		}
		if (isCategory(yAxisModel)) {
			categoryAxisMap.set("y", yAxisModel);
			result.firstCategoryDimIndex ??= 1;
		}
	},
	singleAxis: function(seriesModel, result, axisMap, categoryAxisMap) {
		var singleAxisModel = seriesModel.getReferringComponents("singleAxis", SINGLE_REFERRING).models[0];
		result.coordSysDims = ["single"];
		axisMap.set("single", singleAxisModel);
		if (isCategory(singleAxisModel)) {
			categoryAxisMap.set("single", singleAxisModel);
			result.firstCategoryDimIndex = 0;
		}
	},
	polar: function(seriesModel, result, axisMap, categoryAxisMap) {
		var polarModel = seriesModel.getReferringComponents("polar", SINGLE_REFERRING).models[0];
		var radiusAxisModel = polarModel.findAxisModel("radiusAxis");
		var angleAxisModel = polarModel.findAxisModel("angleAxis");
		result.coordSysDims = ["radius", "angle"];
		axisMap.set("radius", radiusAxisModel);
		axisMap.set("angle", angleAxisModel);
		if (isCategory(radiusAxisModel)) {
			categoryAxisMap.set("radius", radiusAxisModel);
			result.firstCategoryDimIndex = 0;
		}
		if (isCategory(angleAxisModel)) {
			categoryAxisMap.set("angle", angleAxisModel);
			result.firstCategoryDimIndex ??= 1;
		}
	},
	geo: function(seriesModel, result, axisMap, categoryAxisMap) {
		result.coordSysDims = ["lng", "lat"];
	},
	parallel: function(seriesModel, result, axisMap, categoryAxisMap) {
		var ecModel = seriesModel.ecModel;
		var parallelModel = ecModel.getComponent("parallel", seriesModel.get("parallelIndex"));
		var coordSysDims = result.coordSysDims = parallelModel.dimensions.slice();
		each$4(parallelModel.parallelAxisIndex, function(axisIndex, index) {
			var axisModel = ecModel.getComponent("parallelAxis", axisIndex);
			var axisDim = coordSysDims[index];
			axisMap.set(axisDim, axisModel);
			if (isCategory(axisModel)) {
				categoryAxisMap.set(axisDim, axisModel);
				if (result.firstCategoryDimIndex == null) result.firstCategoryDimIndex = index;
			}
		});
	}
};
function isCategory(axisModel) {
	return axisModel.get("type") === "category";
}
function enableDataStack(seriesModel, dimensionsInput, opt) {
	opt = opt || {};
	var byIndex = opt.byIndex;
	var stackedCoordDimension = opt.stackedCoordDimension;
	var dimensionDefineList;
	var schema;
	var store;
	if (isLegacyDimensionsInput(dimensionsInput)) dimensionDefineList = dimensionsInput;
	else {
		schema = dimensionsInput.schema;
		dimensionDefineList = schema.dimensions;
		store = dimensionsInput.store;
	}
	var mayStack = !!(seriesModel && seriesModel.get("stack"));
	var stackedByDimInfo;
	var stackedDimInfo;
	var stackResultDimension;
	var stackedOverDimension;
	each$4(dimensionDefineList, function(dimensionInfo, index) {
		if (isString(dimensionInfo)) dimensionDefineList[index] = dimensionInfo = { name: dimensionInfo };
		if (mayStack && !dimensionInfo.isExtraCoord) {
			if (!byIndex && !stackedByDimInfo && dimensionInfo.ordinalMeta) stackedByDimInfo = dimensionInfo;
			if (!stackedDimInfo && dimensionInfo.type !== "ordinal" && dimensionInfo.type !== "time" && (!stackedCoordDimension || stackedCoordDimension === dimensionInfo.coordDim)) stackedDimInfo = dimensionInfo;
		}
	});
	if (stackedDimInfo && !byIndex && !stackedByDimInfo) byIndex = true;
	if (stackedDimInfo) {
		stackResultDimension = "__\0ecstackresult_" + seriesModel.id;
		stackedOverDimension = "__\0ecstackedover_" + seriesModel.id;
		if (stackedByDimInfo) stackedByDimInfo.createInvertedIndices = true;
		var stackedDimCoordDim_1 = stackedDimInfo.coordDim;
		var stackedDimType = stackedDimInfo.type;
		var stackedDimCoordIndex_1 = 0;
		each$4(dimensionDefineList, function(dimensionInfo) {
			if (dimensionInfo.coordDim === stackedDimCoordDim_1) stackedDimCoordIndex_1++;
		});
		var stackedOverDimensionDefine = {
			name: stackResultDimension,
			coordDim: stackedDimCoordDim_1,
			coordDimIndex: stackedDimCoordIndex_1,
			type: stackedDimType,
			isExtraCoord: true,
			isCalculationCoord: true,
			storeDimIndex: dimensionDefineList.length
		};
		var stackResultDimensionDefine = {
			name: stackedOverDimension,
			coordDim: stackedOverDimension,
			coordDimIndex: stackedDimCoordIndex_1 + 1,
			type: stackedDimType,
			isExtraCoord: true,
			isCalculationCoord: true,
			storeDimIndex: dimensionDefineList.length + 1
		};
		if (schema) {
			if (store) {
				stackedOverDimensionDefine.storeDimIndex = store.ensureCalculationDimension(stackedOverDimension, stackedDimType);
				stackResultDimensionDefine.storeDimIndex = store.ensureCalculationDimension(stackResultDimension, stackedDimType);
			}
			schema.appendCalculationDimension(stackedOverDimensionDefine);
			schema.appendCalculationDimension(stackResultDimensionDefine);
		} else {
			dimensionDefineList.push(stackedOverDimensionDefine);
			dimensionDefineList.push(stackResultDimensionDefine);
		}
	}
	return {
		stackedDimension: stackedDimInfo && stackedDimInfo.name,
		stackedByDimension: stackedByDimInfo && stackedByDimInfo.name,
		isStackedByIndex: byIndex,
		stackedOverDimension,
		stackResultDimension
	};
}
function isLegacyDimensionsInput(dimensionsInput) {
	return !isSeriesDataSchema(dimensionsInput.schema);
}
function isDimensionStacked(data, stackedDim) {
	return !!stackedDim && stackedDim === data.getCalculationInfo("stackedDimension");
}
function getStackedDimension(data, targetDim) {
	return isDimensionStacked(data, targetDim) ? data.getCalculationInfo("stackResultDimension") : targetDim;
}
function getCoordSysDimDefs(seriesModel, coordSysInfo) {
	var coordSysName = seriesModel.get("coordinateSystem");
	var registeredCoordSys = CoordinateSystem_default.get(coordSysName);
	var coordSysDimDefs;
	if (coordSysInfo && coordSysInfo.coordSysDims) coordSysDimDefs = map$1(coordSysInfo.coordSysDims, function(dim) {
		var dimInfo = { name: dim };
		var axisModel = coordSysInfo.axisMap.get(dim);
		if (axisModel) {
			var axisType = axisModel.get("type");
			dimInfo.type = getDimensionTypeByAxis(axisType);
		}
		return dimInfo;
	});
	if (!coordSysDimDefs) coordSysDimDefs = registeredCoordSys && (registeredCoordSys.getDimensionsInfo ? registeredCoordSys.getDimensionsInfo() : registeredCoordSys.dimensions.slice()) || ["x", "y"];
	return coordSysDimDefs;
}
function injectOrdinalMeta(dimInfoList, createInvertedIndices, coordSysInfo) {
	var firstCategoryDimIndex;
	var hasNameEncode;
	coordSysInfo && each$4(dimInfoList, function(dimInfo, dimIndex) {
		var coordDim = dimInfo.coordDim;
		var categoryAxisModel = coordSysInfo.categoryAxisMap.get(coordDim);
		if (categoryAxisModel) {
			if (firstCategoryDimIndex == null) firstCategoryDimIndex = dimIndex;
			dimInfo.ordinalMeta = categoryAxisModel.getOrdinalMeta();
			if (createInvertedIndices) dimInfo.createInvertedIndices = true;
		}
		if (dimInfo.otherDims.itemName != null) hasNameEncode = true;
	});
	if (!hasNameEncode && firstCategoryDimIndex != null) dimInfoList[firstCategoryDimIndex].otherDims.itemName = 0;
	return firstCategoryDimIndex;
}
/**

* Caution: there are side effects to `sourceManager` in this method.

* Should better only be called in `Series['getInitialData']`.

*/
function createSeriesData(sourceRaw, seriesModel, opt) {
	opt = opt || {};
	var sourceManager = seriesModel.getSourceManager();
	var source;
	var isOriginalSource = false;
	if (sourceRaw) {
		isOriginalSource = true;
		source = createSourceFromSeriesDataOption(sourceRaw);
	} else {
		source = sourceManager.getSource();
		isOriginalSource = source.sourceFormat === SOURCE_FORMAT_ORIGINAL;
	}
	var coordSysInfo = getCoordSysInfoBySeries(seriesModel);
	var coordSysDimDefs = getCoordSysDimDefs(seriesModel, coordSysInfo);
	var useEncodeDefaulter = opt.useEncodeDefaulter;
	var encodeDefaulter = isFunction(useEncodeDefaulter) ? useEncodeDefaulter : useEncodeDefaulter ? curry$1(makeSeriesEncodeForAxisCoordSys, coordSysDimDefs, seriesModel) : null;
	var createDimensionOptions = {
		coordDimensions: coordSysDimDefs,
		generateCoord: opt.generateCoord,
		encodeDefine: seriesModel.getEncode(),
		encodeDefaulter,
		canOmitUnusedDimensions: !isOriginalSource
	};
	var schema = prepareSeriesDataSchema(source, createDimensionOptions);
	var firstCategoryDimIndex = injectOrdinalMeta(schema.dimensions, opt.createInvertedIndices, coordSysInfo);
	var store = !isOriginalSource ? sourceManager.getSharedDataStore(schema) : null;
	var stackCalculationInfo = enableDataStack(seriesModel, {
		schema,
		store
	});
	var data = new SeriesData_default(schema, seriesModel);
	data.setCalculationInfo(stackCalculationInfo);
	var dimValueGetter = firstCategoryDimIndex != null && isNeedCompleteOrdinalData(source) ? function(itemOpt, dimName, dataIndex, dimIndex) {
		return dimIndex === firstCategoryDimIndex ? dataIndex : this.defaultDimValueGetter(itemOpt, dimName, dataIndex, dimIndex);
	} : null;
	data.hasItemOption = false;
	data.initData(
		// Try to reuse the data store in sourceManager if using dataset.
		isOriginalSource ? source : store,
		null,
		dimValueGetter
);
	return data;
}
function isNeedCompleteOrdinalData(source) {
	if (source.sourceFormat === SOURCE_FORMAT_ORIGINAL) {
		var sampleItem = firstDataNotNull(source.data || []);
		return !isArray(getDataItemValue(sampleItem));
	}
}
function firstDataNotNull(arr) {
	var i = 0;
	while (i < arr.length && arr[i] == null) i++;
	return arr[i];
}
var createSeriesData_default = createSeriesData;
var base = Math.round(Math.random() * 10);
function getUID(type) {
	return [type || "", base++].join("_");
}
function enableSubTypeDefaulter(target) {
	var subTypeDefaulters = {};
	target.registerSubTypeDefaulter = function(componentType, defaulter) {
		var componentTypeInfo = parseClassType(componentType);
		subTypeDefaulters[componentTypeInfo.main] = defaulter;
	};
	target.determineSubType = function(componentType, option) {
		var type = option.type;
		if (!type) {
			var componentTypeMain = parseClassType(componentType).main;
			if (target.hasSubTypes(componentType) && subTypeDefaulters[componentTypeMain]) type = subTypeDefaulters[componentTypeMain](option);
		}
		return type;
	};
}
function enableTopologicalTravel(entity, dependencyGetter) {
	/**
	
	* @param targetNameList Target Component type list.
	
	*                       Can be ['aa', 'bb', 'aa.xx']
	
	* @param fullNameList By which we can build dependency graph.
	
	* @param callback Params: componentType, dependencies.
	
	* @param context Scope of callback.
	
	*/
	entity.topologicalTravel = function(targetNameList, fullNameList, callback, context) {
		if (!targetNameList.length) return;
		var result = makeDepndencyGraph(fullNameList);
		var graph = result.graph;
		var noEntryList = result.noEntryList;
		var targetNameSet = {};
		each$4(targetNameList, function(name) {
			targetNameSet[name] = true;
		});
		while (noEntryList.length) {
			var currComponentType = noEntryList.pop();
			var currVertex = graph[currComponentType];
			var isInTargetNameSet = !!targetNameSet[currComponentType];
			if (isInTargetNameSet) {
				callback.call(context, currComponentType, currVertex.originalDeps.slice());
				delete targetNameSet[currComponentType];
			}
			each$4(currVertex.successor, isInTargetNameSet ? removeEdgeAndAdd : removeEdge);
		}
		each$4(targetNameSet, function() {
			var errMsg = "";
			throw new Error(errMsg);
		});
		function removeEdge(succComponentType) {
			graph[succComponentType].entryCount--;
			if (graph[succComponentType].entryCount === 0) noEntryList.push(succComponentType);
		}
		function removeEdgeAndAdd(succComponentType) {
			targetNameSet[succComponentType] = true;
			removeEdge(succComponentType);
		}
	};
	function makeDepndencyGraph(fullNameList) {
		var graph = {};
		var noEntryList = [];
		each$4(fullNameList, function(name) {
			var thisItem = createDependencyGraphItem(graph, name);
			var originalDeps = thisItem.originalDeps = dependencyGetter(name);
			var availableDeps = getAvailableDependencies(originalDeps, fullNameList);
			thisItem.entryCount = availableDeps.length;
			if (thisItem.entryCount === 0) noEntryList.push(name);
			each$4(availableDeps, function(dependentName) {
				if (indexOf(thisItem.predecessor, dependentName) < 0) thisItem.predecessor.push(dependentName);
				var thatItem = createDependencyGraphItem(graph, dependentName);
				if (indexOf(thatItem.successor, dependentName) < 0) thatItem.successor.push(name);
			});
		});
		return {
			graph,
			noEntryList
		};
	}
	function createDependencyGraphItem(graph, name) {
		if (!graph[name]) graph[name] = {
			predecessor: [],
			successor: []
		};
		return graph[name];
	}
	function getAvailableDependencies(originalDeps, fullNameList) {
		var availableDeps = [];
		each$4(originalDeps, function(dep) {
			indexOf(fullNameList, dep) >= 0 && availableDeps.push(dep);
		});
		return availableDeps;
	}
}
function inheritDefaultOption(superOption, subOption) {
	return merge(merge({}, superOption, true), subOption, true);
}
var LN2 = Math.log(2);
function determinant(rows, rank, rowStart, rowMask, colMask, detCache) {
	var cacheKey = rowMask + "-" + colMask;
	var fullRank = rows.length;
	if (detCache.hasOwnProperty(cacheKey)) return detCache[cacheKey];
	if (rank === 1) {
		var colStart = Math.round(Math.log((1 << fullRank) - 1 & ~colMask) / LN2);
		return rows[rowStart][colStart];
	}
	var subRowMask = rowMask | 1 << rowStart;
	var subRowStart = rowStart + 1;
	while (rowMask & 1 << subRowStart) subRowStart++;
	var sum = 0;
	for (var j = 0, colLocalIdx = 0; j < fullRank; j++) {
		var colTag = 1 << j;
		if (!(colTag & colMask)) {
			sum += (colLocalIdx % 2 ? -1 : 1) * rows[rowStart][j] * determinant(rows, rank - 1, subRowStart, subRowMask, colMask | colTag, detCache);
			colLocalIdx++;
		}
	}
	detCache[cacheKey] = sum;
	return sum;
}
function buildTransformer(src, dest) {
	var mA = [
		[
			src[0],
			src[1],
			1,
			0,
			0,
			0,
			-dest[0] * src[0],
			-dest[0] * src[1]
		],
		[
			0,
			0,
			0,
			src[0],
			src[1],
			1,
			-dest[1] * src[0],
			-dest[1] * src[1]
		],
		[
			src[2],
			src[3],
			1,
			0,
			0,
			0,
			-dest[2] * src[2],
			-dest[2] * src[3]
		],
		[
			0,
			0,
			0,
			src[2],
			src[3],
			1,
			-dest[3] * src[2],
			-dest[3] * src[3]
		],
		[
			src[4],
			src[5],
			1,
			0,
			0,
			0,
			-dest[4] * src[4],
			-dest[4] * src[5]
		],
		[
			0,
			0,
			0,
			src[4],
			src[5],
			1,
			-dest[5] * src[4],
			-dest[5] * src[5]
		],
		[
			src[6],
			src[7],
			1,
			0,
			0,
			0,
			-dest[6] * src[6],
			-dest[6] * src[7]
		],
		[
			0,
			0,
			0,
			src[6],
			src[7],
			1,
			-dest[7] * src[6],
			-dest[7] * src[7]
		]
	];
	var detCache = {};
	var det = determinant(mA, 8, 0, 0, 0, detCache);
	if (det === 0) return;
	var vh = [];
	for (var i = 0; i < 8; i++) for (var j = 0; j < 8; j++) {
		vh[j] ?? (vh[j] = 0);
		vh[j] += ((i + j) % 2 ? -1 : 1) * determinant(mA, 7, i === 0 ? 1 : 0, 1 << i, 1 << j, detCache) / det * dest[i];
	}
	return function(out$1, srcPointX, srcPointY) {
		var pk = srcPointX * vh[6] + srcPointY * vh[7] + 1;
		out$1[0] = (srcPointX * vh[0] + srcPointY * vh[1] + vh[2]) / pk;
		out$1[1] = (srcPointX * vh[3] + srcPointY * vh[4] + vh[5]) / pk;
	};
}
var EVENT_SAVED_PROP = "___zrEVENTSAVED";
var _calcOut$1 = [];
function transformLocalCoord(out$1, elFrom, elTarget, inX, inY) {
	return transformCoordWithViewport(_calcOut$1, elFrom, inX, inY, true) && transformCoordWithViewport(out$1, elTarget, _calcOut$1[0], _calcOut$1[1]);
}
function transformCoordWithViewport(out$1, el, inX, inY, inverse) {
	if (el.getBoundingClientRect && env_default.domSupported && !isCanvasEl(el)) {
		var saved = el[EVENT_SAVED_PROP] || (el[EVENT_SAVED_PROP] = {});
		var markers = prepareCoordMarkers(el, saved);
		var transformer = preparePointerTransformer(markers, saved, inverse);
		if (transformer) {
			transformer(out$1, inX, inY);
			return true;
		}
	}
	return false;
}
function prepareCoordMarkers(el, saved) {
	var markers = saved.markers;
	if (markers) return markers;
	markers = saved.markers = [];
	var propLR = ["left", "right"];
	var propTB = ["top", "bottom"];
	for (var i = 0; i < 4; i++) {
		var marker = document.createElement("div");
		var stl = marker.style;
		var idxLR = i % 2;
		var idxTB = (i >> 1) % 2;
		stl.cssText = [
			"position: absolute",
			"visibility: hidden",
			"padding: 0",
			"margin: 0",
			"border-width: 0",
			"user-select: none",
			"width:0",
			"height:0",
			propLR[idxLR] + ":0",
			propTB[idxTB] + ":0",
			propLR[1 - idxLR] + ":auto",
			propTB[1 - idxTB] + ":auto",
			""
		].join("!important;");
		el.appendChild(marker);
		markers.push(marker);
	}
	return markers;
}
function preparePointerTransformer(markers, saved, inverse) {
	var transformerName = inverse ? "invTrans" : "trans";
	var transformer = saved[transformerName];
	var oldSrcCoords = saved.srcCoords;
	var srcCoords = [];
	var destCoords = [];
	var oldCoordTheSame = true;
	for (var i = 0; i < 4; i++) {
		var rect = markers[i].getBoundingClientRect();
		var ii = 2 * i;
		var x = rect.left;
		var y = rect.top;
		srcCoords.push(x, y);
		oldCoordTheSame = oldCoordTheSame && oldSrcCoords && x === oldSrcCoords[ii] && y === oldSrcCoords[ii + 1];
		destCoords.push(markers[i].offsetLeft, markers[i].offsetTop);
	}
	return oldCoordTheSame && transformer ? transformer : (saved.srcCoords = srcCoords, saved[transformerName] = inverse ? buildTransformer(destCoords, srcCoords) : buildTransformer(srcCoords, destCoords));
}
function isCanvasEl(el) {
	return el.nodeName.toUpperCase() === "CANVAS";
}
var replaceReg = /([&<>"'])/g;
var replaceMap = {
	"&": "&amp;",
	"<": "&lt;",
	">": "&gt;",
	"\"": "&quot;",
	"'": "&#39;"
};
function encodeHTML(source) {
	return source == null ? "" : (source + "").replace(replaceReg, function(str, c) {
		return replaceMap[c];
	});
}
var langEN_default = {
	time: {
		month: [
			"January",
			"February",
			"March",
			"April",
			"May",
			"June",
			"July",
			"August",
			"September",
			"October",
			"November",
			"December"
		],
		monthAbbr: [
			"Jan",
			"Feb",
			"Mar",
			"Apr",
			"May",
			"Jun",
			"Jul",
			"Aug",
			"Sep",
			"Oct",
			"Nov",
			"Dec"
		],
		dayOfWeek: [
			"Sunday",
			"Monday",
			"Tuesday",
			"Wednesday",
			"Thursday",
			"Friday",
			"Saturday"
		],
		dayOfWeekAbbr: [
			"Sun",
			"Mon",
			"Tue",
			"Wed",
			"Thu",
			"Fri",
			"Sat"
		]
	},
	legend: { selector: {
		all: "All",
		inverse: "Inv"
	} },
	toolbox: {
		brush: { title: {
			rect: "Box Select",
			polygon: "Lasso Select",
			lineX: "Horizontally Select",
			lineY: "Vertically Select",
			keep: "Keep Selections",
			clear: "Clear Selections"
		} },
		dataView: {
			title: "Data View",
			lang: [
				"Data View",
				"Close",
				"Refresh"
			]
		},
		dataZoom: { title: {
			zoom: "Zoom",
			back: "Zoom Reset"
		} },
		magicType: { title: {
			line: "Switch to Line Chart",
			bar: "Switch to Bar Chart",
			stack: "Stack",
			tiled: "Tile"
		} },
		restore: { title: "Restore" },
		saveAsImage: {
			title: "Save as Image",
			lang: ["Right Click to Save Image"]
		}
	},
	series: { typeNames: {
		pie: "Pie chart",
		bar: "Bar chart",
		line: "Line chart",
		scatter: "Scatter plot",
		effectScatter: "Ripple scatter plot",
		radar: "Radar chart",
		tree: "Tree",
		treemap: "Treemap",
		boxplot: "Boxplot",
		candlestick: "Candlestick",
		k: "K line chart",
		heatmap: "Heat map",
		map: "Map",
		parallel: "Parallel coordinate map",
		lines: "Line graph",
		graph: "Relationship graph",
		sankey: "Sankey diagram",
		funnel: "Funnel chart",
		gauge: "Gauge",
		pictorialBar: "Pictorial bar",
		themeRiver: "Theme River Map",
		sunburst: "Sunburst",
		custom: "Custom chart",
		chart: "Chart"
	} },
	aria: {
		general: {
			withTitle: "This is a chart about \"{title}\"",
			withoutTitle: "This is a chart"
		},
		series: {
			single: {
				prefix: "",
				withName: " with type {seriesType} named {seriesName}.",
				withoutName: " with type {seriesType}."
			},
			multiple: {
				prefix: ". It consists of {seriesCount} series count.",
				withName: " The {seriesId} series is a {seriesType} representing {seriesName}.",
				withoutName: " The {seriesId} series is a {seriesType}.",
				separator: {
					middle: "",
					end: ""
				}
			}
		},
		data: {
			allData: "The data is as follows: ",
			partialData: "The first {displayCnt} items are: ",
			withName: "the data for {name} is {value}",
			withoutName: "{value}",
			separator: {
				middle: ", ",
				end: ". "
			}
		}
	}
};
var langZH_default = {
	time: {
		month: [
			"一月",
			"二月",
			"三月",
			"四月",
			"五月",
			"六月",
			"七月",
			"八月",
			"九月",
			"十月",
			"十一月",
			"十二月"
		],
		monthAbbr: [
			"1月",
			"2月",
			"3月",
			"4月",
			"5月",
			"6月",
			"7月",
			"8月",
			"9月",
			"10月",
			"11月",
			"12月"
		],
		dayOfWeek: [
			"星期日",
			"星期一",
			"星期二",
			"星期三",
			"星期四",
			"星期五",
			"星期六"
		],
		dayOfWeekAbbr: [
			"日",
			"一",
			"二",
			"三",
			"四",
			"五",
			"六"
		]
	},
	legend: { selector: {
		all: "全选",
		inverse: "反选"
	} },
	toolbox: {
		brush: { title: {
			rect: "矩形选择",
			polygon: "圈选",
			lineX: "横向选择",
			lineY: "纵向选择",
			keep: "保持选择",
			clear: "清除选择"
		} },
		dataView: {
			title: "数据视图",
			lang: [
				"数据视图",
				"关闭",
				"刷新"
			]
		},
		dataZoom: { title: {
			zoom: "区域缩放",
			back: "区域缩放还原"
		} },
		magicType: { title: {
			line: "切换为折线图",
			bar: "切换为柱状图",
			stack: "切换为堆叠",
			tiled: "切换为平铺"
		} },
		restore: { title: "还原" },
		saveAsImage: {
			title: "保存为图片",
			lang: ["右键另存为图片"]
		}
	},
	series: { typeNames: {
		pie: "饼图",
		bar: "柱状图",
		line: "折线图",
		scatter: "散点图",
		effectScatter: "涟漪散点图",
		radar: "雷达图",
		tree: "树图",
		treemap: "矩形树图",
		boxplot: "箱型图",
		candlestick: "K线图",
		k: "K线图",
		heatmap: "热力图",
		map: "地图",
		parallel: "平行坐标图",
		lines: "线图",
		graph: "关系图",
		sankey: "桑基图",
		funnel: "漏斗图",
		gauge: "仪表盘图",
		pictorialBar: "象形柱图",
		themeRiver: "主题河流图",
		sunburst: "旭日图",
		custom: "自定义图表",
		chart: "图表"
	} },
	aria: {
		general: {
			withTitle: "这是一个关于“{title}”的图表。",
			withoutTitle: "这是一个图表，"
		},
		series: {
			single: {
				prefix: "",
				withName: "图表类型是{seriesType}，表示{seriesName}。",
				withoutName: "图表类型是{seriesType}。"
			},
			multiple: {
				prefix: "它由{seriesCount}个图表系列组成。",
				withName: "第{seriesId}个系列是一个表示{seriesName}的{seriesType}，",
				withoutName: "第{seriesId}个系列是一个{seriesType}，",
				separator: {
					middle: "；",
					end: "。"
				}
			}
		},
		data: {
			allData: "其数据是——",
			partialData: "其中，前{displayCnt}项是——",
			withName: "{name}的数据是{value}",
			withoutName: "{value}",
			separator: {
				middle: "，",
				end: ""
			}
		}
	}
};
var LOCALE_ZH = "ZH";
var LOCALE_EN = "EN";
var DEFAULT_LOCALE = LOCALE_EN;
var localeStorage = {};
var localeModels = {};
var SYSTEM_LANG = !env_default.domSupported ? DEFAULT_LOCALE : function() {
	var langStr = (document.documentElement.lang || navigator.language || navigator.browserLanguage || DEFAULT_LOCALE).toUpperCase();
	return langStr.indexOf(LOCALE_ZH) > -1 ? LOCALE_ZH : DEFAULT_LOCALE;
}();
function registerLocale(locale, localeObj) {
	locale = locale.toUpperCase();
	localeModels[locale] = new Model_default(localeObj);
	localeStorage[locale] = localeObj;
}
function createLocaleObject(locale) {
	if (isString(locale)) {
		var localeObj = localeStorage[locale.toUpperCase()] || {};
		if (locale === LOCALE_ZH || locale === LOCALE_EN) return clone$2(localeObj);
		else return merge(clone$2(localeObj), clone$2(localeStorage[DEFAULT_LOCALE]), false);
	} else return merge(clone$2(locale), clone$2(localeStorage[DEFAULT_LOCALE]), false);
}
function getLocaleModel(lang) {
	return localeModels[lang];
}
function getDefaultLocaleModel() {
	return localeModels[DEFAULT_LOCALE];
}
registerLocale(LOCALE_EN, langEN_default);
registerLocale(LOCALE_ZH, langZH_default);
var ONE_SECOND = 1e3;
var ONE_MINUTE = ONE_SECOND * 60;
var ONE_HOUR = ONE_MINUTE * 60;
var ONE_DAY = ONE_HOUR * 24;
var ONE_YEAR = ONE_DAY * 365;
var defaultLeveledFormatter = {
	year: "{yyyy}",
	month: "{MMM}",
	day: "{d}",
	hour: "{HH}:{mm}",
	minute: "{HH}:{mm}",
	second: "{HH}:{mm}:{ss}",
	millisecond: "{HH}:{mm}:{ss} {SSS}",
	none: "{yyyy}-{MM}-{dd} {HH}:{mm}:{ss} {SSS}"
};
var fullDayFormatter = "{yyyy}-{MM}-{dd}";
var fullLeveledFormatter = {
	year: "{yyyy}",
	month: "{yyyy}-{MM}",
	day: fullDayFormatter,
	hour: fullDayFormatter + " " + defaultLeveledFormatter.hour,
	minute: fullDayFormatter + " " + defaultLeveledFormatter.minute,
	second: fullDayFormatter + " " + defaultLeveledFormatter.second,
	millisecond: defaultLeveledFormatter.none
};
var primaryTimeUnits = [
	"year",
	"month",
	"day",
	"hour",
	"minute",
	"second",
	"millisecond"
];
var timeUnits = [
	"year",
	"half-year",
	"quarter",
	"month",
	"week",
	"half-week",
	"day",
	"half-day",
	"quarter-day",
	"hour",
	"minute",
	"second",
	"millisecond"
];
function pad(str, len$1) {
	str += "";
	return "0000".substr(0, len$1 - str.length) + str;
}
function getPrimaryTimeUnit(timeUnit) {
	switch (timeUnit) {
		case "half-year":
		case "quarter": return "month";
		case "week":
		case "half-week": return "day";
		case "half-day":
		case "quarter-day": return "hour";
		default: return timeUnit;
	}
}
function isPrimaryTimeUnit(timeUnit) {
	return timeUnit === getPrimaryTimeUnit(timeUnit);
}
function getDefaultFormatPrecisionOfInterval(timeUnit) {
	switch (timeUnit) {
		case "year":
		case "month": return "day";
		case "millisecond": return "millisecond";
		default: return "second";
	}
}
function format(time, template, isUTC, lang) {
	var date = parseDate(time);
	var y = date[fullYearGetterName(isUTC)]();
	var M = date[monthGetterName(isUTC)]() + 1;
	var q = Math.floor((M - 1) / 3) + 1;
	var d = date[dateGetterName(isUTC)]();
	var e$1 = date["get" + (isUTC ? "UTC" : "") + "Day"]();
	var H = date[hoursGetterName(isUTC)]();
	var h$1 = (H - 1) % 12 + 1;
	var m$1 = date[minutesGetterName(isUTC)]();
	var s = date[secondsGetterName(isUTC)]();
	var S = date[millisecondsGetterName(isUTC)]();
	var a = H >= 12 ? "pm" : "am";
	var A = a.toUpperCase();
	var localeModel = lang instanceof Model_default ? lang : getLocaleModel(lang || SYSTEM_LANG) || getDefaultLocaleModel();
	var timeModel = localeModel.getModel("time");
	var month = timeModel.get("month");
	var monthAbbr = timeModel.get("monthAbbr");
	var dayOfWeek = timeModel.get("dayOfWeek");
	var dayOfWeekAbbr = timeModel.get("dayOfWeekAbbr");
	return (template || "").replace(/{a}/g, a + "").replace(/{A}/g, A + "").replace(/{yyyy}/g, y + "").replace(/{yy}/g, pad(y % 100 + "", 2)).replace(/{Q}/g, q + "").replace(/{MMMM}/g, month[M - 1]).replace(/{MMM}/g, monthAbbr[M - 1]).replace(/{MM}/g, pad(M, 2)).replace(/{M}/g, M + "").replace(/{dd}/g, pad(d, 2)).replace(/{d}/g, d + "").replace(/{eeee}/g, dayOfWeek[e$1]).replace(/{ee}/g, dayOfWeekAbbr[e$1]).replace(/{e}/g, e$1 + "").replace(/{HH}/g, pad(H, 2)).replace(/{H}/g, H + "").replace(/{hh}/g, pad(h$1 + "", 2)).replace(/{h}/g, h$1 + "").replace(/{mm}/g, pad(m$1, 2)).replace(/{m}/g, m$1 + "").replace(/{ss}/g, pad(s, 2)).replace(/{s}/g, s + "").replace(/{SSS}/g, pad(S, 3)).replace(/{S}/g, S + "");
}
function leveledFormat(tick, idx, formatter, lang, isUTC) {
	var template = null;
	if (isString(formatter)) template = formatter;
	else if (isFunction(formatter)) template = formatter(tick.value, idx, { level: tick.level });
	else {
		var defaults$1 = extend({}, defaultLeveledFormatter);
		if (tick.level > 0) for (var i = 0; i < primaryTimeUnits.length; ++i) defaults$1[primaryTimeUnits[i]] = "{primary|" + defaults$1[primaryTimeUnits[i]] + "}";
		var mergedFormatter = formatter ? formatter.inherit === false ? formatter : defaults(formatter, defaults$1) : defaults$1;
		var unit = getUnitFromValue(tick.value, isUTC);
		if (mergedFormatter[unit]) template = mergedFormatter[unit];
		else if (mergedFormatter.inherit) {
			var targetId = timeUnits.indexOf(unit);
			for (var i = targetId - 1; i >= 0; --i) if (mergedFormatter[unit]) {
				template = mergedFormatter[unit];
				break;
			}
			template = template || defaults$1.none;
		}
		if (isArray(template)) {
			var levelId = tick.level == null ? 0 : tick.level >= 0 ? tick.level : template.length + tick.level;
			levelId = Math.min(levelId, template.length - 1);
			template = template[levelId];
		}
	}
	return format(new Date(tick.value), template, isUTC, lang);
}
function getUnitFromValue(value, isUTC) {
	var date = parseDate(value);
	var M = date[monthGetterName(isUTC)]() + 1;
	var d = date[dateGetterName(isUTC)]();
	var h$1 = date[hoursGetterName(isUTC)]();
	var m$1 = date[minutesGetterName(isUTC)]();
	var s = date[secondsGetterName(isUTC)]();
	var S = date[millisecondsGetterName(isUTC)]();
	var isSecond = S === 0;
	var isMinute = isSecond && s === 0;
	var isHour = isMinute && m$1 === 0;
	var isDay = isHour && h$1 === 0;
	var isMonth = isDay && d === 1;
	var isYear = isMonth && M === 1;
	if (isYear) return "year";
	else if (isMonth) return "month";
	else if (isDay) return "day";
	else if (isHour) return "hour";
	else if (isMinute) return "minute";
	else if (isSecond) return "second";
	else return "millisecond";
}
function getUnitValue(value, unit, isUTC) {
	var date = isNumber(value) ? parseDate(value) : value;
	unit = unit || getUnitFromValue(value, isUTC);
	switch (unit) {
		case "year": return date[fullYearGetterName(isUTC)]();
		case "half-year": return date[monthGetterName(isUTC)]() >= 6 ? 1 : 0;
		case "quarter": return Math.floor((date[monthGetterName(isUTC)]() + 1) / 4);
		case "month": return date[monthGetterName(isUTC)]();
		case "day": return date[dateGetterName(isUTC)]();
		case "half-day": return date[hoursGetterName(isUTC)]() / 24;
		case "hour": return date[hoursGetterName(isUTC)]();
		case "minute": return date[minutesGetterName(isUTC)]();
		case "second": return date[secondsGetterName(isUTC)]();
		case "millisecond": return date[millisecondsGetterName(isUTC)]();
	}
}
function fullYearGetterName(isUTC) {
	return isUTC ? "getUTCFullYear" : "getFullYear";
}
function monthGetterName(isUTC) {
	return isUTC ? "getUTCMonth" : "getMonth";
}
function dateGetterName(isUTC) {
	return isUTC ? "getUTCDate" : "getDate";
}
function hoursGetterName(isUTC) {
	return isUTC ? "getUTCHours" : "getHours";
}
function minutesGetterName(isUTC) {
	return isUTC ? "getUTCMinutes" : "getMinutes";
}
function secondsGetterName(isUTC) {
	return isUTC ? "getUTCSeconds" : "getSeconds";
}
function millisecondsGetterName(isUTC) {
	return isUTC ? "getUTCMilliseconds" : "getMilliseconds";
}
function fullYearSetterName(isUTC) {
	return isUTC ? "setUTCFullYear" : "setFullYear";
}
function monthSetterName(isUTC) {
	return isUTC ? "setUTCMonth" : "setMonth";
}
function dateSetterName(isUTC) {
	return isUTC ? "setUTCDate" : "setDate";
}
function hoursSetterName(isUTC) {
	return isUTC ? "setUTCHours" : "setHours";
}
function minutesSetterName(isUTC) {
	return isUTC ? "setUTCMinutes" : "setMinutes";
}
function secondsSetterName(isUTC) {
	return isUTC ? "setUTCSeconds" : "setSeconds";
}
function millisecondsSetterName(isUTC) {
	return isUTC ? "setUTCMilliseconds" : "setMilliseconds";
}
function addCommas(x) {
	if (!isNumeric(x)) return isString(x) ? x : "-";
	var parts = (x + "").split(".");
	return parts[0].replace(/(\d{1,3})(?=(?:\d{3})+(?!\d))/g, "$1,") + (parts.length > 1 ? "." + parts[1] : "");
}
function toCamelCase(str, upperCaseFirst) {
	str = (str || "").toLowerCase().replace(/-(.)/g, function(match, group1) {
		return group1.toUpperCase();
	});
	if (upperCaseFirst && str) str = str.charAt(0).toUpperCase() + str.slice(1);
	return str;
}
var normalizeCssArray = normalizeCssArray$1;
function makeValueReadable(value, valueType, useUTC) {
	var USER_READABLE_DEFUALT_TIME_PATTERN = "{yyyy}-{MM}-{dd} {HH}:{mm}:{ss}";
	function stringToUserReadable(str) {
		return str && trim(str) ? str : "-";
	}
	function isNumberUserReadable(num) {
		return !!(num != null && !isNaN(num) && isFinite(num));
	}
	var isTypeTime = valueType === "time";
	var isValueDate = value instanceof Date;
	if (isTypeTime || isValueDate) {
		var date = isTypeTime ? parseDate(value) : value;
		if (!isNaN(+date)) return format(date, USER_READABLE_DEFUALT_TIME_PATTERN, useUTC);
		else if (isValueDate) return "-";
	}
	if (valueType === "ordinal") return isStringSafe(value) ? stringToUserReadable(value) : isNumber(value) ? isNumberUserReadable(value) ? value + "" : "-" : "-";
	var numericResult = numericToNumber(value);
	return isNumberUserReadable(numericResult) ? addCommas(numericResult) : isStringSafe(value) ? stringToUserReadable(value) : typeof value === "boolean" ? value + "" : "-";
}
var TPL_VAR_ALIAS = [
	"a",
	"b",
	"c",
	"d",
	"e",
	"f",
	"g"
];
var wrapVar = function(varName, seriesIdx) {
	return "{" + varName + (seriesIdx == null ? "" : seriesIdx) + "}";
};
function formatTpl(tpl, paramsList, encode) {
	if (!isArray(paramsList)) paramsList = [paramsList];
	var seriesLen = paramsList.length;
	if (!seriesLen) return "";
	var $vars = paramsList[0].$vars || [];
	for (var i = 0; i < $vars.length; i++) {
		var alias = TPL_VAR_ALIAS[i];
		tpl = tpl.replace(wrapVar(alias), wrapVar(alias, 0));
	}
	for (var seriesIdx = 0; seriesIdx < seriesLen; seriesIdx++) for (var k = 0; k < $vars.length; k++) {
		var val = paramsList[seriesIdx][$vars[k]];
		tpl = tpl.replace(wrapVar(TPL_VAR_ALIAS[k], seriesIdx), encode ? encodeHTML(val) : val);
	}
	return tpl;
}
function getTooltipMarker(inOpt, extraCssText) {
	var opt = isString(inOpt) ? {
		color: inOpt,
		extraCssText
	} : inOpt || {};
	var color = opt.color;
	var type = opt.type;
	extraCssText = opt.extraCssText;
	var renderMode = opt.renderMode || "html";
	if (!color) return "";
	if (renderMode === "html") return type === "subItem" ? "<span style=\"display:inline-block;vertical-align:middle;margin-right:8px;margin-left:3px;border-radius:4px;width:4px;height:4px;background-color:" + encodeHTML(color) + ";" + (extraCssText || "") + "\"></span>" : "<span style=\"display:inline-block;margin-right:4px;border-radius:10px;width:10px;height:10px;background-color:" + encodeHTML(color) + ";" + (extraCssText || "") + "\"></span>";
	else {
		var markerId = opt.markerId || "markerX";
		return {
			renderMode,
			content: "{" + markerId + "|}  ",
			style: type === "subItem" ? {
				width: 4,
				height: 4,
				borderRadius: 2,
				backgroundColor: color
			} : {
				width: 10,
				height: 10,
				borderRadius: 5,
				backgroundColor: color
			}
		};
	}
}
function convertToColorString(color, defaultColor) {
	defaultColor = defaultColor || "transparent";
	return isString(color) ? color : isObject$2(color) ? color.colorStops && (color.colorStops[0] || {}).color || defaultColor : defaultColor;
}
function windowOpen(link, target) {
	if (target === "_blank" || target === "blank") {
		var blank = window.open();
		blank.opener = null;
		blank.location.href = link;
	} else window.open(link, target);
}
var each$3 = each$4;
var LOCATION_PARAMS = [
	"left",
	"right",
	"top",
	"bottom",
	"width",
	"height"
];
var HV_NAMES = [[
	"width",
	"left",
	"right"
], [
	"height",
	"top",
	"bottom"
]];
function boxLayout(orient, group, gap, maxWidth, maxHeight) {
	var x = 0;
	var y = 0;
	if (maxWidth == null) maxWidth = Infinity;
	if (maxHeight == null) maxHeight = Infinity;
	var currentLineMaxSize = 0;
	group.eachChild(function(child, idx) {
		var rect = child.getBoundingRect();
		var nextChild = group.childAt(idx + 1);
		var nextChildRect = nextChild && nextChild.getBoundingRect();
		var nextX;
		var nextY;
		if (orient === "horizontal") {
			var moveX = rect.width + (nextChildRect ? -nextChildRect.x + rect.x : 0);
			nextX = x + moveX;
			if (nextX > maxWidth || child.newline) {
				x = 0;
				nextX = moveX;
				y += currentLineMaxSize + gap;
				currentLineMaxSize = rect.height;
			} else currentLineMaxSize = Math.max(currentLineMaxSize, rect.height);
		} else {
			var moveY = rect.height + (nextChildRect ? -nextChildRect.y + rect.y : 0);
			nextY = y + moveY;
			if (nextY > maxHeight || child.newline) {
				x += currentLineMaxSize + gap;
				y = 0;
				nextY = moveY;
				currentLineMaxSize = rect.width;
			} else currentLineMaxSize = Math.max(currentLineMaxSize, rect.width);
		}
		if (child.newline) return;
		child.x = x;
		child.y = y;
		child.markRedraw();
		orient === "horizontal" ? x = nextX + gap : y = nextY + gap;
	});
}
var box = boxLayout;
var vbox = curry$1(boxLayout, "vertical");
var hbox = curry$1(boxLayout, "horizontal");
function getLayoutRect(positionInfo, containerRect, margin) {
	margin = normalizeCssArray(margin || 0);
	var containerWidth = containerRect.width;
	var containerHeight = containerRect.height;
	var left = parsePercent(positionInfo.left, containerWidth);
	var top = parsePercent(positionInfo.top, containerHeight);
	var right = parsePercent(positionInfo.right, containerWidth);
	var bottom = parsePercent(positionInfo.bottom, containerHeight);
	var width = parsePercent(positionInfo.width, containerWidth);
	var height = parsePercent(positionInfo.height, containerHeight);
	var verticalMargin = margin[2] + margin[0];
	var horizontalMargin = margin[1] + margin[3];
	var aspect = positionInfo.aspect;
	if (isNaN(width)) width = containerWidth - right - horizontalMargin - left;
	if (isNaN(height)) height = containerHeight - bottom - verticalMargin - top;
	if (aspect != null) {
		if (isNaN(width) && isNaN(height)) if (aspect > containerWidth / containerHeight) width = containerWidth * .8;
		else height = containerHeight * .8;
		if (isNaN(width)) width = aspect * height;
		if (isNaN(height)) height = width / aspect;
	}
	if (isNaN(left)) left = containerWidth - right - width - horizontalMargin;
	if (isNaN(top)) top = containerHeight - bottom - height - verticalMargin;
	switch (positionInfo.left || positionInfo.right) {
		case "center":
			left = containerWidth / 2 - width / 2 - margin[3];
			break;
		case "right":
			left = containerWidth - width - horizontalMargin;
			break;
	}
	switch (positionInfo.top || positionInfo.bottom) {
		case "middle":
		case "center":
			top = containerHeight / 2 - height / 2 - margin[0];
			break;
		case "bottom":
			top = containerHeight - height - verticalMargin;
			break;
	}
	left = left || 0;
	top = top || 0;
	if (isNaN(width)) width = containerWidth - horizontalMargin - left - (right || 0);
	if (isNaN(height)) height = containerHeight - verticalMargin - top - (bottom || 0);
	var rect = new BoundingRect_default(left + margin[3], top + margin[0], width, height);
	rect.margin = margin;
	return rect;
}
function fetchLayoutMode(ins) {
	var layoutMode = ins.layoutMode || ins.constructor.layoutMode;
	return isObject$2(layoutMode) ? layoutMode : layoutMode ? { type: layoutMode } : null;
}
function mergeLayoutParam(targetOption, newOption, opt) {
	var ignoreSize = opt && opt.ignoreSize;
	!isArray(ignoreSize) && (ignoreSize = [ignoreSize, ignoreSize]);
	var hResult = merge$1(HV_NAMES[0], 0);
	var vResult = merge$1(HV_NAMES[1], 1);
	copy$1(HV_NAMES[0], targetOption, hResult);
	copy$1(HV_NAMES[1], targetOption, vResult);
	function merge$1(names, hvIdx) {
		var newParams = {};
		var newValueCount = 0;
		var merged = {};
		var mergedValueCount = 0;
		var enoughParamNumber = 2;
		each$3(names, function(name) {
			merged[name] = targetOption[name];
		});
		each$3(names, function(name) {
			hasProp(newOption, name) && (newParams[name] = merged[name] = newOption[name]);
			hasValue(newParams, name) && newValueCount++;
			hasValue(merged, name) && mergedValueCount++;
		});
		if (ignoreSize[hvIdx]) {
			if (hasValue(newOption, names[1])) merged[names[2]] = null;
			else if (hasValue(newOption, names[2])) merged[names[1]] = null;
			return merged;
		}
		if (mergedValueCount === enoughParamNumber || !newValueCount) return merged;
		else if (newValueCount >= enoughParamNumber) return newParams;
		else {
			for (var i = 0; i < names.length; i++) {
				var name_1 = names[i];
				if (!hasProp(newParams, name_1) && hasProp(targetOption, name_1)) {
					newParams[name_1] = targetOption[name_1];
					break;
				}
			}
			return newParams;
		}
	}
	function hasProp(obj, name) {
		return obj.hasOwnProperty(name);
	}
	function hasValue(obj, name) {
		return obj[name] != null && obj[name] !== "auto";
	}
	function copy$1(names, target, source) {
		each$3(names, function(name) {
			target[name] = source[name];
		});
	}
}
function getLayoutParams(source) {
	return copyLayoutParams({}, source);
}
function copyLayoutParams(target, source) {
	source && target && each$3(LOCATION_PARAMS, function(name) {
		source.hasOwnProperty(name) && (target[name] = source[name]);
	});
	return target;
}
var inner$8 = makeInner();
var ComponentModel = function(_super) {
	__extends(ComponentModel$1, _super);
	function ComponentModel$1(option, parentModel, ecModel) {
		var _this = _super.call(this, option, parentModel, ecModel) || this;
		_this.uid = getUID("ec_cpt_model");
		return _this;
	}
	ComponentModel$1.prototype.init = function(option, parentModel, ecModel) {
		this.mergeDefaultAndTheme(option, ecModel);
	};
	ComponentModel$1.prototype.mergeDefaultAndTheme = function(option, ecModel) {
		var layoutMode = fetchLayoutMode(this);
		var inputPositionParams = layoutMode ? getLayoutParams(option) : {};
		var themeModel = ecModel.getTheme();
		merge(option, themeModel.get(this.mainType));
		merge(option, this.getDefaultOption());
		if (layoutMode) mergeLayoutParam(option, inputPositionParams, layoutMode);
	};
	ComponentModel$1.prototype.mergeOption = function(option, ecModel) {
		merge(this.option, option, true);
		var layoutMode = fetchLayoutMode(this);
		if (layoutMode) mergeLayoutParam(this.option, option, layoutMode);
	};
	/**
	
	* Called immediately after `init` or `mergeOption` of this instance called.
	
	*/
	ComponentModel$1.prototype.optionUpdated = function(newCptOption, isInit) {};
	/**
	
	* [How to declare defaultOption]:
	
	*
	
	* (A) If using class declaration in typescript (since echarts 5):
	
	* ```ts
	
	* import {ComponentOption} from '../model/option.js';
	
	* export interface XxxOption extends ComponentOption {
	
	*     aaa: number
	
	* }
	
	* export class XxxModel extends Component {
	
	*     static type = 'xxx';
	
	*     static defaultOption: XxxOption = {
	
	*         aaa: 123
	
	*     }
	
	* }
	
	* Component.registerClass(XxxModel);
	
	* ```
	
	* ```ts
	
	* import {inheritDefaultOption} from '../util/component.js';
	
	* import {XxxModel, XxxOption} from './XxxModel.js';
	
	* export interface XxxSubOption extends XxxOption {
	
	*     bbb: number
	
	* }
	
	* class XxxSubModel extends XxxModel {
	
	*     static defaultOption: XxxSubOption = inheritDefaultOption(XxxModel.defaultOption, {
	
	*         bbb: 456
	
	*     })
	
	*     fn() {
	
	*         let opt = this.getDefaultOption();
	
	*         // opt is {aaa: 123, bbb: 456}
	
	*     }
	
	* }
	
	* ```
	
	*
	
	* (B) If using class extend (previous approach in echarts 3 & 4):
	
	* ```js
	
	* let XxxComponent = Component.extend({
	
	*     defaultOption: {
	
	*         xx: 123
	
	*     }
	
	* })
	
	* ```
	
	* ```js
	
	* let XxxSubComponent = XxxComponent.extend({
	
	*     defaultOption: {
	
	*         yy: 456
	
	*     },
	
	*     fn: function () {
	
	*         let opt = this.getDefaultOption();
	
	*         // opt is {xx: 123, yy: 456}
	
	*     }
	
	* })
	
	* ```
	
	*/
	ComponentModel$1.prototype.getDefaultOption = function() {
		var ctor = this.constructor;
		if (!isExtendedClass(ctor)) return ctor.defaultOption;
		var fields = inner$8(this);
		if (!fields.defaultOption) {
			var optList = [];
			var clz = ctor;
			while (clz) {
				var opt = clz.prototype.defaultOption;
				opt && optList.push(opt);
				clz = clz.superClass;
			}
			var defaultOption$1 = {};
			for (var i = optList.length - 1; i >= 0; i--) defaultOption$1 = merge(defaultOption$1, optList[i], true);
			fields.defaultOption = defaultOption$1;
		}
		return fields.defaultOption;
	};
	/**
	
	* Notice: always force to input param `useDefault` in case that forget to consider it.
	
	* The same behavior as `modelUtil.parseFinder`.
	
	*
	
	* @param useDefault In many cases like series refer axis and axis refer grid,
	
	*        If axis index / axis id not specified, use the first target as default.
	
	*        In other cases like dataZoom refer axis, if not specified, measn no refer.
	
	*/
	ComponentModel$1.prototype.getReferringComponents = function(mainType, opt) {
		var indexKey = mainType + "Index";
		var idKey = mainType + "Id";
		return queryReferringComponents(this.ecModel, mainType, {
			index: this.get(indexKey, true),
			id: this.get(idKey, true)
		}, opt);
	};
	ComponentModel$1.prototype.getBoxLayoutParams = function() {
		var boxLayoutModel = this;
		return {
			left: boxLayoutModel.get("left"),
			top: boxLayoutModel.get("top"),
			right: boxLayoutModel.get("right"),
			bottom: boxLayoutModel.get("bottom"),
			width: boxLayoutModel.get("width"),
			height: boxLayoutModel.get("height")
		};
	};
	/**
	
	* Get key for zlevel.
	
	* If developers don't configure zlevel. We will assign zlevel to series based on the key.
	
	* For example, lines with trail effect and progressive series will in an individual zlevel.
	
	*/
	ComponentModel$1.prototype.getZLevelKey = function() {
		return "";
	};
	ComponentModel$1.prototype.setZLevel = function(zlevel) {
		this.option.zlevel = zlevel;
	};
	ComponentModel$1.protoInitialize = function() {
		var proto$1 = ComponentModel$1.prototype;
		proto$1.type = "component";
		proto$1.id = "";
		proto$1.name = "";
		proto$1.mainType = "";
		proto$1.subType = "";
		proto$1.componentIndex = 0;
	}();
	return ComponentModel$1;
}(Model_default);
mountExtend(ComponentModel, Model_default);
enableClassManagement(ComponentModel);
enableSubTypeDefaulter(ComponentModel);
enableTopologicalTravel(ComponentModel, getDependencies);
function getDependencies(componentType) {
	var deps = [];
	each$4(ComponentModel.getClassesByMainType(componentType), function(clz) {
		deps = deps.concat(clz.dependencies || clz.prototype.dependencies || []);
	});
	deps = map$1(deps, function(type) {
		return parseClassType(type).main;
	});
	if (componentType !== "dataset" && indexOf(deps, "dataset") <= 0) deps.unshift("dataset");
	return deps;
}
var Component_default$1 = ComponentModel;
var innerColor = makeInner();
var innerDecal = makeInner();
var PaletteMixin = function() {
	function PaletteMixin$1() {}
	PaletteMixin$1.prototype.getColorFromPalette = function(name, scope, requestNum) {
		var defaultPalette = normalizeToArray(this.get("color", true));
		var layeredPalette = this.get("colorLayer", true);
		return getFromPalette(this, innerColor, defaultPalette, layeredPalette, name, scope, requestNum);
	};
	PaletteMixin$1.prototype.clearColorPalette = function() {
		clearPalette(this, innerColor);
	};
	return PaletteMixin$1;
}();
function getNearestPalette(palettes, requestColorNum) {
	var paletteNum = palettes.length;
	for (var i = 0; i < paletteNum; i++) if (palettes[i].length > requestColorNum) return palettes[i];
	return palettes[paletteNum - 1];
}
/**

* @param name MUST NOT be null/undefined. Otherwise call this function

*             twise with the same parameters will get different result.

* @param scope default this.

* @return Can be null/undefined

*/
function getFromPalette(that, inner$10, defaultPalette, layeredPalette, name, scope, requestNum) {
	scope = scope || that;
	var scopeFields = inner$10(scope);
	var paletteIdx = scopeFields.paletteIdx || 0;
	var paletteNameMap = scopeFields.paletteNameMap = scopeFields.paletteNameMap || {};
	if (paletteNameMap.hasOwnProperty(name)) return paletteNameMap[name];
	var palette = requestNum == null || !layeredPalette ? defaultPalette : getNearestPalette(layeredPalette, requestNum);
	palette = palette || defaultPalette;
	if (!palette || !palette.length) return;
	var pickedPaletteItem = palette[paletteIdx];
	if (name) paletteNameMap[name] = pickedPaletteItem;
	scopeFields.paletteIdx = (paletteIdx + 1) % palette.length;
	return pickedPaletteItem;
}
function clearPalette(that, inner$10) {
	inner$10(that).paletteIdx = 0;
	inner$10(that).paletteNameMap = {};
}
var DIMENSION_LABEL_REG = /\{@(.+?)\}/g;
var DataFormatMixin = function() {
	function DataFormatMixin$1() {}
	/**
	
	* Get params for formatter
	
	*/
	DataFormatMixin$1.prototype.getDataParams = function(dataIndex, dataType) {
		var data = this.getData(dataType);
		var rawValue = this.getRawValue(dataIndex, dataType);
		var rawDataIndex = data.getRawIndex(dataIndex);
		var name = data.getName(dataIndex);
		var itemOpt = data.getRawDataItem(dataIndex);
		var style = data.getItemVisual(dataIndex, "style");
		var color = style && style[data.getItemVisual(dataIndex, "drawType") || "fill"];
		var borderColor = style && style.stroke;
		var mainType = this.mainType;
		var isSeries$1 = mainType === "series";
		var userOutput = data.userOutput && data.userOutput.get();
		return {
			componentType: mainType,
			componentSubType: this.subType,
			componentIndex: this.componentIndex,
			seriesType: isSeries$1 ? this.subType : null,
			seriesIndex: this.seriesIndex,
			seriesId: isSeries$1 ? this.id : null,
			seriesName: isSeries$1 ? this.name : null,
			name,
			dataIndex: rawDataIndex,
			data: itemOpt,
			dataType,
			value: rawValue,
			color,
			borderColor,
			dimensionNames: userOutput ? userOutput.fullDimensions : null,
			encode: userOutput ? userOutput.encode : null,
			$vars: [
				"seriesName",
				"name",
				"value"
			]
		};
	};
	/**
	
	* Format label
	
	* @param dataIndex
	
	* @param status 'normal' by default
	
	* @param dataType
	
	* @param labelDimIndex Only used in some chart that
	
	*        use formatter in different dimensions, like radar.
	
	* @param formatter Formatter given outside.
	
	* @return return null/undefined if no formatter
	
	*/
	DataFormatMixin$1.prototype.getFormattedLabel = function(dataIndex, status, dataType, labelDimIndex, formatter, extendParams) {
		status = status || "normal";
		var data = this.getData(dataType);
		var params = this.getDataParams(dataIndex, dataType);
		if (extendParams) params.value = extendParams.interpolatedValue;
		if (labelDimIndex != null && isArray(params.value)) params.value = params.value[labelDimIndex];
		if (!formatter) {
			var itemModel = data.getItemModel(dataIndex);
			formatter = itemModel.get(status === "normal" ? ["label", "formatter"] : [
				status,
				"label",
				"formatter"
			]);
		}
		if (isFunction(formatter)) {
			params.status = status;
			params.dimensionIndex = labelDimIndex;
			return formatter(params);
		} else if (isString(formatter)) {
			var str = formatTpl(formatter, params);
			return str.replace(DIMENSION_LABEL_REG, function(origin, dimStr) {
				var len$1 = dimStr.length;
				var dimLoose = dimStr;
				if (dimLoose.charAt(0) === "[" && dimLoose.charAt(len$1 - 1) === "]") dimLoose = +dimLoose.slice(1, len$1 - 1);
				var val = retrieveRawValue(data, dataIndex, dimLoose);
				if (extendParams && isArray(extendParams.interpolatedValue)) {
					var dimIndex = data.getDimensionIndex(dimLoose);
					if (dimIndex >= 0) val = extendParams.interpolatedValue[dimIndex];
				}
				return val != null ? val + "" : "";
			});
		}
	};
	/**
	
	* Get raw value in option
	
	*/
	DataFormatMixin$1.prototype.getRawValue = function(idx, dataType) {
		return retrieveRawValue(this.getData(dataType), idx);
	};
	/**
	
	* Should be implemented.
	
	* @param {number} dataIndex
	
	* @param {boolean} [multipleSeries=false]
	
	* @param {string} [dataType]
	
	*/
	DataFormatMixin$1.prototype.formatTooltip = function(dataIndex, multipleSeries, dataType) {
		return;
	};
	return DataFormatMixin$1;
}();
function normalizeTooltipFormatResult(result) {
	var markupText;
	var markupFragment;
	if (isObject$2(result)) {
		if (result.type) markupFragment = result;
	} else markupText = result;
	return {
		text: markupText,
		frag: markupFragment
	};
}
function createTask(define) {
	return new Task(define);
}
var Task = function() {
	function Task$1(define) {
		define = define || {};
		this._reset = define.reset;
		this._plan = define.plan;
		this._count = define.count;
		this._onDirty = define.onDirty;
		this._dirty = true;
	}
	/**
	
	* @param step Specified step.
	
	* @param skip Skip customer perform call.
	
	* @param modBy Sampling window size.
	
	* @param modDataCount Sampling count.
	
	* @return whether unfinished.
	
	*/
	Task$1.prototype.perform = function(performArgs) {
		var upTask = this._upstream;
		var skip = performArgs && performArgs.skip;
		if (this._dirty && upTask) {
			var context = this.context;
			context.data = context.outputData = upTask.context.outputData;
		}
		if (this.__pipeline) this.__pipeline.currentTask = this;
		var planResult;
		if (this._plan && !skip) planResult = this._plan(this.context);
		var lastModBy = normalizeModBy(this._modBy);
		var lastModDataCount = this._modDataCount || 0;
		var modBy = normalizeModBy(performArgs && performArgs.modBy);
		var modDataCount = performArgs && performArgs.modDataCount || 0;
		if (lastModBy !== modBy || lastModDataCount !== modDataCount) planResult = "reset";
		function normalizeModBy(val) {
			!(val >= 1) && (val = 1);
			return val;
		}
		var forceFirstProgress;
		if (this._dirty || planResult === "reset") {
			this._dirty = false;
			forceFirstProgress = this._doReset(skip);
		}
		this._modBy = modBy;
		this._modDataCount = modDataCount;
		var step = performArgs && performArgs.step;
		if (upTask) this._dueEnd = upTask._outputDueEnd;
		else this._dueEnd = this._count ? this._count(this.context) : Infinity;
		if (this._progress) {
			var start$1 = this._dueIndex;
			var end$1 = Math.min(step != null ? this._dueIndex + step : Infinity, this._dueEnd);
			if (!skip && (forceFirstProgress || start$1 < end$1)) {
				var progress = this._progress;
				if (isArray(progress)) for (var i = 0; i < progress.length; i++) this._doProgress(progress[i], start$1, end$1, modBy, modDataCount);
				else this._doProgress(progress, start$1, end$1, modBy, modDataCount);
			}
			this._dueIndex = end$1;
			var outputDueEnd = this._settedOutputEnd != null ? this._settedOutputEnd : end$1;
			this._outputDueEnd = outputDueEnd;
		} else this._dueIndex = this._outputDueEnd = this._settedOutputEnd != null ? this._settedOutputEnd : this._dueEnd;
		return this.unfinished();
	};
	Task$1.prototype.dirty = function() {
		this._dirty = true;
		this._onDirty && this._onDirty(this.context);
	};
	Task$1.prototype._doProgress = function(progress, start$1, end$1, modBy, modDataCount) {
		iterator.reset(start$1, end$1, modBy, modDataCount);
		this._callingProgress = progress;
		this._callingProgress({
			start: start$1,
			end: end$1,
			count: end$1 - start$1,
			next: iterator.next
		}, this.context);
	};
	Task$1.prototype._doReset = function(skip) {
		this._dueIndex = this._outputDueEnd = this._dueEnd = 0;
		this._settedOutputEnd = null;
		var progress;
		var forceFirstProgress;
		if (!skip && this._reset) {
			progress = this._reset(this.context);
			if (progress && progress.progress) {
				forceFirstProgress = progress.forceFirstProgress;
				progress = progress.progress;
			}
			if (isArray(progress) && !progress.length) progress = null;
		}
		this._progress = progress;
		this._modBy = this._modDataCount = null;
		var downstream = this._downstream;
		downstream && downstream.dirty();
		return forceFirstProgress;
	};
	Task$1.prototype.unfinished = function() {
		return this._progress && this._dueIndex < this._dueEnd;
	};
	/**
	
	* @param downTask The downstream task.
	
	* @return The downstream task.
	
	*/
	Task$1.prototype.pipe = function(downTask) {
		if (this._downstream !== downTask || this._dirty) {
			this._downstream = downTask;
			downTask._upstream = this;
			downTask.dirty();
		}
	};
	Task$1.prototype.dispose = function() {
		if (this._disposed) return;
		this._upstream && (this._upstream._downstream = null);
		this._downstream && (this._downstream._upstream = null);
		this._dirty = false;
		this._disposed = true;
	};
	Task$1.prototype.getUpstream = function() {
		return this._upstream;
	};
	Task$1.prototype.getDownstream = function() {
		return this._downstream;
	};
	Task$1.prototype.setOutputEnd = function(end$1) {
		this._outputDueEnd = this._settedOutputEnd = end$1;
	};
	return Task$1;
}();
var iterator = function() {
	var end$1;
	var current;
	var modBy;
	var modDataCount;
	var winCount;
	var it = { reset: function(s, e$1, sStep, sCount) {
		current = s;
		end$1 = e$1;
		modBy = sStep;
		modDataCount = sCount;
		winCount = Math.ceil(modDataCount / modBy);
		it.next = modBy > 1 && modDataCount > 0 ? modNext : sequentialNext;
	} };
	return it;
	function sequentialNext() {
		return current < end$1 ? current++ : null;
	}
	function modNext() {
		var dataIndex = current % winCount * modBy + Math.ceil(current / winCount);
		var result = current >= end$1 ? null : dataIndex < modDataCount ? dataIndex : current;
		current++;
		return result;
	}
}();
/**

* TODO: disable writable.

* This structure will be exposed to users.

*/
var ExternalSource = function() {
	function ExternalSource$1() {}
	ExternalSource$1.prototype.getRawData = function() {
		throw new Error("not supported");
	};
	ExternalSource$1.prototype.getRawDataItem = function(dataIndex) {
		throw new Error("not supported");
	};
	ExternalSource$1.prototype.cloneRawData = function() {
		return;
	};
	/**
	
	* @return If dimension not found, return null/undefined.
	
	*/
	ExternalSource$1.prototype.getDimensionInfo = function(dim) {
		return;
	};
	/**
	
	* dimensions defined if and only if either:
	
	* (a) dataset.dimensions are declared.
	
	* (b) dataset data include dimensions definitions in data (detected or via specified `sourceHeader`).
	
	* If dimensions are defined, `dimensionInfoAll` is corresponding to
	
	* the defined dimensions.
	
	* Otherwise, `dimensionInfoAll` is determined by data columns.
	
	* @return Always return an array (even empty array).
	
	*/
	ExternalSource$1.prototype.cloneAllDimensionInfo = function() {
		return;
	};
	ExternalSource$1.prototype.count = function() {
		return;
	};
	/**
	
	* Only support by dimension index.
	
	* No need to support by dimension name in transform function,
	
	* because transform function is not case-specific, no need to use name literally.
	
	*/
	ExternalSource$1.prototype.retrieveValue = function(dataIndex, dimIndex) {
		return;
	};
	ExternalSource$1.prototype.retrieveValueFromItem = function(dataItem, dimIndex) {
		return;
	};
	ExternalSource$1.prototype.convertValue = function(rawVal, dimInfo) {
		return parseDataValue(rawVal, dimInfo);
	};
	return ExternalSource$1;
}();
function createExternalSource(internalSource, externalTransform) {
	var extSource = new ExternalSource();
	var data = internalSource.data;
	var sourceFormat = extSource.sourceFormat = internalSource.sourceFormat;
	var sourceHeaderCount = internalSource.startIndex;
	var errMsg = "";
	if (internalSource.seriesLayoutBy !== SERIES_LAYOUT_BY_COLUMN) throwError(errMsg);
	var dimensions = [];
	var dimsByName = {};
	var dimsDef = internalSource.dimensionsDefine;
	if (dimsDef) each$4(dimsDef, function(dimDef, idx) {
		var name = dimDef.name;
		var dimDefExt = {
			index: idx,
			name,
			displayName: dimDef.displayName
		};
		dimensions.push(dimDefExt);
		if (name != null) {
			var errMsg_1 = "";
			if (hasOwn(dimsByName, name)) throwError(errMsg_1);
			dimsByName[name] = dimDefExt;
		}
	});
	else for (var i = 0; i < internalSource.dimensionsDetectedCount || 0; i++) dimensions.push({ index: i });
	var rawItemGetter = getRawSourceItemGetter(sourceFormat, SERIES_LAYOUT_BY_COLUMN);
	if (externalTransform.__isBuiltIn) {
		extSource.getRawDataItem = function(dataIndex) {
			return rawItemGetter(data, sourceHeaderCount, dimensions, dataIndex);
		};
		extSource.getRawData = bind$1(getRawData, null, internalSource);
	}
	extSource.cloneRawData = bind$1(cloneRawData, null, internalSource);
	var rawCounter = getRawSourceDataCounter(sourceFormat, SERIES_LAYOUT_BY_COLUMN);
	extSource.count = bind$1(rawCounter, null, data, sourceHeaderCount, dimensions);
	var rawValueGetter = getRawSourceValueGetter(sourceFormat);
	extSource.retrieveValue = function(dataIndex, dimIndex) {
		var rawItem = rawItemGetter(data, sourceHeaderCount, dimensions, dataIndex);
		return retrieveValueFromItem(rawItem, dimIndex);
	};
	var retrieveValueFromItem = extSource.retrieveValueFromItem = function(dataItem, dimIndex) {
		if (dataItem == null) return;
		var dimDef = dimensions[dimIndex];
		if (dimDef) return rawValueGetter(dataItem, dimIndex, dimDef.name);
	};
	extSource.getDimensionInfo = bind$1(getDimensionInfo, null, dimensions, dimsByName);
	extSource.cloneAllDimensionInfo = bind$1(cloneAllDimensionInfo, null, dimensions);
	return extSource;
}
function getRawData(upstream) {
	var sourceFormat = upstream.sourceFormat;
	if (!isSupportedSourceFormat(sourceFormat)) {
		var errMsg = "";
		throwError(errMsg);
	}
	return upstream.data;
}
function cloneRawData(upstream) {
	var sourceFormat = upstream.sourceFormat;
	var data = upstream.data;
	if (!isSupportedSourceFormat(sourceFormat)) {
		var errMsg = "";
		throwError(errMsg);
	}
	if (sourceFormat === SOURCE_FORMAT_ARRAY_ROWS) {
		var result = [];
		for (var i = 0, len$1 = data.length; i < len$1; i++) result.push(data[i].slice());
		return result;
	} else if (sourceFormat === SOURCE_FORMAT_OBJECT_ROWS) {
		var result = [];
		for (var i = 0, len$1 = data.length; i < len$1; i++) result.push(extend({}, data[i]));
		return result;
	}
}
function getDimensionInfo(dimensions, dimsByName, dim) {
	if (dim == null) return;
	if (isNumber(dim) || !isNaN(dim) && !hasOwn(dimsByName, dim)) return dimensions[dim];
	else if (hasOwn(dimsByName, dim)) return dimsByName[dim];
}
function cloneAllDimensionInfo(dimensions) {
	return clone$2(dimensions);
}
var externalTransformMap = createHashMap();
function registerExternalTransform(externalTransform) {
	externalTransform = clone$2(externalTransform);
	var type = externalTransform.type;
	var errMsg = "";
	if (!type) throwError(errMsg);
	var typeParsed = type.split(":");
	if (typeParsed.length !== 2) throwError(errMsg);
	var isBuiltIn = false;
	if (typeParsed[0] === "echarts") {
		type = typeParsed[1];
		isBuiltIn = true;
	}
	externalTransform.__isBuiltIn = isBuiltIn;
	externalTransformMap.set(type, externalTransform);
}
function applyDataTransform(rawTransOption, sourceList, infoForPrint) {
	var pipedTransOption = normalizeToArray(rawTransOption);
	var pipeLen = pipedTransOption.length;
	var errMsg = "";
	if (!pipeLen) throwError(errMsg);
	for (var i = 0, len$1 = pipeLen; i < len$1; i++) {
		var transOption = pipedTransOption[i];
		sourceList = applySingleDataTransform(transOption, sourceList, infoForPrint, pipeLen === 1 ? null : i);
		if (i !== len$1 - 1) sourceList.length = Math.max(sourceList.length, 1);
	}
	return sourceList;
}
function applySingleDataTransform(transOption, upSourceList, infoForPrint, pipeIndex) {
	var errMsg = "";
	if (!upSourceList.length) throwError(errMsg);
	if (!isObject$2(transOption)) throwError(errMsg);
	var transType = transOption.type;
	var externalTransform = externalTransformMap.get(transType);
	if (!externalTransform) throwError(errMsg);
	var extUpSourceList = map$1(upSourceList, function(upSource) {
		return createExternalSource(upSource, externalTransform);
	});
	var resultList = normalizeToArray(externalTransform.transform({
		upstream: extUpSourceList[0],
		upstreamList: extUpSourceList,
		config: clone$2(transOption.config)
	}));
	if (0) var printStrArr;
	return map$1(resultList, function(result, resultIndex) {
		var errMsg$1 = "";
		if (!isObject$2(result)) throwError(errMsg$1);
		if (!result.data) throwError(errMsg$1);
		var sourceFormat = detectSourceFormat(result.data);
		if (!isSupportedSourceFormat(sourceFormat)) throwError(errMsg$1);
		var resultMetaRawOption;
		var firstUpSource = upSourceList[0];
		/**
		
		* Intuitively, the end users known the content of the original `dataset.source`,
		
		* calucating the transform result in mind.
		
		* Suppose the original `dataset.source` is:
		
		* ```js
		
		* [
		
		*     ['product', '2012', '2013', '2014', '2015'],
		
		*     ['AAA', 41.1, 30.4, 65.1, 53.3],
		
		*     ['BBB', 86.5, 92.1, 85.7, 83.1],
		
		*     ['CCC', 24.1, 67.2, 79.5, 86.4]
		
		* ]
		
		* ```
		
		* The dimension info have to be detected from the source data.
		
		* Some of the transformers (like filter, sort) will follow the dimension info
		
		* of upstream, while others use new dimensions (like aggregate).
		
		* Transformer can output a field `dimensions` to define the its own output dimensions.
		
		* We also allow transformers to ignore the output `dimensions` field, and
		
		* inherit the upstream dimensions definition. It can reduce the burden of handling
		
		* dimensions in transformers.
		
		*
		
		* See also [DIMENSION_INHERIT_RULE] in `sourceManager.ts`.
		
		*/
		if (firstUpSource && resultIndex === 0 && !result.dimensions) {
			var startIndex = firstUpSource.startIndex;
			if (startIndex) result.data = firstUpSource.data.slice(0, startIndex).concat(result.data);
			resultMetaRawOption = {
				seriesLayoutBy: SERIES_LAYOUT_BY_COLUMN,
				sourceHeader: startIndex,
				dimensions: firstUpSource.metaRawOption.dimensions
			};
		} else resultMetaRawOption = {
			seriesLayoutBy: SERIES_LAYOUT_BY_COLUMN,
			sourceHeader: 0,
			dimensions: result.dimensions
		};
		return createSource(result.data, resultMetaRawOption, null);
	});
}
function isSupportedSourceFormat(sourceFormat) {
	return sourceFormat === SOURCE_FORMAT_ARRAY_ROWS || sourceFormat === SOURCE_FORMAT_OBJECT_ROWS;
}
/**

* [REQUIREMENT_MEMO]:

* (0) `metaRawOption` means `dimensions`/`sourceHeader`/`seriesLayoutBy` in raw option.

* (1) Keep support the feature: `metaRawOption` can be specified both on `series` and

* `root-dataset`. Them on `series` has higher priority.

* (2) Do not support to set `metaRawOption` on a `non-root-dataset`, because it might

* confuse users: whether those props indicate how to visit the upstream source or visit

* the transform result source, and some transforms has nothing to do with these props,

* and some transforms might have multiple upstream.

* (3) Transforms should specify `metaRawOption` in each output, just like they can be

* declared in `root-dataset`.

* (4) At present only support visit source in `SERIES_LAYOUT_BY_COLUMN` in transforms.

* That is for reducing complexity in transforms.

* PENDING: Whether to provide transposition transform?

*

* [IMPLEMENTAION_MEMO]:

* "sourceVisitConfig" are calculated from `metaRawOption` and `data`.

* They will not be calculated until `source` is about to be visited (to prevent from

* duplicate calcuation). `source` is visited only in series and input to transforms.

*

* [DIMENSION_INHERIT_RULE]:

* By default the dimensions are inherited from ancestors, unless a transform return

* a new dimensions definition.

* Consider the case:

* ```js

* dataset: [{

*     source: [ ['Product', 'Sales', 'Prise'], ['Cookies', 321, 44.21], ...]

* }, {

*     transform: { type: 'filter', ... }

* }]

* dataset: [{

*     dimension: ['Product', 'Sales', 'Prise'],

*     source: [ ['Cookies', 321, 44.21], ...]

* }, {

*     transform: { type: 'filter', ... }

* }]

* ```

* The two types of option should have the same behavior after transform.

*

*

* [SCENARIO]:

* (1) Provide source data directly:

* ```js

* series: {

*     encode: {...},

*     dimensions: [...]

*     seriesLayoutBy: 'row',

*     data: [[...]]

* }

* ```

* (2) Series refer to dataset.

* ```js

* series: [{

*     encode: {...}

*     // Ignore datasetIndex means `datasetIndex: 0`

*     // and the dimensions defination in dataset is used

* }, {

*     encode: {...},

*     seriesLayoutBy: 'column',

*     datasetIndex: 1

* }]

* ```

* (3) dataset transform

* ```js

* dataset: [{

*     source: [...]

* }, {

*     source: [...]

* }, {

*     // By default from 0.

*     transform: { type: 'filter', config: {...} }

* }, {

*     // Piped.

*     transform: [

*         { type: 'filter', config: {...} },

*         { type: 'sort', config: {...} }

*     ]

* }, {

*     id: 'regressionData',

*     fromDatasetIndex: 1,

*     // Third-party transform

*     transform: { type: 'ecStat:regression', config: {...} }

* }, {

*     // retrieve the extra result.

*     id: 'regressionFormula',

*     fromDatasetId: 'regressionData',

*     fromTransformResult: 1

* }]

* ```

*/
var SourceManager = function() {
	function SourceManager$1(sourceHost) {
		this._sourceList = [];
		this._storeList = [];
		this._upstreamSignList = [];
		this._versionSignBase = 0;
		this._dirty = true;
		this._sourceHost = sourceHost;
	}
	/**
	
	* Mark dirty.
	
	*/
	SourceManager$1.prototype.dirty = function() {
		this._setLocalSource([], []);
		this._storeList = [];
		this._dirty = true;
	};
	SourceManager$1.prototype._setLocalSource = function(sourceList, upstreamSignList) {
		this._sourceList = sourceList;
		this._upstreamSignList = upstreamSignList;
		this._versionSignBase++;
		if (this._versionSignBase > 9e10) this._versionSignBase = 0;
	};
	/**
	
	* For detecting whether the upstream source is dirty, so that
	
	* the local cached source (in `_sourceList`) should be discarded.
	
	*/
	SourceManager$1.prototype._getVersionSign = function() {
		return this._sourceHost.uid + "_" + this._versionSignBase;
	};
	/**
	
	* Always return a source instance. Otherwise throw error.
	
	*/
	SourceManager$1.prototype.prepareSource = function() {
		if (this._isDirty()) {
			this._createSource();
			this._dirty = false;
		}
	};
	SourceManager$1.prototype._createSource = function() {
		this._setLocalSource([], []);
		var sourceHost = this._sourceHost;
		var upSourceMgrList = this._getUpstreamSourceManagers();
		var hasUpstream = !!upSourceMgrList.length;
		var resultSourceList;
		var upstreamSignList;
		if (isSeries(sourceHost)) {
			var seriesModel = sourceHost;
			var data = void 0;
			var sourceFormat = void 0;
			var upSource = void 0;
			if (hasUpstream) {
				var upSourceMgr = upSourceMgrList[0];
				upSourceMgr.prepareSource();
				upSource = upSourceMgr.getSource();
				data = upSource.data;
				sourceFormat = upSource.sourceFormat;
				upstreamSignList = [upSourceMgr._getVersionSign()];
			} else {
				data = seriesModel.get("data", true);
				sourceFormat = isTypedArray(data) ? SOURCE_FORMAT_TYPED_ARRAY : SOURCE_FORMAT_ORIGINAL;
				upstreamSignList = [];
			}
			var newMetaRawOption = this._getSourceMetaRawOption() || {};
			var upMetaRawOption = upSource && upSource.metaRawOption || {};
			var seriesLayoutBy = retrieve2(newMetaRawOption.seriesLayoutBy, upMetaRawOption.seriesLayoutBy) || null;
			var sourceHeader = retrieve2(newMetaRawOption.sourceHeader, upMetaRawOption.sourceHeader);
			var dimensions = retrieve2(newMetaRawOption.dimensions, upMetaRawOption.dimensions);
			var needsCreateSource = seriesLayoutBy !== upMetaRawOption.seriesLayoutBy || !!sourceHeader !== !!upMetaRawOption.sourceHeader || dimensions;
			resultSourceList = needsCreateSource ? [createSource(data, {
				seriesLayoutBy,
				sourceHeader,
				dimensions
			}, sourceFormat)] : [];
		} else {
			var datasetModel = sourceHost;
			if (hasUpstream) {
				var result = this._applyTransform(upSourceMgrList);
				resultSourceList = result.sourceList;
				upstreamSignList = result.upstreamSignList;
			} else {
				var sourceData = datasetModel.get("source", true);
				resultSourceList = [createSource(sourceData, this._getSourceMetaRawOption(), null)];
				upstreamSignList = [];
			}
		}
		this._setLocalSource(resultSourceList, upstreamSignList);
	};
	SourceManager$1.prototype._applyTransform = function(upMgrList) {
		var datasetModel = this._sourceHost;
		var transformOption = datasetModel.get("transform", true);
		var fromTransformResult = datasetModel.get("fromTransformResult", true);
		if (fromTransformResult != null) {
			var errMsg = "";
			if (upMgrList.length !== 1) doThrow(errMsg);
		}
		var sourceList;
		var upSourceList = [];
		var upstreamSignList = [];
		each$4(upMgrList, function(upMgr) {
			upMgr.prepareSource();
			var upSource = upMgr.getSource(fromTransformResult || 0);
			var errMsg$1 = "";
			if (fromTransformResult != null && !upSource) doThrow(errMsg$1);
			upSourceList.push(upSource);
			upstreamSignList.push(upMgr._getVersionSign());
		});
		if (transformOption) sourceList = applyDataTransform(transformOption, upSourceList, { datasetIndex: datasetModel.componentIndex });
		else if (fromTransformResult != null) sourceList = [cloneSourceShallow(upSourceList[0])];
		return {
			sourceList,
			upstreamSignList
		};
	};
	SourceManager$1.prototype._isDirty = function() {
		if (this._dirty) return true;
		var upSourceMgrList = this._getUpstreamSourceManagers();
		for (var i = 0; i < upSourceMgrList.length; i++) {
			var upSrcMgr = upSourceMgrList[i];
			if (upSrcMgr._isDirty() || this._upstreamSignList[i] !== upSrcMgr._getVersionSign()) return true;
		}
	};
	/**
	
	* @param sourceIndex By default 0, means "main source".
	
	*                    In most cases there is only one source.
	
	*/
	SourceManager$1.prototype.getSource = function(sourceIndex) {
		sourceIndex = sourceIndex || 0;
		var source = this._sourceList[sourceIndex];
		if (!source) {
			var upSourceMgrList = this._getUpstreamSourceManagers();
			return upSourceMgrList[0] && upSourceMgrList[0].getSource(sourceIndex);
		}
		return source;
	};
	/**
	
	*
	
	* Get a data store which can be shared across series.
	
	* Only available for series.
	
	*
	
	* @param seriesDimRequest Dimensions that are generated in series.
	
	*        Should have been sorted by `storeDimIndex` asc.
	
	*/
	SourceManager$1.prototype.getSharedDataStore = function(seriesDimRequest) {
		var schema = seriesDimRequest.makeStoreSchema();
		return this._innerGetDataStore(schema.dimensions, seriesDimRequest.source, schema.hash);
	};
	SourceManager$1.prototype._innerGetDataStore = function(storeDims, seriesSource, sourceReadKey) {
		var sourceIndex = 0;
		var storeList = this._storeList;
		var cachedStoreMap = storeList[sourceIndex];
		if (!cachedStoreMap) cachedStoreMap = storeList[sourceIndex] = {};
		var cachedStore = cachedStoreMap[sourceReadKey];
		if (!cachedStore) {
			var upSourceMgr = this._getUpstreamSourceManagers()[0];
			if (isSeries(this._sourceHost) && upSourceMgr) cachedStore = upSourceMgr._innerGetDataStore(storeDims, seriesSource, sourceReadKey);
			else {
				cachedStore = new DataStore_default();
				cachedStore.initData(new DefaultDataProvider(seriesSource, storeDims.length), storeDims);
			}
			cachedStoreMap[sourceReadKey] = cachedStore;
		}
		return cachedStore;
	};
	/**
	
	* PENDING: Is it fast enough?
	
	* If no upstream, return empty array.
	
	*/
	SourceManager$1.prototype._getUpstreamSourceManagers = function() {
		var sourceHost = this._sourceHost;
		if (isSeries(sourceHost)) {
			var datasetModel = querySeriesUpstreamDatasetModel(sourceHost);
			return !datasetModel ? [] : [datasetModel.getSourceManager()];
		} else return map$1(queryDatasetUpstreamDatasetModels(sourceHost), function(datasetModel$1) {
			return datasetModel$1.getSourceManager();
		});
	};
	SourceManager$1.prototype._getSourceMetaRawOption = function() {
		var sourceHost = this._sourceHost;
		var seriesLayoutBy;
		var sourceHeader;
		var dimensions;
		if (isSeries(sourceHost)) {
			seriesLayoutBy = sourceHost.get("seriesLayoutBy", true);
			sourceHeader = sourceHost.get("sourceHeader", true);
			dimensions = sourceHost.get("dimensions", true);
		} else if (!this._getUpstreamSourceManagers().length) {
			var model = sourceHost;
			seriesLayoutBy = model.get("seriesLayoutBy", true);
			sourceHeader = model.get("sourceHeader", true);
			dimensions = model.get("dimensions", true);
		}
		return {
			seriesLayoutBy,
			sourceHeader,
			dimensions
		};
	};
	return SourceManager$1;
}();
function isSeries(sourceHost) {
	return sourceHost.mainType === "series";
}
function doThrow(errMsg) {
	throw new Error(errMsg);
}
var TOOLTIP_LINE_HEIGHT_CSS = "line-height:1";
function getTooltipLineHeight(textStyle) {
	var lineHeight = textStyle.lineHeight;
	if (lineHeight == null) return TOOLTIP_LINE_HEIGHT_CSS;
	else return "line-height:" + encodeHTML(lineHeight + "") + "px";
}
function getTooltipTextStyle(textStyle, renderMode) {
	var nameFontColor = textStyle.color || "#6e7079";
	var nameFontSize = textStyle.fontSize || 12;
	var nameFontWeight = textStyle.fontWeight || "400";
	var valueFontColor = textStyle.color || "#464646";
	var valueFontSize = textStyle.fontSize || 14;
	var valueFontWeight = textStyle.fontWeight || "900";
	if (renderMode === "html") return {
		nameStyle: "font-size:" + encodeHTML(nameFontSize + "") + "px;color:" + encodeHTML(nameFontColor) + ";font-weight:" + encodeHTML(nameFontWeight + ""),
		valueStyle: "font-size:" + encodeHTML(valueFontSize + "") + "px;color:" + encodeHTML(valueFontColor) + ";font-weight:" + encodeHTML(valueFontWeight + "")
	};
	else return {
		nameStyle: {
			fontSize: nameFontSize,
			fill: nameFontColor,
			fontWeight: nameFontWeight
		},
		valueStyle: {
			fontSize: valueFontSize,
			fill: valueFontColor,
			fontWeight: valueFontWeight
		}
	};
}
var HTML_GAPS = [
	0,
	10,
	20,
	30
];
var RICH_TEXT_GAPS = [
	"",
	"\n",
	"\n\n",
	"\n\n\n"
];
function createTooltipMarkup(type, option) {
	option.type = type;
	return option;
}
function isSectionFragment(frag) {
	return frag.type === "section";
}
function getBuilder(frag) {
	return isSectionFragment(frag) ? buildSection : buildNameValue;
}
function getBlockGapLevel(frag) {
	if (isSectionFragment(frag)) {
		var gapLevel_1 = 0;
		var subBlockLen = frag.blocks.length;
		var hasInnerGap_1 = subBlockLen > 1 || subBlockLen > 0 && !frag.noHeader;
		each$4(frag.blocks, function(subBlock) {
			var subGapLevel = getBlockGapLevel(subBlock);
			if (subGapLevel >= gapLevel_1) gapLevel_1 = subGapLevel + +(hasInnerGap_1 && (!subGapLevel || isSectionFragment(subBlock) && !subBlock.noHeader));
		});
		return gapLevel_1;
	}
	return 0;
}
function buildSection(ctx, fragment, topMarginForOuterGap, toolTipTextStyle) {
	var noHeader = fragment.noHeader;
	var gaps = getGap(getBlockGapLevel(fragment));
	var subMarkupTextList = [];
	var subBlocks = fragment.blocks || [];
	assert(!subBlocks || isArray(subBlocks));
	subBlocks = subBlocks || [];
	var orderMode = ctx.orderMode;
	if (fragment.sortBlocks && orderMode) {
		subBlocks = subBlocks.slice();
		var orderMap = {
			valueAsc: "asc",
			valueDesc: "desc"
		};
		if (hasOwn(orderMap, orderMode)) {
			var comparator_1 = new SortOrderComparator(orderMap[orderMode], null);
			subBlocks.sort(function(a, b) {
				return comparator_1.evaluate(a.sortParam, b.sortParam);
			});
		} else if (orderMode === "seriesDesc") subBlocks.reverse();
	}
	each$4(subBlocks, function(subBlock, idx) {
		var valueFormatter = fragment.valueFormatter;
		var subMarkupText$1 = getBuilder(subBlock)(
			// Inherit valueFormatter
			valueFormatter ? extend(extend({}, ctx), { valueFormatter }) : ctx,
			subBlock,
			idx > 0 ? gaps.html : 0,
			toolTipTextStyle
);
		subMarkupText$1 != null && subMarkupTextList.push(subMarkupText$1);
	});
	var subMarkupText = ctx.renderMode === "richText" ? subMarkupTextList.join(gaps.richText) : wrapBlockHTML(toolTipTextStyle, subMarkupTextList.join(""), noHeader ? topMarginForOuterGap : gaps.html);
	if (noHeader) return subMarkupText;
	var displayableHeader = makeValueReadable(fragment.header, "ordinal", ctx.useUTC);
	var nameStyle = getTooltipTextStyle(toolTipTextStyle, ctx.renderMode).nameStyle;
	var tooltipLineHeight = getTooltipLineHeight(toolTipTextStyle);
	if (ctx.renderMode === "richText") return wrapInlineNameRichText(ctx, displayableHeader, nameStyle) + gaps.richText + subMarkupText;
	else return wrapBlockHTML(toolTipTextStyle, "<div style=\"" + nameStyle + ";" + tooltipLineHeight + ";\">" + encodeHTML(displayableHeader) + "</div>" + subMarkupText, topMarginForOuterGap);
}
function buildNameValue(ctx, fragment, topMarginForOuterGap, toolTipTextStyle) {
	var renderMode = ctx.renderMode;
	var noName = fragment.noName;
	var noValue = fragment.noValue;
	var noMarker = !fragment.markerType;
	var name = fragment.name;
	var useUTC = ctx.useUTC;
	var valueFormatter = fragment.valueFormatter || ctx.valueFormatter || function(value) {
		value = isArray(value) ? value : [value];
		return map$1(value, function(val, idx) {
			return makeValueReadable(val, isArray(valueTypeOption) ? valueTypeOption[idx] : valueTypeOption, useUTC);
		});
	};
	if (noName && noValue) return;
	var markerStr = noMarker ? "" : ctx.markupStyleCreator.makeTooltipMarker(fragment.markerType, fragment.markerColor || "#333", renderMode);
	var readableName = noName ? "" : makeValueReadable(name, "ordinal", useUTC);
	var valueTypeOption = fragment.valueType;
	var readableValueList = noValue ? [] : valueFormatter(fragment.value, fragment.dataIndex);
	var valueAlignRight = !noMarker || !noName;
	var valueCloseToMarker = !noMarker && noName;
	var _a$1 = getTooltipTextStyle(toolTipTextStyle, renderMode), nameStyle = _a$1.nameStyle, valueStyle = _a$1.valueStyle;
	return renderMode === "richText" ? (noMarker ? "" : markerStr) + (noName ? "" : wrapInlineNameRichText(ctx, readableName, nameStyle)) + (noValue ? "" : wrapInlineValueRichText(ctx, readableValueList, valueAlignRight, valueCloseToMarker, valueStyle)) : wrapBlockHTML(toolTipTextStyle, (noMarker ? "" : markerStr) + (noName ? "" : wrapInlineNameHTML(readableName, !noMarker, nameStyle)) + (noValue ? "" : wrapInlineValueHTML(readableValueList, valueAlignRight, valueCloseToMarker, valueStyle)), topMarginForOuterGap);
}
function buildTooltipMarkup(fragment, markupStyleCreator, renderMode, orderMode, useUTC, toolTipTextStyle) {
	if (!fragment) return;
	var builder = getBuilder(fragment);
	var ctx = {
		useUTC,
		renderMode,
		orderMode,
		markupStyleCreator,
		valueFormatter: fragment.valueFormatter
	};
	return builder(ctx, fragment, 0, toolTipTextStyle);
}
function getGap(gapLevel) {
	return {
		html: HTML_GAPS[gapLevel],
		richText: RICH_TEXT_GAPS[gapLevel]
	};
}
function wrapBlockHTML(textStyle, encodedContent, topGap) {
	var clearfix = "<div style=\"clear:both\"></div>";
	var marginCSS = "margin: " + topGap + "px 0 0";
	var tooltipLineHeight = getTooltipLineHeight(textStyle);
	return "<div style=\"" + marginCSS + ";" + tooltipLineHeight + ";\">" + encodedContent + clearfix + "</div>";
}
function wrapInlineNameHTML(name, leftHasMarker, style) {
	var marginCss = leftHasMarker ? "margin-left:2px" : "";
	return "<span style=\"" + style + ";" + marginCss + "\">" + encodeHTML(name) + "</span>";
}
function wrapInlineValueHTML(valueList, alignRight, valueCloseToMarker, style) {
	var paddingStr = valueCloseToMarker ? "10px" : "20px";
	var alignCSS = alignRight ? "float:right;margin-left:" + paddingStr : "";
	valueList = isArray(valueList) ? valueList : [valueList];
	return "<span style=\"" + alignCSS + ";" + style + "\">" + map$1(valueList, function(value) {
		return encodeHTML(value);
	}).join("&nbsp;&nbsp;") + "</span>";
}
function wrapInlineNameRichText(ctx, name, style) {
	return ctx.markupStyleCreator.wrapRichTextStyle(name, style);
}
function wrapInlineValueRichText(ctx, values, alignRight, valueCloseToMarker, style) {
	var styles = [style];
	var paddingLeft = valueCloseToMarker ? 10 : 20;
	alignRight && styles.push({
		padding: [
			0,
			0,
			0,
			paddingLeft
		],
		align: "right"
	});
	return ctx.markupStyleCreator.wrapRichTextStyle(isArray(values) ? values.join("  ") : values, styles);
}
function retrieveVisualColorForTooltipMarker(series, dataIndex) {
	var style = series.getData().getItemVisual(dataIndex, "style");
	var color = style[series.visualDrawType];
	return convertToColorString(color);
}
function getPaddingFromTooltipModel(model, renderMode) {
	var padding = model.get("padding");
	return padding != null ? padding : renderMode === "richText" ? [8, 10] : 10;
}
/**

* The major feature is generate styles for `renderMode: 'richText'`.

* But it also serves `renderMode: 'html'` to provide

* "renderMode-independent" API.

*/
var TooltipMarkupStyleCreator = function() {
	function TooltipMarkupStyleCreator$1() {
		this.richTextStyles = {};
		this._nextStyleNameId = getRandomIdBase();
	}
	TooltipMarkupStyleCreator$1.prototype._generateStyleName = function() {
		return "__EC_aUTo_" + this._nextStyleNameId++;
	};
	TooltipMarkupStyleCreator$1.prototype.makeTooltipMarker = function(markerType, colorStr, renderMode) {
		var markerId = renderMode === "richText" ? this._generateStyleName() : null;
		var marker = getTooltipMarker({
			color: colorStr,
			type: markerType,
			renderMode,
			markerId
		});
		if (isString(marker)) return marker;
		else {
			this.richTextStyles[markerId] = marker.style;
			return marker.content;
		}
	};
	/**
	
	* @usage
	
	* ```ts
	
	* const styledText = markupStyleCreator.wrapRichTextStyle([
	
	*     // The styles will be auto merged.
	
	*     {
	
	*         fontSize: 12,
	
	*         color: 'blue'
	
	*     },
	
	*     {
	
	*         padding: 20
	
	*     }
	
	* ]);
	
	* ```
	
	*/
	TooltipMarkupStyleCreator$1.prototype.wrapRichTextStyle = function(text, styles) {
		var finalStl = {};
		if (isArray(styles)) each$4(styles, function(stl) {
			return extend(finalStl, stl);
		});
		else extend(finalStl, styles);
		var styleName = this._generateStyleName();
		this.richTextStyles[styleName] = finalStl;
		return "{" + styleName + "|" + text + "}";
	};
	return TooltipMarkupStyleCreator$1;
}();
function defaultSeriesFormatTooltip(opt) {
	var series = opt.series;
	var dataIndex = opt.dataIndex;
	var multipleSeries = opt.multipleSeries;
	var data = series.getData();
	var tooltipDims = data.mapDimensionsAll("defaultedTooltip");
	var tooltipDimLen = tooltipDims.length;
	var value = series.getRawValue(dataIndex);
	var isValueArr = isArray(value);
	var markerColor = retrieveVisualColorForTooltipMarker(series, dataIndex);
	var inlineValue;
	var inlineValueType;
	var subBlocks;
	var sortParam;
	if (tooltipDimLen > 1 || isValueArr && !tooltipDimLen) {
		var formatArrResult = formatTooltipArrayValue(value, series, dataIndex, tooltipDims, markerColor);
		inlineValue = formatArrResult.inlineValues;
		inlineValueType = formatArrResult.inlineValueTypes;
		subBlocks = formatArrResult.blocks;
		sortParam = formatArrResult.inlineValues[0];
	} else if (tooltipDimLen) {
		var dimInfo = data.getDimensionInfo(tooltipDims[0]);
		sortParam = inlineValue = retrieveRawValue(data, dataIndex, tooltipDims[0]);
		inlineValueType = dimInfo.type;
	} else sortParam = inlineValue = isValueArr ? value[0] : value;
	var seriesNameSpecified = isNameSpecified(series);
	var seriesName = seriesNameSpecified && series.name || "";
	var itemName = data.getName(dataIndex);
	var inlineName = multipleSeries ? seriesName : itemName;
	return createTooltipMarkup("section", {
		header: seriesName,
		noHeader: multipleSeries || !seriesNameSpecified,
		sortParam,
		blocks: [createTooltipMarkup("nameValue", {
			markerType: "item",
			markerColor,
			name: inlineName,
			noName: !trim(inlineName),
			value: inlineValue,
			valueType: inlineValueType,
			dataIndex
		})].concat(subBlocks || [])
	});
}
function formatTooltipArrayValue(value, series, dataIndex, tooltipDims, colorStr) {
	var data = series.getData();
	var isValueMultipleLine = reduce(value, function(isValueMultipleLine$1, val, idx) {
		var dimItem = data.getDimensionInfo(idx);
		return isValueMultipleLine$1 = isValueMultipleLine$1 || dimItem && dimItem.tooltip !== false && dimItem.displayName != null;
	}, false);
	var inlineValues = [];
	var inlineValueTypes = [];
	var blocks = [];
	tooltipDims.length ? each$4(tooltipDims, function(dim) {
		setEachItem(retrieveRawValue(data, dataIndex, dim), dim);
	}) : each$4(value, setEachItem);
	function setEachItem(val, dim) {
		var dimInfo = data.getDimensionInfo(dim);
		if (!dimInfo || dimInfo.otherDims.tooltip === false) return;
		if (isValueMultipleLine) blocks.push(createTooltipMarkup("nameValue", {
			markerType: "subItem",
			markerColor: colorStr,
			name: dimInfo.displayName,
			value: val,
			valueType: dimInfo.type
		}));
		else {
			inlineValues.push(val);
			inlineValueTypes.push(dimInfo.type);
		}
	}
	return {
		inlineValues,
		inlineValueTypes,
		blocks
	};
}
var inner$7 = makeInner();
function getSelectionKey(data, dataIndex) {
	return data.getName(dataIndex) || data.getId(dataIndex);
}
var SERIES_UNIVERSAL_TRANSITION_PROP = "__universalTransitionEnabled";
var SeriesModel = function(_super) {
	__extends(SeriesModel$1, _super);
	function SeriesModel$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._selectedDataIndicesMap = {};
		return _this;
	}
	SeriesModel$1.prototype.init = function(option, parentModel, ecModel) {
		this.seriesIndex = this.componentIndex;
		this.dataTask = createTask({
			count: dataTaskCount,
			reset: dataTaskReset
		});
		this.dataTask.context = { model: this };
		this.mergeDefaultAndTheme(option, ecModel);
		var sourceManager = inner$7(this).sourceManager = new SourceManager(this);
		sourceManager.prepareSource();
		var data = this.getInitialData(option, ecModel);
		wrapData(data, this);
		this.dataTask.context.data = data;
		inner$7(this).dataBeforeProcessed = data;
		autoSeriesName(this);
		this._initSelectedMapFromData(data);
	};
	/**
	
	* Util for merge default and theme to option
	
	*/
	SeriesModel$1.prototype.mergeDefaultAndTheme = function(option, ecModel) {
		var layoutMode = fetchLayoutMode(this);
		var inputPositionParams = layoutMode ? getLayoutParams(option) : {};
		var themeSubType = this.subType;
		if (Component_default$1.hasClass(themeSubType)) themeSubType += "Series";
		merge(option, ecModel.getTheme().get(this.subType));
		merge(option, this.getDefaultOption());
		defaultEmphasis(option, "label", ["show"]);
		this.fillDataTextStyle(option.data);
		if (layoutMode) mergeLayoutParam(option, inputPositionParams, layoutMode);
	};
	SeriesModel$1.prototype.mergeOption = function(newSeriesOption, ecModel) {
		newSeriesOption = merge(this.option, newSeriesOption, true);
		this.fillDataTextStyle(newSeriesOption.data);
		var layoutMode = fetchLayoutMode(this);
		if (layoutMode) mergeLayoutParam(this.option, newSeriesOption, layoutMode);
		var sourceManager = inner$7(this).sourceManager;
		sourceManager.dirty();
		sourceManager.prepareSource();
		var data = this.getInitialData(newSeriesOption, ecModel);
		wrapData(data, this);
		this.dataTask.dirty();
		this.dataTask.context.data = data;
		inner$7(this).dataBeforeProcessed = data;
		autoSeriesName(this);
		this._initSelectedMapFromData(data);
	};
	SeriesModel$1.prototype.fillDataTextStyle = function(data) {
		if (data && !isTypedArray(data)) {
			var props = ["show"];
			for (var i = 0; i < data.length; i++) if (data[i] && data[i].label) defaultEmphasis(data[i], "label", props);
		}
	};
	/**
	
	* Init a data structure from data related option in series
	
	* Must be overridden.
	
	*/
	SeriesModel$1.prototype.getInitialData = function(option, ecModel) {
		return;
	};
	/**
	
	* Append data to list
	
	*/
	SeriesModel$1.prototype.appendData = function(params) {
		var data = this.getRawData();
		data.appendData(params.data);
	};
	/**
	
	* Consider some method like `filter`, `map` need make new data,
	
	* We should make sure that `seriesModel.getData()` get correct
	
	* data in the stream procedure. So we fetch data from upstream
	
	* each time `task.perform` called.
	
	*/
	SeriesModel$1.prototype.getData = function(dataType) {
		var task = getCurrentTask(this);
		if (task) {
			var data = task.context.data;
			return dataType == null || !data.getLinkedData ? data : data.getLinkedData(dataType);
		} else return inner$7(this).data;
	};
	SeriesModel$1.prototype.getAllData = function() {
		var mainData = this.getData();
		return mainData && mainData.getLinkedDataAll ? mainData.getLinkedDataAll() : [{ data: mainData }];
	};
	SeriesModel$1.prototype.setData = function(data) {
		var task = getCurrentTask(this);
		if (task) {
			var context = task.context;
			context.outputData = data;
			if (task !== this.dataTask) context.data = data;
		}
		inner$7(this).data = data;
	};
	SeriesModel$1.prototype.getEncode = function() {
		var encode = this.get("encode", true);
		if (encode) return createHashMap(encode);
	};
	SeriesModel$1.prototype.getSourceManager = function() {
		return inner$7(this).sourceManager;
	};
	SeriesModel$1.prototype.getSource = function() {
		return this.getSourceManager().getSource();
	};
	/**
	
	* Get data before processed
	
	*/
	SeriesModel$1.prototype.getRawData = function() {
		return inner$7(this).dataBeforeProcessed;
	};
	SeriesModel$1.prototype.getColorBy = function() {
		var colorBy = this.get("colorBy");
		return colorBy || "series";
	};
	SeriesModel$1.prototype.isColorBySeries = function() {
		return this.getColorBy() === "series";
	};
	/**
	
	* Get base axis if has coordinate system and has axis.
	
	* By default use coordSys.getBaseAxis();
	
	* Can be overridden for some chart.
	
	* @return {type} description
	
	*/
	SeriesModel$1.prototype.getBaseAxis = function() {
		var coordSys = this.coordinateSystem;
		return coordSys && coordSys.getBaseAxis && coordSys.getBaseAxis();
	};
	/**
	
	* Default tooltip formatter
	
	*
	
	* @param dataIndex
	
	* @param multipleSeries
	
	* @param dataType
	
	* @param renderMode valid values: 'html'(by default) and 'richText'.
	
	*        'html' is used for rendering tooltip in extra DOM form, and the result
	
	*        string is used as DOM HTML content.
	
	*        'richText' is used for rendering tooltip in rich text form, for those where
	
	*        DOM operation is not supported.
	
	* @return formatted tooltip with `html` and `markers`
	
	*        Notice: The override method can also return string
	
	*/
	SeriesModel$1.prototype.formatTooltip = function(dataIndex, multipleSeries, dataType) {
		return defaultSeriesFormatTooltip({
			series: this,
			dataIndex,
			multipleSeries
		});
	};
	SeriesModel$1.prototype.isAnimationEnabled = function() {
		var ecModel = this.ecModel;
		if (env_default.node && !(ecModel && ecModel.ssr)) return false;
		var animationEnabled = this.getShallow("animation");
		if (animationEnabled) {
			if (this.getData().count() > this.getShallow("animationThreshold")) animationEnabled = false;
		}
		return !!animationEnabled;
	};
	SeriesModel$1.prototype.restoreData = function() {
		this.dataTask.dirty();
	};
	SeriesModel$1.prototype.getColorFromPalette = function(name, scope, requestColorNum) {
		var ecModel = this.ecModel;
		var color = PaletteMixin.prototype.getColorFromPalette.call(this, name, scope, requestColorNum);
		if (!color) color = ecModel.getColorFromPalette(name, scope, requestColorNum);
		return color;
	};
	/**
	
	* Use `data.mapDimensionsAll(coordDim)` instead.
	
	* @deprecated
	
	*/
	SeriesModel$1.prototype.coordDimToDataDim = function(coordDim) {
		return this.getRawData().mapDimensionsAll(coordDim);
	};
	/**
	
	* Get progressive rendering count each step
	
	*/
	SeriesModel$1.prototype.getProgressive = function() {
		return this.get("progressive");
	};
	/**
	
	* Get progressive rendering count each step
	
	*/
	SeriesModel$1.prototype.getProgressiveThreshold = function() {
		return this.get("progressiveThreshold");
	};
	SeriesModel$1.prototype.select = function(innerDataIndices, dataType) {
		this._innerSelect(this.getData(dataType), innerDataIndices);
	};
	SeriesModel$1.prototype.unselect = function(innerDataIndices, dataType) {
		var selectedMap = this.option.selectedMap;
		if (!selectedMap) return;
		var selectedMode = this.option.selectedMode;
		var data = this.getData(dataType);
		if (selectedMode === "series" || selectedMap === "all") {
			this.option.selectedMap = {};
			this._selectedDataIndicesMap = {};
			return;
		}
		for (var i = 0; i < innerDataIndices.length; i++) {
			var dataIndex = innerDataIndices[i];
			var nameOrId = getSelectionKey(data, dataIndex);
			selectedMap[nameOrId] = false;
			this._selectedDataIndicesMap[nameOrId] = -1;
		}
	};
	SeriesModel$1.prototype.toggleSelect = function(innerDataIndices, dataType) {
		var tmpArr = [];
		for (var i = 0; i < innerDataIndices.length; i++) {
			tmpArr[0] = innerDataIndices[i];
			this.isSelected(innerDataIndices[i], dataType) ? this.unselect(tmpArr, dataType) : this.select(tmpArr, dataType);
		}
	};
	SeriesModel$1.prototype.getSelectedDataIndices = function() {
		if (this.option.selectedMap === "all") return [].slice.call(this.getData().getIndices());
		var selectedDataIndicesMap = this._selectedDataIndicesMap;
		var nameOrIds = keys(selectedDataIndicesMap);
		var dataIndices = [];
		for (var i = 0; i < nameOrIds.length; i++) {
			var dataIndex = selectedDataIndicesMap[nameOrIds[i]];
			if (dataIndex >= 0) dataIndices.push(dataIndex);
		}
		return dataIndices;
	};
	SeriesModel$1.prototype.isSelected = function(dataIndex, dataType) {
		var selectedMap = this.option.selectedMap;
		if (!selectedMap) return false;
		var data = this.getData(dataType);
		return (selectedMap === "all" || selectedMap[getSelectionKey(data, dataIndex)]) && !data.getItemModel(dataIndex).get(["select", "disabled"]);
	};
	SeriesModel$1.prototype.isUniversalTransitionEnabled = function() {
		if (this[SERIES_UNIVERSAL_TRANSITION_PROP]) return true;
		var universalTransitionOpt = this.option.universalTransition;
		if (!universalTransitionOpt) return false;
		if (universalTransitionOpt === true) return true;
		return universalTransitionOpt && universalTransitionOpt.enabled;
	};
	SeriesModel$1.prototype._innerSelect = function(data, innerDataIndices) {
		var _a$1, _b$1;
		var option = this.option;
		var selectedMode = option.selectedMode;
		var len$1 = innerDataIndices.length;
		if (!selectedMode || !len$1) return;
		if (selectedMode === "series") option.selectedMap = "all";
		else if (selectedMode === "multiple") {
			if (!isObject$2(option.selectedMap)) option.selectedMap = {};
			var selectedMap = option.selectedMap;
			for (var i = 0; i < len$1; i++) {
				var dataIndex = innerDataIndices[i];
				var nameOrId = getSelectionKey(data, dataIndex);
				selectedMap[nameOrId] = true;
				this._selectedDataIndicesMap[nameOrId] = data.getRawIndex(dataIndex);
			}
		} else if (selectedMode === "single" || selectedMode === true) {
			var lastDataIndex = innerDataIndices[len$1 - 1];
			var nameOrId = getSelectionKey(data, lastDataIndex);
			option.selectedMap = (_a$1 = {}, _a$1[nameOrId] = true, _a$1);
			this._selectedDataIndicesMap = (_b$1 = {}, _b$1[nameOrId] = data.getRawIndex(lastDataIndex), _b$1);
		}
	};
	SeriesModel$1.prototype._initSelectedMapFromData = function(data) {
		if (this.option.selectedMap) return;
		var dataIndices = [];
		if (data.hasItemOption) data.each(function(idx) {
			var rawItem = data.getRawDataItem(idx);
			if (rawItem && rawItem.selected) dataIndices.push(idx);
		});
		if (dataIndices.length > 0) this._innerSelect(data, dataIndices);
	};
	SeriesModel$1.registerClass = function(clz) {
		return Component_default$1.registerClass(clz);
	};
	SeriesModel$1.protoInitialize = function() {
		var proto$1 = SeriesModel$1.prototype;
		proto$1.type = "series.__base__";
		proto$1.seriesIndex = 0;
		proto$1.ignoreStyleOnData = false;
		proto$1.hasSymbolVisual = false;
		proto$1.defaultSymbol = "circle";
		proto$1.visualStyleAccessPath = "itemStyle";
		proto$1.visualDrawType = "fill";
	}();
	return SeriesModel$1;
}(Component_default$1);
mixin(SeriesModel, DataFormatMixin);
mixin(SeriesModel, PaletteMixin);
mountExtend(SeriesModel, Component_default$1);
/**

* MUST be called after `prepareSource` called

* Here we need to make auto series, especially for auto legend. But we

* do not modify series.name in option to avoid side effects.

*/
function autoSeriesName(seriesModel) {
	var name = seriesModel.name;
	if (!isNameSpecified(seriesModel)) seriesModel.name = getSeriesAutoName(seriesModel) || name;
}
function getSeriesAutoName(seriesModel) {
	var data = seriesModel.getRawData();
	var dataDims = data.mapDimensionsAll("seriesName");
	var nameArr = [];
	each$4(dataDims, function(dataDim) {
		var dimInfo = data.getDimensionInfo(dataDim);
		dimInfo.displayName && nameArr.push(dimInfo.displayName);
	});
	return nameArr.join(" ");
}
function dataTaskCount(context) {
	return context.model.getRawData().count();
}
function dataTaskReset(context) {
	var seriesModel = context.model;
	seriesModel.setData(seriesModel.getRawData().cloneShallow());
	return dataTaskProgress;
}
function dataTaskProgress(param, context) {
	if (context.outputData && param.end > context.outputData.count()) context.model.getRawData().cloneShallow(context.outputData);
}
function wrapData(data, seriesModel) {
	each$4(concatArray(data.CHANGABLE_METHODS, data.DOWNSAMPLE_METHODS), function(methodName) {
		data.wrapMethod(methodName, curry$1(onDataChange, seriesModel));
	});
}
function onDataChange(seriesModel, newList) {
	var task = getCurrentTask(seriesModel);
	if (task) task.setOutputEnd((newList || this).count());
	return newList;
}
function getCurrentTask(seriesModel) {
	var scheduler = (seriesModel.ecModel || {}).scheduler;
	var pipeline = scheduler && scheduler.getPipeline(seriesModel.uid);
	if (pipeline) {
		var task = pipeline.currentTask;
		if (task) {
			var agentStubMap = task.agentStubMap;
			if (agentStubMap) task = agentStubMap.get(seriesModel.uid);
		}
		return task;
	}
}
var Series_default = SeriesModel;
/**

* Triangle shape

* @inner

*/
var Triangle = Path_default.extend({
	type: "triangle",
	shape: {
		cx: 0,
		cy: 0,
		width: 0,
		height: 0
	},
	buildPath: function(path, shape) {
		var cx = shape.cx;
		var cy = shape.cy;
		var width = shape.width / 2;
		var height = shape.height / 2;
		path.moveTo(cx, cy - height);
		path.lineTo(cx + width, cy + height);
		path.lineTo(cx - width, cy + height);
		path.closePath();
	}
});
/**

* Diamond shape

* @inner

*/
var Diamond = Path_default.extend({
	type: "diamond",
	shape: {
		cx: 0,
		cy: 0,
		width: 0,
		height: 0
	},
	buildPath: function(path, shape) {
		var cx = shape.cx;
		var cy = shape.cy;
		var width = shape.width / 2;
		var height = shape.height / 2;
		path.moveTo(cx, cy - height);
		path.lineTo(cx + width, cy);
		path.lineTo(cx, cy + height);
		path.lineTo(cx - width, cy);
		path.closePath();
	}
});
/**

* Pin shape

* @inner

*/
var Pin = Path_default.extend({
	type: "pin",
	shape: {
		x: 0,
		y: 0,
		width: 0,
		height: 0
	},
	buildPath: function(path, shape) {
		var x = shape.x;
		var y = shape.y;
		var w = shape.width / 5 * 3;
		var h$1 = Math.max(w, shape.height);
		var r = w / 2;
		var dy = r * r / (h$1 - r);
		var cy = y - h$1 + r + dy;
		var angle = Math.asin(dy / r);
		var dx = Math.cos(angle) * r;
		var tanX = Math.sin(angle);
		var tanY = Math.cos(angle);
		var cpLen = r * .6;
		var cpLen2 = r * .7;
		path.moveTo(x - dx, cy + dy);
		path.arc(x, cy, r, Math.PI - angle, Math.PI * 2 + angle);
		path.bezierCurveTo(x + dx - tanX * cpLen, cy + dy + tanY * cpLen, x, y - cpLen2, x, y);
		path.bezierCurveTo(x, y - cpLen2, x - dx + tanX * cpLen, cy + dy + tanY * cpLen, x - dx, cy + dy);
		path.closePath();
	}
});
/**

* Arrow shape

* @inner

*/
var Arrow = Path_default.extend({
	type: "arrow",
	shape: {
		x: 0,
		y: 0,
		width: 0,
		height: 0
	},
	buildPath: function(ctx, shape) {
		var height = shape.height;
		var width = shape.width;
		var x = shape.x;
		var y = shape.y;
		var dx = width / 3 * 2;
		ctx.moveTo(x, y);
		ctx.lineTo(x + dx, y + height);
		ctx.lineTo(x, y + height / 4 * 3);
		ctx.lineTo(x - dx, y + height);
		ctx.lineTo(x, y);
		ctx.closePath();
	}
});
/**

* Map of path constructors

*/
var symbolCtors = {
	line: Line_default,
	rect: Rect_default,
	roundRect: Rect_default,
	square: Rect_default,
	circle: Circle_default,
	diamond: Diamond,
	pin: Pin,
	arrow: Arrow,
	triangle: Triangle
};
var symbolShapeMakers = {
	line: function(x, y, w, h$1, shape) {
		shape.x1 = x;
		shape.y1 = y + h$1 / 2;
		shape.x2 = x + w;
		shape.y2 = y + h$1 / 2;
	},
	rect: function(x, y, w, h$1, shape) {
		shape.x = x;
		shape.y = y;
		shape.width = w;
		shape.height = h$1;
	},
	roundRect: function(x, y, w, h$1, shape) {
		shape.x = x;
		shape.y = y;
		shape.width = w;
		shape.height = h$1;
		shape.r = Math.min(w, h$1) / 4;
	},
	square: function(x, y, w, h$1, shape) {
		var size = Math.min(w, h$1);
		shape.x = x;
		shape.y = y;
		shape.width = size;
		shape.height = size;
	},
	circle: function(x, y, w, h$1, shape) {
		shape.cx = x + w / 2;
		shape.cy = y + h$1 / 2;
		shape.r = Math.min(w, h$1) / 2;
	},
	diamond: function(x, y, w, h$1, shape) {
		shape.cx = x + w / 2;
		shape.cy = y + h$1 / 2;
		shape.width = w;
		shape.height = h$1;
	},
	pin: function(x, y, w, h$1, shape) {
		shape.x = x + w / 2;
		shape.y = y + h$1 / 2;
		shape.width = w;
		shape.height = h$1;
	},
	arrow: function(x, y, w, h$1, shape) {
		shape.x = x + w / 2;
		shape.y = y + h$1 / 2;
		shape.width = w;
		shape.height = h$1;
	},
	triangle: function(x, y, w, h$1, shape) {
		shape.cx = x + w / 2;
		shape.cy = y + h$1 / 2;
		shape.width = w;
		shape.height = h$1;
	}
};
var symbolBuildProxies = {};
each$4(symbolCtors, function(Ctor, name) {
	symbolBuildProxies[name] = new Ctor();
});
var SymbolClz = Path_default.extend({
	type: "symbol",
	shape: {
		symbolType: "",
		x: 0,
		y: 0,
		width: 0,
		height: 0
	},
	calculateTextPosition: function(out$1, config, rect) {
		var res = calculateTextPosition(out$1, config, rect);
		var shape = this.shape;
		if (shape && shape.symbolType === "pin" && config.position === "inside") res.y = rect.y + rect.height * .4;
		return res;
	},
	buildPath: function(ctx, shape, inBundle) {
		var symbolType = shape.symbolType;
		if (symbolType !== "none") {
			var proxySymbol = symbolBuildProxies[symbolType];
			if (!proxySymbol) {
				symbolType = "rect";
				proxySymbol = symbolBuildProxies[symbolType];
			}
			symbolShapeMakers[symbolType](shape.x, shape.y, shape.width, shape.height, proxySymbol.shape);
			proxySymbol.buildPath(ctx, proxySymbol.shape, inBundle);
		}
	}
});
function symbolPathSetColor(color, innerColor$1) {
	if (this.type !== "image") {
		var symbolStyle = this.style;
		if (this.__isEmptyBrush) {
			symbolStyle.stroke = color;
			symbolStyle.fill = innerColor$1 || "#fff";
			symbolStyle.lineWidth = 2;
		} else if (this.shape.symbolType === "line") symbolStyle.stroke = color;
		else symbolStyle.fill = color;
		this.markRedraw();
	}
}
function createSymbol(symbolType, x, y, w, h$1, color, keepAspect) {
	var isEmpty = symbolType.indexOf("empty") === 0;
	if (isEmpty) symbolType = symbolType.substr(5, 1).toLowerCase() + symbolType.substr(6);
	var symbolPath;
	if (symbolType.indexOf("image://") === 0) symbolPath = makeImage(symbolType.slice(8), new BoundingRect_default(x, y, w, h$1), keepAspect ? "center" : "cover");
	else if (symbolType.indexOf("path://") === 0) symbolPath = makePath(symbolType.slice(7), {}, new BoundingRect_default(x, y, w, h$1), keepAspect ? "center" : "cover");
	else symbolPath = new SymbolClz({ shape: {
		symbolType,
		x,
		y,
		width: w,
		height: h$1
	} });
	symbolPath.__isEmptyBrush = isEmpty;
	symbolPath.setColor = symbolPathSetColor;
	if (color) symbolPath.setColor(color);
	return symbolPath;
}
function normalizeSymbolOffset(symbolOffset, symbolSize) {
	if (symbolOffset == null) return;
	if (!isArray(symbolOffset)) symbolOffset = [symbolOffset, symbolOffset];
	return [parsePercent(symbolOffset[0], symbolSize[0]) || 0, parsePercent(retrieve2(symbolOffset[1], symbolOffset[0]), symbolSize[1]) || 0];
}
function getDefaultLabel(data, dataIndex) {
	var labelDims = data.mapDimensionsAll("defaultedLabel");
	var len$1 = labelDims.length;
	if (len$1 === 1) {
		var rawVal = retrieveRawValue(data, dataIndex, labelDims[0]);
		return rawVal != null ? rawVal + "" : null;
	} else if (len$1) {
		var vals = [];
		for (var i = 0; i < labelDims.length; i++) vals.push(retrieveRawValue(data, dataIndex, labelDims[i]));
		return vals.join(" ");
	}
}
function getDefaultInterpolatedLabel(data, interpolatedValue) {
	var labelDims = data.mapDimensionsAll("defaultedLabel");
	if (!isArray(interpolatedValue)) return interpolatedValue + "";
	var vals = [];
	for (var i = 0; i < labelDims.length; i++) {
		var dimIndex = data.getDimensionIndex(labelDims[i]);
		if (dimIndex >= 0) vals.push(interpolatedValue[dimIndex]);
	}
	return vals.join(" ");
}
var supportFloat32Array = typeof Float32Array !== "undefined";
var Float32ArrayCtor = !supportFloat32Array ? Array : Float32Array;
function createFloat32Array(arg) {
	if (isArray(arg)) return supportFloat32Array ? new Float32Array(arg) : arg;
	return new Float32ArrayCtor(arg);
}
function createRenderPlanner() {
	var inner$10 = makeInner();
	return function(seriesModel) {
		var fields = inner$10(seriesModel);
		var pipelineContext = seriesModel.pipelineContext;
		var originalLarge = !!fields.large;
		var originalProgressive = !!fields.progressiveRender;
		var large = fields.large = !!(pipelineContext && pipelineContext.large);
		var progressive = fields.progressiveRender = !!(pipelineContext && pipelineContext.progressiveRender);
		return !!(originalLarge !== large || originalProgressive !== progressive) && "reset";
	};
}
var inner$6 = makeInner();
var renderPlanner = createRenderPlanner();
var ChartView = function() {
	function ChartView$1() {
		this.group = new Group_default();
		this.uid = getUID("viewChart");
		this.renderTask = createTask({
			plan: renderTaskPlan,
			reset: renderTaskReset
		});
		this.renderTask.context = { view: this };
	}
	ChartView$1.prototype.init = function(ecModel, api) {};
	ChartView$1.prototype.render = function(seriesModel, ecModel, api, payload) {};
	/**
	
	* Highlight series or specified data item.
	
	*/
	ChartView$1.prototype.highlight = function(seriesModel, ecModel, api, payload) {
		var data = seriesModel.getData(payload && payload.dataType);
		if (!data) return;
		toggleHighlight(data, payload, "emphasis");
	};
	/**
	
	* Downplay series or specified data item.
	
	*/
	ChartView$1.prototype.downplay = function(seriesModel, ecModel, api, payload) {
		var data = seriesModel.getData(payload && payload.dataType);
		if (!data) return;
		toggleHighlight(data, payload, "normal");
	};
	/**
	
	* Remove self.
	
	*/
	ChartView$1.prototype.remove = function(ecModel, api) {
		this.group.removeAll();
	};
	/**
	
	* Dispose self.
	
	*/
	ChartView$1.prototype.dispose = function(ecModel, api) {};
	ChartView$1.prototype.updateView = function(seriesModel, ecModel, api, payload) {
		this.render(seriesModel, ecModel, api, payload);
	};
	ChartView$1.prototype.updateLayout = function(seriesModel, ecModel, api, payload) {
		this.render(seriesModel, ecModel, api, payload);
	};
	ChartView$1.prototype.updateVisual = function(seriesModel, ecModel, api, payload) {
		this.render(seriesModel, ecModel, api, payload);
	};
	/**
	
	* Traverse the new rendered elements.
	
	*
	
	* It will traverse the new added element in progressive rendering.
	
	* And traverse all in normal rendering.
	
	*/
	ChartView$1.prototype.eachRendered = function(cb) {
		traverseElements(this.group, cb);
	};
	ChartView$1.markUpdateMethod = function(payload, methodName) {
		inner$6(payload).updateMethod = methodName;
	};
	ChartView$1.protoInitialize = function() {
		var proto$1 = ChartView$1.prototype;
		proto$1.type = "chart";
	}();
	return ChartView$1;
}();
/**

* Set state of single element

*/
function elSetState(el, state, highlightDigit) {
	if (el && isHighDownDispatcher(el)) (state === "emphasis" ? enterEmphasis : leaveEmphasis)(el, highlightDigit);
}
function toggleHighlight(data, payload, state) {
	var dataIndex = queryDataIndex(data, payload);
	var highlightDigit = payload && payload.highlightKey != null ? getHighlightDigit(payload.highlightKey) : null;
	if (dataIndex != null) each$4(normalizeToArray(dataIndex), function(dataIdx) {
		elSetState(data.getItemGraphicEl(dataIdx), state, highlightDigit);
	});
	else data.eachItemGraphicEl(function(el) {
		elSetState(el, state, highlightDigit);
	});
}
enableClassExtend(ChartView, ["dispose"]);
enableClassManagement(ChartView);
function renderTaskPlan(context) {
	return renderPlanner(context.model);
}
function renderTaskReset(context) {
	var seriesModel = context.model;
	var ecModel = context.ecModel;
	var api = context.api;
	var payload = context.payload;
	var progressiveRender = seriesModel.pipelineContext.progressiveRender;
	var view = context.view;
	var updateMethod = payload && inner$6(payload).updateMethod;
	var methodName = progressiveRender ? "incrementalPrepareRender" : updateMethod && view[updateMethod] ? updateMethod : "render";
	if (methodName !== "render") view[methodName](seriesModel, ecModel, api, payload);
	return progressMethodMap[methodName];
}
var progressMethodMap = {
	incrementalPrepareRender: { progress: function(params, context) {
		context.view.incrementalRender(params, context.model, context.ecModel, context.api, context.payload);
	} },
	render: {
		forceFirstProgress: true,
		progress: function(params, context) {
			context.view.render(context.model, context.ecModel, context.api, context.payload);
		}
	}
};
var Chart_default = ChartView;
function createGridClipPath(cartesian, hasAnimation, seriesModel, done, during) {
	var rect = cartesian.getArea();
	var x = rect.x;
	var y = rect.y;
	var width = rect.width;
	var height = rect.height;
	var lineWidth = seriesModel.get(["lineStyle", "width"]) || 0;
	x -= lineWidth / 2;
	y -= lineWidth / 2;
	width += lineWidth;
	height += lineWidth;
	width = Math.ceil(width);
	if (x !== Math.floor(x)) {
		x = Math.floor(x);
		width++;
	}
	var clipPath = new Rect_default({ shape: {
		x,
		y,
		width,
		height
	} });
	if (hasAnimation) {
		var baseAxis = cartesian.getBaseAxis();
		var isHorizontal = baseAxis.isHorizontal();
		var isAxisInversed = baseAxis.inverse;
		if (isHorizontal) {
			if (isAxisInversed) clipPath.shape.x += width;
			clipPath.shape.width = 0;
		} else {
			if (!isAxisInversed) clipPath.shape.y += height;
			clipPath.shape.height = 0;
		}
		var duringCb = isFunction(during) ? function(percent) {
			during(percent, clipPath);
		} : null;
		initProps(clipPath, { shape: {
			width,
			height,
			x,
			y
		} }, seriesModel, null, done, duringCb);
	}
	return clipPath;
}
function createPolarClipPath(polar, hasAnimation, seriesModel) {
	var sectorArea = polar.getArea();
	var r0 = round(sectorArea.r0, 1);
	var r = round(sectorArea.r, 1);
	var clipPath = new Sector_default({ shape: {
		cx: round(polar.cx, 1),
		cy: round(polar.cy, 1),
		r0,
		r,
		startAngle: sectorArea.startAngle,
		endAngle: sectorArea.endAngle,
		clockwise: sectorArea.clockwise
	} });
	if (hasAnimation) {
		var isRadial = polar.getBaseAxis().dim === "angle";
		if (isRadial) clipPath.shape.endAngle = sectorArea.startAngle;
		else clipPath.shape.r = r0;
		initProps(clipPath, { shape: {
			endAngle: sectorArea.endAngle,
			r
		} }, seriesModel);
	}
	return clipPath;
}
function createClipPath(coordSys, hasAnimation, seriesModel, done, during) {
	if (!coordSys) return null;
	else if (coordSys.type === "polar") return createPolarClipPath(coordSys, hasAnimation, seriesModel);
	else if (coordSys.type === "cartesian2d") return createGridClipPath(coordSys, hasAnimation, seriesModel, done, during);
	return null;
}
function isCoordinateSystemType(coordSys, type) {
	return coordSys.type === type;
}
var samplers = {
	average: function(frame) {
		var sum = 0;
		var count = 0;
		for (var i = 0; i < frame.length; i++) if (!isNaN(frame[i])) {
			sum += frame[i];
			count++;
		}
		return count === 0 ? NaN : sum / count;
	},
	sum: function(frame) {
		var sum = 0;
		for (var i = 0; i < frame.length; i++) sum += frame[i] || 0;
		return sum;
	},
	max: function(frame) {
		var max$2 = -Infinity;
		for (var i = 0; i < frame.length; i++) frame[i] > max$2 && (max$2 = frame[i]);
		return isFinite(max$2) ? max$2 : NaN;
	},
	min: function(frame) {
		var min$2 = Infinity;
		for (var i = 0; i < frame.length; i++) frame[i] < min$2 && (min$2 = frame[i]);
		return isFinite(min$2) ? min$2 : NaN;
	},
	nearest: function(frame) {
		return frame[0];
	}
};
var indexSampler = function(frame) {
	return Math.round(frame.length / 2);
};
function dataSample(seriesType$1) {
	return {
		seriesType: seriesType$1,
		reset: function(seriesModel, ecModel, api) {
			var data = seriesModel.getData();
			var sampling = seriesModel.get("sampling");
			var coordSys = seriesModel.coordinateSystem;
			var count = data.count();
			if (count > 10 && coordSys.type === "cartesian2d" && sampling) {
				var baseAxis = coordSys.getBaseAxis();
				var valueAxis$1 = coordSys.getOtherAxis(baseAxis);
				var extent$1 = baseAxis.getExtent();
				var dpr$1 = api.getDevicePixelRatio();
				var size = Math.abs(extent$1[1] - extent$1[0]) * (dpr$1 || 1);
				var rate = Math.round(count / size);
				if (isFinite(rate) && rate > 1) {
					if (sampling === "lttb") seriesModel.setData(data.lttbDownSample(data.mapDimension(valueAxis$1.dim), 1 / rate));
					else if (sampling === "minmax") seriesModel.setData(data.minmaxDownSample(data.mapDimension(valueAxis$1.dim), 1 / rate));
					var sampler = void 0;
					if (isString(sampling)) sampler = samplers[sampling];
					else if (isFunction(sampling)) sampler = sampling;
					if (sampler) seriesModel.setData(data.downSample(data.mapDimension(valueAxis$1.dim), 1 / rate, sampler, indexSampler));
				}
			}
		}
	};
}
var STACK_PREFIX = "__ec_stack_";
function getSeriesStackId(seriesModel) {
	return seriesModel.get("stack") || STACK_PREFIX + seriesModel.seriesIndex;
}
function getAxisKey(axis) {
	return axis.dim + axis.index;
}
function prepareLayoutBarSeries(seriesType$1, ecModel) {
	var seriesModels = [];
	ecModel.eachSeriesByType(seriesType$1, function(seriesModel) {
		if (isOnCartesian(seriesModel)) seriesModels.push(seriesModel);
	});
	return seriesModels;
}
/**

* Map from (baseAxis.dim + '_' + baseAxis.index) to min gap of two adjacent

* values.

* This works for time axes, value axes, and log axes.

* For a single time axis, return value is in the form like

* {'x_0': [1000000]}.

* The value of 1000000 is in milliseconds.

*/
function getValueAxesMinGaps(barSeries) {
	/**
	
	* Map from axis.index to values.
	
	* For a single time axis, axisValues is in the form like
	
	* {'x_0': [1495555200000, 1495641600000, 1495728000000]}.
	
	* Items in axisValues[x], e.g. 1495555200000, are time values of all
	
	* series.
	
	*/
	var axisValues = {};
	each$4(barSeries, function(seriesModel) {
		var cartesian = seriesModel.coordinateSystem;
		var baseAxis = cartesian.getBaseAxis();
		if (baseAxis.type !== "time" && baseAxis.type !== "value") return;
		var data = seriesModel.getData();
		var key$1 = baseAxis.dim + "_" + baseAxis.index;
		var dimIdx = data.getDimensionIndex(data.mapDimension(baseAxis.dim));
		var store = data.getStore();
		for (var i = 0, cnt = store.count(); i < cnt; ++i) {
			var value = store.get(dimIdx, i);
			if (!axisValues[key$1]) axisValues[key$1] = [value];
			else axisValues[key$1].push(value);
		}
	});
	var axisMinGaps = {};
	for (var key in axisValues) if (axisValues.hasOwnProperty(key)) {
		var valuesInAxis = axisValues[key];
		if (valuesInAxis) {
			valuesInAxis.sort(function(a, b) {
				return a - b;
			});
			var min$2 = null;
			for (var j = 1; j < valuesInAxis.length; ++j) {
				var delta = valuesInAxis[j] - valuesInAxis[j - 1];
				if (delta > 0) min$2 = min$2 === null ? delta : Math.min(min$2, delta);
			}
			axisMinGaps[key] = min$2;
		}
	}
	return axisMinGaps;
}
function makeColumnLayout(barSeries) {
	var axisMinGaps = getValueAxesMinGaps(barSeries);
	var seriesInfoList = [];
	each$4(barSeries, function(seriesModel) {
		var cartesian = seriesModel.coordinateSystem;
		var baseAxis = cartesian.getBaseAxis();
		var axisExtent = baseAxis.getExtent();
		var bandWidth;
		if (baseAxis.type === "category") bandWidth = baseAxis.getBandWidth();
		else if (baseAxis.type === "value" || baseAxis.type === "time") {
			var key = baseAxis.dim + "_" + baseAxis.index;
			var minGap = axisMinGaps[key];
			var extentSpan = Math.abs(axisExtent[1] - axisExtent[0]);
			var scale$3 = baseAxis.scale.getExtent();
			var scaleSpan = Math.abs(scale$3[1] - scale$3[0]);
			bandWidth = minGap ? extentSpan / scaleSpan * minGap : extentSpan;
		} else {
			var data = seriesModel.getData();
			bandWidth = Math.abs(axisExtent[1] - axisExtent[0]) / data.count();
		}
		var barWidth = parsePercent(seriesModel.get("barWidth"), bandWidth);
		var barMaxWidth = parsePercent(seriesModel.get("barMaxWidth"), bandWidth);
		var barMinWidth = parsePercent(
			// barMinWidth by default is 0.5 / 1 in cartesian. Because in value axis,
			// the auto-calculated bar width might be less than 0.5 / 1.
			seriesModel.get("barMinWidth") || (isInLargeMode(seriesModel) ? .5 : 1),
			bandWidth
);
		var barGap = seriesModel.get("barGap");
		var barCategoryGap = seriesModel.get("barCategoryGap");
		seriesInfoList.push({
			bandWidth,
			barWidth,
			barMaxWidth,
			barMinWidth,
			barGap,
			barCategoryGap,
			axisKey: getAxisKey(baseAxis),
			stackId: getSeriesStackId(seriesModel)
		});
	});
	return doCalBarWidthAndOffset(seriesInfoList);
}
function doCalBarWidthAndOffset(seriesInfoList) {
	var columnsMap = {};
	each$4(seriesInfoList, function(seriesInfo, idx) {
		var axisKey = seriesInfo.axisKey;
		var bandWidth = seriesInfo.bandWidth;
		var columnsOnAxis = columnsMap[axisKey] || {
			bandWidth,
			remainedWidth: bandWidth,
			autoWidthCount: 0,
			categoryGap: null,
			gap: "20%",
			stacks: {}
		};
		var stacks = columnsOnAxis.stacks;
		columnsMap[axisKey] = columnsOnAxis;
		var stackId = seriesInfo.stackId;
		if (!stacks[stackId]) columnsOnAxis.autoWidthCount++;
		stacks[stackId] = stacks[stackId] || {
			width: 0,
			maxWidth: 0
		};
		var barWidth = seriesInfo.barWidth;
		if (barWidth && !stacks[stackId].width) {
			stacks[stackId].width = barWidth;
			barWidth = Math.min(columnsOnAxis.remainedWidth, barWidth);
			columnsOnAxis.remainedWidth -= barWidth;
		}
		var barMaxWidth = seriesInfo.barMaxWidth;
		barMaxWidth && (stacks[stackId].maxWidth = barMaxWidth);
		var barMinWidth = seriesInfo.barMinWidth;
		barMinWidth && (stacks[stackId].minWidth = barMinWidth);
		var barGap = seriesInfo.barGap;
		barGap != null && (columnsOnAxis.gap = barGap);
		var barCategoryGap = seriesInfo.barCategoryGap;
		barCategoryGap != null && (columnsOnAxis.categoryGap = barCategoryGap);
	});
	var result = {};
	each$4(columnsMap, function(columnsOnAxis, coordSysName) {
		result[coordSysName] = {};
		var stacks = columnsOnAxis.stacks;
		var bandWidth = columnsOnAxis.bandWidth;
		var categoryGapPercent = columnsOnAxis.categoryGap;
		if (categoryGapPercent == null) {
			var columnCount = keys(stacks).length;
			categoryGapPercent = Math.max(35 - columnCount * 4, 15) + "%";
		}
		var categoryGap = parsePercent(categoryGapPercent, bandWidth);
		var barGapPercent = parsePercent(columnsOnAxis.gap, 1);
		var remainedWidth = columnsOnAxis.remainedWidth;
		var autoWidthCount = columnsOnAxis.autoWidthCount;
		var autoWidth = (remainedWidth - categoryGap) / (autoWidthCount + (autoWidthCount - 1) * barGapPercent);
		autoWidth = Math.max(autoWidth, 0);
		each$4(stacks, function(column) {
			var maxWidth = column.maxWidth;
			var minWidth = column.minWidth;
			if (!column.width) {
				var finalWidth = autoWidth;
				if (maxWidth && maxWidth < finalWidth) finalWidth = Math.min(maxWidth, remainedWidth);
				if (minWidth && minWidth > finalWidth) finalWidth = minWidth;
				if (finalWidth !== autoWidth) {
					column.width = finalWidth;
					remainedWidth -= finalWidth + barGapPercent * finalWidth;
					autoWidthCount--;
				}
			} else {
				var finalWidth = column.width;
				if (maxWidth) finalWidth = Math.min(finalWidth, maxWidth);
				if (minWidth) finalWidth = Math.max(finalWidth, minWidth);
				column.width = finalWidth;
				remainedWidth -= finalWidth + barGapPercent * finalWidth;
				autoWidthCount--;
			}
		});
		autoWidth = (remainedWidth - categoryGap) / (autoWidthCount + (autoWidthCount - 1) * barGapPercent);
		autoWidth = Math.max(autoWidth, 0);
		var widthSum = 0;
		var lastColumn;
		each$4(stacks, function(column, idx) {
			if (!column.width) column.width = autoWidth;
			lastColumn = column;
			widthSum += column.width * (1 + barGapPercent);
		});
		if (lastColumn) widthSum -= lastColumn.width * barGapPercent;
		var offset = -widthSum / 2;
		each$4(stacks, function(column, stackId) {
			result[coordSysName][stackId] = result[coordSysName][stackId] || {
				bandWidth,
				offset,
				width: column.width
			};
			offset += column.width * (1 + barGapPercent);
		});
	});
	return result;
}
function retrieveColumnLayout(barWidthAndOffset, axis, seriesModel) {
	if (barWidthAndOffset && axis) {
		var result = barWidthAndOffset[getAxisKey(axis)];
		if (result != null && seriesModel != null) return result[getSeriesStackId(seriesModel)];
		return result;
	}
}
function layout$1(seriesType$1, ecModel) {
	var seriesModels = prepareLayoutBarSeries(seriesType$1, ecModel);
	var barWidthAndOffset = makeColumnLayout(seriesModels);
	each$4(seriesModels, function(seriesModel) {
		var data = seriesModel.getData();
		var cartesian = seriesModel.coordinateSystem;
		var baseAxis = cartesian.getBaseAxis();
		var stackId = getSeriesStackId(seriesModel);
		var columnLayoutInfo = barWidthAndOffset[getAxisKey(baseAxis)][stackId];
		var columnOffset = columnLayoutInfo.offset;
		var columnWidth = columnLayoutInfo.width;
		data.setLayout({
			bandWidth: columnLayoutInfo.bandWidth,
			offset: columnOffset,
			size: columnWidth
		});
	});
}
function createProgressiveLayout(seriesType$1) {
	return {
		seriesType: seriesType$1,
		plan: createRenderPlanner(),
		reset: function(seriesModel) {
			if (!isOnCartesian(seriesModel)) return;
			var data = seriesModel.getData();
			var cartesian = seriesModel.coordinateSystem;
			var baseAxis = cartesian.getBaseAxis();
			var valueAxis$1 = cartesian.getOtherAxis(baseAxis);
			var valueDimIdx = data.getDimensionIndex(data.mapDimension(valueAxis$1.dim));
			var baseDimIdx = data.getDimensionIndex(data.mapDimension(baseAxis.dim));
			var drawBackground = seriesModel.get("showBackground", true);
			var valueDim = data.mapDimension(valueAxis$1.dim);
			var stackResultDim = data.getCalculationInfo("stackResultDimension");
			var stacked = isDimensionStacked(data, valueDim) && !!data.getCalculationInfo("stackedOnSeries");
			var isValueAxisH = valueAxis$1.isHorizontal();
			var valueAxisStart = getValueAxisStart(baseAxis, valueAxis$1);
			var isLarge = isInLargeMode(seriesModel);
			var barMinHeight = seriesModel.get("barMinHeight") || 0;
			var stackedDimIdx = stackResultDim && data.getDimensionIndex(stackResultDim);
			var columnWidth = data.getLayout("size");
			var columnOffset = data.getLayout("offset");
			return { progress: function(params, data$1) {
				var count = params.count;
				var largePoints = isLarge && createFloat32Array(count * 3);
				var largeBackgroundPoints = isLarge && drawBackground && createFloat32Array(count * 3);
				var largeDataIndices = isLarge && createFloat32Array(count);
				var coordLayout = cartesian.master.getRect();
				var bgSize = isValueAxisH ? coordLayout.width : coordLayout.height;
				var dataIndex;
				var store = data$1.getStore();
				var idxOffset = 0;
				while ((dataIndex = params.next()) != null) {
					var value = store.get(stacked ? stackedDimIdx : valueDimIdx, dataIndex);
					var baseValue = store.get(baseDimIdx, dataIndex);
					var baseCoord = valueAxisStart;
					var stackStartValue = void 0;
					if (stacked) stackStartValue = +value - store.get(valueDimIdx, dataIndex);
					var x = void 0;
					var y = void 0;
					var width = void 0;
					var height = void 0;
					if (isValueAxisH) {
						var coord = cartesian.dataToPoint([value, baseValue]);
						if (stacked) {
							var startCoord = cartesian.dataToPoint([stackStartValue, baseValue]);
							baseCoord = startCoord[0];
						}
						x = baseCoord;
						y = coord[1] + columnOffset;
						width = coord[0] - baseCoord;
						height = columnWidth;
						if (Math.abs(width) < barMinHeight) width = (width < 0 ? -1 : 1) * barMinHeight;
					} else {
						var coord = cartesian.dataToPoint([baseValue, value]);
						if (stacked) {
							var startCoord = cartesian.dataToPoint([baseValue, stackStartValue]);
							baseCoord = startCoord[1];
						}
						x = coord[0] + columnOffset;
						y = baseCoord;
						width = columnWidth;
						height = coord[1] - baseCoord;
						if (Math.abs(height) < barMinHeight) height = (height <= 0 ? -1 : 1) * barMinHeight;
					}
					if (!isLarge) data$1.setItemLayout(dataIndex, {
						x,
						y,
						width,
						height
					});
					else {
						largePoints[idxOffset] = x;
						largePoints[idxOffset + 1] = y;
						largePoints[idxOffset + 2] = isValueAxisH ? width : height;
						if (largeBackgroundPoints) {
							largeBackgroundPoints[idxOffset] = isValueAxisH ? coordLayout.x : x;
							largeBackgroundPoints[idxOffset + 1] = isValueAxisH ? y : coordLayout.y;
							largeBackgroundPoints[idxOffset + 2] = bgSize;
						}
						largeDataIndices[dataIndex] = dataIndex;
					}
					idxOffset += 3;
				}
				if (isLarge) data$1.setLayout({
					largePoints,
					largeDataIndices,
					largeBackgroundPoints,
					valueAxisHorizontal: isValueAxisH
				});
			} };
		}
	};
}
function isOnCartesian(seriesModel) {
	return seriesModel.coordinateSystem && seriesModel.coordinateSystem.type === "cartesian2d";
}
function isInLargeMode(seriesModel) {
	return seriesModel.pipelineContext && seriesModel.pipelineContext.large;
}
function getValueAxisStart(baseAxis, valueAxis$1) {
	var startValue = valueAxis$1.model.get("startValue");
	if (!startValue) startValue = 0;
	return valueAxis$1.toGlobalCoord(valueAxis$1.dataToCoord(valueAxis$1.type === "log" ? startValue > 0 ? startValue : 1 : startValue));
}
var BaseBarSeriesModel = function(_super) {
	__extends(BaseBarSeriesModel$1, _super);
	function BaseBarSeriesModel$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = BaseBarSeriesModel$1.type;
		return _this;
	}
	BaseBarSeriesModel$1.prototype.getInitialData = function(option, ecModel) {
		return createSeriesData_default(null, this, { useEncodeDefaulter: true });
	};
	BaseBarSeriesModel$1.prototype.getMarkerPosition = function(value, dims, startingAtTick) {
		var coordSys = this.coordinateSystem;
		if (coordSys && coordSys.clampData) {
			var clampData_1 = coordSys.clampData(value);
			var pt_1 = coordSys.dataToPoint(clampData_1);
			if (startingAtTick) each$4(coordSys.getAxes(), function(axis, idx) {
				if (axis.type === "category" && dims != null) {
					var tickCoords = axis.getTicksCoords();
					var alignTicksWithLabel = axis.getTickModel().get("alignWithLabel");
					var targetTickId = clampData_1[idx];
					var isEnd = dims[idx] === "x1" || dims[idx] === "y1";
					if (isEnd && !alignTicksWithLabel) targetTickId += 1;
					if (tickCoords.length < 2) return;
					else if (tickCoords.length === 2) {
						pt_1[idx] = axis.toGlobalCoord(axis.getExtent()[isEnd ? 1 : 0]);
						return;
					}
					var leftCoord = void 0;
					var coord = void 0;
					var stepTickValue = 1;
					for (var i = 0; i < tickCoords.length; i++) {
						var tickCoord = tickCoords[i].coord;
						var tickValue = i === tickCoords.length - 1 ? tickCoords[i - 1].tickValue + stepTickValue : tickCoords[i].tickValue;
						if (tickValue === targetTickId) {
							coord = tickCoord;
							break;
						} else if (tickValue < targetTickId) leftCoord = tickCoord;
						else if (leftCoord != null && tickValue > targetTickId) {
							coord = (tickCoord + leftCoord) / 2;
							break;
						}
						if (i === 1) stepTickValue = tickValue - tickCoords[0].tickValue;
					}
					if (coord == null) {
						if (!leftCoord) coord = tickCoords[0].coord;
						else if (leftCoord) coord = tickCoords[tickCoords.length - 1].coord;
					}
					pt_1[idx] = axis.toGlobalCoord(coord);
				}
			});
			else {
				var data = this.getData();
				var offset = data.getLayout("offset");
				var size = data.getLayout("size");
				var offsetIndex = coordSys.getBaseAxis().isHorizontal() ? 0 : 1;
				pt_1[offsetIndex] += offset + size / 2;
			}
			return pt_1;
		}
		return [NaN, NaN];
	};
	BaseBarSeriesModel$1.type = "series.__base_bar__";
	BaseBarSeriesModel$1.defaultOption = {
		z: 2,
		coordinateSystem: "cartesian2d",
		legendHoverLink: true,
		barMinHeight: 0,
		barMinAngle: 0,
		large: false,
		largeThreshold: 400,
		progressive: 3e3,
		progressiveChunkMode: "mod"
	};
	return BaseBarSeriesModel$1;
}(Series_default);
Series_default.registerClass(BaseBarSeriesModel);
var BaseBarSeries_default = BaseBarSeriesModel;
var BarSeriesModel = function(_super) {
	__extends(BarSeriesModel$1, _super);
	function BarSeriesModel$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = BarSeriesModel$1.type;
		return _this;
	}
	BarSeriesModel$1.prototype.getInitialData = function() {
		return createSeriesData_default(null, this, {
			useEncodeDefaulter: true,
			createInvertedIndices: !!this.get("realtimeSort", true) || null
		});
	};
	/**
	
	* @override
	
	*/
	BarSeriesModel$1.prototype.getProgressive = function() {
		return this.get("large") ? this.get("progressive") : false;
	};
	/**
	
	* @override
	
	*/
	BarSeriesModel$1.prototype.getProgressiveThreshold = function() {
		var progressiveThreshold = this.get("progressiveThreshold");
		var largeThreshold = this.get("largeThreshold");
		if (largeThreshold > progressiveThreshold) progressiveThreshold = largeThreshold;
		return progressiveThreshold;
	};
	BarSeriesModel$1.prototype.brushSelector = function(dataIndex, data, selectors) {
		return selectors.rect(data.getItemLayout(dataIndex));
	};
	BarSeriesModel$1.type = "series.bar";
	BarSeriesModel$1.dependencies = ["grid", "polar"];
	BarSeriesModel$1.defaultOption = inheritDefaultOption(BaseBarSeries_default.defaultOption, {
		clip: true,
		roundCap: false,
		showBackground: false,
		backgroundStyle: {
			color: "rgba(180, 180, 180, 0.2)",
			borderColor: null,
			borderWidth: 0,
			borderType: "solid",
			borderRadius: 0,
			shadowBlur: 0,
			shadowColor: null,
			shadowOffsetX: 0,
			shadowOffsetY: 0,
			opacity: 1
		},
		select: { itemStyle: { borderColor: "#212121" } },
		realtimeSort: false
	});
	return BarSeriesModel$1;
}(BaseBarSeries_default);
var BarSeries_default = BarSeriesModel;
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
var ORIGIN_METHOD = "\0__throttleOriginMethod";
var RATE = "\0__throttleRate";
var THROTTLE_TYPE = "\0__throttleType";
function throttle(fn, delay, debounce) {
	var currCall;
	var lastCall = 0;
	var lastExec = 0;
	var timer = null;
	var diff;
	var scope;
	var args;
	var debounceNextCall;
	delay = delay || 0;
	function exec() {
		lastExec = new Date().getTime();
		timer = null;
		fn.apply(scope, args || []);
	}
	var cb = function() {
		var cbArgs = [];
		for (var _i = 0; _i < arguments.length; _i++) cbArgs[_i] = arguments[_i];
		currCall = new Date().getTime();
		scope = this;
		args = cbArgs;
		var thisDelay = debounceNextCall || delay;
		var thisDebounce = debounceNextCall || debounce;
		debounceNextCall = null;
		diff = currCall - (thisDebounce ? lastCall : lastExec) - thisDelay;
		clearTimeout(timer);
		if (thisDebounce) timer = setTimeout(exec, thisDelay);
		else if (diff >= 0) exec();
		else timer = setTimeout(exec, -diff);
		lastCall = currCall;
	};
	/**
	
	* Clear throttle.
	
	* @public
	
	*/
	cb.clear = function() {
		if (timer) {
			clearTimeout(timer);
			timer = null;
		}
	};
	/**
	
	* Enable debounce once.
	
	*/
	cb.debounceNextCall = function(debounceDelay) {
		debounceNextCall = debounceDelay;
	};
	return cb;
}
function createOrUpdate(obj, fnAttr, rate, throttleType) {
	var fn = obj[fnAttr];
	if (!fn) return;
	var originFn = fn[ORIGIN_METHOD] || fn;
	var lastThrottleType = fn[THROTTLE_TYPE];
	var lastRate = fn[RATE];
	if (lastRate !== rate || lastThrottleType !== throttleType) {
		if (rate == null || !throttleType) return obj[fnAttr] = originFn;
		fn = obj[fnAttr] = throttle(originFn, rate, throttleType === "debounce");
		fn[ORIGIN_METHOD] = originFn;
		fn[THROTTLE_TYPE] = throttleType;
		fn[RATE] = rate;
	}
	return fn;
}
function clear(obj, fnAttr) {
	var fn = obj[fnAttr];
	if (fn && fn[ORIGIN_METHOD]) {
		fn.clear && fn.clear();
		obj[fnAttr] = fn[ORIGIN_METHOD];
	}
}
/**

* Sausage: similar to sector, but have half circle on both sides

*/
var SausageShape = function() {
	function SausageShape$1() {
		this.cx = 0;
		this.cy = 0;
		this.r0 = 0;
		this.r = 0;
		this.startAngle = 0;
		this.endAngle = Math.PI * 2;
		this.clockwise = true;
	}
	return SausageShape$1;
}();
var SausagePath = function(_super) {
	__extends(SausagePath$1, _super);
	function SausagePath$1(opts) {
		var _this = _super.call(this, opts) || this;
		_this.type = "sausage";
		return _this;
	}
	SausagePath$1.prototype.getDefaultShape = function() {
		return new SausageShape();
	};
	SausagePath$1.prototype.buildPath = function(ctx, shape) {
		var cx = shape.cx;
		var cy = shape.cy;
		var r0 = Math.max(shape.r0 || 0, 0);
		var r = Math.max(shape.r, 0);
		var dr = (r - r0) * .5;
		var rCenter = r0 + dr;
		var startAngle = shape.startAngle;
		var endAngle = shape.endAngle;
		var clockwise = shape.clockwise;
		var PI2$6 = Math.PI * 2;
		var lessThanCircle = clockwise ? endAngle - startAngle < PI2$6 : startAngle - endAngle < PI2$6;
		if (!lessThanCircle) startAngle = endAngle - (clockwise ? PI2$6 : -PI2$6);
		var unitStartX = Math.cos(startAngle);
		var unitStartY = Math.sin(startAngle);
		var unitEndX = Math.cos(endAngle);
		var unitEndY = Math.sin(endAngle);
		if (lessThanCircle) {
			ctx.moveTo(unitStartX * r0 + cx, unitStartY * r0 + cy);
			ctx.arc(unitStartX * rCenter + cx, unitStartY * rCenter + cy, dr, -Math.PI + startAngle, startAngle, !clockwise);
		} else ctx.moveTo(unitStartX * r + cx, unitStartY * r + cy);
		ctx.arc(cx, cy, r, startAngle, endAngle, !clockwise);
		ctx.arc(unitEndX * rCenter + cx, unitEndY * rCenter + cy, dr, endAngle - Math.PI * 2, endAngle - Math.PI, !clockwise);
		if (r0 !== 0) ctx.arc(cx, cy, r0, endAngle, startAngle, clockwise);
	};
	return SausagePath$1;
}(Path_default);
var sausage_default = SausagePath;
function createSectorCalculateTextPosition(positionMapping, opts) {
	opts = opts || {};
	var isRoundCap = opts.isRoundCap;
	return function(out$1, opts$1, boundingRect) {
		var textPosition = opts$1.position;
		if (!textPosition || textPosition instanceof Array) return calculateTextPosition(out$1, opts$1, boundingRect);
		var mappedSectorPosition = positionMapping(textPosition);
		var distance$1 = opts$1.distance != null ? opts$1.distance : 5;
		var sector = this.shape;
		var cx = sector.cx;
		var cy = sector.cy;
		var r = sector.r;
		var r0 = sector.r0;
		var middleR = (r + r0) / 2;
		var startAngle = sector.startAngle;
		var endAngle = sector.endAngle;
		var middleAngle = (startAngle + endAngle) / 2;
		var extraDist = isRoundCap ? Math.abs(r - r0) / 2 : 0;
		var mathCos$4 = Math.cos;
		var mathSin$4 = Math.sin;
		var x = cx + r * mathCos$4(startAngle);
		var y = cy + r * mathSin$4(startAngle);
		var textAlign = "left";
		var textVerticalAlign = "top";
		switch (mappedSectorPosition) {
			case "startArc":
				x = cx + (r0 - distance$1) * mathCos$4(middleAngle);
				y = cy + (r0 - distance$1) * mathSin$4(middleAngle);
				textAlign = "center";
				textVerticalAlign = "top";
				break;
			case "insideStartArc":
				x = cx + (r0 + distance$1) * mathCos$4(middleAngle);
				y = cy + (r0 + distance$1) * mathSin$4(middleAngle);
				textAlign = "center";
				textVerticalAlign = "bottom";
				break;
			case "startAngle":
				x = cx + middleR * mathCos$4(startAngle) + adjustAngleDistanceX(startAngle, distance$1 + extraDist, false);
				y = cy + middleR * mathSin$4(startAngle) + adjustAngleDistanceY(startAngle, distance$1 + extraDist, false);
				textAlign = "right";
				textVerticalAlign = "middle";
				break;
			case "insideStartAngle":
				x = cx + middleR * mathCos$4(startAngle) + adjustAngleDistanceX(startAngle, -distance$1 + extraDist, false);
				y = cy + middleR * mathSin$4(startAngle) + adjustAngleDistanceY(startAngle, -distance$1 + extraDist, false);
				textAlign = "left";
				textVerticalAlign = "middle";
				break;
			case "middle":
				x = cx + middleR * mathCos$4(middleAngle);
				y = cy + middleR * mathSin$4(middleAngle);
				textAlign = "center";
				textVerticalAlign = "middle";
				break;
			case "endArc":
				x = cx + (r + distance$1) * mathCos$4(middleAngle);
				y = cy + (r + distance$1) * mathSin$4(middleAngle);
				textAlign = "center";
				textVerticalAlign = "bottom";
				break;
			case "insideEndArc":
				x = cx + (r - distance$1) * mathCos$4(middleAngle);
				y = cy + (r - distance$1) * mathSin$4(middleAngle);
				textAlign = "center";
				textVerticalAlign = "top";
				break;
			case "endAngle":
				x = cx + middleR * mathCos$4(endAngle) + adjustAngleDistanceX(endAngle, distance$1 + extraDist, true);
				y = cy + middleR * mathSin$4(endAngle) + adjustAngleDistanceY(endAngle, distance$1 + extraDist, true);
				textAlign = "left";
				textVerticalAlign = "middle";
				break;
			case "insideEndAngle":
				x = cx + middleR * mathCos$4(endAngle) + adjustAngleDistanceX(endAngle, -distance$1 + extraDist, true);
				y = cy + middleR * mathSin$4(endAngle) + adjustAngleDistanceY(endAngle, -distance$1 + extraDist, true);
				textAlign = "right";
				textVerticalAlign = "middle";
				break;
			default: return calculateTextPosition(out$1, opts$1, boundingRect);
		}
		out$1 = out$1 || {};
		out$1.x = x;
		out$1.y = y;
		out$1.align = textAlign;
		out$1.verticalAlign = textVerticalAlign;
		return out$1;
	};
}
function setSectorTextRotation(sector, textPosition, positionMapping, rotateType) {
	if (isNumber(rotateType)) {
		sector.setTextConfig({ rotation: rotateType });
		return;
	} else if (isArray(textPosition)) {
		sector.setTextConfig({ rotation: 0 });
		return;
	}
	var shape = sector.shape;
	var startAngle = shape.clockwise ? shape.startAngle : shape.endAngle;
	var endAngle = shape.clockwise ? shape.endAngle : shape.startAngle;
	var middleAngle = (startAngle + endAngle) / 2;
	var anchorAngle;
	var mappedSectorPosition = positionMapping(textPosition);
	switch (mappedSectorPosition) {
		case "startArc":
		case "insideStartArc":
		case "middle":
		case "insideEndArc":
		case "endArc":
			anchorAngle = middleAngle;
			break;
		case "startAngle":
		case "insideStartAngle":
			anchorAngle = startAngle;
			break;
		case "endAngle":
		case "insideEndAngle":
			anchorAngle = endAngle;
			break;
		default:
			sector.setTextConfig({ rotation: 0 });
			return;
	}
	var rotate$1 = Math.PI * 1.5 - anchorAngle;
	/**
	
	* TODO: labels with rotate > Math.PI / 2 should be rotate another
	
	* half round flipped to increase readability. However, only middle
	
	* position supports this for now, because in other positions, the
	
	* anchor point is not at the center of the text, so the positions
	
	* after rotating is not as expected.
	
	*/
	if (mappedSectorPosition === "middle" && rotate$1 > Math.PI / 2 && rotate$1 < Math.PI * 1.5) rotate$1 -= Math.PI;
	sector.setTextConfig({ rotation: rotate$1 });
}
function adjustAngleDistanceX(angle, distance$1, isEnd) {
	return distance$1 * Math.sin(angle) * (isEnd ? -1 : 1);
}
function adjustAngleDistanceY(angle, distance$1, isEnd) {
	return distance$1 * Math.cos(angle) * (isEnd ? 1 : -1);
}
function getSectorCornerRadius(model, shape, zeroIfNull) {
	var cornerRadius = model.get("borderRadius");
	if (cornerRadius == null) return zeroIfNull ? { cornerRadius: 0 } : null;
	if (!isArray(cornerRadius)) cornerRadius = [
		cornerRadius,
		cornerRadius,
		cornerRadius,
		cornerRadius
	];
	var dr = Math.abs(shape.r || 0 - shape.r0 || 0);
	return { cornerRadius: map$1(cornerRadius, function(cr) {
		return parsePercent$1(cr, dr);
	}) };
}
var mathMax = Math.max;
var mathMin = Math.min;
function getClipArea(coord, data) {
	var coordSysClipArea = coord.getArea && coord.getArea();
	if (isCoordinateSystemType(coord, "cartesian2d")) {
		var baseAxis = coord.getBaseAxis();
		if (baseAxis.type !== "category" || !baseAxis.onBand) {
			var expandWidth = data.getLayout("bandWidth");
			if (baseAxis.isHorizontal()) {
				coordSysClipArea.x -= expandWidth;
				coordSysClipArea.width += expandWidth * 2;
			} else {
				coordSysClipArea.y -= expandWidth;
				coordSysClipArea.height += expandWidth * 2;
			}
		}
	}
	return coordSysClipArea;
}
var BarView = function(_super) {
	__extends(BarView$1, _super);
	function BarView$1() {
		var _this = _super.call(this) || this;
		_this.type = BarView$1.type;
		_this._isFirstFrame = true;
		return _this;
	}
	BarView$1.prototype.render = function(seriesModel, ecModel, api, payload) {
		this._model = seriesModel;
		this._removeOnRenderedListener(api);
		this._updateDrawMode(seriesModel);
		var coordinateSystemType = seriesModel.get("coordinateSystem");
		if (coordinateSystemType === "cartesian2d" || coordinateSystemType === "polar") {
			this._progressiveEls = null;
			this._isLargeDraw ? this._renderLarge(seriesModel, ecModel, api) : this._renderNormal(seriesModel, ecModel, api, payload);
		}
	};
	BarView$1.prototype.incrementalPrepareRender = function(seriesModel) {
		this._clear();
		this._updateDrawMode(seriesModel);
		this._updateLargeClip(seriesModel);
	};
	BarView$1.prototype.incrementalRender = function(params, seriesModel) {
		this._progressiveEls = [];
		this._incrementalRenderLarge(params, seriesModel);
	};
	BarView$1.prototype.eachRendered = function(cb) {
		traverseElements(this._progressiveEls || this.group, cb);
	};
	BarView$1.prototype._updateDrawMode = function(seriesModel) {
		var isLargeDraw = seriesModel.pipelineContext.large;
		if (this._isLargeDraw == null || isLargeDraw !== this._isLargeDraw) {
			this._isLargeDraw = isLargeDraw;
			this._clear();
		}
	};
	BarView$1.prototype._renderNormal = function(seriesModel, ecModel, api, payload) {
		var group = this.group;
		var data = seriesModel.getData();
		var oldData = this._data;
		var coord = seriesModel.coordinateSystem;
		var baseAxis = coord.getBaseAxis();
		var isHorizontalOrRadial;
		if (coord.type === "cartesian2d") isHorizontalOrRadial = baseAxis.isHorizontal();
		else if (coord.type === "polar") isHorizontalOrRadial = baseAxis.dim === "angle";
		var animationModel = seriesModel.isAnimationEnabled() ? seriesModel : null;
		var realtimeSortCfg = shouldRealtimeSort(seriesModel, coord);
		if (realtimeSortCfg) this._enableRealtimeSort(realtimeSortCfg, data, api);
		var needsClip = seriesModel.get("clip", true) || realtimeSortCfg;
		var coordSysClipArea = getClipArea(coord, data);
		group.removeClipPath();
		var roundCap = seriesModel.get("roundCap", true);
		var drawBackground = seriesModel.get("showBackground", true);
		var backgroundModel = seriesModel.getModel("backgroundStyle");
		var barBorderRadius = backgroundModel.get("borderRadius") || 0;
		var bgEls = [];
		var oldBgEls = this._backgroundEls;
		var isInitSort = payload && payload.isInitSort;
		var isChangeOrder = payload && payload.type === "changeAxisOrder";
		function createBackground(dataIndex) {
			var bgLayout = getLayout[coord.type](data, dataIndex);
			var bgEl = createBackgroundEl(coord, isHorizontalOrRadial, bgLayout);
			bgEl.useStyle(backgroundModel.getItemStyle());
			if (coord.type === "cartesian2d") bgEl.setShape("r", barBorderRadius);
			else bgEl.setShape("cornerRadius", barBorderRadius);
			bgEls[dataIndex] = bgEl;
			return bgEl;
		}
		data.diff(oldData).add(function(dataIndex) {
			var itemModel = data.getItemModel(dataIndex);
			var layout$2 = getLayout[coord.type](data, dataIndex, itemModel);
			if (drawBackground) createBackground(dataIndex);
			if (!data.hasValue(dataIndex) || !isValidLayout[coord.type](layout$2)) return;
			var isClipped = false;
			if (needsClip) isClipped = clip[coord.type](coordSysClipArea, layout$2);
			var el = elementCreator[coord.type](seriesModel, data, dataIndex, layout$2, isHorizontalOrRadial, animationModel, baseAxis.model, false, roundCap);
			if (realtimeSortCfg)
 /**
			
			* Force label animation because even if the element is
			
			* ignored because it's clipped, it may not be clipped after
			
			* changing order. Then, if not using forceLabelAnimation,
			
			* the label animation was never started, in which case,
			
			* the label will be the final value and doesn't have label
			
			* animation.
			
			*/
			el.forceLabelAnimation = true;
			updateStyle(el, data, dataIndex, itemModel, layout$2, seriesModel, isHorizontalOrRadial, coord.type === "polar");
			if (isInitSort) el.attr({ shape: layout$2 });
			else if (realtimeSortCfg) updateRealtimeAnimation(realtimeSortCfg, animationModel, el, layout$2, dataIndex, isHorizontalOrRadial, false, false);
			else initProps(el, { shape: layout$2 }, seriesModel, dataIndex);
			data.setItemGraphicEl(dataIndex, el);
			group.add(el);
			el.ignore = isClipped;
		}).update(function(newIndex, oldIndex) {
			var itemModel = data.getItemModel(newIndex);
			var layout$2 = getLayout[coord.type](data, newIndex, itemModel);
			if (drawBackground) {
				var bgEl = void 0;
				if (oldBgEls.length === 0) bgEl = createBackground(oldIndex);
				else {
					bgEl = oldBgEls[oldIndex];
					bgEl.useStyle(backgroundModel.getItemStyle());
					if (coord.type === "cartesian2d") bgEl.setShape("r", barBorderRadius);
					else bgEl.setShape("cornerRadius", barBorderRadius);
					bgEls[newIndex] = bgEl;
				}
				var bgLayout = getLayout[coord.type](data, newIndex);
				var shape = createBackgroundShape(isHorizontalOrRadial, bgLayout, coord);
				updateProps$1(bgEl, { shape }, animationModel, newIndex);
			}
			var el = oldData.getItemGraphicEl(oldIndex);
			if (!data.hasValue(newIndex) || !isValidLayout[coord.type](layout$2)) {
				group.remove(el);
				return;
			}
			var isClipped = false;
			if (needsClip) {
				isClipped = clip[coord.type](coordSysClipArea, layout$2);
				if (isClipped) group.remove(el);
			}
			if (!el) el = elementCreator[coord.type](seriesModel, data, newIndex, layout$2, isHorizontalOrRadial, animationModel, baseAxis.model, !!el, roundCap);
			else saveOldStyle(el);
			if (realtimeSortCfg) el.forceLabelAnimation = true;
			if (isChangeOrder) {
				var textEl = el.getTextContent();
				if (textEl) {
					var labelInnerStore = labelInner(textEl);
					if (labelInnerStore.prevValue != null)
 /**
					
					* Set preValue to be value so that no new label
					
					* should be started, otherwise, it will take a full
					
					* `animationDurationUpdate` time to finish the
					
					* animation, which is not expected.
					
					*/
					labelInnerStore.prevValue = labelInnerStore.value;
				}
			} else updateStyle(el, data, newIndex, itemModel, layout$2, seriesModel, isHorizontalOrRadial, coord.type === "polar");
			if (isInitSort) el.attr({ shape: layout$2 });
			else if (realtimeSortCfg) updateRealtimeAnimation(realtimeSortCfg, animationModel, el, layout$2, newIndex, isHorizontalOrRadial, true, isChangeOrder);
			else updateProps$1(el, { shape: layout$2 }, seriesModel, newIndex, null);
			data.setItemGraphicEl(newIndex, el);
			el.ignore = isClipped;
			group.add(el);
		}).remove(function(dataIndex) {
			var el = oldData.getItemGraphicEl(dataIndex);
			el && removeElementWithFadeOut(el, seriesModel, dataIndex);
		}).execute();
		var bgGroup = this._backgroundGroup || (this._backgroundGroup = new Group_default());
		bgGroup.removeAll();
		for (var i = 0; i < bgEls.length; ++i) bgGroup.add(bgEls[i]);
		group.add(bgGroup);
		this._backgroundEls = bgEls;
		this._data = data;
	};
	BarView$1.prototype._renderLarge = function(seriesModel, ecModel, api) {
		this._clear();
		createLarge(seriesModel, this.group);
		this._updateLargeClip(seriesModel);
	};
	BarView$1.prototype._incrementalRenderLarge = function(params, seriesModel) {
		this._removeBackground();
		createLarge(seriesModel, this.group, this._progressiveEls, true);
	};
	BarView$1.prototype._updateLargeClip = function(seriesModel) {
		var clipPath = seriesModel.get("clip", true) && createClipPath(seriesModel.coordinateSystem, false, seriesModel);
		var group = this.group;
		if (clipPath) group.setClipPath(clipPath);
		else group.removeClipPath();
	};
	BarView$1.prototype._enableRealtimeSort = function(realtimeSortCfg, data, api) {
		var _this = this;
		if (!data.count()) return;
		var baseAxis = realtimeSortCfg.baseAxis;
		if (this._isFirstFrame) {
			this._dispatchInitSort(data, realtimeSortCfg, api);
			this._isFirstFrame = false;
		} else {
			var orderMapping_1 = function(idx) {
				var el = data.getItemGraphicEl(idx);
				var shape = el && el.shape;
				return shape && Math.abs(baseAxis.isHorizontal() ? shape.height : shape.width) || 0;
			};
			this._onRendered = function() {
				_this._updateSortWithinSameData(data, orderMapping_1, baseAxis, api);
			};
			api.getZr().on("rendered", this._onRendered);
		}
	};
	BarView$1.prototype._dataSort = function(data, baseAxis, orderMapping) {
		var info = [];
		data.each(data.mapDimension(baseAxis.dim), function(ordinalNumber, dataIdx) {
			var mappedValue = orderMapping(dataIdx);
			mappedValue = mappedValue == null ? NaN : mappedValue;
			info.push({
				dataIndex: dataIdx,
				mappedValue,
				ordinalNumber
			});
		});
		info.sort(function(a, b) {
			return b.mappedValue - a.mappedValue;
		});
		return { ordinalNumbers: map$1(info, function(item) {
			return item.ordinalNumber;
		}) };
	};
	BarView$1.prototype._isOrderChangedWithinSameData = function(data, orderMapping, baseAxis) {
		var scale$3 = baseAxis.scale;
		var ordinalDataDim = data.mapDimension(baseAxis.dim);
		var lastValue = Number.MAX_VALUE;
		for (var tickNum = 0, len$1 = scale$3.getOrdinalMeta().categories.length; tickNum < len$1; ++tickNum) {
			var rawIdx = data.rawIndexOf(ordinalDataDim, scale$3.getRawOrdinalNumber(tickNum));
			var value = rawIdx < 0 ? Number.MIN_VALUE : orderMapping(data.indexOfRawIndex(rawIdx));
			if (value > lastValue) return true;
			lastValue = value;
		}
		return false;
	};
	BarView$1.prototype._isOrderDifferentInView = function(orderInfo, baseAxis) {
		var scale$3 = baseAxis.scale;
		var extent$1 = scale$3.getExtent();
		var tickNum = Math.max(0, extent$1[0]);
		var tickMax = Math.min(extent$1[1], scale$3.getOrdinalMeta().categories.length - 1);
		for (; tickNum <= tickMax; ++tickNum) if (orderInfo.ordinalNumbers[tickNum] !== scale$3.getRawOrdinalNumber(tickNum)) return true;
	};
	BarView$1.prototype._updateSortWithinSameData = function(data, orderMapping, baseAxis, api) {
		if (!this._isOrderChangedWithinSameData(data, orderMapping, baseAxis)) return;
		var sortInfo = this._dataSort(data, baseAxis, orderMapping);
		if (this._isOrderDifferentInView(sortInfo, baseAxis)) {
			this._removeOnRenderedListener(api);
			api.dispatchAction({
				type: "changeAxisOrder",
				componentType: baseAxis.dim + "Axis",
				axisId: baseAxis.index,
				sortInfo
			});
		}
	};
	BarView$1.prototype._dispatchInitSort = function(data, realtimeSortCfg, api) {
		var baseAxis = realtimeSortCfg.baseAxis;
		var sortResult = this._dataSort(data, baseAxis, function(dataIdx) {
			return data.get(data.mapDimension(realtimeSortCfg.otherAxis.dim), dataIdx);
		});
		api.dispatchAction({
			type: "changeAxisOrder",
			componentType: baseAxis.dim + "Axis",
			isInitSort: true,
			axisId: baseAxis.index,
			sortInfo: sortResult
		});
	};
	BarView$1.prototype.remove = function(ecModel, api) {
		this._clear(this._model);
		this._removeOnRenderedListener(api);
	};
	BarView$1.prototype.dispose = function(ecModel, api) {
		this._removeOnRenderedListener(api);
	};
	BarView$1.prototype._removeOnRenderedListener = function(api) {
		if (this._onRendered) {
			api.getZr().off("rendered", this._onRendered);
			this._onRendered = null;
		}
	};
	BarView$1.prototype._clear = function(model) {
		var group = this.group;
		var data = this._data;
		if (model && model.isAnimationEnabled() && data && !this._isLargeDraw) {
			this._removeBackground();
			this._backgroundEls = [];
			data.eachItemGraphicEl(function(el) {
				removeElementWithFadeOut(el, model, getECData(el).dataIndex);
			});
		} else group.removeAll();
		this._data = null;
		this._isFirstFrame = true;
	};
	BarView$1.prototype._removeBackground = function() {
		this.group.remove(this._backgroundGroup);
		this._backgroundGroup = null;
	};
	BarView$1.type = "bar";
	return BarView$1;
}(Chart_default);
var clip = {
	cartesian2d: function(coordSysBoundingRect, layout$2) {
		var signWidth = layout$2.width < 0 ? -1 : 1;
		var signHeight = layout$2.height < 0 ? -1 : 1;
		if (signWidth < 0) {
			layout$2.x += layout$2.width;
			layout$2.width = -layout$2.width;
		}
		if (signHeight < 0) {
			layout$2.y += layout$2.height;
			layout$2.height = -layout$2.height;
		}
		var coordSysX2 = coordSysBoundingRect.x + coordSysBoundingRect.width;
		var coordSysY2 = coordSysBoundingRect.y + coordSysBoundingRect.height;
		var x = mathMax(layout$2.x, coordSysBoundingRect.x);
		var x2 = mathMin(layout$2.x + layout$2.width, coordSysX2);
		var y = mathMax(layout$2.y, coordSysBoundingRect.y);
		var y2 = mathMin(layout$2.y + layout$2.height, coordSysY2);
		var xClipped = x2 < x;
		var yClipped = y2 < y;
		layout$2.x = xClipped && x > coordSysX2 ? x2 : x;
		layout$2.y = yClipped && y > coordSysY2 ? y2 : y;
		layout$2.width = xClipped ? 0 : x2 - x;
		layout$2.height = yClipped ? 0 : y2 - y;
		if (signWidth < 0) {
			layout$2.x += layout$2.width;
			layout$2.width = -layout$2.width;
		}
		if (signHeight < 0) {
			layout$2.y += layout$2.height;
			layout$2.height = -layout$2.height;
		}
		return xClipped || yClipped;
	},
	polar: function(coordSysClipArea, layout$2) {
		var signR = layout$2.r0 <= layout$2.r ? 1 : -1;
		if (signR < 0) {
			var tmp = layout$2.r;
			layout$2.r = layout$2.r0;
			layout$2.r0 = tmp;
		}
		var r = mathMin(layout$2.r, coordSysClipArea.r);
		var r0 = mathMax(layout$2.r0, coordSysClipArea.r0);
		layout$2.r = r;
		layout$2.r0 = r0;
		var clipped = r - r0 < 0;
		if (signR < 0) {
			var tmp = layout$2.r;
			layout$2.r = layout$2.r0;
			layout$2.r0 = tmp;
		}
		return clipped;
	}
};
var elementCreator = {
	cartesian2d: function(seriesModel, data, newIndex, layout$2, isHorizontal, animationModel, axisModel, isUpdate, roundCap) {
		var rect = new Rect_default({
			shape: extend({}, layout$2),
			z2: 1
		});
		rect.__dataIndex = newIndex;
		rect.name = "item";
		if (animationModel) {
			var rectShape = rect.shape;
			var animateProperty = isHorizontal ? "height" : "width";
			rectShape[animateProperty] = 0;
		}
		return rect;
	},
	polar: function(seriesModel, data, newIndex, layout$2, isRadial, animationModel, axisModel, isUpdate, roundCap) {
		var ShapeClass = !isRadial && roundCap ? sausage_default : Sector_default;
		var sector = new ShapeClass({
			shape: layout$2,
			z2: 1
		});
		sector.name = "item";
		var positionMap = createPolarPositionMapping(isRadial);
		sector.calculateTextPosition = createSectorCalculateTextPosition(positionMap, { isRoundCap: ShapeClass === sausage_default });
		if (animationModel) {
			var sectorShape = sector.shape;
			var animateProperty = isRadial ? "r" : "endAngle";
			var animateTarget = {};
			sectorShape[animateProperty] = isRadial ? layout$2.r0 : layout$2.startAngle;
			animateTarget[animateProperty] = layout$2[animateProperty];
			(isUpdate ? updateProps$1 : initProps)(sector, { shape: animateTarget }, animationModel);
		}
		return sector;
	}
};
function shouldRealtimeSort(seriesModel, coordSys) {
	var realtimeSortOption = seriesModel.get("realtimeSort", true);
	var baseAxis = coordSys.getBaseAxis();
	if (realtimeSortOption && baseAxis.type === "category" && coordSys.type === "cartesian2d") return {
		baseAxis,
		otherAxis: coordSys.getOtherAxis(baseAxis)
	};
}
function updateRealtimeAnimation(realtimeSortCfg, seriesAnimationModel, el, layout$2, newIndex, isHorizontal, isUpdate, isChangeOrder) {
	var seriesTarget;
	var axisTarget;
	if (isHorizontal) {
		axisTarget = {
			x: layout$2.x,
			width: layout$2.width
		};
		seriesTarget = {
			y: layout$2.y,
			height: layout$2.height
		};
	} else {
		axisTarget = {
			y: layout$2.y,
			height: layout$2.height
		};
		seriesTarget = {
			x: layout$2.x,
			width: layout$2.width
		};
	}
	if (!isChangeOrder) (isUpdate ? updateProps$1 : initProps)(el, { shape: seriesTarget }, seriesAnimationModel, newIndex, null);
	var axisAnimationModel = seriesAnimationModel ? realtimeSortCfg.baseAxis.model : null;
	(isUpdate ? updateProps$1 : initProps)(el, { shape: axisTarget }, axisAnimationModel, newIndex);
}
function checkPropertiesNotValid(obj, props) {
	for (var i = 0; i < props.length; i++) if (!isFinite(obj[props[i]])) return true;
	return false;
}
var rectPropties = [
	"x",
	"y",
	"width",
	"height"
];
var polarPropties = [
	"cx",
	"cy",
	"r",
	"startAngle",
	"endAngle"
];
var isValidLayout = {
	cartesian2d: function(layout$2) {
		return !checkPropertiesNotValid(layout$2, rectPropties);
	},
	polar: function(layout$2) {
		return !checkPropertiesNotValid(layout$2, polarPropties);
	}
};
var getLayout = {
	cartesian2d: function(data, dataIndex, itemModel) {
		var layout$2 = data.getItemLayout(dataIndex);
		var fixedLineWidth = itemModel ? getLineWidth(itemModel, layout$2) : 0;
		var signX = layout$2.width > 0 ? 1 : -1;
		var signY = layout$2.height > 0 ? 1 : -1;
		return {
			x: layout$2.x + signX * fixedLineWidth / 2,
			y: layout$2.y + signY * fixedLineWidth / 2,
			width: layout$2.width - signX * fixedLineWidth,
			height: layout$2.height - signY * fixedLineWidth
		};
	},
	polar: function(data, dataIndex, itemModel) {
		var layout$2 = data.getItemLayout(dataIndex);
		return {
			cx: layout$2.cx,
			cy: layout$2.cy,
			r0: layout$2.r0,
			r: layout$2.r,
			startAngle: layout$2.startAngle,
			endAngle: layout$2.endAngle,
			clockwise: layout$2.clockwise
		};
	}
};
function isZeroOnPolar(layout$2) {
	return layout$2.startAngle != null && layout$2.endAngle != null && layout$2.startAngle === layout$2.endAngle;
}
function createPolarPositionMapping(isRadial) {
	return function(isRadial$1) {
		var arcOrAngle = isRadial$1 ? "Arc" : "Angle";
		return function(position) {
			switch (position) {
				case "start":
				case "insideStart":
				case "end":
				case "insideEnd": return position + arcOrAngle;
				default: return position;
			}
		};
	}(isRadial);
}
function updateStyle(el, data, dataIndex, itemModel, layout$2, seriesModel, isHorizontalOrRadial, isPolar) {
	var style = data.getItemVisual(dataIndex, "style");
	if (!isPolar) {
		var borderRadius = itemModel.get(["itemStyle", "borderRadius"]) || 0;
		el.setShape("r", borderRadius);
	} else if (!seriesModel.get("roundCap")) {
		var sectorShape = el.shape;
		var cornerRadius = getSectorCornerRadius(itemModel.getModel("itemStyle"), sectorShape, true);
		extend(sectorShape, cornerRadius);
		el.setShape(sectorShape);
	}
	el.useStyle(style);
	var cursorStyle = itemModel.getShallow("cursor");
	cursorStyle && el.attr("cursor", cursorStyle);
	var labelPositionOutside = isPolar ? isHorizontalOrRadial ? layout$2.r >= layout$2.r0 ? "endArc" : "startArc" : layout$2.endAngle >= layout$2.startAngle ? "endAngle" : "startAngle" : isHorizontalOrRadial ? layout$2.height >= 0 ? "bottom" : "top" : layout$2.width >= 0 ? "right" : "left";
	var labelStatesModels = getLabelStatesModels(itemModel);
	setLabelStyle(el, labelStatesModels, {
		labelFetcher: seriesModel,
		labelDataIndex: dataIndex,
		defaultText: getDefaultLabel(seriesModel.getData(), dataIndex),
		inheritColor: style.fill,
		defaultOpacity: style.opacity,
		defaultOutsidePosition: labelPositionOutside
	});
	var label = el.getTextContent();
	if (isPolar && label) {
		var position = itemModel.get(["label", "position"]);
		el.textConfig.inside = position === "middle" ? true : null;
		setSectorTextRotation(el, position === "outside" ? labelPositionOutside : position, createPolarPositionMapping(isHorizontalOrRadial), itemModel.get(["label", "rotate"]));
	}
	setLabelValueAnimation(label, labelStatesModels, seriesModel.getRawValue(dataIndex), function(value) {
		return getDefaultInterpolatedLabel(data, value);
	});
	var emphasisModel = itemModel.getModel(["emphasis"]);
	toggleHoverEmphasis(el, emphasisModel.get("focus"), emphasisModel.get("blurScope"), emphasisModel.get("disabled"));
	setStatesStylesFromModel(el, itemModel);
	if (isZeroOnPolar(layout$2)) {
		el.style.fill = "none";
		el.style.stroke = "none";
		each$4(el.states, function(state) {
			if (state.style) state.style.fill = state.style.stroke = "none";
		});
	}
}
function getLineWidth(itemModel, rawLayout) {
	var borderColor = itemModel.get(["itemStyle", "borderColor"]);
	if (!borderColor || borderColor === "none") return 0;
	var lineWidth = itemModel.get(["itemStyle", "borderWidth"]) || 0;
	var width = isNaN(rawLayout.width) ? Number.MAX_VALUE : Math.abs(rawLayout.width);
	var height = isNaN(rawLayout.height) ? Number.MAX_VALUE : Math.abs(rawLayout.height);
	return Math.min(lineWidth, width, height);
}
var LagePathShape = function() {
	function LagePathShape$1() {}
	return LagePathShape$1;
}();
var LargePath = function(_super) {
	__extends(LargePath$1, _super);
	function LargePath$1(opts) {
		var _this = _super.call(this, opts) || this;
		_this.type = "largeBar";
		return _this;
	}
	LargePath$1.prototype.getDefaultShape = function() {
		return new LagePathShape();
	};
	LargePath$1.prototype.buildPath = function(ctx, shape) {
		var points$1 = shape.points;
		var baseDimIdx = this.baseDimIdx;
		var valueDimIdx = 1 - this.baseDimIdx;
		var startPoint = [];
		var size = [];
		var barWidth = this.barWidth;
		for (var i = 0; i < points$1.length; i += 3) {
			size[baseDimIdx] = barWidth;
			size[valueDimIdx] = points$1[i + 2];
			startPoint[baseDimIdx] = points$1[i + baseDimIdx];
			startPoint[valueDimIdx] = points$1[i + valueDimIdx];
			ctx.rect(startPoint[0], startPoint[1], size[0], size[1]);
		}
	};
	return LargePath$1;
}(Path_default);
function createLarge(seriesModel, group, progressiveEls, incremental) {
	var data = seriesModel.getData();
	var baseDimIdx = data.getLayout("valueAxisHorizontal") ? 1 : 0;
	var largeDataIndices = data.getLayout("largeDataIndices");
	var barWidth = data.getLayout("size");
	var backgroundModel = seriesModel.getModel("backgroundStyle");
	var bgPoints = data.getLayout("largeBackgroundPoints");
	if (bgPoints) {
		var bgEl = new LargePath({
			shape: { points: bgPoints },
			incremental: !!incremental,
			silent: true,
			z2: 0
		});
		bgEl.baseDimIdx = baseDimIdx;
		bgEl.largeDataIndices = largeDataIndices;
		bgEl.barWidth = barWidth;
		bgEl.useStyle(backgroundModel.getItemStyle());
		group.add(bgEl);
		progressiveEls && progressiveEls.push(bgEl);
	}
	var el = new LargePath({
		shape: { points: data.getLayout("largePoints") },
		incremental: !!incremental,
		ignoreCoarsePointer: true,
		z2: 1
	});
	el.baseDimIdx = baseDimIdx;
	el.largeDataIndices = largeDataIndices;
	el.barWidth = barWidth;
	group.add(el);
	el.useStyle(data.getVisual("style"));
	el.style.stroke = null;
	getECData(el).seriesIndex = seriesModel.seriesIndex;
	if (!seriesModel.get("silent")) {
		el.on("mousedown", largePathUpdateDataIndex);
		el.on("mousemove", largePathUpdateDataIndex);
	}
	progressiveEls && progressiveEls.push(el);
}
var largePathUpdateDataIndex = throttle(function(event) {
	var largePath = this;
	var dataIndex = largePathFindDataIndex(largePath, event.offsetX, event.offsetY);
	getECData(largePath).dataIndex = dataIndex >= 0 ? dataIndex : null;
}, 30, false);
function largePathFindDataIndex(largePath, x, y) {
	var baseDimIdx = largePath.baseDimIdx;
	var valueDimIdx = 1 - baseDimIdx;
	var points$1 = largePath.shape.points;
	var largeDataIndices = largePath.largeDataIndices;
	var startPoint = [];
	var size = [];
	var barWidth = largePath.barWidth;
	for (var i = 0, len$1 = points$1.length / 3; i < len$1; i++) {
		var ii = i * 3;
		size[baseDimIdx] = barWidth;
		size[valueDimIdx] = points$1[ii + 2];
		startPoint[baseDimIdx] = points$1[ii + baseDimIdx];
		startPoint[valueDimIdx] = points$1[ii + valueDimIdx];
		if (size[valueDimIdx] < 0) {
			startPoint[valueDimIdx] += size[valueDimIdx];
			size[valueDimIdx] = -size[valueDimIdx];
		}
		if (x >= startPoint[0] && x <= startPoint[0] + size[0] && y >= startPoint[1] && y <= startPoint[1] + size[1]) return largeDataIndices[i];
	}
	return -1;
}
function createBackgroundShape(isHorizontalOrRadial, layout$2, coord) {
	if (isCoordinateSystemType(coord, "cartesian2d")) {
		var rectShape = layout$2;
		var coordLayout = coord.getArea();
		return {
			x: isHorizontalOrRadial ? rectShape.x : coordLayout.x,
			y: isHorizontalOrRadial ? coordLayout.y : rectShape.y,
			width: isHorizontalOrRadial ? rectShape.width : coordLayout.width,
			height: isHorizontalOrRadial ? coordLayout.height : rectShape.height
		};
	} else {
		var coordLayout = coord.getArea();
		var sectorShape = layout$2;
		return {
			cx: coordLayout.cx,
			cy: coordLayout.cy,
			r0: isHorizontalOrRadial ? coordLayout.r0 : sectorShape.r0,
			r: isHorizontalOrRadial ? coordLayout.r : sectorShape.r,
			startAngle: isHorizontalOrRadial ? sectorShape.startAngle : 0,
			endAngle: isHorizontalOrRadial ? sectorShape.endAngle : Math.PI * 2
		};
	}
}
function createBackgroundEl(coord, isHorizontalOrRadial, layout$2) {
	var ElementClz = coord.type === "polar" ? Sector_default : Rect_default;
	return new ElementClz({
		shape: createBackgroundShape(isHorizontalOrRadial, layout$2, coord),
		silent: true,
		z2: 0
	});
}
var BarView_default = BarView;
function install$9(registers) {
	registers.registerChartView(BarView_default);
	registers.registerSeriesModel(BarSeries_default);
	registers.registerLayout(registers.PRIORITY.VISUAL.LAYOUT, curry$1(layout$1, "bar"));
	registers.registerLayout(registers.PRIORITY.VISUAL.PROGRESSIVE_LAYOUT, createProgressiveLayout("bar"));
	registers.registerProcessor(registers.PRIORITY.PROCESSOR.STATISTIC, dataSample("bar"));
	/**
	
	* @payload
	
	* @property {string} [componentType=series]
	
	* @property {number} [dx]
	
	* @property {number} [dy]
	
	* @property {number} [zoom]
	
	* @property {number} [originX]
	
	* @property {number} [originY]
	
	*/
	registers.registerAction({
		type: "changeAxisOrder",
		event: "changeAxisOrder",
		update: "update"
	}, function(payload, ecModel) {
		var componentType = payload.componentType || "series";
		ecModel.eachComponent({
			mainType: componentType,
			query: payload
		}, function(componentModel) {
			if (payload.sortInfo) componentModel.axis.setCategorySortInfo(payload.sortInfo);
		});
	});
}
function handleSeriesLegacySelectEvents(type, eventPostfix, ecIns, ecModel, payload) {
	var legacyEventName = type + eventPostfix;
	if (!ecIns.isSilent(legacyEventName)) ecModel.eachComponent({
		mainType: "series",
		subType: "pie"
	}, function(seriesModel) {
		var seriesIndex = seriesModel.seriesIndex;
		var selectedMap = seriesModel.option.selectedMap;
		var selected = payload.selected;
		for (var i = 0; i < selected.length; i++) if (selected[i].seriesIndex === seriesIndex) {
			var data = seriesModel.getData();
			var dataIndex = queryDataIndex(data, payload.fromActionPayload);
			ecIns.trigger(legacyEventName, {
				type: legacyEventName,
				seriesId: seriesModel.id,
				name: isArray(dataIndex) ? data.getName(dataIndex[0]) : data.getName(dataIndex),
				selected: isString(selectedMap) ? selectedMap : extend({}, selectedMap)
			});
		}
	});
}
function handleLegacySelectEvents(messageCenter, ecIns, api) {
	messageCenter.on("selectchanged", function(params) {
		var ecModel = api.getModel();
		if (params.isFromClick) {
			handleSeriesLegacySelectEvents("map", "selectchanged", ecIns, ecModel, params);
			handleSeriesLegacySelectEvents("pie", "selectchanged", ecIns, ecModel, params);
		} else if (params.fromAction === "select") {
			handleSeriesLegacySelectEvents("map", "selected", ecIns, ecModel, params);
			handleSeriesLegacySelectEvents("pie", "selected", ecIns, ecModel, params);
		} else if (params.fromAction === "unselect") {
			handleSeriesLegacySelectEvents("map", "unselected", ecIns, ecModel, params);
			handleSeriesLegacySelectEvents("pie", "unselected", ecIns, ecModel, params);
		}
	});
}
function prepareLayoutList(input) {
	var list = [];
	for (var i = 0; i < input.length; i++) {
		var rawItem = input[i];
		if (rawItem.defaultAttr.ignore) continue;
		var label = rawItem.label;
		var transform = label.getComputedTransform();
		var localRect = label.getBoundingRect();
		var isAxisAligned = !transform || transform[1] < 1e-5 && transform[2] < 1e-5;
		var minMargin = label.style.margin || 0;
		var globalRect = localRect.clone();
		globalRect.applyTransform(transform);
		globalRect.x -= minMargin / 2;
		globalRect.y -= minMargin / 2;
		globalRect.width += minMargin;
		globalRect.height += minMargin;
		var obb = isAxisAligned ? new OrientedBoundingRect_default(localRect, transform) : null;
		list.push({
			label,
			labelLine: rawItem.labelLine,
			rect: globalRect,
			localRect,
			obb,
			priority: rawItem.priority,
			defaultAttr: rawItem.defaultAttr,
			layoutOption: rawItem.computedLayoutOption,
			axisAligned: isAxisAligned,
			transform
		});
	}
	return list;
}
function hideOverlap(labelList) {
	var displayedLabels = [];
	labelList.sort(function(a, b) {
		return b.priority - a.priority;
	});
	var globalRect = new BoundingRect_default(0, 0, 0, 0);
	function hideEl(el) {
		if (!el.ignore) {
			var emphasisState = el.ensureState("emphasis");
			if (emphasisState.ignore == null) emphasisState.ignore = false;
		}
		el.ignore = true;
	}
	for (var i = 0; i < labelList.length; i++) {
		var labelItem = labelList[i];
		var isAxisAligned = labelItem.axisAligned;
		var localRect = labelItem.localRect;
		var transform = labelItem.transform;
		var label = labelItem.label;
		var labelLine = labelItem.labelLine;
		globalRect.copy(labelItem.rect);
		globalRect.width -= .1;
		globalRect.height -= .1;
		globalRect.x += .05;
		globalRect.y += .05;
		var obb = labelItem.obb;
		var overlapped = false;
		for (var j = 0; j < displayedLabels.length; j++) {
			var existsTextCfg = displayedLabels[j];
			if (!globalRect.intersect(existsTextCfg.rect)) continue;
			if (isAxisAligned && existsTextCfg.axisAligned) {
				overlapped = true;
				break;
			}
			if (!existsTextCfg.obb) existsTextCfg.obb = new OrientedBoundingRect_default(existsTextCfg.localRect, existsTextCfg.transform);
			if (!obb) obb = new OrientedBoundingRect_default(localRect, transform);
			if (obb.intersect(existsTextCfg.obb)) {
				overlapped = true;
				break;
			}
		}
		if (overlapped) {
			hideEl(label);
			labelLine && hideEl(labelLine);
		} else {
			label.attr("ignore", labelItem.defaultAttr.ignore);
			labelLine && labelLine.attr("ignore", labelItem.defaultAttr.labelGuideIgnore);
			displayedLabels.push(labelItem);
		}
	}
}
var Param = function() {
	function Param$1(target, e$1) {
		this.target = target;
		this.topTarget = e$1 && e$1.topTarget;
	}
	return Param$1;
}();
var Draggable = function() {
	function Draggable$1(handler) {
		this.handler = handler;
		handler.on("mousedown", this._dragStart, this);
		handler.on("mousemove", this._drag, this);
		handler.on("mouseup", this._dragEnd, this);
	}
	Draggable$1.prototype._dragStart = function(e$1) {
		var draggingTarget = e$1.target;
		while (draggingTarget && !draggingTarget.draggable) draggingTarget = draggingTarget.parent || draggingTarget.__hostTarget;
		if (draggingTarget) {
			this._draggingTarget = draggingTarget;
			draggingTarget.dragging = true;
			this._x = e$1.offsetX;
			this._y = e$1.offsetY;
			this.handler.dispatchToElement(new Param(draggingTarget, e$1), "dragstart", e$1.event);
		}
	};
	Draggable$1.prototype._drag = function(e$1) {
		var draggingTarget = this._draggingTarget;
		if (draggingTarget) {
			var x = e$1.offsetX;
			var y = e$1.offsetY;
			var dx = x - this._x;
			var dy = y - this._y;
			this._x = x;
			this._y = y;
			draggingTarget.drift(dx, dy, e$1);
			this.handler.dispatchToElement(new Param(draggingTarget, e$1), "drag", e$1.event);
			var dropTarget = this.handler.findHover(x, y, draggingTarget).target;
			var lastDropTarget = this._dropTarget;
			this._dropTarget = dropTarget;
			if (draggingTarget !== dropTarget) {
				if (lastDropTarget && dropTarget !== lastDropTarget) this.handler.dispatchToElement(new Param(lastDropTarget, e$1), "dragleave", e$1.event);
				if (dropTarget && dropTarget !== lastDropTarget) this.handler.dispatchToElement(new Param(dropTarget, e$1), "dragenter", e$1.event);
			}
		}
	};
	Draggable$1.prototype._dragEnd = function(e$1) {
		var draggingTarget = this._draggingTarget;
		if (draggingTarget) draggingTarget.dragging = false;
		this.handler.dispatchToElement(new Param(draggingTarget, e$1), "dragend", e$1.event);
		if (this._dropTarget) this.handler.dispatchToElement(new Param(this._dropTarget, e$1), "drop", e$1.event);
		this._draggingTarget = null;
		this._dropTarget = null;
	};
	return Draggable$1;
}();
var Draggable_default = Draggable;
var MOUSE_EVENT_REG = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
var _calcOut = [];
var firefoxNotSupportOffsetXY = env_default.browser.firefox && +env_default.browser.version.split(".")[0] < 39;
function clientToLocal(el, e$1, out$1, calculate) {
	out$1 = out$1 || {};
	if (calculate) calculateZrXY(el, e$1, out$1);
	else if (firefoxNotSupportOffsetXY && e$1.layerX != null && e$1.layerX !== e$1.offsetX) {
		out$1.zrX = e$1.layerX;
		out$1.zrY = e$1.layerY;
	} else if (e$1.offsetX != null) {
		out$1.zrX = e$1.offsetX;
		out$1.zrY = e$1.offsetY;
	} else calculateZrXY(el, e$1, out$1);
	return out$1;
}
function calculateZrXY(el, e$1, out$1) {
	if (env_default.domSupported && el.getBoundingClientRect) {
		var ex = e$1.clientX;
		var ey = e$1.clientY;
		if (isCanvasEl(el)) {
			var box$1 = el.getBoundingClientRect();
			out$1.zrX = ex - box$1.left;
			out$1.zrY = ey - box$1.top;
			return;
		} else if (transformCoordWithViewport(_calcOut, el, ex, ey)) {
			out$1.zrX = _calcOut[0];
			out$1.zrY = _calcOut[1];
			return;
		}
	}
	out$1.zrX = out$1.zrY = 0;
}
function getNativeEvent(e$1) {
	return e$1 || window.event;
}
function normalizeEvent(el, e$1, calculate) {
	e$1 = getNativeEvent(e$1);
	if (e$1.zrX != null) return e$1;
	var eventType = e$1.type;
	var isTouch = eventType && eventType.indexOf("touch") >= 0;
	if (!isTouch) {
		clientToLocal(el, e$1, e$1, calculate);
		var wheelDelta = getWheelDeltaMayPolyfill(e$1);
		e$1.zrDelta = wheelDelta ? wheelDelta / 120 : -(e$1.detail || 0) / 3;
	} else {
		var touch = eventType !== "touchend" ? e$1.targetTouches[0] : e$1.changedTouches[0];
		touch && clientToLocal(el, touch, e$1, calculate);
	}
	var button = e$1.button;
	if (e$1.which == null && button !== void 0 && MOUSE_EVENT_REG.test(e$1.type)) e$1.which = button & 1 ? 1 : button & 2 ? 3 : button & 4 ? 2 : 0;
	return e$1;
}
function getWheelDeltaMayPolyfill(e$1) {
	var rawWheelDelta = e$1.wheelDelta;
	if (rawWheelDelta) return rawWheelDelta;
	var deltaX = e$1.deltaX;
	var deltaY = e$1.deltaY;
	if (deltaX == null || deltaY == null) return rawWheelDelta;
	var delta = deltaY !== 0 ? Math.abs(deltaY) : Math.abs(deltaX);
	var sign = deltaY > 0 ? -1 : deltaY < 0 ? 1 : deltaX > 0 ? -1 : 1;
	return 3 * delta * sign;
}
function addEventListener(el, name, handler, opt) {
	el.addEventListener(name, handler, opt);
}
function removeEventListener(el, name, handler, opt) {
	el.removeEventListener(name, handler, opt);
}
var stop = function(e$1) {
	e$1.preventDefault();
	e$1.stopPropagation();
	e$1.cancelBubble = true;
};
var GestureMgr = function() {
	function GestureMgr$1() {
		this._track = [];
	}
	GestureMgr$1.prototype.recognize = function(event, target, root) {
		this._doTrack(event, target, root);
		return this._recognize(event);
	};
	GestureMgr$1.prototype.clear = function() {
		this._track.length = 0;
		return this;
	};
	GestureMgr$1.prototype._doTrack = function(event, target, root) {
		var touches = event.touches;
		if (!touches) return;
		var trackItem = {
			points: [],
			touches: [],
			target,
			event
		};
		for (var i = 0, len$1 = touches.length; i < len$1; i++) {
			var touch = touches[i];
			var pos = clientToLocal(root, touch, {});
			trackItem.points.push([pos.zrX, pos.zrY]);
			trackItem.touches.push(touch);
		}
		this._track.push(trackItem);
	};
	GestureMgr$1.prototype._recognize = function(event) {
		for (var eventName in recognizers) if (recognizers.hasOwnProperty(eventName)) {
			var gestureInfo = recognizers[eventName](this._track, event);
			if (gestureInfo) return gestureInfo;
		}
	};
	return GestureMgr$1;
}();
function dist(pointPair) {
	var dx = pointPair[1][0] - pointPair[0][0];
	var dy = pointPair[1][1] - pointPair[0][1];
	return Math.sqrt(dx * dx + dy * dy);
}
function center(pointPair) {
	return [(pointPair[0][0] + pointPair[1][0]) / 2, (pointPair[0][1] + pointPair[1][1]) / 2];
}
var recognizers = { pinch: function(tracks, event) {
	var trackLen = tracks.length;
	if (!trackLen) return;
	var pinchEnd = (tracks[trackLen - 1] || {}).points;
	var pinchPre = (tracks[trackLen - 2] || {}).points || pinchEnd;
	if (pinchPre && pinchPre.length > 1 && pinchEnd && pinchEnd.length > 1) {
		var pinchScale = dist(pinchEnd) / dist(pinchPre);
		!isFinite(pinchScale) && (pinchScale = 1);
		event.pinchScale = pinchScale;
		var pinchCenter = center(pinchEnd);
		event.pinchX = pinchCenter[0];
		event.pinchY = pinchCenter[1];
		return {
			type: "pinch",
			target: tracks[0].target,
			event
		};
	}
} };
var SILENT = "silent";
function makeEventPacket(eveType, targetInfo, event) {
	return {
		type: eveType,
		event,
		target: targetInfo.target,
		topTarget: targetInfo.topTarget,
		cancelBubble: false,
		offsetX: event.zrX,
		offsetY: event.zrY,
		gestureEvent: event.gestureEvent,
		pinchX: event.pinchX,
		pinchY: event.pinchY,
		pinchScale: event.pinchScale,
		wheelDelta: event.zrDelta,
		zrByTouch: event.zrByTouch,
		which: event.which,
		stop: stopEvent
	};
}
function stopEvent() {
	stop(this.event);
}
var EmptyProxy = function(_super) {
	__extends(EmptyProxy$1, _super);
	function EmptyProxy$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.handler = null;
		return _this;
	}
	EmptyProxy$1.prototype.dispose = function() {};
	EmptyProxy$1.prototype.setCursor = function() {};
	return EmptyProxy$1;
}(Eventful_default);
var HoveredResult = function() {
	function HoveredResult$1(x, y) {
		this.x = x;
		this.y = y;
	}
	return HoveredResult$1;
}();
var handlerNames = [
	"click",
	"dblclick",
	"mousewheel",
	"mouseout",
	"mouseup",
	"mousedown",
	"mousemove",
	"contextmenu"
];
var tmpRect = new BoundingRect_default(0, 0, 0, 0);
var Handler = function(_super) {
	__extends(Handler$1, _super);
	function Handler$1(storage, painter, proxy, painterRoot, pointerSize) {
		var _this = _super.call(this) || this;
		_this._hovered = new HoveredResult(0, 0);
		_this.storage = storage;
		_this.painter = painter;
		_this.painterRoot = painterRoot;
		_this._pointerSize = pointerSize;
		proxy = proxy || new EmptyProxy();
		_this.proxy = null;
		_this.setHandlerProxy(proxy);
		_this._draggingMgr = new Draggable_default(_this);
		return _this;
	}
	Handler$1.prototype.setHandlerProxy = function(proxy) {
		if (this.proxy) this.proxy.dispose();
		if (proxy) {
			each$4(handlerNames, function(name) {
				proxy.on && proxy.on(name, this[name], this);
			}, this);
			proxy.handler = this;
		}
		this.proxy = proxy;
	};
	Handler$1.prototype.mousemove = function(event) {
		var x = event.zrX;
		var y = event.zrY;
		var isOutside = isOutsideBoundary(this, x, y);
		var lastHovered = this._hovered;
		var lastHoveredTarget = lastHovered.target;
		if (lastHoveredTarget && !lastHoveredTarget.__zr) {
			lastHovered = this.findHover(lastHovered.x, lastHovered.y);
			lastHoveredTarget = lastHovered.target;
		}
		var hovered = this._hovered = isOutside ? new HoveredResult(x, y) : this.findHover(x, y);
		var hoveredTarget = hovered.target;
		var proxy = this.proxy;
		proxy.setCursor && proxy.setCursor(hoveredTarget ? hoveredTarget.cursor : "default");
		if (lastHoveredTarget && hoveredTarget !== lastHoveredTarget) this.dispatchToElement(lastHovered, "mouseout", event);
		this.dispatchToElement(hovered, "mousemove", event);
		if (hoveredTarget && hoveredTarget !== lastHoveredTarget) this.dispatchToElement(hovered, "mouseover", event);
	};
	Handler$1.prototype.mouseout = function(event) {
		var eventControl = event.zrEventControl;
		if (eventControl !== "only_globalout") this.dispatchToElement(this._hovered, "mouseout", event);
		if (eventControl !== "no_globalout") this.trigger("globalout", {
			type: "globalout",
			event
		});
	};
	Handler$1.prototype.resize = function() {
		this._hovered = new HoveredResult(0, 0);
	};
	Handler$1.prototype.dispatch = function(eventName, eventArgs) {
		var handler = this[eventName];
		handler && handler.call(this, eventArgs);
	};
	Handler$1.prototype.dispose = function() {
		this.proxy.dispose();
		this.storage = null;
		this.proxy = null;
		this.painter = null;
	};
	Handler$1.prototype.setCursorStyle = function(cursorStyle) {
		var proxy = this.proxy;
		proxy.setCursor && proxy.setCursor(cursorStyle);
	};
	Handler$1.prototype.dispatchToElement = function(targetInfo, eventName, event) {
		targetInfo = targetInfo || {};
		var el = targetInfo.target;
		if (el && el.silent) return;
		var eventKey = "on" + eventName;
		var eventPacket = makeEventPacket(eventName, targetInfo, event);
		while (el) {
			el[eventKey] && (eventPacket.cancelBubble = !!el[eventKey].call(el, eventPacket));
			el.trigger(eventName, eventPacket);
			el = el.__hostTarget ? el.__hostTarget : el.parent;
			if (eventPacket.cancelBubble) break;
		}
		if (!eventPacket.cancelBubble) {
			this.trigger(eventName, eventPacket);
			if (this.painter && this.painter.eachOtherLayer) this.painter.eachOtherLayer(function(layer) {
				if (typeof layer[eventKey] === "function") layer[eventKey].call(layer, eventPacket);
				if (layer.trigger) layer.trigger(eventName, eventPacket);
			});
		}
	};
	Handler$1.prototype.findHover = function(x, y, exclude) {
		var list = this.storage.getDisplayList();
		var out$1 = new HoveredResult(x, y);
		setHoverTarget(list, out$1, x, y, exclude);
		if (this._pointerSize && !out$1.target) {
			var candidates = [];
			var pointerSize = this._pointerSize;
			var targetSizeHalf = pointerSize / 2;
			var pointerRect = new BoundingRect_default(x - targetSizeHalf, y - targetSizeHalf, pointerSize, pointerSize);
			for (var i = list.length - 1; i >= 0; i--) {
				var el = list[i];
				if (el !== exclude && !el.ignore && !el.ignoreCoarsePointer && (!el.parent || !el.parent.ignoreCoarsePointer)) {
					tmpRect.copy(el.getBoundingRect());
					if (el.transform) tmpRect.applyTransform(el.transform);
					if (tmpRect.intersect(pointerRect)) candidates.push(el);
				}
			}
			if (candidates.length) {
				var rStep = 4;
				var thetaStep = Math.PI / 12;
				var PI2$6 = Math.PI * 2;
				for (var r = 0; r < targetSizeHalf; r += rStep) for (var theta = 0; theta < PI2$6; theta += thetaStep) {
					var x1 = x + r * Math.cos(theta);
					var y1 = y + r * Math.sin(theta);
					setHoverTarget(candidates, out$1, x1, y1, exclude);
					if (out$1.target) return out$1;
				}
			}
		}
		return out$1;
	};
	Handler$1.prototype.processGesture = function(event, stage) {
		if (!this._gestureMgr) this._gestureMgr = new GestureMgr();
		var gestureMgr = this._gestureMgr;
		stage === "start" && gestureMgr.clear();
		var gestureInfo = gestureMgr.recognize(event, this.findHover(event.zrX, event.zrY, null).target, this.proxy.dom);
		stage === "end" && gestureMgr.clear();
		if (gestureInfo) {
			var type = gestureInfo.type;
			event.gestureEvent = type;
			var res = new HoveredResult();
			res.target = gestureInfo.target;
			this.dispatchToElement(res, type, gestureInfo.event);
		}
	};
	return Handler$1;
}(Eventful_default);
each$4([
	"click",
	"mousedown",
	"mouseup",
	"mousewheel",
	"dblclick",
	"contextmenu"
], function(name) {
	Handler.prototype[name] = function(event) {
		var x = event.zrX;
		var y = event.zrY;
		var isOutside = isOutsideBoundary(this, x, y);
		var hovered;
		var hoveredTarget;
		if (name !== "mouseup" || !isOutside) {
			hovered = this.findHover(x, y);
			hoveredTarget = hovered.target;
		}
		if (name === "mousedown") {
			this._downEl = hoveredTarget;
			this._downPoint = [event.zrX, event.zrY];
			this._upEl = hoveredTarget;
		} else if (name === "mouseup") this._upEl = hoveredTarget;
		else if (name === "click") {
			if (this._downEl !== this._upEl || !this._downPoint || dist$1(this._downPoint, [event.zrX, event.zrY]) > 4) return;
			this._downPoint = null;
		}
		this.dispatchToElement(hovered, name, event);
	};
});
function isHover(displayable, x, y) {
	if (displayable[displayable.rectHover ? "rectContain" : "contain"](x, y)) {
		var el = displayable;
		var isSilent = void 0;
		var ignoreClip = false;
		while (el) {
			if (el.ignoreClip) ignoreClip = true;
			if (!ignoreClip) {
				var clipPath = el.getClipPath();
				if (clipPath && !clipPath.contain(x, y)) return false;
			}
			if (el.silent) isSilent = true;
			var hostEl = el.__hostTarget;
			el = hostEl ? hostEl : el.parent;
		}
		return isSilent ? SILENT : true;
	}
	return false;
}
function setHoverTarget(list, out$1, x, y, exclude) {
	for (var i = list.length - 1; i >= 0; i--) {
		var el = list[i];
		var hoverCheckResult = void 0;
		if (el !== exclude && !el.ignore && (hoverCheckResult = isHover(el, x, y))) {
			!out$1.topTarget && (out$1.topTarget = el);
			if (hoverCheckResult !== SILENT) {
				out$1.target = el;
				break;
			}
		}
	}
}
function isOutsideBoundary(handlerInstance, x, y) {
	var painter = handlerInstance.painter;
	return x < 0 || x > painter.getWidth() || y < 0 || y > painter.getHeight();
}
var Handler_default = Handler;
var DEFAULT_MIN_MERGE = 32;
var DEFAULT_MIN_GALLOPING = 7;
function minRunLength(n) {
	var r = 0;
	while (n >= DEFAULT_MIN_MERGE) {
		r |= n & 1;
		n >>= 1;
	}
	return n + r;
}
function makeAscendingRun(array, lo, hi, compare$1) {
	var runHi = lo + 1;
	if (runHi === hi) return 1;
	if (compare$1(array[runHi++], array[lo]) < 0) {
		while (runHi < hi && compare$1(array[runHi], array[runHi - 1]) < 0) runHi++;
		reverseRun(array, lo, runHi);
	} else while (runHi < hi && compare$1(array[runHi], array[runHi - 1]) >= 0) runHi++;
	return runHi - lo;
}
function reverseRun(array, lo, hi) {
	hi--;
	while (lo < hi) {
		var t = array[lo];
		array[lo++] = array[hi];
		array[hi--] = t;
	}
}
function binaryInsertionSort(array, lo, hi, start$1, compare$1) {
	if (start$1 === lo) start$1++;
	for (; start$1 < hi; start$1++) {
		var pivot = array[start$1];
		var left = lo;
		var right = start$1;
		var mid;
		while (left < right) {
			mid = left + right >>> 1;
			if (compare$1(pivot, array[mid]) < 0) right = mid;
			else left = mid + 1;
		}
		var n = start$1 - left;
		switch (n) {
			case 3: array[left + 3] = array[left + 2];
			case 2: array[left + 2] = array[left + 1];
			case 1:
				array[left + 1] = array[left];
				break;
			default: while (n > 0) {
				array[left + n] = array[left + n - 1];
				n--;
			}
		}
		array[left] = pivot;
	}
}
function gallopLeft(value, array, start$1, length, hint, compare$1) {
	var lastOffset = 0;
	var maxOffset = 0;
	var offset = 1;
	if (compare$1(value, array[start$1 + hint]) > 0) {
		maxOffset = length - hint;
		while (offset < maxOffset && compare$1(value, array[start$1 + hint + offset]) > 0) {
			lastOffset = offset;
			offset = (offset << 1) + 1;
			if (offset <= 0) offset = maxOffset;
		}
		if (offset > maxOffset) offset = maxOffset;
		lastOffset += hint;
		offset += hint;
	} else {
		maxOffset = hint + 1;
		while (offset < maxOffset && compare$1(value, array[start$1 + hint - offset]) <= 0) {
			lastOffset = offset;
			offset = (offset << 1) + 1;
			if (offset <= 0) offset = maxOffset;
		}
		if (offset > maxOffset) offset = maxOffset;
		var tmp = lastOffset;
		lastOffset = hint - offset;
		offset = hint - tmp;
	}
	lastOffset++;
	while (lastOffset < offset) {
		var m$1 = lastOffset + (offset - lastOffset >>> 1);
		if (compare$1(value, array[start$1 + m$1]) > 0) lastOffset = m$1 + 1;
		else offset = m$1;
	}
	return offset;
}
function gallopRight(value, array, start$1, length, hint, compare$1) {
	var lastOffset = 0;
	var maxOffset = 0;
	var offset = 1;
	if (compare$1(value, array[start$1 + hint]) < 0) {
		maxOffset = hint + 1;
		while (offset < maxOffset && compare$1(value, array[start$1 + hint - offset]) < 0) {
			lastOffset = offset;
			offset = (offset << 1) + 1;
			if (offset <= 0) offset = maxOffset;
		}
		if (offset > maxOffset) offset = maxOffset;
		var tmp = lastOffset;
		lastOffset = hint - offset;
		offset = hint - tmp;
	} else {
		maxOffset = length - hint;
		while (offset < maxOffset && compare$1(value, array[start$1 + hint + offset]) >= 0) {
			lastOffset = offset;
			offset = (offset << 1) + 1;
			if (offset <= 0) offset = maxOffset;
		}
		if (offset > maxOffset) offset = maxOffset;
		lastOffset += hint;
		offset += hint;
	}
	lastOffset++;
	while (lastOffset < offset) {
		var m$1 = lastOffset + (offset - lastOffset >>> 1);
		if (compare$1(value, array[start$1 + m$1]) < 0) offset = m$1;
		else lastOffset = m$1 + 1;
	}
	return offset;
}
function TimSort(array, compare$1) {
	var minGallop = DEFAULT_MIN_GALLOPING;
	var runStart;
	var runLength;
	var stackSize = 0;
	var tmp = [];
	runStart = [];
	runLength = [];
	function pushRun(_runStart, _runLength) {
		runStart[stackSize] = _runStart;
		runLength[stackSize] = _runLength;
		stackSize += 1;
	}
	function mergeRuns() {
		while (stackSize > 1) {
			var n = stackSize - 2;
			if (n >= 1 && runLength[n - 1] <= runLength[n] + runLength[n + 1] || n >= 2 && runLength[n - 2] <= runLength[n] + runLength[n - 1]) {
				if (runLength[n - 1] < runLength[n + 1]) n--;
			} else if (runLength[n] > runLength[n + 1]) break;
			mergeAt(n);
		}
	}
	function forceMergeRuns() {
		while (stackSize > 1) {
			var n = stackSize - 2;
			if (n > 0 && runLength[n - 1] < runLength[n + 1]) n--;
			mergeAt(n);
		}
	}
	function mergeAt(i) {
		var start1 = runStart[i];
		var length1 = runLength[i];
		var start2 = runStart[i + 1];
		var length2 = runLength[i + 1];
		runLength[i] = length1 + length2;
		if (i === stackSize - 3) {
			runStart[i + 1] = runStart[i + 2];
			runLength[i + 1] = runLength[i + 2];
		}
		stackSize--;
		var k = gallopRight(array[start2], array, start1, length1, 0, compare$1);
		start1 += k;
		length1 -= k;
		if (length1 === 0) return;
		length2 = gallopLeft(array[start1 + length1 - 1], array, start2, length2, length2 - 1, compare$1);
		if (length2 === 0) return;
		if (length1 <= length2) mergeLow(start1, length1, start2, length2);
		else mergeHigh(start1, length1, start2, length2);
	}
	function mergeLow(start1, length1, start2, length2) {
		var i = 0;
		for (i = 0; i < length1; i++) tmp[i] = array[start1 + i];
		var cursor1 = 0;
		var cursor2 = start2;
		var dest = start1;
		array[dest++] = array[cursor2++];
		if (--length2 === 0) {
			for (i = 0; i < length1; i++) array[dest + i] = tmp[cursor1 + i];
			return;
		}
		if (length1 === 1) {
			for (i = 0; i < length2; i++) array[dest + i] = array[cursor2 + i];
			array[dest + length2] = tmp[cursor1];
			return;
		}
		var _minGallop = minGallop;
		var count1;
		var count2;
		var exit;
		while (1) {
			count1 = 0;
			count2 = 0;
			exit = false;
			do
				if (compare$1(array[cursor2], tmp[cursor1]) < 0) {
					array[dest++] = array[cursor2++];
					count2++;
					count1 = 0;
					if (--length2 === 0) {
						exit = true;
						break;
					}
				} else {
					array[dest++] = tmp[cursor1++];
					count1++;
					count2 = 0;
					if (--length1 === 1) {
						exit = true;
						break;
					}
				}
			while ((count1 | count2) < _minGallop);
			if (exit) break;
			do {
				count1 = gallopRight(array[cursor2], tmp, cursor1, length1, 0, compare$1);
				if (count1 !== 0) {
					for (i = 0; i < count1; i++) array[dest + i] = tmp[cursor1 + i];
					dest += count1;
					cursor1 += count1;
					length1 -= count1;
					if (length1 <= 1) {
						exit = true;
						break;
					}
				}
				array[dest++] = array[cursor2++];
				if (--length2 === 0) {
					exit = true;
					break;
				}
				count2 = gallopLeft(tmp[cursor1], array, cursor2, length2, 0, compare$1);
				if (count2 !== 0) {
					for (i = 0; i < count2; i++) array[dest + i] = array[cursor2 + i];
					dest += count2;
					cursor2 += count2;
					length2 -= count2;
					if (length2 === 0) {
						exit = true;
						break;
					}
				}
				array[dest++] = tmp[cursor1++];
				if (--length1 === 1) {
					exit = true;
					break;
				}
				_minGallop--;
			} while (count1 >= DEFAULT_MIN_GALLOPING || count2 >= DEFAULT_MIN_GALLOPING);
			if (exit) break;
			if (_minGallop < 0) _minGallop = 0;
			_minGallop += 2;
		}
		minGallop = _minGallop;
		minGallop < 1 && (minGallop = 1);
		if (length1 === 1) {
			for (i = 0; i < length2; i++) array[dest + i] = array[cursor2 + i];
			array[dest + length2] = tmp[cursor1];
		} else if (length1 === 0) throw new Error();
		else for (i = 0; i < length1; i++) array[dest + i] = tmp[cursor1 + i];
	}
	function mergeHigh(start1, length1, start2, length2) {
		var i = 0;
		for (i = 0; i < length2; i++) tmp[i] = array[start2 + i];
		var cursor1 = start1 + length1 - 1;
		var cursor2 = length2 - 1;
		var dest = start2 + length2 - 1;
		var customCursor = 0;
		var customDest = 0;
		array[dest--] = array[cursor1--];
		if (--length1 === 0) {
			customCursor = dest - (length2 - 1);
			for (i = 0; i < length2; i++) array[customCursor + i] = tmp[i];
			return;
		}
		if (length2 === 1) {
			dest -= length1;
			cursor1 -= length1;
			customDest = dest + 1;
			customCursor = cursor1 + 1;
			for (i = length1 - 1; i >= 0; i--) array[customDest + i] = array[customCursor + i];
			array[dest] = tmp[cursor2];
			return;
		}
		var _minGallop = minGallop;
		while (true) {
			var count1 = 0;
			var count2 = 0;
			var exit = false;
			do
				if (compare$1(tmp[cursor2], array[cursor1]) < 0) {
					array[dest--] = array[cursor1--];
					count1++;
					count2 = 0;
					if (--length1 === 0) {
						exit = true;
						break;
					}
				} else {
					array[dest--] = tmp[cursor2--];
					count2++;
					count1 = 0;
					if (--length2 === 1) {
						exit = true;
						break;
					}
				}
			while ((count1 | count2) < _minGallop);
			if (exit) break;
			do {
				count1 = length1 - gallopRight(tmp[cursor2], array, start1, length1, length1 - 1, compare$1);
				if (count1 !== 0) {
					dest -= count1;
					cursor1 -= count1;
					length1 -= count1;
					customDest = dest + 1;
					customCursor = cursor1 + 1;
					for (i = count1 - 1; i >= 0; i--) array[customDest + i] = array[customCursor + i];
					if (length1 === 0) {
						exit = true;
						break;
					}
				}
				array[dest--] = tmp[cursor2--];
				if (--length2 === 1) {
					exit = true;
					break;
				}
				count2 = length2 - gallopLeft(array[cursor1], tmp, 0, length2, length2 - 1, compare$1);
				if (count2 !== 0) {
					dest -= count2;
					cursor2 -= count2;
					length2 -= count2;
					customDest = dest + 1;
					customCursor = cursor2 + 1;
					for (i = 0; i < count2; i++) array[customDest + i] = tmp[customCursor + i];
					if (length2 <= 1) {
						exit = true;
						break;
					}
				}
				array[dest--] = array[cursor1--];
				if (--length1 === 0) {
					exit = true;
					break;
				}
				_minGallop--;
			} while (count1 >= DEFAULT_MIN_GALLOPING || count2 >= DEFAULT_MIN_GALLOPING);
			if (exit) break;
			if (_minGallop < 0) _minGallop = 0;
			_minGallop += 2;
		}
		minGallop = _minGallop;
		if (minGallop < 1) minGallop = 1;
		if (length2 === 1) {
			dest -= length1;
			cursor1 -= length1;
			customDest = dest + 1;
			customCursor = cursor1 + 1;
			for (i = length1 - 1; i >= 0; i--) array[customDest + i] = array[customCursor + i];
			array[dest] = tmp[cursor2];
		} else if (length2 === 0) throw new Error();
		else {
			customCursor = dest - (length2 - 1);
			for (i = 0; i < length2; i++) array[customCursor + i] = tmp[i];
		}
	}
	return {
		mergeRuns,
		forceMergeRuns,
		pushRun
	};
}
function sort(array, compare$1, lo, hi) {
	if (!lo) lo = 0;
	if (!hi) hi = array.length;
	var remaining = hi - lo;
	if (remaining < 2) return;
	var runLength = 0;
	if (remaining < DEFAULT_MIN_MERGE) {
		runLength = makeAscendingRun(array, lo, hi, compare$1);
		binaryInsertionSort(array, lo, hi, lo + runLength, compare$1);
		return;
	}
	var ts = TimSort(array, compare$1);
	var minRun = minRunLength(remaining);
	do {
		runLength = makeAscendingRun(array, lo, hi, compare$1);
		if (runLength < minRun) {
			var force = remaining;
			if (force > minRun) force = minRun;
			binaryInsertionSort(array, lo, lo + force, lo + runLength, compare$1);
			runLength = force;
		}
		ts.pushRun(lo, runLength);
		ts.mergeRuns();
		remaining -= runLength;
		lo += runLength;
	} while (remaining !== 0);
	ts.forceMergeRuns();
}
var invalidZErrorLogged = false;
function logInvalidZError() {
	if (invalidZErrorLogged) return;
	invalidZErrorLogged = true;
	console.warn("z / z2 / zlevel of displayable is invalid, which may cause unexpected errors");
}
function shapeCompareFunc(a, b) {
	if (a.zlevel === b.zlevel) {
		if (a.z === b.z) return a.z2 - b.z2;
		return a.z - b.z;
	}
	return a.zlevel - b.zlevel;
}
var Storage = function() {
	function Storage$1() {
		this._roots = [];
		this._displayList = [];
		this._displayListLen = 0;
		this.displayableSortFunc = shapeCompareFunc;
	}
	Storage$1.prototype.traverse = function(cb, context) {
		for (var i = 0; i < this._roots.length; i++) this._roots[i].traverse(cb, context);
	};
	Storage$1.prototype.getDisplayList = function(update, includeIgnore) {
		includeIgnore = includeIgnore || false;
		var displayList = this._displayList;
		if (update || !displayList.length) this.updateDisplayList(includeIgnore);
		return displayList;
	};
	Storage$1.prototype.updateDisplayList = function(includeIgnore) {
		this._displayListLen = 0;
		var roots$1 = this._roots;
		var displayList = this._displayList;
		for (var i = 0, len$1 = roots$1.length; i < len$1; i++) this._updateAndAddDisplayable(roots$1[i], null, includeIgnore);
		displayList.length = this._displayListLen;
		sort(displayList, shapeCompareFunc);
	};
	Storage$1.prototype._updateAndAddDisplayable = function(el, clipPaths, includeIgnore) {
		if (el.ignore && !includeIgnore) return;
		el.beforeUpdate();
		el.update();
		el.afterUpdate();
		var userSetClipPath = el.getClipPath();
		if (el.ignoreClip) clipPaths = null;
		else if (userSetClipPath) {
			if (clipPaths) clipPaths = clipPaths.slice();
			else clipPaths = [];
			var currentClipPath = userSetClipPath;
			var parentClipPath = el;
			while (currentClipPath) {
				currentClipPath.parent = parentClipPath;
				currentClipPath.updateTransform();
				clipPaths.push(currentClipPath);
				parentClipPath = currentClipPath;
				currentClipPath = currentClipPath.getClipPath();
			}
		}
		if (el.childrenRef) {
			var children = el.childrenRef();
			for (var i = 0; i < children.length; i++) {
				var child = children[i];
				if (el.__dirty) child.__dirty |= REDRAW_BIT;
				this._updateAndAddDisplayable(child, clipPaths, includeIgnore);
			}
			el.__dirty = 0;
		} else {
			var disp = el;
			if (clipPaths && clipPaths.length) disp.__clipPaths = clipPaths;
			else if (disp.__clipPaths && disp.__clipPaths.length > 0) disp.__clipPaths = [];
			if (isNaN(disp.z)) {
				logInvalidZError();
				disp.z = 0;
			}
			if (isNaN(disp.z2)) {
				logInvalidZError();
				disp.z2 = 0;
			}
			if (isNaN(disp.zlevel)) {
				logInvalidZError();
				disp.zlevel = 0;
			}
			this._displayList[this._displayListLen++] = disp;
		}
		var decalEl = el.getDecalElement && el.getDecalElement();
		if (decalEl) this._updateAndAddDisplayable(decalEl, clipPaths, includeIgnore);
		var textGuide = el.getTextGuideLine();
		if (textGuide) this._updateAndAddDisplayable(textGuide, clipPaths, includeIgnore);
		var textEl = el.getTextContent();
		if (textEl) this._updateAndAddDisplayable(textEl, clipPaths, includeIgnore);
	};
	Storage$1.prototype.addRoot = function(el) {
		if (el.__zr && el.__zr.storage === this) return;
		this._roots.push(el);
	};
	Storage$1.prototype.delRoot = function(el) {
		if (el instanceof Array) {
			for (var i = 0, l = el.length; i < l; i++) this.delRoot(el[i]);
			return;
		}
		var idx = indexOf(this._roots, el);
		if (idx >= 0) this._roots.splice(idx, 1);
	};
	Storage$1.prototype.delAllRoots = function() {
		this._roots = [];
		this._displayList = [];
		this._displayListLen = 0;
		return;
	};
	Storage$1.prototype.getRoots = function() {
		return this._roots;
	};
	Storage$1.prototype.dispose = function() {
		this._displayList = null;
		this._roots = null;
	};
	return Storage$1;
}();
var Storage_default = Storage;
var requestAnimationFrame;
requestAnimationFrame = env_default.hasGlobalWindow && (window.requestAnimationFrame && window.requestAnimationFrame.bind(window) || window.msRequestAnimationFrame && window.msRequestAnimationFrame.bind(window) || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame) || function(func) {
	return setTimeout(func, 16);
};
var requestAnimationFrame_default = requestAnimationFrame;
function getTime() {
	return new Date().getTime();
}
var Animation = function(_super) {
	__extends(Animation$1, _super);
	function Animation$1(opts) {
		var _this = _super.call(this) || this;
		_this._running = false;
		_this._time = 0;
		_this._pausedTime = 0;
		_this._pauseStart = 0;
		_this._paused = false;
		opts = opts || {};
		_this.stage = opts.stage || {};
		return _this;
	}
	Animation$1.prototype.addClip = function(clip$1) {
		if (clip$1.animation) this.removeClip(clip$1);
		if (!this._head) this._head = this._tail = clip$1;
		else {
			this._tail.next = clip$1;
			clip$1.prev = this._tail;
			clip$1.next = null;
			this._tail = clip$1;
		}
		clip$1.animation = this;
	};
	Animation$1.prototype.addAnimator = function(animator) {
		animator.animation = this;
		var clip$1 = animator.getClip();
		if (clip$1) this.addClip(clip$1);
	};
	Animation$1.prototype.removeClip = function(clip$1) {
		if (!clip$1.animation) return;
		var prev = clip$1.prev;
		var next = clip$1.next;
		if (prev) prev.next = next;
		else this._head = next;
		if (next) next.prev = prev;
		else this._tail = prev;
		clip$1.next = clip$1.prev = clip$1.animation = null;
	};
	Animation$1.prototype.removeAnimator = function(animator) {
		var clip$1 = animator.getClip();
		if (clip$1) this.removeClip(clip$1);
		animator.animation = null;
	};
	Animation$1.prototype.update = function(notTriggerFrameAndStageUpdate) {
		var time = getTime() - this._pausedTime;
		var delta = time - this._time;
		var clip$1 = this._head;
		while (clip$1) {
			var nextClip = clip$1.next;
			var finished = clip$1.step(time, delta);
			if (finished) {
				clip$1.ondestroy();
				this.removeClip(clip$1);
				clip$1 = nextClip;
			} else clip$1 = nextClip;
		}
		this._time = time;
		if (!notTriggerFrameAndStageUpdate) {
			this.trigger("frame", delta);
			this.stage.update && this.stage.update();
		}
	};
	Animation$1.prototype._startLoop = function() {
		var self$1 = this;
		this._running = true;
		function step() {
			if (self$1._running) {
				requestAnimationFrame_default(step);
				!self$1._paused && self$1.update();
			}
		}
		requestAnimationFrame_default(step);
	};
	Animation$1.prototype.start = function() {
		if (this._running) return;
		this._time = getTime();
		this._pausedTime = 0;
		this._startLoop();
	};
	Animation$1.prototype.stop = function() {
		this._running = false;
	};
	Animation$1.prototype.pause = function() {
		if (!this._paused) {
			this._pauseStart = getTime();
			this._paused = true;
		}
	};
	Animation$1.prototype.resume = function() {
		if (this._paused) {
			this._pausedTime += getTime() - this._pauseStart;
			this._paused = false;
		}
	};
	Animation$1.prototype.clear = function() {
		var clip$1 = this._head;
		while (clip$1) {
			var nextClip = clip$1.next;
			clip$1.prev = clip$1.next = clip$1.animation = null;
			clip$1 = nextClip;
		}
		this._head = this._tail = null;
	};
	Animation$1.prototype.isFinished = function() {
		return this._head == null;
	};
	Animation$1.prototype.animate = function(target, options) {
		options = options || {};
		this.start();
		var animator = new Animator_default(target, options.loop);
		this.addAnimator(animator);
		return animator;
	};
	return Animation$1;
}(Eventful_default);
var Animation_default = Animation;
var TOUCH_CLICK_DELAY = 300;
var globalEventSupported = env_default.domSupported;
var localNativeListenerNames = function() {
	var mouseHandlerNames = [
		"click",
		"dblclick",
		"mousewheel",
		"wheel",
		"mouseout",
		"mouseup",
		"mousedown",
		"mousemove",
		"contextmenu"
	];
	var touchHandlerNames = [
		"touchstart",
		"touchend",
		"touchmove"
	];
	var pointerEventNameMap = {
		pointerdown: 1,
		pointerup: 1,
		pointermove: 1,
		pointerout: 1
	};
	var pointerHandlerNames = map$1(mouseHandlerNames, function(name) {
		var nm = name.replace("mouse", "pointer");
		return pointerEventNameMap.hasOwnProperty(nm) ? nm : name;
	});
	return {
		mouse: mouseHandlerNames,
		touch: touchHandlerNames,
		pointer: pointerHandlerNames
	};
}();
var globalNativeListenerNames = {
	mouse: ["mousemove", "mouseup"],
	pointer: ["pointermove", "pointerup"]
};
var wheelEventSupported = false;
function isPointerFromTouch(event) {
	var pointerType = event.pointerType;
	return pointerType === "pen" || pointerType === "touch";
}
function setTouchTimer(scope) {
	scope.touching = true;
	if (scope.touchTimer != null) {
		clearTimeout(scope.touchTimer);
		scope.touchTimer = null;
	}
	scope.touchTimer = setTimeout(function() {
		scope.touching = false;
		scope.touchTimer = null;
	}, 700);
}
function markTouch(event) {
	event && (event.zrByTouch = true);
}
function normalizeGlobalEvent(instance, event) {
	return normalizeEvent(instance.dom, new FakeGlobalEvent(instance, event), true);
}
function isLocalEl(instance, el) {
	var elTmp = el;
	var isLocal = false;
	while (elTmp && elTmp.nodeType !== 9 && !(isLocal = elTmp.domBelongToZr || elTmp !== el && elTmp === instance.painterRoot)) elTmp = elTmp.parentNode;
	return isLocal;
}
var FakeGlobalEvent = function() {
	function FakeGlobalEvent$1(instance, event) {
		this.stopPropagation = noop;
		this.stopImmediatePropagation = noop;
		this.preventDefault = noop;
		this.type = event.type;
		this.target = this.currentTarget = instance.dom;
		this.pointerType = event.pointerType;
		this.clientX = event.clientX;
		this.clientY = event.clientY;
	}
	return FakeGlobalEvent$1;
}();
var localDOMHandlers = {
	mousedown: function(event) {
		event = normalizeEvent(this.dom, event);
		this.__mayPointerCapture = [event.zrX, event.zrY];
		this.trigger("mousedown", event);
	},
	mousemove: function(event) {
		event = normalizeEvent(this.dom, event);
		var downPoint = this.__mayPointerCapture;
		if (downPoint && (event.zrX !== downPoint[0] || event.zrY !== downPoint[1])) this.__togglePointerCapture(true);
		this.trigger("mousemove", event);
	},
	mouseup: function(event) {
		event = normalizeEvent(this.dom, event);
		this.__togglePointerCapture(false);
		this.trigger("mouseup", event);
	},
	mouseout: function(event) {
		event = normalizeEvent(this.dom, event);
		var element = event.toElement || event.relatedTarget;
		if (!isLocalEl(this, element)) {
			if (this.__pointerCapturing) event.zrEventControl = "no_globalout";
			this.trigger("mouseout", event);
		}
	},
	wheel: function(event) {
		wheelEventSupported = true;
		event = normalizeEvent(this.dom, event);
		this.trigger("mousewheel", event);
	},
	mousewheel: function(event) {
		if (wheelEventSupported) return;
		event = normalizeEvent(this.dom, event);
		this.trigger("mousewheel", event);
	},
	touchstart: function(event) {
		event = normalizeEvent(this.dom, event);
		markTouch(event);
		this.__lastTouchMoment = new Date();
		this.handler.processGesture(event, "start");
		localDOMHandlers.mousemove.call(this, event);
		localDOMHandlers.mousedown.call(this, event);
	},
	touchmove: function(event) {
		event = normalizeEvent(this.dom, event);
		markTouch(event);
		this.handler.processGesture(event, "change");
		localDOMHandlers.mousemove.call(this, event);
	},
	touchend: function(event) {
		event = normalizeEvent(this.dom, event);
		markTouch(event);
		this.handler.processGesture(event, "end");
		localDOMHandlers.mouseup.call(this, event);
		if (+new Date() - +this.__lastTouchMoment < TOUCH_CLICK_DELAY) localDOMHandlers.click.call(this, event);
	},
	pointerdown: function(event) {
		localDOMHandlers.mousedown.call(this, event);
	},
	pointermove: function(event) {
		if (!isPointerFromTouch(event)) localDOMHandlers.mousemove.call(this, event);
	},
	pointerup: function(event) {
		localDOMHandlers.mouseup.call(this, event);
	},
	pointerout: function(event) {
		if (!isPointerFromTouch(event)) localDOMHandlers.mouseout.call(this, event);
	}
};
each$4([
	"click",
	"dblclick",
	"contextmenu"
], function(name) {
	localDOMHandlers[name] = function(event) {
		event = normalizeEvent(this.dom, event);
		this.trigger(name, event);
	};
});
var globalDOMHandlers = {
	pointermove: function(event) {
		if (!isPointerFromTouch(event)) globalDOMHandlers.mousemove.call(this, event);
	},
	pointerup: function(event) {
		globalDOMHandlers.mouseup.call(this, event);
	},
	mousemove: function(event) {
		this.trigger("mousemove", event);
	},
	mouseup: function(event) {
		var pointerCaptureReleasing = this.__pointerCapturing;
		this.__togglePointerCapture(false);
		this.trigger("mouseup", event);
		if (pointerCaptureReleasing) {
			event.zrEventControl = "only_globalout";
			this.trigger("mouseout", event);
		}
	}
};
function mountLocalDOMEventListeners(instance, scope) {
	var domHandlers = scope.domHandlers;
	if (env_default.pointerEventsSupported) each$4(localNativeListenerNames.pointer, function(nativeEventName) {
		mountSingleDOMEventListener(scope, nativeEventName, function(event) {
			domHandlers[nativeEventName].call(instance, event);
		});
	});
	else {
		if (env_default.touchEventsSupported) each$4(localNativeListenerNames.touch, function(nativeEventName) {
			mountSingleDOMEventListener(scope, nativeEventName, function(event) {
				domHandlers[nativeEventName].call(instance, event);
				setTouchTimer(scope);
			});
		});
		each$4(localNativeListenerNames.mouse, function(nativeEventName) {
			mountSingleDOMEventListener(scope, nativeEventName, function(event) {
				event = getNativeEvent(event);
				if (!scope.touching) domHandlers[nativeEventName].call(instance, event);
			});
		});
	}
}
function mountGlobalDOMEventListeners(instance, scope) {
	if (env_default.pointerEventsSupported) each$4(globalNativeListenerNames.pointer, mount);
	else if (!env_default.touchEventsSupported) each$4(globalNativeListenerNames.mouse, mount);
	function mount(nativeEventName) {
		function nativeEventListener(event) {
			event = getNativeEvent(event);
			if (!isLocalEl(instance, event.target)) {
				event = normalizeGlobalEvent(instance, event);
				scope.domHandlers[nativeEventName].call(instance, event);
			}
		}
		mountSingleDOMEventListener(scope, nativeEventName, nativeEventListener, { capture: true });
	}
}
function mountSingleDOMEventListener(scope, nativeEventName, listener, opt) {
	scope.mounted[nativeEventName] = listener;
	scope.listenerOpts[nativeEventName] = opt;
	addEventListener(scope.domTarget, nativeEventName, listener, opt);
}
function unmountDOMEventListeners(scope) {
	var mounted = scope.mounted;
	for (var nativeEventName in mounted) if (mounted.hasOwnProperty(nativeEventName)) removeEventListener(scope.domTarget, nativeEventName, mounted[nativeEventName], scope.listenerOpts[nativeEventName]);
	scope.mounted = {};
}
var DOMHandlerScope = function() {
	function DOMHandlerScope$1(domTarget, domHandlers) {
		this.mounted = {};
		this.listenerOpts = {};
		this.touching = false;
		this.domTarget = domTarget;
		this.domHandlers = domHandlers;
	}
	return DOMHandlerScope$1;
}();
var HandlerDomProxy = function(_super) {
	__extends(HandlerDomProxy$1, _super);
	function HandlerDomProxy$1(dom, painterRoot) {
		var _this = _super.call(this) || this;
		_this.__pointerCapturing = false;
		_this.dom = dom;
		_this.painterRoot = painterRoot;
		_this._localHandlerScope = new DOMHandlerScope(dom, localDOMHandlers);
		if (globalEventSupported) _this._globalHandlerScope = new DOMHandlerScope(document, globalDOMHandlers);
		mountLocalDOMEventListeners(_this, _this._localHandlerScope);
		return _this;
	}
	HandlerDomProxy$1.prototype.dispose = function() {
		unmountDOMEventListeners(this._localHandlerScope);
		if (globalEventSupported) unmountDOMEventListeners(this._globalHandlerScope);
	};
	HandlerDomProxy$1.prototype.setCursor = function(cursorStyle) {
		this.dom.style && (this.dom.style.cursor = cursorStyle || "default");
	};
	HandlerDomProxy$1.prototype.__togglePointerCapture = function(isPointerCapturing) {
		this.__mayPointerCapture = null;
		if (globalEventSupported && +this.__pointerCapturing ^ +isPointerCapturing) {
			this.__pointerCapturing = isPointerCapturing;
			var globalHandlerScope = this._globalHandlerScope;
			isPointerCapturing ? mountGlobalDOMEventListeners(this, globalHandlerScope) : unmountDOMEventListeners(globalHandlerScope);
		}
	};
	return HandlerDomProxy$1;
}(Eventful_default);
var HandlerProxy_default = HandlerDomProxy;
var painterCtors = {};
var instances$1 = {};
function delInstance(id) {
	delete instances$1[id];
}
function isDarkMode(backgroundColor$1) {
	if (!backgroundColor$1) return false;
	if (typeof backgroundColor$1 === "string") return lum(backgroundColor$1, 1) < DARK_MODE_THRESHOLD;
	else if (backgroundColor$1.colorStops) {
		var colorStops = backgroundColor$1.colorStops;
		var totalLum = 0;
		var len$1 = colorStops.length;
		for (var i = 0; i < len$1; i++) totalLum += lum(colorStops[i].color, 1);
		totalLum /= len$1;
		return totalLum < DARK_MODE_THRESHOLD;
	}
	return false;
}
var ZRender = function() {
	function ZRender$1(id, dom, opts) {
		var _this = this;
		this._sleepAfterStill = 10;
		this._stillFrameAccum = 0;
		this._needsRefresh = true;
		this._needsRefreshHover = true;
		this._darkMode = false;
		opts = opts || {};
		this.dom = dom;
		this.id = id;
		var storage = new Storage_default();
		var rendererType = opts.renderer || "canvas";
		if (!painterCtors[rendererType]) rendererType = keys(painterCtors)[0];
		opts.useDirtyRect = opts.useDirtyRect == null ? false : opts.useDirtyRect;
		var painter = new painterCtors[rendererType](dom, storage, opts, id);
		var ssrMode = opts.ssr || painter.ssrOnly;
		this.storage = storage;
		this.painter = painter;
		var handlerProxy = !env_default.node && !env_default.worker && !ssrMode ? new HandlerProxy_default(painter.getViewportRoot(), painter.root) : null;
		var useCoarsePointer = opts.useCoarsePointer;
		var usePointerSize = useCoarsePointer == null || useCoarsePointer === "auto" ? env_default.touchEventsSupported : !!useCoarsePointer;
		var defaultPointerSize = 44;
		var pointerSize;
		if (usePointerSize) pointerSize = retrieve2(opts.pointerSize, defaultPointerSize);
		this.handler = new Handler_default(storage, painter, handlerProxy, painter.root, pointerSize);
		this.animation = new Animation_default({ stage: { update: ssrMode ? null : function() {
			return _this._flush(true);
		} } });
		if (!ssrMode) this.animation.start();
	}
	ZRender$1.prototype.add = function(el) {
		if (this._disposed || !el) return;
		this.storage.addRoot(el);
		el.addSelfToZr(this);
		this.refresh();
	};
	ZRender$1.prototype.remove = function(el) {
		if (this._disposed || !el) return;
		this.storage.delRoot(el);
		el.removeSelfFromZr(this);
		this.refresh();
	};
	ZRender$1.prototype.configLayer = function(zLevel, config) {
		if (this._disposed) return;
		if (this.painter.configLayer) this.painter.configLayer(zLevel, config);
		this.refresh();
	};
	ZRender$1.prototype.setBackgroundColor = function(backgroundColor$1) {
		if (this._disposed) return;
		if (this.painter.setBackgroundColor) this.painter.setBackgroundColor(backgroundColor$1);
		this.refresh();
		this._backgroundColor = backgroundColor$1;
		this._darkMode = isDarkMode(backgroundColor$1);
	};
	ZRender$1.prototype.getBackgroundColor = function() {
		return this._backgroundColor;
	};
	ZRender$1.prototype.setDarkMode = function(darkMode) {
		this._darkMode = darkMode;
	};
	ZRender$1.prototype.isDarkMode = function() {
		return this._darkMode;
	};
	ZRender$1.prototype.refreshImmediately = function(fromInside) {
		if (this._disposed) return;
		if (!fromInside) this.animation.update(true);
		this._needsRefresh = false;
		this.painter.refresh();
		this._needsRefresh = false;
	};
	ZRender$1.prototype.refresh = function() {
		if (this._disposed) return;
		this._needsRefresh = true;
		this.animation.start();
	};
	ZRender$1.prototype.flush = function() {
		if (this._disposed) return;
		this._flush(false);
	};
	ZRender$1.prototype._flush = function(fromInside) {
		var triggerRendered;
		var start$1 = getTime();
		if (this._needsRefresh) {
			triggerRendered = true;
			this.refreshImmediately(fromInside);
		}
		if (this._needsRefreshHover) {
			triggerRendered = true;
			this.refreshHoverImmediately();
		}
		var end$1 = getTime();
		if (triggerRendered) {
			this._stillFrameAccum = 0;
			this.trigger("rendered", { elapsedTime: end$1 - start$1 });
		} else if (this._sleepAfterStill > 0) {
			this._stillFrameAccum++;
			if (this._stillFrameAccum > this._sleepAfterStill) this.animation.stop();
		}
	};
	ZRender$1.prototype.setSleepAfterStill = function(stillFramesCount) {
		this._sleepAfterStill = stillFramesCount;
	};
	ZRender$1.prototype.wakeUp = function() {
		if (this._disposed) return;
		this.animation.start();
		this._stillFrameAccum = 0;
	};
	ZRender$1.prototype.refreshHover = function() {
		this._needsRefreshHover = true;
	};
	ZRender$1.prototype.refreshHoverImmediately = function() {
		if (this._disposed) return;
		this._needsRefreshHover = false;
		if (this.painter.refreshHover && this.painter.getType() === "canvas") this.painter.refreshHover();
	};
	ZRender$1.prototype.resize = function(opts) {
		if (this._disposed) return;
		opts = opts || {};
		this.painter.resize(opts.width, opts.height);
		this.handler.resize();
	};
	ZRender$1.prototype.clearAnimation = function() {
		if (this._disposed) return;
		this.animation.clear();
	};
	ZRender$1.prototype.getWidth = function() {
		if (this._disposed) return;
		return this.painter.getWidth();
	};
	ZRender$1.prototype.getHeight = function() {
		if (this._disposed) return;
		return this.painter.getHeight();
	};
	ZRender$1.prototype.setCursorStyle = function(cursorStyle) {
		if (this._disposed) return;
		this.handler.setCursorStyle(cursorStyle);
	};
	ZRender$1.prototype.findHover = function(x, y) {
		if (this._disposed) return;
		return this.handler.findHover(x, y);
	};
	ZRender$1.prototype.on = function(eventName, eventHandler, context) {
		if (!this._disposed) this.handler.on(eventName, eventHandler, context);
		return this;
	};
	ZRender$1.prototype.off = function(eventName, eventHandler) {
		if (this._disposed) return;
		this.handler.off(eventName, eventHandler);
	};
	ZRender$1.prototype.trigger = function(eventName, event) {
		if (this._disposed) return;
		this.handler.trigger(eventName, event);
	};
	ZRender$1.prototype.clear = function() {
		if (this._disposed) return;
		var roots$1 = this.storage.getRoots();
		for (var i = 0; i < roots$1.length; i++) if (roots$1[i] instanceof Group_default) roots$1[i].removeSelfFromZr(this);
		this.storage.delAllRoots();
		this.painter.clear();
	};
	ZRender$1.prototype.dispose = function() {
		if (this._disposed) return;
		this.animation.stop();
		this.clear();
		this.storage.dispose();
		this.painter.dispose();
		this.handler.dispose();
		this.animation = this.storage = this.painter = this.handler = null;
		this._disposed = true;
		delInstance(this.id);
	};
	return ZRender$1;
}();
function init$1(dom, opts) {
	var zr = new ZRender(guid(), dom, opts);
	instances$1[zr.id] = zr;
	return zr;
}
function registerPainter(name, Ctor) {
	painterCtors[name] = Ctor;
}
var ssrDataGetter;
function registerSSRDataGetter(getter) {
	ssrDataGetter = getter;
}
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
var platform = "";
if (typeof navigator !== "undefined") platform = navigator.platform || "";
var decalColor = "rgba(0, 0, 0, 0.2)";
var globalDefault_default = {
	darkMode: "auto",
	colorBy: "series",
	color: [
		"#5470c6",
		"#91cc75",
		"#fac858",
		"#ee6666",
		"#73c0de",
		"#3ba272",
		"#fc8452",
		"#9a60b4",
		"#ea7ccc"
	],
	gradientColor: [
		"#f6efa6",
		"#d88273",
		"#bf444c"
	],
	aria: { decal: { decals: [
		{
			color: decalColor,
			dashArrayX: [1, 0],
			dashArrayY: [2, 5],
			symbolSize: 1,
			rotation: Math.PI / 6
		},
		{
			color: decalColor,
			symbol: "circle",
			dashArrayX: [[8, 8], [
				0,
				8,
				8,
				0
			]],
			dashArrayY: [6, 0],
			symbolSize: .8
		},
		{
			color: decalColor,
			dashArrayX: [1, 0],
			dashArrayY: [4, 3],
			rotation: -Math.PI / 4
		},
		{
			color: decalColor,
			dashArrayX: [[6, 6], [
				0,
				6,
				6,
				0
			]],
			dashArrayY: [6, 0]
		},
		{
			color: decalColor,
			dashArrayX: [[1, 0], [1, 6]],
			dashArrayY: [
				1,
				0,
				6,
				0
			],
			rotation: Math.PI / 4
		},
		{
			color: decalColor,
			symbol: "triangle",
			dashArrayX: [[9, 9], [
				0,
				9,
				9,
				0
			]],
			dashArrayY: [7, 2],
			symbolSize: .75
		}
	] } },
	textStyle: {
		fontFamily: platform.match(/^Win/) ? "Microsoft YaHei" : "sans-serif",
		fontSize: 12,
		fontStyle: "normal",
		fontWeight: "normal"
	},
	blendMode: null,
	stateAnimation: {
		duration: 300,
		easing: "cubicOut"
	},
	animation: "auto",
	animationDuration: 1e3,
	animationDurationUpdate: 500,
	animationEasing: "cubicInOut",
	animationEasingUpdate: "cubicInOut",
	animationThreshold: 2e3,
	progressiveThreshold: 3e3,
	progressive: 400,
	hoverLayerThreshold: 3e3,
	useUTC: false
};
var internalOptionCreatorMap = createHashMap();
function concatInternalOptions(ecModel, mainType, newCmptOptionList) {
	var internalOptionCreator = internalOptionCreatorMap.get(mainType);
	if (!internalOptionCreator) return newCmptOptionList;
	var internalOptions = internalOptionCreator(ecModel);
	if (!internalOptions) return newCmptOptionList;
	if (0) var i;
	return newCmptOptionList.concat(internalOptions);
}
var reCreateSeriesIndices;
var assertSeriesInitialized;
var initBase;
var OPTION_INNER_KEY = "\0_ec_inner";
var OPTION_INNER_VALUE = 1;
var GlobalModel = function(_super) {
	__extends(GlobalModel$1, _super);
	function GlobalModel$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	GlobalModel$1.prototype.init = function(option, parentModel, ecModel, theme$1, locale, optionManager) {
		theme$1 = theme$1 || {};
		this.option = null;
		this._theme = new Model_default(theme$1);
		this._locale = new Model_default(locale);
		this._optionManager = optionManager;
	};
	GlobalModel$1.prototype.setOption = function(option, opts, optionPreprocessorFuncs$1) {
		var innerOpt = normalizeSetOptionInput(opts);
		this._optionManager.setOption(option, optionPreprocessorFuncs$1, innerOpt);
		this._resetOption(null, innerOpt);
	};
	/**
	
	* @param type null/undefined: reset all.
	
	*        'recreate': force recreate all.
	
	*        'timeline': only reset timeline option
	
	*        'media': only reset media query option
	
	* @return Whether option changed.
	
	*/
	GlobalModel$1.prototype.resetOption = function(type, opt) {
		return this._resetOption(type, normalizeSetOptionInput(opt));
	};
	GlobalModel$1.prototype._resetOption = function(type, opt) {
		var optionChanged = false;
		var optionManager = this._optionManager;
		if (!type || type === "recreate") {
			var baseOption = optionManager.mountOption(type === "recreate");
			if (!this.option || type === "recreate") initBase(this, baseOption);
			else {
				this.restoreData();
				this._mergeOption(baseOption, opt);
			}
			optionChanged = true;
		}
		if (type === "timeline" || type === "media") this.restoreData();
		if (!type || type === "recreate" || type === "timeline") {
			var timelineOption = optionManager.getTimelineOption(this);
			if (timelineOption) {
				optionChanged = true;
				this._mergeOption(timelineOption, opt);
			}
		}
		if (!type || type === "recreate" || type === "media") {
			var mediaOptions = optionManager.getMediaOption(this);
			if (mediaOptions.length) each$4(mediaOptions, function(mediaOption) {
				optionChanged = true;
				this._mergeOption(mediaOption, opt);
			}, this);
		}
		return optionChanged;
	};
	GlobalModel$1.prototype.mergeOption = function(option) {
		this._mergeOption(option, null);
	};
	GlobalModel$1.prototype._mergeOption = function(newOption, opt) {
		var option = this.option;
		var componentsMap = this._componentsMap;
		var componentsCount = this._componentsCount;
		var newCmptTypes = [];
		var newCmptTypeMap = createHashMap();
		var replaceMergeMainTypeMap = opt && opt.replaceMergeMainTypeMap;
		resetSourceDefaulter(this);
		each$4(newOption, function(componentOption, mainType) {
			if (componentOption == null) return;
			if (!Component_default$1.hasClass(mainType)) option[mainType] = option[mainType] == null ? clone$2(componentOption) : merge(option[mainType], componentOption, true);
			else if (mainType) {
				newCmptTypes.push(mainType);
				newCmptTypeMap.set(mainType, true);
			}
		});
		if (replaceMergeMainTypeMap) replaceMergeMainTypeMap.each(function(val, mainTypeInReplaceMerge) {
			if (Component_default$1.hasClass(mainTypeInReplaceMerge) && !newCmptTypeMap.get(mainTypeInReplaceMerge)) {
				newCmptTypes.push(mainTypeInReplaceMerge);
				newCmptTypeMap.set(mainTypeInReplaceMerge, true);
			}
		});
		Component_default$1.topologicalTravel(newCmptTypes, Component_default$1.getAllClassMainTypes(), visitComponent, this);
		function visitComponent(mainType) {
			var newCmptOptionList = concatInternalOptions(this, mainType, normalizeToArray(newOption[mainType]));
			var oldCmptList = componentsMap.get(mainType);
			var mergeMode = !oldCmptList ? "replaceAll" : replaceMergeMainTypeMap && replaceMergeMainTypeMap.get(mainType) ? "replaceMerge" : "normalMerge";
			var mappingResult = mappingToExists(oldCmptList, newCmptOptionList, mergeMode);
			setComponentTypeToKeyInfo(mappingResult, mainType, Component_default$1);
			option[mainType] = null;
			componentsMap.set(mainType, null);
			componentsCount.set(mainType, 0);
			var optionsByMainType = [];
			var cmptsByMainType = [];
			var cmptsCountByMainType = 0;
			var tooltipExists;
			var tooltipWarningLogged;
			each$4(mappingResult, function(resultItem, index) {
				var componentModel = resultItem.existing;
				var newCmptOption = resultItem.newOption;
				if (!newCmptOption) {
					if (componentModel) {
						componentModel.mergeOption({}, this);
						componentModel.optionUpdated({}, false);
					}
				} else {
					var isSeriesType = mainType === "series";
					var ComponentModelClass = Component_default$1.getClass(mainType, resultItem.keyInfo.subType, !isSeriesType);
					if (!ComponentModelClass) {
						if (0) var subType, seriesImportName;
						return;
					}
					if (mainType === "tooltip") {
						if (tooltipExists) return;
						tooltipExists = true;
					}
					if (componentModel && componentModel.constructor === ComponentModelClass) {
						componentModel.name = resultItem.keyInfo.name;
						componentModel.mergeOption(newCmptOption, this);
						componentModel.optionUpdated(newCmptOption, false);
					} else {
						var extraOpt = extend({ componentIndex: index }, resultItem.keyInfo);
						componentModel = new ComponentModelClass(newCmptOption, this, this, extraOpt);
						extend(componentModel, extraOpt);
						if (resultItem.brandNew) componentModel.__requireNewView = true;
						componentModel.init(newCmptOption, this, this);
						componentModel.optionUpdated(null, true);
					}
				}
				if (componentModel) {
					optionsByMainType.push(componentModel.option);
					cmptsByMainType.push(componentModel);
					cmptsCountByMainType++;
				} else {
					optionsByMainType.push(void 0);
					cmptsByMainType.push(void 0);
				}
			}, this);
			option[mainType] = optionsByMainType;
			componentsMap.set(mainType, cmptsByMainType);
			componentsCount.set(mainType, cmptsCountByMainType);
			if (mainType === "series") reCreateSeriesIndices(this);
		}
		if (!this._seriesIndices) reCreateSeriesIndices(this);
	};
	/**
	
	* Get option for output (cloned option and inner info removed)
	
	*/
	GlobalModel$1.prototype.getOption = function() {
		var option = clone$2(this.option);
		each$4(option, function(optInMainType, mainType) {
			if (Component_default$1.hasClass(mainType)) {
				var opts = normalizeToArray(optInMainType);
				var realLen = opts.length;
				var metNonInner = false;
				for (var i = realLen - 1; i >= 0; i--) if (opts[i] && !isComponentIdInternal(opts[i])) metNonInner = true;
				else {
					opts[i] = null;
					!metNonInner && realLen--;
				}
				opts.length = realLen;
				option[mainType] = opts;
			}
		});
		delete option[OPTION_INNER_KEY];
		return option;
	};
	GlobalModel$1.prototype.getTheme = function() {
		return this._theme;
	};
	GlobalModel$1.prototype.getLocaleModel = function() {
		return this._locale;
	};
	GlobalModel$1.prototype.setUpdatePayload = function(payload) {
		this._payload = payload;
	};
	GlobalModel$1.prototype.getUpdatePayload = function() {
		return this._payload;
	};
	/**
	
	* @param idx If not specified, return the first one.
	
	*/
	GlobalModel$1.prototype.getComponent = function(mainType, idx) {
		var list = this._componentsMap.get(mainType);
		if (list) {
			var cmpt = list[idx || 0];
			if (cmpt) return cmpt;
			else if (idx == null) {
				for (var i = 0; i < list.length; i++) if (list[i]) return list[i];
			}
		}
	};
	/**
	
	* @return Never be null/undefined.
	
	*/
	GlobalModel$1.prototype.queryComponents = function(condition) {
		var mainType = condition.mainType;
		if (!mainType) return [];
		var index = condition.index;
		var id = condition.id;
		var name = condition.name;
		var cmpts = this._componentsMap.get(mainType);
		if (!cmpts || !cmpts.length) return [];
		var result;
		if (index != null) {
			result = [];
			each$4(normalizeToArray(index), function(idx) {
				cmpts[idx] && result.push(cmpts[idx]);
			});
		} else if (id != null) result = queryByIdOrName("id", id, cmpts);
		else if (name != null) result = queryByIdOrName("name", name, cmpts);
		else result = filter(cmpts, function(cmpt) {
			return !!cmpt;
		});
		return filterBySubType(result, condition);
	};
	/**
	
	* The interface is different from queryComponents,
	
	* which is convenient for inner usage.
	
	*
	
	* @usage
	
	* let result = findComponents(
	
	*     {mainType: 'dataZoom', query: {dataZoomId: 'abc'}}
	
	* );
	
	* let result = findComponents(
	
	*     {mainType: 'series', subType: 'pie', query: {seriesName: 'uio'}}
	
	* );
	
	* let result = findComponents(
	
	*     {mainType: 'series',
	
	*     filter: function (model, index) {...}}
	
	* );
	
	* // result like [component0, componnet1, ...]
	
	*/
	GlobalModel$1.prototype.findComponents = function(condition) {
		var query = condition.query;
		var mainType = condition.mainType;
		var queryCond = getQueryCond(query);
		var result = queryCond ? this.queryComponents(queryCond) : filter(this._componentsMap.get(mainType), function(cmpt) {
			return !!cmpt;
		});
		return doFilter(filterBySubType(result, condition));
		function getQueryCond(q) {
			var indexAttr = mainType + "Index";
			var idAttr = mainType + "Id";
			var nameAttr = mainType + "Name";
			return q && (q[indexAttr] != null || q[idAttr] != null || q[nameAttr] != null) ? {
				mainType,
				index: q[indexAttr],
				id: q[idAttr],
				name: q[nameAttr]
			} : null;
		}
		function doFilter(res) {
			return condition.filter ? filter(res, condition.filter) : res;
		}
	};
	GlobalModel$1.prototype.eachComponent = function(mainType, cb, context) {
		var componentsMap = this._componentsMap;
		if (isFunction(mainType)) {
			var ctxForAll_1 = cb;
			var cbForAll_1 = mainType;
			componentsMap.each(function(cmpts$1, componentType) {
				for (var i$1 = 0; cmpts$1 && i$1 < cmpts$1.length; i$1++) {
					var cmpt$1 = cmpts$1[i$1];
					cmpt$1 && cbForAll_1.call(ctxForAll_1, componentType, cmpt$1, cmpt$1.componentIndex);
				}
			});
		} else {
			var cmpts = isString(mainType) ? componentsMap.get(mainType) : isObject$2(mainType) ? this.findComponents(mainType) : null;
			for (var i = 0; cmpts && i < cmpts.length; i++) {
				var cmpt = cmpts[i];
				cmpt && cb.call(context, cmpt, cmpt.componentIndex);
			}
		}
	};
	/**
	
	* Get series list before filtered by name.
	
	*/
	GlobalModel$1.prototype.getSeriesByName = function(name) {
		var nameStr = convertOptionIdName(name, null);
		return filter(this._componentsMap.get("series"), function(oneSeries) {
			return !!oneSeries && nameStr != null && oneSeries.name === nameStr;
		});
	};
	/**
	
	* Get series list before filtered by index.
	
	*/
	GlobalModel$1.prototype.getSeriesByIndex = function(seriesIndex) {
		return this._componentsMap.get("series")[seriesIndex];
	};
	/**
	
	* Get series list before filtered by type.
	
	* FIXME: rename to getRawSeriesByType?
	
	*/
	GlobalModel$1.prototype.getSeriesByType = function(subType) {
		return filter(this._componentsMap.get("series"), function(oneSeries) {
			return !!oneSeries && oneSeries.subType === subType;
		});
	};
	/**
	
	* Get all series before filtered.
	
	*/
	GlobalModel$1.prototype.getSeries = function() {
		return filter(this._componentsMap.get("series"), function(oneSeries) {
			return !!oneSeries;
		});
	};
	/**
	
	* Count series before filtered.
	
	*/
	GlobalModel$1.prototype.getSeriesCount = function() {
		return this._componentsCount.get("series");
	};
	/**
	
	* After filtering, series may be different
	
	* from raw series.
	
	*/
	GlobalModel$1.prototype.eachSeries = function(cb, context) {
		assertSeriesInitialized(this);
		each$4(this._seriesIndices, function(rawSeriesIndex) {
			var series = this._componentsMap.get("series")[rawSeriesIndex];
			cb.call(context, series, rawSeriesIndex);
		}, this);
	};
	/**
	
	* Iterate raw series before filtered.
	
	*
	
	* @param {Function} cb
	
	* @param {*} context
	
	*/
	GlobalModel$1.prototype.eachRawSeries = function(cb, context) {
		each$4(this._componentsMap.get("series"), function(series) {
			series && cb.call(context, series, series.componentIndex);
		});
	};
	/**
	
	* After filtering, series may be different.
	
	* from raw series.
	
	*/
	GlobalModel$1.prototype.eachSeriesByType = function(subType, cb, context) {
		assertSeriesInitialized(this);
		each$4(this._seriesIndices, function(rawSeriesIndex) {
			var series = this._componentsMap.get("series")[rawSeriesIndex];
			if (series.subType === subType) cb.call(context, series, rawSeriesIndex);
		}, this);
	};
	/**
	
	* Iterate raw series before filtered of given type.
	
	*/
	GlobalModel$1.prototype.eachRawSeriesByType = function(subType, cb, context) {
		return each$4(this.getSeriesByType(subType), cb, context);
	};
	GlobalModel$1.prototype.isSeriesFiltered = function(seriesModel) {
		assertSeriesInitialized(this);
		return this._seriesIndicesMap.get(seriesModel.componentIndex) == null;
	};
	GlobalModel$1.prototype.getCurrentSeriesIndices = function() {
		return (this._seriesIndices || []).slice();
	};
	GlobalModel$1.prototype.filterSeries = function(cb, context) {
		assertSeriesInitialized(this);
		var newSeriesIndices = [];
		each$4(this._seriesIndices, function(seriesRawIdx) {
			var series = this._componentsMap.get("series")[seriesRawIdx];
			cb.call(context, series, seriesRawIdx) && newSeriesIndices.push(seriesRawIdx);
		}, this);
		this._seriesIndices = newSeriesIndices;
		this._seriesIndicesMap = createHashMap(newSeriesIndices);
	};
	GlobalModel$1.prototype.restoreData = function(payload) {
		reCreateSeriesIndices(this);
		var componentsMap = this._componentsMap;
		var componentTypes = [];
		componentsMap.each(function(components, componentType) {
			if (Component_default$1.hasClass(componentType)) componentTypes.push(componentType);
		});
		Component_default$1.topologicalTravel(componentTypes, Component_default$1.getAllClassMainTypes(), function(componentType) {
			each$4(componentsMap.get(componentType), function(component) {
				if (component && (componentType !== "series" || !isNotTargetSeries(component, payload))) component.restoreData();
			});
		});
	};
	GlobalModel$1.internalField = function() {
		reCreateSeriesIndices = function(ecModel) {
			var seriesIndices = ecModel._seriesIndices = [];
			each$4(ecModel._componentsMap.get("series"), function(series) {
				series && seriesIndices.push(series.componentIndex);
			});
			ecModel._seriesIndicesMap = createHashMap(seriesIndices);
		};
		assertSeriesInitialized = function(ecModel) {};
		initBase = function(ecModel, baseOption) {
			ecModel.option = {};
			ecModel.option[OPTION_INNER_KEY] = OPTION_INNER_VALUE;
			ecModel._componentsMap = createHashMap({ series: [] });
			ecModel._componentsCount = createHashMap();
			var airaOption = baseOption.aria;
			if (isObject$2(airaOption) && airaOption.enabled == null) airaOption.enabled = true;
			mergeTheme(baseOption, ecModel._theme.option);
			merge(baseOption, globalDefault_default, false);
			ecModel._mergeOption(baseOption, null);
		};
	}();
	return GlobalModel$1;
}(Model_default);
function isNotTargetSeries(seriesModel, payload) {
	if (payload) {
		var index = payload.seriesIndex;
		var id = payload.seriesId;
		var name_1 = payload.seriesName;
		return index != null && seriesModel.componentIndex !== index || id != null && seriesModel.id !== id || name_1 != null && seriesModel.name !== name_1;
	}
}
function mergeTheme(option, theme$1) {
	var notMergeColorLayer = option.color && !option.colorLayer;
	each$4(theme$1, function(themeItem, name) {
		if (name === "colorLayer" && notMergeColorLayer) return;
		if (!Component_default$1.hasClass(name)) {
			if (typeof themeItem === "object") option[name] = !option[name] ? clone$2(themeItem) : merge(option[name], themeItem, false);
			else if (option[name] == null) option[name] = themeItem;
		}
	});
}
function queryByIdOrName(attr, idOrName, cmpts) {
	if (isArray(idOrName)) {
		var keyMap_1 = createHashMap();
		each$4(idOrName, function(idOrNameItem) {
			if (idOrNameItem != null) {
				var idName = convertOptionIdName(idOrNameItem, null);
				idName != null && keyMap_1.set(idOrNameItem, true);
			}
		});
		return filter(cmpts, function(cmpt) {
			return cmpt && keyMap_1.get(cmpt[attr]);
		});
	} else {
		var idName_1 = convertOptionIdName(idOrName, null);
		return filter(cmpts, function(cmpt) {
			return cmpt && idName_1 != null && cmpt[attr] === idName_1;
		});
	}
}
function filterBySubType(components, condition) {
	return condition.hasOwnProperty("subType") ? filter(components, function(cmpt) {
		return cmpt && cmpt.subType === condition.subType;
	}) : components;
}
function normalizeSetOptionInput(opts) {
	var replaceMergeMainTypeMap = createHashMap();
	opts && each$4(normalizeToArray(opts.replaceMerge), function(mainType) {
		replaceMergeMainTypeMap.set(mainType, true);
	});
	return { replaceMergeMainTypeMap };
}
mixin(GlobalModel, PaletteMixin);
var Global_default = GlobalModel;
var availableMethods = [
	"getDom",
	"getZr",
	"getWidth",
	"getHeight",
	"getDevicePixelRatio",
	"dispatchAction",
	"isSSR",
	"isDisposed",
	"on",
	"off",
	"getDataURL",
	"getConnectedDataURL",
	"getOption",
	"getId",
	"updateLabelLayout"
];
var ExtensionAPI = function() {
	function ExtensionAPI$1(ecInstance) {
		each$4(availableMethods, function(methodName) {
			this[methodName] = bind$1(ecInstance[methodName], ecInstance);
		}, this);
	}
	return ExtensionAPI$1;
}();
var ExtensionAPI_default = ExtensionAPI;
var QUERY_REG = /^(min|max)?(.+)$/;
/**

* TERM EXPLANATIONS:

* See `ECOption` and `ECUnitOption` in `src/util/types.ts`.

*/
var OptionManager = function() {
	function OptionManager$1(api) {
		this._timelineOptions = [];
		this._mediaList = [];
		/**
		
		* -1, means default.
		
		* empty means no media.
		
		*/
		this._currentMediaIndices = [];
		this._api = api;
	}
	OptionManager$1.prototype.setOption = function(rawOption, optionPreprocessorFuncs$1, opt) {
		if (rawOption) {
			each$4(normalizeToArray(rawOption.series), function(series) {
				series && series.data && isTypedArray(series.data) && setAsPrimitive(series.data);
			});
			each$4(normalizeToArray(rawOption.dataset), function(dataset) {
				dataset && dataset.source && isTypedArray(dataset.source) && setAsPrimitive(dataset.source);
			});
		}
		rawOption = clone$2(rawOption);
		var optionBackup = this._optionBackup;
		var newParsedOption = parseRawOption(rawOption, optionPreprocessorFuncs$1, !optionBackup);
		this._newBaseOption = newParsedOption.baseOption;
		if (optionBackup) {
			if (newParsedOption.timelineOptions.length) optionBackup.timelineOptions = newParsedOption.timelineOptions;
			if (newParsedOption.mediaList.length) optionBackup.mediaList = newParsedOption.mediaList;
			if (newParsedOption.mediaDefault) optionBackup.mediaDefault = newParsedOption.mediaDefault;
		} else this._optionBackup = newParsedOption;
	};
	OptionManager$1.prototype.mountOption = function(isRecreate) {
		var optionBackup = this._optionBackup;
		this._timelineOptions = optionBackup.timelineOptions;
		this._mediaList = optionBackup.mediaList;
		this._mediaDefault = optionBackup.mediaDefault;
		this._currentMediaIndices = [];
		return clone$2(isRecreate ? optionBackup.baseOption : this._newBaseOption);
	};
	OptionManager$1.prototype.getTimelineOption = function(ecModel) {
		var option;
		var timelineOptions = this._timelineOptions;
		if (timelineOptions.length) {
			var timelineModel = ecModel.getComponent("timeline");
			if (timelineModel) option = clone$2(
				// FIXME:TS as TimelineModel or quivlant interface
				timelineOptions[timelineModel.getCurrentIndex()]
);
		}
		return option;
	};
	OptionManager$1.prototype.getMediaOption = function(ecModel) {
		var ecWidth = this._api.getWidth();
		var ecHeight = this._api.getHeight();
		var mediaList = this._mediaList;
		var mediaDefault = this._mediaDefault;
		var indices = [];
		var result = [];
		if (!mediaList.length && !mediaDefault) return result;
		for (var i = 0, len$1 = mediaList.length; i < len$1; i++) if (applyMediaQuery(mediaList[i].query, ecWidth, ecHeight)) indices.push(i);
		if (!indices.length && mediaDefault) indices = [-1];
		if (indices.length && !indicesEquals(indices, this._currentMediaIndices)) result = map$1(indices, function(index) {
			return clone$2(index === -1 ? mediaDefault.option : mediaList[index].option);
		});
		this._currentMediaIndices = indices;
		return result;
	};
	return OptionManager$1;
}();
/**

* [RAW_OPTION_PATTERNS]

* (Note: "series: []" represents all other props in `ECUnitOption`)

*

* (1) No prop "baseOption" declared:

* Root option is used as "baseOption" (except prop "options" and "media").

* ```js

* option = {

*     series: [],

*     timeline: {},

*     options: [],

* };

* option = {

*     series: [],

*     media: {},

* };

* option = {

*     series: [],

*     timeline: {},

*     options: [],

*     media: {},

* }

* ```

*

* (2) Prop "baseOption" declared:

* If "baseOption" declared, `ECUnitOption` props can only be declared

* inside "baseOption" except prop "timeline" (compat ec2).

* ```js

* option = {

*     baseOption: {

*         timeline: {},

*         series: [],

*     },

*     options: []

* };

* option = {

*     baseOption: {

*         series: [],

*     },

*     media: []

* };

* option = {

*     baseOption: {

*         timeline: {},

*         series: [],

*     },

*     options: []

*     media: []

* };

* option = {

*     // ec3 compat ec2: allow (only) `timeline` declared

*     // outside baseOption. Keep this setting for compat.

*     timeline: {},

*     baseOption: {

*         series: [],

*     },

*     options: [],

*     media: []

* };

* ```

*/
function parseRawOption(rawOption, optionPreprocessorFuncs$1, isNew) {
	var mediaList = [];
	var mediaDefault;
	var baseOption;
	var declaredBaseOption = rawOption.baseOption;
	var timelineOnRoot = rawOption.timeline;
	var timelineOptionsOnRoot = rawOption.options;
	var mediaOnRoot = rawOption.media;
	var hasMedia = !!rawOption.media;
	var hasTimeline = !!(timelineOptionsOnRoot || timelineOnRoot || declaredBaseOption && declaredBaseOption.timeline);
	if (declaredBaseOption) {
		baseOption = declaredBaseOption;
		if (!baseOption.timeline) baseOption.timeline = timelineOnRoot;
	} else {
		if (hasTimeline || hasMedia) rawOption.options = rawOption.media = null;
		baseOption = rawOption;
	}
	if (hasMedia) {
		if (isArray(mediaOnRoot)) each$4(mediaOnRoot, function(singleMedia) {
			if (singleMedia && singleMedia.option) {
				if (singleMedia.query) mediaList.push(singleMedia);
				else if (!mediaDefault) mediaDefault = singleMedia;
			}
		});
	}
	doPreprocess(baseOption);
	each$4(timelineOptionsOnRoot, function(option) {
		return doPreprocess(option);
	});
	each$4(mediaList, function(media) {
		return doPreprocess(media.option);
	});
	function doPreprocess(option) {
		each$4(optionPreprocessorFuncs$1, function(preProcess) {
			preProcess(option, isNew);
		});
	}
	return {
		baseOption,
		timelineOptions: timelineOptionsOnRoot || [],
		mediaDefault,
		mediaList
	};
}
/**

* @see <http://www.w3.org/TR/css3-mediaqueries/#media1>

* Support: width, height, aspectRatio

* Can use max or min as prefix.

*/
function applyMediaQuery(query, ecWidth, ecHeight) {
	var realMap = {
		width: ecWidth,
		height: ecHeight,
		aspectratio: ecWidth / ecHeight
	};
	var applicable = true;
	each$4(query, function(value, attr) {
		var matched = attr.match(QUERY_REG);
		if (!matched || !matched[1] || !matched[2]) return;
		var operator = matched[1];
		var realAttr = matched[2].toLowerCase();
		if (!compare(realMap[realAttr], value, operator)) applicable = false;
	});
	return applicable;
}
function compare(real, expect, operator) {
	if (operator === "min") return real >= expect;
	else if (operator === "max") return real <= expect;
	else return real === expect;
}
function indicesEquals(indices1, indices2) {
	return indices1.join(",") === indices2.join(",");
}
var OptionManager_default = OptionManager;
var each$2 = each$4;
var isObject = isObject$2;
var POSSIBLE_STYLES = [
	"areaStyle",
	"lineStyle",
	"nodeStyle",
	"linkStyle",
	"chordStyle",
	"label",
	"labelLine"
];
function compatEC2ItemStyle(opt) {
	var itemStyleOpt = opt && opt.itemStyle;
	if (!itemStyleOpt) return;
	for (var i = 0, len$1 = POSSIBLE_STYLES.length; i < len$1; i++) {
		var styleName = POSSIBLE_STYLES[i];
		var normalItemStyleOpt = itemStyleOpt.normal;
		var emphasisItemStyleOpt = itemStyleOpt.emphasis;
		if (normalItemStyleOpt && normalItemStyleOpt[styleName]) {
			opt[styleName] = opt[styleName] || {};
			if (!opt[styleName].normal) opt[styleName].normal = normalItemStyleOpt[styleName];
			else merge(opt[styleName].normal, normalItemStyleOpt[styleName]);
			normalItemStyleOpt[styleName] = null;
		}
		if (emphasisItemStyleOpt && emphasisItemStyleOpt[styleName]) {
			opt[styleName] = opt[styleName] || {};
			if (!opt[styleName].emphasis) opt[styleName].emphasis = emphasisItemStyleOpt[styleName];
			else merge(opt[styleName].emphasis, emphasisItemStyleOpt[styleName]);
			emphasisItemStyleOpt[styleName] = null;
		}
	}
}
function convertNormalEmphasis(opt, optType, useExtend) {
	if (opt && opt[optType] && (opt[optType].normal || opt[optType].emphasis)) {
		var normalOpt = opt[optType].normal;
		var emphasisOpt = opt[optType].emphasis;
		if (normalOpt) if (useExtend) {
			opt[optType].normal = opt[optType].emphasis = null;
			defaults(opt[optType], normalOpt);
		} else opt[optType] = normalOpt;
		if (emphasisOpt) {
			opt.emphasis = opt.emphasis || {};
			opt.emphasis[optType] = emphasisOpt;
			if (emphasisOpt.focus) opt.emphasis.focus = emphasisOpt.focus;
			if (emphasisOpt.blurScope) opt.emphasis.blurScope = emphasisOpt.blurScope;
		}
	}
}
function removeEC3NormalStatus(opt) {
	convertNormalEmphasis(opt, "itemStyle");
	convertNormalEmphasis(opt, "lineStyle");
	convertNormalEmphasis(opt, "areaStyle");
	convertNormalEmphasis(opt, "label");
	convertNormalEmphasis(opt, "labelLine");
	convertNormalEmphasis(opt, "upperLabel");
	convertNormalEmphasis(opt, "edgeLabel");
}
function compatTextStyle(opt, propName) {
	var labelOptSingle = isObject(opt) && opt[propName];
	var textStyle = isObject(labelOptSingle) && labelOptSingle.textStyle;
	if (textStyle) for (var i = 0, len$1 = TEXT_STYLE_OPTIONS.length; i < len$1; i++) {
		var textPropName = TEXT_STYLE_OPTIONS[i];
		if (textStyle.hasOwnProperty(textPropName)) labelOptSingle[textPropName] = textStyle[textPropName];
	}
}
function compatEC3CommonStyles(opt) {
	if (opt) {
		removeEC3NormalStatus(opt);
		compatTextStyle(opt, "label");
		opt.emphasis && compatTextStyle(opt.emphasis, "label");
	}
}
function processSeries(seriesOpt) {
	if (!isObject(seriesOpt)) return;
	compatEC2ItemStyle(seriesOpt);
	removeEC3NormalStatus(seriesOpt);
	compatTextStyle(seriesOpt, "label");
	compatTextStyle(seriesOpt, "upperLabel");
	compatTextStyle(seriesOpt, "edgeLabel");
	if (seriesOpt.emphasis) {
		compatTextStyle(seriesOpt.emphasis, "label");
		compatTextStyle(seriesOpt.emphasis, "upperLabel");
		compatTextStyle(seriesOpt.emphasis, "edgeLabel");
	}
	var markPoint = seriesOpt.markPoint;
	if (markPoint) {
		compatEC2ItemStyle(markPoint);
		compatEC3CommonStyles(markPoint);
	}
	var markLine = seriesOpt.markLine;
	if (markLine) {
		compatEC2ItemStyle(markLine);
		compatEC3CommonStyles(markLine);
	}
	var markArea = seriesOpt.markArea;
	if (markArea) compatEC3CommonStyles(markArea);
	var data = seriesOpt.data;
	if (seriesOpt.type === "graph") {
		data = data || seriesOpt.nodes;
		var edgeData = seriesOpt.links || seriesOpt.edges;
		if (edgeData && !isTypedArray(edgeData)) for (var i = 0; i < edgeData.length; i++) compatEC3CommonStyles(edgeData[i]);
		each$4(seriesOpt.categories, function(opt) {
			removeEC3NormalStatus(opt);
		});
	}
	if (data && !isTypedArray(data)) for (var i = 0; i < data.length; i++) compatEC3CommonStyles(data[i]);
	markPoint = seriesOpt.markPoint;
	if (markPoint && markPoint.data) {
		var mpData = markPoint.data;
		for (var i = 0; i < mpData.length; i++) compatEC3CommonStyles(mpData[i]);
	}
	markLine = seriesOpt.markLine;
	if (markLine && markLine.data) {
		var mlData = markLine.data;
		for (var i = 0; i < mlData.length; i++) if (isArray(mlData[i])) {
			compatEC3CommonStyles(mlData[i][0]);
			compatEC3CommonStyles(mlData[i][1]);
		} else compatEC3CommonStyles(mlData[i]);
	}
	if (seriesOpt.type === "gauge") {
		compatTextStyle(seriesOpt, "axisLabel");
		compatTextStyle(seriesOpt, "title");
		compatTextStyle(seriesOpt, "detail");
	} else if (seriesOpt.type === "treemap") {
		convertNormalEmphasis(seriesOpt.breadcrumb, "itemStyle");
		each$4(seriesOpt.levels, function(opt) {
			removeEC3NormalStatus(opt);
		});
	} else if (seriesOpt.type === "tree") removeEC3NormalStatus(seriesOpt.leaves);
}
function toArr(o) {
	return isArray(o) ? o : o ? [o] : [];
}
function toObj(o) {
	return (isArray(o) ? o[0] : o) || {};
}
function globalCompatStyle(option, isTheme) {
	each$2(toArr(option.series), function(seriesOpt) {
		isObject(seriesOpt) && processSeries(seriesOpt);
	});
	var axes = [
		"xAxis",
		"yAxis",
		"radiusAxis",
		"angleAxis",
		"singleAxis",
		"parallelAxis",
		"radar"
	];
	isTheme && axes.push("valueAxis", "categoryAxis", "logAxis", "timeAxis");
	each$2(axes, function(axisName) {
		each$2(toArr(option[axisName]), function(axisOpt) {
			if (axisOpt) {
				compatTextStyle(axisOpt, "axisLabel");
				compatTextStyle(axisOpt.axisPointer, "label");
			}
		});
	});
	each$2(toArr(option.parallel), function(parallelOpt) {
		var parallelAxisDefault = parallelOpt && parallelOpt.parallelAxisDefault;
		compatTextStyle(parallelAxisDefault, "axisLabel");
		compatTextStyle(parallelAxisDefault && parallelAxisDefault.axisPointer, "label");
	});
	each$2(toArr(option.calendar), function(calendarOpt) {
		convertNormalEmphasis(calendarOpt, "itemStyle");
		compatTextStyle(calendarOpt, "dayLabel");
		compatTextStyle(calendarOpt, "monthLabel");
		compatTextStyle(calendarOpt, "yearLabel");
	});
	each$2(toArr(option.radar), function(radarOpt) {
		compatTextStyle(radarOpt, "name");
		if (radarOpt.name && radarOpt.axisName == null) {
			radarOpt.axisName = radarOpt.name;
			delete radarOpt.name;
		}
		if (radarOpt.nameGap != null && radarOpt.axisNameGap == null) {
			radarOpt.axisNameGap = radarOpt.nameGap;
			delete radarOpt.nameGap;
		}
	});
	each$2(toArr(option.geo), function(geoOpt) {
		if (isObject(geoOpt)) {
			compatEC3CommonStyles(geoOpt);
			each$2(toArr(geoOpt.regions), function(regionObj) {
				compatEC3CommonStyles(regionObj);
			});
		}
	});
	each$2(toArr(option.timeline), function(timelineOpt) {
		compatEC3CommonStyles(timelineOpt);
		convertNormalEmphasis(timelineOpt, "label");
		convertNormalEmphasis(timelineOpt, "itemStyle");
		convertNormalEmphasis(timelineOpt, "controlStyle", true);
		var data = timelineOpt.data;
		isArray(data) && each$4(data, function(item) {
			if (isObject$2(item)) {
				convertNormalEmphasis(item, "label");
				convertNormalEmphasis(item, "itemStyle");
			}
		});
	});
	each$2(toArr(option.toolbox), function(toolboxOpt) {
		convertNormalEmphasis(toolboxOpt, "iconStyle");
		each$2(toolboxOpt.feature, function(featureOpt) {
			convertNormalEmphasis(featureOpt, "iconStyle");
		});
	});
	compatTextStyle(toObj(option.axisPointer), "label");
	compatTextStyle(toObj(option.tooltip).axisPointer, "label");
}
function get(opt, path) {
	var pathArr = path.split(",");
	var obj = opt;
	for (var i = 0; i < pathArr.length; i++) {
		obj = obj && obj[pathArr[i]];
		if (obj == null) break;
	}
	return obj;
}
function set(opt, path, val, overwrite) {
	var pathArr = path.split(",");
	var obj = opt;
	var key;
	var i = 0;
	for (; i < pathArr.length - 1; i++) {
		key = pathArr[i];
		if (obj[key] == null) obj[key] = {};
		obj = obj[key];
	}
	if (overwrite || obj[pathArr[i]] == null) obj[pathArr[i]] = val;
}
function compatLayoutProperties(option) {
	option && each$4(LAYOUT_PROPERTIES, function(prop) {
		if (prop[0] in option && !(prop[1] in option)) option[prop[1]] = option[prop[0]];
	});
}
var LAYOUT_PROPERTIES = [
	["x", "left"],
	["y", "top"],
	["x2", "right"],
	["y2", "bottom"]
];
var COMPATITABLE_COMPONENTS = [
	"grid",
	"geo",
	"parallel",
	"legend",
	"toolbox",
	"title",
	"visualMap",
	"dataZoom",
	"timeline"
];
var BAR_ITEM_STYLE_MAP = [
	["borderRadius", "barBorderRadius"],
	["borderColor", "barBorderColor"],
	["borderWidth", "barBorderWidth"]
];
function compatBarItemStyle(option) {
	var itemStyle = option && option.itemStyle;
	if (itemStyle) for (var i = 0; i < BAR_ITEM_STYLE_MAP.length; i++) {
		var oldName = BAR_ITEM_STYLE_MAP[i][1];
		var newName = BAR_ITEM_STYLE_MAP[i][0];
		if (itemStyle[oldName] != null) itemStyle[newName] = itemStyle[oldName];
	}
}
function compatPieLabel(option) {
	if (!option) return;
	if (option.alignTo === "edge" && option.margin != null && option.edgeDistance == null) option.edgeDistance = option.margin;
}
function compatSunburstState(option) {
	if (!option) return;
	if (option.downplay && !option.blur) option.blur = option.downplay;
}
function compatGraphFocus(option) {
	if (!option) return;
	if (option.focusNodeAdjacency != null) {
		option.emphasis = option.emphasis || {};
		if (option.emphasis.focus == null) option.emphasis.focus = "adjacency";
	}
}
function traverseTree(data, cb) {
	if (data) for (var i = 0; i < data.length; i++) {
		cb(data[i]);
		data[i] && traverseTree(data[i].children, cb);
	}
}
function globalBackwardCompat(option, isTheme) {
	globalCompatStyle(option, isTheme);
	option.series = normalizeToArray(option.series);
	each$4(option.series, function(seriesOpt) {
		if (!isObject$2(seriesOpt)) return;
		var seriesType$1 = seriesOpt.type;
		if (seriesType$1 === "line") {
			if (seriesOpt.clipOverflow != null) seriesOpt.clip = seriesOpt.clipOverflow;
		} else if (seriesType$1 === "pie" || seriesType$1 === "gauge") {
			if (seriesOpt.clockWise != null) seriesOpt.clockwise = seriesOpt.clockWise;
			compatPieLabel(seriesOpt.label);
			var data = seriesOpt.data;
			if (data && !isTypedArray(data)) for (var i = 0; i < data.length; i++) compatPieLabel(data[i]);
			if (seriesOpt.hoverOffset != null) {
				seriesOpt.emphasis = seriesOpt.emphasis || {};
				if (seriesOpt.emphasis.scaleSize = null) seriesOpt.emphasis.scaleSize = seriesOpt.hoverOffset;
			}
		} else if (seriesType$1 === "gauge") {
			var pointerColor = get(seriesOpt, "pointer.color");
			pointerColor != null && set(seriesOpt, "itemStyle.color", pointerColor);
		} else if (seriesType$1 === "bar") {
			compatBarItemStyle(seriesOpt);
			compatBarItemStyle(seriesOpt.backgroundStyle);
			compatBarItemStyle(seriesOpt.emphasis);
			var data = seriesOpt.data;
			if (data && !isTypedArray(data)) {
				for (var i = 0; i < data.length; i++) if (typeof data[i] === "object") {
					compatBarItemStyle(data[i]);
					compatBarItemStyle(data[i] && data[i].emphasis);
				}
			}
		} else if (seriesType$1 === "sunburst") {
			var highlightPolicy = seriesOpt.highlightPolicy;
			if (highlightPolicy) {
				seriesOpt.emphasis = seriesOpt.emphasis || {};
				if (!seriesOpt.emphasis.focus) seriesOpt.emphasis.focus = highlightPolicy;
			}
			compatSunburstState(seriesOpt);
			traverseTree(seriesOpt.data, compatSunburstState);
		} else if (seriesType$1 === "graph" || seriesType$1 === "sankey") compatGraphFocus(seriesOpt);
		else if (seriesType$1 === "map") {
			if (seriesOpt.mapType && !seriesOpt.map) seriesOpt.map = seriesOpt.mapType;
			if (seriesOpt.mapLocation) defaults(seriesOpt, seriesOpt.mapLocation);
		}
		if (seriesOpt.hoverAnimation != null) {
			seriesOpt.emphasis = seriesOpt.emphasis || {};
			if (seriesOpt.emphasis && seriesOpt.emphasis.scale == null) seriesOpt.emphasis.scale = seriesOpt.hoverAnimation;
		}
		compatLayoutProperties(seriesOpt);
	});
	if (option.dataRange) option.visualMap = option.dataRange;
	each$4(COMPATITABLE_COMPONENTS, function(componentName) {
		var options = option[componentName];
		if (options) {
			if (!isArray(options)) options = [options];
			each$4(options, function(option$1) {
				compatLayoutProperties(option$1);
			});
		}
	});
}
function dataStack(ecModel) {
	var stackInfoMap = createHashMap();
	ecModel.eachSeries(function(seriesModel) {
		var stack = seriesModel.get("stack");
		if (stack) {
			var stackInfoList = stackInfoMap.get(stack) || stackInfoMap.set(stack, []);
			var data = seriesModel.getData();
			var stackInfo = {
				stackResultDimension: data.getCalculationInfo("stackResultDimension"),
				stackedOverDimension: data.getCalculationInfo("stackedOverDimension"),
				stackedDimension: data.getCalculationInfo("stackedDimension"),
				stackedByDimension: data.getCalculationInfo("stackedByDimension"),
				isStackedByIndex: data.getCalculationInfo("isStackedByIndex"),
				data,
				seriesModel
			};
			if (!stackInfo.stackedDimension || !(stackInfo.isStackedByIndex || stackInfo.stackedByDimension)) return;
			stackInfoList.length && data.setCalculationInfo("stackedOnSeries", stackInfoList[stackInfoList.length - 1].seriesModel);
			stackInfoList.push(stackInfo);
		}
	});
	stackInfoMap.each(calculateStack);
}
function calculateStack(stackInfoList) {
	each$4(stackInfoList, function(targetStackInfo, idxInStack) {
		var resultVal = [];
		var resultNaN = [NaN, NaN];
		var dims = [targetStackInfo.stackResultDimension, targetStackInfo.stackedOverDimension];
		var targetData = targetStackInfo.data;
		var isStackedByIndex = targetStackInfo.isStackedByIndex;
		var stackStrategy = targetStackInfo.seriesModel.get("stackStrategy") || "samesign";
		targetData.modify(dims, function(v0, v1, dataIndex) {
			var sum = targetData.get(targetStackInfo.stackedDimension, dataIndex);
			if (isNaN(sum)) return resultNaN;
			var byValue;
			var stackedDataRawIndex;
			if (isStackedByIndex) stackedDataRawIndex = targetData.getRawIndex(dataIndex);
			else byValue = targetData.get(targetStackInfo.stackedByDimension, dataIndex);
			var stackedOver = NaN;
			for (var j = idxInStack - 1; j >= 0; j--) {
				var stackInfo = stackInfoList[j];
				if (!isStackedByIndex) stackedDataRawIndex = stackInfo.data.rawIndexOf(stackInfo.stackedByDimension, byValue);
				if (stackedDataRawIndex >= 0) {
					var val = stackInfo.data.getByRawIndex(stackInfo.stackResultDimension, stackedDataRawIndex);
					if (stackStrategy === "all" || stackStrategy === "positive" && val > 0 || stackStrategy === "negative" && val < 0 || stackStrategy === "samesign" && sum >= 0 && val > 0 || stackStrategy === "samesign" && sum <= 0 && val < 0) {
						sum = addSafe(sum, val);
						stackedOver = val;
						break;
					}
				}
			}
			resultVal[0] = sum;
			resultVal[1] = stackedOver;
			return resultVal;
		});
	});
}
var ComponentView = function() {
	function ComponentView$1() {
		this.group = new Group_default();
		this.uid = getUID("viewComponent");
	}
	ComponentView$1.prototype.init = function(ecModel, api) {};
	ComponentView$1.prototype.render = function(model, ecModel, api, payload) {};
	ComponentView$1.prototype.dispose = function(ecModel, api) {};
	ComponentView$1.prototype.updateView = function(model, ecModel, api, payload) {};
	ComponentView$1.prototype.updateLayout = function(model, ecModel, api, payload) {};
	ComponentView$1.prototype.updateVisual = function(model, ecModel, api, payload) {};
	/**
	
	* Hook for toggle blur target series.
	
	* Can be used in marker for blur or leave blur the markers
	
	*/
	ComponentView$1.prototype.toggleBlurSeries = function(seriesModels, isBlur, ecModel) {};
	/**
	
	* Traverse the new rendered elements.
	
	*
	
	* It will traverse the new added element in progressive rendering.
	
	* And traverse all in normal rendering.
	
	*/
	ComponentView$1.prototype.eachRendered = function(cb) {
		var group = this.group;
		if (group) group.traverse(cb);
	};
	return ComponentView$1;
}();
enableClassExtend(ComponentView);
enableClassManagement(ComponentView);
var Component_default = ComponentView;
var inner$5 = makeInner();
var defaultStyleMappers = {
	itemStyle: makeStyleMapper(ITEM_STYLE_KEY_MAP, true),
	lineStyle: makeStyleMapper(LINE_STYLE_KEY_MAP, true)
};
var defaultColorKey = {
	lineStyle: "stroke",
	itemStyle: "fill"
};
function getStyleMapper(seriesModel, stylePath) {
	var styleMapper = seriesModel.visualStyleMapper || defaultStyleMappers[stylePath];
	if (!styleMapper) {
		console.warn("Unknown style type '" + stylePath + "'.");
		return defaultStyleMappers.itemStyle;
	}
	return styleMapper;
}
function getDefaultColorKey(seriesModel, stylePath) {
	var colorKey = seriesModel.visualDrawType || defaultColorKey[stylePath];
	if (!colorKey) {
		console.warn("Unknown style type '" + stylePath + "'.");
		return "fill";
	}
	return colorKey;
}
var seriesStyleTask = {
	createOnAllSeries: true,
	performRawSeries: true,
	reset: function(seriesModel, ecModel) {
		var data = seriesModel.getData();
		var stylePath = seriesModel.visualStyleAccessPath || "itemStyle";
		var styleModel = seriesModel.getModel(stylePath);
		var getStyle$1 = getStyleMapper(seriesModel, stylePath);
		var globalStyle = getStyle$1(styleModel);
		var decalOption = styleModel.getShallow("decal");
		if (decalOption) {
			data.setVisual("decal", decalOption);
			decalOption.dirty = true;
		}
		var colorKey = getDefaultColorKey(seriesModel, stylePath);
		var color = globalStyle[colorKey];
		var colorCallback = isFunction(color) ? color : null;
		var hasAutoColor = globalStyle.fill === "auto" || globalStyle.stroke === "auto";
		if (!globalStyle[colorKey] || colorCallback || hasAutoColor) {
			var colorPalette$1 = seriesModel.getColorFromPalette(
				// TODO series count changed.
				seriesModel.name,
				null,
				ecModel.getSeriesCount()
);
			if (!globalStyle[colorKey]) {
				globalStyle[colorKey] = colorPalette$1;
				data.setVisual("colorFromPalette", true);
			}
			globalStyle.fill = globalStyle.fill === "auto" || isFunction(globalStyle.fill) ? colorPalette$1 : globalStyle.fill;
			globalStyle.stroke = globalStyle.stroke === "auto" || isFunction(globalStyle.stroke) ? colorPalette$1 : globalStyle.stroke;
		}
		data.setVisual("style", globalStyle);
		data.setVisual("drawType", colorKey);
		if (!ecModel.isSeriesFiltered(seriesModel) && colorCallback) {
			data.setVisual("colorFromPalette", false);
			return { dataEach: function(data$1, idx) {
				var dataParams = seriesModel.getDataParams(idx);
				var itemStyle = extend({}, globalStyle);
				itemStyle[colorKey] = colorCallback(dataParams);
				data$1.setItemVisual(idx, "style", itemStyle);
			} };
		}
	}
};
var sharedModel = new Model_default();
var dataStyleTask = {
	createOnAllSeries: true,
	performRawSeries: true,
	reset: function(seriesModel, ecModel) {
		if (seriesModel.ignoreStyleOnData || ecModel.isSeriesFiltered(seriesModel)) return;
		var data = seriesModel.getData();
		var stylePath = seriesModel.visualStyleAccessPath || "itemStyle";
		var getStyle$1 = getStyleMapper(seriesModel, stylePath);
		var colorKey = data.getVisual("drawType");
		return { dataEach: data.hasItemOption ? function(data$1, idx) {
			var rawItem = data$1.getRawDataItem(idx);
			if (rawItem && rawItem[stylePath]) {
				sharedModel.option = rawItem[stylePath];
				var style = getStyle$1(sharedModel);
				var existsStyle = data$1.ensureUniqueItemVisual(idx, "style");
				extend(existsStyle, style);
				if (sharedModel.option.decal) {
					data$1.setItemVisual(idx, "decal", sharedModel.option.decal);
					sharedModel.option.decal.dirty = true;
				}
				if (colorKey in style) data$1.setItemVisual(idx, "colorFromPalette", false);
			}
		} : null };
	}
};
var dataColorPaletteTask = {
	performRawSeries: true,
	overallReset: function(ecModel) {
		var paletteScopeGroupByType = createHashMap();
		ecModel.eachSeries(function(seriesModel) {
			var colorBy = seriesModel.getColorBy();
			if (seriesModel.isColorBySeries()) return;
			var key = seriesModel.type + "-" + colorBy;
			var colorScope = paletteScopeGroupByType.get(key);
			if (!colorScope) {
				colorScope = {};
				paletteScopeGroupByType.set(key, colorScope);
			}
			inner$5(seriesModel).scope = colorScope;
		});
		ecModel.eachSeries(function(seriesModel) {
			if (seriesModel.isColorBySeries() || ecModel.isSeriesFiltered(seriesModel)) return;
			var dataAll = seriesModel.getRawData();
			var idxMap = {};
			var data = seriesModel.getData();
			var colorScope = inner$5(seriesModel).scope;
			var stylePath = seriesModel.visualStyleAccessPath || "itemStyle";
			var colorKey = getDefaultColorKey(seriesModel, stylePath);
			data.each(function(idx) {
				var rawIdx = data.getRawIndex(idx);
				idxMap[rawIdx] = idx;
			});
			dataAll.each(function(rawIdx) {
				var idx = idxMap[rawIdx];
				var fromPalette = data.getItemVisual(idx, "colorFromPalette");
				if (fromPalette) {
					var itemStyle = data.ensureUniqueItemVisual(idx, "style");
					var name_1 = dataAll.getName(rawIdx) || rawIdx + "";
					var dataCount = dataAll.count();
					itemStyle[colorKey] = seriesModel.getColorFromPalette(name_1, colorScope, dataCount);
				}
			});
		});
	}
};
var PI$1 = Math.PI;
function defaultLoading(api, opts) {
	opts = opts || {};
	defaults(opts, {
		text: "loading",
		textColor: "#000",
		fontSize: 12,
		fontWeight: "normal",
		fontStyle: "normal",
		fontFamily: "sans-serif",
		maskColor: "rgba(255, 255, 255, 0.8)",
		showSpinner: true,
		color: "#5470c6",
		spinnerRadius: 10,
		lineWidth: 5,
		zlevel: 0
	});
	var group = new Group_default();
	var mask = new Rect_default({
		style: { fill: opts.maskColor },
		zlevel: opts.zlevel,
		z: 1e4
	});
	group.add(mask);
	var textContent = new Text_default({
		style: {
			text: opts.text,
			fill: opts.textColor,
			fontSize: opts.fontSize,
			fontWeight: opts.fontWeight,
			fontStyle: opts.fontStyle,
			fontFamily: opts.fontFamily
		},
		zlevel: opts.zlevel,
		z: 10001
	});
	var labelRect = new Rect_default({
		style: { fill: "none" },
		textContent,
		textConfig: {
			position: "right",
			distance: 10
		},
		zlevel: opts.zlevel,
		z: 10001
	});
	group.add(labelRect);
	var arc;
	if (opts.showSpinner) {
		arc = new Arc_default({
			shape: {
				startAngle: -PI$1 / 2,
				endAngle: -PI$1 / 2 + .1,
				r: opts.spinnerRadius
			},
			style: {
				stroke: opts.color,
				lineCap: "round",
				lineWidth: opts.lineWidth
			},
			zlevel: opts.zlevel,
			z: 10001
		});
		arc.animateShape(true).when(1e3, { endAngle: PI$1 * 3 / 2 }).start("circularInOut");
		arc.animateShape(true).when(1e3, { startAngle: PI$1 * 3 / 2 }).delay(300).start("circularInOut");
		group.add(arc);
	}
	group.resize = function() {
		var textWidth = textContent.getBoundingRect().width;
		var r = opts.showSpinner ? opts.spinnerRadius : 0;
		var cx = (api.getWidth() - r * 2 - (opts.showSpinner && textWidth ? 10 : 0) - textWidth) / 2 - (opts.showSpinner && textWidth ? 0 : 5 + textWidth / 2) + (opts.showSpinner ? 0 : textWidth / 2) + (textWidth ? 0 : r);
		var cy = api.getHeight() / 2;
		opts.showSpinner && arc.setShape({
			cx,
			cy
		});
		labelRect.setShape({
			x: cx - r,
			y: cy - r,
			width: r * 2,
			height: r * 2
		});
		mask.setShape({
			x: 0,
			y: 0,
			width: api.getWidth(),
			height: api.getHeight()
		});
	};
	group.resize();
	return group;
}
var Scheduler = function() {
	function Scheduler$1(ecInstance, api, dataProcessorHandlers, visualHandlers) {
		this._stageTaskMap = createHashMap();
		this.ecInstance = ecInstance;
		this.api = api;
		dataProcessorHandlers = this._dataProcessorHandlers = dataProcessorHandlers.slice();
		visualHandlers = this._visualHandlers = visualHandlers.slice();
		this._allHandlers = dataProcessorHandlers.concat(visualHandlers);
	}
	Scheduler$1.prototype.restoreData = function(ecModel, payload) {
		ecModel.restoreData(payload);
		this._stageTaskMap.each(function(taskRecord) {
			var overallTask = taskRecord.overallTask;
			overallTask && overallTask.dirty();
		});
	};
	Scheduler$1.prototype.getPerformArgs = function(task, isBlock) {
		if (!task.__pipeline) return;
		var pipeline = this._pipelineMap.get(task.__pipeline.id);
		var pCtx = pipeline.context;
		var incremental = !isBlock && pipeline.progressiveEnabled && (!pCtx || pCtx.progressiveRender) && task.__idxInPipeline > pipeline.blockIndex;
		var step = incremental ? pipeline.step : null;
		var modDataCount = pCtx && pCtx.modDataCount;
		var modBy = modDataCount != null ? Math.ceil(modDataCount / step) : null;
		return {
			step,
			modBy,
			modDataCount
		};
	};
	Scheduler$1.prototype.getPipeline = function(pipelineId) {
		return this._pipelineMap.get(pipelineId);
	};
	/**
	
	* Current, progressive rendering starts from visual and layout.
	
	* Always detect render mode in the same stage, avoiding that incorrect
	
	* detection caused by data filtering.
	
	* Caution:
	
	* `updateStreamModes` use `seriesModel.getData()`.
	
	*/
	Scheduler$1.prototype.updateStreamModes = function(seriesModel, view) {
		var pipeline = this._pipelineMap.get(seriesModel.uid);
		var data = seriesModel.getData();
		var dataLen = data.count();
		var progressiveRender = pipeline.progressiveEnabled && view.incrementalPrepareRender && dataLen >= pipeline.threshold;
		var large = seriesModel.get("large") && dataLen >= seriesModel.get("largeThreshold");
		var modDataCount = seriesModel.get("progressiveChunkMode") === "mod" ? dataLen : null;
		seriesModel.pipelineContext = pipeline.context = {
			progressiveRender,
			modDataCount,
			large
		};
	};
	Scheduler$1.prototype.restorePipelines = function(ecModel) {
		var scheduler = this;
		var pipelineMap = scheduler._pipelineMap = createHashMap();
		ecModel.eachSeries(function(seriesModel) {
			var progressive = seriesModel.getProgressive();
			var pipelineId = seriesModel.uid;
			pipelineMap.set(pipelineId, {
				id: pipelineId,
				head: null,
				tail: null,
				threshold: seriesModel.getProgressiveThreshold(),
				progressiveEnabled: progressive && !(seriesModel.preventIncremental && seriesModel.preventIncremental()),
				blockIndex: -1,
				step: Math.round(progressive || 700),
				count: 0
			});
			scheduler._pipe(seriesModel, seriesModel.dataTask);
		});
	};
	Scheduler$1.prototype.prepareStageTasks = function() {
		var stageTaskMap = this._stageTaskMap;
		var ecModel = this.api.getModel();
		var api = this.api;
		each$4(this._allHandlers, function(handler) {
			var record = stageTaskMap.get(handler.uid) || stageTaskMap.set(handler.uid, {});
			var errMsg = "";
			assert(!(handler.reset && handler.overallReset), errMsg);
			handler.reset && this._createSeriesStageTask(handler, record, ecModel, api);
			handler.overallReset && this._createOverallStageTask(handler, record, ecModel, api);
		}, this);
	};
	Scheduler$1.prototype.prepareView = function(view, model, ecModel, api) {
		var renderTask = view.renderTask;
		var context = renderTask.context;
		context.model = model;
		context.ecModel = ecModel;
		context.api = api;
		renderTask.__block = !view.incrementalPrepareRender;
		this._pipe(model, renderTask);
	};
	Scheduler$1.prototype.performDataProcessorTasks = function(ecModel, payload) {
		this._performStageTasks(this._dataProcessorHandlers, ecModel, payload, { block: true });
	};
	Scheduler$1.prototype.performVisualTasks = function(ecModel, payload, opt) {
		this._performStageTasks(this._visualHandlers, ecModel, payload, opt);
	};
	Scheduler$1.prototype._performStageTasks = function(stageHandlers, ecModel, payload, opt) {
		opt = opt || {};
		var unfinished = false;
		var scheduler = this;
		each$4(stageHandlers, function(stageHandler, idx) {
			if (opt.visualType && opt.visualType !== stageHandler.visualType) return;
			var stageHandlerRecord = scheduler._stageTaskMap.get(stageHandler.uid);
			var seriesTaskMap = stageHandlerRecord.seriesTaskMap;
			var overallTask = stageHandlerRecord.overallTask;
			if (overallTask) {
				var overallNeedDirty_1;
				var agentStubMap = overallTask.agentStubMap;
				agentStubMap.each(function(stub) {
					if (needSetDirty(opt, stub)) {
						stub.dirty();
						overallNeedDirty_1 = true;
					}
				});
				overallNeedDirty_1 && overallTask.dirty();
				scheduler.updatePayload(overallTask, payload);
				var performArgs_1 = scheduler.getPerformArgs(overallTask, opt.block);
				agentStubMap.each(function(stub) {
					stub.perform(performArgs_1);
				});
				if (overallTask.perform(performArgs_1)) unfinished = true;
			} else if (seriesTaskMap) seriesTaskMap.each(function(task, pipelineId) {
				if (needSetDirty(opt, task)) task.dirty();
				var performArgs = scheduler.getPerformArgs(task, opt.block);
				performArgs.skip = !stageHandler.performRawSeries && ecModel.isSeriesFiltered(task.context.model);
				scheduler.updatePayload(task, payload);
				if (task.perform(performArgs)) unfinished = true;
			});
		});
		function needSetDirty(opt$1, task) {
			return opt$1.setDirty && (!opt$1.dirtyMap || opt$1.dirtyMap.get(task.__pipeline.id));
		}
		this.unfinished = unfinished || this.unfinished;
	};
	Scheduler$1.prototype.performSeriesTasks = function(ecModel) {
		var unfinished;
		ecModel.eachSeries(function(seriesModel) {
			unfinished = seriesModel.dataTask.perform() || unfinished;
		});
		this.unfinished = unfinished || this.unfinished;
	};
	Scheduler$1.prototype.plan = function() {
		this._pipelineMap.each(function(pipeline) {
			var task = pipeline.tail;
			do {
				if (task.__block) {
					pipeline.blockIndex = task.__idxInPipeline;
					break;
				}
				task = task.getUpstream();
			} while (task);
		});
	};
	Scheduler$1.prototype.updatePayload = function(task, payload) {
		payload !== "remain" && (task.context.payload = payload);
	};
	Scheduler$1.prototype._createSeriesStageTask = function(stageHandler, stageHandlerRecord, ecModel, api) {
		var scheduler = this;
		var oldSeriesTaskMap = stageHandlerRecord.seriesTaskMap;
		var newSeriesTaskMap = stageHandlerRecord.seriesTaskMap = createHashMap();
		var seriesType$1 = stageHandler.seriesType;
		var getTargetSeries = stageHandler.getTargetSeries;
		if (stageHandler.createOnAllSeries) ecModel.eachRawSeries(create$2);
		else if (seriesType$1) ecModel.eachRawSeriesByType(seriesType$1, create$2);
		else if (getTargetSeries) getTargetSeries(ecModel, api).each(create$2);
		function create$2(seriesModel) {
			var pipelineId = seriesModel.uid;
			var task = newSeriesTaskMap.set(pipelineId, oldSeriesTaskMap && oldSeriesTaskMap.get(pipelineId) || createTask({
				plan: seriesTaskPlan,
				reset: seriesTaskReset,
				count: seriesTaskCount
			}));
			task.context = {
				model: seriesModel,
				ecModel,
				api,
				useClearVisual: stageHandler.isVisual && !stageHandler.isLayout,
				plan: stageHandler.plan,
				reset: stageHandler.reset,
				scheduler
			};
			scheduler._pipe(seriesModel, task);
		}
	};
	Scheduler$1.prototype._createOverallStageTask = function(stageHandler, stageHandlerRecord, ecModel, api) {
		var scheduler = this;
		var overallTask = stageHandlerRecord.overallTask = stageHandlerRecord.overallTask || createTask({ reset: overallTaskReset });
		overallTask.context = {
			ecModel,
			api,
			overallReset: stageHandler.overallReset,
			scheduler
		};
		var oldAgentStubMap = overallTask.agentStubMap;
		var newAgentStubMap = overallTask.agentStubMap = createHashMap();
		var seriesType$1 = stageHandler.seriesType;
		var getTargetSeries = stageHandler.getTargetSeries;
		var overallProgress = true;
		var shouldOverallTaskDirty = false;
		var errMsg = "";
		assert(!stageHandler.createOnAllSeries, errMsg);
		if (seriesType$1) ecModel.eachRawSeriesByType(seriesType$1, createStub);
		else if (getTargetSeries) getTargetSeries(ecModel, api).each(createStub);
		else {
			overallProgress = false;
			each$4(ecModel.getSeries(), createStub);
		}
		function createStub(seriesModel) {
			var pipelineId = seriesModel.uid;
			var stub = newAgentStubMap.set(pipelineId, oldAgentStubMap && oldAgentStubMap.get(pipelineId) || (shouldOverallTaskDirty = true, createTask({
				reset: stubReset,
				onDirty: stubOnDirty
			})));
			stub.context = {
				model: seriesModel,
				overallProgress
			};
			stub.agent = overallTask;
			stub.__block = overallProgress;
			scheduler._pipe(seriesModel, stub);
		}
		if (shouldOverallTaskDirty) overallTask.dirty();
	};
	Scheduler$1.prototype._pipe = function(seriesModel, task) {
		var pipelineId = seriesModel.uid;
		var pipeline = this._pipelineMap.get(pipelineId);
		!pipeline.head && (pipeline.head = task);
		pipeline.tail && pipeline.tail.pipe(task);
		pipeline.tail = task;
		task.__idxInPipeline = pipeline.count++;
		task.__pipeline = pipeline;
	};
	Scheduler$1.wrapStageHandler = function(stageHandler, visualType) {
		if (isFunction(stageHandler)) stageHandler = {
			overallReset: stageHandler,
			seriesType: detectSeriseType(stageHandler)
		};
		stageHandler.uid = getUID("stageHandler");
		visualType && (stageHandler.visualType = visualType);
		return stageHandler;
	};
	return Scheduler$1;
}();
function overallTaskReset(context) {
	context.overallReset(context.ecModel, context.api, context.payload);
}
function stubReset(context) {
	return context.overallProgress && stubProgress;
}
function stubProgress() {
	this.agent.dirty();
	this.getDownstream().dirty();
}
function stubOnDirty() {
	this.agent && this.agent.dirty();
}
function seriesTaskPlan(context) {
	return context.plan ? context.plan(context.model, context.ecModel, context.api, context.payload) : null;
}
function seriesTaskReset(context) {
	if (context.useClearVisual) context.data.clearAllVisual();
	var resetDefines = context.resetDefines = normalizeToArray(context.reset(context.model, context.ecModel, context.api, context.payload));
	return resetDefines.length > 1 ? map$1(resetDefines, function(v, idx) {
		return makeSeriesTaskProgress(idx);
	}) : singleSeriesTaskProgress;
}
var singleSeriesTaskProgress = makeSeriesTaskProgress(0);
function makeSeriesTaskProgress(resetDefineIdx) {
	return function(params, context) {
		var data = context.data;
		var resetDefine = context.resetDefines[resetDefineIdx];
		if (resetDefine && resetDefine.dataEach) for (var i = params.start; i < params.end; i++) resetDefine.dataEach(data, i);
		else if (resetDefine && resetDefine.progress) resetDefine.progress(params, data);
	};
}
function seriesTaskCount(context) {
	return context.data.count();
}
/**

* Only some legacy stage handlers (usually in echarts extensions) are pure function.

* To ensure that they can work normally, they should work in block mode, that is,

* they should not be started util the previous tasks finished. So they cause the

* progressive rendering disabled. We try to detect the series type, to narrow down

* the block range to only the series type they concern, but not all series.

*/
function detectSeriseType(legacyFunc) {
	seriesType = null;
	try {
		legacyFunc(ecModelMock, apiMock);
	} catch (e$1) {}
	return seriesType;
}
var ecModelMock = {};
var apiMock = {};
var seriesType;
mockMethods(ecModelMock, Global_default);
mockMethods(apiMock, ExtensionAPI_default);
ecModelMock.eachSeriesByType = ecModelMock.eachRawSeriesByType = function(type) {
	seriesType = type;
};
ecModelMock.eachComponent = function(cond) {
	if (cond.mainType === "series" && cond.subType) seriesType = cond.subType;
};
function mockMethods(target, Clz) {
	for (var name_1 in Clz.prototype) target[name_1] = noop;
}
var Scheduler_default = Scheduler;
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
var colorAll = [
	"#37A2DA",
	"#32C5E9",
	"#67E0E3",
	"#9FE6B8",
	"#FFDB5C",
	"#ff9f7f",
	"#fb7293",
	"#E062AE",
	"#E690D1",
	"#e7bcf3",
	"#9d96f5",
	"#8378EA",
	"#96BFFF"
];
var light_default = {
	color: colorAll,
	colorLayer: [
		[
			"#37A2DA",
			"#ffd85c",
			"#fd7b5f"
		],
		[
			"#37A2DA",
			"#67E0E3",
			"#FFDB5C",
			"#ff9f7f",
			"#E062AE",
			"#9d96f5"
		],
		[
			"#37A2DA",
			"#32C5E9",
			"#9FE6B8",
			"#FFDB5C",
			"#ff9f7f",
			"#fb7293",
			"#e7bcf3",
			"#8378EA",
			"#96BFFF"
		],
		colorAll
	]
};
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
var contrastColor = "#B9B8CE";
var backgroundColor = "#100C2A";
var axisCommon = function() {
	return {
		axisLine: { lineStyle: { color: contrastColor } },
		splitLine: { lineStyle: { color: "#484753" } },
		splitArea: { areaStyle: { color: ["rgba(255,255,255,0.02)", "rgba(255,255,255,0.05)"] } },
		minorSplitLine: { lineStyle: { color: "#20203B" } }
	};
};
var colorPalette = [
	"#4992ff",
	"#7cffb2",
	"#fddd60",
	"#ff6e76",
	"#58d9f9",
	"#05c091",
	"#ff8a45",
	"#8d48e3",
	"#dd79ff"
];
var theme = {
	darkMode: true,
	color: colorPalette,
	backgroundColor,
	axisPointer: {
		lineStyle: { color: "#817f91" },
		crossStyle: { color: "#817f91" },
		label: { color: "#fff" }
	},
	legend: {
		textStyle: { color: contrastColor },
		pageTextStyle: { color: contrastColor }
	},
	textStyle: { color: contrastColor },
	title: {
		textStyle: { color: "#EEF1FA" },
		subtextStyle: { color: "#B9B8CE" }
	},
	toolbox: { iconStyle: { borderColor: contrastColor } },
	dataZoom: {
		borderColor: "#71708A",
		textStyle: { color: contrastColor },
		brushStyle: { color: "rgba(135,163,206,0.3)" },
		handleStyle: {
			color: "#353450",
			borderColor: "#C5CBE3"
		},
		moveHandleStyle: {
			color: "#B0B6C3",
			opacity: .3
		},
		fillerColor: "rgba(135,163,206,0.2)",
		emphasis: {
			handleStyle: {
				borderColor: "#91B7F2",
				color: "#4D587D"
			},
			moveHandleStyle: {
				color: "#636D9A",
				opacity: .7
			}
		},
		dataBackground: {
			lineStyle: {
				color: "#71708A",
				width: 1
			},
			areaStyle: { color: "#71708A" }
		},
		selectedDataBackground: {
			lineStyle: { color: "#87A3CE" },
			areaStyle: { color: "#87A3CE" }
		}
	},
	visualMap: { textStyle: { color: contrastColor } },
	timeline: {
		lineStyle: { color: contrastColor },
		label: { color: contrastColor },
		controlStyle: {
			color: contrastColor,
			borderColor: contrastColor
		}
	},
	calendar: {
		itemStyle: { color: backgroundColor },
		dayLabel: { color: contrastColor },
		monthLabel: { color: contrastColor },
		yearLabel: { color: contrastColor }
	},
	timeAxis: axisCommon(),
	logAxis: axisCommon(),
	valueAxis: axisCommon(),
	categoryAxis: axisCommon(),
	line: { symbol: "circle" },
	graph: { color: colorPalette },
	gauge: {
		title: { color: contrastColor },
		axisLine: { lineStyle: { color: [[1, "rgba(207,212,219,0.2)"]] } },
		axisLabel: { color: contrastColor },
		detail: { color: "#EEF1FA" }
	},
	candlestick: { itemStyle: {
		color: "#f64e56",
		color0: "#54ea92",
		borderColor: "#f64e56",
		borderColor0: "#54ea92"
	} }
};
theme.categoryAxis.splitLine.show = false;
var dark_default = theme;
/**

* Usage of query:

* `chart.on('click', query, handler);`

* The `query` can be:

* + The component type query string, only `mainType` or `mainType.subType`,

*   like: 'xAxis', 'series', 'xAxis.category' or 'series.line'.

* + The component query object, like:

*   `{seriesIndex: 2}`, `{seriesName: 'xx'}`, `{seriesId: 'some'}`,

*   `{xAxisIndex: 2}`, `{xAxisName: 'xx'}`, `{xAxisId: 'some'}`.

* + The data query object, like:

*   `{dataIndex: 123}`, `{dataType: 'link'}`, `{name: 'some'}`.

* + The other query object (cmponent customized query), like:

*   `{element: 'some'}` (only available in custom series).

*

* Caveat: If a prop in the `query` object is `null/undefined`, it is the

* same as there is no such prop in the `query` object.

*/
var ECEventProcessor = function() {
	function ECEventProcessor$1() {}
	ECEventProcessor$1.prototype.normalizeQuery = function(query) {
		var cptQuery = {};
		var dataQuery = {};
		var otherQuery = {};
		if (isString(query)) {
			var condCptType = parseClassType(query);
			cptQuery.mainType = condCptType.main || null;
			cptQuery.subType = condCptType.sub || null;
		} else {
			var suffixes_1 = [
				"Index",
				"Name",
				"Id"
			];
			var dataKeys_1 = {
				name: 1,
				dataIndex: 1,
				dataType: 1
			};
			each$4(query, function(val, key) {
				var reserved = false;
				for (var i = 0; i < suffixes_1.length; i++) {
					var propSuffix = suffixes_1[i];
					var suffixPos = key.lastIndexOf(propSuffix);
					if (suffixPos > 0 && suffixPos === key.length - propSuffix.length) {
						var mainType = key.slice(0, suffixPos);
						if (mainType !== "data") {
							cptQuery.mainType = mainType;
							cptQuery[propSuffix.toLowerCase()] = val;
							reserved = true;
						}
					}
				}
				if (dataKeys_1.hasOwnProperty(key)) {
					dataQuery[key] = val;
					reserved = true;
				}
				if (!reserved) otherQuery[key] = val;
			});
		}
		return {
			cptQuery,
			dataQuery,
			otherQuery
		};
	};
	ECEventProcessor$1.prototype.filter = function(eventType, query) {
		var eventInfo = this.eventInfo;
		if (!eventInfo) return true;
		var targetEl = eventInfo.targetEl;
		var packedEvent = eventInfo.packedEvent;
		var model = eventInfo.model;
		var view = eventInfo.view;
		if (!model || !view) return true;
		var cptQuery = query.cptQuery;
		var dataQuery = query.dataQuery;
		return check(cptQuery, model, "mainType") && check(cptQuery, model, "subType") && check(cptQuery, model, "index", "componentIndex") && check(cptQuery, model, "name") && check(cptQuery, model, "id") && check(dataQuery, packedEvent, "name") && check(dataQuery, packedEvent, "dataIndex") && check(dataQuery, packedEvent, "dataType") && (!view.filterForExposedEvent || view.filterForExposedEvent(eventType, query.otherQuery, targetEl, packedEvent));
		function check(query$1, host, prop, propOnHost) {
			return query$1[prop] == null || host[propOnHost || prop] === query$1[prop];
		}
	};
	ECEventProcessor$1.prototype.afterTrigger = function() {
		this.eventInfo = null;
	};
	return ECEventProcessor$1;
}();
var SYMBOL_PROPS_WITH_CB = [
	"symbol",
	"symbolSize",
	"symbolRotate",
	"symbolOffset"
];
var SYMBOL_PROPS = SYMBOL_PROPS_WITH_CB.concat(["symbolKeepAspect"]);
var seriesSymbolTask = {
	createOnAllSeries: true,
	performRawSeries: true,
	reset: function(seriesModel, ecModel) {
		var data = seriesModel.getData();
		if (seriesModel.legendIcon) data.setVisual("legendIcon", seriesModel.legendIcon);
		if (!seriesModel.hasSymbolVisual) return;
		var symbolOptions = {};
		var symbolOptionsCb = {};
		var hasCallback = false;
		for (var i = 0; i < SYMBOL_PROPS_WITH_CB.length; i++) {
			var symbolPropName = SYMBOL_PROPS_WITH_CB[i];
			var val = seriesModel.get(symbolPropName);
			if (isFunction(val)) {
				hasCallback = true;
				symbolOptionsCb[symbolPropName] = val;
			} else symbolOptions[symbolPropName] = val;
		}
		symbolOptions.symbol = symbolOptions.symbol || seriesModel.defaultSymbol;
		data.setVisual(extend({
			legendIcon: seriesModel.legendIcon || symbolOptions.symbol,
			symbolKeepAspect: seriesModel.get("symbolKeepAspect")
		}, symbolOptions));
		if (ecModel.isSeriesFiltered(seriesModel)) return;
		var symbolPropsCb = keys(symbolOptionsCb);
		function dataEach(data$1, idx) {
			var rawValue = seriesModel.getRawValue(idx);
			var params = seriesModel.getDataParams(idx);
			for (var i$1 = 0; i$1 < symbolPropsCb.length; i$1++) {
				var symbolPropName$1 = symbolPropsCb[i$1];
				data$1.setItemVisual(idx, symbolPropName$1, symbolOptionsCb[symbolPropName$1](rawValue, params));
			}
		}
		return { dataEach: hasCallback ? dataEach : null };
	}
};
var dataSymbolTask = {
	createOnAllSeries: true,
	performRawSeries: true,
	reset: function(seriesModel, ecModel) {
		if (!seriesModel.hasSymbolVisual) return;
		if (ecModel.isSeriesFiltered(seriesModel)) return;
		var data = seriesModel.getData();
		function dataEach(data$1, idx) {
			var itemModel = data$1.getItemModel(idx);
			for (var i = 0; i < SYMBOL_PROPS.length; i++) {
				var symbolPropName = SYMBOL_PROPS[i];
				var val = itemModel.getShallow(symbolPropName, true);
				if (val != null) data$1.setItemVisual(idx, symbolPropName, val);
			}
		}
		return { dataEach: data.hasItemOption ? dataEach : null };
	}
};
function getItemVisualFromData(data, dataIndex, key) {
	switch (key) {
		case "color":
			var style = data.getItemVisual(dataIndex, "style");
			return style[data.getVisual("drawType")];
		case "opacity": return data.getItemVisual(dataIndex, "style").opacity;
		case "symbol":
		case "symbolSize":
		case "liftZ": return data.getItemVisual(dataIndex, key);
		default:
	}
}
function getVisualFromData(data, key) {
	switch (key) {
		case "color":
			var style = data.getVisual("style");
			return style[data.getVisual("drawType")];
		case "opacity": return data.getVisual("style").opacity;
		case "symbol":
		case "symbolSize":
		case "liftZ": return data.getVisual(key);
		default:
	}
}
function findEventDispatcher(target, det, returnFirstMatch) {
	var found;
	while (target) {
		if (det(target)) {
			found = target;
			if (returnFirstMatch) break;
		}
		target = target.__hostTarget || target.parent;
	}
	return found;
}
var wmUniqueIndex = Math.round(Math.random() * 9);
var supportDefineProperty = typeof Object.defineProperty === "function";
var WeakMap = function() {
	function WeakMap$1() {
		this._id = "__ec_inner_" + wmUniqueIndex++;
	}
	WeakMap$1.prototype.get = function(key) {
		return this._guard(key)[this._id];
	};
	WeakMap$1.prototype.set = function(key, value) {
		var target = this._guard(key);
		if (supportDefineProperty) Object.defineProperty(target, this._id, {
			value,
			enumerable: false,
			configurable: true
		});
		else target[this._id] = value;
		return this;
	};
	WeakMap$1.prototype["delete"] = function(key) {
		if (this.has(key)) {
			delete this._guard(key)[this._id];
			return true;
		}
		return false;
	};
	WeakMap$1.prototype.has = function(key) {
		return !!this._guard(key)[this._id];
	};
	WeakMap$1.prototype._guard = function(key) {
		if (key !== Object(key)) throw TypeError("Value of WeakMap is not a non-null object.");
		return key;
	};
	return WeakMap$1;
}();
var WeakMap_default = WeakMap;
function isSafeNum(num) {
	return isFinite(num);
}
function createLinearGradient(ctx, obj, rect) {
	var x = obj.x == null ? 0 : obj.x;
	var x2 = obj.x2 == null ? 1 : obj.x2;
	var y = obj.y == null ? 0 : obj.y;
	var y2 = obj.y2 == null ? 0 : obj.y2;
	if (!obj.global) {
		x = x * rect.width + rect.x;
		x2 = x2 * rect.width + rect.x;
		y = y * rect.height + rect.y;
		y2 = y2 * rect.height + rect.y;
	}
	x = isSafeNum(x) ? x : 0;
	x2 = isSafeNum(x2) ? x2 : 1;
	y = isSafeNum(y) ? y : 0;
	y2 = isSafeNum(y2) ? y2 : 0;
	var canvasGradient = ctx.createLinearGradient(x, y, x2, y2);
	return canvasGradient;
}
function createRadialGradient(ctx, obj, rect) {
	var width = rect.width;
	var height = rect.height;
	var min$2 = Math.min(width, height);
	var x = obj.x == null ? .5 : obj.x;
	var y = obj.y == null ? .5 : obj.y;
	var r = obj.r == null ? .5 : obj.r;
	if (!obj.global) {
		x = x * width + rect.x;
		y = y * height + rect.y;
		r = r * min$2;
	}
	x = isSafeNum(x) ? x : .5;
	y = isSafeNum(y) ? y : .5;
	r = r >= 0 && isSafeNum(r) ? r : .5;
	var canvasGradient = ctx.createRadialGradient(x, y, 0, x, y, r);
	return canvasGradient;
}
function getCanvasGradient(ctx, obj, rect) {
	var canvasGradient = obj.type === "radial" ? createRadialGradient(ctx, obj, rect) : createLinearGradient(ctx, obj, rect);
	var colorStops = obj.colorStops;
	for (var i = 0; i < colorStops.length; i++) canvasGradient.addColorStop(colorStops[i].offset, colorStops[i].color);
	return canvasGradient;
}
function isClipPathChanged(clipPaths, prevClipPaths) {
	if (clipPaths === prevClipPaths || !clipPaths && !prevClipPaths) return false;
	if (!clipPaths || !prevClipPaths || clipPaths.length !== prevClipPaths.length) return true;
	for (var i = 0; i < clipPaths.length; i++) if (clipPaths[i] !== prevClipPaths[i]) return true;
	return false;
}
function parseInt10(val) {
	return parseInt(val, 10);
}
function getSize(root, whIdx, opts) {
	var wh = ["width", "height"][whIdx];
	var cwh = ["clientWidth", "clientHeight"][whIdx];
	var plt = ["paddingLeft", "paddingTop"][whIdx];
	var prb = ["paddingRight", "paddingBottom"][whIdx];
	if (opts[wh] != null && opts[wh] !== "auto") return parseFloat(opts[wh]);
	var stl = document.defaultView.getComputedStyle(root);
	return (root[cwh] || parseInt10(stl[wh]) || parseInt10(root.style[wh])) - (parseInt10(stl[plt]) || 0) - (parseInt10(stl[prb]) || 0) | 0;
}
function normalizeLineDash(lineType, lineWidth) {
	if (!lineType || lineType === "solid" || !(lineWidth > 0)) return null;
	return lineType === "dashed" ? [4 * lineWidth, 2 * lineWidth] : lineType === "dotted" ? [lineWidth] : isNumber(lineType) ? [lineType] : isArray(lineType) ? lineType : null;
}
function getLineDash(el) {
	var style = el.style;
	var lineDash = style.lineDash && style.lineWidth > 0 && normalizeLineDash(style.lineDash, style.lineWidth);
	var lineDashOffset = style.lineDashOffset;
	if (lineDash) {
		var lineScale_1 = style.strokeNoScale && el.getLineScale ? el.getLineScale() : 1;
		if (lineScale_1 && lineScale_1 !== 1) {
			lineDash = map$1(lineDash, function(rawVal) {
				return rawVal / lineScale_1;
			});
			lineDashOffset /= lineScale_1;
		}
	}
	return [lineDash, lineDashOffset];
}
var pathProxyForDraw = new PathProxy_default(true);
function styleHasStroke(style) {
	var stroke = style.stroke;
	return !(stroke == null || stroke === "none" || !(style.lineWidth > 0));
}
function isValidStrokeFillStyle(strokeOrFill) {
	return typeof strokeOrFill === "string" && strokeOrFill !== "none";
}
function styleHasFill(style) {
	var fill = style.fill;
	return fill != null && fill !== "none";
}
function doFillPath(ctx, style) {
	if (style.fillOpacity != null && style.fillOpacity !== 1) {
		var originalGlobalAlpha = ctx.globalAlpha;
		ctx.globalAlpha = style.fillOpacity * style.opacity;
		ctx.fill();
		ctx.globalAlpha = originalGlobalAlpha;
	} else ctx.fill();
}
function doStrokePath(ctx, style) {
	if (style.strokeOpacity != null && style.strokeOpacity !== 1) {
		var originalGlobalAlpha = ctx.globalAlpha;
		ctx.globalAlpha = style.strokeOpacity * style.opacity;
		ctx.stroke();
		ctx.globalAlpha = originalGlobalAlpha;
	} else ctx.stroke();
}
function createCanvasPattern(ctx, pattern, el) {
	var image = createOrUpdateImage(pattern.image, pattern.__image, el);
	if (isImageReady(image)) {
		var canvasPattern = ctx.createPattern(image, pattern.repeat || "repeat");
		if (typeof DOMMatrix === "function" && canvasPattern && canvasPattern.setTransform) {
			var matrix = new DOMMatrix();
			matrix.translateSelf(pattern.x || 0, pattern.y || 0);
			matrix.rotateSelf(0, 0, (pattern.rotation || 0) * RADIAN_TO_DEGREE);
			matrix.scaleSelf(pattern.scaleX || 1, pattern.scaleY || 1);
			canvasPattern.setTransform(matrix);
		}
		return canvasPattern;
	}
}
function brushPath(ctx, el, style, inBatch) {
	var _a$1;
	var hasStroke = styleHasStroke(style);
	var hasFill = styleHasFill(style);
	var strokePercent = style.strokePercent;
	var strokePart = strokePercent < 1;
	var firstDraw = !el.path;
	if ((!el.silent || strokePart) && firstDraw) el.createPathProxy();
	var path = el.path || pathProxyForDraw;
	var dirtyFlag = el.__dirty;
	if (!inBatch) {
		var fill = style.fill;
		var stroke = style.stroke;
		var hasFillGradient = hasFill && !!fill.colorStops;
		var hasStrokeGradient = hasStroke && !!stroke.colorStops;
		var hasFillPattern = hasFill && !!fill.image;
		var hasStrokePattern = hasStroke && !!stroke.image;
		var fillGradient = void 0;
		var strokeGradient = void 0;
		var fillPattern = void 0;
		var strokePattern = void 0;
		var rect = void 0;
		if (hasFillGradient || hasStrokeGradient) rect = el.getBoundingRect();
		if (hasFillGradient) {
			fillGradient = dirtyFlag ? getCanvasGradient(ctx, fill, rect) : el.__canvasFillGradient;
			el.__canvasFillGradient = fillGradient;
		}
		if (hasStrokeGradient) {
			strokeGradient = dirtyFlag ? getCanvasGradient(ctx, stroke, rect) : el.__canvasStrokeGradient;
			el.__canvasStrokeGradient = strokeGradient;
		}
		if (hasFillPattern) {
			fillPattern = dirtyFlag || !el.__canvasFillPattern ? createCanvasPattern(ctx, fill, el) : el.__canvasFillPattern;
			el.__canvasFillPattern = fillPattern;
		}
		if (hasStrokePattern) {
			strokePattern = dirtyFlag || !el.__canvasStrokePattern ? createCanvasPattern(ctx, stroke, el) : el.__canvasStrokePattern;
			el.__canvasStrokePattern = fillPattern;
		}
		if (hasFillGradient) ctx.fillStyle = fillGradient;
		else if (hasFillPattern) if (fillPattern) ctx.fillStyle = fillPattern;
		else hasFill = false;
		if (hasStrokeGradient) ctx.strokeStyle = strokeGradient;
		else if (hasStrokePattern) if (strokePattern) ctx.strokeStyle = strokePattern;
		else hasStroke = false;
	}
	var scale$3 = el.getGlobalScale();
	path.setScale(scale$3[0], scale$3[1], el.segmentIgnoreThreshold);
	var lineDash;
	var lineDashOffset;
	if (ctx.setLineDash && style.lineDash) _a$1 = getLineDash(el), lineDash = _a$1[0], lineDashOffset = _a$1[1];
	var needsRebuild = true;
	if (firstDraw || dirtyFlag & SHAPE_CHANGED_BIT) {
		path.setDPR(ctx.dpr);
		if (strokePart) path.setContext(null);
		else {
			path.setContext(ctx);
			needsRebuild = false;
		}
		path.reset();
		el.buildPath(path, el.shape, inBatch);
		path.toStatic();
		el.pathUpdated();
	}
	if (needsRebuild) path.rebuildPath(ctx, strokePart ? strokePercent : 1);
	if (lineDash) {
		ctx.setLineDash(lineDash);
		ctx.lineDashOffset = lineDashOffset;
	}
	if (!inBatch) if (style.strokeFirst) {
		if (hasStroke) doStrokePath(ctx, style);
		if (hasFill) doFillPath(ctx, style);
	} else {
		if (hasFill) doFillPath(ctx, style);
		if (hasStroke) doStrokePath(ctx, style);
	}
	if (lineDash) ctx.setLineDash([]);
}
function brushImage(ctx, el, style) {
	var image = el.__image = createOrUpdateImage(style.image, el.__image, el, el.onload);
	if (!image || !isImageReady(image)) return;
	var x = style.x || 0;
	var y = style.y || 0;
	var width = el.getWidth();
	var height = el.getHeight();
	var aspect = image.width / image.height;
	if (width == null && height != null) width = height * aspect;
	else if (height == null && width != null) height = width / aspect;
	else if (width == null && height == null) {
		width = image.width;
		height = image.height;
	}
	if (style.sWidth && style.sHeight) {
		var sx = style.sx || 0;
		var sy = style.sy || 0;
		ctx.drawImage(image, sx, sy, style.sWidth, style.sHeight, x, y, width, height);
	} else if (style.sx && style.sy) {
		var sx = style.sx;
		var sy = style.sy;
		var sWidth = width - sx;
		var sHeight = height - sy;
		ctx.drawImage(image, sx, sy, sWidth, sHeight, x, y, width, height);
	} else ctx.drawImage(image, x, y, width, height);
}
function brushText(ctx, el, style) {
	var _a$1;
	var text = style.text;
	text != null && (text += "");
	if (text) {
		ctx.font = style.font || DEFAULT_FONT;
		ctx.textAlign = style.textAlign;
		ctx.textBaseline = style.textBaseline;
		var lineDash = void 0;
		var lineDashOffset = void 0;
		if (ctx.setLineDash && style.lineDash) _a$1 = getLineDash(el), lineDash = _a$1[0], lineDashOffset = _a$1[1];
		if (lineDash) {
			ctx.setLineDash(lineDash);
			ctx.lineDashOffset = lineDashOffset;
		}
		if (style.strokeFirst) {
			if (styleHasStroke(style)) ctx.strokeText(text, style.x, style.y);
			if (styleHasFill(style)) ctx.fillText(text, style.x, style.y);
		} else {
			if (styleHasFill(style)) ctx.fillText(text, style.x, style.y);
			if (styleHasStroke(style)) ctx.strokeText(text, style.x, style.y);
		}
		if (lineDash) ctx.setLineDash([]);
	}
}
var SHADOW_NUMBER_PROPS = [
	"shadowBlur",
	"shadowOffsetX",
	"shadowOffsetY"
];
var STROKE_PROPS = [
	["lineCap", "butt"],
	["lineJoin", "miter"],
	["miterLimit", 10]
];
function bindCommonProps(ctx, style, prevStyle, forceSetAll, scope) {
	var styleChanged = false;
	if (!forceSetAll) {
		prevStyle = prevStyle || {};
		if (style === prevStyle) return false;
	}
	if (forceSetAll || style.opacity !== prevStyle.opacity) {
		flushPathDrawn(ctx, scope);
		styleChanged = true;
		var opacity = Math.max(Math.min(style.opacity, 1), 0);
		ctx.globalAlpha = isNaN(opacity) ? DEFAULT_COMMON_STYLE.opacity : opacity;
	}
	if (forceSetAll || style.blend !== prevStyle.blend) {
		if (!styleChanged) {
			flushPathDrawn(ctx, scope);
			styleChanged = true;
		}
		ctx.globalCompositeOperation = style.blend || DEFAULT_COMMON_STYLE.blend;
	}
	for (var i = 0; i < SHADOW_NUMBER_PROPS.length; i++) {
		var propName = SHADOW_NUMBER_PROPS[i];
		if (forceSetAll || style[propName] !== prevStyle[propName]) {
			if (!styleChanged) {
				flushPathDrawn(ctx, scope);
				styleChanged = true;
			}
			ctx[propName] = ctx.dpr * (style[propName] || 0);
		}
	}
	if (forceSetAll || style.shadowColor !== prevStyle.shadowColor) {
		if (!styleChanged) {
			flushPathDrawn(ctx, scope);
			styleChanged = true;
		}
		ctx.shadowColor = style.shadowColor || DEFAULT_COMMON_STYLE.shadowColor;
	}
	return styleChanged;
}
function bindPathAndTextCommonStyle(ctx, el, prevEl, forceSetAll, scope) {
	var style = getStyle(el, scope.inHover);
	var prevStyle = forceSetAll ? null : prevEl && getStyle(prevEl, scope.inHover) || {};
	if (style === prevStyle) return false;
	var styleChanged = bindCommonProps(ctx, style, prevStyle, forceSetAll, scope);
	if (forceSetAll || style.fill !== prevStyle.fill) {
		if (!styleChanged) {
			flushPathDrawn(ctx, scope);
			styleChanged = true;
		}
		isValidStrokeFillStyle(style.fill) && (ctx.fillStyle = style.fill);
	}
	if (forceSetAll || style.stroke !== prevStyle.stroke) {
		if (!styleChanged) {
			flushPathDrawn(ctx, scope);
			styleChanged = true;
		}
		isValidStrokeFillStyle(style.stroke) && (ctx.strokeStyle = style.stroke);
	}
	if (forceSetAll || style.opacity !== prevStyle.opacity) {
		if (!styleChanged) {
			flushPathDrawn(ctx, scope);
			styleChanged = true;
		}
		ctx.globalAlpha = style.opacity == null ? 1 : style.opacity;
	}
	if (el.hasStroke()) {
		var lineWidth = style.lineWidth;
		var newLineWidth = lineWidth / (style.strokeNoScale && el.getLineScale ? el.getLineScale() : 1);
		if (ctx.lineWidth !== newLineWidth) {
			if (!styleChanged) {
				flushPathDrawn(ctx, scope);
				styleChanged = true;
			}
			ctx.lineWidth = newLineWidth;
		}
	}
	for (var i = 0; i < STROKE_PROPS.length; i++) {
		var prop = STROKE_PROPS[i];
		var propName = prop[0];
		if (forceSetAll || style[propName] !== prevStyle[propName]) {
			if (!styleChanged) {
				flushPathDrawn(ctx, scope);
				styleChanged = true;
			}
			ctx[propName] = style[propName] || prop[1];
		}
	}
	return styleChanged;
}
function bindImageStyle(ctx, el, prevEl, forceSetAll, scope) {
	return bindCommonProps(ctx, getStyle(el, scope.inHover), prevEl && getStyle(prevEl, scope.inHover), forceSetAll, scope);
}
function setContextTransform(ctx, el) {
	var m$1 = el.transform;
	var dpr$1 = ctx.dpr || 1;
	if (m$1) ctx.setTransform(dpr$1 * m$1[0], dpr$1 * m$1[1], dpr$1 * m$1[2], dpr$1 * m$1[3], dpr$1 * m$1[4], dpr$1 * m$1[5]);
	else ctx.setTransform(dpr$1, 0, 0, dpr$1, 0, 0);
}
function updateClipStatus(clipPaths, ctx, scope) {
	var allClipped = false;
	for (var i = 0; i < clipPaths.length; i++) {
		var clipPath = clipPaths[i];
		allClipped = allClipped || clipPath.isZeroArea();
		setContextTransform(ctx, clipPath);
		ctx.beginPath();
		clipPath.buildPath(ctx, clipPath.shape);
		ctx.clip();
	}
	scope.allClipped = allClipped;
}
function isTransformChanged(m0, m1) {
	if (m0 && m1) return m0[0] !== m1[0] || m0[1] !== m1[1] || m0[2] !== m1[2] || m0[3] !== m1[3] || m0[4] !== m1[4] || m0[5] !== m1[5];
	else if (!m0 && !m1) return false;
	return true;
}
var DRAW_TYPE_PATH = 1;
var DRAW_TYPE_IMAGE = 2;
var DRAW_TYPE_TEXT = 3;
var DRAW_TYPE_INCREMENTAL = 4;
function canPathBatch(style) {
	var hasFill = styleHasFill(style);
	var hasStroke = styleHasStroke(style);
	return !(style.lineDash || !(+hasFill ^ +hasStroke) || hasFill && typeof style.fill !== "string" || hasStroke && typeof style.stroke !== "string" || style.strokePercent < 1 || style.strokeOpacity < 1 || style.fillOpacity < 1);
}
function flushPathDrawn(ctx, scope) {
	scope.batchFill && ctx.fill();
	scope.batchStroke && ctx.stroke();
	scope.batchFill = "";
	scope.batchStroke = "";
}
function getStyle(el, inHover) {
	return inHover ? el.__hoverStyle || el.style : el.style;
}
function brushSingle(ctx, el) {
	brush(ctx, el, {
		inHover: false,
		viewWidth: 0,
		viewHeight: 0
	}, true);
}
function brush(ctx, el, scope, isLast) {
	var m$1 = el.transform;
	if (!el.shouldBePainted(scope.viewWidth, scope.viewHeight, false, false)) {
		el.__dirty &= ~REDRAW_BIT;
		el.__isRendered = false;
		return;
	}
	var clipPaths = el.__clipPaths;
	var prevElClipPaths = scope.prevElClipPaths;
	var forceSetTransform = false;
	var forceSetStyle = false;
	if (!prevElClipPaths || isClipPathChanged(clipPaths, prevElClipPaths)) {
		if (prevElClipPaths && prevElClipPaths.length) {
			flushPathDrawn(ctx, scope);
			ctx.restore();
			forceSetStyle = forceSetTransform = true;
			scope.prevElClipPaths = null;
			scope.allClipped = false;
			scope.prevEl = null;
		}
		if (clipPaths && clipPaths.length) {
			flushPathDrawn(ctx, scope);
			ctx.save();
			updateClipStatus(clipPaths, ctx, scope);
			forceSetTransform = true;
		}
		scope.prevElClipPaths = clipPaths;
	}
	if (scope.allClipped) {
		el.__isRendered = false;
		return;
	}
	el.beforeBrush && el.beforeBrush();
	el.innerBeforeBrush();
	var prevEl = scope.prevEl;
	if (!prevEl) forceSetStyle = forceSetTransform = true;
	var canBatchPath = el instanceof Path_default && el.autoBatch && canPathBatch(el.style);
	if (forceSetTransform || isTransformChanged(m$1, prevEl.transform)) {
		flushPathDrawn(ctx, scope);
		setContextTransform(ctx, el);
	} else if (!canBatchPath) flushPathDrawn(ctx, scope);
	var style = getStyle(el, scope.inHover);
	if (el instanceof Path_default) {
		if (scope.lastDrawType !== DRAW_TYPE_PATH) {
			forceSetStyle = true;
			scope.lastDrawType = DRAW_TYPE_PATH;
		}
		bindPathAndTextCommonStyle(ctx, el, prevEl, forceSetStyle, scope);
		if (!canBatchPath || !scope.batchFill && !scope.batchStroke) ctx.beginPath();
		brushPath(ctx, el, style, canBatchPath);
		if (canBatchPath) {
			scope.batchFill = style.fill || "";
			scope.batchStroke = style.stroke || "";
		}
	} else if (el instanceof TSpan_default) {
		if (scope.lastDrawType !== DRAW_TYPE_TEXT) {
			forceSetStyle = true;
			scope.lastDrawType = DRAW_TYPE_TEXT;
		}
		bindPathAndTextCommonStyle(ctx, el, prevEl, forceSetStyle, scope);
		brushText(ctx, el, style);
	} else if (el instanceof Image_default) {
		if (scope.lastDrawType !== DRAW_TYPE_IMAGE) {
			forceSetStyle = true;
			scope.lastDrawType = DRAW_TYPE_IMAGE;
		}
		bindImageStyle(ctx, el, prevEl, forceSetStyle, scope);
		brushImage(ctx, el, style);
	} else if (el.getTemporalDisplayables) {
		if (scope.lastDrawType !== DRAW_TYPE_INCREMENTAL) {
			forceSetStyle = true;
			scope.lastDrawType = DRAW_TYPE_INCREMENTAL;
		}
		brushIncremental(ctx, el, scope);
	}
	if (canBatchPath && isLast) flushPathDrawn(ctx, scope);
	el.innerAfterBrush();
	el.afterBrush && el.afterBrush();
	scope.prevEl = el;
	el.__dirty = 0;
	el.__isRendered = true;
}
function brushIncremental(ctx, el, scope) {
	var displayables = el.getDisplayables();
	var temporalDisplayables = el.getTemporalDisplayables();
	ctx.save();
	var innerScope = {
		prevElClipPaths: null,
		prevEl: null,
		allClipped: false,
		viewWidth: scope.viewWidth,
		viewHeight: scope.viewHeight,
		inHover: scope.inHover
	};
	var i;
	var len$1;
	for (i = el.getCursor(), len$1 = displayables.length; i < len$1; i++) {
		var displayable = displayables[i];
		displayable.beforeBrush && displayable.beforeBrush();
		displayable.innerBeforeBrush();
		brush(ctx, displayable, innerScope, i === len$1 - 1);
		displayable.innerAfterBrush();
		displayable.afterBrush && displayable.afterBrush();
		innerScope.prevEl = displayable;
	}
	for (var i_1 = 0, len_1 = temporalDisplayables.length; i_1 < len_1; i_1++) {
		var displayable = temporalDisplayables[i_1];
		displayable.beforeBrush && displayable.beforeBrush();
		displayable.innerBeforeBrush();
		brush(ctx, displayable, innerScope, i_1 === len_1 - 1);
		displayable.innerAfterBrush();
		displayable.afterBrush && displayable.afterBrush();
		innerScope.prevEl = displayable;
	}
	el.clearTemporalDisplayables();
	el.notClear = true;
	ctx.restore();
}
var decalMap = new WeakMap_default();
var decalCache = new LRU_default(100);
var decalKeys = [
	"symbol",
	"symbolSize",
	"symbolKeepAspect",
	"color",
	"backgroundColor",
	"dashArrayX",
	"dashArrayY",
	"maxTileWidth",
	"maxTileHeight"
];
function createOrUpdatePatternFromDecal(decalObject, api) {
	if (decalObject === "none") return null;
	var dpr$1 = api.getDevicePixelRatio();
	var zr = api.getZr();
	var isSVG = zr.painter.type === "svg";
	if (decalObject.dirty) decalMap["delete"](decalObject);
	var oldPattern = decalMap.get(decalObject);
	if (oldPattern) return oldPattern;
	var decalOpt = defaults(decalObject, {
		symbol: "rect",
		symbolSize: 1,
		symbolKeepAspect: true,
		color: "rgba(0, 0, 0, 0.2)",
		backgroundColor: null,
		dashArrayX: 5,
		dashArrayY: 5,
		rotation: 0,
		maxTileWidth: 512,
		maxTileHeight: 512
	});
	if (decalOpt.backgroundColor === "none") decalOpt.backgroundColor = null;
	var pattern = { repeat: "repeat" };
	setPatternnSource(pattern);
	pattern.rotation = decalOpt.rotation;
	pattern.scaleX = pattern.scaleY = isSVG ? 1 : 1 / dpr$1;
	decalMap.set(decalObject, pattern);
	decalObject.dirty = false;
	return pattern;
	function setPatternnSource(pattern$1) {
		var keys$1 = [dpr$1];
		var isValidKey = true;
		for (var i = 0; i < decalKeys.length; ++i) {
			var value = decalOpt[decalKeys[i]];
			if (value != null && !isArray(value) && !isString(value) && !isNumber(value) && typeof value !== "boolean") {
				isValidKey = false;
				break;
			}
			keys$1.push(value);
		}
		var cacheKey;
		if (isValidKey) {
			cacheKey = keys$1.join(",") + (isSVG ? "-svg" : "");
			var cache = decalCache.get(cacheKey);
			if (cache) isSVG ? pattern$1.svgElement = cache : pattern$1.image = cache;
		}
		var dashArrayX = normalizeDashArrayX(decalOpt.dashArrayX);
		var dashArrayY = normalizeDashArrayY(decalOpt.dashArrayY);
		var symbolArray = normalizeSymbolArray(decalOpt.symbol);
		var lineBlockLengthsX = getLineBlockLengthX(dashArrayX);
		var lineBlockLengthY = getLineBlockLengthY(dashArrayY);
		var canvas = !isSVG && platformApi.createCanvas();
		var svgRoot = isSVG && {
			tag: "g",
			attrs: {},
			key: "dcl",
			children: []
		};
		var pSize = getPatternSize();
		var ctx;
		if (canvas) {
			canvas.width = pSize.width * dpr$1;
			canvas.height = pSize.height * dpr$1;
			ctx = canvas.getContext("2d");
		}
		brushDecal();
		if (isValidKey) decalCache.put(cacheKey, canvas || svgRoot);
		pattern$1.image = canvas;
		pattern$1.svgElement = svgRoot;
		pattern$1.svgWidth = pSize.width;
		pattern$1.svgHeight = pSize.height;
		/**
		
		* Get minimum length that can make a repeatable pattern.
		
		*
		
		* @return {Object} pattern width and height
		
		*/
		function getPatternSize() {
			/**
			
			* For example, if dash is [[3, 2], [2, 1]] for X, it looks like
			
			* |---  ---  ---  ---  --- ...
			
			* |-- -- -- -- -- -- -- -- ...
			
			* |---  ---  ---  ---  --- ...
			
			* |-- -- -- -- -- -- -- -- ...
			
			* So the minimum length of X is 15,
			
			* which is the least common multiple of `3 + 2` and `2 + 1`
			
			* |---  ---  ---  |---  --- ...
			
			* |-- -- -- -- -- |-- -- -- ...
			
			*/
			var width = 1;
			for (var i$1 = 0, xlen = lineBlockLengthsX.length; i$1 < xlen; ++i$1) width = getLeastCommonMultiple(width, lineBlockLengthsX[i$1]);
			var symbolRepeats = 1;
			for (var i$1 = 0, xlen = symbolArray.length; i$1 < xlen; ++i$1) symbolRepeats = getLeastCommonMultiple(symbolRepeats, symbolArray[i$1].length);
			width *= symbolRepeats;
			var height = lineBlockLengthY * lineBlockLengthsX.length * symbolArray.length;
			if (0) var warn;
			return {
				width: Math.max(1, Math.min(width, decalOpt.maxTileWidth)),
				height: Math.max(1, Math.min(height, decalOpt.maxTileHeight))
			};
		}
		function brushDecal() {
			if (ctx) {
				ctx.clearRect(0, 0, canvas.width, canvas.height);
				if (decalOpt.backgroundColor) {
					ctx.fillStyle = decalOpt.backgroundColor;
					ctx.fillRect(0, 0, canvas.width, canvas.height);
				}
			}
			var ySum = 0;
			for (var i$1 = 0; i$1 < dashArrayY.length; ++i$1) ySum += dashArrayY[i$1];
			if (ySum <= 0) return;
			var y = -lineBlockLengthY;
			var yId = 0;
			var yIdTotal = 0;
			var xId0 = 0;
			while (y < pSize.height) {
				if (yId % 2 === 0) {
					var symbolYId = yIdTotal / 2 % symbolArray.length;
					var x = 0;
					var xId1 = 0;
					var xId1Total = 0;
					while (x < pSize.width * 2) {
						var xSum = 0;
						for (var i$1 = 0; i$1 < dashArrayX[xId0].length; ++i$1) xSum += dashArrayX[xId0][i$1];
						if (xSum <= 0) break;
						if (xId1 % 2 === 0) {
							var size = (1 - decalOpt.symbolSize) * .5;
							var left = x + dashArrayX[xId0][xId1] * size;
							var top_1 = y + dashArrayY[yId] * size;
							var width = dashArrayX[xId0][xId1] * decalOpt.symbolSize;
							var height = dashArrayY[yId] * decalOpt.symbolSize;
							var symbolXId = xId1Total / 2 % symbolArray[symbolYId].length;
							brushSymbol(left, top_1, width, height, symbolArray[symbolYId][symbolXId]);
						}
						x += dashArrayX[xId0][xId1];
						++xId1Total;
						++xId1;
						if (xId1 === dashArrayX[xId0].length) xId1 = 0;
					}
					++xId0;
					if (xId0 === dashArrayX.length) xId0 = 0;
				}
				y += dashArrayY[yId];
				++yIdTotal;
				++yId;
				if (yId === dashArrayY.length) yId = 0;
			}
			function brushSymbol(x$1, y$1, width$1, height$1, symbolType) {
				var scale$3 = isSVG ? 1 : dpr$1;
				var symbol = createSymbol(symbolType, x$1 * scale$3, y$1 * scale$3, width$1 * scale$3, height$1 * scale$3, decalOpt.color, decalOpt.symbolKeepAspect);
				if (isSVG) {
					var symbolVNode = zr.painter.renderOneToVNode(symbol);
					if (symbolVNode) svgRoot.children.push(symbolVNode);
				} else brushSingle(ctx, symbol);
			}
		}
	}
}
/**

* Convert symbol array into normalized array

*

* @param {string | (string | string[])[]} symbol symbol input

* @return {string[][]} normolized symbol array

*/
function normalizeSymbolArray(symbol) {
	if (!symbol || symbol.length === 0) return [["rect"]];
	if (isString(symbol)) return [[symbol]];
	var isAllString = true;
	for (var i = 0; i < symbol.length; ++i) if (!isString(symbol[i])) {
		isAllString = false;
		break;
	}
	if (isAllString) return normalizeSymbolArray([symbol]);
	var result = [];
	for (var i = 0; i < symbol.length; ++i) if (isString(symbol[i])) result.push([symbol[i]]);
	else result.push(symbol[i]);
	return result;
}
/**

* Convert dash input into dashArray

*

* @param {DecalDashArrayX} dash dash input

* @return {number[][]} normolized dash array

*/
function normalizeDashArrayX(dash) {
	if (!dash || dash.length === 0) return [[0, 0]];
	if (isNumber(dash)) {
		var dashValue = Math.ceil(dash);
		return [[dashValue, dashValue]];
	}
	/**
	
	* [20, 5] should be normalized into [[20, 5]],
	
	* while [20, [5, 10]] should be normalized into [[20, 20], [5, 10]]
	
	*/
	var isAllNumber = true;
	for (var i = 0; i < dash.length; ++i) if (!isNumber(dash[i])) {
		isAllNumber = false;
		break;
	}
	if (isAllNumber) return normalizeDashArrayX([dash]);
	var result = [];
	for (var i = 0; i < dash.length; ++i) if (isNumber(dash[i])) {
		var dashValue = Math.ceil(dash[i]);
		result.push([dashValue, dashValue]);
	} else {
		var dashValue = map$1(dash[i], function(n) {
			return Math.ceil(n);
		});
		if (dashValue.length % 2 === 1) result.push(dashValue.concat(dashValue));
		else result.push(dashValue);
	}
	return result;
}
/**

* Convert dash input into dashArray

*

* @param {DecalDashArrayY} dash dash input

* @return {number[]} normolized dash array

*/
function normalizeDashArrayY(dash) {
	if (!dash || typeof dash === "object" && dash.length === 0) return [0, 0];
	if (isNumber(dash)) {
		var dashValue_1 = Math.ceil(dash);
		return [dashValue_1, dashValue_1];
	}
	var dashValue = map$1(dash, function(n) {
		return Math.ceil(n);
	});
	return dash.length % 2 ? dashValue.concat(dashValue) : dashValue;
}
/**

* Get block length of each line. A block is the length of dash line and space.

* For example, a line with [4, 1] has a dash line of 4 and a space of 1 after

* that, so the block length of this line is 5.

*

* @param {number[][]} dash dash array of X or Y

* @return {number[]} block length of each line

*/
function getLineBlockLengthX(dash) {
	return map$1(dash, function(line) {
		return getLineBlockLengthY(line);
	});
}
function getLineBlockLengthY(dash) {
	var blockLength = 0;
	for (var i = 0; i < dash.length; ++i) blockLength += dash[i];
	if (dash.length % 2 === 1) return blockLength * 2;
	return blockLength;
}
function decalVisual(ecModel, api) {
	ecModel.eachRawSeries(function(seriesModel) {
		if (ecModel.isSeriesFiltered(seriesModel)) return;
		var data = seriesModel.getData();
		if (data.hasItemVisual()) data.each(function(idx) {
			var decal$1 = data.getItemVisual(idx, "decal");
			if (decal$1) {
				var itemStyle = data.ensureUniqueItemVisual(idx, "style");
				itemStyle.decal = createOrUpdatePatternFromDecal(decal$1, api);
			}
		});
		var decal = data.getVisual("decal");
		if (decal) {
			var style = data.getVisual("style");
			style.decal = createOrUpdatePatternFromDecal(decal, api);
		}
	});
}
var lifecycle = new Eventful_default();
var lifecycle_default = lifecycle;
var implsStore = {};
function registerImpl(name, impl) {
	implsStore[name] = impl;
}
function getImpl(name) {
	return implsStore[name];
}
var TEST_FRAME_REMAIN_TIME = 1;
var PRIORITY_PROCESSOR_SERIES_FILTER = 800;
var PRIORITY_PROCESSOR_DATASTACK = 900;
var PRIORITY_PROCESSOR_FILTER = 1e3;
var PRIORITY_PROCESSOR_DEFAULT = 2e3;
var PRIORITY_PROCESSOR_STATISTIC = 5e3;
var PRIORITY_VISUAL_LAYOUT = 1e3;
var PRIORITY_VISUAL_PROGRESSIVE_LAYOUT = 1100;
var PRIORITY_VISUAL_GLOBAL = 2e3;
var PRIORITY_VISUAL_CHART = 3e3;
var PRIORITY_VISUAL_COMPONENT = 4e3;
var PRIORITY_VISUAL_CHART_DATA_CUSTOM = 4500;
var PRIORITY_VISUAL_POST_CHART_LAYOUT = 4600;
var PRIORITY_VISUAL_BRUSH = 5e3;
var PRIORITY_VISUAL_ARIA = 6e3;
var PRIORITY_VISUAL_DECAL = 7e3;
var PRIORITY = {
	PROCESSOR: {
		FILTER: PRIORITY_PROCESSOR_FILTER,
		SERIES_FILTER: PRIORITY_PROCESSOR_SERIES_FILTER,
		STATISTIC: PRIORITY_PROCESSOR_STATISTIC
	},
	VISUAL: {
		LAYOUT: PRIORITY_VISUAL_LAYOUT,
		PROGRESSIVE_LAYOUT: PRIORITY_VISUAL_PROGRESSIVE_LAYOUT,
		GLOBAL: PRIORITY_VISUAL_GLOBAL,
		CHART: PRIORITY_VISUAL_CHART,
		POST_CHART_LAYOUT: PRIORITY_VISUAL_POST_CHART_LAYOUT,
		COMPONENT: PRIORITY_VISUAL_COMPONENT,
		BRUSH: PRIORITY_VISUAL_BRUSH,
		CHART_ITEM: PRIORITY_VISUAL_CHART_DATA_CUSTOM,
		ARIA: PRIORITY_VISUAL_ARIA,
		DECAL: PRIORITY_VISUAL_DECAL
	}
};
var IN_MAIN_PROCESS_KEY = "__flagInMainProcess";
var PENDING_UPDATE = "__pendingUpdate";
var STATUS_NEEDS_UPDATE_KEY = "__needsUpdateStatus";
var ACTION_REG = /^[a-zA-Z0-9_]+$/;
var CONNECT_STATUS_KEY = "__connectUpdateStatus";
var CONNECT_STATUS_PENDING = 0;
var CONNECT_STATUS_UPDATING = 1;
var CONNECT_STATUS_UPDATED = 2;
function createRegisterEventWithLowercaseECharts(method) {
	return function() {
		var args = [];
		for (var _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
		if (this.isDisposed()) {
			disposedWarning(this.id);
			return;
		}
		return toLowercaseNameAndCallEventful(this, method, args);
	};
}
function createRegisterEventWithLowercaseMessageCenter(method) {
	return function() {
		var args = [];
		for (var _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
		return toLowercaseNameAndCallEventful(this, method, args);
	};
}
function toLowercaseNameAndCallEventful(host, method, args) {
	args[0] = args[0] && args[0].toLowerCase();
	return Eventful_default.prototype[method].apply(host, args);
}
var MessageCenter = function(_super) {
	__extends(MessageCenter$1, _super);
	function MessageCenter$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	return MessageCenter$1;
}(Eventful_default);
var messageCenterProto = MessageCenter.prototype;
messageCenterProto.on = createRegisterEventWithLowercaseMessageCenter("on");
messageCenterProto.off = createRegisterEventWithLowercaseMessageCenter("off");
var prepare;
var prepareView;
var updateDirectly;
var updateMethods;
var doConvertPixel;
var updateStreamModes;
var doDispatchAction;
var flushPendingActions;
var triggerUpdatedEvent;
var bindRenderedEvent;
var bindMouseEvent;
var render;
var renderComponents;
var renderSeries;
var createExtensionAPI;
var enableConnect;
var markStatusToUpdate;
var applyChangedStates;
var ECharts$1 = function(_super) {
	__extends(ECharts$2, _super);
	function ECharts$2(dom, theme$1, opts) {
		var _this = _super.call(this, new ECEventProcessor()) || this;
		_this._chartsViews = [];
		_this._chartsMap = {};
		_this._componentsViews = [];
		_this._componentsMap = {};
		_this._pendingActions = [];
		opts = opts || {};
		if (isString(theme$1)) theme$1 = themeStorage[theme$1];
		_this._dom = dom;
		var defaultRenderer = "canvas";
		var defaultCoarsePointer = "auto";
		var defaultUseDirtyRect = false;
		if (0) var root;
		if (opts.ssr) registerSSRDataGetter(function(el) {
			var ecData = getECData(el);
			var dataIndex = ecData.dataIndex;
			if (dataIndex == null) return;
			var hashMap = createHashMap();
			hashMap.set("series_index", ecData.seriesIndex);
			hashMap.set("data_index", dataIndex);
			ecData.ssrType && hashMap.set("ssr_type", ecData.ssrType);
			return hashMap;
		});
		var zr = _this._zr = init$1(dom, {
			renderer: opts.renderer || defaultRenderer,
			devicePixelRatio: opts.devicePixelRatio,
			width: opts.width,
			height: opts.height,
			ssr: opts.ssr,
			useDirtyRect: retrieve2(opts.useDirtyRect, defaultUseDirtyRect),
			useCoarsePointer: retrieve2(opts.useCoarsePointer, defaultCoarsePointer),
			pointerSize: opts.pointerSize
		});
		_this._ssr = opts.ssr;
		_this._throttledZrFlush = throttle(bind$1(zr.flush, zr), 17);
		theme$1 = clone$2(theme$1);
		theme$1 && globalBackwardCompat(theme$1, true);
		_this._theme = theme$1;
		_this._locale = createLocaleObject(opts.locale || SYSTEM_LANG);
		_this._coordSysMgr = new CoordinateSystem_default();
		var api = _this._api = createExtensionAPI(_this);
		function prioritySortFunc(a, b) {
			return a.__prio - b.__prio;
		}
		sort(visualFuncs, prioritySortFunc);
		sort(dataProcessorFuncs, prioritySortFunc);
		_this._scheduler = new Scheduler_default(_this, api, dataProcessorFuncs, visualFuncs);
		_this._messageCenter = new MessageCenter();
		_this._initEvents();
		_this.resize = bind$1(_this.resize, _this);
		zr.animation.on("frame", _this._onframe, _this);
		bindRenderedEvent(zr, _this);
		bindMouseEvent(zr, _this);
		setAsPrimitive(_this);
		return _this;
	}
	ECharts$2.prototype._onframe = function() {
		if (this._disposed) return;
		applyChangedStates(this);
		var scheduler = this._scheduler;
		if (this[PENDING_UPDATE]) {
			var silent = this[PENDING_UPDATE].silent;
			this[IN_MAIN_PROCESS_KEY] = true;
			try {
				prepare(this);
				updateMethods.update.call(this, null, this[PENDING_UPDATE].updateParams);
			} catch (e$1) {
				this[IN_MAIN_PROCESS_KEY] = false;
				this[PENDING_UPDATE] = null;
				throw e$1;
			}
			this._zr.flush();
			this[IN_MAIN_PROCESS_KEY] = false;
			this[PENDING_UPDATE] = null;
			flushPendingActions.call(this, silent);
			triggerUpdatedEvent.call(this, silent);
		} else if (scheduler.unfinished) {
			var remainTime = TEST_FRAME_REMAIN_TIME;
			var ecModel = this._model;
			var api = this._api;
			scheduler.unfinished = false;
			do {
				var startTime = +new Date();
				scheduler.performSeriesTasks(ecModel);
				scheduler.performDataProcessorTasks(ecModel);
				updateStreamModes(this, ecModel);
				scheduler.performVisualTasks(ecModel);
				renderSeries(this, this._model, api, "remain", {});
				remainTime -= +new Date() - startTime;
			} while (remainTime > 0 && scheduler.unfinished);
			if (!scheduler.unfinished) this._zr.flush();
		}
	};
	ECharts$2.prototype.getDom = function() {
		return this._dom;
	};
	ECharts$2.prototype.getId = function() {
		return this.id;
	};
	ECharts$2.prototype.getZr = function() {
		return this._zr;
	};
	ECharts$2.prototype.isSSR = function() {
		return this._ssr;
	};
	ECharts$2.prototype.setOption = function(option, notMerge, lazyUpdate) {
		if (this[IN_MAIN_PROCESS_KEY]) return;
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		var silent;
		var replaceMerge;
		var transitionOpt;
		if (isObject$2(notMerge)) {
			lazyUpdate = notMerge.lazyUpdate;
			silent = notMerge.silent;
			replaceMerge = notMerge.replaceMerge;
			transitionOpt = notMerge.transition;
			notMerge = notMerge.notMerge;
		}
		this[IN_MAIN_PROCESS_KEY] = true;
		if (!this._model || notMerge) {
			var optionManager = new OptionManager_default(this._api);
			var theme$1 = this._theme;
			var ecModel = this._model = new Global_default();
			ecModel.scheduler = this._scheduler;
			ecModel.ssr = this._ssr;
			ecModel.init(null, null, null, theme$1, this._locale, optionManager);
		}
		this._model.setOption(option, { replaceMerge }, optionPreprocessorFuncs);
		var updateParams = {
			seriesTransition: transitionOpt,
			optionChanged: true
		};
		if (lazyUpdate) {
			this[PENDING_UPDATE] = {
				silent,
				updateParams
			};
			this[IN_MAIN_PROCESS_KEY] = false;
			this.getZr().wakeUp();
		} else {
			try {
				prepare(this);
				updateMethods.update.call(this, null, updateParams);
			} catch (e$1) {
				this[PENDING_UPDATE] = null;
				this[IN_MAIN_PROCESS_KEY] = false;
				throw e$1;
			}
			if (!this._ssr) this._zr.flush();
			this[PENDING_UPDATE] = null;
			this[IN_MAIN_PROCESS_KEY] = false;
			flushPendingActions.call(this, silent);
			triggerUpdatedEvent.call(this, silent);
		}
	};
	/**
	
	* @deprecated
	
	*/
	ECharts$2.prototype.setTheme = function() {
		deprecateLog("ECharts#setTheme() is DEPRECATED in ECharts 3.0");
	};
	ECharts$2.prototype.getModel = function() {
		return this._model;
	};
	ECharts$2.prototype.getOption = function() {
		return this._model && this._model.getOption();
	};
	ECharts$2.prototype.getWidth = function() {
		return this._zr.getWidth();
	};
	ECharts$2.prototype.getHeight = function() {
		return this._zr.getHeight();
	};
	ECharts$2.prototype.getDevicePixelRatio = function() {
		return this._zr.painter.dpr || env_default.hasGlobalWindow && window.devicePixelRatio || 1;
	};
	/**
	
	* Get canvas which has all thing rendered
	
	* @deprecated Use renderToCanvas instead.
	
	*/
	ECharts$2.prototype.getRenderedCanvas = function(opts) {
		return this.renderToCanvas(opts);
	};
	ECharts$2.prototype.renderToCanvas = function(opts) {
		opts = opts || {};
		var painter = this._zr.painter;
		return painter.getRenderedCanvas({
			backgroundColor: opts.backgroundColor || this._model.get("backgroundColor"),
			pixelRatio: opts.pixelRatio || this.getDevicePixelRatio()
		});
	};
	ECharts$2.prototype.renderToSVGString = function(opts) {
		opts = opts || {};
		var painter = this._zr.painter;
		return painter.renderToString({ useViewBox: opts.useViewBox });
	};
	/**
	
	* Get svg data url
	
	*/
	ECharts$2.prototype.getSvgDataURL = function() {
		if (!env_default.svgSupported) return;
		var zr = this._zr;
		var list = zr.storage.getDisplayList();
		each$4(list, function(el) {
			el.stopAnimation(null, true);
		});
		return zr.painter.toDataURL();
	};
	ECharts$2.prototype.getDataURL = function(opts) {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		opts = opts || {};
		var excludeComponents = opts.excludeComponents;
		var ecModel = this._model;
		var excludesComponentViews = [];
		var self$1 = this;
		each$4(excludeComponents, function(componentType) {
			ecModel.eachComponent({ mainType: componentType }, function(component) {
				var view = self$1._componentsMap[component.__viewId];
				if (!view.group.ignore) {
					excludesComponentViews.push(view);
					view.group.ignore = true;
				}
			});
		});
		var url = this._zr.painter.getType() === "svg" ? this.getSvgDataURL() : this.renderToCanvas(opts).toDataURL("image/" + (opts && opts.type || "png"));
		each$4(excludesComponentViews, function(view) {
			view.group.ignore = false;
		});
		return url;
	};
	ECharts$2.prototype.getConnectedDataURL = function(opts) {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		var isSvg = opts.type === "svg";
		var groupId = this.group;
		var mathMin$6 = Math.min;
		var mathMax$6 = Math.max;
		var MAX_NUMBER = Infinity;
		if (connectedGroups[groupId]) {
			var left_1 = MAX_NUMBER;
			var top_1 = MAX_NUMBER;
			var right_1 = -MAX_NUMBER;
			var bottom_1 = -MAX_NUMBER;
			var canvasList_1 = [];
			var dpr_1 = opts && opts.pixelRatio || this.getDevicePixelRatio();
			each$4(instances, function(chart, id) {
				if (chart.group === groupId) {
					var canvas = isSvg ? chart.getZr().painter.getSvgDom().innerHTML : chart.renderToCanvas(clone$2(opts));
					var boundingRect = chart.getDom().getBoundingClientRect();
					left_1 = mathMin$6(boundingRect.left, left_1);
					top_1 = mathMin$6(boundingRect.top, top_1);
					right_1 = mathMax$6(boundingRect.right, right_1);
					bottom_1 = mathMax$6(boundingRect.bottom, bottom_1);
					canvasList_1.push({
						dom: canvas,
						left: boundingRect.left,
						top: boundingRect.top
					});
				}
			});
			left_1 *= dpr_1;
			top_1 *= dpr_1;
			right_1 *= dpr_1;
			bottom_1 *= dpr_1;
			var width = right_1 - left_1;
			var height = bottom_1 - top_1;
			var targetCanvas = platformApi.createCanvas();
			var zr_1 = init$1(targetCanvas, { renderer: isSvg ? "svg" : "canvas" });
			zr_1.resize({
				width,
				height
			});
			if (isSvg) {
				var content_1 = "";
				each$4(canvasList_1, function(item) {
					var x = item.left - left_1;
					var y = item.top - top_1;
					content_1 += "<g transform=\"translate(" + x + "," + y + ")\">" + item.dom + "</g>";
				});
				zr_1.painter.getSvgRoot().innerHTML = content_1;
				if (opts.connectedBackgroundColor) zr_1.painter.setBackgroundColor(opts.connectedBackgroundColor);
				zr_1.refreshImmediately();
				return zr_1.painter.toDataURL();
			} else {
				if (opts.connectedBackgroundColor) zr_1.add(new Rect_default({
					shape: {
						x: 0,
						y: 0,
						width,
						height
					},
					style: { fill: opts.connectedBackgroundColor }
				}));
				each$4(canvasList_1, function(item) {
					var img = new Image_default({ style: {
						x: item.left * dpr_1 - left_1,
						y: item.top * dpr_1 - top_1,
						image: item.dom
					} });
					zr_1.add(img);
				});
				zr_1.refreshImmediately();
				return targetCanvas.toDataURL("image/" + (opts && opts.type || "png"));
			}
		} else return this.getDataURL(opts);
	};
	ECharts$2.prototype.convertToPixel = function(finder, value) {
		return doConvertPixel(this, "convertToPixel", finder, value);
	};
	ECharts$2.prototype.convertFromPixel = function(finder, value) {
		return doConvertPixel(this, "convertFromPixel", finder, value);
	};
	/**
	
	* Is the specified coordinate systems or components contain the given pixel point.
	
	* @param {Array|number} value
	
	* @return {boolean} result
	
	*/
	ECharts$2.prototype.containPixel = function(finder, value) {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		var ecModel = this._model;
		var result;
		var findResult = parseFinder(ecModel, finder);
		each$4(findResult, function(models, key) {
			key.indexOf("Models") >= 0 && each$4(models, function(model) {
				var coordSys = model.coordinateSystem;
				if (coordSys && coordSys.containPoint) result = result || !!coordSys.containPoint(value);
				else if (key === "seriesModels") {
					var view = this._chartsMap[model.__viewId];
					if (view && view.containPoint) result = result || view.containPoint(value, model);
				}
			}, this);
		}, this);
		return !!result;
	};
	/**
	
	* Get visual from series or data.
	
	* @param finder
	
	*        If string, e.g., 'series', means {seriesIndex: 0}.
	
	*        If Object, could contain some of these properties below:
	
	*        {
	
	*            seriesIndex / seriesId / seriesName,
	
	*            dataIndex / dataIndexInside
	
	*        }
	
	*        If dataIndex is not specified, series visual will be fetched,
	
	*        but not data item visual.
	
	*        If all of seriesIndex, seriesId, seriesName are not specified,
	
	*        visual will be fetched from first series.
	
	* @param visualType 'color', 'symbol', 'symbolSize'
	
	*/
	ECharts$2.prototype.getVisual = function(finder, visualType) {
		var ecModel = this._model;
		var parsedFinder = parseFinder(ecModel, finder, { defaultMainType: "series" });
		var seriesModel = parsedFinder.seriesModel;
		var data = seriesModel.getData();
		var dataIndexInside = parsedFinder.hasOwnProperty("dataIndexInside") ? parsedFinder.dataIndexInside : parsedFinder.hasOwnProperty("dataIndex") ? data.indexOfRawIndex(parsedFinder.dataIndex) : null;
		return dataIndexInside != null ? getItemVisualFromData(data, dataIndexInside, visualType) : getVisualFromData(data, visualType);
	};
	/**
	
	* Get view of corresponding component model
	
	*/
	ECharts$2.prototype.getViewOfComponentModel = function(componentModel) {
		return this._componentsMap[componentModel.__viewId];
	};
	/**
	
	* Get view of corresponding series model
	
	*/
	ECharts$2.prototype.getViewOfSeriesModel = function(seriesModel) {
		return this._chartsMap[seriesModel.__viewId];
	};
	ECharts$2.prototype._initEvents = function() {
		var _this = this;
		each$4(MOUSE_EVENT_NAMES, function(eveName) {
			var handler = function(e$1) {
				var ecModel = _this.getModel();
				var el = e$1.target;
				var params;
				var isGlobalOut = eveName === "globalout";
				if (isGlobalOut) params = {};
				else el && findEventDispatcher(el, function(parent) {
					var ecData = getECData(parent);
					if (ecData && ecData.dataIndex != null) {
						var dataModel = ecData.dataModel || ecModel.getSeriesByIndex(ecData.seriesIndex);
						params = dataModel && dataModel.getDataParams(ecData.dataIndex, ecData.dataType, el) || {};
						return true;
					} else if (ecData.eventData) {
						params = extend({}, ecData.eventData);
						return true;
					}
				}, true);
				if (params) {
					var componentType = params.componentType;
					var componentIndex = params.componentIndex;
					if (componentType === "markLine" || componentType === "markPoint" || componentType === "markArea") {
						componentType = "series";
						componentIndex = params.seriesIndex;
					}
					var model = componentType && componentIndex != null && ecModel.getComponent(componentType, componentIndex);
					var view = model && _this[model.mainType === "series" ? "_chartsMap" : "_componentsMap"][model.__viewId];
					params.event = e$1;
					params.type = eveName;
					_this._$eventProcessor.eventInfo = {
						targetEl: el,
						packedEvent: params,
						model,
						view
					};
					_this.trigger(eveName, params);
				}
			};
			handler.zrEventfulCallAtLast = true;
			_this._zr.on(eveName, handler, _this);
		});
		each$4(eventActionMap, function(actionType, eventType) {
			_this._messageCenter.on(eventType, function(event) {
				this.trigger(eventType, event);
			}, _this);
		});
		each$4(["selectchanged"], function(eventType) {
			_this._messageCenter.on(eventType, function(event) {
				this.trigger(eventType, event);
			}, _this);
		});
		handleLegacySelectEvents(this._messageCenter, this, this._api);
	};
	ECharts$2.prototype.isDisposed = function() {
		return this._disposed;
	};
	ECharts$2.prototype.clear = function() {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		this.setOption({ series: [] }, true);
	};
	ECharts$2.prototype.dispose = function() {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		this._disposed = true;
		var dom = this.getDom();
		if (dom) setAttribute(this.getDom(), DOM_ATTRIBUTE_KEY, "");
		var chart = this;
		var api = chart._api;
		var ecModel = chart._model;
		each$4(chart._componentsViews, function(component) {
			component.dispose(ecModel, api);
		});
		each$4(chart._chartsViews, function(chart$1) {
			chart$1.dispose(ecModel, api);
		});
		chart._zr.dispose();
		chart._dom = chart._model = chart._chartsMap = chart._componentsMap = chart._chartsViews = chart._componentsViews = chart._scheduler = chart._api = chart._zr = chart._throttledZrFlush = chart._theme = chart._coordSysMgr = chart._messageCenter = null;
		delete instances[chart.id];
	};
	/**
	
	* Resize the chart
	
	*/
	ECharts$2.prototype.resize = function(opts) {
		if (this[IN_MAIN_PROCESS_KEY]) return;
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		this._zr.resize(opts);
		var ecModel = this._model;
		this._loadingFX && this._loadingFX.resize();
		if (!ecModel) return;
		var needPrepare = ecModel.resetOption("media");
		var silent = opts && opts.silent;
		if (this[PENDING_UPDATE]) {
			if (silent == null) silent = this[PENDING_UPDATE].silent;
			needPrepare = true;
			this[PENDING_UPDATE] = null;
		}
		this[IN_MAIN_PROCESS_KEY] = true;
		try {
			needPrepare && prepare(this);
			updateMethods.update.call(this, {
				type: "resize",
				animation: extend({ duration: 0 }, opts && opts.animation)
			});
		} catch (e$1) {
			this[IN_MAIN_PROCESS_KEY] = false;
			throw e$1;
		}
		this[IN_MAIN_PROCESS_KEY] = false;
		flushPendingActions.call(this, silent);
		triggerUpdatedEvent.call(this, silent);
	};
	ECharts$2.prototype.showLoading = function(name, cfg) {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		if (isObject$2(name)) {
			cfg = name;
			name = "";
		}
		name = name || "default";
		this.hideLoading();
		if (!loadingEffects[name]) return;
		var el = loadingEffects[name](this._api, cfg);
		var zr = this._zr;
		this._loadingFX = el;
		zr.add(el);
	};
	/**
	
	* Hide loading effect
	
	*/
	ECharts$2.prototype.hideLoading = function() {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		this._loadingFX && this._zr.remove(this._loadingFX);
		this._loadingFX = null;
	};
	ECharts$2.prototype.makeActionFromEvent = function(eventObj) {
		var payload = extend({}, eventObj);
		payload.type = eventActionMap[eventObj.type];
		return payload;
	};
	/**
	
	* @param opt If pass boolean, means opt.silent
	
	* @param opt.silent Default `false`. Whether trigger events.
	
	* @param opt.flush Default `undefined`.
	
	*        true: Flush immediately, and then pixel in canvas can be fetched
	
	*            immediately. Caution: it might affect performance.
	
	*        false: Not flush.
	
	*        undefined: Auto decide whether perform flush.
	
	*/
	ECharts$2.prototype.dispatchAction = function(payload, opt) {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		if (!isObject$2(opt)) opt = { silent: !!opt };
		if (!actions[payload.type]) return;
		if (!this._model) return;
		if (this[IN_MAIN_PROCESS_KEY]) {
			this._pendingActions.push(payload);
			return;
		}
		var silent = opt.silent;
		doDispatchAction.call(this, payload, silent);
		var flush = opt.flush;
		if (flush) this._zr.flush();
		else if (flush !== false && env_default.browser.weChat) this._throttledZrFlush();
		flushPendingActions.call(this, silent);
		triggerUpdatedEvent.call(this, silent);
	};
	ECharts$2.prototype.updateLabelLayout = function() {
		lifecycle_default.trigger("series:layoutlabels", this._model, this._api, { updatedSeries: [] });
	};
	ECharts$2.prototype.appendData = function(params) {
		if (this._disposed) {
			disposedWarning(this.id);
			return;
		}
		var seriesIndex = params.seriesIndex;
		var ecModel = this.getModel();
		var seriesModel = ecModel.getSeriesByIndex(seriesIndex);
		seriesModel.appendData(params);
		this._scheduler.unfinished = true;
		this.getZr().wakeUp();
	};
	ECharts$2.internalField = function() {
		prepare = function(ecIns) {
			var scheduler = ecIns._scheduler;
			scheduler.restorePipelines(ecIns._model);
			scheduler.prepareStageTasks();
			prepareView(ecIns, true);
			prepareView(ecIns, false);
			scheduler.plan();
		};
		/**
		
		* Prepare view instances of charts and components
		
		*/
		prepareView = function(ecIns, isComponent) {
			var ecModel = ecIns._model;
			var scheduler = ecIns._scheduler;
			var viewList = isComponent ? ecIns._componentsViews : ecIns._chartsViews;
			var viewMap = isComponent ? ecIns._componentsMap : ecIns._chartsMap;
			var zr = ecIns._zr;
			var api = ecIns._api;
			for (var i = 0; i < viewList.length; i++) viewList[i].__alive = false;
			isComponent ? ecModel.eachComponent(function(componentType, model) {
				componentType !== "series" && doPrepare(model);
			}) : ecModel.eachSeries(doPrepare);
			function doPrepare(model) {
				var requireNewView = model.__requireNewView;
				model.__requireNewView = false;
				var viewId = "_ec_" + model.id + "_" + model.type;
				var view$1 = !requireNewView && viewMap[viewId];
				if (!view$1) {
					var classType = parseClassType(model.type);
					var Clazz = isComponent ? Component_default.getClass(classType.main, classType.sub) : Chart_default.getClass(classType.sub);
					view$1 = new Clazz();
					view$1.init(ecModel, api);
					viewMap[viewId] = view$1;
					viewList.push(view$1);
					zr.add(view$1.group);
				}
				model.__viewId = view$1.__id = viewId;
				view$1.__alive = true;
				view$1.__model = model;
				view$1.group.__ecComponentInfo = {
					mainType: model.mainType,
					index: model.componentIndex
				};
				!isComponent && scheduler.prepareView(view$1, model, ecModel, api);
			}
			for (var i = 0; i < viewList.length;) {
				var view = viewList[i];
				if (!view.__alive) {
					!isComponent && view.renderTask.dispose();
					zr.remove(view.group);
					view.dispose(ecModel, api);
					viewList.splice(i, 1);
					if (viewMap[view.__id] === view) delete viewMap[view.__id];
					view.__id = view.group.__ecComponentInfo = null;
				} else i++;
			}
		};
		updateDirectly = function(ecIns, method, payload, mainType, subType) {
			var ecModel = ecIns._model;
			ecModel.setUpdatePayload(payload);
			if (!mainType) {
				each$4([].concat(ecIns._componentsViews).concat(ecIns._chartsViews), callView);
				return;
			}
			var query = {};
			query[mainType + "Id"] = payload[mainType + "Id"];
			query[mainType + "Index"] = payload[mainType + "Index"];
			query[mainType + "Name"] = payload[mainType + "Name"];
			var condition = {
				mainType,
				query
			};
			subType && (condition.subType = subType);
			var excludeSeriesId = payload.excludeSeriesId;
			var excludeSeriesIdMap;
			if (excludeSeriesId != null) {
				excludeSeriesIdMap = createHashMap();
				each$4(normalizeToArray(excludeSeriesId), function(id) {
					var modelId = convertOptionIdName(id, null);
					if (modelId != null) excludeSeriesIdMap.set(modelId, true);
				});
			}
			ecModel && ecModel.eachComponent(condition, function(model) {
				var isExcluded = excludeSeriesIdMap && excludeSeriesIdMap.get(model.id) != null;
				if (isExcluded) return;
				if (isHighDownPayload(payload)) if (model instanceof Series_default) {
					if (payload.type === HIGHLIGHT_ACTION_TYPE && !payload.notBlur && !model.get(["emphasis", "disabled"])) blurSeriesFromHighlightPayload(model, payload, ecIns._api);
				} else {
					var _a$1 = findComponentHighDownDispatchers(model.mainType, model.componentIndex, payload.name, ecIns._api), focusSelf = _a$1.focusSelf, dispatchers = _a$1.dispatchers;
					if (payload.type === HIGHLIGHT_ACTION_TYPE && focusSelf && !payload.notBlur) blurComponent(model.mainType, model.componentIndex, ecIns._api);
					if (dispatchers) each$4(dispatchers, function(dispatcher) {
						payload.type === HIGHLIGHT_ACTION_TYPE ? enterEmphasis(dispatcher) : leaveEmphasis(dispatcher);
					});
				}
				else if (isSelectChangePayload(payload)) {
					if (model instanceof Series_default) {
						toggleSelectionFromPayload(model, payload, ecIns._api);
						updateSeriesElementSelection(model);
						markStatusToUpdate(ecIns);
					}
				}
			}, ecIns);
			ecModel && ecModel.eachComponent(condition, function(model) {
				var isExcluded = excludeSeriesIdMap && excludeSeriesIdMap.get(model.id) != null;
				if (isExcluded) return;
				callView(ecIns[mainType === "series" ? "_chartsMap" : "_componentsMap"][model.__viewId]);
			}, ecIns);
			function callView(view) {
				view && view.__alive && view[method] && view[method](view.__model, ecModel, ecIns._api, payload);
			}
		};
		updateMethods = {
			prepareAndUpdate: function(payload) {
				prepare(this);
				updateMethods.update.call(this, payload, { optionChanged: payload.newOption != null });
			},
			update: function(payload, updateParams) {
				var ecModel = this._model;
				var api = this._api;
				var zr = this._zr;
				var coordSysMgr = this._coordSysMgr;
				var scheduler = this._scheduler;
				if (!ecModel) return;
				ecModel.setUpdatePayload(payload);
				scheduler.restoreData(ecModel, payload);
				scheduler.performSeriesTasks(ecModel);
				coordSysMgr.create(ecModel, api);
				scheduler.performDataProcessorTasks(ecModel, payload);
				updateStreamModes(this, ecModel);
				coordSysMgr.update(ecModel, api);
				clearColorPalette(ecModel);
				scheduler.performVisualTasks(ecModel, payload);
				render(this, ecModel, api, payload, updateParams);
				var backgroundColor$1 = ecModel.get("backgroundColor") || "transparent";
				var darkMode = ecModel.get("darkMode");
				zr.setBackgroundColor(backgroundColor$1);
				if (darkMode != null && darkMode !== "auto") zr.setDarkMode(darkMode);
				lifecycle_default.trigger("afterupdate", ecModel, api);
			},
			updateTransform: function(payload) {
				var _this = this;
				var ecModel = this._model;
				var api = this._api;
				if (!ecModel) return;
				ecModel.setUpdatePayload(payload);
				var componentDirtyList = [];
				ecModel.eachComponent(function(componentType, componentModel) {
					if (componentType === "series") return;
					var componentView = _this.getViewOfComponentModel(componentModel);
					if (componentView && componentView.__alive) if (componentView.updateTransform) {
						var result = componentView.updateTransform(componentModel, ecModel, api, payload);
						result && result.update && componentDirtyList.push(componentView);
					} else componentDirtyList.push(componentView);
				});
				var seriesDirtyMap = createHashMap();
				ecModel.eachSeries(function(seriesModel) {
					var chartView = _this._chartsMap[seriesModel.__viewId];
					if (chartView.updateTransform) {
						var result = chartView.updateTransform(seriesModel, ecModel, api, payload);
						result && result.update && seriesDirtyMap.set(seriesModel.uid, 1);
					} else seriesDirtyMap.set(seriesModel.uid, 1);
				});
				clearColorPalette(ecModel);
				this._scheduler.performVisualTasks(ecModel, payload, {
					setDirty: true,
					dirtyMap: seriesDirtyMap
				});
				renderSeries(this, ecModel, api, payload, {}, seriesDirtyMap);
				lifecycle_default.trigger("afterupdate", ecModel, api);
			},
			updateView: function(payload) {
				var ecModel = this._model;
				if (!ecModel) return;
				ecModel.setUpdatePayload(payload);
				Chart_default.markUpdateMethod(payload, "updateView");
				clearColorPalette(ecModel);
				this._scheduler.performVisualTasks(ecModel, payload, { setDirty: true });
				render(this, ecModel, this._api, payload, {});
				lifecycle_default.trigger("afterupdate", ecModel, this._api);
			},
			updateVisual: function(payload) {
				var _this = this;
				var ecModel = this._model;
				if (!ecModel) return;
				ecModel.setUpdatePayload(payload);
				ecModel.eachSeries(function(seriesModel) {
					seriesModel.getData().clearAllVisual();
				});
				Chart_default.markUpdateMethod(payload, "updateVisual");
				clearColorPalette(ecModel);
				this._scheduler.performVisualTasks(ecModel, payload, {
					visualType: "visual",
					setDirty: true
				});
				ecModel.eachComponent(function(componentType, componentModel) {
					if (componentType !== "series") {
						var componentView = _this.getViewOfComponentModel(componentModel);
						componentView && componentView.__alive && componentView.updateVisual(componentModel, ecModel, _this._api, payload);
					}
				});
				ecModel.eachSeries(function(seriesModel) {
					var chartView = _this._chartsMap[seriesModel.__viewId];
					chartView.updateVisual(seriesModel, ecModel, _this._api, payload);
				});
				lifecycle_default.trigger("afterupdate", ecModel, this._api);
			},
			updateLayout: function(payload) {
				updateMethods.update.call(this, payload);
			}
		};
		doConvertPixel = function(ecIns, methodName, finder, value) {
			if (ecIns._disposed) {
				disposedWarning(ecIns.id);
				return;
			}
			var ecModel = ecIns._model;
			var coordSysList = ecIns._coordSysMgr.getCoordinateSystems();
			var result;
			var parsedFinder = parseFinder(ecModel, finder);
			for (var i = 0; i < coordSysList.length; i++) {
				var coordSys = coordSysList[i];
				if (coordSys[methodName] && (result = coordSys[methodName](ecModel, parsedFinder, value)) != null) return result;
			}
		};
		updateStreamModes = function(ecIns, ecModel) {
			var chartsMap = ecIns._chartsMap;
			var scheduler = ecIns._scheduler;
			ecModel.eachSeries(function(seriesModel) {
				scheduler.updateStreamModes(seriesModel, chartsMap[seriesModel.__viewId]);
			});
		};
		doDispatchAction = function(payload, silent) {
			var _this = this;
			var ecModel = this.getModel();
			var payloadType = payload.type;
			var escapeConnect = payload.escapeConnect;
			var actionWrap = actions[payloadType];
			var actionInfo = actionWrap.actionInfo;
			var cptTypeTmp = (actionInfo.update || "update").split(":");
			var updateMethod = cptTypeTmp.pop();
			var cptType = cptTypeTmp[0] != null && parseClassType(cptTypeTmp[0]);
			this[IN_MAIN_PROCESS_KEY] = true;
			var payloads = [payload];
			var batched = false;
			if (payload.batch) {
				batched = true;
				payloads = map$1(payload.batch, function(item) {
					item = defaults(extend({}, item), payload);
					item.batch = null;
					return item;
				});
			}
			var eventObjBatch = [];
			var eventObj;
			var isSelectChange = isSelectChangePayload(payload);
			var isHighDown = isHighDownPayload(payload);
			if (isHighDown) allLeaveBlur(this._api);
			each$4(payloads, function(batchItem) {
				eventObj = actionWrap.action(batchItem, _this._model, _this._api);
				eventObj = eventObj || extend({}, batchItem);
				eventObj.type = actionInfo.event || eventObj.type;
				eventObjBatch.push(eventObj);
				if (isHighDown) {
					var _a$1 = preParseFinder(payload), queryOptionMap = _a$1.queryOptionMap, mainTypeSpecified = _a$1.mainTypeSpecified;
					var componentMainType = mainTypeSpecified ? queryOptionMap.keys()[0] : "series";
					updateDirectly(_this, updateMethod, batchItem, componentMainType);
					markStatusToUpdate(_this);
				} else if (isSelectChange) {
					updateDirectly(_this, updateMethod, batchItem, "series");
					markStatusToUpdate(_this);
				} else if (cptType) updateDirectly(_this, updateMethod, batchItem, cptType.main, cptType.sub);
			});
			if (updateMethod !== "none" && !isHighDown && !isSelectChange && !cptType) try {
				if (this[PENDING_UPDATE]) {
					prepare(this);
					updateMethods.update.call(this, payload);
					this[PENDING_UPDATE] = null;
				} else updateMethods[updateMethod].call(this, payload);
			} catch (e$1) {
				this[IN_MAIN_PROCESS_KEY] = false;
				throw e$1;
			}
			if (batched) eventObj = {
				type: actionInfo.event || payloadType,
				escapeConnect,
				batch: eventObjBatch
			};
			else eventObj = eventObjBatch[0];
			this[IN_MAIN_PROCESS_KEY] = false;
			if (!silent) {
				var messageCenter = this._messageCenter;
				messageCenter.trigger(eventObj.type, eventObj);
				if (isSelectChange) {
					var newObj = {
						type: "selectchanged",
						escapeConnect,
						selected: getAllSelectedIndices(ecModel),
						isFromClick: payload.isFromClick || false,
						fromAction: payload.type,
						fromActionPayload: payload
					};
					messageCenter.trigger(newObj.type, newObj);
				}
			}
		};
		flushPendingActions = function(silent) {
			var pendingActions = this._pendingActions;
			while (pendingActions.length) {
				var payload = pendingActions.shift();
				doDispatchAction.call(this, payload, silent);
			}
		};
		triggerUpdatedEvent = function(silent) {
			!silent && this.trigger("updated");
		};
		/**
		
		* Event `rendered` is triggered when zr
		
		* rendered. It is useful for realtime
		
		* snapshot (reflect animation).
		
		*
		
		* Event `finished` is triggered when:
		
		* (1) zrender rendering finished.
		
		* (2) initial animation finished.
		
		* (3) progressive rendering finished.
		
		* (4) no pending action.
		
		* (5) no delayed setOption needs to be processed.
		
		*/
		bindRenderedEvent = function(zr, ecIns) {
			zr.on("rendered", function(params) {
				ecIns.trigger("rendered", params);
				if (zr.animation.isFinished() && !ecIns[PENDING_UPDATE] && !ecIns._scheduler.unfinished && !ecIns._pendingActions.length) ecIns.trigger("finished");
			});
		};
		bindMouseEvent = function(zr, ecIns) {
			zr.on("mouseover", function(e$1) {
				var el = e$1.target;
				var dispatcher = findEventDispatcher(el, isHighDownDispatcher);
				if (dispatcher) {
					handleGlobalMouseOverForHighDown(dispatcher, e$1, ecIns._api);
					markStatusToUpdate(ecIns);
				}
			}).on("mouseout", function(e$1) {
				var el = e$1.target;
				var dispatcher = findEventDispatcher(el, isHighDownDispatcher);
				if (dispatcher) {
					handleGlobalMouseOutForHighDown(dispatcher, e$1, ecIns._api);
					markStatusToUpdate(ecIns);
				}
			}).on("click", function(e$1) {
				var el = e$1.target;
				var dispatcher = findEventDispatcher(el, function(target) {
					return getECData(target).dataIndex != null;
				}, true);
				if (dispatcher) {
					var actionType = dispatcher.selected ? "unselect" : "select";
					var ecData = getECData(dispatcher);
					ecIns._api.dispatchAction({
						type: actionType,
						dataType: ecData.dataType,
						dataIndexInside: ecData.dataIndex,
						seriesIndex: ecData.seriesIndex,
						isFromClick: true
					});
				}
			});
		};
		function clearColorPalette(ecModel) {
			ecModel.clearColorPalette();
			ecModel.eachSeries(function(seriesModel) {
				seriesModel.clearColorPalette();
			});
		}
		function allocateZlevels(ecModel) {
			var componentZLevels = [];
			var seriesZLevels = [];
			var hasSeparateZLevel = false;
			ecModel.eachComponent(function(componentType, componentModel) {
				var zlevel = componentModel.get("zlevel") || 0;
				var z = componentModel.get("z") || 0;
				var zlevelKey = componentModel.getZLevelKey();
				hasSeparateZLevel = hasSeparateZLevel || !!zlevelKey;
				(componentType === "series" ? seriesZLevels : componentZLevels).push({
					zlevel,
					z,
					idx: componentModel.componentIndex,
					type: componentType,
					key: zlevelKey
				});
			});
			if (hasSeparateZLevel) {
				var zLevels = componentZLevels.concat(seriesZLevels);
				var lastSeriesZLevel_1;
				var lastSeriesKey_1;
				sort(zLevels, function(a, b) {
					if (a.zlevel === b.zlevel) return a.z - b.z;
					return a.zlevel - b.zlevel;
				});
				each$4(zLevels, function(item) {
					var componentModel = ecModel.getComponent(item.type, item.idx);
					var zlevel = item.zlevel;
					var key = item.key;
					if (lastSeriesZLevel_1 != null) zlevel = Math.max(lastSeriesZLevel_1, zlevel);
					if (key) {
						if (zlevel === lastSeriesZLevel_1 && key !== lastSeriesKey_1) zlevel++;
						lastSeriesKey_1 = key;
					} else if (lastSeriesKey_1) {
						if (zlevel === lastSeriesZLevel_1) zlevel++;
						lastSeriesKey_1 = "";
					}
					lastSeriesZLevel_1 = zlevel;
					componentModel.setZLevel(zlevel);
				});
			}
		}
		render = function(ecIns, ecModel, api, payload, updateParams) {
			allocateZlevels(ecModel);
			renderComponents(ecIns, ecModel, api, payload, updateParams);
			each$4(ecIns._chartsViews, function(chart) {
				chart.__alive = false;
			});
			renderSeries(ecIns, ecModel, api, payload, updateParams);
			each$4(ecIns._chartsViews, function(chart) {
				if (!chart.__alive) chart.remove(ecModel, api);
			});
		};
		renderComponents = function(ecIns, ecModel, api, payload, updateParams, dirtyList) {
			each$4(dirtyList || ecIns._componentsViews, function(componentView) {
				var componentModel = componentView.__model;
				clearStates(componentModel, componentView);
				componentView.render(componentModel, ecModel, api, payload);
				updateZ(componentModel, componentView);
				updateStates(componentModel, componentView);
			});
		};
		/**
		
		* Render each chart and component
		
		*/
		renderSeries = function(ecIns, ecModel, api, payload, updateParams, dirtyMap) {
			var scheduler = ecIns._scheduler;
			updateParams = extend(updateParams || {}, { updatedSeries: ecModel.getSeries() });
			lifecycle_default.trigger("series:beforeupdate", ecModel, api, updateParams);
			var unfinished = false;
			ecModel.eachSeries(function(seriesModel) {
				var chartView = ecIns._chartsMap[seriesModel.__viewId];
				chartView.__alive = true;
				var renderTask = chartView.renderTask;
				scheduler.updatePayload(renderTask, payload);
				clearStates(seriesModel, chartView);
				if (dirtyMap && dirtyMap.get(seriesModel.uid)) renderTask.dirty();
				if (renderTask.perform(scheduler.getPerformArgs(renderTask))) unfinished = true;
				chartView.group.silent = !!seriesModel.get("silent");
				updateBlend(seriesModel, chartView);
				updateSeriesElementSelection(seriesModel);
			});
			scheduler.unfinished = unfinished || scheduler.unfinished;
			lifecycle_default.trigger("series:layoutlabels", ecModel, api, updateParams);
			lifecycle_default.trigger("series:transition", ecModel, api, updateParams);
			ecModel.eachSeries(function(seriesModel) {
				var chartView = ecIns._chartsMap[seriesModel.__viewId];
				updateZ(seriesModel, chartView);
				updateStates(seriesModel, chartView);
			});
			updateHoverLayerStatus(ecIns, ecModel);
			lifecycle_default.trigger("series:afterupdate", ecModel, api, updateParams);
		};
		markStatusToUpdate = function(ecIns) {
			ecIns[STATUS_NEEDS_UPDATE_KEY] = true;
			ecIns.getZr().wakeUp();
		};
		applyChangedStates = function(ecIns) {
			if (!ecIns[STATUS_NEEDS_UPDATE_KEY]) return;
			ecIns.getZr().storage.traverse(function(el) {
				if (isElementRemoved(el)) return;
				applyElementStates(el);
			});
			ecIns[STATUS_NEEDS_UPDATE_KEY] = false;
		};
		function applyElementStates(el) {
			var newStates = [];
			var oldStates = el.currentStates;
			for (var i = 0; i < oldStates.length; i++) {
				var stateName = oldStates[i];
				if (!(stateName === "emphasis" || stateName === "blur" || stateName === "select")) newStates.push(stateName);
			}
			if (el.selected && el.states.select) newStates.push("select");
			if (el.hoverState === HOVER_STATE_EMPHASIS && el.states.emphasis) newStates.push("emphasis");
			else if (el.hoverState === HOVER_STATE_BLUR && el.states.blur) newStates.push("blur");
			el.useStates(newStates);
		}
		function updateHoverLayerStatus(ecIns, ecModel) {
			var zr = ecIns._zr;
			var storage = zr.storage;
			var elCount = 0;
			storage.traverse(function(el) {
				if (!el.isGroup) elCount++;
			});
			if (elCount > ecModel.get("hoverLayerThreshold") && !env_default.node && !env_default.worker) ecModel.eachSeries(function(seriesModel) {
				if (seriesModel.preventUsingHoverLayer) return;
				var chartView = ecIns._chartsMap[seriesModel.__viewId];
				if (chartView.__alive) chartView.eachRendered(function(el) {
					if (el.states.emphasis) el.states.emphasis.hoverLayer = true;
				});
			});
		}
		/**
		
		* Update chart and blend.
		
		*/
		function updateBlend(seriesModel, chartView) {
			var blendMode = seriesModel.get("blendMode") || null;
			chartView.eachRendered(function(el) {
				if (!el.isGroup) el.style.blend = blendMode;
			});
		}
		function updateZ(model, view) {
			if (model.preventAutoZ) return;
			var z = model.get("z") || 0;
			var zlevel = model.get("zlevel") || 0;
			view.eachRendered(function(el) {
				doUpdateZ(el, z, zlevel, -Infinity);
				return true;
			});
		}
		function doUpdateZ(el, z, zlevel, maxZ2) {
			var label = el.getTextContent();
			var labelLine = el.getTextGuideLine();
			var isGroup = el.isGroup;
			if (isGroup) {
				var children = el.childrenRef();
				for (var i = 0; i < children.length; i++) maxZ2 = Math.max(doUpdateZ(children[i], z, zlevel, maxZ2), maxZ2);
			} else {
				el.z = z;
				el.zlevel = zlevel;
				maxZ2 = Math.max(el.z2, maxZ2);
			}
			if (label) {
				label.z = z;
				label.zlevel = zlevel;
				isFinite(maxZ2) && (label.z2 = maxZ2 + 2);
			}
			if (labelLine) {
				var textGuideLineConfig = el.textGuideLineConfig;
				labelLine.z = z;
				labelLine.zlevel = zlevel;
				isFinite(maxZ2) && (labelLine.z2 = maxZ2 + (textGuideLineConfig && textGuideLineConfig.showAbove ? 1 : -1));
			}
			return maxZ2;
		}
		function clearStates(model, view) {
			view.eachRendered(function(el) {
				if (isElementRemoved(el)) return;
				var textContent = el.getTextContent();
				var textGuide = el.getTextGuideLine();
				if (el.stateTransition) el.stateTransition = null;
				if (textContent && textContent.stateTransition) textContent.stateTransition = null;
				if (textGuide && textGuide.stateTransition) textGuide.stateTransition = null;
				if (el.hasState()) {
					el.prevStates = el.currentStates;
					el.clearStates();
				} else if (el.prevStates) el.prevStates = null;
			});
		}
		function updateStates(model, view) {
			var stateAnimationModel = model.getModel("stateAnimation");
			var enableAnimation = model.isAnimationEnabled();
			var duration = stateAnimationModel.get("duration");
			var stateTransition = duration > 0 ? {
				duration,
				delay: stateAnimationModel.get("delay"),
				easing: stateAnimationModel.get("easing")
			} : null;
			view.eachRendered(function(el) {
				if (el.states && el.states.emphasis) {
					if (isElementRemoved(el)) return;
					if (el instanceof Path_default) savePathStates(el);
					if (el.__dirty) {
						var prevStates = el.prevStates;
						if (prevStates) el.useStates(prevStates);
					}
					if (enableAnimation) {
						el.stateTransition = stateTransition;
						var textContent = el.getTextContent();
						var textGuide = el.getTextGuideLine();
						if (textContent) textContent.stateTransition = stateTransition;
						if (textGuide) textGuide.stateTransition = stateTransition;
					}
					if (el.__dirty) applyElementStates(el);
				}
			});
		}
		createExtensionAPI = function(ecIns) {
			return new (function(_super$1) {
				__extends(class_1, _super$1);
				function class_1() {
					return _super$1 !== null && _super$1.apply(this, arguments) || this;
				}
				class_1.prototype.getCoordinateSystems = function() {
					return ecIns._coordSysMgr.getCoordinateSystems();
				};
				class_1.prototype.getComponentByElement = function(el) {
					while (el) {
						var modelInfo = el.__ecComponentInfo;
						if (modelInfo != null) return ecIns._model.getComponent(modelInfo.mainType, modelInfo.index);
						el = el.parent;
					}
				};
				class_1.prototype.enterEmphasis = function(el, highlightDigit) {
					enterEmphasis(el, highlightDigit);
					markStatusToUpdate(ecIns);
				};
				class_1.prototype.leaveEmphasis = function(el, highlightDigit) {
					leaveEmphasis(el, highlightDigit);
					markStatusToUpdate(ecIns);
				};
				class_1.prototype.enterBlur = function(el) {
					enterBlur(el);
					markStatusToUpdate(ecIns);
				};
				class_1.prototype.leaveBlur = function(el) {
					leaveBlur(el);
					markStatusToUpdate(ecIns);
				};
				class_1.prototype.enterSelect = function(el) {
					enterSelect(el);
					markStatusToUpdate(ecIns);
				};
				class_1.prototype.leaveSelect = function(el) {
					leaveSelect(el);
					markStatusToUpdate(ecIns);
				};
				class_1.prototype.getModel = function() {
					return ecIns.getModel();
				};
				class_1.prototype.getViewOfComponentModel = function(componentModel) {
					return ecIns.getViewOfComponentModel(componentModel);
				};
				class_1.prototype.getViewOfSeriesModel = function(seriesModel) {
					return ecIns.getViewOfSeriesModel(seriesModel);
				};
				return class_1;
			}(ExtensionAPI_default))(ecIns);
		};
		enableConnect = function(chart) {
			function updateConnectedChartsStatus(charts, status) {
				for (var i = 0; i < charts.length; i++) {
					var otherChart = charts[i];
					otherChart[CONNECT_STATUS_KEY] = status;
				}
			}
			each$4(eventActionMap, function(actionType, eventType) {
				chart._messageCenter.on(eventType, function(event) {
					if (connectedGroups[chart.group] && chart[CONNECT_STATUS_KEY] !== CONNECT_STATUS_PENDING) {
						if (event && event.escapeConnect) return;
						var action_1 = chart.makeActionFromEvent(event);
						var otherCharts_1 = [];
						each$4(instances, function(otherChart) {
							if (otherChart !== chart && otherChart.group === chart.group) otherCharts_1.push(otherChart);
						});
						updateConnectedChartsStatus(otherCharts_1, CONNECT_STATUS_PENDING);
						each$4(otherCharts_1, function(otherChart) {
							if (otherChart[CONNECT_STATUS_KEY] !== CONNECT_STATUS_UPDATING) otherChart.dispatchAction(action_1);
						});
						updateConnectedChartsStatus(otherCharts_1, CONNECT_STATUS_UPDATED);
					}
				});
			});
		};
	}();
	return ECharts$2;
}(Eventful_default);
var echartsProto = ECharts$1.prototype;
echartsProto.on = createRegisterEventWithLowercaseECharts("on");
echartsProto.off = createRegisterEventWithLowercaseECharts("off");
/**

* @deprecated

*/
echartsProto.one = function(eventName, cb, ctx) {
	var self$1 = this;
	deprecateLog("ECharts#one is deprecated.");
	function wrapped() {
		var args2 = [];
		for (var _i = 0; _i < arguments.length; _i++) args2[_i] = arguments[_i];
		cb && cb.apply && cb.apply(this, args2);
		self$1.off(eventName, wrapped);
	}
	this.on.call(this, eventName, wrapped, ctx);
};
var MOUSE_EVENT_NAMES = [
	"click",
	"dblclick",
	"mouseover",
	"mouseout",
	"mousemove",
	"mousedown",
	"mouseup",
	"globalout",
	"contextmenu"
];
function disposedWarning(id) {}
var actions = {};
/**

* Map eventType to actionType

*/
var eventActionMap = {};
var dataProcessorFuncs = [];
var optionPreprocessorFuncs = [];
var visualFuncs = [];
var themeStorage = {};
var loadingEffects = {};
var instances = {};
var connectedGroups = {};
var idBase = +new Date() - 0;
var groupIdBase = +new Date() - 0;
var DOM_ATTRIBUTE_KEY = "_echarts_instance_";
function init(dom, theme$1, opts) {
	var isClient = !(opts && opts.ssr);
	if (isClient) {
		var existInstance = getInstanceByDom(dom);
		if (existInstance) return existInstance;
	}
	var chart = new ECharts$1(dom, theme$1, opts);
	chart.id = "ec_" + idBase++;
	instances[chart.id] = chart;
	isClient && setAttribute(dom, DOM_ATTRIBUTE_KEY, chart.id);
	enableConnect(chart);
	lifecycle_default.trigger("afterinit", chart);
	return chart;
}
function getInstanceByDom(dom) {
	return instances[getAttribute(dom, DOM_ATTRIBUTE_KEY)];
}
function registerTheme(name, theme$1) {
	themeStorage[name] = theme$1;
}
function registerPreprocessor(preprocessorFunc) {
	if (indexOf(optionPreprocessorFuncs, preprocessorFunc) < 0) optionPreprocessorFuncs.push(preprocessorFunc);
}
function registerProcessor(priority, processor) {
	normalizeRegister(dataProcessorFuncs, priority, processor, PRIORITY_PROCESSOR_DEFAULT);
}
function registerPostInit(postInitFunc) {
	registerUpdateLifecycle("afterinit", postInitFunc);
}
function registerPostUpdate(postUpdateFunc) {
	registerUpdateLifecycle("afterupdate", postUpdateFunc);
}
function registerUpdateLifecycle(name, cb) {
	lifecycle_default.on(name, cb);
}
function registerAction(actionInfo, eventName, action) {
	if (isFunction(eventName)) {
		action = eventName;
		eventName = "";
	}
	var actionType = isObject$2(actionInfo) ? actionInfo.type : [actionInfo, actionInfo = { event: eventName }][0];
	actionInfo.event = (actionInfo.event || actionType).toLowerCase();
	eventName = actionInfo.event;
	if (eventActionMap[eventName]) return;
	assert(ACTION_REG.test(actionType) && ACTION_REG.test(eventName));
	if (!actions[actionType]) actions[actionType] = {
		action,
		actionInfo
	};
	eventActionMap[eventName] = actionType;
}
function registerCoordinateSystem(type, coordSysCreator) {
	CoordinateSystem_default.register(type, coordSysCreator);
}
function registerLayout(priority, layoutTask) {
	normalizeRegister(visualFuncs, priority, layoutTask, PRIORITY_VISUAL_LAYOUT, "layout");
}
function registerVisual(priority, visualTask) {
	normalizeRegister(visualFuncs, priority, visualTask, PRIORITY_VISUAL_CHART, "visual");
}
var registeredTasks = [];
function normalizeRegister(targetList, priority, fn, defaultPriority, visualType) {
	if (isFunction(priority) || isObject$2(priority)) {
		fn = priority;
		priority = defaultPriority;
	}
	if (indexOf(registeredTasks, fn) >= 0) return;
	registeredTasks.push(fn);
	var stageHandler = Scheduler_default.wrapStageHandler(fn, visualType);
	stageHandler.__prio = priority;
	stageHandler.__raw = fn;
	targetList.push(stageHandler);
}
function registerLoading(name, loadingFx) {
	loadingEffects[name] = loadingFx;
}
function registerMap(mapName, geoJson, specialAreas) {
	var registerMap$1 = getImpl("registerMap");
	registerMap$1 && registerMap$1(mapName, geoJson, specialAreas);
}
var registerTransform = registerExternalTransform;
/**

* Globa dispatchAction to a specified chart instance.

*/
registerVisual(PRIORITY_VISUAL_GLOBAL, seriesStyleTask);
registerVisual(PRIORITY_VISUAL_CHART_DATA_CUSTOM, dataStyleTask);
registerVisual(PRIORITY_VISUAL_CHART_DATA_CUSTOM, dataColorPaletteTask);
registerVisual(PRIORITY_VISUAL_GLOBAL, seriesSymbolTask);
registerVisual(PRIORITY_VISUAL_CHART_DATA_CUSTOM, dataSymbolTask);
registerVisual(PRIORITY_VISUAL_DECAL, decalVisual);
registerPreprocessor(globalBackwardCompat);
registerProcessor(PRIORITY_PROCESSOR_DATASTACK, dataStack);
registerLoading("default", defaultLoading);
registerAction({
	type: HIGHLIGHT_ACTION_TYPE,
	event: HIGHLIGHT_ACTION_TYPE,
	update: HIGHLIGHT_ACTION_TYPE
}, noop);
registerAction({
	type: DOWNPLAY_ACTION_TYPE,
	event: DOWNPLAY_ACTION_TYPE,
	update: DOWNPLAY_ACTION_TYPE
}, noop);
registerAction({
	type: SELECT_ACTION_TYPE,
	event: SELECT_ACTION_TYPE,
	update: SELECT_ACTION_TYPE
}, noop);
registerAction({
	type: UNSELECT_ACTION_TYPE,
	event: UNSELECT_ACTION_TYPE,
	update: UNSELECT_ACTION_TYPE
}, noop);
registerAction({
	type: TOGGLE_SELECT_ACTION_TYPE,
	event: TOGGLE_SELECT_ACTION_TYPE,
	update: TOGGLE_SELECT_ACTION_TYPE
}, noop);
registerTheme("light", light_default);
registerTheme("dark", dark_default);
var extensions = [];
var extensionRegisters = {
	registerPreprocessor,
	registerProcessor,
	registerPostInit,
	registerPostUpdate,
	registerUpdateLifecycle,
	registerAction,
	registerCoordinateSystem,
	registerLayout,
	registerVisual,
	registerTransform,
	registerLoading,
	registerMap,
	registerImpl,
	PRIORITY,
	ComponentModel: Component_default$1,
	ComponentView: Component_default,
	SeriesModel: Series_default,
	ChartView: Chart_default,
	registerComponentModel: function(ComponentModelClass) {
		Component_default$1.registerClass(ComponentModelClass);
	},
	registerComponentView: function(ComponentViewClass) {
		Component_default.registerClass(ComponentViewClass);
	},
	registerSeriesModel: function(SeriesModelClass) {
		Series_default.registerClass(SeriesModelClass);
	},
	registerChartView: function(ChartViewClass) {
		Chart_default.registerClass(ChartViewClass);
	},
	registerSubTypeDefaulter: function(componentType, defaulter) {
		Component_default$1.registerSubTypeDefaulter(componentType, defaulter);
	},
	registerPainter: function(painterType, PainterCtor) {
		registerPainter(painterType, PainterCtor);
	}
};
function use(ext) {
	if (isArray(ext)) {
		each$4(ext, function(singleExt) {
			use(singleExt);
		});
		return;
	}
	if (indexOf(extensions, ext) >= 0) return;
	extensions.push(ext);
	if (isFunction(ext)) ext = { install: ext };
	ext.install(extensionRegisters);
}
var GridModel = function(_super) {
	__extends(GridModel$1, _super);
	function GridModel$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	GridModel$1.type = "grid";
	GridModel$1.dependencies = ["xAxis", "yAxis"];
	GridModel$1.layoutMode = "box";
	GridModel$1.defaultOption = {
		show: false,
		z: 0,
		left: "10%",
		top: 60,
		right: "10%",
		bottom: 70,
		containLabel: false,
		backgroundColor: "rgba(0,0,0,0)",
		borderWidth: 1,
		borderColor: "#ccc"
	};
	return GridModel$1;
}(Component_default$1);
var GridModel_default = GridModel;
/**
* AUTO-GENERATED FILE. DO NOT MODIFY.
*/
var AxisModelCommonMixin = function() {
	function AxisModelCommonMixin$1() {}
	AxisModelCommonMixin$1.prototype.getNeedCrossZero = function() {
		var option = this.option;
		return !option.scale;
	};
	/**
	
	* Should be implemented by each axis model if necessary.
	
	* @return coordinate system model
	
	*/
	AxisModelCommonMixin$1.prototype.getCoordSysModel = function() {
		return;
	};
	return AxisModelCommonMixin$1;
}();
var CartesianAxisModel = function(_super) {
	__extends(CartesianAxisModel$1, _super);
	function CartesianAxisModel$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	CartesianAxisModel$1.prototype.getCoordSysModel = function() {
		return this.getReferringComponents("grid", SINGLE_REFERRING).models[0];
	};
	CartesianAxisModel$1.type = "cartesian2dAxis";
	return CartesianAxisModel$1;
}(Component_default$1);
mixin(CartesianAxisModel, AxisModelCommonMixin);
var defaultOption = {
	show: true,
	z: 0,
	inverse: false,
	name: "",
	nameLocation: "end",
	nameRotate: null,
	nameTruncate: {
		maxWidth: null,
		ellipsis: "...",
		placeholder: "."
	},
	nameTextStyle: {},
	nameGap: 15,
	silent: false,
	triggerEvent: false,
	tooltip: { show: false },
	axisPointer: {},
	axisLine: {
		show: true,
		onZero: true,
		onZeroAxisIndex: null,
		lineStyle: {
			color: "#6E7079",
			width: 1,
			type: "solid"
		},
		symbol: ["none", "none"],
		symbolSize: [10, 15]
	},
	axisTick: {
		show: true,
		inside: false,
		length: 5,
		lineStyle: { width: 1 }
	},
	axisLabel: {
		show: true,
		inside: false,
		rotate: 0,
		showMinLabel: null,
		showMaxLabel: null,
		margin: 8,
		fontSize: 12
	},
	splitLine: {
		show: true,
		showMinLine: true,
		showMaxLine: true,
		lineStyle: {
			color: ["#E0E6F1"],
			width: 1,
			type: "solid"
		}
	},
	splitArea: {
		show: false,
		areaStyle: { color: ["rgba(250,250,250,0.2)", "rgba(210,219,238,0.2)"] }
	}
};
var categoryAxis = merge({
	boundaryGap: true,
	deduplication: null,
	splitLine: { show: false },
	axisTick: {
		alignWithLabel: false,
		interval: "auto"
	},
	axisLabel: { interval: "auto" }
}, defaultOption);
var valueAxis = merge({
	boundaryGap: [0, 0],
	axisLine: { show: "auto" },
	axisTick: { show: "auto" },
	splitNumber: 5,
	minorTick: {
		show: false,
		splitNumber: 5,
		length: 3,
		lineStyle: {}
	},
	minorSplitLine: {
		show: false,
		lineStyle: {
			color: "#F4F7FD",
			width: 1
		}
	}
}, defaultOption);
var timeAxis = merge({
	splitNumber: 6,
	axisLabel: {
		showMinLabel: false,
		showMaxLabel: false,
		rich: { primary: { fontWeight: "bold" } }
	},
	splitLine: { show: false }
}, valueAxis);
var logAxis = defaults({ logBase: 10 }, valueAxis);
var axisDefault_default = {
	category: categoryAxis,
	value: valueAxis,
	time: timeAxis,
	log: logAxis
};
var uidBase = 0;
var OrdinalMeta = function() {
	function OrdinalMeta$1(opt) {
		this.categories = opt.categories || [];
		this._needCollect = opt.needCollect;
		this._deduplication = opt.deduplication;
		this.uid = ++uidBase;
	}
	OrdinalMeta$1.createByAxisModel = function(axisModel) {
		var option = axisModel.option;
		var data = option.data;
		var categories = data && map$1(data, getName);
		return new OrdinalMeta$1({
			categories,
			needCollect: !categories,
			deduplication: option.dedplication !== false
		});
	};
	OrdinalMeta$1.prototype.getOrdinal = function(category) {
		return this._getOrCreateMap().get(category);
	};
	/**
	
	* @return The ordinal. If not found, return NaN.
	
	*/
	OrdinalMeta$1.prototype.parseAndCollect = function(category) {
		var index;
		var needCollect = this._needCollect;
		if (!isString(category) && !needCollect) return category;
		if (needCollect && !this._deduplication) {
			index = this.categories.length;
			this.categories[index] = category;
			return index;
		}
		var map$2 = this._getOrCreateMap();
		index = map$2.get(category);
		if (index == null) if (needCollect) {
			index = this.categories.length;
			this.categories[index] = category;
			map$2.set(category, index);
		} else index = NaN;
		return index;
	};
	OrdinalMeta$1.prototype._getOrCreateMap = function() {
		return this._map || (this._map = createHashMap(this.categories));
	};
	return OrdinalMeta$1;
}();
function getName(obj) {
	if (isObject$2(obj) && obj.value != null) return obj.value;
	else return obj + "";
}
var OrdinalMeta_default = OrdinalMeta;
var AXIS_TYPES = {
	value: 1,
	category: 1,
	time: 1,
	log: 1
};
function axisModelCreator(registers, axisName, BaseAxisModelClass, extraDefaultOption) {
	each$4(AXIS_TYPES, function(v, axisType) {
		var defaultOption$1 = merge(merge({}, axisDefault_default[axisType], true), extraDefaultOption, true);
		var AxisModel = function(_super) {
			__extends(AxisModel$1, _super);
			function AxisModel$1() {
				var _this = _super !== null && _super.apply(this, arguments) || this;
				_this.type = axisName + "Axis." + axisType;
				return _this;
			}
			AxisModel$1.prototype.mergeDefaultAndTheme = function(option, ecModel) {
				var layoutMode = fetchLayoutMode(this);
				var inputPositionParams = layoutMode ? getLayoutParams(option) : {};
				var themeModel = ecModel.getTheme();
				merge(option, themeModel.get(axisType + "Axis"));
				merge(option, this.getDefaultOption());
				option.type = getAxisType(option);
				if (layoutMode) mergeLayoutParam(option, inputPositionParams, layoutMode);
			};
			AxisModel$1.prototype.optionUpdated = function() {
				var thisOption = this.option;
				if (thisOption.type === "category") this.__ordinalMeta = OrdinalMeta_default.createByAxisModel(this);
			};
			/**
			
			* Should not be called before all of 'getInitailData' finished.
			
			* Because categories are collected during initializing data.
			
			*/
			AxisModel$1.prototype.getCategories = function(rawData) {
				var option = this.option;
				if (option.type === "category") {
					if (rawData) return option.data;
					return this.__ordinalMeta.categories;
				}
			};
			AxisModel$1.prototype.getOrdinalMeta = function() {
				return this.__ordinalMeta;
			};
			AxisModel$1.type = axisName + "Axis." + axisType;
			AxisModel$1.defaultOption = defaultOption$1;
			return AxisModel$1;
		}(BaseAxisModelClass);
		registers.registerComponentModel(AxisModel);
	});
	registers.registerSubTypeDefaulter(axisName + "Axis", getAxisType);
}
function getAxisType(option) {
	return option.type || (option.data ? "category" : "value");
}
var Scale = function() {
	function Scale$1(setting) {
		this._setting = setting || {};
		this._extent = [Infinity, -Infinity];
	}
	Scale$1.prototype.getSetting = function(name) {
		return this._setting[name];
	};
	/**
	
	* Set extent from data
	
	*/
	Scale$1.prototype.unionExtent = function(other) {
		var extent$1 = this._extent;
		other[0] < extent$1[0] && (extent$1[0] = other[0]);
		other[1] > extent$1[1] && (extent$1[1] = other[1]);
	};
	/**
	
	* Set extent from data
	
	*/
	Scale$1.prototype.unionExtentFromData = function(data, dim) {
		this.unionExtent(data.getApproximateExtent(dim));
	};
	/**
	
	* Get extent
	
	*
	
	* Extent is always in increase order.
	
	*/
	Scale$1.prototype.getExtent = function() {
		return this._extent.slice();
	};
	/**
	
	* Set extent
	
	*/
	Scale$1.prototype.setExtent = function(start$1, end$1) {
		var thisExtent = this._extent;
		if (!isNaN(start$1)) thisExtent[0] = start$1;
		if (!isNaN(end$1)) thisExtent[1] = end$1;
	};
	/**
	
	* If value is in extent range
	
	*/
	Scale$1.prototype.isInExtentRange = function(value) {
		return this._extent[0] <= value && this._extent[1] >= value;
	};
	/**
	
	* When axis extent depends on data and no data exists,
	
	* axis ticks should not be drawn, which is named 'blank'.
	
	*/
	Scale$1.prototype.isBlank = function() {
		return this._isBlank;
	};
	/**
	
	* When axis extent depends on data and no data exists,
	
	* axis ticks should not be drawn, which is named 'blank'.
	
	*/
	Scale$1.prototype.setBlank = function(isBlank) {
		this._isBlank = isBlank;
	};
	return Scale$1;
}();
enableClassManagement(Scale);
var Scale_default = Scale;
function isIntervalOrLogScale(scale$3) {
	return scale$3.type === "interval" || scale$3.type === "log";
}
function intervalScaleNiceTicks(extent$1, splitNumber, minInterval, maxInterval) {
	var result = {};
	var span = extent$1[1] - extent$1[0];
	var interval = result.interval = nice(span / splitNumber, true);
	if (minInterval != null && interval < minInterval) interval = result.interval = minInterval;
	if (maxInterval != null && interval > maxInterval) interval = result.interval = maxInterval;
	var precision = result.intervalPrecision = getIntervalPrecision(interval);
	var niceTickExtent = result.niceTickExtent = [round(Math.ceil(extent$1[0] / interval) * interval, precision), round(Math.floor(extent$1[1] / interval) * interval, precision)];
	fixExtent(niceTickExtent, extent$1);
	return result;
}
function increaseInterval(interval) {
	var exp10 = Math.pow(10, quantityExponent(interval));
	var f = interval / exp10;
	if (!f) f = 1;
	else if (f === 2) f = 3;
	else if (f === 3) f = 5;
	else f *= 2;
	return round(f * exp10);
}
function getIntervalPrecision(interval) {
	return getPrecision(interval) + 2;
}
function clamp(niceTickExtent, idx, extent$1) {
	niceTickExtent[idx] = Math.max(Math.min(niceTickExtent[idx], extent$1[1]), extent$1[0]);
}
function fixExtent(niceTickExtent, extent$1) {
	!isFinite(niceTickExtent[0]) && (niceTickExtent[0] = extent$1[0]);
	!isFinite(niceTickExtent[1]) && (niceTickExtent[1] = extent$1[1]);
	clamp(niceTickExtent, 0, extent$1);
	clamp(niceTickExtent, 1, extent$1);
	if (niceTickExtent[0] > niceTickExtent[1]) niceTickExtent[0] = niceTickExtent[1];
}
function contain(val, extent$1) {
	return val >= extent$1[0] && val <= extent$1[1];
}
function normalize(val, extent$1) {
	if (extent$1[1] === extent$1[0]) return .5;
	return (val - extent$1[0]) / (extent$1[1] - extent$1[0]);
}
function scale(val, extent$1) {
	return val * (extent$1[1] - extent$1[0]) + extent$1[0];
}
var OrdinalScale = function(_super) {
	__extends(OrdinalScale$1, _super);
	function OrdinalScale$1(setting) {
		var _this = _super.call(this, setting) || this;
		_this.type = "ordinal";
		var ordinalMeta = _this.getSetting("ordinalMeta");
		if (!ordinalMeta) ordinalMeta = new OrdinalMeta_default({});
		if (isArray(ordinalMeta)) ordinalMeta = new OrdinalMeta_default({ categories: map$1(ordinalMeta, function(item) {
			return isObject$2(item) ? item.value : item;
		}) });
		_this._ordinalMeta = ordinalMeta;
		_this._extent = _this.getSetting("extent") || [0, ordinalMeta.categories.length - 1];
		return _this;
	}
	OrdinalScale$1.prototype.parse = function(val) {
		if (val == null) return NaN;
		return isString(val) ? this._ordinalMeta.getOrdinal(val) : Math.round(val);
	};
	OrdinalScale$1.prototype.contain = function(rank) {
		rank = this.parse(rank);
		return contain(rank, this._extent) && this._ordinalMeta.categories[rank] != null;
	};
	/**
	
	* Normalize given rank or name to linear [0, 1]
	
	* @param val raw ordinal number.
	
	* @return normalized value in [0, 1].
	
	*/
	OrdinalScale$1.prototype.normalize = function(val) {
		val = this._getTickNumber(this.parse(val));
		return normalize(val, this._extent);
	};
	/**
	
	* @param val normalized value in [0, 1].
	
	* @return raw ordinal number.
	
	*/
	OrdinalScale$1.prototype.scale = function(val) {
		val = Math.round(scale(val, this._extent));
		return this.getRawOrdinalNumber(val);
	};
	OrdinalScale$1.prototype.getTicks = function() {
		var ticks = [];
		var extent$1 = this._extent;
		var rank = extent$1[0];
		while (rank <= extent$1[1]) {
			ticks.push({ value: rank });
			rank++;
		}
		return ticks;
	};
	OrdinalScale$1.prototype.getMinorTicks = function(splitNumber) {
		return;
	};
	/**
	
	* @see `Ordinal['_ordinalNumbersByTick']`
	
	*/
	OrdinalScale$1.prototype.setSortInfo = function(info) {
		if (info == null) {
			this._ordinalNumbersByTick = this._ticksByOrdinalNumber = null;
			return;
		}
		var infoOrdinalNumbers = info.ordinalNumbers;
		var ordinalsByTick = this._ordinalNumbersByTick = [];
		var ticksByOrdinal = this._ticksByOrdinalNumber = [];
		var tickNum = 0;
		var allCategoryLen = this._ordinalMeta.categories.length;
		for (var len$1 = Math.min(allCategoryLen, infoOrdinalNumbers.length); tickNum < len$1; ++tickNum) {
			var ordinalNumber = infoOrdinalNumbers[tickNum];
			ordinalsByTick[tickNum] = ordinalNumber;
			ticksByOrdinal[ordinalNumber] = tickNum;
		}
		var unusedOrdinal = 0;
		for (; tickNum < allCategoryLen; ++tickNum) {
			while (ticksByOrdinal[unusedOrdinal] != null) unusedOrdinal++;
			ordinalsByTick.push(unusedOrdinal);
			ticksByOrdinal[unusedOrdinal] = tickNum;
		}
	};
	OrdinalScale$1.prototype._getTickNumber = function(ordinal) {
		var ticksByOrdinalNumber = this._ticksByOrdinalNumber;
		return ticksByOrdinalNumber && ordinal >= 0 && ordinal < ticksByOrdinalNumber.length ? ticksByOrdinalNumber[ordinal] : ordinal;
	};
	/**
	
	* @usage
	
	* ```js
	
	* const ordinalNumber = ordinalScale.getRawOrdinalNumber(tickVal);
	
	*
	
	* // case0
	
	* const rawOrdinalValue = axisModel.getCategories()[ordinalNumber];
	
	* // case1
	
	* const rawOrdinalValue = this._ordinalMeta.categories[ordinalNumber];
	
	* // case2
	
	* const coord = axis.dataToCoord(ordinalNumber);
	
	* ```
	
	*
	
	* @param {OrdinalNumber} tickNumber index of display
	
	*/
	OrdinalScale$1.prototype.getRawOrdinalNumber = function(tickNumber) {
		var ordinalNumbersByTick = this._ordinalNumbersByTick;
		return ordinalNumbersByTick && tickNumber >= 0 && tickNumber < ordinalNumbersByTick.length ? ordinalNumbersByTick[tickNumber] : tickNumber;
	};
	/**
	
	* Get item on tick
	
	*/
	OrdinalScale$1.prototype.getLabel = function(tick) {
		if (!this.isBlank()) {
			var ordinalNumber = this.getRawOrdinalNumber(tick.value);
			var cateogry = this._ordinalMeta.categories[ordinalNumber];
			return cateogry == null ? "" : cateogry + "";
		}
	};
	OrdinalScale$1.prototype.count = function() {
		return this._extent[1] - this._extent[0] + 1;
	};
	OrdinalScale$1.prototype.unionExtentFromData = function(data, dim) {
		this.unionExtent(data.getApproximateExtent(dim));
	};
	/**
	
	* @override
	
	* If value is in extent range
	
	*/
	OrdinalScale$1.prototype.isInExtentRange = function(value) {
		value = this._getTickNumber(value);
		return this._extent[0] <= value && this._extent[1] >= value;
	};
	OrdinalScale$1.prototype.getOrdinalMeta = function() {
		return this._ordinalMeta;
	};
	OrdinalScale$1.prototype.calcNiceTicks = function() {};
	OrdinalScale$1.prototype.calcNiceExtent = function() {};
	OrdinalScale$1.type = "ordinal";
	return OrdinalScale$1;
}(Scale_default);
Scale_default.registerClass(OrdinalScale);
var Ordinal_default = OrdinalScale;
var roundNumber = round;
var IntervalScale = function(_super) {
	__extends(IntervalScale$1, _super);
	function IntervalScale$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = "interval";
		_this._interval = 0;
		_this._intervalPrecision = 2;
		return _this;
	}
	IntervalScale$1.prototype.parse = function(val) {
		return val;
	};
	IntervalScale$1.prototype.contain = function(val) {
		return contain(val, this._extent);
	};
	IntervalScale$1.prototype.normalize = function(val) {
		return normalize(val, this._extent);
	};
	IntervalScale$1.prototype.scale = function(val) {
		return scale(val, this._extent);
	};
	IntervalScale$1.prototype.setExtent = function(start$1, end$1) {
		var thisExtent = this._extent;
		if (!isNaN(start$1)) thisExtent[0] = parseFloat(start$1);
		if (!isNaN(end$1)) thisExtent[1] = parseFloat(end$1);
	};
	IntervalScale$1.prototype.unionExtent = function(other) {
		var extent$1 = this._extent;
		other[0] < extent$1[0] && (extent$1[0] = other[0]);
		other[1] > extent$1[1] && (extent$1[1] = other[1]);
		this.setExtent(extent$1[0], extent$1[1]);
	};
	IntervalScale$1.prototype.getInterval = function() {
		return this._interval;
	};
	IntervalScale$1.prototype.setInterval = function(interval) {
		this._interval = interval;
		this._niceExtent = this._extent.slice();
		this._intervalPrecision = getIntervalPrecision(interval);
	};
	/**
	
	* @param expandToNicedExtent Whether expand the ticks to niced extent.
	
	*/
	IntervalScale$1.prototype.getTicks = function(expandToNicedExtent) {
		var interval = this._interval;
		var extent$1 = this._extent;
		var niceTickExtent = this._niceExtent;
		var intervalPrecision = this._intervalPrecision;
		var ticks = [];
		if (!interval) return ticks;
		var safeLimit = 1e4;
		if (extent$1[0] < niceTickExtent[0]) if (expandToNicedExtent) ticks.push({ value: roundNumber(niceTickExtent[0] - interval, intervalPrecision) });
		else ticks.push({ value: extent$1[0] });
		var tick = niceTickExtent[0];
		while (tick <= niceTickExtent[1]) {
			ticks.push({ value: tick });
			tick = roundNumber(tick + interval, intervalPrecision);
			if (tick === ticks[ticks.length - 1].value) break;
			if (ticks.length > safeLimit) return [];
		}
		var lastNiceTick = ticks.length ? ticks[ticks.length - 1].value : niceTickExtent[1];
		if (extent$1[1] > lastNiceTick) if (expandToNicedExtent) ticks.push({ value: roundNumber(lastNiceTick + interval, intervalPrecision) });
		else ticks.push({ value: extent$1[1] });
		return ticks;
	};
	IntervalScale$1.prototype.getMinorTicks = function(splitNumber) {
		var ticks = this.getTicks(true);
		var minorTicks = [];
		var extent$1 = this.getExtent();
		for (var i = 1; i < ticks.length; i++) {
			var nextTick$1 = ticks[i];
			var prevTick = ticks[i - 1];
			var count = 0;
			var minorTicksGroup = [];
			var interval = nextTick$1.value - prevTick.value;
			var minorInterval = interval / splitNumber;
			while (count < splitNumber - 1) {
				var minorTick = roundNumber(prevTick.value + (count + 1) * minorInterval);
				if (minorTick > extent$1[0] && minorTick < extent$1[1]) minorTicksGroup.push(minorTick);
				count++;
			}
			minorTicks.push(minorTicksGroup);
		}
		return minorTicks;
	};
	/**
	
	* @param opt.precision If 'auto', use nice presision.
	
	* @param opt.pad returns 1.50 but not 1.5 if precision is 2.
	
	*/
	IntervalScale$1.prototype.getLabel = function(data, opt) {
		if (data == null) return "";
		var precision = opt && opt.precision;
		if (precision == null) precision = getPrecision(data.value) || 0;
		else if (precision === "auto") precision = this._intervalPrecision;
		var dataNum = roundNumber(data.value, precision, true);
		return addCommas(dataNum);
	};
	/**
	
	* @param splitNumber By default `5`.
	
	*/
	IntervalScale$1.prototype.calcNiceTicks = function(splitNumber, minInterval, maxInterval) {
		splitNumber = splitNumber || 5;
		var extent$1 = this._extent;
		var span = extent$1[1] - extent$1[0];
		if (!isFinite(span)) return;
		if (span < 0) {
			span = -span;
			extent$1.reverse();
		}
		var result = intervalScaleNiceTicks(extent$1, splitNumber, minInterval, maxInterval);
		this._intervalPrecision = result.intervalPrecision;
		this._interval = result.interval;
		this._niceExtent = result.niceTickExtent;
	};
	IntervalScale$1.prototype.calcNiceExtent = function(opt) {
		var extent$1 = this._extent;
		if (extent$1[0] === extent$1[1]) if (extent$1[0] !== 0) {
			var expandSize = Math.abs(extent$1[0]);
			if (!opt.fixMax) {
				extent$1[1] += expandSize / 2;
				extent$1[0] -= expandSize / 2;
			} else extent$1[0] -= expandSize / 2;
		} else extent$1[1] = 1;
		var span = extent$1[1] - extent$1[0];
		if (!isFinite(span)) {
			extent$1[0] = 0;
			extent$1[1] = 1;
		}
		this.calcNiceTicks(opt.splitNumber, opt.minInterval, opt.maxInterval);
		var interval = this._interval;
		if (!opt.fixMin) extent$1[0] = roundNumber(Math.floor(extent$1[0] / interval) * interval);
		if (!opt.fixMax) extent$1[1] = roundNumber(Math.ceil(extent$1[1] / interval) * interval);
	};
	IntervalScale$1.prototype.setNiceExtent = function(min$2, max$2) {
		this._niceExtent = [min$2, max$2];
	};
	IntervalScale$1.type = "interval";
	return IntervalScale$1;
}(Scale_default);
Scale_default.registerClass(IntervalScale);
var Interval_default = IntervalScale;
var bisect = function(a, x, lo, hi) {
	while (lo < hi) {
		var mid = lo + hi >>> 1;
		if (a[mid][1] < x) lo = mid + 1;
		else hi = mid;
	}
	return lo;
};
var TimeScale = function(_super) {
	__extends(TimeScale$1, _super);
	function TimeScale$1(settings) {
		var _this = _super.call(this, settings) || this;
		_this.type = "time";
		return _this;
	}
	/**
	
	* Get label is mainly for other components like dataZoom, tooltip.
	
	*/
	TimeScale$1.prototype.getLabel = function(tick) {
		var useUTC = this.getSetting("useUTC");
		return format(tick.value, fullLeveledFormatter[getDefaultFormatPrecisionOfInterval(getPrimaryTimeUnit(this._minLevelUnit))] || fullLeveledFormatter.second, useUTC, this.getSetting("locale"));
	};
	TimeScale$1.prototype.getFormattedLabel = function(tick, idx, labelFormatter) {
		var isUTC = this.getSetting("useUTC");
		var lang = this.getSetting("locale");
		return leveledFormat(tick, idx, labelFormatter, lang, isUTC);
	};
	/**
	
	* @override
	
	*/
	TimeScale$1.prototype.getTicks = function() {
		var interval = this._interval;
		var extent$1 = this._extent;
		var ticks = [];
		if (!interval) return ticks;
		ticks.push({
			value: extent$1[0],
			level: 0
		});
		var useUTC = this.getSetting("useUTC");
		var innerTicks = getIntervalTicks(this._minLevelUnit, this._approxInterval, useUTC, extent$1);
		ticks = ticks.concat(innerTicks);
		ticks.push({
			value: extent$1[1],
			level: 0
		});
		return ticks;
	};
	TimeScale$1.prototype.calcNiceExtent = function(opt) {
		var extent$1 = this._extent;
		if (extent$1[0] === extent$1[1]) {
			extent$1[0] -= ONE_DAY;
			extent$1[1] += ONE_DAY;
		}
		if (extent$1[1] === -Infinity && extent$1[0] === Infinity) {
			var d = new Date();
			extent$1[1] = +new Date(d.getFullYear(), d.getMonth(), d.getDate());
			extent$1[0] = extent$1[1] - ONE_DAY;
		}
		this.calcNiceTicks(opt.splitNumber, opt.minInterval, opt.maxInterval);
	};
	TimeScale$1.prototype.calcNiceTicks = function(approxTickNum, minInterval, maxInterval) {
		approxTickNum = approxTickNum || 10;
		var extent$1 = this._extent;
		var span = extent$1[1] - extent$1[0];
		this._approxInterval = span / approxTickNum;
		if (minInterval != null && this._approxInterval < minInterval) this._approxInterval = minInterval;
		if (maxInterval != null && this._approxInterval > maxInterval) this._approxInterval = maxInterval;
		var scaleIntervalsLen = scaleIntervals.length;
		var idx = Math.min(bisect(scaleIntervals, this._approxInterval, 0, scaleIntervalsLen), scaleIntervalsLen - 1);
		this._interval = scaleIntervals[idx][1];
		this._minLevelUnit = scaleIntervals[Math.max(idx - 1, 0)][0];
	};
	TimeScale$1.prototype.parse = function(val) {
		return isNumber(val) ? val : +parseDate(val);
	};
	TimeScale$1.prototype.contain = function(val) {
		return contain(this.parse(val), this._extent);
	};
	TimeScale$1.prototype.normalize = function(val) {
		return normalize(this.parse(val), this._extent);
	};
	TimeScale$1.prototype.scale = function(val) {
		return scale(val, this._extent);
	};
	TimeScale$1.type = "time";
	return TimeScale$1;
}(Interval_default);
/**

* This implementation was originally copied from "d3.js"

* <https://github.com/d3/d3/blob/b516d77fb8566b576088e73410437494717ada26/src/time/scale.js>

* with some modifications made for this program.

* See the license statement at the head of this file.

*/
var scaleIntervals = [
	["second", ONE_SECOND],
	["minute", ONE_MINUTE],
	["hour", ONE_HOUR],
	["quarter-day", ONE_HOUR * 6],
	["half-day", ONE_HOUR * 12],
	["day", ONE_DAY * 1.2],
	["half-week", ONE_DAY * 3.5],
	["week", ONE_DAY * 7],
	["month", ONE_DAY * 31],
	["quarter", ONE_DAY * 95],
	["half-year", ONE_YEAR / 2],
	["year", ONE_YEAR]
];
function isUnitValueSame(unit, valueA, valueB, isUTC) {
	var dateA = parseDate(valueA);
	var dateB = parseDate(valueB);
	var isSame = function(unit$1) {
		return getUnitValue(dateA, unit$1, isUTC) === getUnitValue(dateB, unit$1, isUTC);
	};
	var isSameYear = function() {
		return isSame("year");
	};
	var isSameMonth = function() {
		return isSameYear() && isSame("month");
	};
	var isSameDay = function() {
		return isSameMonth() && isSame("day");
	};
	var isSameHour = function() {
		return isSameDay() && isSame("hour");
	};
	var isSameMinute = function() {
		return isSameHour() && isSame("minute");
	};
	var isSameSecond = function() {
		return isSameMinute() && isSame("second");
	};
	var isSameMilliSecond = function() {
		return isSameSecond() && isSame("millisecond");
	};
	switch (unit) {
		case "year": return isSameYear();
		case "month": return isSameMonth();
		case "day": return isSameDay();
		case "hour": return isSameHour();
		case "minute": return isSameMinute();
		case "second": return isSameSecond();
		case "millisecond": return isSameMilliSecond();
	}
}
function getDateInterval(approxInterval, daysInMonth) {
	approxInterval /= ONE_DAY;
	return approxInterval > 16 ? 16 : approxInterval > 7.5 ? 7 : approxInterval > 3.5 ? 4 : approxInterval > 1.5 ? 2 : 1;
}
function getMonthInterval(approxInterval) {
	var APPROX_ONE_MONTH = 30 * ONE_DAY;
	approxInterval /= APPROX_ONE_MONTH;
	return approxInterval > 6 ? 6 : approxInterval > 3 ? 3 : approxInterval > 2 ? 2 : 1;
}
function getHourInterval(approxInterval) {
	approxInterval /= ONE_HOUR;
	return approxInterval > 12 ? 12 : approxInterval > 6 ? 6 : approxInterval > 3.5 ? 4 : approxInterval > 2 ? 2 : 1;
}
function getMinutesAndSecondsInterval(approxInterval, isMinutes) {
	approxInterval /= isMinutes ? ONE_MINUTE : ONE_SECOND;
	return approxInterval > 30 ? 30 : approxInterval > 20 ? 20 : approxInterval > 15 ? 15 : approxInterval > 10 ? 10 : approxInterval > 5 ? 5 : approxInterval > 2 ? 2 : 1;
}
function getMillisecondsInterval(approxInterval) {
	return nice(approxInterval, true);
}
function getFirstTimestampOfUnit(date, unitName, isUTC) {
	var outDate = new Date(date);
	switch (getPrimaryTimeUnit(unitName)) {
		case "year":
		case "month": outDate[monthSetterName(isUTC)](0);
		case "day": outDate[dateSetterName(isUTC)](1);
		case "hour": outDate[hoursSetterName(isUTC)](0);
		case "minute": outDate[minutesSetterName(isUTC)](0);
		case "second":
			outDate[secondsSetterName(isUTC)](0);
			outDate[millisecondsSetterName(isUTC)](0);
	}
	return outDate.getTime();
}
function getIntervalTicks(bottomUnitName, approxInterval, isUTC, extent$1) {
	var safeLimit = 1e4;
	var unitNames = timeUnits;
	var iter = 0;
	function addTicksInSpan(interval, minTimestamp, maxTimestamp, getMethodName, setMethodName, isDate, out$1) {
		var date = new Date(minTimestamp);
		var dateTime = minTimestamp;
		var d = date[getMethodName]();
		while (dateTime < maxTimestamp && dateTime <= extent$1[1]) {
			out$1.push({ value: dateTime });
			d += interval;
			date[setMethodName](d);
			dateTime = date.getTime();
		}
		out$1.push({
			value: dateTime,
			notAdd: true
		});
	}
	function addLevelTicks(unitName, lastLevelTicks, levelTicks$1) {
		var newAddedTicks = [];
		var isFirstLevel = !lastLevelTicks.length;
		if (isUnitValueSame(getPrimaryTimeUnit(unitName), extent$1[0], extent$1[1], isUTC)) return;
		if (isFirstLevel) lastLevelTicks = [{ value: getFirstTimestampOfUnit(new Date(extent$1[0]), unitName, isUTC) }, { value: extent$1[1] }];
		for (var i$1 = 0; i$1 < lastLevelTicks.length - 1; i$1++) {
			var startTick = lastLevelTicks[i$1].value;
			var endTick = lastLevelTicks[i$1 + 1].value;
			if (startTick === endTick) continue;
			var interval = void 0;
			var getterName = void 0;
			var setterName = void 0;
			var isDate = false;
			switch (unitName) {
				case "year":
					interval = Math.max(1, Math.round(approxInterval / ONE_DAY / 365));
					getterName = fullYearGetterName(isUTC);
					setterName = fullYearSetterName(isUTC);
					break;
				case "half-year":
				case "quarter":
				case "month":
					interval = getMonthInterval(approxInterval);
					getterName = monthGetterName(isUTC);
					setterName = monthSetterName(isUTC);
					break;
				case "week":
				case "half-week":
				case "day":
					interval = getDateInterval(approxInterval, 31);
					getterName = dateGetterName(isUTC);
					setterName = dateSetterName(isUTC);
					isDate = true;
					break;
				case "half-day":
				case "quarter-day":
				case "hour":
					interval = getHourInterval(approxInterval);
					getterName = hoursGetterName(isUTC);
					setterName = hoursSetterName(isUTC);
					break;
				case "minute":
					interval = getMinutesAndSecondsInterval(approxInterval, true);
					getterName = minutesGetterName(isUTC);
					setterName = minutesSetterName(isUTC);
					break;
				case "second":
					interval = getMinutesAndSecondsInterval(approxInterval, false);
					getterName = secondsGetterName(isUTC);
					setterName = secondsSetterName(isUTC);
					break;
				case "millisecond":
					interval = getMillisecondsInterval(approxInterval);
					getterName = millisecondsGetterName(isUTC);
					setterName = millisecondsSetterName(isUTC);
					break;
			}
			addTicksInSpan(interval, startTick, endTick, getterName, setterName, isDate, newAddedTicks);
			if (unitName === "year" && levelTicks$1.length > 1 && i$1 === 0) levelTicks$1.unshift({ value: levelTicks$1[0].value - interval });
		}
		for (var i$1 = 0; i$1 < newAddedTicks.length; i$1++) levelTicks$1.push(newAddedTicks[i$1]);
		return newAddedTicks;
	}
	var levelsTicks = [];
	var currentLevelTicks = [];
	var tickCount = 0;
	var lastLevelTickCount = 0;
	for (var i = 0; i < unitNames.length && iter++ < safeLimit; ++i) {
		var primaryTimeUnit = getPrimaryTimeUnit(unitNames[i]);
		if (!isPrimaryTimeUnit(unitNames[i])) continue;
		addLevelTicks(unitNames[i], levelsTicks[levelsTicks.length - 1] || [], currentLevelTicks);
		var nextPrimaryTimeUnit = unitNames[i + 1] ? getPrimaryTimeUnit(unitNames[i + 1]) : null;
		if (primaryTimeUnit !== nextPrimaryTimeUnit) {
			if (currentLevelTicks.length) {
				lastLevelTickCount = tickCount;
				currentLevelTicks.sort(function(a, b) {
					return a.value - b.value;
				});
				var levelTicksRemoveDuplicated = [];
				for (var i_1 = 0; i_1 < currentLevelTicks.length; ++i_1) {
					var tickValue = currentLevelTicks[i_1].value;
					if (i_1 === 0 || currentLevelTicks[i_1 - 1].value !== tickValue) {
						levelTicksRemoveDuplicated.push(currentLevelTicks[i_1]);
						if (tickValue >= extent$1[0] && tickValue <= extent$1[1]) tickCount++;
					}
				}
				var targetTickNum = (extent$1[1] - extent$1[0]) / approxInterval;
				if (tickCount > targetTickNum * 1.5 && lastLevelTickCount > targetTickNum / 1.5) break;
				levelsTicks.push(levelTicksRemoveDuplicated);
				if (tickCount > targetTickNum || bottomUnitName === unitNames[i]) break;
			}
			currentLevelTicks = [];
		}
	}
	var levelsTicksInExtent = filter(map$1(levelsTicks, function(levelTicks$1) {
		return filter(levelTicks$1, function(tick) {
			return tick.value >= extent$1[0] && tick.value <= extent$1[1] && !tick.notAdd;
		});
	}), function(levelTicks$1) {
		return levelTicks$1.length > 0;
	});
	var ticks = [];
	var maxLevel = levelsTicksInExtent.length - 1;
	for (var i = 0; i < levelsTicksInExtent.length; ++i) {
		var levelTicks = levelsTicksInExtent[i];
		for (var k = 0; k < levelTicks.length; ++k) ticks.push({
			value: levelTicks[k].value,
			level: maxLevel - i
		});
	}
	ticks.sort(function(a, b) {
		return a.value - b.value;
	});
	var result = [];
	for (var i = 0; i < ticks.length; ++i) if (i === 0 || ticks[i].value !== ticks[i - 1].value) result.push(ticks[i]);
	return result;
}
Scale_default.registerClass(TimeScale);
var Time_default = TimeScale;
var scaleProto = Scale_default.prototype;
var intervalScaleProto = Interval_default.prototype;
var roundingErrorFix = round;
var mathFloor = Math.floor;
var mathCeil = Math.ceil;
var mathPow = Math.pow;
var mathLog$1 = Math.log;
var LogScale = function(_super) {
	__extends(LogScale$1, _super);
	function LogScale$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = "log";
		_this.base = 10;
		_this._originalScale = new Interval_default();
		_this._interval = 0;
		return _this;
	}
	/**
	
	* @param Whether expand the ticks to niced extent.
	
	*/
	LogScale$1.prototype.getTicks = function(expandToNicedExtent) {
		var originalScale = this._originalScale;
		var extent$1 = this._extent;
		var originalExtent = originalScale.getExtent();
		var ticks = intervalScaleProto.getTicks.call(this, expandToNicedExtent);
		return map$1(ticks, function(tick) {
			var val = tick.value;
			var powVal = round(mathPow(this.base, val));
			powVal = val === extent$1[0] && this._fixMin ? fixRoundingError(powVal, originalExtent[0]) : powVal;
			powVal = val === extent$1[1] && this._fixMax ? fixRoundingError(powVal, originalExtent[1]) : powVal;
			return { value: powVal };
		}, this);
	};
	LogScale$1.prototype.setExtent = function(start$1, end$1) {
		var base$1 = mathLog$1(this.base);
		start$1 = mathLog$1(Math.max(0, start$1)) / base$1;
		end$1 = mathLog$1(Math.max(0, end$1)) / base$1;
		intervalScaleProto.setExtent.call(this, start$1, end$1);
	};
	/**
	
	* @return {number} end
	
	*/
	LogScale$1.prototype.getExtent = function() {
		var base$1 = this.base;
		var extent$1 = scaleProto.getExtent.call(this);
		extent$1[0] = mathPow(base$1, extent$1[0]);
		extent$1[1] = mathPow(base$1, extent$1[1]);
		var originalScale = this._originalScale;
		var originalExtent = originalScale.getExtent();
		this._fixMin && (extent$1[0] = fixRoundingError(extent$1[0], originalExtent[0]));
		this._fixMax && (extent$1[1] = fixRoundingError(extent$1[1], originalExtent[1]));
		return extent$1;
	};
	LogScale$1.prototype.unionExtent = function(extent$1) {
		this._originalScale.unionExtent(extent$1);
		var base$1 = this.base;
		extent$1[0] = mathLog$1(extent$1[0]) / mathLog$1(base$1);
		extent$1[1] = mathLog$1(extent$1[1]) / mathLog$1(base$1);
		scaleProto.unionExtent.call(this, extent$1);
	};
	LogScale$1.prototype.unionExtentFromData = function(data, dim) {
		this.unionExtent(data.getApproximateExtent(dim));
	};
	/**
	
	* Update interval and extent of intervals for nice ticks
	
	* @param approxTickNum default 10 Given approx tick number
	
	*/
	LogScale$1.prototype.calcNiceTicks = function(approxTickNum) {
		approxTickNum = approxTickNum || 10;
		var extent$1 = this._extent;
		var span = extent$1[1] - extent$1[0];
		if (span === Infinity || span <= 0) return;
		var interval = quantity(span);
		var err = approxTickNum / span * interval;
		if (err <= .5) interval *= 10;
		while (!isNaN(interval) && Math.abs(interval) < 1 && Math.abs(interval) > 0) interval *= 10;
		var niceExtent = [round(mathCeil(extent$1[0] / interval) * interval), round(mathFloor(extent$1[1] / interval) * interval)];
		this._interval = interval;
		this._niceExtent = niceExtent;
	};
	LogScale$1.prototype.calcNiceExtent = function(opt) {
		intervalScaleProto.calcNiceExtent.call(this, opt);
		this._fixMin = opt.fixMin;
		this._fixMax = opt.fixMax;
	};
	LogScale$1.prototype.parse = function(val) {
		return val;
	};
	LogScale$1.prototype.contain = function(val) {
		val = mathLog$1(val) / mathLog$1(this.base);
		return contain(val, this._extent);
	};
	LogScale$1.prototype.normalize = function(val) {
		val = mathLog$1(val) / mathLog$1(this.base);
		return normalize(val, this._extent);
	};
	LogScale$1.prototype.scale = function(val) {
		val = scale(val, this._extent);
		return mathPow(this.base, val);
	};
	LogScale$1.type = "log";
	return LogScale$1;
}(Scale_default);
var proto = LogScale.prototype;
proto.getMinorTicks = intervalScaleProto.getMinorTicks;
proto.getLabel = intervalScaleProto.getLabel;
function fixRoundingError(val, originalVal) {
	return roundingErrorFix(val, getPrecision(originalVal));
}
Scale_default.registerClass(LogScale);
var Log_default = LogScale;
var ScaleRawExtentInfo = function() {
	function ScaleRawExtentInfo$1(scale$3, model, originalExtent) {
		this._prepareParams(scale$3, model, originalExtent);
	}
	/**
	
	* Parameters depending on outside (like model, user callback)
	
	* are prepared and fixed here.
	
	*/
	ScaleRawExtentInfo$1.prototype._prepareParams = function(scale$3, model, dataExtent) {
		if (dataExtent[1] < dataExtent[0]) dataExtent = [NaN, NaN];
		this._dataMin = dataExtent[0];
		this._dataMax = dataExtent[1];
		var isOrdinal = this._isOrdinal = scale$3.type === "ordinal";
		this._needCrossZero = scale$3.type === "interval" && model.getNeedCrossZero && model.getNeedCrossZero();
		var axisMinValue = model.get("min", true);
		if (axisMinValue == null) axisMinValue = model.get("startValue", true);
		var modelMinRaw = this._modelMinRaw = axisMinValue;
		if (isFunction(modelMinRaw)) this._modelMinNum = parseAxisModelMinMax(scale$3, modelMinRaw({
			min: dataExtent[0],
			max: dataExtent[1]
		}));
		else if (modelMinRaw !== "dataMin") this._modelMinNum = parseAxisModelMinMax(scale$3, modelMinRaw);
		var modelMaxRaw = this._modelMaxRaw = model.get("max", true);
		if (isFunction(modelMaxRaw)) this._modelMaxNum = parseAxisModelMinMax(scale$3, modelMaxRaw({
			min: dataExtent[0],
			max: dataExtent[1]
		}));
		else if (modelMaxRaw !== "dataMax") this._modelMaxNum = parseAxisModelMinMax(scale$3, modelMaxRaw);
		if (isOrdinal) this._axisDataLen = model.getCategories().length;
		else {
			var boundaryGap = model.get("boundaryGap");
			var boundaryGapArr = isArray(boundaryGap) ? boundaryGap : [boundaryGap || 0, boundaryGap || 0];
			if (typeof boundaryGapArr[0] === "boolean" || typeof boundaryGapArr[1] === "boolean") this._boundaryGapInner = [0, 0];
			else this._boundaryGapInner = [parsePercent$1(boundaryGapArr[0], 1), parsePercent$1(boundaryGapArr[1], 1)];
		}
	};
	/**
	
	* Calculate extent by prepared parameters.
	
	* This method has no external dependency and can be called duplicatedly,
	
	* getting the same result.
	
	* If parameters changed, should call this method to recalcuate.
	
	*/
	ScaleRawExtentInfo$1.prototype.calculate = function() {
		var isOrdinal = this._isOrdinal;
		var dataMin = this._dataMin;
		var dataMax = this._dataMax;
		var axisDataLen = this._axisDataLen;
		var boundaryGapInner = this._boundaryGapInner;
		var span = !isOrdinal ? dataMax - dataMin || Math.abs(dataMin) : null;
		var min$2 = this._modelMinRaw === "dataMin" ? dataMin : this._modelMinNum;
		var max$2 = this._modelMaxRaw === "dataMax" ? dataMax : this._modelMaxNum;
		var minFixed = min$2 != null;
		var maxFixed = max$2 != null;
		if (min$2 == null) min$2 = isOrdinal ? axisDataLen ? 0 : NaN : dataMin - boundaryGapInner[0] * span;
		if (max$2 == null) max$2 = isOrdinal ? axisDataLen ? axisDataLen - 1 : NaN : dataMax + boundaryGapInner[1] * span;
		(min$2 == null || !isFinite(min$2)) && (min$2 = NaN);
		(max$2 == null || !isFinite(max$2)) && (max$2 = NaN);
		var isBlank = eqNaN(min$2) || eqNaN(max$2) || isOrdinal && !axisDataLen;
		if (this._needCrossZero) {
			if (min$2 > 0 && max$2 > 0 && !minFixed) min$2 = 0;
			if (min$2 < 0 && max$2 < 0 && !maxFixed) max$2 = 0;
		}
		var determinedMin = this._determinedMin;
		var determinedMax = this._determinedMax;
		if (determinedMin != null) {
			min$2 = determinedMin;
			minFixed = true;
		}
		if (determinedMax != null) {
			max$2 = determinedMax;
			maxFixed = true;
		}
		return {
			min: min$2,
			max: max$2,
			minFixed,
			maxFixed,
			isBlank
		};
	};
	ScaleRawExtentInfo$1.prototype.modifyDataMinMax = function(minMaxName, val) {
		this[DATA_MIN_MAX_ATTR[minMaxName]] = val;
	};
	ScaleRawExtentInfo$1.prototype.setDeterminedMinMax = function(minMaxName, val) {
		var attr = DETERMINED_MIN_MAX_ATTR[minMaxName];
		this[attr] = val;
	};
	ScaleRawExtentInfo$1.prototype.freeze = function() {
		this.frozen = true;
	};
	return ScaleRawExtentInfo$1;
}();
var DETERMINED_MIN_MAX_ATTR = {
	min: "_determinedMin",
	max: "_determinedMax"
};
var DATA_MIN_MAX_ATTR = {
	min: "_dataMin",
	max: "_dataMax"
};
function ensureScaleRawExtentInfo(scale$3, model, originalExtent) {
	var rawExtentInfo = scale$3.rawExtentInfo;
	if (rawExtentInfo) return rawExtentInfo;
	rawExtentInfo = new ScaleRawExtentInfo(scale$3, model, originalExtent);
	scale$3.rawExtentInfo = rawExtentInfo;
	return rawExtentInfo;
}
function parseAxisModelMinMax(scale$3, minMax) {
	return minMax == null ? null : eqNaN(minMax) ? NaN : scale$3.parse(minMax);
}
function getScaleExtent(scale$3, model) {
	var scaleType = scale$3.type;
	var rawExtentResult = ensureScaleRawExtentInfo(scale$3, model, scale$3.getExtent()).calculate();
	scale$3.setBlank(rawExtentResult.isBlank);
	var min$2 = rawExtentResult.min;
	var max$2 = rawExtentResult.max;
	var ecModel = model.ecModel;
	if (ecModel && scaleType === "time") {
		var barSeriesModels = prepareLayoutBarSeries("bar", ecModel);
		var isBaseAxisAndHasBarSeries_1 = false;
		each$4(barSeriesModels, function(seriesModel) {
			isBaseAxisAndHasBarSeries_1 = isBaseAxisAndHasBarSeries_1 || seriesModel.getBaseAxis() === model.axis;
		});
		if (isBaseAxisAndHasBarSeries_1) {
			var barWidthAndOffset = makeColumnLayout(barSeriesModels);
			var adjustedScale = adjustScaleForOverflow(min$2, max$2, model, barWidthAndOffset);
			min$2 = adjustedScale.min;
			max$2 = adjustedScale.max;
		}
	}
	return {
		extent: [min$2, max$2],
		fixMin: rawExtentResult.minFixed,
		fixMax: rawExtentResult.maxFixed
	};
}
function adjustScaleForOverflow(min$2, max$2, model, barWidthAndOffset) {
	var axisExtent = model.axis.getExtent();
	var axisLength = Math.abs(axisExtent[1] - axisExtent[0]);
	var barsOnCurrentAxis = retrieveColumnLayout(barWidthAndOffset, model.axis);
	if (barsOnCurrentAxis === void 0) return {
		min: min$2,
		max: max$2
	};
	var minOverflow = Infinity;
	each$4(barsOnCurrentAxis, function(item) {
		minOverflow = Math.min(item.offset, minOverflow);
	});
	var maxOverflow = -Infinity;
	each$4(barsOnCurrentAxis, function(item) {
		maxOverflow = Math.max(item.offset + item.width, maxOverflow);
	});
	minOverflow = Math.abs(minOverflow);
	maxOverflow = Math.abs(maxOverflow);
	var totalOverFlow = minOverflow + maxOverflow;
	var oldRange = max$2 - min$2;
	var oldRangePercentOfNew = 1 - (minOverflow + maxOverflow) / axisLength;
	var overflowBuffer = oldRange / oldRangePercentOfNew - oldRange;
	max$2 += overflowBuffer * (maxOverflow / totalOverFlow);
	min$2 -= overflowBuffer * (minOverflow / totalOverFlow);
	return {
		min: min$2,
		max: max$2
	};
}
function niceScaleExtent(scale$3, inModel) {
	var model = inModel;
	var extentInfo = getScaleExtent(scale$3, model);
	var extent$1 = extentInfo.extent;
	var splitNumber = model.get("splitNumber");
	if (scale$3 instanceof Log_default) scale$3.base = model.get("logBase");
	var scaleType = scale$3.type;
	var interval = model.get("interval");
	var isIntervalOrTime = scaleType === "interval" || scaleType === "time";
	scale$3.setExtent(extent$1[0], extent$1[1]);
	scale$3.calcNiceExtent({
		splitNumber,
		fixMin: extentInfo.fixMin,
		fixMax: extentInfo.fixMax,
		minInterval: isIntervalOrTime ? model.get("minInterval") : null,
		maxInterval: isIntervalOrTime ? model.get("maxInterval") : null
	});
	if (interval != null) scale$3.setInterval && scale$3.setInterval(interval);
}
function createScaleByModel(model, axisType) {
	axisType = axisType || model.get("type");
	if (axisType) switch (axisType) {
		case "category": return new Ordinal_default({
			ordinalMeta: model.getOrdinalMeta ? model.getOrdinalMeta() : model.getCategories(),
			extent: [Infinity, -Infinity]
		});
		case "time": return new Time_default({
			locale: model.ecModel.getLocaleModel(),
			useUTC: model.ecModel.get("useUTC")
		});
		default: return new ((Scale_default.getClass(axisType)) || Interval_default)();
	}
}
function ifAxisCrossZero(axis) {
	var dataExtent = axis.scale.getExtent();
	var min$2 = dataExtent[0];
	var max$2 = dataExtent[1];
	return !(min$2 > 0 && max$2 > 0 || min$2 < 0 && max$2 < 0);
}
function makeLabelFormatter(axis) {
	var labelFormatter = axis.getLabelModel().get("formatter");
	var categoryTickStart = axis.type === "category" ? axis.scale.getExtent()[0] : null;
	if (axis.scale.type === "time") return function(tpl) {
		return function(tick, idx) {
			return axis.scale.getFormattedLabel(tick, idx, tpl);
		};
	}(labelFormatter);
	else if (isString(labelFormatter)) return function(tpl) {
		return function(tick) {
			var label = axis.scale.getLabel(tick);
			var text = tpl.replace("{value}", label != null ? label : "");
			return text;
		};
	}(labelFormatter);
	else if (isFunction(labelFormatter)) return function(cb) {
		return function(tick, idx) {
			if (categoryTickStart != null) idx = tick.value - categoryTickStart;
			return cb(getAxisRawValue(axis, tick), idx, tick.level != null ? { level: tick.level } : null);
		};
	}(labelFormatter);
	else return function(tick) {
		return axis.scale.getLabel(tick);
	};
}
function getAxisRawValue(axis, tick) {
	return axis.type === "category" ? axis.scale.getLabel(tick) : tick.value;
}
function estimateLabelUnionRect(axis) {
	var axisModel = axis.model;
	var scale$3 = axis.scale;
	if (!axisModel.get(["axisLabel", "show"]) || scale$3.isBlank()) return;
	var realNumberScaleTicks;
	var tickCount;
	var categoryScaleExtent = scale$3.getExtent();
	if (scale$3 instanceof Ordinal_default) tickCount = scale$3.count();
	else {
		realNumberScaleTicks = scale$3.getTicks();
		tickCount = realNumberScaleTicks.length;
	}
	var axisLabelModel = axis.getLabelModel();
	var labelFormatter = makeLabelFormatter(axis);
	var rect;
	var step = 1;
	if (tickCount > 40) step = Math.ceil(tickCount / 40);
	for (var i = 0; i < tickCount; i += step) {
		var tick = realNumberScaleTicks ? realNumberScaleTicks[i] : { value: categoryScaleExtent[0] + i };
		var label = labelFormatter(tick, i);
		var unrotatedSingleRect = axisLabelModel.getTextRect(label);
		var singleRect = rotateTextRect(unrotatedSingleRect, axisLabelModel.get("rotate") || 0);
		rect ? rect.union(singleRect) : rect = singleRect;
	}
	return rect;
}
function rotateTextRect(textRect, rotate$1) {
	var rotateRadians = rotate$1 * Math.PI / 180;
	var beforeWidth = textRect.width;
	var beforeHeight = textRect.height;
	var afterWidth = beforeWidth * Math.abs(Math.cos(rotateRadians)) + Math.abs(beforeHeight * Math.sin(rotateRadians));
	var afterHeight = beforeWidth * Math.abs(Math.sin(rotateRadians)) + Math.abs(beforeHeight * Math.cos(rotateRadians));
	var rotatedRect = new BoundingRect_default(textRect.x, textRect.y, afterWidth, afterHeight);
	return rotatedRect;
}
function getOptionCategoryInterval(model) {
	var interval = model.get("interval");
	return interval == null ? "auto" : interval;
}
function shouldShowAllLabels(axis) {
	return axis.type === "category" && getOptionCategoryInterval(axis.getLabelModel()) === 0;
}
function getDataDimensionsOnAxis(data, axisDim) {
	var dataDimMap = {};
	each$4(data.mapDimensionsAll(axisDim), function(dataDim) {
		dataDimMap[getStackedDimension(data, dataDim)] = true;
	});
	return keys(dataDimMap);
}
var Cartesian = function() {
	function Cartesian$1(name) {
		this.type = "cartesian";
		this._dimList = [];
		this._axes = {};
		this.name = name || "";
	}
	Cartesian$1.prototype.getAxis = function(dim) {
		return this._axes[dim];
	};
	Cartesian$1.prototype.getAxes = function() {
		return map$1(this._dimList, function(dim) {
			return this._axes[dim];
		}, this);
	};
	Cartesian$1.prototype.getAxesByScale = function(scaleType) {
		scaleType = scaleType.toLowerCase();
		return filter(this.getAxes(), function(axis) {
			return axis.scale.type === scaleType;
		});
	};
	Cartesian$1.prototype.addAxis = function(axis) {
		var dim = axis.dim;
		this._axes[dim] = axis;
		this._dimList.push(dim);
	};
	return Cartesian$1;
}();
var Cartesian_default = Cartesian;
var cartesian2DDimensions = ["x", "y"];
function canCalculateAffineTransform(scale$3) {
	return scale$3.type === "interval" || scale$3.type === "time";
}
var Cartesian2D = function(_super) {
	__extends(Cartesian2D$1, _super);
	function Cartesian2D$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = "cartesian2d";
		_this.dimensions = cartesian2DDimensions;
		return _this;
	}
	/**
	
	* Calculate an affine transform matrix if two axes are time or value.
	
	* It's mainly for accelartion on the large time series data.
	
	*/
	Cartesian2D$1.prototype.calcAffineTransform = function() {
		this._transform = this._invTransform = null;
		var xAxisScale = this.getAxis("x").scale;
		var yAxisScale = this.getAxis("y").scale;
		if (!canCalculateAffineTransform(xAxisScale) || !canCalculateAffineTransform(yAxisScale)) return;
		var xScaleExtent = xAxisScale.getExtent();
		var yScaleExtent = yAxisScale.getExtent();
		var start$1 = this.dataToPoint([xScaleExtent[0], yScaleExtent[0]]);
		var end$1 = this.dataToPoint([xScaleExtent[1], yScaleExtent[1]]);
		var xScaleSpan = xScaleExtent[1] - xScaleExtent[0];
		var yScaleSpan = yScaleExtent[1] - yScaleExtent[0];
		if (!xScaleSpan || !yScaleSpan) return;
		var scaleX = (end$1[0] - start$1[0]) / xScaleSpan;
		var scaleY = (end$1[1] - start$1[1]) / yScaleSpan;
		var translateX = start$1[0] - xScaleExtent[0] * scaleX;
		var translateY = start$1[1] - yScaleExtent[0] * scaleY;
		var m$1 = this._transform = [
			scaleX,
			0,
			0,
			scaleY,
			translateX,
			translateY
		];
		this._invTransform = invert([], m$1);
	};
	/**
	
	* Base axis will be used on stacking.
	
	*/
	Cartesian2D$1.prototype.getBaseAxis = function() {
		return this.getAxesByScale("ordinal")[0] || this.getAxesByScale("time")[0] || this.getAxis("x");
	};
	Cartesian2D$1.prototype.containPoint = function(point) {
		var axisX = this.getAxis("x");
		var axisY = this.getAxis("y");
		return axisX.contain(axisX.toLocalCoord(point[0])) && axisY.contain(axisY.toLocalCoord(point[1]));
	};
	Cartesian2D$1.prototype.containData = function(data) {
		return this.getAxis("x").containData(data[0]) && this.getAxis("y").containData(data[1]);
	};
	Cartesian2D$1.prototype.containZone = function(data1, data2) {
		var zoneDiag1 = this.dataToPoint(data1);
		var zoneDiag2 = this.dataToPoint(data2);
		var area = this.getArea();
		var zone = new BoundingRect_default(zoneDiag1[0], zoneDiag1[1], zoneDiag2[0] - zoneDiag1[0], zoneDiag2[1] - zoneDiag1[1]);
		return area.intersect(zone);
	};
	Cartesian2D$1.prototype.dataToPoint = function(data, clamp$1, out$1) {
		out$1 = out$1 || [];
		var xVal = data[0];
		var yVal = data[1];
		if (this._transform && xVal != null && isFinite(xVal) && yVal != null && isFinite(yVal)) return applyTransform$1(out$1, data, this._transform);
		var xAxis = this.getAxis("x");
		var yAxis = this.getAxis("y");
		out$1[0] = xAxis.toGlobalCoord(xAxis.dataToCoord(xVal, clamp$1));
		out$1[1] = yAxis.toGlobalCoord(yAxis.dataToCoord(yVal, clamp$1));
		return out$1;
	};
	Cartesian2D$1.prototype.clampData = function(data, out$1) {
		var xScale = this.getAxis("x").scale;
		var yScale = this.getAxis("y").scale;
		var xAxisExtent = xScale.getExtent();
		var yAxisExtent = yScale.getExtent();
		var x = xScale.parse(data[0]);
		var y = yScale.parse(data[1]);
		out$1 = out$1 || [];
		out$1[0] = Math.min(Math.max(Math.min(xAxisExtent[0], xAxisExtent[1]), x), Math.max(xAxisExtent[0], xAxisExtent[1]));
		out$1[1] = Math.min(Math.max(Math.min(yAxisExtent[0], yAxisExtent[1]), y), Math.max(yAxisExtent[0], yAxisExtent[1]));
		return out$1;
	};
	Cartesian2D$1.prototype.pointToData = function(point, clamp$1) {
		var out$1 = [];
		if (this._invTransform) return applyTransform$1(out$1, point, this._invTransform);
		var xAxis = this.getAxis("x");
		var yAxis = this.getAxis("y");
		out$1[0] = xAxis.coordToData(xAxis.toLocalCoord(point[0]), clamp$1);
		out$1[1] = yAxis.coordToData(yAxis.toLocalCoord(point[1]), clamp$1);
		return out$1;
	};
	Cartesian2D$1.prototype.getOtherAxis = function(axis) {
		return this.getAxis(axis.dim === "x" ? "y" : "x");
	};
	/**
	
	* Get rect area of cartesian.
	
	* Area will have a contain function to determine if a point is in the coordinate system.
	
	*/
	Cartesian2D$1.prototype.getArea = function(tolerance) {
		tolerance = tolerance || 0;
		var xExtent = this.getAxis("x").getGlobalExtent();
		var yExtent = this.getAxis("y").getGlobalExtent();
		var x = Math.min(xExtent[0], xExtent[1]) - tolerance;
		var y = Math.min(yExtent[0], yExtent[1]) - tolerance;
		var width = Math.max(xExtent[0], xExtent[1]) - x + tolerance;
		var height = Math.max(yExtent[0], yExtent[1]) - y + tolerance;
		return new BoundingRect_default(x, y, width, height);
	};
	return Cartesian2D$1;
}(Cartesian_default);
var Cartesian2D_default = Cartesian2D;
var inner$4 = makeInner();
function tickValuesToNumbers(axis, values) {
	var nums = map$1(values, function(val) {
		return axis.scale.parse(val);
	});
	if (axis.type === "time" && nums.length > 0) {
		nums.sort();
		nums.unshift(nums[0]);
		nums.push(nums[nums.length - 1]);
	}
	return nums;
}
function createAxisLabels(axis) {
	var custom = axis.getLabelModel().get("customValues");
	if (custom) {
		var labelFormatter_1 = makeLabelFormatter(axis);
		var extent_1 = axis.scale.getExtent();
		var tickNumbers = tickValuesToNumbers(axis, custom);
		var ticks = filter(tickNumbers, function(val) {
			return val >= extent_1[0] && val <= extent_1[1];
		});
		return { labels: map$1(ticks, function(numval) {
			var tick = { value: numval };
			return {
				formattedLabel: labelFormatter_1(tick),
				rawLabel: axis.scale.getLabel(tick),
				tickValue: numval
			};
		}) };
	}
	return axis.type === "category" ? makeCategoryLabels(axis) : makeRealNumberLabels(axis);
}
function createAxisTicks(axis, tickModel) {
	var custom = axis.getTickModel().get("customValues");
	if (custom) {
		var extent_2 = axis.scale.getExtent();
		var tickNumbers = tickValuesToNumbers(axis, custom);
		return { ticks: filter(tickNumbers, function(val) {
			return val >= extent_2[0] && val <= extent_2[1];
		}) };
	}
	return axis.type === "category" ? makeCategoryTicks(axis, tickModel) : { ticks: map$1(axis.scale.getTicks(), function(tick) {
		return tick.value;
	}) };
}
function makeCategoryLabels(axis) {
	var labelModel = axis.getLabelModel();
	var result = makeCategoryLabelsActually(axis, labelModel);
	return !labelModel.get("show") || axis.scale.isBlank() ? {
		labels: [],
		labelCategoryInterval: result.labelCategoryInterval
	} : result;
}
function makeCategoryLabelsActually(axis, labelModel) {
	var labelsCache = getListCache(axis, "labels");
	var optionLabelInterval = getOptionCategoryInterval(labelModel);
	var result = listCacheGet(labelsCache, optionLabelInterval);
	if (result) return result;
	var labels;
	var numericLabelInterval;
	if (isFunction(optionLabelInterval)) labels = makeLabelsByCustomizedCategoryInterval(axis, optionLabelInterval);
	else {
		numericLabelInterval = optionLabelInterval === "auto" ? makeAutoCategoryInterval(axis) : optionLabelInterval;
		labels = makeLabelsByNumericCategoryInterval(axis, numericLabelInterval);
	}
	return listCacheSet(labelsCache, optionLabelInterval, {
		labels,
		labelCategoryInterval: numericLabelInterval
	});
}
function makeCategoryTicks(axis, tickModel) {
	var ticksCache = getListCache(axis, "ticks");
	var optionTickInterval = getOptionCategoryInterval(tickModel);
	var result = listCacheGet(ticksCache, optionTickInterval);
	if (result) return result;
	var ticks;
	var tickCategoryInterval;
	if (!tickModel.get("show") || axis.scale.isBlank()) ticks = [];
	if (isFunction(optionTickInterval)) ticks = makeLabelsByCustomizedCategoryInterval(axis, optionTickInterval, true);
	else if (optionTickInterval === "auto") {
		var labelsResult = makeCategoryLabelsActually(axis, axis.getLabelModel());
		tickCategoryInterval = labelsResult.labelCategoryInterval;
		ticks = map$1(labelsResult.labels, function(labelItem) {
			return labelItem.tickValue;
		});
	} else {
		tickCategoryInterval = optionTickInterval;
		ticks = makeLabelsByNumericCategoryInterval(axis, tickCategoryInterval, true);
	}
	return listCacheSet(ticksCache, optionTickInterval, {
		ticks,
		tickCategoryInterval
	});
}
function makeRealNumberLabels(axis) {
	var ticks = axis.scale.getTicks();
	var labelFormatter = makeLabelFormatter(axis);
	return { labels: map$1(ticks, function(tick, idx) {
		return {
			level: tick.level,
			formattedLabel: labelFormatter(tick, idx),
			rawLabel: axis.scale.getLabel(tick),
			tickValue: tick.value
		};
	}) };
}
function getListCache(axis, prop) {
	return inner$4(axis)[prop] || (inner$4(axis)[prop] = []);
}
function listCacheGet(cache, key) {
	for (var i = 0; i < cache.length; i++) if (cache[i].key === key) return cache[i].value;
}
function listCacheSet(cache, key, value) {
	cache.push({
		key,
		value
	});
	return value;
}
function makeAutoCategoryInterval(axis) {
	var result = inner$4(axis).autoInterval;
	return result != null ? result : inner$4(axis).autoInterval = axis.calculateCategoryInterval();
}
function calculateCategoryInterval(axis) {
	var params = fetchAutoCategoryIntervalCalculationParams(axis);
	var labelFormatter = makeLabelFormatter(axis);
	var rotation = (params.axisRotate - params.labelRotate) / 180 * Math.PI;
	var ordinalScale = axis.scale;
	var ordinalExtent = ordinalScale.getExtent();
	var tickCount = ordinalScale.count();
	if (ordinalExtent[1] - ordinalExtent[0] < 1) return 0;
	var step = 1;
	if (tickCount > 40) step = Math.max(1, Math.floor(tickCount / 40));
	var tickValue = ordinalExtent[0];
	var unitSpan = axis.dataToCoord(tickValue + 1) - axis.dataToCoord(tickValue);
	var unitW = Math.abs(unitSpan * Math.cos(rotation));
	var unitH = Math.abs(unitSpan * Math.sin(rotation));
	var maxW = 0;
	var maxH = 0;
	for (; tickValue <= ordinalExtent[1]; tickValue += step) {
		var width = 0;
		var height = 0;
		var rect = getBoundingRect(labelFormatter({ value: tickValue }), params.font, "center", "top");
		width = rect.width * 1.3;
		height = rect.height * 1.3;
		maxW = Math.max(maxW, width, 7);
		maxH = Math.max(maxH, height, 7);
	}
	var dw = maxW / unitW;
	var dh = maxH / unitH;
	isNaN(dw) && (dw = Infinity);
	isNaN(dh) && (dh = Infinity);
	var interval = Math.max(0, Math.floor(Math.min(dw, dh)));
	var cache = inner$4(axis.model);
	var axisExtent = axis.getExtent();
	var lastAutoInterval = cache.lastAutoInterval;
	var lastTickCount = cache.lastTickCount;
	if (lastAutoInterval != null && lastTickCount != null && Math.abs(lastAutoInterval - interval) <= 1 && Math.abs(lastTickCount - tickCount) <= 1 && lastAutoInterval > interval && cache.axisExtent0 === axisExtent[0] && cache.axisExtent1 === axisExtent[1]) interval = lastAutoInterval;
	else {
		cache.lastTickCount = tickCount;
		cache.lastAutoInterval = interval;
		cache.axisExtent0 = axisExtent[0];
		cache.axisExtent1 = axisExtent[1];
	}
	return interval;
}
function fetchAutoCategoryIntervalCalculationParams(axis) {
	var labelModel = axis.getLabelModel();
	return {
		axisRotate: axis.getRotate ? axis.getRotate() : axis.isHorizontal && !axis.isHorizontal() ? 90 : 0,
		labelRotate: labelModel.get("rotate") || 0,
		font: labelModel.getFont()
	};
}
function makeLabelsByNumericCategoryInterval(axis, categoryInterval, onlyTick) {
	var labelFormatter = makeLabelFormatter(axis);
	var ordinalScale = axis.scale;
	var ordinalExtent = ordinalScale.getExtent();
	var labelModel = axis.getLabelModel();
	var result = [];
	var step = Math.max((categoryInterval || 0) + 1, 1);
	var startTick = ordinalExtent[0];
	var tickCount = ordinalScale.count();
	if (startTick !== 0 && step > 1 && tickCount / step > 2) startTick = Math.round(Math.ceil(startTick / step) * step);
	var showAllLabel = shouldShowAllLabels(axis);
	var includeMinLabel = labelModel.get("showMinLabel") || showAllLabel;
	var includeMaxLabel = labelModel.get("showMaxLabel") || showAllLabel;
	if (includeMinLabel && startTick !== ordinalExtent[0]) addItem(ordinalExtent[0]);
	var tickValue = startTick;
	for (; tickValue <= ordinalExtent[1]; tickValue += step) addItem(tickValue);
	if (includeMaxLabel && tickValue - step !== ordinalExtent[1]) addItem(ordinalExtent[1]);
	function addItem(tickValue$1) {
		var tickObj = { value: tickValue$1 };
		result.push(onlyTick ? tickValue$1 : {
			formattedLabel: labelFormatter(tickObj),
			rawLabel: ordinalScale.getLabel(tickObj),
			tickValue: tickValue$1
		});
	}
	return result;
}
function makeLabelsByCustomizedCategoryInterval(axis, categoryInterval, onlyTick) {
	var ordinalScale = axis.scale;
	var labelFormatter = makeLabelFormatter(axis);
	var result = [];
	each$4(ordinalScale.getTicks(), function(tick) {
		var rawLabel = ordinalScale.getLabel(tick);
		var tickValue = tick.value;
		if (categoryInterval(tick.value, rawLabel)) result.push(onlyTick ? tickValue : {
			formattedLabel: labelFormatter(tick),
			rawLabel,
			tickValue
		});
	});
	return result;
}
var NORMALIZED_EXTENT = [0, 1];
/**

* Base class of Axis.

*/
var Axis = function() {
	function Axis$1(dim, scale$3, extent$1) {
		this.onBand = false;
		this.inverse = false;
		this.dim = dim;
		this.scale = scale$3;
		this._extent = extent$1 || [0, 0];
	}
	/**
	
	* If axis extent contain given coord
	
	*/
	Axis$1.prototype.contain = function(coord) {
		var extent$1 = this._extent;
		var min$2 = Math.min(extent$1[0], extent$1[1]);
		var max$2 = Math.max(extent$1[0], extent$1[1]);
		return coord >= min$2 && coord <= max$2;
	};
	/**
	
	* If axis extent contain given data
	
	*/
	Axis$1.prototype.containData = function(data) {
		return this.scale.contain(data);
	};
	/**
	
	* Get coord extent.
	
	*/
	Axis$1.prototype.getExtent = function() {
		return this._extent.slice();
	};
	/**
	
	* Get precision used for formatting
	
	*/
	Axis$1.prototype.getPixelPrecision = function(dataExtent) {
		return getPixelPrecision(dataExtent || this.scale.getExtent(), this._extent);
	};
	/**
	
	* Set coord extent
	
	*/
	Axis$1.prototype.setExtent = function(start$1, end$1) {
		var extent$1 = this._extent;
		extent$1[0] = start$1;
		extent$1[1] = end$1;
	};
	/**
	
	* Convert data to coord. Data is the rank if it has an ordinal scale
	
	*/
	Axis$1.prototype.dataToCoord = function(data, clamp$1) {
		var extent$1 = this._extent;
		var scale$3 = this.scale;
		data = scale$3.normalize(data);
		if (this.onBand && scale$3.type === "ordinal") {
			extent$1 = extent$1.slice();
			fixExtentWithBands(extent$1, scale$3.count());
		}
		return linearMap(data, NORMALIZED_EXTENT, extent$1, clamp$1);
	};
	/**
	
	* Convert coord to data. Data is the rank if it has an ordinal scale
	
	*/
	Axis$1.prototype.coordToData = function(coord, clamp$1) {
		var extent$1 = this._extent;
		var scale$3 = this.scale;
		if (this.onBand && scale$3.type === "ordinal") {
			extent$1 = extent$1.slice();
			fixExtentWithBands(extent$1, scale$3.count());
		}
		var t = linearMap(coord, extent$1, NORMALIZED_EXTENT, clamp$1);
		return this.scale.scale(t);
	};
	/**
	
	* Convert pixel point to data in axis
	
	*/
	Axis$1.prototype.pointToData = function(point, clamp$1) {
		return;
	};
	/**
	
	* Different from `zrUtil.map(axis.getTicks(), axis.dataToCoord, axis)`,
	
	* `axis.getTicksCoords` considers `onBand`, which is used by
	
	* `boundaryGap:true` of category axis and splitLine and splitArea.
	
	* @param opt.tickModel default: axis.model.getModel('axisTick')
	
	* @param opt.clamp If `true`, the first and the last
	
	*        tick must be at the axis end points. Otherwise, clip ticks
	
	*        that outside the axis extent.
	
	*/
	Axis$1.prototype.getTicksCoords = function(opt) {
		opt = opt || {};
		var tickModel = opt.tickModel || this.getTickModel();
		var result = createAxisTicks(this, tickModel);
		var ticks = result.ticks;
		var ticksCoords = map$1(ticks, function(tickVal) {
			return {
				coord: this.dataToCoord(this.scale.type === "ordinal" ? this.scale.getRawOrdinalNumber(tickVal) : tickVal),
				tickValue: tickVal
			};
		}, this);
		var alignWithLabel = tickModel.get("alignWithLabel");
		fixOnBandTicksCoords(this, ticksCoords, alignWithLabel, opt.clamp);
		return ticksCoords;
	};
	Axis$1.prototype.getMinorTicksCoords = function() {
		if (this.scale.type === "ordinal") return [];
		var minorTickModel = this.model.getModel("minorTick");
		var splitNumber = minorTickModel.get("splitNumber");
		if (!(splitNumber > 0 && splitNumber < 100)) splitNumber = 5;
		var minorTicks = this.scale.getMinorTicks(splitNumber);
		var minorTicksCoords = map$1(minorTicks, function(minorTicksGroup) {
			return map$1(minorTicksGroup, function(minorTick) {
				return {
					coord: this.dataToCoord(minorTick),
					tickValue: minorTick
				};
			}, this);
		}, this);
		return minorTicksCoords;
	};
	Axis$1.prototype.getViewLabels = function() {
		return createAxisLabels(this).labels;
	};
	Axis$1.prototype.getLabelModel = function() {
		return this.model.getModel("axisLabel");
	};
	/**
	
	* Notice here we only get the default tick model. For splitLine
	
	* or splitArea, we should pass the splitLineModel or splitAreaModel
	
	* manually when calling `getTicksCoords`.
	
	* In GL, this method may be overridden to:
	
	* `axisModel.getModel('axisTick', grid3DModel.getModel('axisTick'));`
	
	*/
	Axis$1.prototype.getTickModel = function() {
		return this.model.getModel("axisTick");
	};
	/**
	
	* Get width of band
	
	*/
	Axis$1.prototype.getBandWidth = function() {
		var axisExtent = this._extent;
		var dataExtent = this.scale.getExtent();
		var len$1 = dataExtent[1] - dataExtent[0] + (this.onBand ? 1 : 0);
		len$1 === 0 && (len$1 = 1);
		var size = Math.abs(axisExtent[1] - axisExtent[0]);
		return Math.abs(size) / len$1;
	};
	/**
	
	* Only be called in category axis.
	
	* Can be overridden, consider other axes like in 3D.
	
	* @return Auto interval for cateogry axis tick and label
	
	*/
	Axis$1.prototype.calculateCategoryInterval = function() {
		return calculateCategoryInterval(this);
	};
	return Axis$1;
}();
function fixExtentWithBands(extent$1, nTick) {
	var size = extent$1[1] - extent$1[0];
	var len$1 = nTick;
	var margin = size / len$1 / 2;
	extent$1[0] += margin;
	extent$1[1] -= margin;
}
function fixOnBandTicksCoords(axis, ticksCoords, alignWithLabel, clamp$1) {
	var ticksLen = ticksCoords.length;
	if (!axis.onBand || alignWithLabel || !ticksLen) return;
	var axisExtent = axis.getExtent();
	var last;
	var diffSize;
	if (ticksLen === 1) {
		ticksCoords[0].coord = axisExtent[0];
		last = ticksCoords[1] = {
			coord: axisExtent[1],
			tickValue: ticksCoords[0].tickValue
		};
	} else {
		var crossLen = ticksCoords[ticksLen - 1].tickValue - ticksCoords[0].tickValue;
		var shift_1 = (ticksCoords[ticksLen - 1].coord - ticksCoords[0].coord) / crossLen;
		each$4(ticksCoords, function(ticksItem) {
			ticksItem.coord -= shift_1 / 2;
		});
		var dataExtent = axis.scale.getExtent();
		diffSize = 1 + dataExtent[1] - ticksCoords[ticksLen - 1].tickValue;
		last = {
			coord: ticksCoords[ticksLen - 1].coord + shift_1 * diffSize,
			tickValue: dataExtent[1] + 1
		};
		ticksCoords.push(last);
	}
	var inverse = axisExtent[0] > axisExtent[1];
	if (littleThan(ticksCoords[0].coord, axisExtent[0])) clamp$1 ? ticksCoords[0].coord = axisExtent[0] : ticksCoords.shift();
	if (clamp$1 && littleThan(axisExtent[0], ticksCoords[0].coord)) ticksCoords.unshift({ coord: axisExtent[0] });
	if (littleThan(axisExtent[1], last.coord)) clamp$1 ? last.coord = axisExtent[1] : ticksCoords.pop();
	if (clamp$1 && littleThan(last.coord, axisExtent[1])) ticksCoords.push({ coord: axisExtent[1] });
	function littleThan(a, b) {
		a = round(a);
		b = round(b);
		return inverse ? a > b : a < b;
	}
}
var Axis_default = Axis;
var Axis2D = function(_super) {
	__extends(Axis2D$1, _super);
	function Axis2D$1(dim, scale$3, coordExtent, axisType, position) {
		var _this = _super.call(this, dim, scale$3, coordExtent) || this;
		/**
		
		* Index of axis, can be used as key
		
		* Injected outside.
		
		*/
		_this.index = 0;
		_this.type = axisType || "value";
		_this.position = position || "bottom";
		return _this;
	}
	Axis2D$1.prototype.isHorizontal = function() {
		var position = this.position;
		return position === "top" || position === "bottom";
	};
	/**
	
	* Each item cooresponds to this.getExtent(), which
	
	* means globalExtent[0] may greater than globalExtent[1],
	
	* unless `asc` is input.
	
	*
	
	* @param {boolean} [asc]
	
	* @return {Array.<number>}
	
	*/
	Axis2D$1.prototype.getGlobalExtent = function(asc) {
		var ret = this.getExtent();
		ret[0] = this.toGlobalCoord(ret[0]);
		ret[1] = this.toGlobalCoord(ret[1]);
		asc && ret[0] > ret[1] && ret.reverse();
		return ret;
	};
	Axis2D$1.prototype.pointToData = function(point, clamp$1) {
		return this.coordToData(this.toLocalCoord(point[this.dim === "x" ? 0 : 1]), clamp$1);
	};
	/**
	
	* Set ordinalSortInfo
	
	* @param info new OrdinalSortInfo
	
	*/
	Axis2D$1.prototype.setCategorySortInfo = function(info) {
		if (this.type !== "category") return false;
		this.model.option.categorySortInfo = info;
		this.scale.setSortInfo(info);
	};
	return Axis2D$1;
}(Axis_default);
var Axis2D_default = Axis2D;
function layout(gridModel, axisModel, opt) {
	opt = opt || {};
	var grid = gridModel.coordinateSystem;
	var axis = axisModel.axis;
	var layout$2 = {};
	var otherAxisOnZeroOf = axis.getAxesOnZeroOf()[0];
	var rawAxisPosition = axis.position;
	var axisPosition = otherAxisOnZeroOf ? "onZero" : rawAxisPosition;
	var axisDim = axis.dim;
	var rect = grid.getRect();
	var rectBound = [
		rect.x,
		rect.x + rect.width,
		rect.y,
		rect.y + rect.height
	];
	var idx = {
		left: 0,
		right: 1,
		top: 0,
		bottom: 1,
		onZero: 2
	};
	var axisOffset = axisModel.get("offset") || 0;
	var posBound = axisDim === "x" ? [rectBound[2] - axisOffset, rectBound[3] + axisOffset] : [rectBound[0] - axisOffset, rectBound[1] + axisOffset];
	if (otherAxisOnZeroOf) {
		var onZeroCoord = otherAxisOnZeroOf.toGlobalCoord(otherAxisOnZeroOf.dataToCoord(0));
		posBound[idx.onZero] = Math.max(Math.min(onZeroCoord, posBound[1]), posBound[0]);
	}
	layout$2.position = [axisDim === "y" ? posBound[idx[axisPosition]] : rectBound[0], axisDim === "x" ? posBound[idx[axisPosition]] : rectBound[3]];
	layout$2.rotation = Math.PI / 2 * (axisDim === "x" ? 0 : 1);
	var dirMap = {
		top: -1,
		bottom: 1,
		left: -1,
		right: 1
	};
	layout$2.labelDirection = layout$2.tickDirection = layout$2.nameDirection = dirMap[rawAxisPosition];
	layout$2.labelOffset = otherAxisOnZeroOf ? posBound[idx[rawAxisPosition]] - posBound[idx.onZero] : 0;
	if (axisModel.get(["axisTick", "inside"])) layout$2.tickDirection = -layout$2.tickDirection;
	if (retrieve(opt.labelInside, axisModel.get(["axisLabel", "inside"]))) layout$2.labelDirection = -layout$2.labelDirection;
	var labelRotate = axisModel.get(["axisLabel", "rotate"]);
	layout$2.labelRotate = axisPosition === "top" ? -labelRotate : labelRotate;
	layout$2.z2 = 1;
	return layout$2;
}
function isCartesian2DSeries(seriesModel) {
	return seriesModel.get("coordinateSystem") === "cartesian2d";
}
function findAxisModels(seriesModel) {
	var axisModelMap = {
		xAxisModel: null,
		yAxisModel: null
	};
	each$4(axisModelMap, function(v, key) {
		var axisType = key.replace(/Model$/, "");
		var axisModel = seriesModel.getReferringComponents(axisType, SINGLE_REFERRING).models[0];
		axisModelMap[key] = axisModel;
	});
	return axisModelMap;
}
var mathLog = Math.log;
function alignScaleTicks(scale$3, axisModel, alignToScale) {
	var intervalScaleProto$1 = Interval_default.prototype;
	var alignToTicks = intervalScaleProto$1.getTicks.call(alignToScale);
	var alignToNicedTicks = intervalScaleProto$1.getTicks.call(alignToScale, true);
	var alignToSplitNumber = alignToTicks.length - 1;
	var alignToInterval = intervalScaleProto$1.getInterval.call(alignToScale);
	var scaleExtent = getScaleExtent(scale$3, axisModel);
	var rawExtent = scaleExtent.extent;
	var isMinFixed = scaleExtent.fixMin;
	var isMaxFixed = scaleExtent.fixMax;
	if (scale$3.type === "log") {
		var logBase = mathLog(scale$3.base);
		rawExtent = [mathLog(rawExtent[0]) / logBase, mathLog(rawExtent[1]) / logBase];
	}
	scale$3.setExtent(rawExtent[0], rawExtent[1]);
	scale$3.calcNiceExtent({
		splitNumber: alignToSplitNumber,
		fixMin: isMinFixed,
		fixMax: isMaxFixed
	});
	var extent$1 = intervalScaleProto$1.getExtent.call(scale$3);
	if (isMinFixed) rawExtent[0] = extent$1[0];
	if (isMaxFixed) rawExtent[1] = extent$1[1];
	var interval = intervalScaleProto$1.getInterval.call(scale$3);
	var min$2 = rawExtent[0];
	var max$2 = rawExtent[1];
	if (isMinFixed && isMaxFixed) interval = (max$2 - min$2) / alignToSplitNumber;
	else if (isMinFixed) {
		max$2 = rawExtent[0] + interval * alignToSplitNumber;
		while (max$2 < rawExtent[1] && isFinite(max$2) && isFinite(rawExtent[1])) {
			interval = increaseInterval(interval);
			max$2 = rawExtent[0] + interval * alignToSplitNumber;
		}
	} else if (isMaxFixed) {
		min$2 = rawExtent[1] - interval * alignToSplitNumber;
		while (min$2 > rawExtent[0] && isFinite(min$2) && isFinite(rawExtent[0])) {
			interval = increaseInterval(interval);
			min$2 = rawExtent[1] - interval * alignToSplitNumber;
		}
	} else {
		var nicedSplitNumber = scale$3.getTicks().length - 1;
		if (nicedSplitNumber > alignToSplitNumber) interval = increaseInterval(interval);
		var range = interval * alignToSplitNumber;
		max$2 = Math.ceil(rawExtent[1] / interval) * interval;
		min$2 = round(max$2 - range);
		if (min$2 < 0 && rawExtent[0] >= 0) {
			min$2 = 0;
			max$2 = round(range);
		} else if (max$2 > 0 && rawExtent[1] <= 0) {
			max$2 = 0;
			min$2 = -round(range);
		}
	}
	var t0 = (alignToTicks[0].value - alignToNicedTicks[0].value) / alignToInterval;
	var t1 = (alignToTicks[alignToSplitNumber].value - alignToNicedTicks[alignToSplitNumber].value) / alignToInterval;
	intervalScaleProto$1.setExtent.call(scale$3, min$2 + interval * t0, max$2 + interval * t1);
	intervalScaleProto$1.setInterval.call(scale$3, interval);
	if (t0 || t1) intervalScaleProto$1.setNiceExtent.call(scale$3, min$2 + interval, max$2 - interval);
	if (0) var ticks;
}
var Grid = function() {
	function Grid$1(gridModel, ecModel, api) {
		this.type = "grid";
		this._coordsMap = {};
		this._coordsList = [];
		this._axesMap = {};
		this._axesList = [];
		this.axisPointerEnabled = true;
		this.dimensions = cartesian2DDimensions;
		this._initCartesian(gridModel, ecModel, api);
		this.model = gridModel;
	}
	Grid$1.prototype.getRect = function() {
		return this._rect;
	};
	Grid$1.prototype.update = function(ecModel, api) {
		var axesMap = this._axesMap;
		this._updateScale(ecModel, this.model);
		function updateAxisTicks(axes) {
			var alignTo;
			var axesIndices = keys(axes);
			var len$1 = axesIndices.length;
			if (!len$1) return;
			var axisNeedsAlign = [];
			for (var i = len$1 - 1; i >= 0; i--) {
				var idx = +axesIndices[i];
				var axis = axes[idx];
				var model = axis.model;
				var scale$3 = axis.scale;
				if (isIntervalOrLogScale(scale$3) && model.get("alignTicks") && model.get("interval") == null) axisNeedsAlign.push(axis);
				else {
					niceScaleExtent(scale$3, model);
					if (isIntervalOrLogScale(scale$3)) alignTo = axis;
				}
			}
			if (axisNeedsAlign.length) {
				if (!alignTo) {
					alignTo = axisNeedsAlign.pop();
					niceScaleExtent(alignTo.scale, alignTo.model);
				}
				each$4(axisNeedsAlign, function(axis$1) {
					alignScaleTicks(axis$1.scale, axis$1.model, alignTo.scale);
				});
			}
		}
		updateAxisTicks(axesMap.x);
		updateAxisTicks(axesMap.y);
		var onZeroRecords = {};
		each$4(axesMap.x, function(xAxis) {
			fixAxisOnZero(axesMap, "y", xAxis, onZeroRecords);
		});
		each$4(axesMap.y, function(yAxis) {
			fixAxisOnZero(axesMap, "x", yAxis, onZeroRecords);
		});
		this.resize(this.model, api);
	};
	/**
	
	* Resize the grid
	
	*/
	Grid$1.prototype.resize = function(gridModel, api, ignoreContainLabel) {
		var boxLayoutParams = gridModel.getBoxLayoutParams();
		var isContainLabel = !ignoreContainLabel && gridModel.get("containLabel");
		var gridRect = getLayoutRect(boxLayoutParams, {
			width: api.getWidth(),
			height: api.getHeight()
		});
		this._rect = gridRect;
		var axesList = this._axesList;
		adjustAxes();
		if (isContainLabel) {
			each$4(axesList, function(axis) {
				if (!axis.model.get(["axisLabel", "inside"])) {
					var labelUnionRect = estimateLabelUnionRect(axis);
					if (labelUnionRect) {
						var dim = axis.isHorizontal() ? "height" : "width";
						var margin = axis.model.get(["axisLabel", "margin"]);
						gridRect[dim] -= labelUnionRect[dim] + margin;
						if (axis.position === "top") gridRect.y += labelUnionRect.height + margin;
						else if (axis.position === "left") gridRect.x += labelUnionRect.width + margin;
					}
				}
			});
			adjustAxes();
		}
		each$4(this._coordsList, function(coord) {
			coord.calcAffineTransform();
		});
		function adjustAxes() {
			each$4(axesList, function(axis) {
				var isHorizontal = axis.isHorizontal();
				var extent$1 = isHorizontal ? [0, gridRect.width] : [0, gridRect.height];
				var idx = axis.inverse ? 1 : 0;
				axis.setExtent(extent$1[idx], extent$1[1 - idx]);
				updateAxisTransform(axis, isHorizontal ? gridRect.x : gridRect.y);
			});
		}
	};
	Grid$1.prototype.getAxis = function(dim, axisIndex) {
		var axesMapOnDim = this._axesMap[dim];
		if (axesMapOnDim != null) return axesMapOnDim[axisIndex || 0];
	};
	Grid$1.prototype.getAxes = function() {
		return this._axesList.slice();
	};
	Grid$1.prototype.getCartesian = function(xAxisIndex, yAxisIndex) {
		if (xAxisIndex != null && yAxisIndex != null) {
			var key = "x" + xAxisIndex + "y" + yAxisIndex;
			return this._coordsMap[key];
		}
		if (isObject$2(xAxisIndex)) {
			yAxisIndex = xAxisIndex.yAxisIndex;
			xAxisIndex = xAxisIndex.xAxisIndex;
		}
		for (var i = 0, coordList = this._coordsList; i < coordList.length; i++) if (coordList[i].getAxis("x").index === xAxisIndex || coordList[i].getAxis("y").index === yAxisIndex) return coordList[i];
	};
	Grid$1.prototype.getCartesians = function() {
		return this._coordsList.slice();
	};
	/**
	
	* @implements
	
	*/
	Grid$1.prototype.convertToPixel = function(ecModel, finder, value) {
		var target = this._findConvertTarget(finder);
		return target.cartesian ? target.cartesian.dataToPoint(value) : target.axis ? target.axis.toGlobalCoord(target.axis.dataToCoord(value)) : null;
	};
	/**
	
	* @implements
	
	*/
	Grid$1.prototype.convertFromPixel = function(ecModel, finder, value) {
		var target = this._findConvertTarget(finder);
		return target.cartesian ? target.cartesian.pointToData(value) : target.axis ? target.axis.coordToData(target.axis.toLocalCoord(value)) : null;
	};
	Grid$1.prototype._findConvertTarget = function(finder) {
		var seriesModel = finder.seriesModel;
		var xAxisModel = finder.xAxisModel || seriesModel && seriesModel.getReferringComponents("xAxis", SINGLE_REFERRING).models[0];
		var yAxisModel = finder.yAxisModel || seriesModel && seriesModel.getReferringComponents("yAxis", SINGLE_REFERRING).models[0];
		var gridModel = finder.gridModel;
		var coordsList = this._coordsList;
		var cartesian;
		var axis;
		if (seriesModel) {
			cartesian = seriesModel.coordinateSystem;
			indexOf(coordsList, cartesian) < 0 && (cartesian = null);
		} else if (xAxisModel && yAxisModel) cartesian = this.getCartesian(xAxisModel.componentIndex, yAxisModel.componentIndex);
		else if (xAxisModel) axis = this.getAxis("x", xAxisModel.componentIndex);
		else if (yAxisModel) axis = this.getAxis("y", yAxisModel.componentIndex);
		else if (gridModel) {
			var grid = gridModel.coordinateSystem;
			if (grid === this) cartesian = this._coordsList[0];
		}
		return {
			cartesian,
			axis
		};
	};
	/**
	
	* @implements
	
	*/
	Grid$1.prototype.containPoint = function(point) {
		var coord = this._coordsList[0];
		if (coord) return coord.containPoint(point);
	};
	/**
	
	* Initialize cartesian coordinate systems
	
	*/
	Grid$1.prototype._initCartesian = function(gridModel, ecModel, api) {
		var _this = this;
		var grid = this;
		var axisPositionUsed = {
			left: false,
			right: false,
			top: false,
			bottom: false
		};
		var axesMap = {
			x: {},
			y: {}
		};
		var axesCount = {
			x: 0,
			y: 0
		};
		ecModel.eachComponent("xAxis", createAxisCreator("x"), this);
		ecModel.eachComponent("yAxis", createAxisCreator("y"), this);
		if (!axesCount.x || !axesCount.y) {
			this._axesMap = {};
			this._axesList = [];
			return;
		}
		this._axesMap = axesMap;
		each$4(axesMap.x, function(xAxis, xAxisIndex) {
			each$4(axesMap.y, function(yAxis, yAxisIndex) {
				var key = "x" + xAxisIndex + "y" + yAxisIndex;
				var cartesian = new Cartesian2D_default(key);
				cartesian.master = _this;
				cartesian.model = gridModel;
				_this._coordsMap[key] = cartesian;
				_this._coordsList.push(cartesian);
				cartesian.addAxis(xAxis);
				cartesian.addAxis(yAxis);
			});
		});
		function createAxisCreator(dimName) {
			return function(axisModel, idx) {
				if (!isAxisUsedInTheGrid(axisModel, gridModel)) return;
				var axisPosition = axisModel.get("position");
				if (dimName === "x") {
					if (axisPosition !== "top" && axisPosition !== "bottom") axisPosition = axisPositionUsed.bottom ? "top" : "bottom";
				} else if (axisPosition !== "left" && axisPosition !== "right") axisPosition = axisPositionUsed.left ? "right" : "left";
				axisPositionUsed[axisPosition] = true;
				var axis = new Axis2D_default(dimName, createScaleByModel(axisModel), [0, 0], axisModel.get("type"), axisPosition);
				var isCategory$1 = axis.type === "category";
				axis.onBand = isCategory$1 && axisModel.get("boundaryGap");
				axis.inverse = axisModel.get("inverse");
				axisModel.axis = axis;
				axis.model = axisModel;
				axis.grid = grid;
				axis.index = idx;
				grid._axesList.push(axis);
				axesMap[dimName][idx] = axis;
				axesCount[dimName]++;
			};
		}
	};
	/**
	
	* Update cartesian properties from series.
	
	*/
	Grid$1.prototype._updateScale = function(ecModel, gridModel) {
		each$4(this._axesList, function(axis) {
			axis.scale.setExtent(Infinity, -Infinity);
			if (axis.type === "category") {
				var categorySortInfo = axis.model.get("categorySortInfo");
				axis.scale.setSortInfo(categorySortInfo);
			}
		});
		ecModel.eachSeries(function(seriesModel) {
			if (isCartesian2DSeries(seriesModel)) {
				var axesModelMap = findAxisModels(seriesModel);
				var xAxisModel = axesModelMap.xAxisModel;
				var yAxisModel = axesModelMap.yAxisModel;
				if (!isAxisUsedInTheGrid(xAxisModel, gridModel) || !isAxisUsedInTheGrid(yAxisModel, gridModel)) return;
				var cartesian = this.getCartesian(xAxisModel.componentIndex, yAxisModel.componentIndex);
				var data = seriesModel.getData();
				var xAxis = cartesian.getAxis("x");
				var yAxis = cartesian.getAxis("y");
				unionExtent(data, xAxis);
				unionExtent(data, yAxis);
			}
		}, this);
		function unionExtent(data, axis) {
			each$4(getDataDimensionsOnAxis(data, axis.dim), function(dim) {
				axis.scale.unionExtentFromData(data, dim);
			});
		}
	};
	/**
	
	* @param dim 'x' or 'y' or 'auto' or null/undefined
	
	*/
	Grid$1.prototype.getTooltipAxes = function(dim) {
		var baseAxes = [];
		var otherAxes = [];
		each$4(this.getCartesians(), function(cartesian) {
			var baseAxis = dim != null && dim !== "auto" ? cartesian.getAxis(dim) : cartesian.getBaseAxis();
			var otherAxis = cartesian.getOtherAxis(baseAxis);
			indexOf(baseAxes, baseAxis) < 0 && baseAxes.push(baseAxis);
			indexOf(otherAxes, otherAxis) < 0 && otherAxes.push(otherAxis);
		});
		return {
			baseAxes,
			otherAxes
		};
	};
	Grid$1.create = function(ecModel, api) {
		var grids = [];
		ecModel.eachComponent("grid", function(gridModel, idx) {
			var grid = new Grid$1(gridModel, ecModel, api);
			grid.name = "grid_" + idx;
			grid.resize(gridModel, api, true);
			gridModel.coordinateSystem = grid;
			grids.push(grid);
		});
		ecModel.eachSeries(function(seriesModel) {
			if (!isCartesian2DSeries(seriesModel)) return;
			var axesModelMap = findAxisModels(seriesModel);
			var xAxisModel = axesModelMap.xAxisModel;
			var yAxisModel = axesModelMap.yAxisModel;
			var gridModel = xAxisModel.getCoordSysModel();
			var grid = gridModel.coordinateSystem;
			seriesModel.coordinateSystem = grid.getCartesian(xAxisModel.componentIndex, yAxisModel.componentIndex);
		});
		return grids;
	};
	Grid$1.dimensions = cartesian2DDimensions;
	return Grid$1;
}();
/**

* Check if the axis is used in the specified grid.

*/
function isAxisUsedInTheGrid(axisModel, gridModel) {
	return axisModel.getCoordSysModel() === gridModel;
}
function fixAxisOnZero(axesMap, otherAxisDim, axis, onZeroRecords) {
	axis.getAxesOnZeroOf = function() {
		return otherAxisOnZeroOf ? [otherAxisOnZeroOf] : [];
	};
	var otherAxes = axesMap[otherAxisDim];
	var otherAxisOnZeroOf;
	var axisModel = axis.model;
	var onZero = axisModel.get(["axisLine", "onZero"]);
	var onZeroAxisIndex = axisModel.get(["axisLine", "onZeroAxisIndex"]);
	if (!onZero) return;
	if (onZeroAxisIndex != null) {
		if (canOnZeroToAxis(otherAxes[onZeroAxisIndex])) otherAxisOnZeroOf = otherAxes[onZeroAxisIndex];
	} else for (var idx in otherAxes) if (otherAxes.hasOwnProperty(idx) && canOnZeroToAxis(otherAxes[idx]) && !onZeroRecords[getOnZeroRecordKey(otherAxes[idx])]) {
		otherAxisOnZeroOf = otherAxes[idx];
		break;
	}
	if (otherAxisOnZeroOf) onZeroRecords[getOnZeroRecordKey(otherAxisOnZeroOf)] = true;
	function getOnZeroRecordKey(axis$1) {
		return axis$1.dim + "_" + axis$1.index;
	}
}
function canOnZeroToAxis(axis) {
	return axis && axis.type !== "category" && axis.type !== "time" && ifAxisCrossZero(axis);
}
function updateAxisTransform(axis, coordBase) {
	var axisExtent = axis.getExtent();
	var axisExtentSum = axisExtent[0] + axisExtent[1];
	axis.toGlobalCoord = axis.dim === "x" ? function(coord) {
		return coord + coordBase;
	} : function(coord) {
		return axisExtentSum - coord + coordBase;
	};
	axis.toLocalCoord = axis.dim === "x" ? function(coord) {
		return coord - coordBase;
	} : function(coord) {
		return axisExtentSum - coord + coordBase;
	};
}
var Grid_default = Grid;
var PI = Math.PI;
/**

* A final axis is translated and rotated from a "standard axis".

* So opt.position and opt.rotation is required.

*

* A standard axis is and axis from [0, 0] to [0, axisExtent[1]],

* for example: (0, 0) ------------> (0, 50)

*

* nameDirection or tickDirection or labelDirection is 1 means tick

* or label is below the standard axis, whereas is -1 means above

* the standard axis. labelOffset means offset between label and axis,

* which is useful when 'onZero', where axisLabel is in the grid and

* label in outside grid.

*

* Tips: like always,

* positive rotation represents anticlockwise, and negative rotation

* represents clockwise.

* The direction of position coordinate is the same as the direction

* of screen coordinate.

*

* Do not need to consider axis 'inverse', which is auto processed by

* axis extent.

*/
var AxisBuilder = function() {
	function AxisBuilder$1(axisModel, opt) {
		this.group = new Group_default();
		this.opt = opt;
		this.axisModel = axisModel;
		defaults(opt, {
			labelOffset: 0,
			nameDirection: 1,
			tickDirection: 1,
			labelDirection: 1,
			silent: true,
			handleAutoShown: function() {
				return true;
			}
		});
		var transformGroup = new Group_default({
			x: opt.position[0],
			y: opt.position[1],
			rotation: opt.rotation
		});
		transformGroup.updateTransform();
		this._transformGroup = transformGroup;
	}
	AxisBuilder$1.prototype.hasBuilder = function(name) {
		return !!builders[name];
	};
	AxisBuilder$1.prototype.add = function(name) {
		builders[name](this.opt, this.axisModel, this.group, this._transformGroup);
	};
	AxisBuilder$1.prototype.getGroup = function() {
		return this.group;
	};
	AxisBuilder$1.innerTextLayout = function(axisRotation, textRotation, direction) {
		var rotationDiff = remRadian(textRotation - axisRotation);
		var textAlign;
		var textVerticalAlign;
		if (isRadianAroundZero(rotationDiff)) {
			textVerticalAlign = direction > 0 ? "top" : "bottom";
			textAlign = "center";
		} else if (isRadianAroundZero(rotationDiff - PI)) {
			textVerticalAlign = direction > 0 ? "bottom" : "top";
			textAlign = "center";
		} else {
			textVerticalAlign = "middle";
			if (rotationDiff > 0 && rotationDiff < PI) textAlign = direction > 0 ? "right" : "left";
			else textAlign = direction > 0 ? "left" : "right";
		}
		return {
			rotation: rotationDiff,
			textAlign,
			textVerticalAlign
		};
	};
	AxisBuilder$1.makeAxisEventDataBase = function(axisModel) {
		var eventData = {
			componentType: axisModel.mainType,
			componentIndex: axisModel.componentIndex
		};
		eventData[axisModel.mainType + "Index"] = axisModel.componentIndex;
		return eventData;
	};
	AxisBuilder$1.isLabelSilent = function(axisModel) {
		var tooltipOpt = axisModel.get("tooltip");
		return axisModel.get("silent") || !(axisModel.get("triggerEvent") || tooltipOpt && tooltipOpt.show);
	};
	return AxisBuilder$1;
}();
var builders = {
	axisLine: function(opt, axisModel, group, transformGroup) {
		var shown = axisModel.get(["axisLine", "show"]);
		if (shown === "auto" && opt.handleAutoShown) shown = opt.handleAutoShown("axisLine");
		if (!shown) return;
		var extent$1 = axisModel.axis.getExtent();
		var matrix = transformGroup.transform;
		var pt1 = [extent$1[0], 0];
		var pt2 = [extent$1[1], 0];
		var inverse = pt1[0] > pt2[0];
		if (matrix) {
			applyTransform$1(pt1, pt1, matrix);
			applyTransform$1(pt2, pt2, matrix);
		}
		var lineStyle = extend({ lineCap: "round" }, axisModel.getModel(["axisLine", "lineStyle"]).getLineStyle());
		var line = new Line_default({
			shape: {
				x1: pt1[0],
				y1: pt1[1],
				x2: pt2[0],
				y2: pt2[1]
			},
			style: lineStyle,
			strokeContainThreshold: opt.strokeContainThreshold || 5,
			silent: true,
			z2: 1
		});
		subPixelOptimizeLine(line.shape, line.style.lineWidth);
		line.anid = "line";
		group.add(line);
		var arrows = axisModel.get(["axisLine", "symbol"]);
		if (arrows != null) {
			var arrowSize = axisModel.get(["axisLine", "symbolSize"]);
			if (isString(arrows)) arrows = [arrows, arrows];
			if (isString(arrowSize) || isNumber(arrowSize)) arrowSize = [arrowSize, arrowSize];
			var arrowOffset = normalizeSymbolOffset(axisModel.get(["axisLine", "symbolOffset"]) || 0, arrowSize);
			var symbolWidth_1 = arrowSize[0];
			var symbolHeight_1 = arrowSize[1];
			each$4([{
				rotate: opt.rotation + Math.PI / 2,
				offset: arrowOffset[0],
				r: 0
			}, {
				rotate: opt.rotation - Math.PI / 2,
				offset: arrowOffset[1],
				r: Math.sqrt((pt1[0] - pt2[0]) * (pt1[0] - pt2[0]) + (pt1[1] - pt2[1]) * (pt1[1] - pt2[1]))
			}], function(point, index) {
				if (arrows[index] !== "none" && arrows[index] != null) {
					var symbol = createSymbol(arrows[index], -symbolWidth_1 / 2, -symbolHeight_1 / 2, symbolWidth_1, symbolHeight_1, lineStyle.stroke, true);
					var r = point.r + point.offset;
					var pt = inverse ? pt2 : pt1;
					symbol.attr({
						rotation: point.rotate,
						x: pt[0] + r * Math.cos(opt.rotation),
						y: pt[1] - r * Math.sin(opt.rotation),
						silent: true,
						z2: 11
					});
					group.add(symbol);
				}
			});
		}
	},
	axisTickLabel: function(opt, axisModel, group, transformGroup) {
		var ticksEls = buildAxisMajorTicks(group, transformGroup, axisModel, opt);
		var labelEls = buildAxisLabel(group, transformGroup, axisModel, opt);
		fixMinMaxLabelShow(axisModel, labelEls, ticksEls);
		buildAxisMinorTicks(group, transformGroup, axisModel, opt.tickDirection);
		if (axisModel.get(["axisLabel", "hideOverlap"])) {
			var labelList = prepareLayoutList(map$1(labelEls, function(label) {
				return {
					label,
					priority: label.z2,
					defaultAttr: { ignore: label.ignore }
				};
			}));
			hideOverlap(labelList);
		}
	},
	axisName: function(opt, axisModel, group, transformGroup) {
		var name = retrieve(opt.axisName, axisModel.get("name"));
		if (!name) return;
		var nameLocation = axisModel.get("nameLocation");
		var nameDirection = opt.nameDirection;
		var textStyleModel = axisModel.getModel("nameTextStyle");
		var gap = axisModel.get("nameGap") || 0;
		var extent$1 = axisModel.axis.getExtent();
		var gapSignal = extent$1[0] > extent$1[1] ? -1 : 1;
		var pos = [nameLocation === "start" ? extent$1[0] - gapSignal * gap : nameLocation === "end" ? extent$1[1] + gapSignal * gap : (extent$1[0] + extent$1[1]) / 2, isNameLocationCenter(nameLocation) ? opt.labelOffset + nameDirection * gap : 0];
		var labelLayout;
		var nameRotation = axisModel.get("nameRotate");
		if (nameRotation != null) nameRotation = nameRotation * PI / 180;
		var axisNameAvailableWidth;
		if (isNameLocationCenter(nameLocation)) labelLayout = AxisBuilder.innerTextLayout(
			opt.rotation,
			nameRotation != null ? nameRotation : opt.rotation,
			// Adapt to axis.
			nameDirection
);
		else {
			labelLayout = endTextLayout(opt.rotation, nameLocation, nameRotation || 0, extent$1);
			axisNameAvailableWidth = opt.axisNameAvailableWidth;
			if (axisNameAvailableWidth != null) {
				axisNameAvailableWidth = Math.abs(axisNameAvailableWidth / Math.sin(labelLayout.rotation));
				!isFinite(axisNameAvailableWidth) && (axisNameAvailableWidth = null);
			}
		}
		var textFont = textStyleModel.getFont();
		var truncateOpt = axisModel.get("nameTruncate", true) || {};
		var ellipsis = truncateOpt.ellipsis;
		var maxWidth = retrieve(opt.nameTruncateMaxWidth, truncateOpt.maxWidth, axisNameAvailableWidth);
		var textEl = new Text_default({
			x: pos[0],
			y: pos[1],
			rotation: labelLayout.rotation,
			silent: AxisBuilder.isLabelSilent(axisModel),
			style: createTextStyle(textStyleModel, {
				text: name,
				font: textFont,
				overflow: "truncate",
				width: maxWidth,
				ellipsis,
				fill: textStyleModel.getTextColor() || axisModel.get([
					"axisLine",
					"lineStyle",
					"color"
				]),
				align: textStyleModel.get("align") || labelLayout.textAlign,
				verticalAlign: textStyleModel.get("verticalAlign") || labelLayout.textVerticalAlign
			}),
			z2: 1
		});
		setTooltipConfig({
			el: textEl,
			componentModel: axisModel,
			itemName: name
		});
		textEl.__fullText = name;
		textEl.anid = "name";
		if (axisModel.get("triggerEvent")) {
			var eventData = AxisBuilder.makeAxisEventDataBase(axisModel);
			eventData.targetType = "axisName";
			eventData.name = name;
			getECData(textEl).eventData = eventData;
		}
		transformGroup.add(textEl);
		textEl.updateTransform();
		group.add(textEl);
		textEl.decomposeTransform();
	}
};
function endTextLayout(rotation, textPosition, textRotate, extent$1) {
	var rotationDiff = remRadian(textRotate - rotation);
	var textAlign;
	var textVerticalAlign;
	var inverse = extent$1[0] > extent$1[1];
	var onLeft = textPosition === "start" && !inverse || textPosition !== "start" && inverse;
	if (isRadianAroundZero(rotationDiff - PI / 2)) {
		textVerticalAlign = onLeft ? "bottom" : "top";
		textAlign = "center";
	} else if (isRadianAroundZero(rotationDiff - PI * 1.5)) {
		textVerticalAlign = onLeft ? "top" : "bottom";
		textAlign = "center";
	} else {
		textVerticalAlign = "middle";
		if (rotationDiff < PI * 1.5 && rotationDiff > PI / 2) textAlign = onLeft ? "left" : "right";
		else textAlign = onLeft ? "right" : "left";
	}
	return {
		rotation: rotationDiff,
		textAlign,
		textVerticalAlign
	};
}
function fixMinMaxLabelShow(axisModel, labelEls, tickEls) {
	if (shouldShowAllLabels(axisModel.axis)) return;
	var showMinLabel = axisModel.get(["axisLabel", "showMinLabel"]);
	var showMaxLabel = axisModel.get(["axisLabel", "showMaxLabel"]);
	labelEls = labelEls || [];
	tickEls = tickEls || [];
	var firstLabel = labelEls[0];
	var nextLabel = labelEls[1];
	var lastLabel = labelEls[labelEls.length - 1];
	var prevLabel = labelEls[labelEls.length - 2];
	var firstTick = tickEls[0];
	var nextTick$1 = tickEls[1];
	var lastTick = tickEls[tickEls.length - 1];
	var prevTick = tickEls[tickEls.length - 2];
	if (showMinLabel === false) {
		ignoreEl(firstLabel);
		ignoreEl(firstTick);
	} else if (isTwoLabelOverlapped(firstLabel, nextLabel)) if (showMinLabel) {
		ignoreEl(nextLabel);
		ignoreEl(nextTick$1);
	} else {
		ignoreEl(firstLabel);
		ignoreEl(firstTick);
	}
	if (showMaxLabel === false) {
		ignoreEl(lastLabel);
		ignoreEl(lastTick);
	} else if (isTwoLabelOverlapped(prevLabel, lastLabel)) if (showMaxLabel) {
		ignoreEl(prevLabel);
		ignoreEl(prevTick);
	} else {
		ignoreEl(lastLabel);
		ignoreEl(lastTick);
	}
}
function ignoreEl(el) {
	el && (el.ignore = true);
}
function isTwoLabelOverlapped(current, next) {
	var firstRect = current && current.getBoundingRect().clone();
	var nextRect = next && next.getBoundingRect().clone();
	if (!firstRect || !nextRect) return;
	var mRotationBack = identity([]);
	rotate(mRotationBack, mRotationBack, -current.rotation);
	firstRect.applyTransform(mul([], mRotationBack, current.getLocalTransform()));
	nextRect.applyTransform(mul([], mRotationBack, next.getLocalTransform()));
	return firstRect.intersect(nextRect);
}
function isNameLocationCenter(nameLocation) {
	return nameLocation === "middle" || nameLocation === "center";
}
function createTicks(ticksCoords, tickTransform, tickEndCoord, tickLineStyle, anidPrefix) {
	var tickEls = [];
	var pt1 = [];
	var pt2 = [];
	for (var i = 0; i < ticksCoords.length; i++) {
		var tickCoord = ticksCoords[i].coord;
		pt1[0] = tickCoord;
		pt1[1] = 0;
		pt2[0] = tickCoord;
		pt2[1] = tickEndCoord;
		if (tickTransform) {
			applyTransform$1(pt1, pt1, tickTransform);
			applyTransform$1(pt2, pt2, tickTransform);
		}
		var tickEl = new Line_default({
			shape: {
				x1: pt1[0],
				y1: pt1[1],
				x2: pt2[0],
				y2: pt2[1]
			},
			style: tickLineStyle,
			z2: 2,
			autoBatch: true,
			silent: true
		});
		subPixelOptimizeLine(tickEl.shape, tickEl.style.lineWidth);
		tickEl.anid = anidPrefix + "_" + ticksCoords[i].tickValue;
		tickEls.push(tickEl);
	}
	return tickEls;
}
function buildAxisMajorTicks(group, transformGroup, axisModel, opt) {
	var axis = axisModel.axis;
	var tickModel = axisModel.getModel("axisTick");
	var shown = tickModel.get("show");
	if (shown === "auto" && opt.handleAutoShown) shown = opt.handleAutoShown("axisTick");
	if (!shown || axis.scale.isBlank()) return;
	var lineStyleModel = tickModel.getModel("lineStyle");
	var tickEndCoord = opt.tickDirection * tickModel.get("length");
	var ticksCoords = axis.getTicksCoords();
	var ticksEls = createTicks(ticksCoords, transformGroup.transform, tickEndCoord, defaults(lineStyleModel.getLineStyle(), { stroke: axisModel.get([
		"axisLine",
		"lineStyle",
		"color"
	]) }), "ticks");
	for (var i = 0; i < ticksEls.length; i++) group.add(ticksEls[i]);
	return ticksEls;
}
function buildAxisMinorTicks(group, transformGroup, axisModel, tickDirection) {
	var axis = axisModel.axis;
	var minorTickModel = axisModel.getModel("minorTick");
	if (!minorTickModel.get("show") || axis.scale.isBlank()) return;
	var minorTicksCoords = axis.getMinorTicksCoords();
	if (!minorTicksCoords.length) return;
	var lineStyleModel = minorTickModel.getModel("lineStyle");
	var tickEndCoord = tickDirection * minorTickModel.get("length");
	var minorTickLineStyle = defaults(lineStyleModel.getLineStyle(), defaults(axisModel.getModel("axisTick").getLineStyle(), { stroke: axisModel.get([
		"axisLine",
		"lineStyle",
		"color"
	]) }));
	for (var i = 0; i < minorTicksCoords.length; i++) {
		var minorTicksEls = createTicks(minorTicksCoords[i], transformGroup.transform, tickEndCoord, minorTickLineStyle, "minorticks_" + i);
		for (var k = 0; k < minorTicksEls.length; k++) group.add(minorTicksEls[k]);
	}
}
function buildAxisLabel(group, transformGroup, axisModel, opt) {
	var axis = axisModel.axis;
	var show = retrieve(opt.axisLabelShow, axisModel.get(["axisLabel", "show"]));
	if (!show || axis.scale.isBlank()) return;
	var labelModel = axisModel.getModel("axisLabel");
	var labelMargin = labelModel.get("margin");
	var labels = axis.getViewLabels();
	var labelRotation = (retrieve(opt.labelRotate, labelModel.get("rotate")) || 0) * PI / 180;
	var labelLayout = AxisBuilder.innerTextLayout(opt.rotation, labelRotation, opt.labelDirection);
	var rawCategoryData = axisModel.getCategories && axisModel.getCategories(true);
	var labelEls = [];
	var silent = AxisBuilder.isLabelSilent(axisModel);
	var triggerEvent = axisModel.get("triggerEvent");
	each$4(labels, function(labelItem, index) {
		var tickValue = axis.scale.type === "ordinal" ? axis.scale.getRawOrdinalNumber(labelItem.tickValue) : labelItem.tickValue;
		var formattedLabel = labelItem.formattedLabel;
		var rawLabel = labelItem.rawLabel;
		var itemLabelModel = labelModel;
		if (rawCategoryData && rawCategoryData[tickValue]) {
			var rawCategoryItem = rawCategoryData[tickValue];
			if (isObject$2(rawCategoryItem) && rawCategoryItem.textStyle) itemLabelModel = new Model_default(rawCategoryItem.textStyle, labelModel, axisModel.ecModel);
		}
		var textColor = itemLabelModel.getTextColor() || axisModel.get([
			"axisLine",
			"lineStyle",
			"color"
		]);
		var tickCoord = axis.dataToCoord(tickValue);
		var align = itemLabelModel.getShallow("align", true) || labelLayout.textAlign;
		var alignMin = retrieve2(itemLabelModel.getShallow("alignMinLabel", true), align);
		var alignMax = retrieve2(itemLabelModel.getShallow("alignMaxLabel", true), align);
		var verticalAlign = itemLabelModel.getShallow("verticalAlign", true) || itemLabelModel.getShallow("baseline", true) || labelLayout.textVerticalAlign;
		var verticalAlignMin = retrieve2(itemLabelModel.getShallow("verticalAlignMinLabel", true), verticalAlign);
		var verticalAlignMax = retrieve2(itemLabelModel.getShallow("verticalAlignMaxLabel", true), verticalAlign);
		var textEl = new Text_default({
			x: tickCoord,
			y: opt.labelOffset + opt.labelDirection * labelMargin,
			rotation: labelLayout.rotation,
			silent,
			z2: 10 + (labelItem.level || 0),
			style: createTextStyle(itemLabelModel, {
				text: formattedLabel,
				align: index === 0 ? alignMin : index === labels.length - 1 ? alignMax : align,
				verticalAlign: index === 0 ? verticalAlignMin : index === labels.length - 1 ? verticalAlignMax : verticalAlign,
				fill: isFunction(textColor) ? textColor(
					// (1) In category axis with data zoom, tick is not the original
					// index of axis.data. So tick should not be exposed to user
					// in category axis.
					// (2) Compatible with previous version, which always use formatted label as
					// input. But in interval scale the formatted label is like '223,445', which
					// maked user replace ','. So we modify it to return original val but remain
					// it as 'string' to avoid error in replacing.
					axis.type === "category" ? rawLabel : axis.type === "value" ? tickValue + "" : tickValue,
					index
) : textColor
			})
		});
		textEl.anid = "label_" + tickValue;
		setTooltipConfig({
			el: textEl,
			componentModel: axisModel,
			itemName: formattedLabel,
			formatterParamsExtra: {
				isTruncated: function() {
					return textEl.isTruncated;
				},
				value: rawLabel,
				tickIndex: index
			}
		});
		if (triggerEvent) {
			var eventData = AxisBuilder.makeAxisEventDataBase(axisModel);
			eventData.targetType = "axisLabel";
			eventData.value = rawLabel;
			eventData.tickIndex = index;
			if (axis.type === "category") eventData.dataIndex = tickValue;
			getECData(textEl).eventData = eventData;
		}
		transformGroup.add(textEl);
		textEl.updateTransform();
		labelEls.push(textEl);
		group.add(textEl);
		textEl.decomposeTransform();
	});
	return labelEls;
}
var AxisBuilder_default = AxisBuilder;
function collect(ecModel, api) {
	var result = {
		axesInfo: {},
		seriesInvolved: false,
		coordSysAxesInfo: {},
		coordSysMap: {}
	};
	collectAxesInfo(result, ecModel, api);
	result.seriesInvolved && collectSeriesInfo(result, ecModel);
	return result;
}
function collectAxesInfo(result, ecModel, api) {
	var globalTooltipModel = ecModel.getComponent("tooltip");
	var globalAxisPointerModel = ecModel.getComponent("axisPointer");
	var linksOption = globalAxisPointerModel.get("link", true) || [];
	var linkGroups = [];
	each$4(api.getCoordinateSystems(), function(coordSys) {
		if (!coordSys.axisPointerEnabled) return;
		var coordSysKey = makeKey(coordSys.model);
		var axesInfoInCoordSys = result.coordSysAxesInfo[coordSysKey] = {};
		result.coordSysMap[coordSysKey] = coordSys;
		var coordSysModel = coordSys.model;
		var baseTooltipModel = coordSysModel.getModel("tooltip", globalTooltipModel);
		each$4(coordSys.getAxes(), curry$1(saveTooltipAxisInfo, false, null));
		if (coordSys.getTooltipAxes && globalTooltipModel && baseTooltipModel.get("show")) {
			var triggerAxis = baseTooltipModel.get("trigger") === "axis";
			var cross = baseTooltipModel.get(["axisPointer", "type"]) === "cross";
			var tooltipAxes = coordSys.getTooltipAxes(baseTooltipModel.get(["axisPointer", "axis"]));
			if (triggerAxis || cross) each$4(tooltipAxes.baseAxes, curry$1(saveTooltipAxisInfo, cross ? "cross" : true, triggerAxis));
			if (cross) each$4(tooltipAxes.otherAxes, curry$1(saveTooltipAxisInfo, "cross", false));
		}
		function saveTooltipAxisInfo(fromTooltip, triggerTooltip, axis) {
			var axisPointerModel = axis.model.getModel("axisPointer", globalAxisPointerModel);
			var axisPointerShow = axisPointerModel.get("show");
			if (!axisPointerShow || axisPointerShow === "auto" && !fromTooltip && !isHandleTrigger(axisPointerModel)) return;
			if (triggerTooltip == null) triggerTooltip = axisPointerModel.get("triggerTooltip");
			axisPointerModel = fromTooltip ? makeAxisPointerModel(axis, baseTooltipModel, globalAxisPointerModel, ecModel, fromTooltip, triggerTooltip) : axisPointerModel;
			var snap = axisPointerModel.get("snap");
			var triggerEmphasis = axisPointerModel.get("triggerEmphasis");
			var axisKey = makeKey(axis.model);
			var involveSeries = triggerTooltip || snap || axis.type === "category";
			var axisInfo = result.axesInfo[axisKey] = {
				key: axisKey,
				axis,
				coordSys,
				axisPointerModel,
				triggerTooltip,
				triggerEmphasis,
				involveSeries,
				snap,
				useHandle: isHandleTrigger(axisPointerModel),
				seriesModels: [],
				linkGroup: null
			};
			axesInfoInCoordSys[axisKey] = axisInfo;
			result.seriesInvolved = result.seriesInvolved || involveSeries;
			var groupIndex = getLinkGroupIndex(linksOption, axis);
			if (groupIndex != null) {
				var linkGroup = linkGroups[groupIndex] || (linkGroups[groupIndex] = { axesInfo: {} });
				linkGroup.axesInfo[axisKey] = axisInfo;
				linkGroup.mapper = linksOption[groupIndex].mapper;
				axisInfo.linkGroup = linkGroup;
			}
		}
	});
}
function makeAxisPointerModel(axis, baseTooltipModel, globalAxisPointerModel, ecModel, fromTooltip, triggerTooltip) {
	var tooltipAxisPointerModel = baseTooltipModel.getModel("axisPointer");
	var fields = [
		"type",
		"snap",
		"lineStyle",
		"shadowStyle",
		"label",
		"animation",
		"animationDurationUpdate",
		"animationEasingUpdate",
		"z"
	];
	var volatileOption = {};
	each$4(fields, function(field) {
		volatileOption[field] = clone$2(tooltipAxisPointerModel.get(field));
	});
	volatileOption.snap = axis.type !== "category" && !!triggerTooltip;
	if (tooltipAxisPointerModel.get("type") === "cross") volatileOption.type = "line";
	var labelOption = volatileOption.label || (volatileOption.label = {});
	labelOption.show ??= false;
	if (fromTooltip === "cross") {
		var tooltipAxisPointerLabelShow = tooltipAxisPointerModel.get(["label", "show"]);
		labelOption.show = tooltipAxisPointerLabelShow != null ? tooltipAxisPointerLabelShow : true;
		if (!triggerTooltip) {
			var crossStyle = volatileOption.lineStyle = tooltipAxisPointerModel.get("crossStyle");
			crossStyle && defaults(labelOption, crossStyle.textStyle);
		}
	}
	return axis.model.getModel("axisPointer", new Model_default(volatileOption, globalAxisPointerModel, ecModel));
}
function collectSeriesInfo(result, ecModel) {
	ecModel.eachSeries(function(seriesModel) {
		var coordSys = seriesModel.coordinateSystem;
		var seriesTooltipTrigger = seriesModel.get(["tooltip", "trigger"], true);
		var seriesTooltipShow = seriesModel.get(["tooltip", "show"], true);
		if (!coordSys || seriesTooltipTrigger === "none" || seriesTooltipTrigger === false || seriesTooltipTrigger === "item" || seriesTooltipShow === false || seriesModel.get(["axisPointer", "show"], true) === false) return;
		each$4(result.coordSysAxesInfo[makeKey(coordSys.model)], function(axisInfo) {
			var axis = axisInfo.axis;
			if (coordSys.getAxis(axis.dim) === axis) {
				axisInfo.seriesModels.push(seriesModel);
				axisInfo.seriesDataCount ??= 0;
				axisInfo.seriesDataCount += seriesModel.getData().count();
			}
		});
	});
}
/**

* For example:

* {

*     axisPointer: {

*         links: [{

*             xAxisIndex: [2, 4],

*             yAxisIndex: 'all'

*         }, {

*             xAxisId: ['a5', 'a7'],

*             xAxisName: 'xxx'

*         }]

*     }

* }

*/
function getLinkGroupIndex(linksOption, axis) {
	var axisModel = axis.model;
	var dim = axis.dim;
	for (var i = 0; i < linksOption.length; i++) {
		var linkOption = linksOption[i] || {};
		if (checkPropInLink(linkOption[dim + "AxisId"], axisModel.id) || checkPropInLink(linkOption[dim + "AxisIndex"], axisModel.componentIndex) || checkPropInLink(linkOption[dim + "AxisName"], axisModel.name)) return i;
	}
}
function checkPropInLink(linkPropValue, axisPropValue) {
	return linkPropValue === "all" || isArray(linkPropValue) && indexOf(linkPropValue, axisPropValue) >= 0 || linkPropValue === axisPropValue;
}
function fixValue(axisModel) {
	var axisInfo = getAxisInfo(axisModel);
	if (!axisInfo) return;
	var axisPointerModel = axisInfo.axisPointerModel;
	var scale$3 = axisInfo.axis.scale;
	var option = axisPointerModel.option;
	var status = axisPointerModel.get("status");
	var value = axisPointerModel.get("value");
	if (value != null) value = scale$3.parse(value);
	var useHandle = isHandleTrigger(axisPointerModel);
	if (status == null) option.status = useHandle ? "show" : "hide";
	var extent$1 = scale$3.getExtent().slice();
	extent$1[0] > extent$1[1] && extent$1.reverse();
	if (value == null || value > extent$1[1]) value = extent$1[1];
	if (value < extent$1[0]) value = extent$1[0];
	option.value = value;
	if (useHandle) option.status = axisInfo.axis.scale.isBlank() ? "hide" : "show";
}
function getAxisInfo(axisModel) {
	var coordSysAxesInfo = (axisModel.ecModel.getComponent("axisPointer") || {}).coordSysAxesInfo;
	return coordSysAxesInfo && coordSysAxesInfo.axesInfo[makeKey(axisModel)];
}
function getAxisPointerModel(axisModel) {
	var axisInfo = getAxisInfo(axisModel);
	return axisInfo && axisInfo.axisPointerModel;
}
function isHandleTrigger(axisPointerModel) {
	return !!axisPointerModel.get(["handle", "show"]);
}
function makeKey(model) {
	return model.type + "||" + model.id;
}
var axisPointerClazz = {};
/**

* Base class of AxisView.

*/
var AxisView = function(_super) {
	__extends(AxisView$1, _super);
	function AxisView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = AxisView$1.type;
		return _this;
	}
	/**
	
	* @override
	
	*/
	AxisView$1.prototype.render = function(axisModel, ecModel, api, payload) {
		this.axisPointerClass && fixValue(axisModel);
		_super.prototype.render.apply(this, arguments);
		this._doUpdateAxisPointerClass(axisModel, api, true);
	};
	/**
	
	* Action handler.
	
	*/
	AxisView$1.prototype.updateAxisPointer = function(axisModel, ecModel, api, payload) {
		this._doUpdateAxisPointerClass(axisModel, api, false);
	};
	/**
	
	* @override
	
	*/
	AxisView$1.prototype.remove = function(ecModel, api) {
		var axisPointer = this._axisPointer;
		axisPointer && axisPointer.remove(api);
	};
	/**
	
	* @override
	
	*/
	AxisView$1.prototype.dispose = function(ecModel, api) {
		this._disposeAxisPointer(api);
		_super.prototype.dispose.apply(this, arguments);
	};
	AxisView$1.prototype._doUpdateAxisPointerClass = function(axisModel, api, forceRender) {
		var Clazz = AxisView$1.getAxisPointerClass(this.axisPointerClass);
		if (!Clazz) return;
		var axisPointerModel = getAxisPointerModel(axisModel);
		axisPointerModel ? (this._axisPointer || (this._axisPointer = new Clazz())).render(axisModel, axisPointerModel, api, forceRender) : this._disposeAxisPointer(api);
	};
	AxisView$1.prototype._disposeAxisPointer = function(api) {
		this._axisPointer && this._axisPointer.dispose(api);
		this._axisPointer = null;
	};
	AxisView$1.registerAxisPointerClass = function(type, clazz) {
		axisPointerClazz[type] = clazz;
	};
	AxisView$1.getAxisPointerClass = function(type) {
		return type && axisPointerClazz[type];
	};
	AxisView$1.type = "axis";
	return AxisView$1;
}(Component_default);
var AxisView_default = AxisView;
var inner$3 = makeInner();
function rectCoordAxisBuildSplitArea(axisView, axisGroup, axisModel, gridModel) {
	var axis = axisModel.axis;
	if (axis.scale.isBlank()) return;
	var splitAreaModel = axisModel.getModel("splitArea");
	var areaStyleModel = splitAreaModel.getModel("areaStyle");
	var areaColors = areaStyleModel.get("color");
	var gridRect = gridModel.coordinateSystem.getRect();
	var ticksCoords = axis.getTicksCoords({
		tickModel: splitAreaModel,
		clamp: true
	});
	if (!ticksCoords.length) return;
	var areaColorsLen = areaColors.length;
	var lastSplitAreaColors = inner$3(axisView).splitAreaColors;
	var newSplitAreaColors = createHashMap();
	var colorIndex = 0;
	if (lastSplitAreaColors) for (var i = 0; i < ticksCoords.length; i++) {
		var cIndex = lastSplitAreaColors.get(ticksCoords[i].tickValue);
		if (cIndex != null) {
			colorIndex = (cIndex + (areaColorsLen - 1) * i) % areaColorsLen;
			break;
		}
	}
	var prev = axis.toGlobalCoord(ticksCoords[0].coord);
	var areaStyle = areaStyleModel.getAreaStyle();
	areaColors = isArray(areaColors) ? areaColors : [areaColors];
	for (var i = 1; i < ticksCoords.length; i++) {
		var tickCoord = axis.toGlobalCoord(ticksCoords[i].coord);
		var x = void 0;
		var y = void 0;
		var width = void 0;
		var height = void 0;
		if (axis.isHorizontal()) {
			x = prev;
			y = gridRect.y;
			width = tickCoord - x;
			height = gridRect.height;
			prev = x + width;
		} else {
			x = gridRect.x;
			y = prev;
			width = gridRect.width;
			height = tickCoord - y;
			prev = y + height;
		}
		var tickValue = ticksCoords[i - 1].tickValue;
		tickValue != null && newSplitAreaColors.set(tickValue, colorIndex);
		axisGroup.add(new Rect_default({
			anid: tickValue != null ? "area_" + tickValue : null,
			shape: {
				x,
				y,
				width,
				height
			},
			style: defaults({ fill: areaColors[colorIndex] }, areaStyle),
			autoBatch: true,
			silent: true
		}));
		colorIndex = (colorIndex + 1) % areaColorsLen;
	}
	inner$3(axisView).splitAreaColors = newSplitAreaColors;
}
function rectCoordAxisHandleRemove(axisView) {
	inner$3(axisView).splitAreaColors = null;
}
var axisBuilderAttrs = [
	"axisLine",
	"axisTickLabel",
	"axisName"
];
var selfBuilderAttrs = [
	"splitArea",
	"splitLine",
	"minorSplitLine"
];
var CartesianAxisView = function(_super) {
	__extends(CartesianAxisView$1, _super);
	function CartesianAxisView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = CartesianAxisView$1.type;
		_this.axisPointerClass = "CartesianAxisPointer";
		return _this;
	}
	/**
	
	* @override
	
	*/
	CartesianAxisView$1.prototype.render = function(axisModel, ecModel, api, payload) {
		this.group.removeAll();
		var oldAxisGroup = this._axisGroup;
		this._axisGroup = new Group_default();
		this.group.add(this._axisGroup);
		if (!axisModel.get("show")) return;
		var gridModel = axisModel.getCoordSysModel();
		var layout$2 = layout(gridModel, axisModel);
		var axisBuilder = new AxisBuilder_default(axisModel, extend({ handleAutoShown: function(elementType) {
			var cartesians = gridModel.coordinateSystem.getCartesians();
			for (var i = 0; i < cartesians.length; i++) if (isIntervalOrLogScale(cartesians[i].getOtherAxis(axisModel.axis).scale)) return true;
			return false;
		} }, layout$2));
		each$4(axisBuilderAttrs, axisBuilder.add, axisBuilder);
		this._axisGroup.add(axisBuilder.getGroup());
		each$4(selfBuilderAttrs, function(name) {
			if (axisModel.get([name, "show"])) axisElementBuilders[name](this, this._axisGroup, axisModel, gridModel);
		}, this);
		var isInitialSortFromBarRacing = payload && payload.type === "changeAxisOrder" && payload.isInitSort;
		if (!isInitialSortFromBarRacing) groupTransition(oldAxisGroup, this._axisGroup, axisModel);
		_super.prototype.render.call(this, axisModel, ecModel, api, payload);
	};
	CartesianAxisView$1.prototype.remove = function() {
		rectCoordAxisHandleRemove(this);
	};
	CartesianAxisView$1.type = "cartesianAxis";
	return CartesianAxisView$1;
}(AxisView_default);
var axisElementBuilders = {
	splitLine: function(axisView, axisGroup, axisModel, gridModel) {
		var axis = axisModel.axis;
		if (axis.scale.isBlank()) return;
		var splitLineModel = axisModel.getModel("splitLine");
		var lineStyleModel = splitLineModel.getModel("lineStyle");
		var lineColors = lineStyleModel.get("color");
		var showMinLine = splitLineModel.get("showMinLine") !== false;
		var showMaxLine = splitLineModel.get("showMaxLine") !== false;
		lineColors = isArray(lineColors) ? lineColors : [lineColors];
		var gridRect = gridModel.coordinateSystem.getRect();
		var isHorizontal = axis.isHorizontal();
		var lineCount = 0;
		var ticksCoords = axis.getTicksCoords({ tickModel: splitLineModel });
		var p1 = [];
		var p2 = [];
		var lineStyle = lineStyleModel.getLineStyle();
		for (var i = 0; i < ticksCoords.length; i++) {
			var tickCoord = axis.toGlobalCoord(ticksCoords[i].coord);
			if (i === 0 && !showMinLine || i === ticksCoords.length - 1 && !showMaxLine) continue;
			var tickValue = ticksCoords[i].tickValue;
			if (isHorizontal) {
				p1[0] = tickCoord;
				p1[1] = gridRect.y;
				p2[0] = tickCoord;
				p2[1] = gridRect.y + gridRect.height;
			} else {
				p1[0] = gridRect.x;
				p1[1] = tickCoord;
				p2[0] = gridRect.x + gridRect.width;
				p2[1] = tickCoord;
			}
			var colorIndex = lineCount++ % lineColors.length;
			var line = new Line_default({
				anid: tickValue != null ? "line_" + tickValue : null,
				autoBatch: true,
				shape: {
					x1: p1[0],
					y1: p1[1],
					x2: p2[0],
					y2: p2[1]
				},
				style: defaults({ stroke: lineColors[colorIndex] }, lineStyle),
				silent: true
			});
			subPixelOptimizeLine(line.shape, lineStyle.lineWidth);
			axisGroup.add(line);
		}
	},
	minorSplitLine: function(axisView, axisGroup, axisModel, gridModel) {
		var axis = axisModel.axis;
		var minorSplitLineModel = axisModel.getModel("minorSplitLine");
		var lineStyleModel = minorSplitLineModel.getModel("lineStyle");
		var gridRect = gridModel.coordinateSystem.getRect();
		var isHorizontal = axis.isHorizontal();
		var minorTicksCoords = axis.getMinorTicksCoords();
		if (!minorTicksCoords.length) return;
		var p1 = [];
		var p2 = [];
		var lineStyle = lineStyleModel.getLineStyle();
		for (var i = 0; i < minorTicksCoords.length; i++) for (var k = 0; k < minorTicksCoords[i].length; k++) {
			var tickCoord = axis.toGlobalCoord(minorTicksCoords[i][k].coord);
			if (isHorizontal) {
				p1[0] = tickCoord;
				p1[1] = gridRect.y;
				p2[0] = tickCoord;
				p2[1] = gridRect.y + gridRect.height;
			} else {
				p1[0] = gridRect.x;
				p1[1] = tickCoord;
				p2[0] = gridRect.x + gridRect.width;
				p2[1] = tickCoord;
			}
			var line = new Line_default({
				anid: "minor_line_" + minorTicksCoords[i][k].tickValue,
				autoBatch: true,
				shape: {
					x1: p1[0],
					y1: p1[1],
					x2: p2[0],
					y2: p2[1]
				},
				style: lineStyle,
				silent: true
			});
			subPixelOptimizeLine(line.shape, lineStyle.lineWidth);
			axisGroup.add(line);
		}
	},
	splitArea: function(axisView, axisGroup, axisModel, gridModel) {
		rectCoordAxisBuildSplitArea(axisView, axisGroup, axisModel, gridModel);
	}
};
var CartesianXAxisView = function(_super) {
	__extends(CartesianXAxisView$1, _super);
	function CartesianXAxisView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = CartesianXAxisView$1.type;
		return _this;
	}
	CartesianXAxisView$1.type = "xAxis";
	return CartesianXAxisView$1;
}(CartesianAxisView);
var CartesianYAxisView = function(_super) {
	__extends(CartesianYAxisView$1, _super);
	function CartesianYAxisView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = CartesianXAxisView.type;
		return _this;
	}
	CartesianYAxisView$1.type = "yAxis";
	return CartesianYAxisView$1;
}(CartesianAxisView);
var GridView = function(_super) {
	__extends(GridView$1, _super);
	function GridView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = "grid";
		return _this;
	}
	GridView$1.prototype.render = function(gridModel, ecModel) {
		this.group.removeAll();
		if (gridModel.get("show")) this.group.add(new Rect_default({
			shape: gridModel.coordinateSystem.getRect(),
			style: defaults({ fill: gridModel.get("backgroundColor") }, gridModel.getItemStyle()),
			silent: true,
			z2: -1
		}));
	};
	GridView$1.type = "grid";
	return GridView$1;
}(Component_default);
var extraOption = { offset: 0 };
function install$8(registers) {
	registers.registerComponentView(GridView);
	registers.registerComponentModel(GridModel_default);
	registers.registerCoordinateSystem("cartesian2d", Grid_default);
	axisModelCreator(registers, "x", CartesianAxisModel, extraOption);
	axisModelCreator(registers, "y", CartesianAxisModel, extraOption);
	registers.registerComponentView(CartesianXAxisView);
	registers.registerComponentView(CartesianYAxisView);
	registers.registerPreprocessor(function(option) {
		if (option.xAxis && option.yAxis && !option.grid) option.grid = {};
	});
}
var inner$2 = makeInner();
var clone = clone$2;
var bind = bind$1;
/**

* Base axis pointer class in 2D.

*/
var BaseAxisPointer = function() {
	function BaseAxisPointer$1() {
		this._dragging = false;
		/**
		
		* In px, arbitrary value. Do not set too small,
		
		* no animation is ok for most cases.
		
		*/
		this.animationThreshold = 15;
	}
	/**
	
	* @implement
	
	*/
	BaseAxisPointer$1.prototype.render = function(axisModel, axisPointerModel, api, forceRender) {
		var value = axisPointerModel.get("value");
		var status = axisPointerModel.get("status");
		this._axisModel = axisModel;
		this._axisPointerModel = axisPointerModel;
		this._api = api;
		if (!forceRender && this._lastValue === value && this._lastStatus === status) return;
		this._lastValue = value;
		this._lastStatus = status;
		var group = this._group;
		var handle = this._handle;
		if (!status || status === "hide") {
			group && group.hide();
			handle && handle.hide();
			return;
		}
		group && group.show();
		handle && handle.show();
		var elOption = {};
		this.makeElOption(elOption, value, axisModel, axisPointerModel, api);
		var graphicKey = elOption.graphicKey;
		if (graphicKey !== this._lastGraphicKey) this.clear(api);
		this._lastGraphicKey = graphicKey;
		var moveAnimation = this._moveAnimation = this.determineAnimation(axisModel, axisPointerModel);
		if (!group) {
			group = this._group = new Group_default();
			this.createPointerEl(group, elOption, axisModel, axisPointerModel);
			this.createLabelEl(group, elOption, axisModel, axisPointerModel);
			api.getZr().add(group);
		} else {
			var doUpdateProps = curry$1(updateProps, axisPointerModel, moveAnimation);
			this.updatePointerEl(group, elOption, doUpdateProps);
			this.updateLabelEl(group, elOption, doUpdateProps, axisPointerModel);
		}
		updateMandatoryProps(group, axisPointerModel, true);
		this._renderHandle(value);
	};
	/**
	
	* @implement
	
	*/
	BaseAxisPointer$1.prototype.remove = function(api) {
		this.clear(api);
	};
	/**
	
	* @implement
	
	*/
	BaseAxisPointer$1.prototype.dispose = function(api) {
		this.clear(api);
	};
	/**
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.determineAnimation = function(axisModel, axisPointerModel) {
		var animation = axisPointerModel.get("animation");
		var axis = axisModel.axis;
		var isCategoryAxis = axis.type === "category";
		var useSnap = axisPointerModel.get("snap");
		if (!useSnap && !isCategoryAxis) return false;
		if (animation === "auto" || animation == null) {
			var animationThreshold = this.animationThreshold;
			if (isCategoryAxis && axis.getBandWidth() > animationThreshold) return true;
			if (useSnap) {
				var seriesDataCount = getAxisInfo(axisModel).seriesDataCount;
				var axisExtent = axis.getExtent();
				return Math.abs(axisExtent[0] - axisExtent[1]) / seriesDataCount > animationThreshold;
			}
			return false;
		}
		return animation === true;
	};
	/**
	
	* add {pointer, label, graphicKey} to elOption
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.makeElOption = function(elOption, value, axisModel, axisPointerModel, api) {};
	/**
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.createPointerEl = function(group, elOption, axisModel, axisPointerModel) {
		var pointerOption = elOption.pointer;
		if (pointerOption) {
			var pointerEl = inner$2(group).pointerEl = new graphic_exports[pointerOption.type](clone(elOption.pointer));
			group.add(pointerEl);
		}
	};
	/**
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.createLabelEl = function(group, elOption, axisModel, axisPointerModel) {
		if (elOption.label) {
			var labelEl = inner$2(group).labelEl = new Text_default(clone(elOption.label));
			group.add(labelEl);
			updateLabelShowHide(labelEl, axisPointerModel);
		}
	};
	/**
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.updatePointerEl = function(group, elOption, updateProps$2) {
		var pointerEl = inner$2(group).pointerEl;
		if (pointerEl && elOption.pointer) {
			pointerEl.setStyle(elOption.pointer.style);
			updateProps$2(pointerEl, { shape: elOption.pointer.shape });
		}
	};
	/**
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.updateLabelEl = function(group, elOption, updateProps$2, axisPointerModel) {
		var labelEl = inner$2(group).labelEl;
		if (labelEl) {
			labelEl.setStyle(elOption.label.style);
			updateProps$2(labelEl, {
				x: elOption.label.x,
				y: elOption.label.y
			});
			updateLabelShowHide(labelEl, axisPointerModel);
		}
	};
	/**
	
	* @private
	
	*/
	BaseAxisPointer$1.prototype._renderHandle = function(value) {
		if (this._dragging || !this.updateHandleTransform) return;
		var axisPointerModel = this._axisPointerModel;
		var zr = this._api.getZr();
		var handle = this._handle;
		var handleModel = axisPointerModel.getModel("handle");
		var status = axisPointerModel.get("status");
		if (!handleModel.get("show") || !status || status === "hide") {
			handle && zr.remove(handle);
			this._handle = null;
			return;
		}
		var isInit;
		if (!this._handle) {
			isInit = true;
			handle = this._handle = createIcon(handleModel.get("icon"), {
				cursor: "move",
				draggable: true,
				onmousemove: function(e$1) {
					stop(e$1.event);
				},
				onmousedown: bind(this._onHandleDragMove, this, 0, 0),
				drift: bind(this._onHandleDragMove, this),
				ondragend: bind(this._onHandleDragEnd, this)
			});
			zr.add(handle);
		}
		updateMandatoryProps(handle, axisPointerModel, false);
		handle.setStyle(handleModel.getItemStyle(null, [
			"color",
			"borderColor",
			"borderWidth",
			"opacity",
			"shadowColor",
			"shadowBlur",
			"shadowOffsetX",
			"shadowOffsetY"
		]));
		var handleSize = handleModel.get("size");
		if (!isArray(handleSize)) handleSize = [handleSize, handleSize];
		handle.scaleX = handleSize[0] / 2;
		handle.scaleY = handleSize[1] / 2;
		createOrUpdate(this, "_doDispatchAxisPointer", handleModel.get("throttle") || 0, "fixRate");
		this._moveHandleToValue(value, isInit);
	};
	BaseAxisPointer$1.prototype._moveHandleToValue = function(value, isInit) {
		updateProps(this._axisPointerModel, !isInit && this._moveAnimation, this._handle, getHandleTransProps(this.getHandleTransform(value, this._axisModel, this._axisPointerModel)));
	};
	BaseAxisPointer$1.prototype._onHandleDragMove = function(dx, dy) {
		var handle = this._handle;
		if (!handle) return;
		this._dragging = true;
		var trans = this.updateHandleTransform(getHandleTransProps(handle), [dx, dy], this._axisModel, this._axisPointerModel);
		this._payloadInfo = trans;
		handle.stopAnimation();
		handle.attr(getHandleTransProps(trans));
		inner$2(handle).lastProp = null;
		this._doDispatchAxisPointer();
	};
	/**
	
	* Throttled method.
	
	*/
	BaseAxisPointer$1.prototype._doDispatchAxisPointer = function() {
		var handle = this._handle;
		if (!handle) return;
		var payloadInfo = this._payloadInfo;
		var axisModel = this._axisModel;
		this._api.dispatchAction({
			type: "updateAxisPointer",
			x: payloadInfo.cursorPoint[0],
			y: payloadInfo.cursorPoint[1],
			tooltipOption: payloadInfo.tooltipOption,
			axesInfo: [{
				axisDim: axisModel.axis.dim,
				axisIndex: axisModel.componentIndex
			}]
		});
	};
	BaseAxisPointer$1.prototype._onHandleDragEnd = function() {
		this._dragging = false;
		var handle = this._handle;
		if (!handle) return;
		var value = this._axisPointerModel.get("value");
		this._moveHandleToValue(value);
		this._api.dispatchAction({ type: "hideTip" });
	};
	/**
	
	* @private
	
	*/
	BaseAxisPointer$1.prototype.clear = function(api) {
		this._lastValue = null;
		this._lastStatus = null;
		var zr = api.getZr();
		var group = this._group;
		var handle = this._handle;
		if (zr && group) {
			this._lastGraphicKey = null;
			group && zr.remove(group);
			handle && zr.remove(handle);
			this._group = null;
			this._handle = null;
			this._payloadInfo = null;
		}
		clear(this, "_doDispatchAxisPointer");
	};
	/**
	
	* @protected
	
	*/
	BaseAxisPointer$1.prototype.doClear = function() {};
	BaseAxisPointer$1.prototype.buildLabel = function(xy, wh, xDimIndex) {
		xDimIndex = xDimIndex || 0;
		return {
			x: xy[xDimIndex],
			y: xy[1 - xDimIndex],
			width: wh[xDimIndex],
			height: wh[1 - xDimIndex]
		};
	};
	return BaseAxisPointer$1;
}();
function updateProps(animationModel, moveAnimation, el, props) {
	if (!propsEqual(inner$2(el).lastProp, props)) {
		inner$2(el).lastProp = props;
		moveAnimation ? updateProps$1(el, props, animationModel) : (el.stopAnimation(), el.attr(props));
	}
}
function propsEqual(lastProps, newProps) {
	if (isObject$2(lastProps) && isObject$2(newProps)) {
		var equals_1 = true;
		each$4(newProps, function(item, key) {
			equals_1 = equals_1 && propsEqual(lastProps[key], item);
		});
		return !!equals_1;
	} else return lastProps === newProps;
}
function updateLabelShowHide(labelEl, axisPointerModel) {
	labelEl[axisPointerModel.get(["label", "show"]) ? "show" : "hide"]();
}
function getHandleTransProps(trans) {
	return {
		x: trans.x || 0,
		y: trans.y || 0,
		rotation: trans.rotation || 0
	};
}
function updateMandatoryProps(group, axisPointerModel, silent) {
	var z = axisPointerModel.get("z");
	var zlevel = axisPointerModel.get("zlevel");
	group && group.traverse(function(el) {
		if (el.type !== "group") {
			z != null && (el.z = z);
			zlevel != null && (el.zlevel = zlevel);
			el.silent = silent;
		}
	});
}
var BaseAxisPointer_default = BaseAxisPointer;
function buildElStyle(axisPointerModel) {
	var axisPointerType = axisPointerModel.get("type");
	var styleModel = axisPointerModel.getModel(axisPointerType + "Style");
	var style;
	if (axisPointerType === "line") {
		style = styleModel.getLineStyle();
		style.fill = null;
	} else if (axisPointerType === "shadow") {
		style = styleModel.getAreaStyle();
		style.stroke = null;
	}
	return style;
}
function buildLabelElOption(elOption, axisModel, axisPointerModel, api, labelPos) {
	var value = axisPointerModel.get("value");
	var text = getValueLabel(value, axisModel.axis, axisModel.ecModel, axisPointerModel.get("seriesDataIndices"), {
		precision: axisPointerModel.get(["label", "precision"]),
		formatter: axisPointerModel.get(["label", "formatter"])
	});
	var labelModel = axisPointerModel.getModel("label");
	var paddings = normalizeCssArray(labelModel.get("padding") || 0);
	var font = labelModel.getFont();
	var textRect = getBoundingRect(text, font);
	var position = labelPos.position;
	var width = textRect.width + paddings[1] + paddings[3];
	var height = textRect.height + paddings[0] + paddings[2];
	var align = labelPos.align;
	align === "right" && (position[0] -= width);
	align === "center" && (position[0] -= width / 2);
	var verticalAlign = labelPos.verticalAlign;
	verticalAlign === "bottom" && (position[1] -= height);
	verticalAlign === "middle" && (position[1] -= height / 2);
	confineInContainer(position, width, height, api);
	var bgColor = labelModel.get("backgroundColor");
	if (!bgColor || bgColor === "auto") bgColor = axisModel.get([
		"axisLine",
		"lineStyle",
		"color"
	]);
	elOption.label = {
		x: position[0],
		y: position[1],
		style: createTextStyle(labelModel, {
			text,
			font,
			fill: labelModel.getTextColor(),
			padding: paddings,
			backgroundColor: bgColor
		}),
		z2: 10
	};
}
function confineInContainer(position, width, height, api) {
	var viewWidth = api.getWidth();
	var viewHeight = api.getHeight();
	position[0] = Math.min(position[0] + width, viewWidth) - width;
	position[1] = Math.min(position[1] + height, viewHeight) - height;
	position[0] = Math.max(position[0], 0);
	position[1] = Math.max(position[1], 0);
}
function getValueLabel(value, axis, ecModel, seriesDataIndices, opt) {
	value = axis.scale.parse(value);
	var text = axis.scale.getLabel({ value }, { precision: opt.precision });
	var formatter = opt.formatter;
	if (formatter) {
		var params_1 = {
			value: getAxisRawValue(axis, { value }),
			axisDimension: axis.dim,
			axisIndex: axis.index,
			seriesData: []
		};
		each$4(seriesDataIndices, function(idxItem) {
			var series = ecModel.getSeriesByIndex(idxItem.seriesIndex);
			var dataIndex = idxItem.dataIndexInside;
			var dataParams = series && series.getDataParams(dataIndex);
			dataParams && params_1.seriesData.push(dataParams);
		});
		if (isString(formatter)) text = formatter.replace("{value}", text);
		else if (isFunction(formatter)) text = formatter(params_1);
	}
	return text;
}
function getTransformedPosition(axis, value, layoutInfo) {
	var transform = create$1();
	rotate(transform, transform, layoutInfo.rotation);
	translate(transform, transform, layoutInfo.position);
	return applyTransform([axis.dataToCoord(value), (layoutInfo.labelOffset || 0) + (layoutInfo.labelDirection || 1) * (layoutInfo.labelMargin || 0)], transform);
}
function buildCartesianSingleLabelElOption(value, elOption, layoutInfo, axisModel, axisPointerModel, api) {
	var textLayout = AxisBuilder_default.innerTextLayout(layoutInfo.rotation, 0, layoutInfo.labelDirection);
	layoutInfo.labelMargin = axisPointerModel.get(["label", "margin"]);
	buildLabelElOption(elOption, axisModel, axisPointerModel, api, {
		position: getTransformedPosition(axisModel.axis, value, layoutInfo),
		align: textLayout.textAlign,
		verticalAlign: textLayout.textVerticalAlign
	});
}
function makeLineShape(p1, p2, xDimIndex) {
	xDimIndex = xDimIndex || 0;
	return {
		x1: p1[xDimIndex],
		y1: p1[1 - xDimIndex],
		x2: p2[xDimIndex],
		y2: p2[1 - xDimIndex]
	};
}
function makeRectShape(xy, wh, xDimIndex) {
	xDimIndex = xDimIndex || 0;
	return {
		x: xy[xDimIndex],
		y: xy[1 - xDimIndex],
		width: wh[xDimIndex],
		height: wh[1 - xDimIndex]
	};
}
var CartesianAxisPointer = function(_super) {
	__extends(CartesianAxisPointer$1, _super);
	function CartesianAxisPointer$1() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	/**
	
	* @override
	
	*/
	CartesianAxisPointer$1.prototype.makeElOption = function(elOption, value, axisModel, axisPointerModel, api) {
		var axis = axisModel.axis;
		var grid = axis.grid;
		var axisPointerType = axisPointerModel.get("type");
		var otherExtent = getCartesian(grid, axis).getOtherAxis(axis).getGlobalExtent();
		var pixelValue = axis.toGlobalCoord(axis.dataToCoord(value, true));
		if (axisPointerType && axisPointerType !== "none") {
			var elStyle = buildElStyle(axisPointerModel);
			var pointerOption = pointerShapeBuilder[axisPointerType](axis, pixelValue, otherExtent);
			pointerOption.style = elStyle;
			elOption.graphicKey = pointerOption.type;
			elOption.pointer = pointerOption;
		}
		var layoutInfo = layout(grid.model, axisModel);
		buildCartesianSingleLabelElOption(
			// @ts-ignore
			value,
			elOption,
			layoutInfo,
			axisModel,
			axisPointerModel,
			api
);
	};
	/**
	
	* @override
	
	*/
	CartesianAxisPointer$1.prototype.getHandleTransform = function(value, axisModel, axisPointerModel) {
		var layoutInfo = layout(axisModel.axis.grid.model, axisModel, { labelInside: false });
		layoutInfo.labelMargin = axisPointerModel.get(["handle", "margin"]);
		var pos = getTransformedPosition(axisModel.axis, value, layoutInfo);
		return {
			x: pos[0],
			y: pos[1],
			rotation: layoutInfo.rotation + (layoutInfo.labelDirection < 0 ? Math.PI : 0)
		};
	};
	/**
	
	* @override
	
	*/
	CartesianAxisPointer$1.prototype.updateHandleTransform = function(transform, delta, axisModel, axisPointerModel) {
		var axis = axisModel.axis;
		var grid = axis.grid;
		var axisExtent = axis.getGlobalExtent(true);
		var otherExtent = getCartesian(grid, axis).getOtherAxis(axis).getGlobalExtent();
		var dimIndex = axis.dim === "x" ? 0 : 1;
		var currPosition = [transform.x, transform.y];
		currPosition[dimIndex] += delta[dimIndex];
		currPosition[dimIndex] = Math.min(axisExtent[1], currPosition[dimIndex]);
		currPosition[dimIndex] = Math.max(axisExtent[0], currPosition[dimIndex]);
		var cursorOtherValue = (otherExtent[1] + otherExtent[0]) / 2;
		var cursorPoint = [cursorOtherValue, cursorOtherValue];
		cursorPoint[dimIndex] = currPosition[dimIndex];
		var tooltipOptions = [{ verticalAlign: "middle" }, { align: "center" }];
		return {
			x: currPosition[0],
			y: currPosition[1],
			rotation: transform.rotation,
			cursorPoint,
			tooltipOption: tooltipOptions[dimIndex]
		};
	};
	return CartesianAxisPointer$1;
}(BaseAxisPointer_default);
function getCartesian(grid, axis) {
	var opt = {};
	opt[axis.dim + "AxisIndex"] = axis.index;
	return grid.getCartesian(opt);
}
var pointerShapeBuilder = {
	line: function(axis, pixelValue, otherExtent) {
		var targetShape = makeLineShape([pixelValue, otherExtent[0]], [pixelValue, otherExtent[1]], getAxisDimIndex(axis));
		return {
			type: "Line",
			subPixelOptimize: true,
			shape: targetShape
		};
	},
	shadow: function(axis, pixelValue, otherExtent) {
		var bandWidth = Math.max(1, axis.getBandWidth());
		var span = otherExtent[1] - otherExtent[0];
		return {
			type: "Rect",
			shape: makeRectShape([pixelValue - bandWidth / 2, otherExtent[0]], [bandWidth, span], getAxisDimIndex(axis))
		};
	}
};
function getAxisDimIndex(axis) {
	return axis.dim === "x" ? 0 : 1;
}
var CartesianAxisPointer_default = CartesianAxisPointer;
var AxisPointerModel = function(_super) {
	__extends(AxisPointerModel$1, _super);
	function AxisPointerModel$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = AxisPointerModel$1.type;
		return _this;
	}
	AxisPointerModel$1.type = "axisPointer";
	AxisPointerModel$1.defaultOption = {
		show: "auto",
		z: 50,
		type: "line",
		snap: false,
		triggerTooltip: true,
		triggerEmphasis: true,
		value: null,
		status: null,
		link: [],
		animation: null,
		animationDurationUpdate: 200,
		lineStyle: {
			color: "#B9BEC9",
			width: 1,
			type: "dashed"
		},
		shadowStyle: { color: "rgba(210,219,238,0.2)" },
		label: {
			show: true,
			formatter: null,
			precision: "auto",
			margin: 3,
			color: "#fff",
			padding: [
				5,
				7,
				5,
				7
			],
			backgroundColor: "auto",
			borderColor: null,
			borderWidth: 0,
			borderRadius: 3
		},
		handle: {
			show: false,
			icon: "M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4h1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7v-1.2h6.6z M13.3,22H6.7v-1.2h6.6z M13.3,19.6H6.7v-1.2h6.6z",
			size: 45,
			margin: 50,
			color: "#333",
			shadowBlur: 3,
			shadowColor: "#aaa",
			shadowOffsetX: 0,
			shadowOffsetY: 2,
			throttle: 40
		}
	};
	return AxisPointerModel$1;
}(Component_default$1);
var AxisPointerModel_default = AxisPointerModel;
var inner$1 = makeInner();
var each$1 = each$4;
function register$1(key, api, handler) {
	if (env_default.node) return;
	var zr = api.getZr();
	inner$1(zr).records || (inner$1(zr).records = {});
	initGlobalListeners(zr, api);
	var record = inner$1(zr).records[key] || (inner$1(zr).records[key] = {});
	record.handler = handler;
}
function initGlobalListeners(zr, api) {
	if (inner$1(zr).initialized) return;
	inner$1(zr).initialized = true;
	useHandler("click", curry$1(doEnter, "click"));
	useHandler("mousemove", curry$1(doEnter, "mousemove"));
	useHandler("globalout", onLeave);
	function useHandler(eventType, cb) {
		zr.on(eventType, function(e$1) {
			var dis = makeDispatchAction$1(api);
			each$1(inner$1(zr).records, function(record) {
				record && cb(record, e$1, dis.dispatchAction);
			});
			dispatchTooltipFinally(dis.pendings, api);
		});
	}
}
function dispatchTooltipFinally(pendings, api) {
	var showLen = pendings.showTip.length;
	var hideLen = pendings.hideTip.length;
	var actuallyPayload;
	if (showLen) actuallyPayload = pendings.showTip[showLen - 1];
	else if (hideLen) actuallyPayload = pendings.hideTip[hideLen - 1];
	if (actuallyPayload) {
		actuallyPayload.dispatchAction = null;
		api.dispatchAction(actuallyPayload);
	}
}
function onLeave(record, e$1, dispatchAction) {
	record.handler("leave", null, dispatchAction);
}
function doEnter(currTrigger, record, e$1, dispatchAction) {
	record.handler(currTrigger, e$1, dispatchAction);
}
function makeDispatchAction$1(api) {
	var pendings = {
		showTip: [],
		hideTip: []
	};
	var dispatchAction = function(payload) {
		var pendingList = pendings[payload.type];
		if (pendingList) pendingList.push(payload);
		else {
			payload.dispatchAction = dispatchAction;
			api.dispatchAction(payload);
		}
	};
	return {
		dispatchAction,
		pendings
	};
}
function unregister(key, api) {
	if (env_default.node) return;
	var zr = api.getZr();
	var record = (inner$1(zr).records || {})[key];
	if (record) inner$1(zr).records[key] = null;
}
var AxisPointerView = function(_super) {
	__extends(AxisPointerView$1, _super);
	function AxisPointerView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = AxisPointerView$1.type;
		return _this;
	}
	AxisPointerView$1.prototype.render = function(globalAxisPointerModel, ecModel, api) {
		var globalTooltipModel = ecModel.getComponent("tooltip");
		var triggerOn = globalAxisPointerModel.get("triggerOn") || globalTooltipModel && globalTooltipModel.get("triggerOn") || "mousemove|click";
		register$1("axisPointer", api, function(currTrigger, e$1, dispatchAction) {
			if (triggerOn !== "none" && (currTrigger === "leave" || triggerOn.indexOf(currTrigger) >= 0)) dispatchAction({
				type: "updateAxisPointer",
				currTrigger,
				x: e$1 && e$1.offsetX,
				y: e$1 && e$1.offsetY
			});
		});
	};
	AxisPointerView$1.prototype.remove = function(ecModel, api) {
		unregister("axisPointer", api);
	};
	AxisPointerView$1.prototype.dispose = function(ecModel, api) {
		unregister("axisPointer", api);
	};
	AxisPointerView$1.type = "axisPointer";
	return AxisPointerView$1;
}(Component_default);
var AxisPointerView_default = AxisPointerView;
function findPointFromSeries(finder, ecModel) {
	var point = [];
	var seriesIndex = finder.seriesIndex;
	var seriesModel;
	if (seriesIndex == null || !(seriesModel = ecModel.getSeriesByIndex(seriesIndex))) return { point: [] };
	var data = seriesModel.getData();
	var dataIndex = queryDataIndex(data, finder);
	if (dataIndex == null || dataIndex < 0 || isArray(dataIndex)) return { point: [] };
	var el = data.getItemGraphicEl(dataIndex);
	var coordSys = seriesModel.coordinateSystem;
	if (seriesModel.getTooltipPosition) point = seriesModel.getTooltipPosition(dataIndex) || [];
	else if (coordSys && coordSys.dataToPoint) if (finder.isStacked) {
		var baseAxis = coordSys.getBaseAxis();
		var valueAxis$1 = coordSys.getOtherAxis(baseAxis);
		var valueAxisDim = valueAxis$1.dim;
		var baseAxisDim = baseAxis.dim;
		var baseDataOffset = valueAxisDim === "x" || valueAxisDim === "radius" ? 1 : 0;
		var baseDim = data.mapDimension(baseAxisDim);
		var stackedData = [];
		stackedData[baseDataOffset] = data.get(baseDim, dataIndex);
		stackedData[1 - baseDataOffset] = data.get(data.getCalculationInfo("stackResultDimension"), dataIndex);
		point = coordSys.dataToPoint(stackedData) || [];
	} else point = coordSys.dataToPoint(data.getValues(map$1(coordSys.dimensions, function(dim) {
		return data.mapDimension(dim);
	}), dataIndex)) || [];
	else if (el) {
		var rect = el.getBoundingRect().clone();
		rect.applyTransform(el.transform);
		point = [rect.x + rect.width / 2, rect.y + rect.height / 2];
	}
	return {
		point,
		el
	};
}
var inner = makeInner();
function axisTrigger(payload, ecModel, api) {
	var currTrigger = payload.currTrigger;
	var point = [payload.x, payload.y];
	var finder = payload;
	var dispatchAction = payload.dispatchAction || bind$1(api.dispatchAction, api);
	var coordSysAxesInfo = ecModel.getComponent("axisPointer").coordSysAxesInfo;
	if (!coordSysAxesInfo) return;
	if (illegalPoint(point)) point = findPointFromSeries({
		seriesIndex: finder.seriesIndex,
		dataIndex: finder.dataIndex
	}, ecModel).point;
	var isIllegalPoint = illegalPoint(point);
	var inputAxesInfo = finder.axesInfo;
	var axesInfo = coordSysAxesInfo.axesInfo;
	var shouldHide = currTrigger === "leave" || illegalPoint(point);
	var outputPayload = {};
	var showValueMap = {};
	var dataByCoordSys = {
		list: [],
		map: {}
	};
	var updaters = {
		showPointer: curry$1(showPointer, showValueMap),
		showTooltip: curry$1(showTooltip, dataByCoordSys)
	};
	each$4(coordSysAxesInfo.coordSysMap, function(coordSys, coordSysKey) {
		var coordSysContainsPoint = isIllegalPoint || coordSys.containPoint(point);
		each$4(coordSysAxesInfo.coordSysAxesInfo[coordSysKey], function(axisInfo, key) {
			var axis = axisInfo.axis;
			var inputAxisInfo = findInputAxisInfo(inputAxesInfo, axisInfo);
			if (!shouldHide && coordSysContainsPoint && (!inputAxesInfo || inputAxisInfo)) {
				var val = inputAxisInfo && inputAxisInfo.value;
				if (val == null && !isIllegalPoint) val = axis.pointToData(point);
				val != null && processOnAxis(axisInfo, val, updaters, false, outputPayload);
			}
		});
	});
	var linkTriggers = {};
	each$4(axesInfo, function(tarAxisInfo, tarKey) {
		var linkGroup = tarAxisInfo.linkGroup;
		if (linkGroup && !showValueMap[tarKey]) each$4(linkGroup.axesInfo, function(srcAxisInfo, srcKey) {
			var srcValItem = showValueMap[srcKey];
			if (srcAxisInfo !== tarAxisInfo && srcValItem) {
				var val = srcValItem.value;
				linkGroup.mapper && (val = tarAxisInfo.axis.scale.parse(linkGroup.mapper(val, makeMapperParam(srcAxisInfo), makeMapperParam(tarAxisInfo))));
				linkTriggers[tarAxisInfo.key] = val;
			}
		});
	});
	each$4(linkTriggers, function(val, tarKey) {
		processOnAxis(axesInfo[tarKey], val, updaters, true, outputPayload);
	});
	updateModelActually(showValueMap, axesInfo, outputPayload);
	dispatchTooltipActually(dataByCoordSys, point, payload, dispatchAction);
	dispatchHighDownActually(axesInfo, dispatchAction, api);
	return outputPayload;
}
function processOnAxis(axisInfo, newValue, updaters, noSnap, outputFinder) {
	var axis = axisInfo.axis;
	if (axis.scale.isBlank() || !axis.containData(newValue)) return;
	if (!axisInfo.involveSeries) {
		updaters.showPointer(axisInfo, newValue);
		return;
	}
	var payloadInfo = buildPayloadsBySeries(newValue, axisInfo);
	var payloadBatch = payloadInfo.payloadBatch;
	var snapToValue = payloadInfo.snapToValue;
	if (payloadBatch[0] && outputFinder.seriesIndex == null) extend(outputFinder, payloadBatch[0]);
	if (!noSnap && axisInfo.snap) {
		if (axis.containData(snapToValue) && snapToValue != null) newValue = snapToValue;
	}
	updaters.showPointer(axisInfo, newValue, payloadBatch);
	updaters.showTooltip(axisInfo, payloadInfo, snapToValue);
}
function buildPayloadsBySeries(value, axisInfo) {
	var axis = axisInfo.axis;
	var dim = axis.dim;
	var snapToValue = value;
	var payloadBatch = [];
	var minDist = Number.MAX_VALUE;
	var minDiff = -1;
	each$4(axisInfo.seriesModels, function(series, idx) {
		var dataDim = series.getData().mapDimensionsAll(dim);
		var seriesNestestValue;
		var dataIndices;
		if (series.getAxisTooltipData) {
			var result = series.getAxisTooltipData(dataDim, value, axis);
			dataIndices = result.dataIndices;
			seriesNestestValue = result.nestestValue;
		} else {
			dataIndices = series.getData().indicesOfNearest(
				dataDim[0],
				value,
				// Add a threshold to avoid find the wrong dataIndex
				// when data length is not same.
				// false,
				axis.type === "category" ? .5 : null
);
			if (!dataIndices.length) return;
			seriesNestestValue = series.getData().get(dataDim[0], dataIndices[0]);
		}
		if (seriesNestestValue == null || !isFinite(seriesNestestValue)) return;
		var diff = value - seriesNestestValue;
		var dist$2 = Math.abs(diff);
		if (dist$2 <= minDist) {
			if (dist$2 < minDist || diff >= 0 && minDiff < 0) {
				minDist = dist$2;
				minDiff = diff;
				snapToValue = seriesNestestValue;
				payloadBatch.length = 0;
			}
			each$4(dataIndices, function(dataIndex) {
				payloadBatch.push({
					seriesIndex: series.seriesIndex,
					dataIndexInside: dataIndex,
					dataIndex: series.getData().getRawIndex(dataIndex)
				});
			});
		}
	});
	return {
		payloadBatch,
		snapToValue
	};
}
function showPointer(showValueMap, axisInfo, value, payloadBatch) {
	showValueMap[axisInfo.key] = {
		value,
		payloadBatch
	};
}
function showTooltip(dataByCoordSys, axisInfo, payloadInfo, value) {
	var payloadBatch = payloadInfo.payloadBatch;
	var axis = axisInfo.axis;
	var axisModel = axis.model;
	var axisPointerModel = axisInfo.axisPointerModel;
	if (!axisInfo.triggerTooltip || !payloadBatch.length) return;
	var coordSysModel = axisInfo.coordSys.model;
	var coordSysKey = makeKey(coordSysModel);
	var coordSysItem = dataByCoordSys.map[coordSysKey];
	if (!coordSysItem) {
		coordSysItem = dataByCoordSys.map[coordSysKey] = {
			coordSysId: coordSysModel.id,
			coordSysIndex: coordSysModel.componentIndex,
			coordSysType: coordSysModel.type,
			coordSysMainType: coordSysModel.mainType,
			dataByAxis: []
		};
		dataByCoordSys.list.push(coordSysItem);
	}
	coordSysItem.dataByAxis.push({
		axisDim: axis.dim,
		axisIndex: axisModel.componentIndex,
		axisType: axisModel.type,
		axisId: axisModel.id,
		value,
		valueLabelOpt: {
			precision: axisPointerModel.get(["label", "precision"]),
			formatter: axisPointerModel.get(["label", "formatter"])
		},
		seriesDataIndices: payloadBatch.slice()
	});
}
function updateModelActually(showValueMap, axesInfo, outputPayload) {
	var outputAxesInfo = outputPayload.axesInfo = [];
	each$4(axesInfo, function(axisInfo, key) {
		var option = axisInfo.axisPointerModel.option;
		var valItem = showValueMap[key];
		if (valItem) {
			!axisInfo.useHandle && (option.status = "show");
			option.value = valItem.value;
			option.seriesDataIndices = (valItem.payloadBatch || []).slice();
		} else !axisInfo.useHandle && (option.status = "hide");
		option.status === "show" && outputAxesInfo.push({
			axisDim: axisInfo.axis.dim,
			axisIndex: axisInfo.axis.model.componentIndex,
			value: option.value
		});
	});
}
function dispatchTooltipActually(dataByCoordSys, point, payload, dispatchAction) {
	if (illegalPoint(point) || !dataByCoordSys.list.length) {
		dispatchAction({ type: "hideTip" });
		return;
	}
	var sampleItem = ((dataByCoordSys.list[0].dataByAxis[0] || {}).seriesDataIndices || [])[0] || {};
	dispatchAction({
		type: "showTip",
		escapeConnect: true,
		x: point[0],
		y: point[1],
		tooltipOption: payload.tooltipOption,
		position: payload.position,
		dataIndexInside: sampleItem.dataIndexInside,
		dataIndex: sampleItem.dataIndex,
		seriesIndex: sampleItem.seriesIndex,
		dataByCoordSys: dataByCoordSys.list
	});
}
function dispatchHighDownActually(axesInfo, dispatchAction, api) {
	var zr = api.getZr();
	var highDownKey = "axisPointerLastHighlights";
	var lastHighlights = inner(zr)[highDownKey] || {};
	var newHighlights = inner(zr)[highDownKey] = {};
	each$4(axesInfo, function(axisInfo, key) {
		var option = axisInfo.axisPointerModel.option;
		option.status === "show" && axisInfo.triggerEmphasis && each$4(option.seriesDataIndices, function(batchItem) {
			var key$1 = batchItem.seriesIndex + " | " + batchItem.dataIndex;
			newHighlights[key$1] = batchItem;
		});
	});
	var toHighlight = [];
	var toDownplay = [];
	each$4(lastHighlights, function(batchItem, key) {
		!newHighlights[key] && toDownplay.push(batchItem);
	});
	each$4(newHighlights, function(batchItem, key) {
		!lastHighlights[key] && toHighlight.push(batchItem);
	});
	toDownplay.length && api.dispatchAction({
		type: "downplay",
		escapeConnect: true,
		notBlur: true,
		batch: toDownplay
	});
	toHighlight.length && api.dispatchAction({
		type: "highlight",
		escapeConnect: true,
		notBlur: true,
		batch: toHighlight
	});
}
function findInputAxisInfo(inputAxesInfo, axisInfo) {
	for (var i = 0; i < (inputAxesInfo || []).length; i++) {
		var inputAxisInfo = inputAxesInfo[i];
		if (axisInfo.axis.dim === inputAxisInfo.axisDim && axisInfo.axis.model.componentIndex === inputAxisInfo.axisIndex) return inputAxisInfo;
	}
}
function makeMapperParam(axisInfo) {
	var axisModel = axisInfo.axis.model;
	var item = {};
	var dim = item.axisDim = axisInfo.axis.dim;
	item.axisIndex = item[dim + "AxisIndex"] = axisModel.componentIndex;
	item.axisName = item[dim + "AxisName"] = axisModel.name;
	item.axisId = item[dim + "AxisId"] = axisModel.id;
	return item;
}
function illegalPoint(point) {
	return !point || point[0] == null || isNaN(point[0]) || point[1] == null || isNaN(point[1]);
}
function install$7(registers) {
	AxisView_default.registerAxisPointerClass("CartesianAxisPointer", CartesianAxisPointer_default);
	registers.registerComponentModel(AxisPointerModel_default);
	registers.registerComponentView(AxisPointerView_default);
	registers.registerPreprocessor(function(option) {
		if (option) {
			(!option.axisPointer || option.axisPointer.length === 0) && (option.axisPointer = {});
			var link = option.axisPointer.link;
			if (link && !isArray(link)) option.axisPointer.link = [link];
		}
	});
	registers.registerProcessor(registers.PRIORITY.PROCESSOR.STATISTIC, function(ecModel, api) {
		ecModel.getComponent("axisPointer").coordSysAxesInfo = collect(ecModel, api);
	});
	registers.registerAction({
		type: "updateAxisPointer",
		event: "updateAxisPointer",
		update: ":updateAxisPointer"
	}, axisTrigger);
}
function install$6(registers) {
	use(install$8);
	use(install$7);
}
function makeBackground(rect, componentModel) {
	var padding = normalizeCssArray(componentModel.get("padding"));
	var style = componentModel.getItemStyle(["color", "opacity"]);
	style.fill = componentModel.get("backgroundColor");
	rect = new Rect_default({
		shape: {
			x: rect.x - padding[3],
			y: rect.y - padding[0],
			width: rect.width + padding[1] + padding[3],
			height: rect.height + padding[0] + padding[2],
			r: componentModel.get("borderRadius")
		},
		style,
		silent: true,
		z2: -1
	});
	return rect;
}
var TooltipModel = function(_super) {
	__extends(TooltipModel$1, _super);
	function TooltipModel$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = TooltipModel$1.type;
		return _this;
	}
	TooltipModel$1.type = "tooltip";
	TooltipModel$1.dependencies = ["axisPointer"];
	TooltipModel$1.defaultOption = {
		z: 60,
		show: true,
		showContent: true,
		trigger: "item",
		triggerOn: "mousemove|click",
		alwaysShowContent: false,
		displayMode: "single",
		renderMode: "auto",
		confine: null,
		showDelay: 0,
		hideDelay: 100,
		transitionDuration: .4,
		enterable: false,
		backgroundColor: "#fff",
		shadowBlur: 10,
		shadowColor: "rgba(0, 0, 0, .2)",
		shadowOffsetX: 1,
		shadowOffsetY: 2,
		borderRadius: 4,
		borderWidth: 1,
		padding: null,
		extraCssText: "",
		axisPointer: {
			type: "line",
			axis: "auto",
			animation: "auto",
			animationDurationUpdate: 200,
			animationEasingUpdate: "exponentialOut",
			crossStyle: {
				color: "#999",
				width: 1,
				type: "dashed",
				textStyle: {}
			}
		},
		textStyle: {
			color: "#666",
			fontSize: 14
		}
	};
	return TooltipModel$1;
}(Component_default$1);
var TooltipModel_default = TooltipModel;
function shouldTooltipConfine(tooltipModel) {
	var confineOption = tooltipModel.get("confine");
	return confineOption != null ? !!confineOption : tooltipModel.get("renderMode") === "richText";
}
function testStyle(styleProps) {
	if (!env_default.domSupported) return;
	var style = document.documentElement.style;
	for (var i = 0, len$1 = styleProps.length; i < len$1; i++) if (styleProps[i] in style) return styleProps[i];
}
var TRANSFORM_VENDOR = testStyle([
	"transform",
	"webkitTransform",
	"OTransform",
	"MozTransform",
	"msTransform"
]);
var TRANSITION_VENDOR = testStyle([
	"webkitTransition",
	"transition",
	"OTransition",
	"MozTransition",
	"msTransition"
]);
function toCSSVendorPrefix(styleVendor, styleProp) {
	if (!styleVendor) return styleProp;
	styleProp = toCamelCase(styleProp, true);
	var idx = styleVendor.indexOf(styleProp);
	styleVendor = idx === -1 ? styleProp : "-" + styleVendor.slice(0, idx) + "-" + styleProp;
	return styleVendor.toLowerCase();
}
function getComputedStyle(el, style) {
	var stl = el.currentStyle || document.defaultView && document.defaultView.getComputedStyle(el);
	return stl ? style ? stl[style] : stl : null;
}
var CSS_TRANSITION_VENDOR = toCSSVendorPrefix(TRANSITION_VENDOR, "transition");
var CSS_TRANSFORM_VENDOR = toCSSVendorPrefix(TRANSFORM_VENDOR, "transform");
var gCssText = "position:absolute;display:block;border-style:solid;white-space:nowrap;z-index:9999999;" + (env_default.transform3dSupported ? "will-change:transform;" : "");
function mirrorPos(pos) {
	pos = pos === "left" ? "right" : pos === "right" ? "left" : pos === "top" ? "bottom" : "top";
	return pos;
}
function assembleArrow(tooltipModel, borderColor, arrowPosition) {
	if (!isString(arrowPosition) || arrowPosition === "inside") return "";
	var backgroundColor$1 = tooltipModel.get("backgroundColor");
	var borderWidth = tooltipModel.get("borderWidth");
	borderColor = convertToColorString(borderColor);
	var arrowPos = mirrorPos(arrowPosition);
	var arrowSize = Math.max(Math.round(borderWidth) * 1.5, 6);
	var positionStyle = "";
	var transformStyle = CSS_TRANSFORM_VENDOR + ":";
	var rotateDeg;
	if (indexOf(["left", "right"], arrowPos) > -1) {
		positionStyle += "top:50%";
		transformStyle += "translateY(-50%) rotate(" + (rotateDeg = arrowPos === "left" ? -225 : -45) + "deg)";
	} else {
		positionStyle += "left:50%";
		transformStyle += "translateX(-50%) rotate(" + (rotateDeg = arrowPos === "top" ? 225 : 45) + "deg)";
	}
	var rotateRadian = rotateDeg * Math.PI / 180;
	var arrowWH = arrowSize + borderWidth;
	var rotatedWH = arrowWH * Math.abs(Math.cos(rotateRadian)) + arrowWH * Math.abs(Math.sin(rotateRadian));
	var arrowOffset = Math.round(((rotatedWH - Math.SQRT2 * borderWidth) / 2 + Math.SQRT2 * borderWidth - (rotatedWH - arrowWH) / 2) * 100) / 100;
	positionStyle += ";" + arrowPos + ":-" + arrowOffset + "px";
	var borderStyle = borderColor + " solid " + borderWidth + "px;";
	var styleCss = [
		"position:absolute;width:" + arrowSize + "px;height:" + arrowSize + "px;z-index:-1;",
		positionStyle + ";" + transformStyle + ";",
		"border-bottom:" + borderStyle,
		"border-right:" + borderStyle,
		"background-color:" + backgroundColor$1 + ";"
	];
	return "<div style=\"" + styleCss.join("") + "\"></div>";
}
function assembleTransition(duration, onlyFade) {
	var transitionCurve = "cubic-bezier(0.23,1,0.32,1)";
	var transitionOption = " " + duration / 2 + "s " + transitionCurve;
	var transitionText = "opacity" + transitionOption + ",visibility" + transitionOption;
	if (!onlyFade) {
		transitionOption = " " + duration + "s " + transitionCurve;
		transitionText += env_default.transformSupported ? "," + CSS_TRANSFORM_VENDOR + transitionOption : ",left" + transitionOption + ",top" + transitionOption;
	}
	return CSS_TRANSITION_VENDOR + ":" + transitionText;
}
function assembleTransform(x, y, toString) {
	var x0 = x.toFixed(0) + "px";
	var y0 = y.toFixed(0) + "px";
	if (!env_default.transformSupported) return toString ? "top:" + y0 + ";left:" + x0 + ";" : [["top", y0], ["left", x0]];
	var is3d = env_default.transform3dSupported;
	var translate$1 = "translate" + (is3d ? "3d" : "") + "(" + x0 + "," + y0 + (is3d ? ",0" : "") + ")";
	return toString ? "top:0;left:0;" + CSS_TRANSFORM_VENDOR + ":" + translate$1 + ";" : [
		["top", 0],
		["left", 0],
		[TRANSFORM_VENDOR, translate$1]
	];
}
/**

* @param {Object} textStyle

* @return {string}

* @inner

*/
function assembleFont(textStyleModel) {
	var cssText = [];
	var fontSize = textStyleModel.get("fontSize");
	var color = textStyleModel.getTextColor();
	color && cssText.push("color:" + color);
	cssText.push("font:" + textStyleModel.getFont());
	var lineHeight = retrieve2(textStyleModel.get("lineHeight"), Math.round(fontSize * 3 / 2));
	fontSize && cssText.push("line-height:" + lineHeight + "px");
	var shadowColor = textStyleModel.get("textShadowColor");
	var shadowBlur = textStyleModel.get("textShadowBlur") || 0;
	var shadowOffsetX = textStyleModel.get("textShadowOffsetX") || 0;
	var shadowOffsetY = textStyleModel.get("textShadowOffsetY") || 0;
	shadowColor && shadowBlur && cssText.push("text-shadow:" + shadowOffsetX + "px " + shadowOffsetY + "px " + shadowBlur + "px " + shadowColor);
	each$4(["decoration", "align"], function(name) {
		var val = textStyleModel.get(name);
		val && cssText.push("text-" + name + ":" + val);
	});
	return cssText.join(";");
}
function assembleCssText(tooltipModel, enableTransition, onlyFade) {
	var cssText = [];
	var transitionDuration = tooltipModel.get("transitionDuration");
	var backgroundColor$1 = tooltipModel.get("backgroundColor");
	var shadowBlur = tooltipModel.get("shadowBlur");
	var shadowColor = tooltipModel.get("shadowColor");
	var shadowOffsetX = tooltipModel.get("shadowOffsetX");
	var shadowOffsetY = tooltipModel.get("shadowOffsetY");
	var textStyleModel = tooltipModel.getModel("textStyle");
	var padding = getPaddingFromTooltipModel(tooltipModel, "html");
	var boxShadow = shadowOffsetX + "px " + shadowOffsetY + "px " + shadowBlur + "px " + shadowColor;
	cssText.push("box-shadow:" + boxShadow);
	enableTransition && transitionDuration && cssText.push(assembleTransition(transitionDuration, onlyFade));
	if (backgroundColor$1) cssText.push("background-color:" + backgroundColor$1);
	each$4([
		"width",
		"color",
		"radius"
	], function(name) {
		var borderName = "border-" + name;
		var camelCase = toCamelCase(borderName);
		var val = tooltipModel.get(camelCase);
		val != null && cssText.push(borderName + ":" + val + (name === "color" ? "" : "px"));
	});
	cssText.push(assembleFont(textStyleModel));
	if (padding != null) cssText.push("padding:" + normalizeCssArray(padding).join("px ") + "px");
	return cssText.join(";") + ";";
}
function makeStyleCoord$1(out$1, zr, container, zrX, zrY) {
	var zrPainter = zr && zr.painter;
	if (container) {
		var zrViewportRoot = zrPainter && zrPainter.getViewportRoot();
		if (zrViewportRoot) transformLocalCoord(out$1, zrViewportRoot, container, zrX, zrY);
	} else {
		out$1[0] = zrX;
		out$1[1] = zrY;
		var viewportRootOffset = zrPainter && zrPainter.getViewportRootOffset();
		if (viewportRootOffset) {
			out$1[0] += viewportRootOffset.offsetLeft;
			out$1[1] += viewportRootOffset.offsetTop;
		}
	}
	out$1[2] = out$1[0] / zr.getWidth();
	out$1[3] = out$1[1] / zr.getHeight();
}
var TooltipHTMLContent = function() {
	function TooltipHTMLContent$1(api, opt) {
		this._show = false;
		this._styleCoord = [
			0,
			0,
			0,
			0
		];
		this._enterable = true;
		this._alwaysShowContent = false;
		this._firstShow = true;
		this._longHide = true;
		if (env_default.wxa) return null;
		var el = document.createElement("div");
		el.domBelongToZr = true;
		this.el = el;
		var zr = this._zr = api.getZr();
		var appendTo = opt.appendTo;
		var container = appendTo && (isString(appendTo) ? document.querySelector(appendTo) : isDom(appendTo) ? appendTo : isFunction(appendTo) && appendTo(api.getDom()));
		makeStyleCoord$1(this._styleCoord, zr, container, api.getWidth() / 2, api.getHeight() / 2);
		(container || api.getDom()).appendChild(el);
		this._api = api;
		this._container = container;
		var self$1 = this;
		el.onmouseenter = function() {
			if (self$1._enterable) {
				clearTimeout(self$1._hideTimeout);
				self$1._show = true;
			}
			self$1._inContent = true;
		};
		el.onmousemove = function(e$1) {
			e$1 = e$1 || window.event;
			if (!self$1._enterable) {
				var handler = zr.handler;
				var zrViewportRoot = zr.painter.getViewportRoot();
				normalizeEvent(zrViewportRoot, e$1, true);
				handler.dispatch("mousemove", e$1);
			}
		};
		el.onmouseleave = function() {
			self$1._inContent = false;
			if (self$1._enterable) {
				if (self$1._show) self$1.hideLater(self$1._hideDelay);
			}
		};
	}
	/**
	
	* Update when tooltip is rendered
	
	*/
	TooltipHTMLContent$1.prototype.update = function(tooltipModel) {
		if (!this._container) {
			var container = this._api.getDom();
			var position = getComputedStyle(container, "position");
			var domStyle = container.style;
			if (domStyle.position !== "absolute" && position !== "absolute") domStyle.position = "relative";
		}
		var alwaysShowContent = tooltipModel.get("alwaysShowContent");
		alwaysShowContent && this._moveIfResized();
		this._alwaysShowContent = alwaysShowContent;
		this.el.className = tooltipModel.get("className") || "";
	};
	TooltipHTMLContent$1.prototype.show = function(tooltipModel, nearPointColor) {
		clearTimeout(this._hideTimeout);
		clearTimeout(this._longHideTimeout);
		var el = this.el;
		var style = el.style;
		var styleCoord = this._styleCoord;
		if (!el.innerHTML) style.display = "none";
		else style.cssText = gCssText + assembleCssText(tooltipModel, !this._firstShow, this._longHide) + assembleTransform(styleCoord[0], styleCoord[1], true) + ("border-color:" + convertToColorString(nearPointColor) + ";") + (tooltipModel.get("extraCssText") || "") + (";pointer-events:" + (this._enterable ? "auto" : "none"));
		this._show = true;
		this._firstShow = false;
		this._longHide = false;
	};
	TooltipHTMLContent$1.prototype.setContent = function(content, markers, tooltipModel, borderColor, arrowPosition) {
		var el = this.el;
		if (content == null) {
			el.innerHTML = "";
			return;
		}
		var arrow = "";
		if (isString(arrowPosition) && tooltipModel.get("trigger") === "item" && !shouldTooltipConfine(tooltipModel)) arrow = assembleArrow(tooltipModel, borderColor, arrowPosition);
		if (isString(content)) el.innerHTML = content + arrow;
		else if (content) {
			el.innerHTML = "";
			if (!isArray(content)) content = [content];
			for (var i = 0; i < content.length; i++) if (isDom(content[i]) && content[i].parentNode !== el) el.appendChild(content[i]);
			if (arrow && el.childNodes.length) {
				var arrowEl = document.createElement("div");
				arrowEl.innerHTML = arrow;
				el.appendChild(arrowEl);
			}
		}
	};
	TooltipHTMLContent$1.prototype.setEnterable = function(enterable) {
		this._enterable = enterable;
	};
	TooltipHTMLContent$1.prototype.getSize = function() {
		var el = this.el;
		return el ? [el.offsetWidth, el.offsetHeight] : [0, 0];
	};
	TooltipHTMLContent$1.prototype.moveTo = function(zrX, zrY) {
		if (!this.el) return;
		var styleCoord = this._styleCoord;
		makeStyleCoord$1(styleCoord, this._zr, this._container, zrX, zrY);
		if (styleCoord[0] != null && styleCoord[1] != null) {
			var style_1 = this.el.style;
			var transforms = assembleTransform(styleCoord[0], styleCoord[1]);
			each$4(transforms, function(transform) {
				style_1[transform[0]] = transform[1];
			});
		}
	};
	/**
	
	* when `alwaysShowContent` is true,
	
	* move the tooltip after chart resized
	
	*/
	TooltipHTMLContent$1.prototype._moveIfResized = function() {
		var ratioX = this._styleCoord[2];
		var ratioY = this._styleCoord[3];
		this.moveTo(ratioX * this._zr.getWidth(), ratioY * this._zr.getHeight());
	};
	TooltipHTMLContent$1.prototype.hide = function() {
		var _this = this;
		var style = this.el.style;
		style.visibility = "hidden";
		style.opacity = "0";
		env_default.transform3dSupported && (style.willChange = "");
		this._show = false;
		this._longHideTimeout = setTimeout(function() {
			return _this._longHide = true;
		}, 500);
	};
	TooltipHTMLContent$1.prototype.hideLater = function(time) {
		if (this._show && !(this._inContent && this._enterable) && !this._alwaysShowContent) if (time) {
			this._hideDelay = time;
			this._show = false;
			this._hideTimeout = setTimeout(bind$1(this.hide, this), time);
		} else this.hide();
	};
	TooltipHTMLContent$1.prototype.isShow = function() {
		return this._show;
	};
	TooltipHTMLContent$1.prototype.dispose = function() {
		clearTimeout(this._hideTimeout);
		clearTimeout(this._longHideTimeout);
		var parentNode = this.el.parentNode;
		parentNode && parentNode.removeChild(this.el);
		this.el = this._container = null;
	};
	return TooltipHTMLContent$1;
}();
var TooltipHTMLContent_default = TooltipHTMLContent;
var TooltipRichContent = function() {
	function TooltipRichContent$1(api) {
		this._show = false;
		this._styleCoord = [
			0,
			0,
			0,
			0
		];
		this._alwaysShowContent = false;
		this._enterable = true;
		this._zr = api.getZr();
		makeStyleCoord(this._styleCoord, this._zr, api.getWidth() / 2, api.getHeight() / 2);
	}
	/**
	
	* Update when tooltip is rendered
	
	*/
	TooltipRichContent$1.prototype.update = function(tooltipModel) {
		var alwaysShowContent = tooltipModel.get("alwaysShowContent");
		alwaysShowContent && this._moveIfResized();
		this._alwaysShowContent = alwaysShowContent;
	};
	TooltipRichContent$1.prototype.show = function() {
		if (this._hideTimeout) clearTimeout(this._hideTimeout);
		this.el.show();
		this._show = true;
	};
	/**
	
	* Set tooltip content
	
	*/
	TooltipRichContent$1.prototype.setContent = function(content, markupStyleCreator, tooltipModel, borderColor, arrowPosition) {
		var _this = this;
		if (isObject$2(content)) throwError("");
		if (this.el) this._zr.remove(this.el);
		var textStyleModel = tooltipModel.getModel("textStyle");
		this.el = new Text_default({
			style: {
				rich: markupStyleCreator.richTextStyles,
				text: content,
				lineHeight: 22,
				borderWidth: 1,
				borderColor,
				textShadowColor: textStyleModel.get("textShadowColor"),
				fill: tooltipModel.get(["textStyle", "color"]),
				padding: getPaddingFromTooltipModel(tooltipModel, "richText"),
				verticalAlign: "top",
				align: "left"
			},
			z: tooltipModel.get("z")
		});
		each$4([
			"backgroundColor",
			"borderRadius",
			"shadowColor",
			"shadowBlur",
			"shadowOffsetX",
			"shadowOffsetY"
		], function(propName) {
			_this.el.style[propName] = tooltipModel.get(propName);
		});
		each$4([
			"textShadowBlur",
			"textShadowOffsetX",
			"textShadowOffsetY"
		], function(propName) {
			_this.el.style[propName] = textStyleModel.get(propName) || 0;
		});
		this._zr.add(this.el);
		var self$1 = this;
		this.el.on("mouseover", function() {
			if (self$1._enterable) {
				clearTimeout(self$1._hideTimeout);
				self$1._show = true;
			}
			self$1._inContent = true;
		});
		this.el.on("mouseout", function() {
			if (self$1._enterable) {
				if (self$1._show) self$1.hideLater(self$1._hideDelay);
			}
			self$1._inContent = false;
		});
	};
	TooltipRichContent$1.prototype.setEnterable = function(enterable) {
		this._enterable = enterable;
	};
	TooltipRichContent$1.prototype.getSize = function() {
		var el = this.el;
		var bounding = this.el.getBoundingRect();
		var shadowOuterSize = calcShadowOuterSize(el.style);
		return [bounding.width + shadowOuterSize.left + shadowOuterSize.right, bounding.height + shadowOuterSize.top + shadowOuterSize.bottom];
	};
	TooltipRichContent$1.prototype.moveTo = function(x, y) {
		var el = this.el;
		if (el) {
			var styleCoord = this._styleCoord;
			makeStyleCoord(styleCoord, this._zr, x, y);
			x = styleCoord[0];
			y = styleCoord[1];
			var style = el.style;
			var borderWidth = mathMaxWith0(style.borderWidth || 0);
			var shadowOuterSize = calcShadowOuterSize(style);
			el.x = x + borderWidth + shadowOuterSize.left;
			el.y = y + borderWidth + shadowOuterSize.top;
			el.markRedraw();
		}
	};
	/**
	
	* when `alwaysShowContent` is true,
	
	* move the tooltip after chart resized
	
	*/
	TooltipRichContent$1.prototype._moveIfResized = function() {
		var ratioX = this._styleCoord[2];
		var ratioY = this._styleCoord[3];
		this.moveTo(ratioX * this._zr.getWidth(), ratioY * this._zr.getHeight());
	};
	TooltipRichContent$1.prototype.hide = function() {
		if (this.el) this.el.hide();
		this._show = false;
	};
	TooltipRichContent$1.prototype.hideLater = function(time) {
		if (this._show && !(this._inContent && this._enterable) && !this._alwaysShowContent) if (time) {
			this._hideDelay = time;
			this._show = false;
			this._hideTimeout = setTimeout(bind$1(this.hide, this), time);
		} else this.hide();
	};
	TooltipRichContent$1.prototype.isShow = function() {
		return this._show;
	};
	TooltipRichContent$1.prototype.dispose = function() {
		this._zr.remove(this.el);
	};
	return TooltipRichContent$1;
}();
function mathMaxWith0(val) {
	return Math.max(0, val);
}
function calcShadowOuterSize(style) {
	var shadowBlur = mathMaxWith0(style.shadowBlur || 0);
	var shadowOffsetX = mathMaxWith0(style.shadowOffsetX || 0);
	var shadowOffsetY = mathMaxWith0(style.shadowOffsetY || 0);
	return {
		left: mathMaxWith0(shadowBlur - shadowOffsetX),
		right: mathMaxWith0(shadowBlur + shadowOffsetX),
		top: mathMaxWith0(shadowBlur - shadowOffsetY),
		bottom: mathMaxWith0(shadowBlur + shadowOffsetY)
	};
}
function makeStyleCoord(out$1, zr, zrX, zrY) {
	out$1[0] = zrX;
	out$1[1] = zrY;
	out$1[2] = out$1[0] / zr.getWidth();
	out$1[3] = out$1[1] / zr.getHeight();
}
var TooltipRichContent_default = TooltipRichContent;
var proxyRect = new Rect_default({ shape: {
	x: -1,
	y: -1,
	width: 2,
	height: 2
} });
var TooltipView = function(_super) {
	__extends(TooltipView$1, _super);
	function TooltipView$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = TooltipView$1.type;
		return _this;
	}
	TooltipView$1.prototype.init = function(ecModel, api) {
		if (env_default.node || !api.getDom()) return;
		var tooltipModel = ecModel.getComponent("tooltip");
		var renderMode = this._renderMode = getTooltipRenderMode(tooltipModel.get("renderMode"));
		this._tooltipContent = renderMode === "richText" ? new TooltipRichContent_default(api) : new TooltipHTMLContent_default(api, { appendTo: tooltipModel.get("appendToBody", true) ? "body" : tooltipModel.get("appendTo", true) });
	};
	TooltipView$1.prototype.render = function(tooltipModel, ecModel, api) {
		if (env_default.node || !api.getDom()) return;
		this.group.removeAll();
		this._tooltipModel = tooltipModel;
		this._ecModel = ecModel;
		this._api = api;
		var tooltipContent = this._tooltipContent;
		tooltipContent.update(tooltipModel);
		tooltipContent.setEnterable(tooltipModel.get("enterable"));
		this._initGlobalListener();
		this._keepShow();
		if (this._renderMode !== "richText" && tooltipModel.get("transitionDuration")) createOrUpdate(this, "_updatePosition", 50, "fixRate");
		else clear(this, "_updatePosition");
	};
	TooltipView$1.prototype._initGlobalListener = function() {
		var tooltipModel = this._tooltipModel;
		var triggerOn = tooltipModel.get("triggerOn");
		register$1("itemTooltip", this._api, bind$1(function(currTrigger, e$1, dispatchAction) {
			if (triggerOn !== "none") {
				if (triggerOn.indexOf(currTrigger) >= 0) this._tryShow(e$1, dispatchAction);
				else if (currTrigger === "leave") this._hide(dispatchAction);
			}
		}, this));
	};
	TooltipView$1.prototype._keepShow = function() {
		var tooltipModel = this._tooltipModel;
		var ecModel = this._ecModel;
		var api = this._api;
		var triggerOn = tooltipModel.get("triggerOn");
		if (this._lastX != null && this._lastY != null && triggerOn !== "none" && triggerOn !== "click") {
			var self_1 = this;
			clearTimeout(this._refreshUpdateTimeout);
			this._refreshUpdateTimeout = setTimeout(function() {
				!api.isDisposed() && self_1.manuallyShowTip(tooltipModel, ecModel, api, {
					x: self_1._lastX,
					y: self_1._lastY,
					dataByCoordSys: self_1._lastDataByCoordSys
				});
			});
		}
	};
	/**
	
	* Show tip manually by
	
	* dispatchAction({
	
	*     type: 'showTip',
	
	*     x: 10,
	
	*     y: 10
	
	* });
	
	* Or
	
	* dispatchAction({
	
	*      type: 'showTip',
	
	*      seriesIndex: 0,
	
	*      dataIndex or dataIndexInside or name
	
	* });
	
	*
	
	*  TODO Batch
	
	*/
	TooltipView$1.prototype.manuallyShowTip = function(tooltipModel, ecModel, api, payload) {
		if (payload.from === this.uid || env_default.node || !api.getDom()) return;
		var dispatchAction = makeDispatchAction(payload, api);
		this._ticket = "";
		var dataByCoordSys = payload.dataByCoordSys;
		var cmptRef = findComponentReference(payload, ecModel, api);
		if (cmptRef) {
			var rect = cmptRef.el.getBoundingRect().clone();
			rect.applyTransform(cmptRef.el.transform);
			this._tryShow({
				offsetX: rect.x + rect.width / 2,
				offsetY: rect.y + rect.height / 2,
				target: cmptRef.el,
				position: payload.position,
				positionDefault: "bottom"
			}, dispatchAction);
		} else if (payload.tooltip && payload.x != null && payload.y != null) {
			var el = proxyRect;
			el.x = payload.x;
			el.y = payload.y;
			el.update();
			getECData(el).tooltipConfig = {
				name: null,
				option: payload.tooltip
			};
			this._tryShow({
				offsetX: payload.x,
				offsetY: payload.y,
				target: el
			}, dispatchAction);
		} else if (dataByCoordSys) this._tryShow({
			offsetX: payload.x,
			offsetY: payload.y,
			position: payload.position,
			dataByCoordSys,
			tooltipOption: payload.tooltipOption
		}, dispatchAction);
		else if (payload.seriesIndex != null) {
			if (this._manuallyAxisShowTip(tooltipModel, ecModel, api, payload)) return;
			var pointInfo = findPointFromSeries(payload, ecModel);
			var cx = pointInfo.point[0];
			var cy = pointInfo.point[1];
			if (cx != null && cy != null) this._tryShow({
				offsetX: cx,
				offsetY: cy,
				target: pointInfo.el,
				position: payload.position,
				positionDefault: "bottom"
			}, dispatchAction);
		} else if (payload.x != null && payload.y != null) {
			api.dispatchAction({
				type: "updateAxisPointer",
				x: payload.x,
				y: payload.y
			});
			this._tryShow({
				offsetX: payload.x,
				offsetY: payload.y,
				position: payload.position,
				target: api.getZr().findHover(payload.x, payload.y).target
			}, dispatchAction);
		}
	};
	TooltipView$1.prototype.manuallyHideTip = function(tooltipModel, ecModel, api, payload) {
		var tooltipContent = this._tooltipContent;
		if (this._tooltipModel) tooltipContent.hideLater(this._tooltipModel.get("hideDelay"));
		this._lastX = this._lastY = this._lastDataByCoordSys = null;
		if (payload.from !== this.uid) this._hide(makeDispatchAction(payload, api));
	};
	TooltipView$1.prototype._manuallyAxisShowTip = function(tooltipModel, ecModel, api, payload) {
		var seriesIndex = payload.seriesIndex;
		var dataIndex = payload.dataIndex;
		var coordSysAxesInfo = ecModel.getComponent("axisPointer").coordSysAxesInfo;
		if (seriesIndex == null || dataIndex == null || coordSysAxesInfo == null) return;
		var seriesModel = ecModel.getSeriesByIndex(seriesIndex);
		if (!seriesModel) return;
		var data = seriesModel.getData();
		var tooltipCascadedModel = buildTooltipModel([
			data.getItemModel(dataIndex),
			seriesModel,
			(seriesModel.coordinateSystem || {}).model
		], this._tooltipModel);
		if (tooltipCascadedModel.get("trigger") !== "axis") return;
		api.dispatchAction({
			type: "updateAxisPointer",
			seriesIndex,
			dataIndex,
			position: payload.position
		});
		return true;
	};
	TooltipView$1.prototype._tryShow = function(e$1, dispatchAction) {
		var el = e$1.target;
		var tooltipModel = this._tooltipModel;
		if (!tooltipModel) return;
		this._lastX = e$1.offsetX;
		this._lastY = e$1.offsetY;
		var dataByCoordSys = e$1.dataByCoordSys;
		if (dataByCoordSys && dataByCoordSys.length) this._showAxisTooltip(dataByCoordSys, e$1);
		else if (el) {
			var ecData = getECData(el);
			if (ecData.ssrType === "legend") return;
			this._lastDataByCoordSys = null;
			var seriesDispatcher_1;
			var cmptDispatcher_1;
			findEventDispatcher(el, function(target) {
				if (getECData(target).dataIndex != null) {
					seriesDispatcher_1 = target;
					return true;
				}
				if (getECData(target).tooltipConfig != null) {
					cmptDispatcher_1 = target;
					return true;
				}
			}, true);
			if (seriesDispatcher_1) this._showSeriesItemTooltip(e$1, seriesDispatcher_1, dispatchAction);
			else if (cmptDispatcher_1) this._showComponentItemTooltip(e$1, cmptDispatcher_1, dispatchAction);
			else this._hide(dispatchAction);
		} else {
			this._lastDataByCoordSys = null;
			this._hide(dispatchAction);
		}
	};
	TooltipView$1.prototype._showOrMove = function(tooltipModel, cb) {
		var delay = tooltipModel.get("showDelay");
		cb = bind$1(cb, this);
		clearTimeout(this._showTimout);
		delay > 0 ? this._showTimout = setTimeout(cb, delay) : cb();
	};
	TooltipView$1.prototype._showAxisTooltip = function(dataByCoordSys, e$1) {
		var ecModel = this._ecModel;
		var globalTooltipModel = this._tooltipModel;
		var point = [e$1.offsetX, e$1.offsetY];
		var singleTooltipModel = buildTooltipModel([e$1.tooltipOption], globalTooltipModel);
		var renderMode = this._renderMode;
		var cbParamsList = [];
		var articleMarkup = createTooltipMarkup("section", {
			blocks: [],
			noHeader: true
		});
		var markupTextArrLegacy = [];
		var markupStyleCreator = new TooltipMarkupStyleCreator();
		each$4(dataByCoordSys, function(itemCoordSys) {
			each$4(itemCoordSys.dataByAxis, function(axisItem) {
				var axisModel = ecModel.getComponent(axisItem.axisDim + "Axis", axisItem.axisIndex);
				var axisValue = axisItem.value;
				if (!axisModel || axisValue == null) return;
				var axisValueLabel = getValueLabel(axisValue, axisModel.axis, ecModel, axisItem.seriesDataIndices, axisItem.valueLabelOpt);
				var axisSectionMarkup = createTooltipMarkup("section", {
					header: axisValueLabel,
					noHeader: !trim(axisValueLabel),
					sortBlocks: true,
					blocks: []
				});
				articleMarkup.blocks.push(axisSectionMarkup);
				each$4(axisItem.seriesDataIndices, function(idxItem) {
					var series = ecModel.getSeriesByIndex(idxItem.seriesIndex);
					var dataIndex = idxItem.dataIndexInside;
					var cbParams = series.getDataParams(dataIndex);
					if (cbParams.dataIndex < 0) return;
					cbParams.axisDim = axisItem.axisDim;
					cbParams.axisIndex = axisItem.axisIndex;
					cbParams.axisType = axisItem.axisType;
					cbParams.axisId = axisItem.axisId;
					cbParams.axisValue = getAxisRawValue(axisModel.axis, { value: axisValue });
					cbParams.axisValueLabel = axisValueLabel;
					cbParams.marker = markupStyleCreator.makeTooltipMarker("item", convertToColorString(cbParams.color), renderMode);
					var seriesTooltipResult = normalizeTooltipFormatResult(series.formatTooltip(dataIndex, true, null));
					var frag = seriesTooltipResult.frag;
					if (frag) {
						var valueFormatter = buildTooltipModel([series], globalTooltipModel).get("valueFormatter");
						axisSectionMarkup.blocks.push(valueFormatter ? extend({ valueFormatter }, frag) : frag);
					}
					if (seriesTooltipResult.text) markupTextArrLegacy.push(seriesTooltipResult.text);
					cbParamsList.push(cbParams);
				});
			});
		});
		articleMarkup.blocks.reverse();
		markupTextArrLegacy.reverse();
		var positionExpr = e$1.position;
		var orderMode = singleTooltipModel.get("order");
		var builtMarkupText = buildTooltipMarkup(articleMarkup, markupStyleCreator, renderMode, orderMode, ecModel.get("useUTC"), singleTooltipModel.get("textStyle"));
		builtMarkupText && markupTextArrLegacy.unshift(builtMarkupText);
		var blockBreak = renderMode === "richText" ? "\n\n" : "<br/>";
		var allMarkupText = markupTextArrLegacy.join(blockBreak);
		this._showOrMove(singleTooltipModel, function() {
			if (this._updateContentNotChangedOnAxis(dataByCoordSys, cbParamsList)) this._updatePosition(singleTooltipModel, positionExpr, point[0], point[1], this._tooltipContent, cbParamsList);
			else this._showTooltipContent(singleTooltipModel, allMarkupText, cbParamsList, Math.random() + "", point[0], point[1], positionExpr, null, markupStyleCreator);
		});
	};
	TooltipView$1.prototype._showSeriesItemTooltip = function(e$1, dispatcher, dispatchAction) {
		var ecModel = this._ecModel;
		var ecData = getECData(dispatcher);
		var seriesIndex = ecData.seriesIndex;
		var seriesModel = ecModel.getSeriesByIndex(seriesIndex);
		var dataModel = ecData.dataModel || seriesModel;
		var dataIndex = ecData.dataIndex;
		var dataType = ecData.dataType;
		var data = dataModel.getData(dataType);
		var renderMode = this._renderMode;
		var positionDefault = e$1.positionDefault;
		var tooltipModel = buildTooltipModel([
			data.getItemModel(dataIndex),
			dataModel,
			seriesModel && (seriesModel.coordinateSystem || {}).model
		], this._tooltipModel, positionDefault ? { position: positionDefault } : null);
		var tooltipTrigger = tooltipModel.get("trigger");
		if (tooltipTrigger != null && tooltipTrigger !== "item") return;
		var params = dataModel.getDataParams(dataIndex, dataType);
		var markupStyleCreator = new TooltipMarkupStyleCreator();
		params.marker = markupStyleCreator.makeTooltipMarker("item", convertToColorString(params.color), renderMode);
		var seriesTooltipResult = normalizeTooltipFormatResult(dataModel.formatTooltip(dataIndex, false, dataType));
		var orderMode = tooltipModel.get("order");
		var valueFormatter = tooltipModel.get("valueFormatter");
		var frag = seriesTooltipResult.frag;
		var markupText = frag ? buildTooltipMarkup(valueFormatter ? extend({ valueFormatter }, frag) : frag, markupStyleCreator, renderMode, orderMode, ecModel.get("useUTC"), tooltipModel.get("textStyle")) : seriesTooltipResult.text;
		var asyncTicket = "item_" + dataModel.name + "_" + dataIndex;
		this._showOrMove(tooltipModel, function() {
			this._showTooltipContent(tooltipModel, markupText, params, asyncTicket, e$1.offsetX, e$1.offsetY, e$1.position, e$1.target, markupStyleCreator);
		});
		dispatchAction({
			type: "showTip",
			dataIndexInside: dataIndex,
			dataIndex: data.getRawIndex(dataIndex),
			seriesIndex,
			from: this.uid
		});
	};
	TooltipView$1.prototype._showComponentItemTooltip = function(e$1, el, dispatchAction) {
		var isHTMLRenderMode = this._renderMode === "html";
		var ecData = getECData(el);
		var tooltipConfig = ecData.tooltipConfig;
		var tooltipOpt = tooltipConfig.option || {};
		var encodeHTMLContent = tooltipOpt.encodeHTMLContent;
		if (isString(tooltipOpt)) {
			var content = tooltipOpt;
			tooltipOpt = {
				content,
				formatter: content
			};
			encodeHTMLContent = true;
		}
		if (encodeHTMLContent && isHTMLRenderMode && tooltipOpt.content) {
			tooltipOpt = clone$2(tooltipOpt);
			tooltipOpt.content = encodeHTML(tooltipOpt.content);
		}
		var tooltipModelCascade = [tooltipOpt];
		var cmpt = this._ecModel.getComponent(ecData.componentMainType, ecData.componentIndex);
		if (cmpt) tooltipModelCascade.push(cmpt);
		tooltipModelCascade.push({ formatter: tooltipOpt.content });
		var positionDefault = e$1.positionDefault;
		var subTooltipModel = buildTooltipModel(tooltipModelCascade, this._tooltipModel, positionDefault ? { position: positionDefault } : null);
		var defaultHtml = subTooltipModel.get("content");
		var asyncTicket = Math.random() + "";
		var markupStyleCreator = new TooltipMarkupStyleCreator();
		this._showOrMove(subTooltipModel, function() {
			var formatterParams = clone$2(subTooltipModel.get("formatterParams") || {});
			this._showTooltipContent(subTooltipModel, defaultHtml, formatterParams, asyncTicket, e$1.offsetX, e$1.offsetY, e$1.position, el, markupStyleCreator);
		});
		dispatchAction({
			type: "showTip",
			from: this.uid
		});
	};
	TooltipView$1.prototype._showTooltipContent = function(tooltipModel, defaultHtml, params, asyncTicket, x, y, positionExpr, el, markupStyleCreator) {
		this._ticket = "";
		if (!tooltipModel.get("showContent") || !tooltipModel.get("show")) return;
		var tooltipContent = this._tooltipContent;
		tooltipContent.setEnterable(tooltipModel.get("enterable"));
		var formatter = tooltipModel.get("formatter");
		positionExpr = positionExpr || tooltipModel.get("position");
		var html = defaultHtml;
		var nearPoint = this._getNearestPoint([x, y], params, tooltipModel.get("trigger"), tooltipModel.get("borderColor"));
		var nearPointColor = nearPoint.color;
		if (formatter) if (isString(formatter)) {
			var useUTC = tooltipModel.ecModel.get("useUTC");
			var params0 = isArray(params) ? params[0] : params;
			var isTimeAxis = params0 && params0.axisType && params0.axisType.indexOf("time") >= 0;
			html = formatter;
			if (isTimeAxis) html = format(params0.axisValue, html, useUTC);
			html = formatTpl(html, params, true);
		} else if (isFunction(formatter)) {
			var callback = bind$1(function(cbTicket, html$1) {
				if (cbTicket === this._ticket) {
					tooltipContent.setContent(html$1, markupStyleCreator, tooltipModel, nearPointColor, positionExpr);
					this._updatePosition(tooltipModel, positionExpr, x, y, tooltipContent, params, el);
				}
			}, this);
			this._ticket = asyncTicket;
			html = formatter(params, asyncTicket, callback);
		} else html = formatter;
		tooltipContent.setContent(html, markupStyleCreator, tooltipModel, nearPointColor, positionExpr);
		tooltipContent.show(tooltipModel, nearPointColor);
		this._updatePosition(tooltipModel, positionExpr, x, y, tooltipContent, params, el);
	};
	TooltipView$1.prototype._getNearestPoint = function(point, tooltipDataParams, trigger, borderColor) {
		if (trigger === "axis" || isArray(tooltipDataParams)) return { color: borderColor || (this._renderMode === "html" ? "#fff" : "none") };
		if (!isArray(tooltipDataParams)) return { color: borderColor || tooltipDataParams.color || tooltipDataParams.borderColor };
	};
	TooltipView$1.prototype._updatePosition = function(tooltipModel, positionExpr, x, y, content, params, el) {
		var viewWidth = this._api.getWidth();
		var viewHeight = this._api.getHeight();
		positionExpr = positionExpr || tooltipModel.get("position");
		var contentSize = content.getSize();
		var align = tooltipModel.get("align");
		var vAlign = tooltipModel.get("verticalAlign");
		var rect = el && el.getBoundingRect().clone();
		el && rect.applyTransform(el.transform);
		if (isFunction(positionExpr)) positionExpr = positionExpr([x, y], params, content.el, rect, {
			viewSize: [viewWidth, viewHeight],
			contentSize: contentSize.slice()
		});
		if (isArray(positionExpr)) {
			x = parsePercent(positionExpr[0], viewWidth);
			y = parsePercent(positionExpr[1], viewHeight);
		} else if (isObject$2(positionExpr)) {
			var boxLayoutPosition = positionExpr;
			boxLayoutPosition.width = contentSize[0];
			boxLayoutPosition.height = contentSize[1];
			var layoutRect = getLayoutRect(boxLayoutPosition, {
				width: viewWidth,
				height: viewHeight
			});
			x = layoutRect.x;
			y = layoutRect.y;
			align = null;
			vAlign = null;
		} else if (isString(positionExpr) && el) {
			var pos = calcTooltipPosition(positionExpr, rect, contentSize, tooltipModel.get("borderWidth"));
			x = pos[0];
			y = pos[1];
		} else {
			var pos = refixTooltipPosition(x, y, content, viewWidth, viewHeight, align ? null : 20, vAlign ? null : 20);
			x = pos[0];
			y = pos[1];
		}
		align && (x -= isCenterAlign(align) ? contentSize[0] / 2 : align === "right" ? contentSize[0] : 0);
		vAlign && (y -= isCenterAlign(vAlign) ? contentSize[1] / 2 : vAlign === "bottom" ? contentSize[1] : 0);
		if (shouldTooltipConfine(tooltipModel)) {
			var pos = confineTooltipPosition(x, y, content, viewWidth, viewHeight);
			x = pos[0];
			y = pos[1];
		}
		content.moveTo(x, y);
	};
	TooltipView$1.prototype._updateContentNotChangedOnAxis = function(dataByCoordSys, cbParamsList) {
		var lastCoordSys = this._lastDataByCoordSys;
		var lastCbParamsList = this._cbParamsList;
		var contentNotChanged = !!lastCoordSys && lastCoordSys.length === dataByCoordSys.length;
		contentNotChanged && each$4(lastCoordSys, function(lastItemCoordSys, indexCoordSys) {
			var lastDataByAxis = lastItemCoordSys.dataByAxis || [];
			var thisItemCoordSys = dataByCoordSys[indexCoordSys] || {};
			var thisDataByAxis = thisItemCoordSys.dataByAxis || [];
			contentNotChanged = contentNotChanged && lastDataByAxis.length === thisDataByAxis.length;
			contentNotChanged && each$4(lastDataByAxis, function(lastItem, indexAxis) {
				var thisItem = thisDataByAxis[indexAxis] || {};
				var lastIndices = lastItem.seriesDataIndices || [];
				var newIndices = thisItem.seriesDataIndices || [];
				contentNotChanged = contentNotChanged && lastItem.value === thisItem.value && lastItem.axisType === thisItem.axisType && lastItem.axisId === thisItem.axisId && lastIndices.length === newIndices.length;
				contentNotChanged && each$4(lastIndices, function(lastIdxItem, j) {
					var newIdxItem = newIndices[j];
					contentNotChanged = contentNotChanged && lastIdxItem.seriesIndex === newIdxItem.seriesIndex && lastIdxItem.dataIndex === newIdxItem.dataIndex;
				});
				lastCbParamsList && each$4(lastItem.seriesDataIndices, function(idxItem) {
					var seriesIdx = idxItem.seriesIndex;
					var cbParams = cbParamsList[seriesIdx];
					var lastCbParams = lastCbParamsList[seriesIdx];
					if (cbParams && lastCbParams && lastCbParams.data !== cbParams.data) contentNotChanged = false;
				});
			});
		});
		this._lastDataByCoordSys = dataByCoordSys;
		this._cbParamsList = cbParamsList;
		return !!contentNotChanged;
	};
	TooltipView$1.prototype._hide = function(dispatchAction) {
		this._lastDataByCoordSys = null;
		dispatchAction({
			type: "hideTip",
			from: this.uid
		});
	};
	TooltipView$1.prototype.dispose = function(ecModel, api) {
		if (env_default.node || !api.getDom()) return;
		clear(this, "_updatePosition");
		this._tooltipContent.dispose();
		unregister("itemTooltip", api);
	};
	TooltipView$1.type = "tooltip";
	return TooltipView$1;
}(Component_default);
/**

* From top to bottom. (the last one should be globalTooltipModel);

*/
function buildTooltipModel(modelCascade, globalTooltipModel, defaultTooltipOption) {
	var ecModel = globalTooltipModel.ecModel;
	var resultModel;
	if (defaultTooltipOption) {
		resultModel = new Model_default(defaultTooltipOption, ecModel, ecModel);
		resultModel = new Model_default(globalTooltipModel.option, resultModel, ecModel);
	} else resultModel = globalTooltipModel;
	for (var i = modelCascade.length - 1; i >= 0; i--) {
		var tooltipOpt = modelCascade[i];
		if (tooltipOpt) {
			if (tooltipOpt instanceof Model_default) tooltipOpt = tooltipOpt.get("tooltip", true);
			if (isString(tooltipOpt)) tooltipOpt = { formatter: tooltipOpt };
			if (tooltipOpt) resultModel = new Model_default(tooltipOpt, resultModel, ecModel);
		}
	}
	return resultModel;
}
function makeDispatchAction(payload, api) {
	return payload.dispatchAction || bind$1(api.dispatchAction, api);
}
function refixTooltipPosition(x, y, content, viewWidth, viewHeight, gapH, gapV) {
	var size = content.getSize();
	var width = size[0];
	var height = size[1];
	if (gapH != null) if (x + width + gapH + 2 > viewWidth) x -= width + gapH;
	else x += gapH;
	if (gapV != null) if (y + height + gapV > viewHeight) y -= height + gapV;
	else y += gapV;
	return [x, y];
}
function confineTooltipPosition(x, y, content, viewWidth, viewHeight) {
	var size = content.getSize();
	var width = size[0];
	var height = size[1];
	x = Math.min(x + width, viewWidth) - width;
	y = Math.min(y + height, viewHeight) - height;
	x = Math.max(x, 0);
	y = Math.max(y, 0);
	return [x, y];
}
function calcTooltipPosition(position, rect, contentSize, borderWidth) {
	var domWidth = contentSize[0];
	var domHeight = contentSize[1];
	var offset = Math.ceil(Math.SQRT2 * borderWidth) + 8;
	var x = 0;
	var y = 0;
	var rectWidth = rect.width;
	var rectHeight = rect.height;
	switch (position) {
		case "inside":
			x = rect.x + rectWidth / 2 - domWidth / 2;
			y = rect.y + rectHeight / 2 - domHeight / 2;
			break;
		case "top":
			x = rect.x + rectWidth / 2 - domWidth / 2;
			y = rect.y - domHeight - offset;
			break;
		case "bottom":
			x = rect.x + rectWidth / 2 - domWidth / 2;
			y = rect.y + rectHeight + offset;
			break;
		case "left":
			x = rect.x - domWidth - offset;
			y = rect.y + rectHeight / 2 - domHeight / 2;
			break;
		case "right":
			x = rect.x + rectWidth + offset;
			y = rect.y + rectHeight / 2 - domHeight / 2;
	}
	return [x, y];
}
function isCenterAlign(align) {
	return align === "center" || align === "middle";
}
/**

* Find target component by payload like:

* ```js

* { legendId: 'some_id', name: 'xxx' }

* { toolboxIndex: 1, name: 'xxx' }

* { geoName: 'some_name', name: 'xxx' }

* ```

* PENDING: at present only

*

* If not found, return null/undefined.

*/
function findComponentReference(payload, ecModel, api) {
	var queryOptionMap = preParseFinder(payload).queryOptionMap;
	var componentMainType = queryOptionMap.keys()[0];
	if (!componentMainType || componentMainType === "series") return;
	var queryResult = queryReferringComponents(ecModel, componentMainType, queryOptionMap.get(componentMainType), {
		useDefault: false,
		enableAll: false,
		enableNone: false
	});
	var model = queryResult.models[0];
	if (!model) return;
	var view = api.getViewOfComponentModel(model);
	var el;
	view.group.traverse(function(subEl) {
		var tooltipConfig = getECData(subEl).tooltipConfig;
		if (tooltipConfig && tooltipConfig.name === payload.name) {
			el = subEl;
			return true;
		}
	});
	if (el) return {
		componentMainType,
		componentIndex: model.componentIndex,
		el
	};
}
var TooltipView_default = TooltipView;
function install$5(registers) {
	use(install$7);
	registers.registerComponentModel(TooltipModel_default);
	registers.registerComponentView(TooltipView_default);
	/**
	
	* @action
	
	* @property {string} type
	
	* @property {number} seriesIndex
	
	* @property {number} dataIndex
	
	* @property {number} [x]
	
	* @property {number} [y]
	
	*/
	registers.registerAction({
		type: "showTip",
		event: "showTip",
		update: "tooltip:manuallyShowTip"
	}, noop);
	registers.registerAction({
		type: "hideTip",
		event: "hideTip",
		update: "tooltip:manuallyHideTip"
	}, noop);
}
var TitleModel = function(_super) {
	__extends(TitleModel$1, _super);
	function TitleModel$1() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.type = TitleModel$1.type;
		_this.layoutMode = {
			type: "box",
			ignoreSize: true
		};
		return _this;
	}
	TitleModel$1.type = "title";
	TitleModel$1.defaultOption = {
		z: 6,
		show: true,
		text: "",
		target: "blank",
		subte