import type { QRCodeErrorCorrectionLevel, QRCodeMaskPattern, QRCodeSegment, QRCodeToDataURLOptions, QRCodeToDataURLOptionsJpegWebp, QRCodeToSJISFunc } from 'qrcode';
import { type PropType } from 'vue';
export declare const LEVELS: readonly ["low", "medium", "quartile", "high", "L", "M", "Q", "H"];
export declare const MASK_PATTERNS: readonly [0, 1, 2, 3, 4, 5, 6, 7];
export declare const MODES: readonly ["alphanumeric", "numeric", "kanji", "byte"];
export type { QRCodeSegment } from 'qrcode';
export type QRCodeValue = QRCodeSegment[] | string;
export declare const TYPES: readonly ["image/png", "image/jpeg", "image/webp"];
export type QRCodeProps = Omit<QRCodeToDataURLOptions, 'renderOptions'> & QRCodeToDataURLOptionsJpegWebp['rendererOpts'] & {
    value: QRCodeValue;
};
declare const _default: import("vue").DefineComponent<{
    version: {
        type: NumberConstructor;
        validator: (version: number) => boolean;
    };
    errorCorrectionLevel: {
        type: PropType<QRCodeErrorCorrectionLevel>;
        validator: (level: QRCodeErrorCorrectionLevel) => boolean;
    };
    maskPattern: {
        type: PropType<QRCodeMaskPattern>;
        validator: (maskPattern: QRCodeMaskPattern) => boolean;
    };
    toSJISFunc: PropType<QRCodeToSJISFunc>;
    margin: NumberConstructor;
    scale: NumberConstructor;
    width: NumberConstructor;
    color: {
        type: ObjectConstructor;
        validator: (color: QRCodeProps['color']) => boolean;
        required: true;
    };
    type: {
        type: PropType<"image/png" | "image/jpeg" | "image/webp" | undefined>;
        validator: (type: QRCodeProps['type']) => boolean;
        required: true;
    };
    quality: {
        type: NumberConstructor;
        validator: (quality: number) => boolean;
        required: false;
    };
    value: {
        type: PropType<QRCodeValue>;
        required: true;
        validator(value: QRCodeValue): boolean;
    };
}, () => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    version: {
        type: NumberConstructor;
        validator: (version: number) => boolean;
    };
    errorCorrectionLevel: {
        type: PropType<QRCodeErrorCorrectionLevel>;
        validator: (level: QRCodeErrorCorrectionLevel) => boolean;
    };
    maskPattern: {
        type: PropType<QRCodeMaskPattern>;
        validator: (maskPattern: QRCodeMaskPattern) => boolean;
    };
    toSJISFunc: PropType<QRCodeToSJISFunc>;
    margin: NumberConstructor;
    scale: NumberConstructor;
    width: NumberConstructor;
    color: {
        type: ObjectConstructor;
        validator: (color: QRCodeProps['color']) => boolean;
        required: true;
    };
    type: {
        type: PropType<"image/png" | "image/jpeg" | "image/webp" | undefined>;
        validator: (type: QRCodeProps['type']) => boolean;
        required: true;
    };
    quality: {
        type: NumberConstructor;
        validator: (quality: number) => boolean;
        required: false;
    };
    value: {
        type: PropType<QRCodeValue>;
        required: true;
        validator(value: QRCodeValue): boolean;
    };
}>>, {}, {}>;
export default _default;
