import { defineAsyncComponent } from 'vue'

const ShortCode = defineAsyncComponent(() => import('@/components/favourite/ShortCode.vue'))
const FavouriteUserList = defineAsyncComponent(() => import('@/components/favourite/UserList.vue'))

export default defineNuxtPlugin((nuxtApp)=> {

    const global=nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList('user-panel:menus',[
        {
            title:'لیست ها',
            icon:['far', 'heart'],
            route:'/profile/lists',
            index:6
        }
    ]);

    global.$addArrayList('profile:quick-access',[{
        index:15,
        title:'لیست ها',
        icon:['far','heart'],
        route:'/profile/lists'
    }]);

   global.$addArrayList('product:page-options',[
        {
            index:0,
            component:ShortCode
        }
    ]);

    global.$addArrayList('user:lists',[
        {
            title:"علاقه مندی ها",
            index:0,
            component:FavouriteUserList
        }
    ]);
});