import {defineAsyncComponent} from "vue";

const FiltersColors = defineAsyncComponent(() => import('@/components/filters/Colors.vue'));
const FiltersPriceRange = defineAsyncComponent(() => import('@/components/filters/PriceRange.vue'));
const FiltersReadySend = defineAsyncComponent(() => import('@/components/filters/ReadySend.vue'));
const FiltersHasAvailable = defineAsyncComponent(() => import('@/components/filters/HasAvailable.vue'));

export default defineNuxtPlugin((nuxtApp)=> {
    const global= nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('filters:options', [
        {
            title:'رنگ ها',
            component:FiltersColors,
            index:0,
            param:'colors',
            whereAdd:(category_id:number)=>{
                return category_id!=0;
            }
        },
        {
            title:'محدوده قیمت',
            component:FiltersPriceRange,
            index:1,
            param:'price'
        },
        {
            title:'فقط کالاهای موجود',
            component:FiltersHasAvailable,
            index:3,
            param:'has-available',
            child:false
        },
        {
            title:'فقط کالاهای آماده ارسال',
            component:FiltersReadySend,
            index:3,
            param:'has-selling-stock',
            child:false
        },
    ]);
});