import { defineAsyncComponent } from 'vue'

const MethodSelection = defineAsyncComponent(() => import('@/components/finance/MethodSelection.vue'))
const AddBankAccount = defineAsyncComponent(() => import('@/components/finance/AddBankAccount.vue'))

export default defineNuxtPlugin((nuxtApp:any)=>{

    const global=nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList('money:returning-methods',[
        {
            title:"واریز به حساب بانکی",
            component:MethodSelection,
            name:'bank-account',
        }
    ]);

    global.$addArrayList('app:main-content',[
        AddBankAccount
    ]);
});