import { defineAsyncComponent } from 'vue'

const onlinePaymentSelection = defineAsyncComponent(() => import('@/components/online-payment/selection.vue'))
export default defineNuxtPlugin((nuxtApp)=> {
    const global = nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('payment:methods',[
        {
            name:'online-payment',
            title:'پرداخت آنلاین',
            event:'request-online-payment',
            component:onlinePaymentSelection,
            index:1
        }
    ]);
});