import useOrderStatusesList from '@/functions/order-statuses-list'
import { defineAsyncComponent } from 'vue'

const OrdersUserFactorLink = defineAsyncComponent(() => import('@/components/orders/user/FactorLink.vue'))
const CheckoutBottomNavigation = defineAsyncComponent(() => import('@/components/orders/checkout/BottomNavigation.vue'))
const OrderStatistics = defineAsyncComponent(() => import('~/components/orders/user/OrderStatistics.vue'))

export default defineNuxtPlugin((nuxtApp)=> {
    const global=nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList('user-panel:menus',[
        {
            title:'سفارش ها',
            icon:['fas', 'bag-shopping'],
            route:'/profile/orders',
            index:1
        }
    ]);

    nuxtApp.vueApp.component(
        'user-order-statistics',
        OrderStatistics
    );
    global.$addArrayList('user-profile',[{
        component:OrderStatistics,
        index:0
    }])

    nuxtApp.vueApp.component('OrdersUserFactorLink',OrdersUserFactorLink);

    global.$addArrayList('order:statutes',useOrderStatusesList());

    global.$addArrayList('profile:quick-access',[{
        index:0,
        title:'سفارش ها',
        icon:['fas','fa-bag-shopping'],
        route:'/profile/orders'
    }]);

    nuxtApp.vueApp.component(
        'CheckoutBottomNavigation',
        CheckoutBottomNavigation
    );


    global.$addArrayList('orders:payment-methods',[
        {
            title:"پرداخت آنلاین",
            value:'online-payment'
        }
    ]);
});
