import { defineAsyncComponent } from 'vue'

const IncredibleOffersAppBar = defineAsyncComponent(() => import('@/components/promotions/IncredibleOffersAppBar.vue'))
const ProductFooter = defineAsyncComponent(() => import('~/components/promotions/ProductFooter.vue'))
const ShortCode = defineAsyncComponent(() => import('~/components/promotions/ShortCode.vue'))
const AmazingOffers = defineAsyncComponent(() => import('@/components/promotions/AmazingOffers.vue'))
const ShowProductAdsLabel = defineAsyncComponent(() => import('~/components/ads/ShowProductAdsLabel.vue'))
const DisplayOfferLabel = defineAsyncComponent(() => import('~/components/promotions/DisplayOfferLabel.vue'))

export default defineNuxtPlugin((nuxtApp)=> {
    const global=nuxtApp.vueApp.config.globalProperties;
    nuxtApp.vueApp.component('IncredibleOffersAppBar',IncredibleOffersAppBar);
    global.$addArrayList('product-view:footer',[
        ProductFooter
    ]);

    nuxtApp.vueApp.config.globalProperties.$addArrayList('product:page-options',[
        {
            index:2,
            component:ShortCode
        }
    ]);

    nuxtApp.vueApp.component('ImportantAmazing',AmazingOffers);

    global.$addArrayList('product-search-view:before-view',[
        {
            component:DisplayOfferLabel,
            index:-1
        }
    ]);
});