import { defineAsyncComponent } from 'vue'

const ProductPage = defineAsyncComponent(() => import('@/components/questions/ProductPage.vue'))
const ProfileQuestions = defineAsyncComponent(() => import('@/components/questions/user/List.vue'))

export default defineNuxtPlugin((nuxtApp)=> {
    const global = nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('product:page-content', [
        {
            title: 'پرسش ها',
            component:ProductPage,
            key: 4,
            name:'questions',
        }
    ]);

    global.$addArrayList('profile:comments-tabs',[{
        title:"پرسش ها",
        key:15,
        component:ProfileQuestions
    }]);
});
