import { defineAsyncComponent } from 'vue'

const MethodSelection = defineAsyncComponent(() => import('@/components/wallet/MethodSelection.vue'))
const Balance = defineAsyncComponent(() => import('~/components/wallet/Balance.vue'))
const WalletPaymentForOrder = defineAsyncComponent(() => import('~/components/wallet/WalletPaymentForOrder.vue'))

export default defineNuxtPlugin((nuxtApp:any)=>{

    const global=nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList('money:returning-methods',[
        {
            title:"کیف پول",
            description:'شما می‌توانید با انتخاب کیف پول به عنوان روش بازگشت وجه، از مزایای انتقال سریع تر وجوه درخواستی بهره‌مند شوید.',
            component:MethodSelection,
            name:'wallet'
        }
    ]);

    global.$addArrayList('user-panel:before-menus',[
        Balance
    ]);

    global.$addArrayList('payment:methods',[
        {
            name:'wallet-payment',
            title:'پرداخت از طریق کیف پول',
            event:'request-wallet-payment',
            component:WalletPaymentForOrder,
            index:2
        }
    ]);

    global.$addArrayList('orders:payment-methods',[
        {
            title:"کسر از کیف پول",
            value:'wallet-payment'
        }
    ]);
});