export default defineEventHandler((event) => {

    const userAgent = getHeader(event, 'user-agent') || '';
    const bots = [
        'Googlebot', 'Bingbot', 'Slurp', 'DuckDuckBot', 'Baiduspider', 'YandexBot',
        'Telegram',
        'WhatsApp',
        'TelegramBot'
    ];

    const isBot = bots.some(bot => userAgent.includes(bot));
    event.context.nuxt = event.context.nuxt || {}
    event.context.nuxt.noSSR  = !isBot;
});
