export const addressStore=defineStore('address',()=>{

    const addresses=ref<Record<string, any>[]>([]);
    const loading=ref<boolean>(false);
    const formBox=ref<any>(null);
    const step=ref(1);
    const addressId=ref(0);
    const searchText=ref<string|null>('');
    const searchLoading=ref<boolean>(false);
    const apiKey:string="eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImp0aSI6IjY0Y2IyY2FhOTUyZGI0NjUzZmZjZWI2MmIyNmFmODUwYWI4NWY2YTM3M2FiNDUzMzc0YTdiN2MzNWNlNDE3OWM3ZThiMGVlMzVkOGEyZWE1In0.eyJhdWQiOiIxOTY4MSIsImp0aSI6IjY0Y2IyY2FhOTUyZGI0NjUzZmZjZWI2MmIyNmFmODUwYWI4NWY2YTM3M2FiNDUzMzc0YTdiN2MzNWNlNDE3OWM3ZThiMGVlMzVkOGEyZWE1IiwiaWF0IjoxNjY1NTA1MDQzLCJuYmYiOjE2NjU1MDUwNDMsImV4cCI6MTY2ODAxMDY0Mywic3ViIjoiIiwic2NvcGVzIjpbImJhc2ljIl19.j8Ot6KjU-3QzKwid1nIsFTpY_X8ghbmVPgE0X_lzqbyYqpgfyJRvou5glbFZm1fitJTijEncAesYK7ydYBjSlbcFpbU0CnMpl1XrcF2gHjXz5DFYh7onL9KH4baQBnzGuNZkatj4p602_9MgBMK_nQCiWiuGl7rLm7cYVwgtsu3XOdksVjx0Rt-NS4LA2czAFy54nTbSM94H6y_beZ5LWkf5kIIX-vqdwELR-T-A1xKQG5T3Sv-9A4w7UXzqQs7dfuV6K_chQ1NahaqtfsGOqduk9KvsCNw9kQf6m1BWMpqCQFtE9Zgi_VcRnWifpcLLm9WmxRPfveOflLpNbUnmeA";
    const searchAddresses=ref<Record<string, any>[]|null>([]);
    const location=ref<number[]>([ 38.0718603 , 46.2842501 ]);
    const formData=ref<Record<string, any>>({});
    const {api}=useRuntimeConfig().public;
    const {$axios}=useNuxtApp();
    const getAddresses=()=>{
        if(!loading.value){
            loading.value=true;
            $axios.get(api+'/user/addresses').then((response)=>{
                loading.value=false;
                addresses.value=response.data;
            }).catch(()=>{
                loading.value=false;
            });
        }
    };
    const showCreateForm=function (){
        step.value=1;
        formBox.value!.show();
    }

    const showEditForm=(id:number)=>{
        step.value=1;
        addressId.value=id;
        const address=addresses.value.find((address)=>address.id==id);
        if(address){
            const selectedAddress:Record<string, any>={...{},...address};
            delete address.id;
            formData.value=selectedAddress;
            location.value=[
                selectedAddress.latitude,
                selectedAddress.longitude,
            ];

        }
        nextTick(()=>{
            formBox.value!.show();
        });
    }

    const searchLocation=async function (){
        searchLoading.value=true;
        const {data:result,error} =await useFetch<Record<string, any>>(
            "https://map.ir/search/v2/autocomplete?text="+searchText.value+'&x-api-key='+apiKey+'&select=City,Region,Neighborhood'
        );
        searchLoading.value=false;
        if(error.value==null){
            searchAddresses.value=result.value!.value;
        }
    }

    const selectAddressLocation=function (data:{[p:string]:any}){
        if(data.geom!==undefined){
            searchText.value='';
            searchAddresses.value=[];
            location.value=[
                data.geom.coordinates[1],
                data.geom.coordinates[0]
            ];
        }
    }

    const removeAddress=(id:number)=>{
        $axios.delete(api+'/user/address/'+id).then((response:{data:Record<string, any>})=>{
            if(response.data.status=='ok'){
                const index=addresses.value.findIndex((address)=>address.id==id);
                if(index>=0){
                    addresses.value.splice(index,1);
                }
            }
        })
    }

    const updateStep=(value:number)=>{
        step.value=value;
    }

    return {
        searchLoading,
        searchAddresses,
        step,
        location,
        searchText,
        addressId,
        formBox,
        loading,
        addresses,
        formData,
        apiKey,
        updateStep,
        removeAddress,
        selectAddressLocation,
        searchLocation,
        showCreateForm,
        showEditForm,
        getAddresses
    }
});