import {defineStore} from "pinia";
import {searchStore} from "~/stores/search-products";

export const useProductsAdsStore = defineStore('productsAdsStore', (ProductsAdsStore) => {

    const searchState=searchStore();

    const ads=ref<{
        search_list?:Record<string, any>[],
        sidebar?:Record<string, any>[]
    }>({});

    const {api}=useRuntimeConfig().public;
    const {$axios}=useNuxtApp();

    const getAds=(category:Record<string, any>)=>{
        $axios.get(api+'/ads/search/products/'+category.id)
            .then((response:{data:Record<string, any>})=>{
                ads.value=response.data;
                updateProductsList();
            });
    }

    const updateProductsList=()=>{
        if(searchState.page==1 && ads.value.search_list){
            if( searchState.result &&
                searchState.result.products &&
                searchState.result.products.data.length>0 &&
                ads.value.search_list?.length>0
            ){
                const original = [...searchState.result.products.data];
                const firstTwo = original.slice(0, 2);
                const merged = [
                    ...firstTwo,
                    ...ads.value.search_list!,
                    ...original.slice(2)
                ];
                searchState.updateResult({
                    ...searchState.result,
                    products: {
                        ...searchState.result.products,
                        data: merged
                    }
                });
            }
        }
    }

    const clearAds=()=>{
        ads.value={
            search_list:[],
            sidebar:[]
        }
    }

    return{
        getAds,
        updateProductsList,
        clearAds,
        ads
    }
});