export const cartStore=defineStore('cart',()=>{

    const sendRequest=ref<{[p:number]:boolean}>({});
    const transferRequest=ref<Record<string, any>>({});
    const cartData=ref<{[p:string]:any}>({});
    const tab=ref<number>(0);
    const cartStorage=ref<Record<string,number>>({});
    const user=useState('user');
    const shopSetting=useState<{[p:string]:string}>('shopSetting');
    const getCartData=()=>{
        if(!sendRequest.value[0]){
            sendRequest.value[0]=true;
            if(Object.keys(cartStorage.value).length==0 && localStorage.getItem('cart')){
                cartStorage.value=JSON.parse(localStorage.getItem('cart')!)
            }
            useNuxtApp().$axios.post(
                useRuntimeConfig().public.api+'/cart',
                {
                    cart:cartStorage.value
                }
            ).then((response:Record<string, any>)=>{
                cartData.value=response.data;
                if(cartData.value && cartData.value.current){
                    cartData.value.current.products.forEach((product:Record<string, any>)=>{
                        updateCartStorage(product.variation.id,product.count);
                    });
                }
                sendRequest.value[0]=false;
                if(user.value && user.value!='loading'){
                    cartStorage.value={};
                    localStorage.removeItem('cart');
                }
            }).catch(()=>{
                sendRequest.value[0]=false;
            });
        }
    };

    const updateCartCount=(variationId:number,count:number)=>{
        sendRequest.value[variationId]=true;
        useNuxtApp().$axios.post(
            useRuntimeConfig().public.api+'/cart/add-product',
            {
                variationId:variationId,
                count:count
            }
        ).then((response:{data:{[p:string]:string}})=>{
            if(response.data.status=='ok'){
                updateCartStorage(variationId,count);
                getCartData();
            }
            sendRequest.value[variationId]=false;
        }).catch(()=>{
            sendRequest.value[variationId]=false;
        });
    }

    const removeFromCart=(variationId:number)=>{
        if(user.value){
            sendRequest.value[variationId]=true;
            useNuxtApp().$axios.post(
                useRuntimeConfig().public.api+'/cart/remove-product',
                {variationId:variationId}
            ).then(()=>{
                sendRequest.value[variationId]=false;
                removeVariationFromCartStorage(variationId);
                getCartData();
            }).catch(()=>{
                sendRequest.value[variationId]=false;
            })
        }
        else{
            removeVariationFromCartStorage(variationId);
            getCartData();
        }
    }

    const taxes=()=>{
        let orderTaxes=0;
        if(parseInt(shopSetting.value.taxes)>0){
            let price=0;
            const products=cartData.value['current'].products;
            for (let i = 0; i <products.length ; i++) {
                price+=(products[i].variation.price2* products[i].count);
            }
            orderTaxes=parseInt(
                ((price*parseInt(shopSetting.value.taxes))/100).toString()
            );
        }
        return orderTaxes;
    }

    const taxPercentage=():number=>{
        return parseInt(shopSetting.value.taxes)>0 ?
               parseInt(shopSetting.value.taxes) : 0;
    }

    const getFinalCartPrice=(type:string='current')=>{
        let price=0;
        const products=cartData.value[type].products;
        for (let i = 0; i <products.length ; i++) {
            price+=(products[i].variation.price2* products[i].count);
        }
        return price;
    }

    const getTotalCartPrice=(type:string='current')=>{
        let price=0;
        const products=cartData.value[type].products;
        for (let i = 0; i <products.length ; i++) {
            price+=(products[i].variation.price1* products[i].count);
        }
        return price;
    }

    const addProductToCart=async (variation:Record<string, any>,added:()=>void)=>{
        await useNuxtApp().$axios.get(useRuntimeConfig().public.serverUrl
            +'/sanctum/csrf-cookie');
        useNuxtApp().$axios.post(
            useRuntimeConfig().public.api+'/cart/add-product',
            {
                variationId:variation.id,
                count:1
            }
        ).then((response:{data:Record<string, any>})=>{
            if(response.data.status=='ok'){
                updateCartStorage(variation.id,1);
                getCartData();
                added();
            }
        })
    }

    const updateCartStorage=(variationId:number,count:number)=>{
        if(!user.value){
            cartStorage.value[variationId]=count;
            localStorage.setItem('cart',
                JSON.stringify(cartStorage.value)
            );
        }
    }

    const removeVariationFromCartStorage=function (variationId:number){
        if(!user.value){
            delete cartStorage.value[variationId];
            localStorage.setItem('cart',
                JSON.stringify(cartStorage.value)
            );
        }
    }

    const getProductsCount=(type:string)=>{
        return cartData.value[type] ? cartData.value[type].products.length : 0;
    }

    const transferProduct=(variationId:number,type:string='next')=>{
        if(user.value){
            transferRequest.value[variationId]=true;
            const url= useRuntimeConfig().public.api+'/cart/products/add-'+type+'-cart';
            useNuxtApp().$axios.post(url,{
                variationId:variationId
            }).then((response:{data:{status:string}})=>{
                if(response.data.status=='ok'){
                    transferRequest.value[variationId]=false;
                    getCartData();
                }
            }).catch(()=>{
                transferRequest.value[variationId]=false;
            });
        }
        else{
            useRouter().push('/login');
        }
    }

    const transferAllToCurrent=()=>{
        transferRequest.value[0]=true;
        useNuxtApp().$axios.post(
            useRuntimeConfig().public.api+'/cart/move-products',
            {
                from:2,
                to:1
            }
        ).then(()=>{
            transferRequest.value[0]=false;
            getCartData();
        }).catch(()=>{
            transferRequest.value[0]=false;
        });
    }

    return {
        transferRequest,
        sendRequest,
        tab,
        cartData,
        cartStorage,
        transferAllToCurrent,
        taxPercentage,
        taxes,
        transferProduct,
        addProductToCart,
        getFinalCartPrice,
        removeFromCart,
        getTotalCartPrice,
        getProductsCount,
        getCartData,
        updateCartCount
    }
});