export const commentStore=defineStore('comment',()=>{

    const list=ref<Record<string, any>>({data:[]});
    const page=ref(0);
    const loading=ref(false);
    const endLoaded=ref(false);
    const fetch=(productId:number)=>{
        if(!loading.value && !endLoaded.value){
            loading.value=true;
            page.value=page.value+1;
            useNuxtApp().$axios.get(
                useRuntimeConfig().public.api+'/product/'+productId+'/comments?page='+page.value
            ).then((response)=>{
                if(list.value.data.length==0){
                    list.value=response.data;
                }
                else{
                    list.value.data=[...list.value.data,...response.data.data];
                }
                loading.value=false;
                if(response.data.data.length<10){
                    endLoaded.value=true;
                }
            }).catch(()=>{
                loading.value=false;
            })
        }
    }

    const reset=()=>{
        page.value=0;
        endLoaded.value=false;
        list.value={data:[]};
    }

    return {
        list,
        loading,
        reset,
        fetch
    }
});