import { useNuxtApp, useRuntimeConfig, useState } from '#app';
import {ref} from "vue";
interface OrderState {
    loading: Ref<boolean>;
    data: Ref<Record<string, any>>;
    formData: Ref<{ [p: string]: any }>;
    errorInContinue:Ref<Record<string, string>>;
    paymentMethod:Ref<string>,
    itemsDeducted:Ref<Record<string, any>>
}

export const useOrderActions = (state: OrderState) => {

    const {serverUrl,api}=useRuntimeConfig().public;
    const toast=useState('toast');
    const {$axios}=useNuxtApp();

    const getOrderInfo = async (addressId: number) => {
        state.loading.value = true;
        state.errorInContinue.value={};
        const apiUrl =api + '/user/cart/submissions?address_id=' + addressId;
        try {
            const response = await useNuxtApp().$axios.get(apiUrl);
            state.data.value = response.data;
        } catch (error) {
            console.error('Error fetching order info:', error);
        } finally {
            state.loading.value = false;
        }
    };

    const payment = async () => {
        const apiUrl = api + '/user/add-order';
        state.loading.value = true;
        try {
            const response = await $axios.post(apiUrl, state.formData.value);
            if (response.data.status === 'ok') {
                if(parseInt(response.data['paymentId'])>0)
                {
                    window.location.href =
                        serverUrl+'/shop/gateway-connect?paymentId='+response.data['paymentId'];
                }
                else if(parseInt(response.data['paymentId'])==0){
                    useRouter().push('/verify/checkout/'+response.data['order_id']);
                }
            }
        } catch (error) {
            toast.value={
                type:"error",
                message:'خطا در ثبت سفارش مجددا تلاش نمایید'
            }
        } finally {
            state.loading.value = false;
        }
    };


    const changePaymentMethod=(method:string)=>{
        state.paymentMethod.value=method;
    }

    const updateItemsDeducted=(value:Record<string, any>)=>{
        state.itemsDeducted.value=value;
    }

    return {
        getOrderInfo,
        payment,
        changePaymentMethod,
        updateItemsDeducted
    };
};
