import { computed } from 'vue';
import {useNuxtApp, useState} from '#app';

export const useOrderComputed = (data: Ref<Record<string, any>>,itemsDeducted:Record<string, any>) => {

    const global = useNuxtApp().vueApp.config.globalProperties;

    const finalPrice = computed(() => {
        let price = 0;
        const submissions = data.value?.submissions ?? {};

        for (const submission of Object.values(submissions) as Record<string, any>[]) {
            const products = submission.products as Record<string, any>[];
            for (const product of products) {
                price += product.count * product.variation.price2;
            }

            const infoPrice = parseInt(submission.info?.price ?? '0');
            if (infoPrice > 0) {
                price += infoPrice;
            }
        }

        return price;
    });

    const totalPrice = computed(() => {
        let price = 0;
        const submissions = data.value?.submissions ?? {};

        for (const submission of Object.values(submissions) as Record<string, any>[]) {
            const products = submission.products as Record<string, any>[];
            for (const product of products) {
                price += product.count * product.variation.price2;
            }

            // const infoPrice = parseInt(submission.info?.price ?? '0');
            // if (infoPrice > 0) {
            //     price += infoPrice;
            // }
        }

        return price;
    });

    const finalPriceExcludingShipping=computed(()=>{
        let price = 0;
        const submissions = data.value?.submissions ?? {};
        for (const submission of Object.values(submissions) as Record<string, any>[]) {
            const products = submission.products as Record<string, any>[];
            for (const product of products) {
                price += product.count * product.variation.price2;
            }
        }
        return price;
    })

    const totalShippingCost = computed(() => {
        const submissions = data.value?.submissions ?? {};
        let total = 0;
        let hasAfterPrice = false;

        for (const submission of Object.values(submissions) as Record<string, any>[]) {
            const info = submission.info;
            const price = parseInt(info?.price ?? '0');

            if (price > 0) {
                total += price;
            } else if (price === -1) {
                hasAfterPrice = true;
            }
        }

        if (total === 0) {
            return hasAfterPrice ? 'پس کرایه' : 'رایگان';
        }

        return (
            global.$replaceEnNumber(global.$numberFormat(total)) +
            ' تومان' +
            (hasAfterPrice ? ' + پس کرایه' : '')
        );
    });

    const shopSetting = useState<{ [key: string]: string }>('shopSetting');

    const taxes = (): number => {
        const taxPercent = parseInt(shopSetting.value.taxes || '0');
        return taxPercent > 0 ? Math.floor((finalPriceExcludingShipping.value * taxPercent) / 100) : 0;
    };

    const payableAmount=computed(()=>{
        let amount=finalPrice.value+taxes();
        const keys=Object.keys(itemsDeducted.value);
        for (let i = 0; i <keys.length ; i++) {
            amount-=(itemsDeducted.value[keys[i]].value);
        }
        return amount;
    });

    return {
        finalPrice,
        totalPrice,
        totalShippingCost,
        payableAmount,
        taxes
    };
};
