export const questionStore=defineStore('questions',()=>{

    const list=ref<{[p:string]:any}>({data:[]});
    const page=ref(0);
    const loading=ref(false);
    const endLoaded=ref(false);
    const fetch=(productId:number)=>{
        if(!loading.value && !endLoaded.value){
            loading.value=true;
            page.value=page.value+1;
            useNuxtApp().$axios.get(
                useRuntimeConfig().public.api+'/product/'+productId+'/questions?page='+page.value
            ).then((response)=>{
                loading.value=false;
                if(list.value.data.length==0){
                    list.value=response.data;
                }
                else{
                    list.value.data=[...list.value.data,...response.data.data];
                }
                if(response.data.data.length<10){
                    endLoaded.value=true;
                }
            }).catch(()=>{
                loading.value=false;
            })
        }
    }

    return {
        list,
        loading,
        fetch
    }
});